<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Accounts
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Accounts\V1;

use Twilio\Options;
use Twilio\Values;

abstract class MessagingGeopermissionsOptions
{
    /**
     * @param string $countryCode The country code to filter the geo permissions. If provided, only the geo permission for the specified country will be returned.
     * @return FetchMessagingGeopermissionsOptions Options builder
     */
    public static function fetch(
        
        string $countryCode = Values::NONE

    ): FetchMessagingGeopermissionsOptions
    {
        return new FetchMessagingGeopermissionsOptions(
            $countryCode
        );
    }


}

class FetchMessagingGeopermissionsOptions extends Options
    {
    /**
     * @param string $countryCode The country code to filter the geo permissions. If provided, only the geo permission for the specified country will be returned.
     */
    public function __construct(
        
        string $countryCode = Values::NONE

    ) {
        $this->options['countryCode'] = $countryCode;
    }

    /**
     * The country code to filter the geo permissions. If provided, only the geo permission for the specified country will be returned.
     *
     * @param string $countryCode The country code to filter the geo permissions. If provided, only the geo permission for the specified country will be returned.
     * @return $this Fluent Builder
     */
    public function setCountryCode(string $countryCode): self
    {
        $this->options['countryCode'] = $countryCode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Accounts.V1.FetchMessagingGeopermissionsOptions ' . $options . ']';
    }
}


