<?php // phpcs:ignoreFile
namespace Phan\Language\Internal;

/**
 * This contains descriptions used by Phan for hover text of internal functions and methods in the language server mode.
 *
 * Format
 *
 * '<function_name>' => 'documentation',
 *
 * NOTE: This format will very likely change as information is added and should not be used directly.
 *
 * Sources of function/method summary info:
 *
 * 1. docs.php.net's SVN repo or website, and examples (See internal/internalsignatures.php)
 *
 *    See https://secure.php.net/manual/en/copyright.php
 *
 *    The PHP manual text and comments are covered by the [Creative Commons Attribution 3.0 License](http://creativecommons.org/licenses/by/3.0/legalcode),
 *    copyright (c) the PHP Documentation Group
 * 2. Various websites documenting individual extensions (e.g. php-ast)
 * 3. PHPStorm stubs (for anything missing from the above sources)
 *    See internal/internalsignatures.php
 *
 *    Available from https://github.com/JetBrains/phpstorm-stubs under the [Apache 2 license](https://www.apache.org/licenses/LICENSE-2.0)
 *
 * CONTRIBUTING:
 *
 * Running `internal/internalstubs.php` can be used to update signature maps
 *
 * There are no plans for these signatures to diverge from what the above upstream sources contain.
 *
 * - If the descriptions cause Phan to crash, bug reports are welcome
 * - If Phan improperly extracted text from a summary (and this affects multiple signatures), patches fixing the extraction will be accepted.
 * - Otherwise, fixes for typos/grammar/inaccuracies in the summary will only be accepted once they are contributed upstream and can be regenerated (e.g. to the svn repo for docs.php.net).
 *
 *   Note that the summaries are used in a wide variety of contexts, and what makes sense for Phan may not make sense for those projects, and vice versa.
 */
return [
'__halt_compiler' => 'Halts the compiler execution',
'abs' => 'Absolute value',
'acos' => 'Arc cosine',
'acosh' => 'Inverse hyperbolic cosine',
'addcslashes' => 'Quote string with slashes in a C style',
'addslashes' => 'Quote string with slashes',
'AMQPBasicProperties::getAppId' => 'Get the application id of the message.',
'AMQPBasicProperties::getClusterId' => 'Get the cluster id of the message.',
'AMQPBasicProperties::getContentEncoding' => 'Get the content encoding of the message.',
'AMQPBasicProperties::getContentType' => 'Get the message content type.',
'AMQPBasicProperties::getCorrelationId' => 'Get the message correlation id.',
'AMQPBasicProperties::getDeliveryMode' => 'Get the delivery mode of the message.',
'AMQPBasicProperties::getExpiration' => 'Get the expiration of the message.',
'AMQPBasicProperties::getHeaders' => 'Get the headers of the message.',
'AMQPBasicProperties::getMessageId' => 'Get the message id of the message.',
'AMQPBasicProperties::getPriority' => 'Get the priority of the message.',
'AMQPBasicProperties::getReplyTo' => 'Get the reply-to address of the message.',
'AMQPBasicProperties::getTimestamp' => 'Get the timestamp of the message.',
'AMQPBasicProperties::getType' => 'Get the message type.',
'AMQPBasicProperties::getUserId' => 'Get the message user id.',
'AMQPChannel::__construct' => 'Create an instance of an AMQPChannel object.',
'AMQPChannel::basicRecover' => 'Redeliver unacknowledged messages.',
'AMQPChannel::close' => 'Closes the channel.',
'AMQPChannel::commitTransaction' => 'Commit a pending transaction.',
'AMQPChannel::confirmSelect' => 'Set the channel to use publisher acknowledgements. This can only used on a non-transactional channel.',
'AMQPChannel::getChannelId' => 'Return internal channel ID',
'AMQPChannel::getConnection' => 'Get the AMQPConnection object in use',
'AMQPChannel::getConsumers' => 'Return array of current consumers where key is consumer and value is AMQPQueue consumer is running on',
'AMQPChannel::getPrefetchCount' => 'Get the number of messages to prefetch from the broker.',
'AMQPChannel::getPrefetchSize' => 'Get the window size to prefetch from the broker.',
'AMQPChannel::isConnected' => 'Check the channel connection.',
'AMQPChannel::qos' => 'Set the Quality Of Service settings for the given channel.

Specify the amount of data to prefetch in terms of window size (octets)
or number of messages from a queue during a AMQPQueue::consume() or
AMQPQueue::get() method call. The client will prefetch data up to size
octets or count messages from the server, whichever limit is hit first.
Setting either value to 0 will instruct the client to ignore that
particular setting. A call to AMQPChannel::qos() will overwrite any
values set by calling AMQPChannel::setPrefetchSize() and
AMQPChannel::setPrefetchCount(). If the call to either
AMQPQueue::consume() or AMQPQueue::get() is done with the AMQP_AUTOACK
flag set, the client will not do any prefetching of data, regardless of
the QOS settings.',
'AMQPChannel::rollbackTransaction' => 'Rollback a transaction.

Rollback an existing transaction. AMQPChannel::startTransaction() must
be called prior to this.',
'AMQPChannel::setConfirmCallback' => 'Set callback to process basic.ack and basic.nac AMQP server methods (applicable when channel in confirm mode).',
'AMQPChannel::setPrefetchCount' => 'Set the number of messages to prefetch from the broker.

Set the number of messages to prefetch from the broker during a call to
AMQPQueue::consume() or AMQPQueue::get(). Any call to this method will
automatically set the prefetch window size to 0, meaning that the
prefetch window size setting will be ignored.',
'AMQPChannel::setPrefetchSize' => 'Set the window size to prefetch from the broker.

Set the prefetch window size, in octets, during a call to
AMQPQueue::consume() or AMQPQueue::get(). Any call to this method will
automatically set the prefetch message count to 0, meaning that the
prefetch message count setting will be ignored. If the call to either
AMQPQueue::consume() or AMQPQueue::get() is done with the AMQP_AUTOACK
flag set, this setting will be ignored.',
'AMQPChannel::setReturnCallback' => 'Set callback to process basic.return AMQP server method',
'AMQPChannel::startTransaction' => 'Start a transaction.

This method must be called on the given channel prior to calling
AMQPChannel::commitTransaction() or AMQPChannel::rollbackTransaction().',
'AMQPChannel::waitForBasicReturn' => 'Start wait loop for basic.return AMQP server methods',
'AMQPChannel::waitForConfirm' => 'Wait until all messages published since the last call have been either ack\'d or nack\'d by the broker.

Note, this method also catch all basic.return message from server.',
'AMQPConnection::__construct' => 'Create an instance of AMQPConnection.

Creates an AMQPConnection instance representing a connection to an AMQP
broker. A connection will not be established until
AMQPConnection::connect() is called.

 $credentials = array(
     \'host\'  => amqp.host The host to connect too. Note: Max 1024 characters.
     \'port\'  => amqp.port Port on the host.
     \'vhost\' => amqp.vhost The virtual host on the host. Note: Max 128 characters.
     \'login\' => amqp.login The login name to use. Note: Max 128 characters.
     \'password\' => amqp.password Password. Note: Max 128 characters.
     \'read_timeout\'  => Timeout in for income activity. Note: 0 or greater seconds. May be fractional.
     \'write_timeout\' => Timeout in for outcome activity. Note: 0 or greater seconds. May be fractional.
     \'connect_timeout\' => Connection timeout. Note: 0 or greater seconds. May be fractional.

     Connection tuning options (see https://www.rabbitmq.com/amqp-0-9-1-reference.html#connection.tune for details):
     \'channel_max\' => Specifies highest channel number that the server permits. 0 means standard extension limit
                      (see PHP_AMQP_MAX_CHANNELS constant)
     \'frame_max\'   => The largest frame size that the server proposes for the connection, including frame header
                      and end-byte. 0 means standard extension limit (depends on librabbimq default frame size limit)
     \'heartbeat\'   => The delay, in seconds, of the connection heartbeat that the server wants.
                      0 means the server does not want a heartbeat. Note, librabbitmq has limited heartbeat support,
                      which means heartbeats checked only during blocking calls.

     TLS support (see https://www.rabbitmq.com/ssl.html for details):
     \'cacert\' => Path to the CA cert file in PEM format..
     \'cert\'   => Path to the client certificate in PEM format.
     \'key\'    => Path to the client key in PEM format.
     \'verify\' => Enable or disable peer verification. If peer verification is enabled then the common name in the
                 server certificate must match the server name. Peer verification is enabled by default.
)',
'AMQPConnection::connect' => 'Establish a transient connection with the AMQP broker.

This method will initiate a connection with the AMQP broker.',
'AMQPConnection::disconnect' => 'Closes the transient connection with the AMQP broker.

This method will close an open connection with the AMQP broker.',
'AMQPConnection::getCACert' => 'Get path to the CA cert file in PEM format',
'AMQPConnection::getCert' => 'Get path to the client certificate in PEM format',
'AMQPConnection::getHeartbeatInterval' => 'Get number of seconds between heartbeats of the connection in seconds.

When connection is connected, effective connection value returned, which is normally the same as original
correspondent value passed to constructor, otherwise original value passed to constructor returned.',
'AMQPConnection::getHost' => 'Get the configured host.',
'AMQPConnection::getKey' => 'Get path to the client key in PEM format',
'AMQPConnection::getLogin' => 'Get the configured login.',
'AMQPConnection::getMaxChannels' => 'Get the maximum number of channels the connection can handle.

When connection is connected, effective connection value returned, which is normally the same as original
correspondent value passed to constructor, otherwise original value passed to constructor returned.',
'AMQPConnection::getMaxFrameSize' => 'Get max supported frame size per connection in bytes.

When connection is connected, effective connection value returned, which is normally the same as original
correspondent value passed to constructor, otherwise original value passed to constructor returned.',
'AMQPConnection::getPassword' => 'Get the configured password.',
'AMQPConnection::getPort' => 'Get the configured port.',
'AMQPConnection::getReadTimeout' => 'Get the configured interval of time to wait for income activity
from AMQP broker',
'AMQPConnection::getTimeout' => 'Get the configured interval of time to wait for income activity
from AMQP broker',
'AMQPConnection::getUsedChannels' => 'Return last used channel id during current connection session.',
'AMQPConnection::getVerify' => 'Get whether peer verification enabled or disabled',
'AMQPConnection::getVhost' => 'Get the configured vhost.',
'AMQPConnection::getWriteTimeout' => 'Get the configured interval of time to wait for outcome activity
to AMQP broker',
'AMQPConnection::isConnected' => 'Check whether the connection to the AMQP broker is still valid.

It does so by checking the return status of the last connect-command.',
'AMQPConnection::isPersistent' => 'Whether connection persistent.

When connection is not connected, boolean false always returned',
'AMQPConnection::pconnect' => 'Establish a persistent connection with the AMQP broker.

This method will initiate a connection with the AMQP broker
or reuse an existing one if present.',
'AMQPConnection::pdisconnect' => 'Closes a persistent connection with the AMQP broker.

This method will close an open persistent connection with the AMQP
broker.',
'AMQPConnection::preconnect' => 'Close any open persistent connections and initiate a new one with the AMQP broker.',
'AMQPConnection::reconnect' => 'Close any open transient connections and initiate a new one with the AMQP broker.',
'AMQPConnection::setCACert' => 'Set path to the CA cert file in PEM format',
'AMQPConnection::setCert' => 'Set path to the client certificate in PEM format',
'AMQPConnection::setHost' => 'Set the hostname used to connect to the AMQP broker.',
'AMQPConnection::setKey' => 'Set path to the client key in PEM format',
'AMQPConnection::setLogin' => 'Set the login string used to connect to the AMQP broker.',
'AMQPConnection::setPassword' => 'Set the password string used to connect to the AMQP broker.',
'AMQPConnection::setPort' => 'Set the port used to connect to the AMQP broker.',
'AMQPConnection::setReadTimeout' => 'Sets the interval of time to wait for income activity from AMQP broker',
'AMQPConnection::setTimeout' => 'Sets the interval of time to wait for income activity from AMQP broker',
'AMQPConnection::setVerify' => 'Enable or disable peer verification',
'AMQPConnection::setVhost' => 'Sets the virtual host to which to connect on the AMQP broker.',
'AMQPConnection::setWriteTimeout' => 'Sets the interval of time to wait for outcome activity to AMQP broker',
'AMQPEnvelope::getAppId' => 'Get the application id of the message.',
'AMQPEnvelope::getBody' => 'Get the body of the message.',
'AMQPEnvelope::getClusterId' => 'Get the cluster id of the message.',
'AMQPEnvelope::getConsumerTag' => 'Get the consumer tag of the message.',
'AMQPEnvelope::getContentEncoding' => 'Get the content encoding of the message.',
'AMQPEnvelope::getContentType' => 'Get the message content type.',
'AMQPEnvelope::getCorrelationId' => 'Get the message correlation id.',
'AMQPEnvelope::getDeliveryMode' => 'Get the delivery mode of the message.',
'AMQPEnvelope::getDeliveryTag' => 'Get the delivery tag of the message.',
'AMQPEnvelope::getExchangeName' => 'Get the exchange name on which the message was published.',
'AMQPEnvelope::getExpiration' => 'Get the expiration of the message.',
'AMQPEnvelope::getHeader' => 'Get a specific message header.',
'AMQPEnvelope::getHeaders' => 'Get the headers of the message.',
'AMQPEnvelope::getMessageId' => 'Get the message id of the message.',
'AMQPEnvelope::getPriority' => 'Get the priority of the message.',
'AMQPEnvelope::getReplyTo' => 'Get the reply-to address of the message.',
'AMQPEnvelope::getRoutingKey' => 'Get the routing key of the message.',
'AMQPEnvelope::getTimestamp' => 'Get the timestamp of the message.',
'AMQPEnvelope::getType' => 'Get the message type.',
'AMQPEnvelope::getUserId' => 'Get the message user id.',
'AMQPEnvelope::hasHeader' => 'Check whether specific message header exists.',
'AMQPEnvelope::isRedelivery' => 'Whether this is a redelivery of the message.

Whether this is a redelivery of a message. If this message has been
delivered and AMQPEnvelope::nack() was called, the message will be put
back on the queue to be redelivered, at which point the message will
always return TRUE when this method is called.',
'AMQPExchange::__construct' => 'Create an instance of AMQPExchange.

Returns a new instance of an AMQPExchange object, associated with the
given AMQPChannel object.',
'AMQPExchange::bind' => 'Bind to another exchange.

Bind an exchange to another exchange using the specified routing key.',
'AMQPExchange::declare' => 'Declare a new exchange on the broker.',
'AMQPExchange::declareExchange' => 'Declare a new exchange on the broker.',
'AMQPExchange::delete' => 'Delete the exchange from the broker.',
'AMQPExchange::getArgument' => 'Get the argument associated with the given key.',
'AMQPExchange::getArguments' => 'Get all arguments set on the given exchange.',
'AMQPExchange::getChannel' => 'Get the AMQPChannel object in use',
'AMQPExchange::getConnection' => 'Get the AMQPConnection object in use',
'AMQPExchange::getFlags' => 'Get all the flags currently set on the given exchange.',
'AMQPExchange::getName' => 'Get the configured name.',
'AMQPExchange::getType' => 'Get the configured type.',
'AMQPExchange::hasArgument' => 'Check whether argument associated with the given key exists.',
'AMQPExchange::publish' => 'Publish a message to an exchange.

Publish a message to the exchange represented by the AMQPExchange object.',
'AMQPExchange::setArgument' => 'Set the value for the given key.',
'AMQPExchange::setArguments' => 'Set all arguments on the exchange.',
'AMQPExchange::setFlags' => 'Set the flags on an exchange.',
'AMQPExchange::setName' => 'Set the name of the exchange.',
'AMQPExchange::setType' => 'Set the type of the exchange.

Set the type of the exchange. This can be any of AMQP_EX_TYPE_DIRECT,
AMQP_EX_TYPE_FANOUT, AMQP_EX_TYPE_HEADERS or AMQP_EX_TYPE_TOPIC.',
'AMQPExchange::unbind' => 'Remove binding to another exchange.

Remove a routing key binding on an another exchange from the given exchange.',
'AMQPQueue::__construct' => 'Create an instance of an AMQPQueue object.',
'AMQPQueue::ack' => 'Acknowledge the receipt of a message.

This method allows the acknowledgement of a message that is retrieved
without the AMQP_AUTOACK flag through AMQPQueue::get() or
AMQPQueue::consume()',
'AMQPQueue::bind' => 'Bind the given queue to a routing key on an exchange.',
'AMQPQueue::cancel' => 'Cancel a queue that is already bound to an exchange and routing key.',
'AMQPQueue::consume' => 'Consume messages from a queue.

Blocking function that will retrieve the next message from the queue as
it becomes available and will pass it off to the callback.',
'AMQPQueue::declare' => 'Declare a new queue',
'AMQPQueue::declareQueue' => 'Declare a new queue on the broker.',
'AMQPQueue::delete' => 'Delete a queue from the broker.

This includes its entire contents of unread or unacknowledged messages.',
'AMQPQueue::get' => 'Retrieve the next message from the queue.

Retrieve the next available message from the queue. If no messages are
present in the queue, this function will return FALSE immediately. This
is a non blocking alternative to the AMQPQueue::consume() method.
Currently, the only supported flag for the flags parameter is
AMQP_AUTOACK. If this flag is passed in, then the message returned will
automatically be marked as acknowledged by the broker as soon as the
frames are sent to the client.',
'AMQPQueue::getArgument' => 'Get the argument associated with the given key.',
'AMQPQueue::getArguments' => 'Get all set arguments as an array of key/value pairs.',
'AMQPQueue::getChannel' => 'Get the AMQPChannel object in use',
'AMQPQueue::getConnection' => 'Get the AMQPConnection object in use',
'AMQPQueue::getConsumerTag' => 'Get latest consumer tag. If no consumer available or the latest on was canceled null will be returned.',
'AMQPQueue::getFlags' => 'Get all the flags currently set on the given queue.',
'AMQPQueue::getName' => 'Get the configured name.',
'AMQPQueue::hasArgument' => 'Check whether a queue has specific argument.',
'AMQPQueue::nack' => 'Mark a message as explicitly not acknowledged.

Mark the message identified by delivery_tag as explicitly not
acknowledged. This method can only be called on messages that have not
yet been acknowledged, meaning that messages retrieved with by
AMQPQueue::consume() and AMQPQueue::get() and using the AMQP_AUTOACK
flag are not eligible. When called, the broker will immediately put the
message back onto the queue, instead of waiting until the connection is
closed. This method is only supported by the RabbitMQ broker. The
behavior of calling this method while connected to any other broker is
undefined.',
'AMQPQueue::purge' => 'Purge the contents of a queue.',
'AMQPQueue::reject' => 'Mark one message as explicitly not acknowledged.

Mark the message identified by delivery_tag as explicitly not
acknowledged. This method can only be called on messages that have not
yet been acknowledged, meaning that messages retrieved with by
AMQPQueue::consume() and AMQPQueue::get() and using the AMQP_AUTOACK
flag are not eligible.',
'AMQPQueue::setArgument' => 'Set a queue argument.',
'AMQPQueue::setArguments' => 'Set all arguments on the given queue.

All other argument settings will be wiped.',
'AMQPQueue::setFlags' => 'Set the flags on the queue.',
'AMQPQueue::setName' => 'Set the queue name.',
'AMQPQueue::unbind' => 'Remove a routing key binding on an exchange from the given queue.',
'apache_child_terminate' => 'Terminate apache process after this request',
'apache_get_modules' => 'Get a list of loaded Apache modules',
'apache_get_version' => 'Fetch Apache version',
'apache_getenv' => 'Get an Apache subprocess_env variable',
'apache_lookup_uri' => 'Perform a partial request for the specified URI and return all info about it',
'apache_note' => 'Get and set apache request notes',
'apache_request_headers' => 'Fetch all HTTP request headers',
'apache_reset_timeout' => 'Reset the Apache write timer',
'apache_response_headers' => 'Fetch all HTTP response headers',
'apache_setenv' => 'Set an Apache subprocess_env variable',
'apc_add' => 'Cache a new variable in the data store',
'apc_bin_dump' => 'Get a binary dump of the given files and user variables',
'apc_bin_dumpfile' => 'Output a binary dump of cached files and user variables to a file',
'apc_bin_load' => 'Load a binary dump into the APC file/user cache',
'apc_bin_loadfile' => 'Load a binary dump from a file into the APC file/user cache',
'apc_cache_info' => 'Retrieves cached information from APC\'s data store',
'apc_cas' => 'Updates an old value with a new value',
'apc_clear_cache' => 'Clears the APC cache',
'apc_compile_file' => 'Stores a file in the bytecode cache, bypassing all filters',
'apc_dec' => 'Decrease a stored number',
'apc_define_constants' => 'Defines a set of constants for retrieval and mass-definition',
'apc_delete' => 'Removes a stored variable from the cache',
'apc_delete_file' => 'Deletes files from the opcode cache',
'apc_exists' => 'Checks if APC key exists',
'apc_fetch' => 'Fetch a stored variable from the cache',
'apc_inc' => 'Increase a stored number',
'apc_load_constants' => 'Loads a set of constants from the cache',
'apc_sma_info' => 'Retrieves APC\'s Shared Memory Allocation information',
'apc_store' => 'Cache a variable in the data store',
'apciterator::__construct' => 'Constructs an APCIterator iterator object',
'apciterator::current' => 'Get current item',
'apciterator::getTotalCount' => 'Get total count',
'apciterator::getTotalHits' => 'Get total cache hits',
'apciterator::getTotalSize' => 'Get total cache size',
'apciterator::key' => 'Get iterator key',
'apciterator::next' => 'Move pointer to next item',
'apciterator::rewind' => 'Rewinds iterator',
'apciterator::valid' => 'Checks if current position is valid',
'apcu_add' => 'Cache a new variable in the data store',
'apcu_cache_info' => 'Retrieves cached information from APCu\'s data store',
'apcu_cas' => 'Updates an old value with a new value',
'apcu_clear_cache' => 'Clears the APCu cache',
'apcu_dec' => 'Decrease a stored number',
'apcu_delete' => 'Removes a stored variable from the cache',
'apcu_enabled' => 'Whether APCu is usable in the current environment',
'apcu_entry' => 'Atomically fetch or generate a cache entry',
'apcu_exists' => 'Checks if entry exists',
'apcu_fetch' => 'Fetch a stored variable from the cache',
'apcu_inc' => 'Increase a stored number',
'apcu_sma_info' => 'Retrieves APCu Shared Memory Allocation information',
'apcu_store' => 'Cache a variable in the data store',
'apcuiterator::__construct' => 'Constructs an APCUIterator iterator object',
'apcuiterator::current' => 'Get current item',
'apcuiterator::getTotalCount' => 'Get total count',
'apcuiterator::getTotalHits' => 'Get total cache hits',
'apcuiterator::getTotalSize' => 'Get total cache size',
'apcuiterator::key' => 'Get iterator key',
'apcuiterator::next' => 'Move pointer to next item',
'apcuiterator::rewind' => 'Rewinds iterator',
'apcuiterator::valid' => 'Checks if current position is valid',
'apd_breakpoint' => 'Stops the interpreter and waits on a CR from the socket',
'apd_callstack' => 'Returns the current call stack as an array',
'apd_clunk' => 'Throw a warning and a callstack',
'apd_continue' => 'Restarts the interpreter',
'apd_croak' => 'Throw an error, a callstack and then exit',
'apd_dump_function_table' => 'Outputs the current function table',
'apd_dump_persistent_resources' => 'Return all persistent resources as an array',
'apd_dump_regular_resources' => 'Return all current regular resources as an array',
'apd_echo' => 'Echo to the debugging socket',
'apd_get_active_symbols' => 'Get an array of the current variables names in the local scope',
'apd_set_pprof_trace' => 'Starts the session debugging',
'apd_set_session' => 'Changes or sets the current debugging level',
'apd_set_session_trace' => 'Starts the session debugging',
'apd_set_session_trace_socket' => 'Starts the remote session debugging',
'appenditerator::__construct' => 'Constructs an AppendIterator',
'appenditerator::append' => 'Appends an iterator',
'appenditerator::current' => 'Gets the current value',
'appenditerator::getArrayIterator' => 'Gets the ArrayIterator',
'appenditerator::getInnerIterator' => 'Gets the inner iterator',
'appenditerator::getIteratorIndex' => 'Gets an index of iterators',
'appenditerator::key' => 'Gets the current key',
'appenditerator::next' => 'Moves to the next element',
'appenditerator::rewind' => 'Rewinds the Iterator',
'appenditerator::valid' => 'Checks validity of the current element',
'array_change_key_case' => 'Changes the case of all keys in an array',
'array_chunk' => 'Split an array into chunks',
'array_column' => 'Return the values from a single column in the input array',
'array_combine' => 'Creates an array by using one array for keys and another for its values',
'array_count_values' => 'Counts all the values of an array',
'array_diff' => 'Computes the difference of arrays',
'array_diff_assoc' => 'Computes the difference of arrays with additional index check',
'array_diff_key' => 'Computes the difference of arrays using keys for comparison',
'array_diff_uassoc' => 'Computes the difference of arrays with additional index check which is performed by a user supplied callback function',
'array_diff_ukey' => 'Computes the difference of arrays using a callback function on the keys for comparison',
'array_fill' => 'Fill an array with values',
'array_fill_keys' => 'Fill an array with values, specifying keys',
'array_filter' => 'Filters elements of an array using a callback function',
'array_flip' => 'Exchanges all keys with their associated values in an array',
'array_intersect' => 'Computes the intersection of arrays',
'array_intersect_assoc' => 'Computes the intersection of arrays with additional index check',
'array_intersect_key' => 'Computes the intersection of arrays using keys for comparison',
'array_intersect_uassoc' => 'Computes the intersection of arrays with additional index check, compares indexes by a callback function',
'array_intersect_ukey' => 'Computes the intersection of arrays using a callback function on the keys for comparison',
'array_key_exists' => 'Checks if the given key or index exists in the array',
'array_key_first' => 'Gets the first key of an array',
'array_key_last' => 'Gets the last key of an array',
'array_keys' => 'Return all the keys or a subset of the keys of an array',
'array_map' => 'Applies the callback to the elements of the given arrays',
'array_merge' => 'Merge one or more arrays',
'array_merge_recursive' => 'Merge one or more arrays recursively',
'array_multisort' => 'Sort multiple or multi-dimensional arrays',
'array_pad' => 'Pad array to the specified length with a value',
'array_pop' => 'Pop the element off the end of array',
'array_product' => 'Calculate the product of values in an array',
'array_push' => 'Push one or more elements onto the end of array',
'array_rand' => 'Pick one or more random keys out of an array',
'array_reduce' => 'Iteratively reduce the array to a single value using a callback function',
'array_replace' => 'Replaces elements from passed arrays into the first array',
'array_replace_recursive' => 'Replaces elements from passed arrays into the first array recursively',
'array_reverse' => 'Return an array with elements in reverse order',
'array_search' => 'Searches the array for a given value and returns the first corresponding key if successful',
'array_shift' => 'Shift an element off the beginning of array',
'array_slice' => 'Extract a slice of the array',
'array_splice' => 'Remove a portion of the array and replace it with something else',
'array_sum' => 'Calculate the sum of values in an array',
'array_udiff' => 'Computes the difference of arrays by using a callback function for data comparison',
'array_udiff_assoc' => 'Computes the difference of arrays with additional index check, compares data by a callback function',
'array_udiff_uassoc' => 'Computes the difference of arrays with additional index check, compares data and indexes by a callback function',
'array_uintersect' => 'Computes the intersection of arrays, compares data by a callback function',
'array_uintersect_assoc' => 'Computes the intersection of arrays with additional index check, compares data by a callback function',
'array_uintersect_uassoc' => 'Computes the intersection of arrays with additional index check, compares data and indexes by separate callback functions',
'array_unique' => 'Removes duplicate values from an array',
'array_unshift' => 'Prepend one or more elements to the beginning of an array',
'array_values' => 'Return all the values of an array',
'array_walk' => 'Apply a user supplied function to every member of an array',
'array_walk_recursive' => 'Apply a user function recursively to every member of an array',
'ArrayAccess::offsetExists' => 'Whether a offset exists',
'ArrayAccess::offsetGet' => 'Offset to retrieve',
'ArrayAccess::offsetSet' => 'Offset to set',
'ArrayAccess::offsetUnset' => 'Offset to unset',
'arrayiterator::__construct' => 'Construct an ArrayIterator',
'arrayiterator::append' => 'Append an element',
'arrayiterator::asort' => 'Sort array by values',
'arrayiterator::count' => 'Count elements',
'arrayiterator::current' => 'Return current array entry',
'arrayiterator::getArrayCopy' => 'Get array copy',
'arrayiterator::getFlags' => 'Get behavior flags',
'arrayiterator::key' => 'Return current array key',
'arrayiterator::ksort' => 'Sort array by keys',
'arrayiterator::natcasesort' => 'Sort an array naturally, case insensitive',
'arrayiterator::natsort' => 'Sort an array naturally',
'arrayiterator::next' => 'Move to next entry',
'arrayiterator::offsetExists' => 'Check if offset exists',
'arrayiterator::offsetGet' => 'Get value for an offset',
'arrayiterator::offsetSet' => 'Set value for an offset',
'arrayiterator::offsetUnset' => 'Unset value for an offset',
'arrayiterator::rewind' => 'Rewind array back to the start',
'arrayiterator::seek' => 'Seek to position',
'arrayiterator::serialize' => 'Serialize',
'arrayiterator::setFlags' => 'Set behaviour flags',
'arrayiterator::uasort' => 'Sort with a user-defined comparison function and maintain index association',
'arrayiterator::uksort' => 'Sort by keys using a user-defined comparison function',
'arrayiterator::unserialize' => 'Unserialize',
'arrayiterator::valid' => 'Check whether array contains more entries',
'arrayobject::__construct' => 'Construct a new array object',
'arrayobject::append' => 'Appends the value',
'arrayobject::asort' => 'Sort the entries by value',
'arrayobject::count' => 'Get the number of public properties in the ArrayObject',
'arrayobject::exchangeArray' => 'Exchange the array for another one',
'arrayobject::getArrayCopy' => 'Creates a copy of the ArrayObject',
'arrayobject::getFlags' => 'Gets the behavior flags',
'arrayobject::getIterator' => 'Create a new iterator from an ArrayObject instance',
'arrayobject::getIteratorClass' => 'Gets the iterator classname for the ArrayObject',
'arrayobject::ksort' => 'Sort the entries by key',
'arrayobject::natcasesort' => 'Sort an array using a case insensitive "natural order" algorithm',
'arrayobject::natsort' => 'Sort entries using a "natural order" algorithm',
'arrayobject::offsetExists' => 'Returns whether the requested index exists',
'arrayobject::offsetGet' => 'Returns the value at the specified index',
'arrayobject::offsetSet' => 'Sets the value at the specified index to newval',
'arrayobject::offsetUnset' => 'Unsets the value at the specified index',
'arrayobject::serialize' => 'Serialize an ArrayObject',
'arrayobject::setFlags' => 'Sets the behavior flags',
'arrayobject::setIteratorClass' => 'Sets the iterator classname for the ArrayObject',
'arrayobject::uasort' => 'Sort the entries with a user-defined comparison function and maintain key association',
'arrayobject::uksort' => 'Sort the entries by keys using a user-defined comparison function',
'arrayobject::unserialize' => 'Unserialize an ArrayObject',
'arsort' => 'Sort an array in reverse order and maintain index association',
'asin' => 'Arc sine',
'asinh' => 'Inverse hyperbolic sine',
'asort' => 'Sort an array and maintain index association',
'assert' => 'Checks if assertion is `false`',
'assert_options' => 'Set/get the various assert flags',
'ast\get_kind_name' => 'Get string representation of AST kind value',
'ast\get_metadata' => 'Provides metadata for the AST kinds',
'ast\get_supported_versions' => 'Returns currently supported AST versions.',
'ast\kind_uses_flags' => 'Check if AST kind uses flags',
'ast\parse_code' => 'Parses code string and returns AST root node.',
'ast\parse_file' => 'Parses code file and returns AST root node.',
'atan' => 'Arc tangent',
'atan2' => 'Arc tangent of two variables',
'atanh' => 'Inverse hyperbolic tangent',
'base64_decode' => 'Decodes data encoded with MIME base64',
'base64_encode' => 'Encodes data with MIME base64',
'base_convert' => 'Convert a number between arbitrary bases',
'basename' => 'Returns trailing name component of path',
'bbcode_add_element' => 'Adds a bbcode element',
'bbcode_add_smiley' => 'Adds a smiley to the parser',
'bbcode_create' => 'Create a BBCode Resource',
'bbcode_destroy' => 'Close BBCode_container resource',
'bbcode_parse' => 'Parse a string following a given rule set',
'bbcode_set_arg_parser' => 'Attach another parser in order to use another rule set for argument parsing',
'bbcode_set_flags' => 'Set or alter parser options',
'bcadd' => 'Add two arbitrary precision numbers',
'bccomp' => 'Compare two arbitrary precision numbers',
'bcdiv' => 'Divide two arbitrary precision numbers',
'bcmod' => 'Get modulus of an arbitrary precision number',
'bcmul' => 'Multiply two arbitrary precision numbers',
'bcompiler_load' => 'Reads and creates classes from a bz compressed file',
'bcompiler_load_exe' => 'Reads and creates classes from a bcompiler exe file',
'bcompiler_parse_class' => 'Reads the bytecodes of a class and calls back to a user function',
'bcompiler_read' => 'Reads and creates classes from a filehandle',
'bcompiler_write_class' => 'Writes a defined class as bytecodes',
'bcompiler_write_constant' => 'Writes a defined constant as bytecodes',
'bcompiler_write_exe_footer' => 'Writes the start pos, and sig to the end of a exe type file',
'bcompiler_write_file' => 'Writes a php source file as bytecodes',
'bcompiler_write_footer' => 'Writes the single character \x00 to indicate End of compiled data',
'bcompiler_write_function' => 'Writes a defined function as bytecodes',
'bcompiler_write_functions_from_file' => 'Writes all functions defined in a file as bytecodes',
'bcompiler_write_header' => 'Writes the bcompiler header',
'bcompiler_write_included_filename' => 'Writes an included file as bytecodes',
'bcpow' => 'Raise an arbitrary precision number to another',
'bcpowmod' => 'Raise an arbitrary precision number to another, reduced by a specified modulus',
'bcscale' => 'Set or get default scale parameter for all bc math functions',
'bcsqrt' => 'Get the square root of an arbitrary precision number',
'bcsub' => 'Subtract one arbitrary precision number from another',
'bin2hex' => 'Convert binary data into hexadecimal representation',
'bind_textdomain_codeset' => 'Specify the character encoding in which the messages from the DOMAIN message catalog will be returned',
'bindec' => 'Binary to decimal',
'bindtextdomain' => 'Sets the path for a domain',
'blenc_encrypt' => 'Encrypt a PHP script with BLENC',
'boolval' => 'Get the boolean value of a variable',
'bson_decode' => 'Deserializes a BSON object into a PHP array',
'bson_encode' => 'Serializes a PHP variable into a BSON string',
'bzclose' => 'Close a bzip2 file',
'bzcompress' => 'Compress a string into bzip2 encoded data',
'bzdecompress' => 'Decompresses bzip2 encoded data',
'bzerrno' => 'Returns a bzip2 error number',
'bzerror' => 'Returns the bzip2 error number and error string in an array',
'bzerrstr' => 'Returns a bzip2 error string',
'bzflush' => 'Force a write of all buffered data',
'bzopen' => 'Opens a bzip2 compressed file',
'bzread' => 'Binary safe bzip2 file read',
'bzwrite' => 'Binary safe bzip2 file write',
'cachingiterator::__construct' => 'Construct a new CachingIterator object for the iterator',
'cachingiterator::__toString' => 'Return the string representation of the current element',
'cachingiterator::count' => 'The number of elements in the iterator',
'cachingiterator::current' => 'Return the current element',
'cachingiterator::getCache' => 'Retrieve the contents of the cache',
'cachingiterator::getFlags' => 'Get flags used',
'cachingiterator::getInnerIterator' => 'Returns the inner iterator',
'cachingiterator::hasNext' => 'Check whether the inner iterator has a valid next element',
'cachingiterator::key' => 'Return the key for the current element',
'cachingiterator::next' => 'Move the iterator forward',
'cachingiterator::offsetExists' => 'The offsetExists purpose',
'cachingiterator::offsetGet' => 'The offsetGet purpose',
'cachingiterator::offsetSet' => 'The offsetSet purpose',
'cachingiterator::offsetUnset' => 'The offsetUnset purpose',
'cachingiterator::rewind' => 'Rewind the iterator',
'cachingiterator::setFlags' => 'The setFlags purpose',
'cachingiterator::valid' => 'Check whether the current element is valid',
'cairo::availableFonts' => 'Retrieves the availables font types',
'cairo::availableSurfaces' => 'Retrieves all available surfaces',
'cairo::statusToString' => 'Retrieves the current status as string',
'cairo::version' => 'Retrieves cairo\'s library version',
'cairo::versionString' => 'Retrieves cairo version as string',
'cairo_create' => 'Returns a new CairoContext object on the requested surface',
'cairo_matrix_create_scale' => 'Alias of CairoMatrix::initScale',
'cairo_matrix_create_translate' => 'Alias of CairoMatrix::initTranslate',
'cairocontext::__construct' => 'Creates a new CairoContext',
'cairocontext::appendPath' => 'Appends a path to current path',
'cairocontext::arc' => 'Adds a circular arc',
'cairocontext::arcNegative' => 'Adds a negative arc',
'cairocontext::clip' => 'Establishes a new clip region',
'cairocontext::clipExtents' => 'Computes the area inside the current clip',
'cairocontext::clipPreserve' => 'Establishes a new clip region from the current clip',
'cairocontext::clipRectangleList' => 'Retrieves the current clip as a list of rectangles',
'cairocontext::closePath' => 'Closes the current path',
'cairocontext::copyPage' => 'Emits the current page',
'cairocontext::copyPath' => 'Creates a copy of the current path',
'cairocontext::copyPathFlat' => 'Gets a flattened copy of the current path',
'cairocontext::curveTo' => 'Adds a curve',
'cairocontext::deviceToUser' => 'Transform a coordinate',
'cairocontext::deviceToUserDistance' => 'Transform a distance',
'cairocontext::fill' => 'Fills the current path',
'cairocontext::fillExtents' => 'Computes the filled area',
'cairocontext::fillPreserve' => 'Fills and preserve the current path',
'cairocontext::fontExtents' => 'Get the font extents',
'cairocontext::getAntialias' => 'Retrieves the current antialias mode',
'cairocontext::getCurrentPoint' => 'The getCurrentPoint purpose',
'cairocontext::getDash' => 'The getDash purpose',
'cairocontext::getDashCount' => 'The getDashCount purpose',
'cairocontext::getFillRule' => 'The getFillRule purpose',
'cairocontext::getFontFace' => 'The getFontFace purpose',
'cairocontext::getFontMatrix' => 'The getFontMatrix purpose',
'cairocontext::getFontOptions' => 'The getFontOptions purpose',
'cairocontext::getGroupTarget' => 'The getGroupTarget purpose',
'cairocontext::getLineCap' => 'The getLineCap purpose',
'cairocontext::getLineJoin' => 'The getLineJoin purpose',
'cairocontext::getLineWidth' => 'The getLineWidth purpose',
'cairocontext::getMatrix' => 'The getMatrix purpose',
'cairocontext::getMiterLimit' => 'The getMiterLimit purpose',
'cairocontext::getOperator' => 'The getOperator purpose',
'cairocontext::getScaledFont' => 'The getScaledFont purpose',
'cairocontext::getSource' => 'The getSource purpose',
'cairocontext::getTarget' => 'The getTarget purpose',
'cairocontext::getTolerance' => 'The getTolerance purpose',
'cairocontext::glyphPath' => 'The glyphPath purpose',
'cairocontext::hasCurrentPoint' => 'The hasCurrentPoint purpose',
'cairocontext::identityMatrix' => 'The identityMatrix purpose',
'cairocontext::inFill' => 'The inFill purpose',
'cairocontext::inStroke' => 'The inStroke purpose',
'cairocontext::lineTo' => 'The lineTo purpose',
'cairocontext::mask' => 'The mask purpose',
'cairocontext::maskSurface' => 'The maskSurface purpose',
'cairocontext::moveTo' => 'The moveTo purpose',
'cairocontext::newPath' => 'The newPath purpose',
'cairocontext::newSubPath' => 'The newSubPath purpose',
'cairocontext::paint' => 'The paint purpose',
'cairocontext::paintWithAlpha' => 'The paintWithAlpha purpose',
'cairocontext::pathExtents' => 'The pathExtents purpose',
'cairocontext::popGroup' => 'The popGroup purpose',
'cairocontext::popGroupToSource' => 'The popGroupToSource purpose',
'cairocontext::pushGroup' => 'The pushGroup purpose',
'cairocontext::pushGroupWithContent' => 'The pushGroupWithContent purpose',
'cairocontext::rectangle' => 'The rectangle purpose',
'cairocontext::relCurveTo' => 'The relCurveTo purpose',
'cairocontext::relLineTo' => 'The relLineTo purpose',
'cairocontext::relMoveTo' => 'The relMoveTo purpose',
'cairocontext::resetClip' => 'The resetClip purpose',
'cairocontext::restore' => 'The restore purpose',
'cairocontext::rotate' => 'The rotate purpose',
'cairocontext::save' => 'The save purpose',
'cairocontext::scale' => 'The scale purpose',
'cairocontext::selectFontFace' => 'The selectFontFace purpose',
'cairocontext::setAntialias' => 'The setAntialias purpose',
'cairocontext::setDash' => 'The setDash purpose',
'cairocontext::setFillRule' => 'The setFillRule purpose',
'cairocontext::setFontFace' => 'The setFontFace purpose',
'cairocontext::setFontMatrix' => 'The setFontMatrix purpose',
'cairocontext::setFontOptions' => 'The setFontOptions purpose',
'cairocontext::setFontSize' => 'The setFontSize purpose',
'cairocontext::setLineCap' => 'The setLineCap purpose',
'cairocontext::setLineJoin' => 'The setLineJoin purpose',
'cairocontext::setLineWidth' => 'The setLineWidth purpose',
'cairocontext::setMatrix' => 'The setMatrix purpose',
'cairocontext::setMiterLimit' => 'The setMiterLimit purpose',
'cairocontext::setOperator' => 'The setOperator purpose',
'cairocontext::setScaledFont' => 'The setScaledFont purpose',
'cairocontext::setSource' => 'The setSource purpose',
'cairocontext::setSourceRGB' => 'The setSourceRGB purpose',
'cairocontext::setSourceRGBA' => 'The setSourceRGBA purpose',
'cairocontext::setSourceSurface' => 'The setSourceSurface purpose',
'cairocontext::setTolerance' => 'The setTolerance purpose',
'cairocontext::showPage' => 'The showPage purpose',
'cairocontext::showText' => 'The showText purpose',
'cairocontext::status' => 'The status purpose',
'cairocontext::stroke' => 'The stroke purpose',
'cairocontext::strokeExtents' => 'The strokeExtents purpose',
'cairocontext::strokePreserve' => 'The strokePreserve purpose',
'cairocontext::textExtents' => 'The textExtents purpose',
'cairocontext::textPath' => 'The textPath purpose',
'cairocontext::transform' => 'The transform purpose',
'cairocontext::translate' => 'The translate purpose',
'cairocontext::userToDevice' => 'The userToDevice purpose',
'cairocontext::userToDeviceDistance' => 'The userToDeviceDistance purpose',
'cairofontface::__construct' => 'Creates a new CairoFontFace object',
'cairofontface::getType' => 'Retrieves the font face type',
'cairofontface::status' => 'Check for CairoFontFace errors',
'cairofontoptions::__construct' => 'The __construct purpose',
'cairofontoptions::equal' => 'The equal purpose',
'cairofontoptions::getAntialias' => 'The getAntialias purpose',
'cairofontoptions::getHintMetrics' => 'The getHintMetrics purpose',
'cairofontoptions::getHintStyle' => 'The getHintStyle purpose',
'cairofontoptions::getSubpixelOrder' => 'The getSubpixelOrder purpose',
'cairofontoptions::hash' => 'The hash purpose',
'cairofontoptions::merge' => 'The merge purpose',
'cairofontoptions::setAntialias' => 'The setAntialias purpose',
'cairofontoptions::setHintMetrics' => 'The setHintMetrics purpose',
'cairofontoptions::setHintStyle' => 'The setHintStyle purpose',
'cairofontoptions::setSubpixelOrder' => 'The setSubpixelOrder purpose',
'cairofontoptions::status' => 'The status purpose',
'cairoformat::strideForWidth' => 'Provides an appropriate stride to use',
'cairogradientpattern::addColorStopRgb' => 'The addColorStopRgb purpose',
'cairogradientpattern::addColorStopRgba' => 'The addColorStopRgba purpose',
'cairogradientpattern::getColorStopCount' => 'The getColorStopCount purpose',
'cairogradientpattern::getColorStopRgba' => 'The getColorStopRgba purpose',
'cairogradientpattern::getExtend' => 'The getExtend purpose',
'cairogradientpattern::setExtend' => 'The setExtend purpose',
'cairoimagesurface::__construct' => 'Creates a new CairoImageSurface',
'cairoimagesurface::createForData' => 'The createForData purpose',
'cairoimagesurface::createFromPng' => 'Creates a new CairoImageSurface form a png image file',
'cairoimagesurface::getData' => 'Gets the image data as string',
'cairoimagesurface::getFormat' => 'Get the image format',
'cairoimagesurface::getHeight' => 'Retrieves the height of the CairoImageSurface',
'cairoimagesurface::getStride' => 'The getStride purpose',
'cairoimagesurface::getWidth' => 'Retrieves the width of the CairoImageSurface',
'cairolineargradient::__construct' => 'The __construct purpose',
'cairolineargradient::getPoints' => 'The getPoints purpose',
'cairomatrix::__construct' => 'Creates a new CairoMatrix object',
'cairomatrix::initIdentity' => 'Creates a new identity matrix',
'cairomatrix::initRotate' => 'Creates a new rotated matrix',
'cairomatrix::initScale' => 'Creates a new scaling matrix',
'cairomatrix::initTranslate' => 'Creates a new translation matrix',
'cairomatrix::invert' => 'The invert purpose',
'cairomatrix::multiply' => 'The multiply purpose',
'cairomatrix::rotate' => 'The rotate purpose',
'cairomatrix::scale' => 'Applies scaling to a matrix',
'cairomatrix::transformDistance' => 'The transformDistance purpose',
'cairomatrix::transformPoint' => 'The transformPoint purpose',
'cairomatrix::translate' => 'The translate purpose',
'cairopattern::__construct' => 'The __construct purpose',
'cairopattern::getMatrix' => 'The getMatrix purpose',
'cairopattern::getType' => 'The getType purpose',
'cairopattern::setMatrix' => 'The setMatrix purpose',
'cairopattern::status' => 'The status purpose',
'cairopdfsurface::__construct' => 'The __construct purpose',
'cairopdfsurface::setSize' => 'The setSize purpose',
'cairopssurface::__construct' => 'The __construct purpose',
'cairopssurface::dscBeginPageSetup' => 'The dscBeginPageSetup purpose',
'cairopssurface::dscBeginSetup' => 'The dscBeginSetup purpose',
'cairopssurface::dscComment' => 'The dscComment purpose',
'cairopssurface::getEps' => 'The getEps purpose',
'cairopssurface::getLevels' => 'The getLevels purpose',
'cairopssurface::levelToString' => 'The levelToString purpose',
'cairopssurface::restrictToLevel' => 'The restrictToLevel purpose',
'cairopssurface::setEps' => 'The setEps purpose',
'cairopssurface::setSize' => 'The setSize purpose',
'cairoradialgradient::__construct' => 'The __construct purpose',
'cairoradialgradient::getCircles' => 'The getCircles purpose',
'cairoscaledfont::__construct' => 'The __construct purpose',
'cairoscaledfont::extents' => 'The extents purpose',
'cairoscaledfont::getCtm' => 'The getCtm purpose',
'cairoscaledfont::getFontFace' => 'The getFontFace purpose',
'cairoscaledfont::getFontMatrix' => 'The getFontMatrix purpose',
'cairoscaledfont::getFontOptions' => 'The getFontOptions purpose',
'cairoscaledfont::getScaleMatrix' => 'The getScaleMatrix purpose',
'cairoscaledfont::getType' => 'The getType purpose',
'cairoscaledfont::glyphExtents' => 'The glyphExtents purpose',
'cairoscaledfont::status' => 'The status purpose',
'cairoscaledfont::textExtents' => 'The textExtents purpose',
'cairosolidpattern::__construct' => 'The __construct purpose',
'cairosolidpattern::getRgba' => 'The getRgba purpose',
'cairosurface::__construct' => 'The __construct purpose',
'cairosurface::copyPage' => 'The copyPage purpose',
'cairosurface::createSimilar' => 'The createSimilar purpose',
'cairosurface::finish' => 'The finish purpose',
'cairosurface::flush' => 'The flush purpose',
'cairosurface::getContent' => 'The getContent purpose',
'cairosurface::getDeviceOffset' => 'The getDeviceOffset purpose',
'cairosurface::getFontOptions' => 'The getFontOptions purpose',
'cairosurface::getType' => 'The getType purpose',
'cairosurface::markDirty' => 'The markDirty purpose',
'cairosurface::markDirtyRectangle' => 'The markDirtyRectangle purpose',
'cairosurface::setDeviceOffset' => 'The setDeviceOffset purpose',
'cairosurface::setFallbackResolution' => 'The setFallbackResolution purpose',
'cairosurface::showPage' => 'The showPage purpose',
'cairosurface::status' => 'The status purpose',
'cairosurface::writeToPng' => 'The writeToPng purpose',
'cairosurfacepattern::__construct' => 'The __construct purpose',
'cairosurfacepattern::getExtend' => 'The getExtend purpose',
'cairosurfacepattern::getFilter' => 'The getFilter purpose',
'cairosurfacepattern::getSurface' => 'The getSurface purpose',
'cairosurfacepattern::setExtend' => 'The setExtend purpose',
'cairosurfacepattern::setFilter' => 'The setFilter purpose',
'cairosvgsurface::__construct' => 'The __construct purpose',
'cairosvgsurface::getVersions' => 'Used to retrieve a list of supported SVG versions',
'cairosvgsurface::restrictToVersion' => 'The restrictToVersion purpose',
'cairosvgsurface::versionToString' => 'The versionToString purpose',
'cal_days_in_month' => 'Return the number of days in a month for a given year and calendar',
'cal_from_jd' => 'Converts from Julian Day Count to a supported calendar',
'cal_info' => 'Returns information about a particular calendar',
'cal_to_jd' => 'Converts from a supported calendar to Julian Day Count',
'call_user_func' => 'Call the callback given by the first parameter',
'call_user_func_array' => 'Call a callback with an array of parameters',
'call_user_method' => 'Call a user method on an specific object',
'call_user_method_array' => 'Call a user method given with an array of parameters',
'callbackfilteriterator::__construct' => 'Create a filtered iterator from another iterator',
'callbackfilteriterator::accept' => 'Calls the callback with the current value, the current key and the inner iterator as arguments',
'CallbackFilterIterator::current' => 'Get the current element value',
'CallbackFilterIterator::getInnerIterator' => 'Get the inner iterator',
'CallbackFilterIterator::key' => 'Get the current key',
'CallbackFilterIterator::next' => 'Move the iterator forward',
'CallbackFilterIterator::rewind' => 'Rewind the iterator',
'CallbackFilterIterator::valid' => 'Check whether the current element is valid',
'Cassandra::cluster' => 'Creates a new cluster builder for constructing a Cluster object.',
'Cassandra::ssl' => 'Creates a new ssl builder for constructing a SSLOptions object.',
'Cassandra\Aggregate::argumentTypes' => 'Returns the argument types of the aggregate',
'Cassandra\Aggregate::finalFunction' => 'Returns the final function of the aggregate',
'Cassandra\Aggregate::initialCondition' => 'Returns the initial condition of the aggregate',
'Cassandra\Aggregate::name' => 'Returns the full name of the aggregate',
'Cassandra\Aggregate::returnType' => 'Returns the return type of the aggregate',
'Cassandra\Aggregate::signature' => 'Returns the signature of the aggregate',
'Cassandra\Aggregate::simpleName' => 'Returns the simple name of the aggregate',
'Cassandra\Aggregate::stateFunction' => 'Returns the state function of the aggregate',
'Cassandra\Aggregate::stateType' => 'Returns the state type of the aggregate',
'Cassandra\BatchStatement::__construct' => 'Creates a new batch statement.',
'Cassandra\BatchStatement::add' => 'Adds a statement to this batch.',
'Cassandra\Bigint::__construct' => 'Creates a new 64bit integer.',
'Cassandra\Bigint::__toString' => 'Returns string representation of the integer value.',
'Cassandra\Bigint::abs' => '`@return \Cassandra\Numeric` absolute value',
'Cassandra\Bigint::add' => '`@return \Cassandra\Numeric` sum',
'Cassandra\Bigint::div' => '`@return \Cassandra\Numeric` quotient',
'Cassandra\Bigint::max' => 'Maximum possible Bigint value',
'Cassandra\Bigint::min' => 'Minimum possible Bigint value',
'Cassandra\Bigint::mod' => '`@return \Cassandra\Numeric` remainder',
'Cassandra\Bigint::mul' => '`@return \Cassandra\Numeric` product',
'Cassandra\Bigint::neg' => '`@return \Cassandra\Numeric` negative value',
'Cassandra\Bigint::sqrt' => '`@return \Cassandra\Numeric` square root',
'Cassandra\Bigint::sub' => '`@return \Cassandra\Numeric` difference',
'Cassandra\Bigint::toDouble' => '`@return float` this number as float',
'Cassandra\Bigint::toInt' => '`@return int` this number as int',
'Cassandra\Bigint::type' => 'The type of this bigint.',
'Cassandra\Bigint::value' => 'Returns the integer value.',
'Cassandra\Blob::__construct' => 'Creates a new bytes array.',
'Cassandra\Blob::__toString' => 'Returns bytes as a hex string.',
'Cassandra\Blob::bytes' => 'Returns bytes as a hex string.',
'Cassandra\Blob::toBinaryString' => 'Returns bytes as a binary string.',
'Cassandra\Blob::type' => 'The type of this blob.',
'Cassandra\Cluster::connect' => 'Creates a new Session instance.',
'Cassandra\Cluster::connectAsync' => 'Creates a new Session instance.',
'Cassandra\Cluster\Builder::build' => 'Returns a Cluster Instance.',
'Cassandra\Cluster\Builder::withBlackListDCs' => 'Sets the blacklist datacenters. Any datacenter in the blacklist will be
ignored and a connection will not be established to any host in those
datacenters. This policy is useful for ensuring the driver will not
connect to any host in a specific datacenter.',
'Cassandra\Cluster\Builder::withBlackListHosts' => 'Sets the blacklist hosts. Any host in the blacklist will be ignored and
a conneciton will not be established. This is useful for ensuring that
the driver will not connection to a predefied set of hosts.',
'Cassandra\Cluster\Builder::withConnectionHeartbeatInterval' => 'Specify interval in seconds that the driver should wait before attempting
to send heartbeat messages and control the amount of time the connection
must be idle before sending heartbeat messages. This is useful for
preventing intermediate network devices from dropping connections.',
'Cassandra\Cluster\Builder::withConnectionsPerHost' => 'Set the size of connection pools used by the driver. Pools are fixed
when only `$core` is given, when a `$max` is specified as well,
additional connections will be created automatically based on current
load until the maximum number of connection has been reached. When
request load goes down, extra connections are automatically cleaned up
until only the core number of connections is left.',
'Cassandra\Cluster\Builder::withConnectTimeout' => 'Timeout used for establishing TCP connections.',
'Cassandra\Cluster\Builder::withContactPoints' => 'Configures the initial endpoints. Note that the driver will
automatically discover and connect to the rest of the cluster.',
'Cassandra\Cluster\Builder::withCredentials' => 'Configures plain-text authentication.',
'Cassandra\Cluster\Builder::withDatacenterAwareRoundRobinLoadBalancingPolicy' => 'Configures this cluster to use a datacenter aware round robin load balancing policy.',
'Cassandra\Cluster\Builder::withDefaultConsistency' => 'Configures default consistency for all requests.',
'Cassandra\Cluster\Builder::withDefaultPageSize' => 'Configures default page size for all results.
Set to `null` to disable paging altogether.',
'Cassandra\Cluster\Builder::withDefaultTimeout' => 'Configures default timeout for future resolution in blocking operations
Set to null to disable (default).',
'Cassandra\Cluster\Builder::withHostnameResolution' => 'Enables/disables Hostname Resolution.

If enabled the driver will resolve hostnames for IP addresses using
reverse IP lookup. This is useful for authentication (Kerberos) or
encryption SSL services that require a valid hostname for verification.

Important: It\'s possible that the underlying C/C++ driver does not
support hostname resolution. A PHP warning will be emitted if the driver
does not support hostname resolution.',
'Cassandra\Cluster\Builder::withIOThreads' => 'Total number of IO threads to use for handling the requests.

Note: number of io threads * core connections per host <= total number
      of connections <= number of io threads * max connections per host',
'Cassandra\Cluster\Builder::withLatencyAwareRouting' => 'Enables/disables latency-aware routing.',
'Cassandra\Cluster\Builder::withPersistentSessions' => 'Enable persistent sessions and clusters.',
'Cassandra\Cluster\Builder::withPort' => 'Specify a different port to be used when connecting to the cluster.',
'Cassandra\Cluster\Builder::withProtocolVersion' => 'Force the driver to use a specific binary protocol version.

Apache Cassandra 1.2+ supports protocol version 1
Apache Cassandra 2.0+ supports protocol version 2
Apache Cassandra 2.1+ supports protocol version 3
Apache Cassandra 2.2+ supports protocol version 4

NOTE: Apache Cassandra 3.x supports protocol version 3 and 4 only',
'Cassandra\Cluster\Builder::withRandomizedContactPoints' => 'Enables/disables Randomized Contact Points.

If enabled this allows the driver randomly use contact points in order
to evenly spread the load across the cluster and prevent
hotspots/load spikes during notifications (e.g. massive schema change).

Note: This setting should only be disabled for debugging and testing.',
'Cassandra\Cluster\Builder::withReconnectInterval' => 'Specify interval in seconds that the driver should wait before attempting
to re-establish a closed connection.',
'Cassandra\Cluster\Builder::withRequestTimeout' => 'Timeout used for waiting for a response from a node.',
'Cassandra\Cluster\Builder::withRetryPolicy' => 'Configures the retry policy.',
'Cassandra\Cluster\Builder::withRoundRobinLoadBalancingPolicy' => 'Configures this cluster to use a round robin load balancing policy.',
'Cassandra\Cluster\Builder::withSchemaMetadata' => 'Enables/disables Schema Metadata.

If disabled this allows the driver to skip over retrieving and
updating schema metadata, but it also disables the usage of token-aware
routing and $session->schema() will always return an empty object. This
can be useful for reducing the startup overhead of short-lived sessions.',
'Cassandra\Cluster\Builder::withSSL' => 'Set up ssl context.',
'Cassandra\Cluster\Builder::withTCPKeepalive' => 'Enables/disables TCP keepalive.',
'Cassandra\Cluster\Builder::withTCPNodelay' => 'Disables nagle algorithm for lower latency.',
'Cassandra\Cluster\Builder::withTimestampGenerator' => 'Sets the timestamp generator.',
'Cassandra\Cluster\Builder::withTokenAwareRouting' => 'Enable token aware routing.',
'Cassandra\Cluster\Builder::withWhiteListDCs' => 'Sets the whitelist datacenters. Any host not in a whitelisted datacenter
will be ignored. This policy is useful for ensuring the driver will only
connect to hosts in specific datacenters.',
'Cassandra\Cluster\Builder::withWhiteListHosts' => 'Sets the whitelist hosts. Any host not in the whitelist will be ignored
and a connection will not be established. This policy is useful for
ensuring that the driver will only connect to a predefined set of hosts.',
'Cassandra\Collection::__construct' => 'Creates a new collection of a given type.',
'Cassandra\Collection::add' => 'Adds one or more values to this collection.',
'Cassandra\Collection::count' => 'Total number of elements in this collection',
'Cassandra\Collection::current' => 'Current element for iteration',
'Cassandra\Collection::find' => 'Finds index of a value in this collection.',
'Cassandra\Collection::get' => 'Retrieves the value at a given index.',
'Cassandra\Collection::key' => 'Current key for iteration',
'Cassandra\Collection::next' => 'Move internal iterator forward',
'Cassandra\Collection::remove' => 'Deletes the value at a given index',
'Cassandra\Collection::rewind' => 'Rewind internal iterator',
'Cassandra\Collection::type' => 'The type of this collection.',
'Cassandra\Collection::valid' => 'Check whether a current value exists',
'Cassandra\Collection::values' => 'Array of values in this collection.',
'Cassandra\Column::indexName' => 'Returns name of the index if defined.',
'Cassandra\Column::indexOptions' => 'Returns index options if present.',
'Cassandra\Column::isFrozen' => 'Returns true for frozen columns.',
'Cassandra\Column::isReversed' => 'Returns whether the column is in descending or ascending order.',
'Cassandra\Column::isStatic' => 'Returns true for static columns.',
'Cassandra\Column::name' => 'Returns the name of the column.',
'Cassandra\Column::type' => 'Returns the type of the column.',
'Cassandra\Custom::type' => 'The type of this value.',
'Cassandra\Date::__construct' => 'Creates a new Date object',
'Cassandra\Date::__toString' => '`@return string` this date in string format: Date(seconds=$seconds)',
'Cassandra\Date::fromDateTime' => 'Creates a new Date object from a \DateTime object.',
'Cassandra\Date::seconds' => '`@return int` Absolute seconds from epoch (1970, 1, 1), can be negative',
'Cassandra\Date::toDateTime' => 'Converts current date to PHP DateTime.',
'Cassandra\Date::type' => 'The type of this date.',
'Cassandra\Decimal::__construct' => 'Creates a decimal from a given decimal string:

~~~{.php}
<?php
$decimal = new Cassandra::Decimal("1313123123.234234234234234234123");
~~~',
'Cassandra\Decimal::__toString' => 'String representation of this decimal.',
'Cassandra\Decimal::abs' => '`@return \Cassandra\Numeric` absolute value',
'Cassandra\Decimal::add' => '`@return \Cassandra\Numeric` sum',
'Cassandra\Decimal::div' => '`@return \Cassandra\Numeric` quotient',
'Cassandra\Decimal::mod' => '`@return \Cassandra\Numeric` remainder',
'Cassandra\Decimal::mul' => '`@return \Cassandra\Numeric` product',
'Cassandra\Decimal::neg' => '`@return \Cassandra\Numeric` negative value',
'Cassandra\Decimal::scale' => 'Scale of this decimal as int.',
'Cassandra\Decimal::sqrt' => '`@return \Cassandra\Numeric` square root',
'Cassandra\Decimal::sub' => '`@return \Cassandra\Numeric` difference',
'Cassandra\Decimal::toDouble' => '`@return float` this number as float',
'Cassandra\Decimal::toInt' => '`@return int` this number as int',
'Cassandra\Decimal::type' => 'The type of this decimal.',
'Cassandra\Decimal::value' => 'Numeric value of this decimal as string.',
'Cassandra\DefaultAggregate::argumentTypes' => 'Returns the argument types of the aggregate',
'Cassandra\DefaultAggregate::finalFunction' => 'Returns the final function of the aggregate',
'Cassandra\DefaultAggregate::initialCondition' => 'Returns the initial condition of the aggregate',
'Cassandra\DefaultAggregate::name' => 'Returns the full name of the aggregate',
'Cassandra\DefaultAggregate::returnType' => 'Returns the return type of the aggregate',
'Cassandra\DefaultAggregate::signature' => 'Returns the signature of the aggregate',
'Cassandra\DefaultAggregate::simpleName' => 'Returns the simple name of the aggregate',
'Cassandra\DefaultAggregate::stateFunction' => 'Returns the state function of the aggregate',
'Cassandra\DefaultAggregate::stateType' => 'Returns the state type of the aggregate',
'Cassandra\DefaultCluster::connect' => 'Creates a new Session instance.',
'Cassandra\DefaultCluster::connectAsync' => 'Creates a new Session instance.',
'Cassandra\DefaultColumn::indexName' => 'Returns name of the index if defined.',
'Cassandra\DefaultColumn::indexOptions' => 'Returns index options if present.',
'Cassandra\DefaultColumn::isFrozen' => 'Returns true for frozen columns.',
'Cassandra\DefaultColumn::isReversed' => 'Returns whether the column is in descending or ascending order.',
'Cassandra\DefaultColumn::isStatic' => 'Returns true for static columns.',
'Cassandra\DefaultColumn::name' => 'Returns the name of the column.',
'Cassandra\DefaultColumn::type' => 'Returns the type of the column.',
'Cassandra\DefaultFunction::arguments' => 'Returns the arguments of the function',
'Cassandra\DefaultFunction::body' => 'Returns the body of the function',
'Cassandra\DefaultFunction::isCalledOnNullInput' => 'Determines if a function is called when the value is null.',
'Cassandra\DefaultFunction::language' => 'Returns the lanuage of the function',
'Cassandra\DefaultFunction::name' => 'Returns the full name of the function',
'Cassandra\DefaultFunction::returnType' => 'Returns the return type of the function',
'Cassandra\DefaultFunction::signature' => 'Returns the signature of the function',
'Cassandra\DefaultFunction::simpleName' => 'Returns the simple name of the function',
'Cassandra\DefaultIndex::className' => 'Returns the class name of the index',
'Cassandra\DefaultIndex::isCustom' => 'Determines if the index is a custom index.',
'Cassandra\DefaultIndex::kind' => 'Returns the kind of index',
'Cassandra\DefaultIndex::name' => 'Returns the name of the index',
'Cassandra\DefaultIndex::option' => 'Return a column\'s option by name',
'Cassandra\DefaultIndex::options' => 'Returns all the index\'s options',
'Cassandra\DefaultIndex::target' => 'Returns the target column of the index',
'Cassandra\DefaultKeyspace::aggregate' => 'Get an aggregate by name and signature',
'Cassandra\DefaultKeyspace::aggregates' => 'Get all aggregates',
'Cassandra\DefaultKeyspace::function_' => 'Get a function by name and signature',
'Cassandra\DefaultKeyspace::functions' => 'Get all functions',
'Cassandra\DefaultKeyspace::hasDurableWrites' => 'Returns whether the keyspace has durable writes enabled',
'Cassandra\DefaultKeyspace::materializedView' => 'Get materialized view by name',
'Cassandra\DefaultKeyspace::materializedViews' => 'Gets all materialized views',
'Cassandra\DefaultKeyspace::name' => 'Returns keyspace name',
'Cassandra\DefaultKeyspace::replicationClassName' => 'Returns replication class name',
'Cassandra\DefaultKeyspace::replicationOptions' => 'Returns replication options',
'Cassandra\DefaultKeyspace::table' => 'Returns a table by name',
'Cassandra\DefaultKeyspace::tables' => 'Returns all tables defined in this keyspace',
'Cassandra\DefaultKeyspace::userType' => 'Get user type by name',
'Cassandra\DefaultKeyspace::userTypes' => 'Get all user types',
'Cassandra\DefaultMaterializedView::baseTable' => 'Returns the base table of the view',
'Cassandra\DefaultMaterializedView::bloomFilterFPChance' => 'Returns bloom filter FP chance',
'Cassandra\DefaultMaterializedView::caching' => 'Returns caching options',
'Cassandra\DefaultMaterializedView::clusteringKey' => 'Returns the clustering key columns of the view',
'Cassandra\DefaultMaterializedView::clusteringOrder' => '`@return array` A list of cluster column orders (\'asc\' and \'desc\')',
'Cassandra\DefaultMaterializedView::column' => 'Returns column by name',
'Cassandra\DefaultMaterializedView::columns' => 'Returns all columns in this view',
'Cassandra\DefaultMaterializedView::comment' => 'Description of the view, if any',
'Cassandra\DefaultMaterializedView::compactionStrategyClassName' => 'Returns compaction strategy class name',
'Cassandra\DefaultMaterializedView::compactionStrategyOptions' => 'Returns compaction strategy options',
'Cassandra\DefaultMaterializedView::compressionParameters' => 'Returns compression parameters',
'Cassandra\DefaultMaterializedView::defaultTTL' => 'Returns default TTL.',
'Cassandra\DefaultMaterializedView::gcGraceSeconds' => 'Returns GC grace seconds',
'Cassandra\DefaultMaterializedView::indexInterval' => 'Returns index interval',
'Cassandra\DefaultMaterializedView::localReadRepairChance' => 'Returns local read repair chance',
'Cassandra\DefaultMaterializedView::maxIndexInterval' => 'Returns the value of `max_index_interval`',
'Cassandra\DefaultMaterializedView::memtableFlushPeriodMs' => 'Returns memtable flush period in milliseconds',
'Cassandra\DefaultMaterializedView::minIndexInterval' => 'Returns the value of `min_index_interval`',
'Cassandra\DefaultMaterializedView::name' => 'Returns the name of this view',
'Cassandra\DefaultMaterializedView::option' => 'Return a view\'s option by name',
'Cassandra\DefaultMaterializedView::options' => 'Returns all the view\'s options',
'Cassandra\DefaultMaterializedView::partitionKey' => 'Returns the partition key columns of the view',
'Cassandra\DefaultMaterializedView::populateIOCacheOnFlush' => 'Returns whether or not the `populate_io_cache_on_flush` is true',
'Cassandra\DefaultMaterializedView::primaryKey' => 'Returns both the partition and clustering key columns of the view',
'Cassandra\DefaultMaterializedView::readRepairChance' => 'Returns read repair chance',
'Cassandra\DefaultMaterializedView::replicateOnWrite' => 'Returns whether or not the `replicate_on_write` is true',
'Cassandra\DefaultMaterializedView::speculativeRetry' => 'Returns speculative retry.',
'Cassandra\DefaultSchema::keyspace' => 'Returns a Keyspace instance by name.',
'Cassandra\DefaultSchema::keyspaces' => 'Returns all keyspaces defined in the schema.',
'Cassandra\DefaultSchema::version' => 'Get the version of the schema snapshot',
'Cassandra\DefaultSession::close' => 'Close the session and all its connections.',
'Cassandra\DefaultSession::closeAsync' => 'Asynchronously close the session and all its connections.',
'Cassandra\DefaultSession::execute' => 'Execute a query.

Available execution options:
| Option Name        | Option **Type** | Option Details                                                                                           |
|--------------------|-----------------|----------------------------------------------------------------------------------------------------------|
| arguments          | array           | An array or positional or named arguments                                                                |
| consistency        | int             | A consistency constant e.g Dse::CONSISTENCY_ONE, Dse::CONSISTENCY_QUORUM, etc.                           |
| timeout            | int             | A number of rows to include in result for paging                                                         |
| paging_state_token | string          | A string token use to resume from the state of a previous result set                                     |
| retry_policy       | RetryPolicy     | A retry policy that is used to handle server-side failures for this request                              |
| serial_consistency | int             | Either Dse::CONSISTENCY_SERIAL or Dse::CONSISTENCY_LOCAL_SERIAL                                          |
| timestamp          | int\|string     | Either an integer or integer string timestamp that represents the number of microseconds since the epoch |
| execute_as         | string          | User to execute statement as                                                                             |',
'Cassandra\DefaultSession::executeAsync' => 'Execute a query asynchronously. This method returns immediately, but
the query continues execution in the background.',
'Cassandra\DefaultSession::metrics' => 'Get performance and diagnostic metrics.',
'Cassandra\DefaultSession::prepare' => 'Prepare a query for execution.',
'Cassandra\DefaultSession::prepareAsync' => 'Asynchronously prepare a query for execution.',
'Cassandra\DefaultSession::schema' => 'Get a snapshot of the cluster\'s current schema.',
'Cassandra\DefaultTable::bloomFilterFPChance' => 'Returns bloom filter FP chance',
'Cassandra\DefaultTable::caching' => 'Returns caching options',
'Cassandra\DefaultTable::clusteringKey' => 'Returns the clustering key columns of the table',
'Cassandra\DefaultTable::clusteringOrder' => '`@return array` A list of cluster column orders (\'asc\' and \'desc\')',
'Cassandra\DefaultTable::column' => 'Returns column by name',
'Cassandra\DefaultTable::columns' => 'Returns all columns in this table',
'Cassandra\DefaultTable::comment' => 'Description of the table, if any',
'Cassandra\DefaultTable::compactionStrategyClassName' => 'Returns compaction strategy class name',
'Cassandra\DefaultTable::compactionStrategyOptions' => 'Returns compaction strategy options',
'Cassandra\DefaultTable::compressionParameters' => 'Returns compression parameters',
'Cassandra\DefaultTable::defaultTTL' => 'Returns default TTL.',
'Cassandra\DefaultTable::gcGraceSeconds' => 'Returns GC grace seconds',
'Cassandra\DefaultTable::index' => 'Get an index by name',
'Cassandra\DefaultTable::indexes' => 'Gets all indexes',
'Cassandra\DefaultTable::indexInterval' => 'Returns index interval',
'Cassandra\DefaultTable::localReadRepairChance' => 'Returns local read repair chance',
'Cassandra\DefaultTable::materializedView' => 'Get materialized view by name',
'Cassandra\DefaultTable::materializedViews' => 'Gets all materialized views',
'Cassandra\DefaultTable::maxIndexInterval' => 'Returns the value of `max_index_interval`',
'Cassandra\DefaultTable::memtableFlushPeriodMs' => 'Returns memtable flush period in milliseconds',
'Cassandra\DefaultTable::minIndexInterval' => 'Returns the value of `min_index_interval`',
'Cassandra\DefaultTable::name' => 'Returns the name of this table',
'Cassandra\DefaultTable::option' => 'Return a table\'s option by name',
'Cassandra\DefaultTable::options' => 'Returns all the table\'s options',
'Cassandra\DefaultTable::partitionKey' => 'Returns the partition key columns of the table',
'Cassandra\DefaultTable::populateIOCacheOnFlush' => 'Returns whether or not the `populate_io_cache_on_flush` is true',
'Cassandra\DefaultTable::primaryKey' => 'Returns both the partition and clustering key columns of the table',
'Cassandra\DefaultTable::readRepairChance' => 'Returns read repair chance',
'Cassandra\DefaultTable::replicateOnWrite' => 'Returns whether or not the `replicate_on_write` is true',
'Cassandra\DefaultTable::speculativeRetry' => 'Returns speculative retry.',
'Cassandra\Duration::__toString' => '`@return string` string representation of this Duration; may be used as a literal parameter in CQL queries.',
'Cassandra\Duration::days' => '`@return string` the days attribute of this Duration',
'Cassandra\Duration::months' => '`@return string` the months attribute of this Duration',
'Cassandra\Duration::nanos' => '`@return string` the nanoseconds attribute of this Duration',
'Cassandra\Duration::type' => 'The type of represented by the value.',
'Cassandra\Exception\AlreadyExistsException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\AlreadyExistsException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\AlreadyExistsException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\AlreadyExistsException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\AlreadyExistsException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\AlreadyExistsException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\AlreadyExistsException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\AlreadyExistsException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\AuthenticationException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\AuthenticationException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\AuthenticationException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\AuthenticationException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\AuthenticationException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\AuthenticationException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\AuthenticationException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\AuthenticationException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\ConfigurationException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\ConfigurationException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\ConfigurationException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\ConfigurationException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\ConfigurationException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\ConfigurationException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\ConfigurationException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\ConfigurationException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\DivideByZeroException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\DivideByZeroException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\DivideByZeroException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\DivideByZeroException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\DivideByZeroException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\DivideByZeroException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\DivideByZeroException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\DivideByZeroException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\DomainException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\DomainException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\DomainException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\DomainException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\DomainException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\DomainException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\DomainException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\DomainException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\ExecutionException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\ExecutionException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\ExecutionException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\ExecutionException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\ExecutionException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\ExecutionException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\ExecutionException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\ExecutionException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\InvalidArgumentException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\InvalidArgumentException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\InvalidArgumentException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\InvalidArgumentException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\InvalidArgumentException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\InvalidArgumentException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\InvalidArgumentException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\InvalidArgumentException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\InvalidQueryException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\InvalidQueryException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\InvalidQueryException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\InvalidQueryException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\InvalidQueryException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\InvalidQueryException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\InvalidQueryException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\InvalidQueryException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\InvalidSyntaxException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\InvalidSyntaxException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\InvalidSyntaxException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\InvalidSyntaxException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\InvalidSyntaxException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\InvalidSyntaxException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\InvalidSyntaxException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\InvalidSyntaxException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\IsBootstrappingException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\IsBootstrappingException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\IsBootstrappingException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\IsBootstrappingException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\IsBootstrappingException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\IsBootstrappingException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\IsBootstrappingException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\IsBootstrappingException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\LogicException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\LogicException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\LogicException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\LogicException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\LogicException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\LogicException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\LogicException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\LogicException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\OverloadedException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\OverloadedException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\OverloadedException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\OverloadedException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\OverloadedException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\OverloadedException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\OverloadedException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\OverloadedException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\ProtocolException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\ProtocolException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\ProtocolException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\ProtocolException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\ProtocolException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\ProtocolException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\ProtocolException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\ProtocolException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\RangeException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\RangeException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\RangeException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\RangeException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\RangeException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\RangeException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\RangeException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\RangeException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\ReadTimeoutException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\ReadTimeoutException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\ReadTimeoutException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\ReadTimeoutException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\ReadTimeoutException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\ReadTimeoutException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\ReadTimeoutException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\ReadTimeoutException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\RuntimeException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\RuntimeException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\RuntimeException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\RuntimeException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\RuntimeException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\RuntimeException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\RuntimeException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\RuntimeException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\ServerException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\ServerException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\ServerException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\ServerException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\ServerException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\ServerException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\ServerException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\ServerException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\TimeoutException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\TimeoutException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\TimeoutException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\TimeoutException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\TimeoutException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\TimeoutException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\TimeoutException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\TimeoutException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\TruncateException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\TruncateException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\TruncateException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\TruncateException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\TruncateException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\TruncateException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\TruncateException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\TruncateException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\UnauthorizedException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\UnauthorizedException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\UnauthorizedException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\UnauthorizedException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\UnauthorizedException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\UnauthorizedException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\UnauthorizedException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\UnauthorizedException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\UnavailableException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\UnavailableException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\UnavailableException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\UnavailableException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\UnavailableException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\UnavailableException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\UnavailableException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\UnavailableException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\UnpreparedException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\UnpreparedException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\UnpreparedException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\UnpreparedException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\UnpreparedException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\UnpreparedException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\UnpreparedException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\UnpreparedException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\ValidationException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\ValidationException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\ValidationException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\ValidationException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\ValidationException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\ValidationException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\ValidationException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\ValidationException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\Exception\WriteTimeoutException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Cassandra\Exception\WriteTimeoutException::getCode' => 'Gets the Exception code',
'Cassandra\Exception\WriteTimeoutException::getFile' => 'Gets the file in which the exception occurred',
'Cassandra\Exception\WriteTimeoutException::getLine' => 'Gets the line in which the exception occurred',
'Cassandra\Exception\WriteTimeoutException::getMessage' => 'Gets the Exception message',
'Cassandra\Exception\WriteTimeoutException::getPrevious' => 'Returns previous Exception',
'Cassandra\Exception\WriteTimeoutException::getTrace' => 'Gets the stack trace',
'Cassandra\Exception\WriteTimeoutException::getTraceAsString' => 'Gets the stack trace as a string',
'Cassandra\ExecutionOptions::__construct' => 'Creates a new options object for execution.',
'Cassandra\Float_::__construct' => 'Creates a new float.',
'Cassandra\Float_::__toString' => 'Returns string representation of the float value.',
'Cassandra\Float_::abs' => '`@return \Cassandra\Numeric` absolute value',
'Cassandra\Float_::add' => '`@return \Cassandra\Numeric` sum',
'Cassandra\Float_::div' => '`@return \Cassandra\Numeric` quotient',
'Cassandra\Float_::max' => 'Maximum possible Float value',
'Cassandra\Float_::min' => 'Minimum possible Float value',
'Cassandra\Float_::mod' => '`@return \Cassandra\Numeric` remainder',
'Cassandra\Float_::mul' => '`@return \Cassandra\Numeric` product',
'Cassandra\Float_::neg' => '`@return \Cassandra\Numeric` negative value',
'Cassandra\Float_::sqrt' => '`@return \Cassandra\Numeric` square root',
'Cassandra\Float_::sub' => '`@return \Cassandra\Numeric` difference',
'Cassandra\Float_::toDouble' => '`@return float` this number as float',
'Cassandra\Float_::toInt' => '`@return int` this number as int',
'Cassandra\Float_::type' => 'The type of this float.',
'Cassandra\Float_::value' => 'Returns the float value.',
'Cassandra\Function_::arguments' => 'Returns the arguments of the function',
'Cassandra\Function_::body' => 'Returns the body of the function',
'Cassandra\Function_::isCalledOnNullInput' => 'Determines if a function is called when the value is null.',
'Cassandra\Function_::language' => 'Returns the lanuage of the function',
'Cassandra\Function_::name' => 'Returns the full name of the function',
'Cassandra\Function_::returnType' => 'Returns the return type of the function',
'Cassandra\Function_::signature' => 'Returns the signature of the function',
'Cassandra\Function_::simpleName' => 'Returns the simple name of the function',
'Cassandra\Future::get' => 'Waits for a given future resource to resolve and throws errors if any.',
'Cassandra\FutureClose::get' => 'Waits for a given future resource to resolve and throws errors if any.',
'Cassandra\FuturePreparedStatement::get' => 'Waits for a given future resource to resolve and throws errors if any.',
'Cassandra\FutureRows::get' => 'Waits for a given future resource to resolve and throws errors if any.',
'Cassandra\FutureSession::get' => 'Waits for a given future resource to resolve and throws errors if any.',
'Cassandra\FutureValue::get' => 'Waits for a given future resource to resolve and throws errors if any.',
'Cassandra\Index::className' => 'Returns the class name of the index',
'Cassandra\Index::isCustom' => 'Determines if the index is a custom index.',
'Cassandra\Index::kind' => 'Returns the kind of index',
'Cassandra\Index::name' => 'Returns the name of the index',
'Cassandra\Index::option' => 'Return a column\'s option by name',
'Cassandra\Index::options' => 'Returns all the index\'s options',
'Cassandra\Index::target' => 'Returns the target column of the index',
'Cassandra\Inet::__construct' => 'Creates a new IPv4 or IPv6 inet address.',
'Cassandra\Inet::__toString' => 'Returns the normalized string representation of the address.',
'Cassandra\Inet::address' => 'Returns the normalized string representation of the address.',
'Cassandra\Inet::type' => 'The type of this inet.',
'Cassandra\Keyspace::aggregate' => 'Get an aggregate by name and signature',
'Cassandra\Keyspace::aggregates' => 'Get all aggregates',
'Cassandra\Keyspace::function_' => 'Get a function by name and signature',
'Cassandra\Keyspace::functions' => 'Get all functions',
'Cassandra\Keyspace::hasDurableWrites' => 'Returns whether the keyspace has durable writes enabled',
'Cassandra\Keyspace::materializedView' => 'Get materialized view by name',
'Cassandra\Keyspace::materializedViews' => 'Gets all materialized views',
'Cassandra\Keyspace::name' => 'Returns keyspace name',
'Cassandra\Keyspace::replicationClassName' => 'Returns replication class name',
'Cassandra\Keyspace::replicationOptions' => 'Returns replication options',
'Cassandra\Keyspace::table' => 'Returns a table by name',
'Cassandra\Keyspace::tables' => 'Returns all tables defined in this keyspace',
'Cassandra\Keyspace::userType' => 'Get user type by name',
'Cassandra\Keyspace::userTypes' => 'Get all user types',
'Cassandra\Map::__construct' => 'Creates a new map of a given key and value type.',
'Cassandra\Map::count' => 'Total number of elements in this map',
'Cassandra\Map::current' => 'Current value for iteration',
'Cassandra\Map::get' => 'Gets the value of the key in the map.',
'Cassandra\Map::has' => 'Returns whether the key is in the map.',
'Cassandra\Map::key' => 'Current key for iteration',
'Cassandra\Map::keys' => 'Returns all keys in the map as an array.',
'Cassandra\Map::next' => 'Move internal iterator forward',
'Cassandra\Map::offsetExists' => 'Returns whether the value a given key is present',
'Cassandra\Map::offsetGet' => 'Retrieves the value at a given key',
'Cassandra\Map::offsetSet' => 'Sets the value at a given key',
'Cassandra\Map::offsetUnset' => 'Deletes the value at a given key',
'Cassandra\Map::remove' => 'Removes the key from the map.',
'Cassandra\Map::rewind' => 'Rewind internal iterator',
'Cassandra\Map::set' => 'Sets key/value in the map.',
'Cassandra\Map::type' => 'The type of this map.',
'Cassandra\Map::valid' => 'Check whether a current value exists',
'Cassandra\Map::values' => 'Returns all values in the map as an array.',
'Cassandra\MaterializedView::baseTable' => 'Returns the base table of the view',
'Cassandra\MaterializedView::bloomFilterFPChance' => 'Returns bloom filter FP chance',
'Cassandra\MaterializedView::caching' => 'Returns caching options',
'Cassandra\MaterializedView::clusteringKey' => 'Returns the clustering key columns of the view',
'Cassandra\MaterializedView::clusteringOrder' => '`@return array` A list of cluster column orders (\'asc\' and \'desc\')',
'Cassandra\MaterializedView::column' => 'Returns column by name',
'Cassandra\MaterializedView::columns' => 'Returns all columns in this view',
'Cassandra\MaterializedView::comment' => 'Description of the view, if any',
'Cassandra\MaterializedView::compactionStrategyClassName' => 'Returns compaction strategy class name',
'Cassandra\MaterializedView::compactionStrategyOptions' => 'Returns compaction strategy options',
'Cassandra\MaterializedView::compressionParameters' => 'Returns compression parameters',
'Cassandra\MaterializedView::defaultTTL' => 'Returns default TTL.',
'Cassandra\MaterializedView::gcGraceSeconds' => 'Returns GC grace seconds',
'Cassandra\MaterializedView::indexInterval' => 'Returns index interval',
'Cassandra\MaterializedView::localReadRepairChance' => 'Returns local read repair chance',
'Cassandra\MaterializedView::maxIndexInterval' => 'Returns the value of `max_index_interval`',
'Cassandra\MaterializedView::memtableFlushPeriodMs' => 'Returns memtable flush period in milliseconds',
'Cassandra\MaterializedView::minIndexInterval' => 'Returns the value of `min_index_interval`',
'Cassandra\MaterializedView::name' => 'Returns the name of this view',
'Cassandra\MaterializedView::option' => 'Return a view\'s option by name',
'Cassandra\MaterializedView::options' => 'Returns all the view\'s options',
'Cassandra\MaterializedView::partitionKey' => 'Returns the partition key columns of the view',
'Cassandra\MaterializedView::populateIOCacheOnFlush' => 'Returns whether or not the `populate_io_cache_on_flush` is true',
'Cassandra\MaterializedView::primaryKey' => 'Returns both the partition and clustering key columns of the view',
'Cassandra\MaterializedView::readRepairChance' => 'Returns read repair chance',
'Cassandra\MaterializedView::replicateOnWrite' => 'Returns whether or not the `replicate_on_write` is true',
'Cassandra\MaterializedView::speculativeRetry' => 'Returns speculative retry.',
'Cassandra\Numeric::abs' => '`@return \Cassandra\Numeric` absolute value',
'Cassandra\Numeric::add' => '`@return \Cassandra\Numeric` sum',
'Cassandra\Numeric::div' => '`@return \Cassandra\Numeric` quotient',
'Cassandra\Numeric::mod' => '`@return \Cassandra\Numeric` remainder',
'Cassandra\Numeric::mul' => '`@return \Cassandra\Numeric` product',
'Cassandra\Numeric::neg' => '`@return \Cassandra\Numeric` negative value',
'Cassandra\Numeric::sqrt' => '`@return \Cassandra\Numeric` square root',
'Cassandra\Numeric::sub' => '`@return \Cassandra\Numeric` difference',
'Cassandra\Numeric::toDouble' => '`@return float` this number as float',
'Cassandra\Numeric::toInt' => '`@return int` this number as int',
'Cassandra\RetryPolicy\Logging::__construct' => 'Creates a new Logging retry policy.',
'Cassandra\Rows::count' => 'Returns the number of rows.',
'Cassandra\Rows::current' => 'Returns current row.',
'Cassandra\Rows::first' => 'Get the first row.',
'Cassandra\Rows::isLastPage' => 'Check for the last page when paging.',
'Cassandra\Rows::key' => 'Returns current index.',
'Cassandra\Rows::next' => 'Advances the rows iterator by one.',
'Cassandra\Rows::nextPage' => 'Get the next page of results.',
'Cassandra\Rows::nextPageAsync' => 'Get the next page of results asynchronously.',
'Cassandra\Rows::offsetExists' => 'Returns existence of a given row.',
'Cassandra\Rows::offsetGet' => 'Returns a row at given index.',
'Cassandra\Rows::offsetSet' => 'Sets a row at given index.',
'Cassandra\Rows::offsetUnset' => 'Removes a row at given index.',
'Cassandra\Rows::pagingStateToken' => 'Returns the raw paging state token.',
'Cassandra\Rows::rewind' => 'Resets the rows iterator.',
'Cassandra\Rows::valid' => 'Returns existence of more rows being available.',
'Cassandra\Schema::keyspace' => 'Returns a Keyspace instance by name.',
'Cassandra\Schema::keyspaces' => 'Returns all keyspaces defined in the schema.',
'Cassandra\Session::close' => 'Close the session and all its connections.',
'Cassandra\Session::closeAsync' => 'Asynchronously close the session and all its connections.',
'Cassandra\Session::execute' => 'Execute a query.

Available execution options:
| Option Name        | Option **Type** | Option Details                                                                                           |
|--------------------|-----------------|----------------------------------------------------------------------------------------------------------|
| arguments          | array           | An array or positional or named arguments                                                                |
| consistency        | int             | A consistency constant e.g Dse::CONSISTENCY_ONE, Dse::CONSISTENCY_QUORUM, etc.                           |
| timeout            | int             | A number of rows to include in result for paging                                                         |
| paging_state_token | string          | A string token use to resume from the state of a previous result set                                     |
| retry_policy       | RetryPolicy     | A retry policy that is used to handle server-side failures for this request                              |
| serial_consistency | int             | Either Dse::CONSISTENCY_SERIAL or Dse::CONSISTENCY_LOCAL_SERIAL                                          |
| timestamp          | int\|string     | Either an integer or integer string timestamp that represents the number of microseconds since the epoch |
| execute_as         | string          | User to execute statement as                                                                             |',
'Cassandra\Session::executeAsync' => 'Execute a query asynchronously. This method returns immediately, but
the query continues execution in the background.',
'Cassandra\Session::metrics' => 'Get performance and diagnostic metrics.',
'Cassandra\Session::prepare' => 'Prepare a query for execution.',
'Cassandra\Session::prepareAsync' => 'Asynchronously prepare a query for execution.',
'Cassandra\Session::schema' => 'Get a snapshot of the cluster\'s current schema.',
'Cassandra\Set::__construct' => 'Creates a new collection of a given type.',
'Cassandra\Set::add' => 'Adds a value to this set.',
'Cassandra\Set::count' => 'Total number of elements in this set',
'Cassandra\Set::current' => 'Current element for iteration',
'Cassandra\Set::has' => 'Returns whether a value is in this set.',
'Cassandra\Set::key' => 'Current key for iteration',
'Cassandra\Set::next' => 'Move internal iterator forward',
'Cassandra\Set::remove' => 'Removes a value to this set.',
'Cassandra\Set::rewind' => 'Rewind internal iterator',
'Cassandra\Set::type' => 'The type of this set.',
'Cassandra\Set::valid' => 'Check whether a current value exists',
'Cassandra\Set::values' => 'Array of values in this set.',
'Cassandra\SimpleStatement::__construct' => 'Creates a new simple statement with the provided CQL.',
'Cassandra\Smallint::__construct' => 'Creates a new 16-bit signed integer.',
'Cassandra\Smallint::abs' => '`@return \Cassandra\Numeric` absolute value',
'Cassandra\Smallint::add' => '`@return \Cassandra\Numeric` sum',
'Cassandra\Smallint::div' => '`@return \Cassandra\Numeric` quotient',
'Cassandra\Smallint::max' => 'Maximum possible Smallint value',
'Cassandra\Smallint::min' => 'Minimum possible Smallint value',
'Cassandra\Smallint::mod' => '`@return \Cassandra\Numeric` remainder',
'Cassandra\Smallint::mul' => '`@return \Cassandra\Numeric` product',
'Cassandra\Smallint::neg' => '`@return \Cassandra\Numeric` negative value',
'Cassandra\Smallint::sqrt' => '`@return \Cassandra\Numeric` square root',
'Cassandra\Smallint::sub' => '`@return \Cassandra\Numeric` difference',
'Cassandra\Smallint::toDouble' => '`@return float` this number as float',
'Cassandra\Smallint::toInt' => '`@return int` this number as int',
'Cassandra\Smallint::type' => 'The type of this value (smallint).',
'Cassandra\Smallint::value' => 'Returns the integer value.',
'Cassandra\SSLOptions\Builder::build' => 'Builds SSL options.',
'Cassandra\SSLOptions\Builder::withClientCert' => 'Set client-side certificate chain.

This is used to authenticate the client on the server-side. This should contain the entire Certificate
chain starting with the certificate itself.',
'Cassandra\SSLOptions\Builder::withPrivateKey' => 'Set client-side private key. This is used to authenticate the client on
the server-side.',
'Cassandra\SSLOptions\Builder::withTrustedCerts' => 'Adds a trusted certificate. This is used to verify node\'s identity.',
'Cassandra\SSLOptions\Builder::withVerifyFlags' => 'Disable certificate verification.',
'Cassandra\Table::bloomFilterFPChance' => 'Returns bloom filter FP chance',
'Cassandra\Table::caching' => 'Returns caching options',
'Cassandra\Table::clusteringKey' => 'Returns the clustering key columns of the table',
'Cassandra\Table::clusteringOrder' => '`@return array` A list of cluster column orders (\'asc\' and \'desc\')',
'Cassandra\Table::column' => 'Returns column by name',
'Cassandra\Table::columns' => 'Returns all columns in this table',
'Cassandra\Table::comment' => 'Description of the table, if any',
'Cassandra\Table::compactionStrategyClassName' => 'Returns compaction strategy class name',
'Cassandra\Table::compactionStrategyOptions' => 'Returns compaction strategy options',
'Cassandra\Table::compressionParameters' => 'Returns compression parameters',
'Cassandra\Table::defaultTTL' => 'Returns default TTL.',
'Cassandra\Table::gcGraceSeconds' => 'Returns GC grace seconds',
'Cassandra\Table::indexInterval' => 'Returns index interval',
'Cassandra\Table::localReadRepairChance' => 'Returns local read repair chance',
'Cassandra\Table::maxIndexInterval' => 'Returns the value of `max_index_interval`',
'Cassandra\Table::memtableFlushPeriodMs' => 'Returns memtable flush period in milliseconds',
'Cassandra\Table::minIndexInterval' => 'Returns the value of `min_index_interval`',
'Cassandra\Table::name' => 'Returns the name of this table',
'Cassandra\Table::option' => 'Return a table\'s option by name',
'Cassandra\Table::options' => 'Returns all the table\'s options',
'Cassandra\Table::partitionKey' => 'Returns the partition key columns of the table',
'Cassandra\Table::populateIOCacheOnFlush' => 'Returns whether or not the `populate_io_cache_on_flush` is true',
'Cassandra\Table::primaryKey' => 'Returns both the partition and clustering key columns of the table',
'Cassandra\Table::readRepairChance' => 'Returns read repair chance',
'Cassandra\Table::replicateOnWrite' => 'Returns whether or not the `replicate_on_write` is true',
'Cassandra\Table::speculativeRetry' => 'Returns speculative retry.',
'Cassandra\Time::__construct' => 'Creates a new Time object',
'Cassandra\Time::__toString' => '`@return string` this date in string format: Time(nanoseconds=$nanoseconds)',
'Cassandra\Time::type' => 'The type of this date.',
'Cassandra\Timestamp::__construct' => 'Creates a new timestamp from either unix timestamp and microseconds or
from the current time by default.',
'Cassandra\Timestamp::__toString' => 'Returns a string representation of this timestamp.',
'Cassandra\Timestamp::microtime' => 'Microtime from this timestamp',
'Cassandra\Timestamp::time' => 'Unix timestamp.',
'Cassandra\Timestamp::toDateTime' => 'Converts current timestamp to PHP DateTime.',
'Cassandra\Timestamp::type' => 'The type of this timestamp.',
'Cassandra\Timeuuid::__construct' => 'Creates a timeuuid from a given timestamp or current time.',
'Cassandra\Timeuuid::__toString' => 'Returns this timeuuid as string.',
'Cassandra\Timeuuid::time' => 'Unix timestamp.',
'Cassandra\Timeuuid::toDateTime' => 'Converts current timeuuid to PHP DateTime.',
'Cassandra\Timeuuid::type' => 'The type of this timeuuid.',
'Cassandra\Timeuuid::uuid' => 'Returns this timeuuid as string.',
'Cassandra\Timeuuid::version' => 'Returns the version of this timeuuid.',
'Cassandra\Tinyint::__construct' => 'Creates a new 8-bit signed integer.',
'Cassandra\Tinyint::abs' => '`@return \Cassandra\Numeric` absolute value',
'Cassandra\Tinyint::add' => '`@return \Cassandra\Numeric` sum',
'Cassandra\Tinyint::div' => '`@return \Cassandra\Numeric` quotient',
'Cassandra\Tinyint::max' => 'Maximum possible Tinyint value',
'Cassandra\Tinyint::min' => 'Minimum possible Tinyint value',
'Cassandra\Tinyint::mod' => '`@return \Cassandra\Numeric` remainder',
'Cassandra\Tinyint::mul' => '`@return \Cassandra\Numeric` product',
'Cassandra\Tinyint::neg' => '`@return \Cassandra\Numeric` negative value',
'Cassandra\Tinyint::sqrt' => '`@return \Cassandra\Numeric` square root',
'Cassandra\Tinyint::sub' => '`@return \Cassandra\Numeric` difference',
'Cassandra\Tinyint::toDouble' => '`@return float` this number as float',
'Cassandra\Tinyint::toInt' => '`@return int` this number as int',
'Cassandra\Tinyint::type' => 'The type of this value (tinyint).',
'Cassandra\Tinyint::value' => 'Returns the integer value.',
'Cassandra\Tuple::__construct' => 'Creates a new tuple with the given types.',
'Cassandra\Tuple::count' => 'Total number of elements in this tuple',
'Cassandra\Tuple::current' => 'Current element for iteration',
'Cassandra\Tuple::get' => 'Retrieves the value at a given index.',
'Cassandra\Tuple::key' => 'Current key for iteration',
'Cassandra\Tuple::next' => 'Move internal iterator forward',
'Cassandra\Tuple::rewind' => 'Rewind internal iterator',
'Cassandra\Tuple::set' => 'Sets the value at index in this tuple .',
'Cassandra\Tuple::type' => 'The type of this tuple.',
'Cassandra\Tuple::valid' => 'Check whether a current value exists',
'Cassandra\Tuple::values' => 'Array of values in this tuple.',
'Cassandra\Type::__toString' => 'Returns string representation of this type.',
'Cassandra\Type::ascii' => 'Get representation of ascii type',
'Cassandra\Type::bigint' => 'Get representation of bigint type',
'Cassandra\Type::blob' => 'Get representation of blob type',
'Cassandra\Type::boolean' => 'Get representation of boolean type',
'Cassandra\Type::collection' => 'Initialize a Collection type',
'Cassandra\Type::counter' => 'Get representation of counter type',
'Cassandra\Type::date' => 'Get representation of date type',
'Cassandra\Type::decimal' => 'Get representation of decimal type',
'Cassandra\Type::double' => 'Get representation of double type',
'Cassandra\Type::duration' => 'Get representation of duration type',
'Cassandra\Type::float' => 'Get representation of float type',
'Cassandra\Type::inet' => 'Get representation of inet type',
'Cassandra\Type::int' => 'Get representation of int type',
'Cassandra\Type::map' => 'Initialize a map type',
'Cassandra\Type::name' => 'Returns the name of this type as string.',
'Cassandra\Type::set' => 'Initialize a set type',
'Cassandra\Type::smallint' => 'Get representation of smallint type',
'Cassandra\Type::text' => 'Get representation of text type',
'Cassandra\Type::time' => 'Get representation of time type',
'Cassandra\Type::timestamp' => 'Get representation of timestamp type',
'Cassandra\Type::timeuuid' => 'Get representation of timeuuid type',
'Cassandra\Type::tinyint' => 'Get representation of tinyint type',
'Cassandra\Type::tuple' => 'Initialize a tuple type',
'Cassandra\Type::userType' => 'Initialize a user type',
'Cassandra\Type::uuid' => 'Get representation of uuid type',
'Cassandra\Type::varchar' => 'Get representation of varchar type',
'Cassandra\Type::varint' => 'Get representation of varint type',
'Cassandra\Type\Collection::__toString' => 'Returns type representation in CQL, e.g. `list<varchar>`',
'Cassandra\Type\Collection::ascii' => 'Get representation of ascii type',
'Cassandra\Type\Collection::bigint' => 'Get representation of bigint type',
'Cassandra\Type\Collection::blob' => 'Get representation of blob type',
'Cassandra\Type\Collection::boolean' => 'Get representation of boolean type',
'Cassandra\Type\Collection::collection' => 'Initialize a Collection type',
'Cassandra\Type\Collection::counter' => 'Get representation of counter type',
'Cassandra\Type\Collection::create' => 'Creates a new Collection from the given values.  When no values
given, creates an empty list.',
'Cassandra\Type\Collection::date' => 'Get representation of date type',
'Cassandra\Type\Collection::decimal' => 'Get representation of decimal type',
'Cassandra\Type\Collection::double' => 'Get representation of double type',
'Cassandra\Type\Collection::duration' => 'Get representation of duration type',
'Cassandra\Type\Collection::float' => 'Get representation of float type',
'Cassandra\Type\Collection::inet' => 'Get representation of inet type',
'Cassandra\Type\Collection::int' => 'Get representation of int type',
'Cassandra\Type\Collection::map' => 'Initialize a map type',
'Cassandra\Type\Collection::name' => 'Returns "list"',
'Cassandra\Type\Collection::set' => 'Initialize a set type',
'Cassandra\Type\Collection::smallint' => 'Get representation of smallint type',
'Cassandra\Type\Collection::text' => 'Get representation of text type',
'Cassandra\Type\Collection::time' => 'Get representation of time type',
'Cassandra\Type\Collection::timestamp' => 'Get representation of timestamp type',
'Cassandra\Type\Collection::timeuuid' => 'Get representation of timeuuid type',
'Cassandra\Type\Collection::tinyint' => 'Get representation of tinyint type',
'Cassandra\Type\Collection::tuple' => 'Initialize a tuple type',
'Cassandra\Type\Collection::userType' => 'Initialize a user type',
'Cassandra\Type\Collection::uuid' => 'Get representation of uuid type',
'Cassandra\Type\Collection::valueType' => 'Returns type of values',
'Cassandra\Type\Collection::varchar' => 'Get representation of varchar type',
'Cassandra\Type\Collection::varint' => 'Get representation of varint type',
'Cassandra\Type\Custom::__toString' => 'Returns string representation of this type.',
'Cassandra\Type\Custom::ascii' => 'Get representation of ascii type',
'Cassandra\Type\Custom::bigint' => 'Get representation of bigint type',
'Cassandra\Type\Custom::blob' => 'Get representation of blob type',
'Cassandra\Type\Custom::boolean' => 'Get representation of boolean type',
'Cassandra\Type\Custom::collection' => 'Initialize a Collection type',
'Cassandra\Type\Custom::counter' => 'Get representation of counter type',
'Cassandra\Type\Custom::date' => 'Get representation of date type',
'Cassandra\Type\Custom::decimal' => 'Get representation of decimal type',
'Cassandra\Type\Custom::double' => 'Get representation of double type',
'Cassandra\Type\Custom::duration' => 'Get representation of duration type',
'Cassandra\Type\Custom::float' => 'Get representation of float type',
'Cassandra\Type\Custom::inet' => 'Get representation of inet type',
'Cassandra\Type\Custom::int' => 'Get representation of int type',
'Cassandra\Type\Custom::map' => 'Initialize a map type',
'Cassandra\Type\Custom::name' => 'Returns the name of this type as string.',
'Cassandra\Type\Custom::set' => 'Initialize a set type',
'Cassandra\Type\Custom::smallint' => 'Get representation of smallint type',
'Cassandra\Type\Custom::text' => 'Get representation of text type',
'Cassandra\Type\Custom::time' => 'Get representation of time type',
'Cassandra\Type\Custom::timestamp' => 'Get representation of timestamp type',
'Cassandra\Type\Custom::timeuuid' => 'Get representation of timeuuid type',
'Cassandra\Type\Custom::tinyint' => 'Get representation of tinyint type',
'Cassandra\Type\Custom::tuple' => 'Initialize a tuple type',
'Cassandra\Type\Custom::userType' => 'Initialize a user type',
'Cassandra\Type\Custom::uuid' => 'Get representation of uuid type',
'Cassandra\Type\Custom::varchar' => 'Get representation of varchar type',
'Cassandra\Type\Custom::varint' => 'Get representation of varint type',
'Cassandra\Type\Map::__toString' => 'Returns type representation in CQL, e.g. `map<varchar, int>`',
'Cassandra\Type\Map::ascii' => 'Get representation of ascii type',
'Cassandra\Type\Map::bigint' => 'Get representation of bigint type',
'Cassandra\Type\Map::blob' => 'Get representation of blob type',
'Cassandra\Type\Map::boolean' => 'Get representation of boolean type',
'Cassandra\Type\Map::collection' => 'Initialize a Collection type',
'Cassandra\Type\Map::counter' => 'Get representation of counter type',
'Cassandra\Type\Map::create' => 'Creates a new Map from the given values.',
'Cassandra\Type\Map::date' => 'Get representation of date type',
'Cassandra\Type\Map::decimal' => 'Get representation of decimal type',
'Cassandra\Type\Map::double' => 'Get representation of double type',
'Cassandra\Type\Map::duration' => 'Get representation of duration type',
'Cassandra\Type\Map::float' => 'Get representation of float type',
'Cassandra\Type\Map::inet' => 'Get representation of inet type',
'Cassandra\Type\Map::int' => 'Get representation of int type',
'Cassandra\Type\Map::keyType' => 'Returns type of keys',
'Cassandra\Type\Map::map' => 'Initialize a map type',
'Cassandra\Type\Map::name' => 'Returns "map"',
'Cassandra\Type\Map::set' => 'Initialize a set type',
'Cassandra\Type\Map::smallint' => 'Get representation of smallint type',
'Cassandra\Type\Map::text' => 'Get representation of text type',
'Cassandra\Type\Map::time' => 'Get representation of time type',
'Cassandra\Type\Map::timestamp' => 'Get representation of timestamp type',
'Cassandra\Type\Map::timeuuid' => 'Get representation of timeuuid type',
'Cassandra\Type\Map::tinyint' => 'Get representation of tinyint type',
'Cassandra\Type\Map::tuple' => 'Initialize a tuple type',
'Cassandra\Type\Map::userType' => 'Initialize a user type',
'Cassandra\Type\Map::uuid' => 'Get representation of uuid type',
'Cassandra\Type\Map::valueType' => 'Returns type of values',
'Cassandra\Type\Map::varchar' => 'Get representation of varchar type',
'Cassandra\Type\Map::varint' => 'Get representation of varint type',
'Cassandra\Type\Scalar::__toString' => 'Returns string representation of this type.',
'Cassandra\Type\Scalar::ascii' => 'Get representation of ascii type',
'Cassandra\Type\Scalar::bigint' => 'Get representation of bigint type',
'Cassandra\Type\Scalar::blob' => 'Get representation of blob type',
'Cassandra\Type\Scalar::boolean' => 'Get representation of boolean type',
'Cassandra\Type\Scalar::collection' => 'Initialize a Collection type',
'Cassandra\Type\Scalar::counter' => 'Get representation of counter type',
'Cassandra\Type\Scalar::date' => 'Get representation of date type',
'Cassandra\Type\Scalar::decimal' => 'Get representation of decimal type',
'Cassandra\Type\Scalar::double' => 'Get representation of double type',
'Cassandra\Type\Scalar::duration' => 'Get representation of duration type',
'Cassandra\Type\Scalar::float' => 'Get representation of float type',
'Cassandra\Type\Scalar::inet' => 'Get representation of inet type',
'Cassandra\Type\Scalar::int' => 'Get representation of int type',
'Cassandra\Type\Scalar::map' => 'Initialize a map type',
'Cassandra\Type\Scalar::name' => 'Returns the name of this type as string.',
'Cassandra\Type\Scalar::set' => 'Initialize a set type',
'Cassandra\Type\Scalar::smallint' => 'Get representation of smallint type',
'Cassandra\Type\Scalar::text' => 'Get representation of text type',
'Cassandra\Type\Scalar::time' => 'Get representation of time type',
'Cassandra\Type\Scalar::timestamp' => 'Get representation of timestamp type',
'Cassandra\Type\Scalar::timeuuid' => 'Get representation of timeuuid type',
'Cassandra\Type\Scalar::tinyint' => 'Get representation of tinyint type',
'Cassandra\Type\Scalar::tuple' => 'Initialize a tuple type',
'Cassandra\Type\Scalar::userType' => 'Initialize a user type',
'Cassandra\Type\Scalar::uuid' => 'Get representation of uuid type',
'Cassandra\Type\Scalar::varchar' => 'Get representation of varchar type',
'Cassandra\Type\Scalar::varint' => 'Get representation of varint type',
'Cassandra\Type\Set::__toString' => 'Returns type representation in CQL, e.g. `set<varchar>`',
'Cassandra\Type\Set::ascii' => 'Get representation of ascii type',
'Cassandra\Type\Set::bigint' => 'Get representation of bigint type',
'Cassandra\Type\Set::blob' => 'Get representation of blob type',
'Cassandra\Type\Set::boolean' => 'Get representation of boolean type',
'Cassandra\Type\Set::collection' => 'Initialize a Collection type',
'Cassandra\Type\Set::counter' => 'Get representation of counter type',
'Cassandra\Type\Set::create' => 'Creates a new Set from the given values.',
'Cassandra\Type\Set::date' => 'Get representation of date type',
'Cassandra\Type\Set::decimal' => 'Get representation of decimal type',
'Cassandra\Type\Set::double' => 'Get representation of double type',
'Cassandra\Type\Set::duration' => 'Get representation of duration type',
'Cassandra\Type\Set::float' => 'Get representation of float type',
'Cassandra\Type\Set::inet' => 'Get representation of inet type',
'Cassandra\Type\Set::int' => 'Get representation of int type',
'Cassandra\Type\Set::map' => 'Initialize a map type',
'Cassandra\Type\Set::name' => 'Returns "set"',
'Cassandra\Type\Set::set' => 'Initialize a set type',
'Cassandra\Type\Set::smallint' => 'Get representation of smallint type',
'Cassandra\Type\Set::text' => 'Get representation of text type',
'Cassandra\Type\Set::time' => 'Get representation of time type',
'Cassandra\Type\Set::timestamp' => 'Get representation of timestamp type',
'Cassandra\Type\Set::timeuuid' => 'Get representation of timeuuid type',
'Cassandra\Type\Set::tinyint' => 'Get representation of tinyint type',
'Cassandra\Type\Set::tuple' => 'Initialize a tuple type',
'Cassandra\Type\Set::userType' => 'Initialize a user type',
'Cassandra\Type\Set::uuid' => 'Get representation of uuid type',
'Cassandra\Type\Set::valueType' => 'Returns type of values',
'Cassandra\Type\Set::varchar' => 'Get representation of varchar type',
'Cassandra\Type\Set::varint' => 'Get representation of varint type',
'Cassandra\Type\Tuple::__toString' => 'Returns type representation in CQL, e.g. `tuple<varchar, int>`',
'Cassandra\Type\Tuple::ascii' => 'Get representation of ascii type',
'Cassandra\Type\Tuple::bigint' => 'Get representation of bigint type',
'Cassandra\Type\Tuple::blob' => 'Get representation of blob type',
'Cassandra\Type\Tuple::boolean' => 'Get representation of boolean type',
'Cassandra\Type\Tuple::collection' => 'Initialize a Collection type',
'Cassandra\Type\Tuple::counter' => 'Get representation of counter type',
'Cassandra\Type\Tuple::create' => 'Creates a new Tuple from the given values. When no values given,
creates a tuple with null for the values.',
'Cassandra\Type\Tuple::date' => 'Get representation of date type',
'Cassandra\Type\Tuple::decimal' => 'Get representation of decimal type',
'Cassandra\Type\Tuple::double' => 'Get representation of double type',
'Cassandra\Type\Tuple::duration' => 'Get representation of duration type',
'Cassandra\Type\Tuple::float' => 'Get representation of float type',
'Cassandra\Type\Tuple::inet' => 'Get representation of inet type',
'Cassandra\Type\Tuple::int' => 'Get representation of int type',
'Cassandra\Type\Tuple::map' => 'Initialize a map type',
'Cassandra\Type\Tuple::name' => 'Returns "tuple"',
'Cassandra\Type\Tuple::set' => 'Initialize a set type',
'Cassandra\Type\Tuple::smallint' => 'Get representation of smallint type',
'Cassandra\Type\Tuple::text' => 'Get representation of text type',
'Cassandra\Type\Tuple::time' => 'Get representation of time type',
'Cassandra\Type\Tuple::timestamp' => 'Get representation of timestamp type',
'Cassandra\Type\Tuple::timeuuid' => 'Get representation of timeuuid type',
'Cassandra\Type\Tuple::tinyint' => 'Get representation of tinyint type',
'Cassandra\Type\Tuple::tuple' => 'Initialize a tuple type',
'Cassandra\Type\Tuple::types' => 'Returns types of values',
'Cassandra\Type\Tuple::userType' => 'Initialize a user type',
'Cassandra\Type\Tuple::uuid' => 'Get representation of uuid type',
'Cassandra\Type\Tuple::varchar' => 'Get representation of varchar type',
'Cassandra\Type\Tuple::varint' => 'Get representation of varint type',
'Cassandra\Type\UserType::__toString' => 'Returns type representation in CQL, e.g. keyspace1.type_name1 or
`userType<name1:varchar, name2:int>`.',
'Cassandra\Type\UserType::ascii' => 'Get representation of ascii type',
'Cassandra\Type\UserType::bigint' => 'Get representation of bigint type',
'Cassandra\Type\UserType::blob' => 'Get representation of blob type',
'Cassandra\Type\UserType::boolean' => 'Get representation of boolean type',
'Cassandra\Type\UserType::collection' => 'Initialize a Collection type',
'Cassandra\Type\UserType::counter' => 'Get representation of counter type',
'Cassandra\Type\UserType::create' => 'Creates a new UserTypeValue from the given name/value pairs. When
no values given, creates an empty user type.',
'Cassandra\Type\UserType::date' => 'Get representation of date type',
'Cassandra\Type\UserType::decimal' => 'Get representation of decimal type',
'Cassandra\Type\UserType::double' => 'Get representation of double type',
'Cassandra\Type\UserType::duration' => 'Get representation of duration type',
'Cassandra\Type\UserType::float' => 'Get representation of float type',
'Cassandra\Type\UserType::inet' => 'Get representation of inet type',
'Cassandra\Type\UserType::int' => 'Get representation of int type',
'Cassandra\Type\UserType::keyspace' => 'Returns keyspace for the user type',
'Cassandra\Type\UserType::map' => 'Initialize a map type',
'Cassandra\Type\UserType::name' => 'Returns type name for the user type',
'Cassandra\Type\UserType::set' => 'Initialize a set type',
'Cassandra\Type\UserType::smallint' => 'Get representation of smallint type',
'Cassandra\Type\UserType::text' => 'Get representation of text type',
'Cassandra\Type\UserType::time' => 'Get representation of time type',
'Cassandra\Type\UserType::timestamp' => 'Get representation of timestamp type',
'Cassandra\Type\UserType::timeuuid' => 'Get representation of timeuuid type',
'Cassandra\Type\UserType::tinyint' => 'Get representation of tinyint type',
'Cassandra\Type\UserType::tuple' => 'Initialize a tuple type',
'Cassandra\Type\UserType::types' => 'Returns types of values',
'Cassandra\Type\UserType::userType' => 'Initialize a user type',
'Cassandra\Type\UserType::uuid' => 'Get representation of uuid type',
'Cassandra\Type\UserType::varchar' => 'Get representation of varchar type',
'Cassandra\Type\UserType::varint' => 'Get representation of varint type',
'Cassandra\Type\UserType::withKeyspace' => 'Associate the user type with a keyspace.',
'Cassandra\Type\UserType::withName' => 'Associate the user type with a name.',
'Cassandra\UserTypeValue::__construct' => 'Creates a new user type value with the given name/type pairs.',
'Cassandra\UserTypeValue::count' => 'Total number of elements in this user type value.',
'Cassandra\UserTypeValue::current' => 'Current element for iteration',
'Cassandra\UserTypeValue::get' => 'Retrieves the value at a given name.',
'Cassandra\UserTypeValue::key' => 'Current key for iteration',
'Cassandra\UserTypeValue::next' => 'Move internal iterator forward',
'Cassandra\UserTypeValue::rewind' => 'Rewind internal iterator',
'Cassandra\UserTypeValue::set' => 'Sets the value at name in this user type value.',
'Cassandra\UserTypeValue::type' => 'The type of this user type value.',
'Cassandra\UserTypeValue::valid' => 'Check whether a current value exists',
'Cassandra\UserTypeValue::values' => 'Array of values in this user type value.',
'Cassandra\Uuid::__construct' => 'Creates a uuid from a given uuid string or a random one.',
'Cassandra\Uuid::__toString' => 'Returns this uuid as string.',
'Cassandra\Uuid::type' => 'The type of this uuid.',
'Cassandra\Uuid::uuid' => 'Returns this uuid as string.',
'Cassandra\Uuid::version' => 'Returns the version of this uuid.',
'Cassandra\UuidInterface::uuid' => 'Returns this uuid as string.',
'Cassandra\UuidInterface::version' => 'Returns the version of this uuid.',
'Cassandra\Value::type' => 'The type of represented by the value.',
'Cassandra\Varint::__construct' => 'Creates a new variable length integer.',
'Cassandra\Varint::__toString' => 'Returns the integer value.',
'Cassandra\Varint::abs' => '`@return \Cassandra\Numeric` absolute value',
'Cassandra\Varint::add' => '`@return \Cassandra\Numeric` sum',
'Cassandra\Varint::div' => '`@return \Cassandra\Numeric` quotient',
'Cassandra\Varint::mod' => '`@return \Cassandra\Numeric` remainder',
'Cassandra\Varint::mul' => '`@return \Cassandra\Numeric` product',
'Cassandra\Varint::neg' => '`@return \Cassandra\Numeric` negative value',
'Cassandra\Varint::sqrt' => '`@return \Cassandra\Numeric` square root',
'Cassandra\Varint::sub' => '`@return \Cassandra\Numeric` difference',
'Cassandra\Varint::toDouble' => '`@return float` this number as float',
'Cassandra\Varint::toInt' => '`@return int` this number as int',
'Cassandra\Varint::type' => 'The type of this varint.',
'Cassandra\Varint::value' => 'Returns the integer value.',
'ceil' => 'Round fractions up',
'chdb::__construct' => 'Creates a chdb instance',
'chdb::get' => 'Gets the value associated with a key',
'chdb_create' => 'Creates a chdb file',
'chdir' => 'Change directory',
'checkdate' => 'Validate a Gregorian date',
'checkdnsrr' => 'Check DNS records corresponding to a given Internet host name or IP address',
'chgrp' => 'Changes file group',
'chmod' => 'Changes file mode',
'chop' => 'Alias of rtrim',
'chown' => 'Changes file owner',
'chr' => 'Generate a single-byte string from a number',
'chroot' => 'Change the root directory',
'chunk_split' => 'Split a string into smaller chunks',
'class_alias' => 'Creates an alias for a class',
'class_exists' => 'Checks if the class has been defined',
'class_implements' => 'Return the interfaces which are implemented by the given class or interface',
'class_parents' => 'Return the parent classes of the given class',
'class_uses' => 'Return the traits used by the given class',
'classkit_import' => 'Import new class method definitions from a file',
'classkit_method_add' => 'Dynamically adds a new method to a given class',
'classkit_method_copy' => 'Copies a method from class to another',
'classkit_method_redefine' => 'Dynamically changes the code of the given method',
'classkit_method_remove' => 'Dynamically removes the given method',
'classkit_method_rename' => 'Dynamically changes the name of the given method',
'classObj::__construct' => 'The second argument class is optional. If given, the new class
created will be a copy of this class.',
'classObj::addLabel' => 'Add a labelObj to the classObj and return its index in the labels
array.
.. versionadded:: 6.2',
'classObj::convertToString' => 'Saves the object to a string.  Provides the inverse option for
updateFromString.',
'classObj::createLegendIcon' => 'Draw the legend icon and return a new imageObj.',
'classObj::deletestyle' => 'Delete the style specified by the style index. If there are any
style that follow the deleted style, their index will decrease by 1.',
'classObj::drawLegendIcon' => 'Draw the legend icon on im object at dstX, dstY.
Returns MS_SUCCESS/MS_FAILURE.',
'classObj::free' => 'Free the object properties and break the internal references.
Note that you have to unset the php variable to free totally the
resources.',
'classObj::getExpressionString' => 'Returns the :ref:`expression <expressions>` string for the class
object.',
'classObj::getLabel' => 'Return a reference to the labelObj at *index* in the labels array.
See the labelObj_ section for more details on multiple class
labels.
.. versionadded:: 6.2',
'classObj::getMetaData' => 'Fetch class metadata entry by name.  Returns "" if no entry
matches the name.  Note that the search is case sensitive.
.. note::
getMetaData\'s query is case sensitive.',
'classObj::getStyle' => 'Return the style object using an index. index >= 0 &&
index < class->numstyles.',
'classObj::getTextString' => 'Returns the text string for the class object.',
'classObj::movestyledown' => 'The style specified by the style index will be moved down into
the array of classes. Returns MS_SUCCESS or MS_FAILURE.
ex class->movestyledown(0) will have the effect of moving style 0
up to position 1, and the style at position 1 will be moved
to position 0.',
'classObj::movestyleup' => 'The style specified by the style index will be moved up into
the array of classes. Returns MS_SUCCESS or MS_FAILURE.
ex class->movestyleup(1) will have the effect of moving style 1
up to position 0, and the style at position 0 will be moved
to position 1.',
'classObj::ms_newClassObj' => 'Old style constructor',
'classObj::removeLabel' => 'Remove the labelObj at *index* from the labels array and return a
reference to the labelObj.  numlabels is decremented, and the
array is updated.
.. versionadded:: 6.2',
'classObj::removeMetaData' => 'Remove a metadata entry for the class.  Returns MS_SUCCESS/MS_FAILURE.',
'classObj::set' => 'Set object property to a new value.',
'classObj::setExpression' => 'Set the :ref:`expression <expressions>` string for the class
object.',
'classObj::setMetaData' => 'Set a metadata entry for the class.  Returns MS_SUCCESS/MS_FAILURE.',
'classObj::settext' => 'Set the text string for the class object.',
'classObj::updateFromString' => 'Update a class from a string snippet. Returns MS_SUCCESS/MS_FAILURE.
.. code-block:: php
set the color
$oClass->updateFromString(\'CLASS STYLE COLOR 255 0 255 END END\');',
'clearstatcache' => 'Clears file status cache',
'cli_get_process_title' => 'Returns the current process title',
'cli_set_process_title' => 'Sets the process title',
'ClosedGeneratorException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'ClosedGeneratorException::__toString' => 'String representation of the exception',
'ClosedGeneratorException::getCode' => 'Gets the Exception code',
'ClosedGeneratorException::getFile' => 'Gets the file in which the exception occurred',
'ClosedGeneratorException::getLine' => 'Gets the line in which the exception occurred',
'ClosedGeneratorException::getMessage' => 'Gets the Exception message',
'ClosedGeneratorException::getPrevious' => 'Returns previous Exception',
'ClosedGeneratorException::getTrace' => 'Gets the stack trace',
'ClosedGeneratorException::getTraceAsString' => 'Gets the stack trace as a string',
'closedir' => 'Close directory handle',
'closelog' => 'Close connection to system logger',
'Closure::__construct' => 'This method exists only to disallow instantiation of the Closure class.
Objects of this class are created in the fashion described on the anonymous functions page.',
'Closure::__invoke' => 'This is for consistency with other classes that implement calling magic,
as this method is not used for calling the function.',
'Closure::bind' => 'This method is a static version of Closure::bindTo().
See the documentation of that method for more information.',
'Closure::bindTo' => 'Duplicates the closure with a new bound object and class scope',
'Closure::call' => 'Temporarily binds the closure to newthis, and calls it with any given parameters.',
'clusterObj::convertToString' => 'Saves the object to a string.  Provides the inverse option for
updateFromString.',
'clusterObj::getFilterString' => 'Returns the :ref:`expression <expressions>` for this cluster
filter or NULL on error.',
'clusterObj::getGroupString' => 'Returns the :ref:`expression <expressions>` for this cluster group
or NULL on error.',
'clusterObj::setFilter' => 'Set layer filter :ref:`expression <expressions>`.',
'clusterObj::setGroup' => 'Set layer group :ref:`expression <expressions>`.',
'collator::__construct' => 'Create a collator',
'collator::asort' => 'Sort array maintaining index association',
'collator::compare' => 'Compare two Unicode strings',
'collator::create' => 'Create a collator',
'collator::getAttribute' => 'Get collation attribute value',
'collator::getErrorCode' => 'Get collator\'s last error code',
'collator::getErrorMessage' => 'Get text for collator\'s last error code',
'collator::getLocale' => 'Get the locale name of the collator',
'collator::getSortKey' => 'Get sorting key for a string',
'collator::getStrength' => 'Get current collation strength',
'collator::setAttribute' => 'Set collation attribute',
'collator::setStrength' => 'Set collation strength',
'collator::sort' => 'Sort array using specified collator',
'collator::sortWithSortKeys' => 'Sort array using specified collator and sort keys',
'collectable::isGarbage' => 'Determine whether an object has been marked as garbage',
'collectable::setGarbage' => 'Mark an object as garbage',
'colorObj::setHex' => 'Set red, green, blue and alpha values. The hex string should have the form
"#rrggbb" (alpha will be set to 255) or "#rrggbbaa". Returns MS_SUCCESS.',
'colorObj::toHex' => 'Get the color as a hex string "#rrggbb" or (if alpha is not 255)
"#rrggbbaa".',
'COM::__construct' => 'COM class constructor.',
'com_create_guid' => 'Generate a globally unique identifier (GUID)',
'com_event_sink' => 'Connect events from a COM object to a PHP object',
'com_get_active_object' => 'Returns a handle to an already running instance of a COM object',
'com_load_typelib' => 'Loads a Typelib',
'com_message_pump' => 'Process COM messages, sleeping for up to timeoutms milliseconds',
'com_print_typeinfo' => 'Print out a PHP class definition for a dispatchable interface',
'commonmark\cql::__construct' => 'CQL Construction',
'commonmark\cql::__invoke' => 'CQL Execution',
'commonmark\interfaces\ivisitable::accept' => 'Visitation',
'commonmark\interfaces\ivisitor::enter' => 'Visitation',
'commonmark\interfaces\ivisitor::leave' => 'Visitation',
'commonmark\node::accept' => 'Visitation',
'commonmark\node::appendChild' => 'AST Manipulation',
'commonmark\node::insertAfter' => 'AST Manipulation',
'commonmark\node::insertBefore' => 'AST Manipulation',
'commonmark\node::prependChild' => 'AST Manipulation',
'commonmark\node::replace' => 'AST Manipulation',
'commonmark\node::unlink' => 'AST Manipulation',
'commonmark\node\bulletlist::__construct' => 'BulletList Construction',
'commonmark\node\codeblock::__construct' => 'CodeBlock Construction',
'commonmark\node\heading::__construct' => 'Heading Construction',
'commonmark\node\image::__construct' => 'Image Construction',
'commonmark\node\link::__construct' => 'Link Construction',
'commonmark\node\orderedlist::__construct' => 'OrderedList Construction',
'commonmark\node\text::__construct' => 'Text Construction',
'commonmark\parse' => 'Parsing',
'commonmark\parser::__construct' => 'Parsing',
'commonmark\parser::finish' => 'Parsing',
'commonmark\parser::parse' => 'Parsing',
'commonmark\render' => 'Rendering',
'commonmark\render\html' => 'Rendering',
'commonmark\render\latex' => 'Rendering',
'commonmark\render\man' => 'Rendering',
'commonmark\render\xml' => 'Rendering',
'compact' => 'Create array containing variables and their values',
'compersisthelper::__construct' => 'Construct a COMPersistHelper object',
'compersisthelper::GetCurFileName' => 'Get current filename',
'compersisthelper::GetMaxStreamSize' => 'Get maximum stream size',
'compersisthelper::InitNew' => 'Initialize object to default state',
'compersisthelper::LoadFromFile' => 'Load object from file',
'compersisthelper::LoadFromStream' => 'Load object from stream',
'compersisthelper::SaveToFile' => 'Save object to file',
'compersisthelper::SaveToStream' => 'Save object to stream',
'CompileError::__clone' => 'Clone the error
Error can not be clone, so this method results in fatal error.',
'CompileError::__toString' => 'Gets a string representation of the thrown object',
'CompileError::getCode' => 'Gets the exception code',
'CompileError::getFile' => 'Gets the file in which the exception occurred',
'CompileError::getLine' => 'Gets the line on which the object was instantiated',
'CompileError::getPrevious' => 'Returns the previous Throwable',
'CompileError::getTrace' => 'Gets the stack trace',
'CompileError::getTraceAsString' => 'Gets the stack trace as a string',
'componere\abstract\definition::addInterface' => 'Add Interface',
'componere\abstract\definition::addMethod' => 'Add Method',
'componere\abstract\definition::addTrait' => 'Add Trait',
'componere\abstract\definition::getReflector' => 'Reflection',
'componere\cast' => 'Casting',
'componere\cast_by_ref' => 'Casting',
'componere\definition::__construct' => 'Definition Construction',
'componere\definition::addConstant' => 'Add Constant',
'componere\definition::addProperty' => 'Add Property',
'componere\definition::getClosure' => 'Get Closure',
'componere\definition::getClosures' => 'Get Closures',
'componere\definition::isRegistered' => 'State Detection',
'componere\definition::register' => 'Registration',
'componere\method::__construct' => 'Method Construction',
'componere\method::getReflector' => 'Reflection',
'componere\method::setPrivate' => 'Accessibility Modification',
'componere\method::setProtected' => 'Accessibility Modification',
'componere\method::setStatic' => 'Accessibility Modification',
'componere\patch::__construct' => 'Patch Construction',
'componere\patch::apply' => 'Application',
'componere\patch::derive' => 'Patch Derivation',
'componere\patch::getClosure' => 'Get Closure',
'componere\patch::getClosures' => 'Get Closures',
'componere\patch::isApplied' => 'State Detection',
'componere\patch::revert' => 'Reversal',
'componere\value::__construct' => 'Value Construction',
'componere\value::hasDefault' => 'Value Interaction',
'componere\value::isPrivate' => 'Accessibility Detection',
'componere\value::isProtected' => 'Accessibility Detection',
'componere\value::isStatic' => 'Accessibility Detection',
'componere\value::setPrivate' => 'Accessibility Modification',
'componere\value::setProtected' => 'Accessibility Modification',
'componere\value::setStatic' => 'Accessibility Modification',
'cond::broadcast' => 'Broadcast a Condition',
'cond::create' => 'Create a Condition',
'cond::destroy' => 'Destroy a Condition',
'cond::signal' => 'Signal a Condition',
'cond::wait' => 'Wait for Condition',
'connection_aborted' => 'Check whether client disconnected',
'connection_status' => 'Returns connection status bitfield',
'constant' => 'Returns the value of a constant',
'convert_cyr_string' => 'Convert from one Cyrillic character set to another',
'convert_uudecode' => 'Decode a uuencoded string',
'convert_uuencode' => 'Uuencode a string',
'copy' => 'Copies file',
'cos' => 'Cosine',
'cosh' => 'Hyperbolic cosine',
'Couchbase\AnalyticsQuery::fromString' => 'Creates new AnalyticsQuery instance directly from the string.',
'Couchbase\basicDecoderV1' => 'Decodes value according to Common Flags (RFC-20)',
'Couchbase\basicEncoderV1' => 'Encodes value according to Common Flags (RFC-20)',
'Couchbase\Bucket::append' => 'Appends content to a document.

On the server side it just contatenate passed value to the existing one.
Note that this might make the value un-decodable. Consider sub-document API
for partial updates of the JSON documents.',
'Couchbase\Bucket::counter' => 'Increments or decrements a key (based on $delta)',
'Couchbase\Bucket::decryptFields' => 'Decrypt fields inside specified document.',
'Couchbase\Bucket::diag' => 'Collect and return information about state of internal network connections.',
'Couchbase\Bucket::encryptFields' => 'Encrypt fields inside specified document.',
'Couchbase\Bucket::get' => 'Retrieves a document',
'Couchbase\Bucket::getAndLock' => 'Retrieves a document and locks it.

After the document has been locked on the server, its CAS would be masked,
and all mutations of it will be rejected until the server unlocks the document
automatically or it will be done manually with \Couchbase\Bucket::unlock() operation.',
'Couchbase\Bucket::getAndTouch' => 'Retrieves a document and updates its expiration time.',
'Couchbase\Bucket::getFromReplica' => 'Retrieves a document from a replica.',
'Couchbase\Bucket::getName' => 'Returns the name of the bucket for current connection',
'Couchbase\Bucket::insert' => 'Inserts a document. This operation will fail if the document already exists on the cluster.',
'Couchbase\Bucket::listExists' => 'Check if the list contains specified value',
'Couchbase\Bucket::listGet' => 'Get an element at the given position',
'Couchbase\Bucket::listPush' => 'Add an element to the end of the list',
'Couchbase\Bucket::listRemove' => 'Remove an element at the given position',
'Couchbase\Bucket::listSet' => 'Set an element at the given position',
'Couchbase\Bucket::listShift' => 'Add an element to the beginning of the list',
'Couchbase\Bucket::listSize' => 'Returns size of the list',
'Couchbase\Bucket::lookupIn' => 'Returns a builder for reading subdocument API.',
'Couchbase\Bucket::manager' => 'Returns an instance of a CouchbaseBucketManager for performing management operations against a bucket.',
'Couchbase\Bucket::mapAdd' => 'Add key to the map',
'Couchbase\Bucket::mapGet' => 'Get an item from a map',
'Couchbase\Bucket::mapRemove' => 'Removes key from the map',
'Couchbase\Bucket::mapSize' => 'Returns size of the map',
'Couchbase\Bucket::mutateIn' => 'Returns a builder for writing subdocument API.',
'Couchbase\Bucket::ping' => 'Try to reach specified services, and measure network latency.',
'Couchbase\Bucket::prepend' => 'Prepends content to a document.

On the server side it just contatenate existing value to the passed one.
Note that this might make the value un-decodable. Consider sub-document API
for partial updates of the JSON documents.',
'Couchbase\Bucket::query' => 'Performs a query to Couchbase Server',
'Couchbase\Bucket::queueAdd' => 'Add an element to the beginning of the queue',
'Couchbase\Bucket::queueExists' => 'Checks if the queue contains specified value',
'Couchbase\Bucket::queueRemove' => 'Remove the element at the end of the queue and return it',
'Couchbase\Bucket::queueSize' => 'Returns size of the queue',
'Couchbase\Bucket::remove' => 'Removes the document.',
'Couchbase\Bucket::replace' => 'Replaces a document. This operation will fail if the document does not exists on the cluster.',
'Couchbase\Bucket::retrieveIn' => 'Retrieves specified paths in JSON document

This is essentially a shortcut for `lookupIn($id)->get($paths)->execute()`.',
'Couchbase\Bucket::setAdd' => 'Add value to the set

Note, that currently only primitive values could be stored in the set (strings, integers and booleans).',
'Couchbase\Bucket::setExists' => 'Check if the value exists in the set',
'Couchbase\Bucket::setRemove' => 'Remove value from the set',
'Couchbase\Bucket::setSize' => 'Returns size of the set',
'Couchbase\Bucket::setTranscoder' => 'Sets custom encoder and decoder functions for handling serialization.',
'Couchbase\Bucket::touch' => 'Updates document\'s expiration time.',
'Couchbase\Bucket::unlock' => 'Unlocks previously locked document',
'Couchbase\Bucket::upsert' => 'Inserts or updates a document, depending on whether the document already exists on the cluster.',
'Couchbase\BucketManager::createN1qlIndex' => 'Create secondary N1QL index.',
'Couchbase\BucketManager::createN1qlPrimaryIndex' => 'Create a primary N1QL index.',
'Couchbase\BucketManager::dropN1qlIndex' => 'Drop the given secondary index',
'Couchbase\BucketManager::dropN1qlPrimaryIndex' => 'Drop the given primary index',
'Couchbase\BucketManager::flush' => 'Flushes the bucket (clears all data)',
'Couchbase\BucketManager::getDesignDocument' => 'Get design document by its name',
'Couchbase\BucketManager::info' => 'Returns information about the bucket

Returns an associative array of status information as seen by the cluster for
this bucket. The exact structure of the returned data can be seen in the Couchbase
Manual by looking at the bucket /info endpoint.',
'Couchbase\BucketManager::insertDesignDocument' => 'Inserts design document and fails if it is exist already.',
'Couchbase\BucketManager::listDesignDocuments' => 'Returns all design documents of the bucket.',
'Couchbase\BucketManager::listN1qlIndexes' => 'List all N1QL indexes that are registered for the current bucket.',
'Couchbase\BucketManager::removeDesignDocument' => 'Removes design document by its name',
'Couchbase\BucketManager::upsertDesignDocument' => 'Creates or replaces design document.',
'Couchbase\ClassicAuthenticator::bucket' => 'Registers bucket credentials in the container',
'Couchbase\ClassicAuthenticator::cluster' => 'Registers cluster management credentials in the container',
'Couchbase\Cluster::__construct' => 'Create cluster object',
'Couchbase\Cluster::authenticate' => 'Associate authenticator with Cluster',
'Couchbase\Cluster::authenticateAs' => 'Create \Couchbase\PasswordAuthenticator from given credentials and associate it with Cluster',
'Couchbase\Cluster::manager' => 'Open management connection to the Couchbase cluster.',
'Couchbase\Cluster::openBucket' => 'Open connection to the Couchbase bucket',
'Couchbase\ClusterManager::createBucket' => 'Creates new bucket',
'Couchbase\ClusterManager::getUser' => 'Fetch single user by its name',
'Couchbase\ClusterManager::info' => 'Provides information about the cluster.

Returns an associative array of status information as seen on the cluster.  The exact structure of the returned
data can be seen in the Couchbase Manual by looking at the cluster /info endpoint.',
'Couchbase\ClusterManager::listBuckets' => 'Lists all buckets on this cluster.',
'Couchbase\ClusterManager::listUsers' => 'Lists all users on this cluster.',
'Couchbase\ClusterManager::removeBucket' => 'Removes a bucket identified by its name.',
'Couchbase\ClusterManager::removeUser' => 'Removes a user identified by its name.',
'Couchbase\ClusterManager::upsertUser' => 'Creates new user',
'Couchbase\defaultDecoder' => 'Decodes value using \Couchbase\basicDecoderV1.

It passes `couchbase.decoder.*` INI properties as $options.',
'Couchbase\defaultEncoder' => 'Encodes value using \Couchbase\basicDecoderV1.

It passes `couchbase.encoder.*` INI properties as $options.',
'Couchbase\fastlzCompress' => 'Compress input using FastLZ algorithm.',
'Couchbase\fastlzDecompress' => 'Decompress input using FastLZ algorithm.',
'Couchbase\LookupInBuilder::execute' => 'Perform several lookup operations inside a single existing JSON document, using a specific timeout',
'Couchbase\LookupInBuilder::exists' => 'Check if a value exists inside the document.

This doesn\'t transmit the value on the wire if it exists, saving the corresponding byte overhead.',
'Couchbase\LookupInBuilder::get' => 'Get a value inside the JSON document.',
'Couchbase\LookupInBuilder::getCount' => 'Get a count of values inside the JSON document.

This method is only available with Couchbase Server 5.0 and later.',
'Couchbase\MutateInBuilder::arrayAddUnique' => 'Insert a value in an existing array only if the value
isn\'t already contained in the array (by way of string comparison).',
'Couchbase\MutateInBuilder::arrayAppend' => 'Append to an existing array, pushing the value to the back/last position in the array.',
'Couchbase\MutateInBuilder::arrayAppendAll' => 'Append multiple values at once in an existing array.

Push all values in the collection\'s iteration order to the back/end of the array.
For example given an array [A, B, C], appending the values X and Y yields [A, B, C, X, Y]
and not [A, B, C, [X, Y]].',
'Couchbase\MutateInBuilder::arrayInsert' => 'Insert into an existing array at a specific position

Position denoted in the path, eg. "sub.array[2]".',
'Couchbase\MutateInBuilder::arrayInsertAll' => 'Insert multiple values at once in an existing array at a specified position.

Position denoted in the path, eg. "sub.array[2]"), inserting all values in the collection\'s iteration order
at the given position and shifting existing values beyond the position by the number of elements in the
collection.

For example given an array [A, B, C], inserting the values X and Y at position 1 yields [A, B, X, Y, C]
and not [A, B, [X, Y], C].',
'Couchbase\MutateInBuilder::arrayPrepend' => 'Prepend to an existing array, pushing the value to the front/first position in the array.',
'Couchbase\MutateInBuilder::arrayPrependAll' => 'Prepend multiple values at once in an existing array.

Push all values in the collection\'s iteration order to the front/start of the array.
For example given an array [A, B, C], prepending the values X and Y yields [X, Y, A, B, C]
and not [[X, Y], A, B, C].',
'Couchbase\MutateInBuilder::counter' => 'Increment/decrement a numerical fragment in a JSON document.

If the value (last element of the path) doesn\'t exist the counter
is created and takes the value of the delta.',
'Couchbase\MutateInBuilder::execute' => 'Perform several mutation operations inside a single existing JSON document.',
'Couchbase\MutateInBuilder::insert' => 'Insert a fragment provided the last element of the path doesn\'t exists.',
'Couchbase\MutateInBuilder::modeDocument' => 'Select mode for new full-document operations.

It defines behaviour of MutateInBuilder#upsert() method. The $mode
could take one of three modes:
 * FULLDOC_REPLACE: complain when document does not exist
 * FULLDOC_INSERT: complain when document does exist
 * FULLDOC_UPSERT: unconditionally set value for the document',
'Couchbase\MutateInBuilder::remove' => 'Remove an entry in a JSON document.

Scalar, array element, dictionary entry, whole array or dictionary, depending on the path.',
'Couchbase\MutateInBuilder::replace' => 'Replace an existing value by the given fragment',
'Couchbase\MutateInBuilder::upsert' => 'Insert a fragment, replacing the old value if the path exists.

When only one argument supplied, the library will handle it as full-document
upsert, and treat this argument as value. See MutateInBuilder#modeDocument()',
'Couchbase\MutateInBuilder::withExpiry' => 'Change the expiry of the enclosing document as part of the mutation.',
'Couchbase\MutationState::add' => 'Update container with the given mutation token holders.',
'Couchbase\MutationState::from' => 'Create container from the given mutation token holders.',
'Couchbase\MutationToken::bucketName' => 'Returns bucket name',
'Couchbase\MutationToken::from' => 'Creates new mutation token',
'Couchbase\MutationToken::sequenceNumber' => 'Returns the sequence number inside partition',
'Couchbase\MutationToken::vbucketId' => 'Returns partition number',
'Couchbase\MutationToken::vbucketUuid' => 'Returns UUID of the partition',
'Couchbase\N1qlQuery::adhoc' => 'Allows to specify if this query is adhoc or not.

If it is not adhoc (so performed often), the client will try to perform optimizations
transparently based on the server capabilities, like preparing the statement and
then executing a query plan instead of the raw query.',
'Couchbase\N1qlQuery::consistency' => 'Specifies the consistency level for this query',
'Couchbase\N1qlQuery::consistentWith' => 'Sets mutation state the query should be consistent with',
'Couchbase\N1qlQuery::crossBucket' => 'Allows to pull credentials from the Authenticator',
'Couchbase\N1qlQuery::fromString' => 'Creates new N1qlQuery instance directly from the N1QL string.',
'Couchbase\N1qlQuery::maxParallelism' => 'Allows to override the default maximum parallelism for the query execution on the server side.',
'Couchbase\N1qlQuery::namedParams' => 'Specify associative array of named parameters

The supplied array of key/value pairs will be merged with already existing named parameters.
Note: carefully choose type of quotes for the query string, because PHP also uses `$`
(dollar sign) for variable interpolation. If you are using double quotes, make sure
that N1QL parameters properly escaped.',
'Couchbase\N1qlQuery::pipelineBatch' => 'Advanced: Controls the number of items execution operators can batch for Fetch from the KV.',
'Couchbase\N1qlQuery::pipelineCap' => 'Advanced: Maximum number of items each execution operator can buffer between various operators.',
'Couchbase\N1qlQuery::positionalParams' => 'Specify array of positional parameters

Previously specified positional parameters will be replaced.
Note: carefully choose type of quotes for the query string, because PHP also uses `$`
(dollar sign) for variable interpolation. If you are using double quotes, make sure
that N1QL parameters properly escaped.',
'Couchbase\N1qlQuery::profile' => 'Controls the profiling mode used during query execution',
'Couchbase\N1qlQuery::readonly' => 'If set to true, it will signal the query engine on the server that only non-data modifying requests
are allowed. Note that this rule is enforced on the server and not the SDK side.

Controls whether a query can change a resulting record set.

If readonly is true, then the following statements are not allowed:
 - CREATE INDEX
 - DROP INDEX
 - INSERT
 - MERGE
 - UPDATE
 - UPSERT
 - DELETE',
'Couchbase\N1qlQuery::scanCap' => 'Advanced: Maximum buffered channel size between the indexer client and the query service for index scans.

This parameter controls when to use scan backfill. Use 0 or a negative number to disable.',
'Couchbase\passthruDecoder' => 'Returns value as it received from the server without any transformations.

It is useful for debug purpose to inspect bare value.',
'Couchbase\passthruEncoder' => 'Returns the value, which has been passed and zero as flags and datatype.

It is useful for debug purposes, or when the value known to be a string, otherwise behavior is not defined (most
likely it will generate error).',
'Couchbase\PasswordAuthenticator::password' => 'Sets password',
'Couchbase\PasswordAuthenticator::username' => 'Sets username',
'Couchbase\SearchQuery::__construct' => 'Prepare an FTS SearchQuery on an index.

Top level query parameters can be set after that by using the fluent API.',
'Couchbase\SearchQuery::addFacet' => 'Adds one SearchFacet to the query

This is an additive operation (the given facets are added to any facet previously requested),
but if an existing facet has the same name it will be replaced.

Note that to be faceted, a field\'s value must be stored in the FTS index.',
'Couchbase\SearchQuery::boolean' => 'Prepare boolean search query',
'Couchbase\SearchQuery::booleanField' => 'Prepare boolean field search query',
'Couchbase\SearchQuery::conjuncts' => 'Prepare compound conjunction search query',
'Couchbase\SearchQuery::consistentWith' => 'Sets the consistency to consider for this FTS query to AT_PLUS and
uses the MutationState to parameterize the consistency.

This replaces any consistency tuning previously set.',
'Couchbase\SearchQuery::dateRange' => 'Prepare date range search query',
'Couchbase\SearchQuery::dateRangeFacet' => 'Prepare date range search facet',
'Couchbase\SearchQuery::disjuncts' => 'Prepare compound disjunction search query',
'Couchbase\SearchQuery::docId' => 'Prepare document ID search query',
'Couchbase\SearchQuery::explain' => 'Activates the explanation of each result hit in the response',
'Couchbase\SearchQuery::fields' => 'Configures the list of fields for which the whole value should be included in the response.

If empty, no field values are included. This drives the inclusion of the fields in each hit.
Note that to be highlighted, the fields must be stored in the FTS index.',
'Couchbase\SearchQuery::geoBoundingBox' => 'Prepare geo bounding box search query',
'Couchbase\SearchQuery::geoDistance' => 'Prepare geo distance search query',
'Couchbase\SearchQuery::highlight' => 'Configures the highlighting of matches in the response',
'Couchbase\SearchQuery::limit' => 'Add a limit to the query on the number of hits it can return',
'Couchbase\SearchQuery::match' => 'Prepare match search query',
'Couchbase\SearchQuery::matchAll' => 'Prepare match all search query',
'Couchbase\SearchQuery::matchNone' => 'Prepare match non search query',
'Couchbase\SearchQuery::matchPhrase' => 'Prepare phrase search query',
'Couchbase\SearchQuery::numericRange' => 'Prepare numeric range search query',
'Couchbase\SearchQuery::numericRangeFacet' => 'Prepare numeric range search facet',
'Couchbase\SearchQuery::prefix' => 'Prepare prefix search query',
'Couchbase\SearchQuery::queryString' => 'Prepare query string search query',
'Couchbase\SearchQuery::regexp' => 'Prepare regexp search query',
'Couchbase\SearchQuery::serverSideTimeout' => 'Sets the server side timeout in milliseconds',
'Couchbase\SearchQuery::skip' => 'Set the number of hits to skip (eg. for pagination).',
'Couchbase\SearchQuery::sort' => 'Configures the list of fields (including special fields) which are used for sorting purposes.
If empty, the default sorting (descending by score) is used by the server.

The list of sort fields can include actual fields (like "firstname" but then they must be stored in the
index, configured in the server side mapping). Fields provided first are considered first and in a "tie" case
the next sort field is considered. So sorting by "firstname" and then "lastname" will first sort ascending by
the firstname and if the names are equal then sort ascending by lastname. Special fields like "_id" and
"_score" can also be used. If prefixed with "-" the sort order is set to descending.

If no sort is provided, it is equal to sort("-_score"), since the server will sort it by score in descending
order.',
'Couchbase\SearchQuery::term' => 'Prepare term search query',
'Couchbase\SearchQuery::termFacet' => 'Prepare term search facet',
'Couchbase\SearchQuery::termRange' => 'Prepare term range search query',
'Couchbase\SearchQuery::wildcard' => 'Prepare wildcard search query',
'Couchbase\SearchSort::field' => 'Sort by a field in the hits.',
'Couchbase\SearchSort::geoDistance' => 'Sort by geo location.',
'Couchbase\SearchSort::id' => 'Sort by the document identifier.',
'Couchbase\SearchSort::score' => 'Sort by the hit score.',
'Couchbase\SearchSortField::descending' => 'Direction of the sort',
'Couchbase\SearchSortField::field' => 'Sort by a field in the hits.',
'Couchbase\SearchSortField::geoDistance' => 'Sort by geo location.',
'Couchbase\SearchSortField::id' => 'Sort by the document identifier.',
'Couchbase\SearchSortField::jsonSerialize' => 'Specify data which should be serialized to JSON',
'Couchbase\SearchSortField::missing' => 'Set where the hits with missing field will be inserted',
'Couchbase\SearchSortField::mode' => 'Set mode of the sort',
'Couchbase\SearchSortField::score' => 'Sort by the hit score.',
'Couchbase\SearchSortField::type' => 'Set type of the field',
'Couchbase\SearchSortGeoDistance::descending' => 'Direction of the sort',
'Couchbase\SearchSortGeoDistance::field' => 'Sort by a field in the hits.',
'Couchbase\SearchSortGeoDistance::geoDistance' => 'Sort by geo location.',
'Couchbase\SearchSortGeoDistance::id' => 'Sort by the document identifier.',
'Couchbase\SearchSortGeoDistance::jsonSerialize' => 'Specify data which should be serialized to JSON',
'Couchbase\SearchSortGeoDistance::score' => 'Sort by the hit score.',
'Couchbase\SearchSortGeoDistance::unit' => 'Name of the units',
'Couchbase\SearchSortId::descending' => 'Direction of the sort',
'Couchbase\SearchSortId::field' => 'Sort by a field in the hits.',
'Couchbase\SearchSortId::geoDistance' => 'Sort by geo location.',
'Couchbase\SearchSortId::id' => 'Sort by the document identifier.',
'Couchbase\SearchSortId::jsonSerialize' => 'Specify data which should be serialized to JSON',
'Couchbase\SearchSortId::score' => 'Sort by the hit score.',
'Couchbase\SearchSortScore::descending' => 'Direction of the sort',
'Couchbase\SearchSortScore::field' => 'Sort by a field in the hits.',
'Couchbase\SearchSortScore::geoDistance' => 'Sort by geo location.',
'Couchbase\SearchSortScore::id' => 'Sort by the document identifier.',
'Couchbase\SearchSortScore::jsonSerialize' => 'Specify data which should be serialized to JSON',
'Couchbase\SearchSortScore::score' => 'Sort by the hit score.',
'Couchbase\SpatialViewQuery::bbox' => 'Specifies the bounding box to search within.

Note, using bbox() is discouraged, startRange/endRange is more flexible and should be preferred.',
'Couchbase\SpatialViewQuery::consistency' => 'Specifies the mode of updating to perorm before and after executing the query',
'Couchbase\SpatialViewQuery::custom' => 'Specifies custom options to pass to the server.

Note that these options are expected to be already encoded.',
'Couchbase\SpatialViewQuery::encode' => 'Returns associative array, representing the View query.',
'Couchbase\SpatialViewQuery::endRange' => 'Specify end range for query',
'Couchbase\SpatialViewQuery::limit' => 'Limits the result set to a specified number rows.',
'Couchbase\SpatialViewQuery::order' => 'Orders the results by key as specified',
'Couchbase\SpatialViewQuery::skip' => 'Skips a number o records rom the beginning of the result set',
'Couchbase\SpatialViewQuery::startRange' => 'Specify start range for query',
'Couchbase\UserSettings::fullName' => 'Sets full name of the user (optional).',
'Couchbase\UserSettings::password' => 'Sets password of the user.',
'Couchbase\UserSettings::role' => 'Adds role to the list of the accessible roles of the user.',
'Couchbase\ViewQuery::consistency' => 'Specifies the mode of updating to perorm before and after executing the query',
'Couchbase\ViewQuery::custom' => 'Specifies custom options to pass to the server.

Note that these options are expected to be already encoded.',
'Couchbase\ViewQuery::encode' => 'Returns associative array, representing the View query.',
'Couchbase\ViewQuery::from' => 'Creates a new Couchbase ViewQuery instance for performing a view query.',
'Couchbase\ViewQuery::fromSpatial' => 'Creates a new Couchbase ViewQuery instance for performing a spatial query.',
'Couchbase\ViewQuery::group' => 'Group the results using the reduce function to a group or single row.

Important: this setter and groupLevel should not be used together in the
same ViewQuery. It is sufficient to only set the grouping level only and
use this setter in cases where you always want the highest group level
implicitly.',
'Couchbase\ViewQuery::groupLevel' => 'Specify the group level to be used.

Important: group() and this setter should not be used together in the
same ViewQuery. It is sufficient to only use this setter and use group()
in cases where you always want the highest group level implicitly.',
'Couchbase\ViewQuery::idRange' => 'Specifies start and end document IDs in addition to range limits.

This might be needed for more precise pagination with a lot of documents
with the same key selected into the same page.',
'Couchbase\ViewQuery::key' => 'Restict results of the query to the specified key',
'Couchbase\ViewQuery::keys' => 'Restict results of the query to the specified set of keys',
'Couchbase\ViewQuery::limit' => 'Limits the result set to a specified number rows.',
'Couchbase\ViewQuery::order' => 'Orders the results by key as specified',
'Couchbase\ViewQuery::range' => 'Specifies a range of the keys to return from the index.',
'Couchbase\ViewQuery::reduce' => 'Specifies whether the reduction function should be applied to results of the query.',
'Couchbase\ViewQuery::skip' => 'Skips a number o records rom the beginning of the result set',
'Couchbase\ViewQueryEncodable::encode' => 'Returns associative array, representing the View query.',
'Couchbase\zlibCompress' => 'Compress input using zlib. Raises Exception when extension compiled without zlib support.',
'Couchbase\zlibDecompress' => 'Compress input using zlib. Raises Exception when extension compiled without zlib support.',
'count' => 'Count all elements in an array, or something in an object',
'count_chars' => 'Return information about characters used in a string',
'countable::count' => 'Count elements of an object',
'crack_check' => 'Performs an obscure check with the given password',
'crack_closedict' => 'Closes an open CrackLib dictionary',
'crack_getlastmessage' => 'Returns the message from the last obscure check',
'crack_opendict' => 'Opens a new CrackLib dictionary',
'crc32' => 'Calculates the crc32 polynomial of a string',
'create_function' => 'Create an anonymous (lambda-style) function',
'crypt' => 'One-way string hashing',
'Crypto\Base64::__construct' => 'Base64 constructor',
'Crypto\Base64::decode' => 'Decodes base64 string $data to raw encoding',
'Crypto\Base64::decodeFinish' => 'Decodes characters that left in the encoding context',
'Crypto\Base64::decodeUpdate' => 'Decodes block of characters from $data and saves the reminder of the last block
to the encoding context',
'Crypto\Base64::encode' => 'Encodes string $data to base64 encoding',
'Crypto\Base64::encodeFinish' => 'Encodes characters that left in the encoding context',
'Crypto\Base64::encodeUpdate' => 'Encodes block of characters from $data and saves the reminder of the last block
to the encoding context',
'Crypto\Cipher::__callStatic' => 'Cipher magic method for calling static methods',
'Crypto\Cipher::__construct' => 'Cipher constructor',
'Crypto\Cipher::decrypt' => 'Decrypts ciphertext to decrypted text',
'Crypto\Cipher::decryptFinish' => 'Finalizes cipher decryption',
'Crypto\Cipher::decryptInit' => 'Initializes cipher decryption',
'Crypto\Cipher::decryptUpdate' => 'Updates cipher decryption',
'Crypto\Cipher::encrypt' => 'Encrypts text to ciphertext',
'Crypto\Cipher::encryptFinish' => 'Finalizes cipher encryption',
'Crypto\Cipher::encryptInit' => 'Initializes cipher encryption',
'Crypto\Cipher::encryptUpdate' => 'Updates cipher encryption',
'Crypto\Cipher::getAlgorithmName' => 'Returns cipher algorithm string',
'Crypto\Cipher::getAlgorithms' => 'Returns cipher algorithms',
'Crypto\Cipher::getBlockSize' => 'Returns cipher block size',
'Crypto\Cipher::getIVLength' => 'Returns cipher IV length',
'Crypto\Cipher::getKeyLength' => 'Returns cipher key length',
'Crypto\Cipher::getMode' => 'Returns cipher mode',
'Crypto\Cipher::getTag' => 'Returns authentication tag',
'Crypto\Cipher::hasAlgorithm' => 'Finds out whether algorithm exists',
'Crypto\Cipher::hasMode' => 'Finds out whether the cipher mode is defined in the used OpenSSL library',
'Crypto\Cipher::setAAD' => 'Sets additional application data for authenticated encryption',
'Crypto\Cipher::setTag' => 'Sets authentication tag',
'Crypto\Cipher::setTagLength' => 'Set authentication tag length',
'Crypto\Hash::__callStatic' => 'Hash magic method for calling static methods',
'Crypto\Hash::__construct' => 'Hash constructor',
'Crypto\Hash::digest' => 'Return hash digest in raw foramt',
'Crypto\Hash::getAlgorithmName' => 'Returns hash algorithm string',
'Crypto\Hash::getAlgorithms' => 'Returns hash algorithms',
'Crypto\Hash::getBlockSize' => 'Returns hash block size',
'Crypto\Hash::getSize' => 'Returns hash size',
'Crypto\Hash::hasAlgorithm' => 'Finds out whether algorithm exists',
'Crypto\Hash::hexdigest' => 'Return hash digest in hex format',
'Crypto\Hash::update' => 'Updates hash',
'Crypto\KDF::__construct' => 'KDF constructor',
'Crypto\KDF::getLength' => 'Get key length',
'Crypto\KDF::getSalt' => 'Get salt',
'Crypto\KDF::setLength' => 'Set key length',
'Crypto\KDF::setSalt' => 'Set salt',
'Crypto\MAC::__callStatic' => 'Hash magic method for calling static methods',
'Crypto\MAC::__construct' => 'Create a MAC (used by MAC subclasses - HMAC and CMAC)',
'Crypto\MAC::digest' => 'Return hash digest in raw foramt',
'Crypto\MAC::getAlgorithmName' => 'Returns hash algorithm string',
'Crypto\MAC::getAlgorithms' => 'Returns hash algorithms',
'Crypto\MAC::getBlockSize' => 'Returns hash block size',
'Crypto\MAC::getSize' => 'Returns hash size',
'Crypto\MAC::hasAlgorithm' => 'Finds out whether algorithm exists',
'Crypto\MAC::hexdigest' => 'Return hash digest in hex format',
'Crypto\MAC::update' => 'Updates hash',
'Crypto\PBKDF2::__construct' => 'KDF constructor',
'Crypto\PBKDF2::derive' => 'Deriver hash for password',
'Crypto\PBKDF2::getHashAlgorithm' => 'Get hash algorithm',
'Crypto\PBKDF2::getIterations' => 'Get iterations',
'Crypto\PBKDF2::getLength' => 'Get key length',
'Crypto\PBKDF2::getSalt' => 'Get salt',
'Crypto\PBKDF2::setHashAlgorithm' => 'Set hash algorithm',
'Crypto\PBKDF2::setIterations' => 'Set iterations',
'Crypto\PBKDF2::setLength' => 'Set key length',
'Crypto\PBKDF2::setSalt' => 'Set salt',
'Crypto\Rand::cleanup' => 'Cleans up PRNG state',
'Crypto\Rand::generate' => 'Generates pseudo random bytes',
'Crypto\Rand::loadFile' => 'Reads a number of bytes from file $filename and adds them to the PRNG. If
max_bytes is non-negative, up to to max_bytes are read; if $max_bytes is
negative, the complete file is read',
'Crypto\Rand::seed' => 'Mixes bytes in $buf into PRNG state',
'Crypto\Rand::writeFile' => 'Writes a number of random bytes (currently 1024) to file $filename which can be
used to initializethe PRNG by calling Crypto\Rand::loadFile() in a later session',
'ctype_alnum' => 'Check for alphanumeric character(s)',
'ctype_alpha' => 'Check for alphabetic character(s)',
'ctype_cntrl' => 'Check for control character(s)',
'ctype_digit' => 'Check for numeric character(s)',
'ctype_graph' => 'Check for any printable character(s) except space',
'ctype_lower' => 'Check for lowercase character(s)',
'ctype_print' => 'Check for printable character(s)',
'ctype_punct' => 'Check for any printable character which is not whitespace or an alphanumeric character',
'ctype_space' => 'Check for whitespace character(s)',
'ctype_upper' => 'Check for uppercase character(s)',
'ctype_xdigit' => 'Check for character(s) representing a hexadecimal digit',
'cubrid_bind' => 'Bind variables to a prepared statement as parameters',
'cubrid_close_prepare' => 'Close the request handle',
'cubrid_close_request' => 'Close the request handle',
'cubrid_col_get' => 'Get contents of collection type column using OID',
'cubrid_col_size' => 'Get the number of elements in collection type column using OID',
'cubrid_column_names' => 'Get the column names in result',
'cubrid_column_types' => 'Get column types in result',
'cubrid_commit' => 'Commit a transaction',
'cubrid_connect' => 'Open a connection to a CUBRID Server',
'cubrid_connect_with_url' => 'Establish the environment for connecting to CUBRID server',
'cubrid_current_oid' => 'Get OID of the current cursor location',
'cubrid_disconnect' => 'Close a database connection',
'cubrid_drop' => 'Delete an instance using OID',
'cubrid_error_code' => 'Get error code for the most recent function call',
'cubrid_error_code_facility' => 'Get the facility code of error',
'cubrid_error_msg' => 'Get last error message for the most recent function call',
'cubrid_execute' => 'Execute a prepared SQL statement',
'cubrid_fetch' => 'Fetch the next row from a result set',
'cubrid_free_result' => 'Free the memory occupied by the result data',
'cubrid_get' => 'Get a column using OID',
'cubrid_get_autocommit' => 'Get auto-commit mode of the connection',
'cubrid_get_charset' => 'Return the current CUBRID connection charset',
'cubrid_get_class_name' => 'Get the class name using OID',
'cubrid_get_client_info' => 'Return the client library version',
'cubrid_get_db_parameter' => 'Returns the CUBRID database parameters',
'cubrid_get_query_timeout' => 'Get the query timeout value of the request',
'cubrid_get_server_info' => 'Return the CUBRID server version',
'cubrid_insert_id' => 'Return the ID generated for the last updated AUTO_INCREMENT column',
'cubrid_is_instance' => 'Check whether the instance pointed by OID exists',
'cubrid_lob2_bind' => 'Bind a lob object or a string as a lob object to a prepared statement as parameters',
'cubrid_lob2_close' => 'Close LOB object',
'cubrid_lob2_export' => 'Export the lob object to a file',
'cubrid_lob2_import' => 'Import BLOB/CLOB data from a file',
'cubrid_lob2_new' => 'Create a lob object',
'cubrid_lob2_read' => 'Read from BLOB/CLOB data',
'cubrid_lob2_seek' => 'Move the cursor of a lob object',
'cubrid_lob2_seek64' => 'Move the cursor of a lob object',
'cubrid_lob2_size' => 'Get a lob object\'s size',
'cubrid_lob2_size64' => 'Get a lob object\'s size',
'cubrid_lob2_tell' => 'Tell the cursor position of the LOB object',
'cubrid_lob2_tell64' => 'Tell the cursor position of the LOB object',
'cubrid_lob2_write' => 'Write to a lob object',
'cubrid_lob_close' => 'Close BLOB/CLOB data',
'cubrid_lob_export' => 'Export BLOB/CLOB data to file',
'cubrid_lob_get' => 'Get BLOB/CLOB data',
'cubrid_lob_send' => 'Read BLOB/CLOB data and send straight to browser',
'cubrid_lob_size' => 'Get BLOB/CLOB data size',
'cubrid_lock_read' => 'Set a read lock on the given OID',
'cubrid_lock_write' => 'Set a write lock on the given OID',
'cubrid_move_cursor' => 'Move the cursor in the result',
'cubrid_next_result' => 'Get result of next query when executing multiple SQL statements',
'cubrid_num_cols' => 'Return the number of columns in the result set',
'cubrid_num_rows' => 'Get the number of rows in the result set',
'cubrid_pconnect' => 'Open a persistent connection to a CUBRID server',
'cubrid_pconnect_with_url' => 'Open a persistent connection to CUBRID server',
'cubrid_prepare' => 'Prepare a SQL statement for execution',
'cubrid_put' => 'Update a column using OID',
'cubrid_rollback' => 'Roll back a transaction',
'cubrid_schema' => 'Get the requested schema information',
'cubrid_seq_drop' => 'Delete an element from sequence type column using OID',
'cubrid_seq_insert' => 'Insert an element to a sequence type column using OID',
'cubrid_seq_put' => 'Update the element value of sequence type column using OID',
'cubrid_set_add' => 'Insert a single element to set type column using OID',
'cubrid_set_autocommit' => 'Set autocommit mode of the connection',
'cubrid_set_db_parameter' => 'Sets the CUBRID database parameters',
'cubrid_set_drop' => 'Delete an element from set type column using OID',
'cubrid_set_query_timeout' => 'Set the timeout time of query execution',
'cubrid_version' => 'Get the CUBRID PHP module\'s version',
'curl_close' => 'Close a cURL session',
'curl_copy_handle' => 'Copy a cURL handle along with all of its preferences',
'curl_errno' => 'Return the last error number',
'curl_error' => 'Return a string containing the last error for the current session',
'curl_escape' => 'URL encodes the given string',
'curl_exec' => 'Perform a cURL session',
'curl_file_create' => 'Create a CURLFile object',
'curl_getinfo' => 'Get information regarding a specific transfer',
'curl_init' => 'Initialize a cURL session',
'curl_multi_add_handle' => 'Add a normal cURL handle to a cURL multi handle',
'curl_multi_close' => 'Close a set of cURL handles',
'curl_multi_errno' => 'Return the last multi curl error number',
'curl_multi_exec' => 'Run the sub-connections of the current cURL handle',
'curl_multi_getcontent' => 'Return the content of a cURL handle if CURLOPT_RETURNTRANSFER is set',
'curl_multi_info_read' => 'Get information about the current transfers',
'curl_multi_init' => 'Returns a new cURL multi handle',
'curl_multi_remove_handle' => 'Remove a multi handle from a set of cURL handles',
'curl_multi_select' => 'Wait for activity on any curl_multi connection',
'curl_multi_setopt' => 'Set an option for the cURL multi handle',
'curl_multi_strerror' => 'Return string describing error code',
'curl_pause' => 'Pause and unpause a connection',
'curl_reset' => 'Reset all options of a libcurl session handle',
'curl_setopt' => 'Set an option for a cURL transfer',
'curl_setopt_array' => 'Set multiple options for a cURL transfer',
'curl_share_close' => 'Close a cURL share handle',
'curl_share_errno' => 'Return the last share curl error number',
'curl_share_init' => 'Initialize a cURL share handle',
'curl_share_setopt' => 'Set an option for a cURL share handle',
'curl_share_strerror' => 'Return string describing the given error code',
'curl_strerror' => 'Return string describing the given error code',
'curl_unescape' => 'Decodes the given URL encoded string',
'curl_version' => 'Gets cURL version information',
'curlfile::__construct' => 'Create a CURLFile object',
'curlfile::__wakeup' => 'Unserialization handler',
'curlfile::getFilename' => 'Get file name',
'curlfile::getMimeType' => 'Get MIME type',
'curlfile::getPostFilename' => 'Get file name for POST',
'curlfile::setMimeType' => 'Set MIME type',
'curlfile::setPostFilename' => 'Set file name for POST',
'current' => 'Return the current element in an array',
'cyrus_authenticate' => 'Authenticate against a Cyrus IMAP server',
'cyrus_bind' => 'Bind callbacks to a Cyrus IMAP connection',
'cyrus_close' => 'Close connection to a Cyrus IMAP server',
'cyrus_connect' => 'Connect to a Cyrus IMAP server',
'cyrus_query' => 'Send a query to a Cyrus IMAP server',
'cyrus_unbind' => 'Unbind ...',
'date' => 'Format a local time/date',
'date_add' => 'Alias of DateTime::add',
'date_create' => 'Alias of DateTime::__construct',
'date_create_from_format' => 'Alias of DateTime::createFromFormat',
'date_create_immutable' => 'Alias of DateTimeImmutable::__construct',
'date_create_immutable_from_format' => 'Alias of DateTimeImmutable::createFromFormat',
'date_date_set' => 'Alias of DateTime::setDate',
'date_default_timezone_get' => 'Gets the default timezone used by all date/time functions in a script',
'date_default_timezone_set' => 'Sets the default timezone used by all date/time functions in a script',
'date_diff' => 'Alias of DateTime::diff',
'date_format' => 'Alias of DateTime::format',
'date_get_last_errors' => 'Alias of DateTime::getLastErrors',
'date_interval_create_from_date_string' => 'Alias of DateInterval::createFromDateString',
'date_interval_format' => 'Alias of DateInterval::format',
'date_isodate_set' => 'Alias of DateTime::setISODate',
'date_modify' => 'Alias of DateTime::modify',
'date_offset_get' => 'Alias of DateTime::getOffset',
'date_parse' => 'Returns associative array with detailed info about given date',
'date_parse_from_format' => 'Get info about given date formatted according to the specified format',
'date_sub' => 'Alias of DateTime::sub',
'date_sun_info' => 'Returns an array with information about sunset/sunrise and twilight begin/end',
'date_sunrise' => 'Returns time of sunrise for a given day and location',
'date_sunset' => 'Returns time of sunset for a given day and location',
'date_time_set' => 'Alias of DateTime::setTime',
'date_timestamp_get' => 'Alias of DateTime::getTimestamp',
'date_timestamp_set' => 'Alias of DateTime::setTimestamp',
'date_timezone_get' => 'Alias of DateTime::getTimezone',
'date_timezone_set' => 'Alias of DateTime::setTimezone',
'dateinterval::__construct' => 'Creates a new DateInterval object',
'dateinterval::createFromDateString' => 'Sets up a DateInterval from the relative parts of the string',
'dateinterval::format' => 'Formats the interval',
'dateperiod::__construct' => 'Creates a new DatePeriod object',
'dateperiod::getDateInterval' => 'Gets the interval',
'dateperiod::getEndDate' => 'Gets the end date',
'dateperiod::getRecurrences' => 'Gets the number of recurrences',
'dateperiod::getStartDate' => 'Gets the start date',
'datetime::__construct' => 'Returns new DateTime object',
'datetime::__set_state' => 'The __set_state handler',
'datetime::add' => 'Adds an amount of days, months, years, hours, minutes and seconds to a DateTime object',
'datetime::createFromFormat' => 'Parses a time string according to a specified format',
'datetime::createFromImmutable' => 'Returns new DateTime object encapsulating the given DateTimeImmutable object',
'DateTime::diff' => 'Returns the difference between two DateTime objects represented as a DateInterval.',
'DateTime::format' => 'Returns date formatted according to given format.',
'datetime::getLastErrors' => 'Returns the warnings and errors',
'DateTime::getOffset' => 'Returns the timezone offset',
'DateTime::getTimestamp' => 'Gets the Unix timestamp.',
'DateTime::getTimezone' => 'Get the TimeZone associated with the DateTime',
'datetime::modify' => 'Alters the timestamp',
'datetime::setDate' => 'Sets the date',
'datetime::setISODate' => 'Sets the ISO date',
'datetime::setTime' => 'Sets the time',
'datetime::setTimestamp' => 'Sets the date and time based on an Unix timestamp',
'datetime::setTimezone' => 'Sets the time zone for the DateTime object',
'datetime::sub' => 'Subtracts an amount of days, months, years, hours, minutes and seconds from a DateTime object',
'datetimeimmutable::__construct' => 'Returns new DateTimeImmutable object',
'datetimeimmutable::__set_state' => 'The __set_state handler',
'DateTimeImmutable::__wakeup' => 'The __wakeup handler',
'datetimeimmutable::add' => 'Adds an amount of days, months, years, hours, minutes and seconds',
'datetimeimmutable::createFromFormat' => 'Parses a time string according to a specified format',
'datetimeimmutable::createFromMutable' => 'Returns new DateTimeImmutable object encapsulating the given DateTime object',
'DateTimeImmutable::diff' => 'Returns the difference between two DateTime objects',
'DateTimeImmutable::format' => 'Returns date formatted according to given format',
'datetimeimmutable::getLastErrors' => 'Returns the warnings and errors',
'DateTimeImmutable::getOffset' => 'Returns the timezone offset',
'DateTimeImmutable::getTimestamp' => 'Gets the Unix timestamp',
'DateTimeImmutable::getTimezone' => 'Return time zone relative to given DateTime',
'datetimeimmutable::modify' => 'Creates a new object with modified timestamp',
'datetimeimmutable::setDate' => 'Sets the date',
'datetimeimmutable::setISODate' => 'Sets the ISO date',
'datetimeimmutable::setTime' => 'Sets the time',
'datetimeimmutable::setTimestamp' => 'Sets the date and time based on a Unix timestamp',
'datetimeimmutable::setTimezone' => 'Sets the time zone',
'datetimeimmutable::sub' => 'Subtracts an amount of days, months, years, hours, minutes and seconds',
'DateTimeInterface::__wakeup' => 'The __wakeup handler',
'DateTimeInterface::diff' => 'Returns the difference between two DateTime objects',
'DateTimeInterface::format' => 'Returns date formatted according to given format',
'DateTimeInterface::getOffset' => 'Returns the timezone offset',
'DateTimeInterface::getTimestamp' => 'Gets the Unix timestamp',
'DateTimeInterface::getTimezone' => 'Return time zone relative to given DateTime',
'datetimezone::__construct' => 'Creates new DateTimeZone object',
'datetimezone::getLocation' => 'Returns location information for a timezone',
'datetimezone::getName' => 'Returns the name of the timezone',
'datetimezone::getOffset' => 'Returns the timezone offset from GMT',
'datetimezone::getTransitions' => 'Returns all transitions for the timezone',
'datetimezone::listAbbreviations' => 'Returns associative array containing dst, offset and the timezone name',
'datetimezone::listIdentifiers' => 'Returns a numerically indexed array containing all defined timezone identifiers',
'db2_autocommit' => 'Returns or sets the AUTOCOMMIT state for a database connection',
'db2_bind_param' => 'Binds a PHP variable to an SQL statement parameter',
'db2_client_info' => 'Returns an object with properties that describe the DB2 database client',
'db2_close' => 'Closes a database connection',
'db2_column_privileges' => 'Returns a result set listing the columns and associated privileges for a table',
'db2_columns' => 'Returns a result set listing the columns and associated metadata for a table',
'db2_commit' => 'Commits a transaction',
'db2_conn_error' => 'Returns a string containing the SQLSTATE returned by the last connection attempt',
'db2_conn_errormsg' => 'Returns the last connection error message and SQLCODE value',
'db2_connect' => 'Returns a connection to a database',
'db2_cursor_type' => 'Returns the cursor type used by a statement resource',
'db2_escape_string' => 'Used to escape certain characters',
'db2_exec' => 'Executes an SQL statement directly',
'db2_execute' => 'Executes a prepared SQL statement',
'db2_fetch_array' => 'Returns an array, indexed by column position, representing a row in a result set',
'db2_fetch_assoc' => 'Returns an array, indexed by column name, representing a row in a result set',
'db2_fetch_both' => 'Returns an array, indexed by both column name and position, representing a row in a result set',
'db2_fetch_object' => 'Returns an object with properties representing columns in the fetched row',
'db2_fetch_row' => 'Sets the result set pointer to the next row or requested row',
'db2_field_display_size' => 'Returns the maximum number of bytes required to display a column',
'db2_field_name' => 'Returns the name of the column in the result set',
'db2_field_num' => 'Returns the position of the named column in a result set',
'db2_field_precision' => 'Returns the precision of the indicated column in a result set',
'db2_field_scale' => 'Returns the scale of the indicated column in a result set',
'db2_field_type' => 'Returns the data type of the indicated column in a result set',
'db2_field_width' => 'Returns the width of the current value of the indicated column in a result set',
'db2_foreign_keys' => 'Returns a result set listing the foreign keys for a table',
'db2_free_result' => 'Frees resources associated with a result set',
'db2_free_stmt' => 'Frees resources associated with the indicated statement resource',
'db2_get_option' => 'Retrieves an option value for a statement resource or a connection resource',
'db2_last_insert_id' => 'Returns the auto generated ID of the last insert query that successfully executed on this connection',
'db2_lob_read' => 'Gets a user defined size of LOB files with each invocation',
'db2_next_result' => 'Requests the next result set from a stored procedure',
'db2_num_fields' => 'Returns the number of fields contained in a result set',
'db2_num_rows' => 'Returns the number of rows affected by an SQL statement',
'db2_pclose' => 'Closes a persistent database connection',
'db2_pconnect' => 'Returns a persistent connection to a database',
'db2_prepare' => 'Prepares an SQL statement to be executed',
'db2_primary_keys' => 'Returns a result set listing primary keys for a table',
'db2_procedure_columns' => 'Returns a result set listing stored procedure parameters',
'db2_procedures' => 'Returns a result set listing the stored procedures registered in a database',
'db2_result' => 'Returns a single column from a row in the result set',
'db2_rollback' => 'Rolls back a transaction',
'db2_server_info' => 'Returns an object with properties that describe the DB2 database server',
'db2_set_option' => 'Set options for connection or statement resources',
'db2_special_columns' => 'Returns a result set listing the unique row identifier columns for a table',
'db2_statistics' => 'Returns a result set listing the index and statistics for a table',
'db2_stmt_error' => 'Returns a string containing the SQLSTATE returned by an SQL statement',
'db2_stmt_errormsg' => 'Returns a string containing the last SQL statement error message',
'db2_table_privileges' => 'Returns a result set listing the tables and associated privileges in a database',
'db2_tables' => 'Returns a result set listing the tables and associated metadata in a database',
'dba_close' => 'Close a DBA database',
'dba_delete' => 'Delete DBA entry specified by key',
'dba_exists' => 'Check whether key exists',
'dba_fetch' => 'Fetch data specified by key',
'dba_firstkey' => 'Fetch first key',
'dba_handlers' => 'List all the handlers available',
'dba_insert' => 'Insert entry',
'dba_key_split' => 'Splits a key in string representation into array representation',
'dba_list' => 'List all open database files',
'dba_nextkey' => 'Fetch next key',
'dba_open' => 'Open database',
'dba_optimize' => 'Optimize database',
'dba_popen' => 'Open database persistently',
'dba_replace' => 'Replace or insert entry',
'dba_sync' => 'Synchronize database',
'dbase_add_record' => 'Adds a record to a database',
'dbase_close' => 'Closes a database',
'dbase_create' => 'Creates a database',
'dbase_delete_record' => 'Deletes a record from a database',
'dbase_get_header_info' => 'Gets the header info of a database',
'dbase_get_record' => 'Gets a record from a database as an indexed array',
'dbase_get_record_with_names' => 'Gets a record from a database as an associative array',
'dbase_numfields' => 'Gets the number of fields of a database',
'dbase_numrecords' => 'Gets the number of records in a database',
'dbase_open' => 'Opens a database',
'dbase_pack' => 'Packs a database',
'dbase_replace_record' => 'Replaces a record in a database',
'dbplus_add' => 'Add a tuple to a relation',
'dbplus_aql' => 'Perform AQL query',
'dbplus_chdir' => 'Get/Set database virtual current directory',
'dbplus_close' => 'Close a relation',
'dbplus_curr' => 'Get current tuple from relation',
'dbplus_errcode' => 'Get error string for given errorcode or last error',
'dbplus_errno' => 'Get error code for last operation',
'dbplus_find' => 'Set a constraint on a relation',
'dbplus_first' => 'Get first tuple from relation',
'dbplus_flush' => 'Flush all changes made on a relation',
'dbplus_freealllocks' => 'Free all locks held by this client',
'dbplus_freelock' => 'Release write lock on tuple',
'dbplus_freerlocks' => 'Free all tuple locks on given relation',
'dbplus_getlock' => 'Get a write lock on a tuple',
'dbplus_getunique' => 'Get an id number unique to a relation',
'dbplus_info' => 'Get information about a relation',
'dbplus_last' => 'Get last tuple from relation',
'dbplus_lockrel' => 'Request write lock on relation',
'dbplus_next' => 'Get next tuple from relation',
'dbplus_open' => 'Open relation file',
'dbplus_prev' => 'Get previous tuple from relation',
'dbplus_rchperm' => 'Change relation permissions',
'dbplus_rcreate' => 'Creates a new DB++ relation',
'dbplus_rcrtexact' => 'Creates an exact but empty copy of a relation including indices',
'dbplus_rcrtlike' => 'Creates an empty copy of a relation with default indices',
'dbplus_resolve' => 'Resolve host information for relation',
'dbplus_restorepos' => 'Restore position',
'dbplus_rkeys' => 'Specify new primary key for a relation',
'dbplus_ropen' => 'Open relation file local',
'dbplus_rquery' => 'Perform local (raw) AQL query',
'dbplus_rrename' => 'Rename a relation',
'dbplus_rsecindex' => 'Create a new secondary index for a relation',
'dbplus_runlink' => 'Remove relation from filesystem',
'dbplus_rzap' => 'Remove all tuples from relation',
'dbplus_savepos' => 'Save position',
'dbplus_setindex' => 'Set index',
'dbplus_setindexbynumber' => 'Set index by number',
'dbplus_sql' => 'Perform SQL query',
'dbplus_tcl' => 'Execute TCL code on server side',
'dbplus_tremove' => 'Remove tuple and return new current tuple',
'dbplus_undo' => 'Undo',
'dbplus_undoprepare' => 'Prepare undo',
'dbplus_unlockrel' => 'Give up write lock on relation',
'dbplus_unselect' => 'Remove a constraint from relation',
'dbplus_update' => 'Update specified tuple in relation',
'dbplus_xlockrel' => 'Request exclusive lock on relation',
'dbplus_xunlockrel' => 'Free exclusive lock on relation',
'dbx_close' => 'Close an open connection/database',
'dbx_compare' => 'Compare two rows for sorting purposes',
'dbx_connect' => 'Open a connection/database',
'dbx_error' => 'Report the error message of the latest function call in the module',
'dbx_escape_string' => 'Escape a string so it can safely be used in an sql-statement',
'dbx_fetch_row' => 'Fetches rows from a query-result that had the DBX_RESULT_UNBUFFERED flag set',
'dbx_query' => 'Send a query and fetch all results (if any)',
'dbx_sort' => 'Sort a result from a dbx_query by a custom sort function',
'dcgettext' => 'Overrides the domain for a single lookup',
'dcngettext' => 'Plural version of dcgettext',
'debug_backtrace' => 'Generates a backtrace',
'debug_print_backtrace' => 'Prints a backtrace',
'debug_zval_dump' => 'Dumps a string representation of an internal zend value to output',
'decbin' => 'Decimal to binary',
'dechex' => 'Decimal to hexadecimal',
'decoct' => 'Decimal to octal',
'define' => 'Defines a named constant',
'define_syslog_variables' => 'Initializes all syslog related variables',
'defined' => 'Checks whether a given named constant exists',
'deflate_add' => 'Incrementally deflate data',
'deflate_init' => 'Initialize an incremental deflate context',
'deg2rad' => 'Converts the number in degrees to the radian equivalent',
'delete' => 'See unlink or unset',
'dgettext' => 'Override the current domain',
'die' => 'Equivalent to exit',
'dio_close' => 'Closes the file descriptor given by fd',
'dio_fcntl' => 'Performs a c library fcntl on fd',
'dio_open' => 'Opens a file (creating it if necessary) at a lower level than the C library input/output stream functions allow',
'dio_read' => 'Reads bytes from a file descriptor',
'dio_seek' => 'Seeks to pos on fd from whence',
'dio_stat' => 'Gets stat information about the file descriptor fd',
'dio_tcsetattr' => 'Sets terminal attributes and baud rate for a serial port',
'dio_truncate' => 'Truncates file descriptor fd to offset bytes',
'dio_write' => 'Writes data to fd with optional truncation at length',
'dir' => 'Return an instance of the Directory class',
'directory::close' => 'Close directory handle',
'directory::read' => 'Read entry from directory handle',
'directory::rewind' => 'Rewind directory handle',
'DirectoryIterator::__construct' => 'Constructs a new directory iterator from a path',
'DirectoryIterator::__toString' => 'Get file name as a string',
'DirectoryIterator::current' => 'Return the current DirectoryIterator item',
'DirectoryIterator::getATime' => 'Get last access time of the current DirectoryIterator item',
'DirectoryIterator::getBasename' => 'Get base name of current DirectoryIterator item',
'DirectoryIterator::getCTime' => 'Get inode change time of the current DirectoryIterator item',
'DirectoryIterator::getExtension' => 'Gets the file extension',
'DirectoryIterator::getFileInfo' => 'Gets an SplFileInfo object for the file',
'DirectoryIterator::getFilename' => 'Return file name of current DirectoryIterator item',
'DirectoryIterator::getGroup' => 'Get group for the current DirectoryIterator item',
'DirectoryIterator::getInode' => 'Get inode for the current DirectoryIterator item',
'DirectoryIterator::getLinkTarget' => 'Gets the target of a link',
'DirectoryIterator::getMTime' => 'Get last modification time of current DirectoryIterator item',
'DirectoryIterator::getOwner' => 'Get owner of current DirectoryIterator item',
'DirectoryIterator::getPath' => 'Get path of current Iterator item without filename',
'DirectoryIterator::getPathInfo' => 'Gets an SplFileInfo object for the path',
'DirectoryIterator::getPathname' => 'Return path and file name of current DirectoryIterator item',
'DirectoryIterator::getPerms' => 'Get the permissions of current DirectoryIterator item',
'DirectoryIterator::getRealPath' => 'Gets absolute path to file',
'DirectoryIterator::getSize' => 'Get size of current DirectoryIterator item',
'DirectoryIterator::getType' => 'Determine the type of the current DirectoryIterator item',
'DirectoryIterator::isDir' => 'Determine if current DirectoryIterator item is a directory',
'DirectoryIterator::isDot' => 'Determine if current DirectoryIterator item is \'.\' or \'..\'',
'DirectoryIterator::isExecutable' => 'Determine if current DirectoryIterator item is executable',
'DirectoryIterator::isFile' => 'Determine if current DirectoryIterator item is a regular file',
'DirectoryIterator::isLink' => 'Determine if current DirectoryIterator item is a symbolic link',
'DirectoryIterator::isReadable' => 'Determine if current DirectoryIterator item can be read',
'DirectoryIterator::isWritable' => 'Determine if current DirectoryIterator item can be written to',
'DirectoryIterator::key' => 'Return the key for the current DirectoryIterator item',
'DirectoryIterator::next' => 'Move forward to next DirectoryIterator item',
'DirectoryIterator::openFile' => 'Gets an SplFileObject object for the file',
'DirectoryIterator::rewind' => 'Rewind the DirectoryIterator back to the start',
'DirectoryIterator::seek' => 'Seek to a DirectoryIterator item',
'DirectoryIterator::setFileClass' => 'Sets the class used with SplFileInfo::openFile',
'DirectoryIterator::setInfoClass' => 'Sets the class used with SplFileInfo::getFileInfo and SplFileInfo::getPathInfo',
'DirectoryIterator::valid' => 'Check whether current DirectoryIterator position is a valid file',
'dirname' => 'Returns a parent directory\'s path',
'disk_free_space' => 'Returns available space on filesystem or disk partition',
'disk_total_space' => 'Returns the total size of a filesystem or disk partition',
'diskfreespace' => 'Alias of disk_free_space',
'DivisionByZeroError::__clone' => 'Clone the error
Error can not be clone, so this method results in fatal error.',
'DivisionByZeroError::__toString' => 'Gets a string representation of the thrown object',
'DivisionByZeroError::getCode' => 'Gets the exception code',
'DivisionByZeroError::getFile' => 'Gets the file in which the exception occurred',
'DivisionByZeroError::getLine' => 'Gets the line on which the object was instantiated',
'DivisionByZeroError::getPrevious' => 'Returns the previous Throwable',
'DivisionByZeroError::getTrace' => 'Gets the stack trace',
'DivisionByZeroError::getTraceAsString' => 'Gets the stack trace as a string',
'dl' => 'Loads a PHP extension at runtime',
'dngettext' => 'Plural version of dgettext',
'dns_check_record' => 'Alias of checkdnsrr',
'dns_get_mx' => 'Alias of getmxrr',
'dns_get_record' => 'Fetch DNS Resource Records associated with a hostname',
'dom_import_simplexml' => 'Gets a DOMElement object from a SimpleXMLElement object',
'DomainException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'DomainException::__toString' => 'String representation of the exception',
'DomainException::getCode' => 'Gets the Exception code',
'DomainException::getFile' => 'Gets the file in which the exception occurred',
'DomainException::getLine' => 'Gets the line in which the exception occurred',
'DomainException::getMessage' => 'Gets the Exception message',
'DomainException::getPrevious' => 'Returns previous Exception',
'DomainException::getTrace' => 'Gets the stack trace',
'DomainException::getTraceAsString' => 'Gets the stack trace as a string',
'domattr::__construct' => 'Creates a new DOMAttr object',
'DOMAttr::appendChild' => 'Adds new child at the end of the children',
'DOMAttr::C14N' => 'Canonicalize nodes to a string',
'DOMAttr::C14NFile' => 'Canonicalize nodes to a file',
'DOMAttr::cloneNode' => 'Clones a node',
'DOMAttr::getLineNo' => 'Get line number for a node',
'DOMAttr::getNodePath' => 'Get an XPath for a node',
'DOMAttr::hasAttributes' => 'Checks if node has attributes',
'DOMAttr::hasChildNodes' => 'Checks if node has children',
'DOMAttr::insertBefore' => 'Adds a new child before a reference node',
'DOMAttr::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'domattr::isId' => 'Checks if attribute is a defined ID',
'DOMAttr::isSameNode' => 'Indicates if two nodes are the same node',
'DOMAttr::isSupported' => 'Checks if feature is supported for specified version',
'DOMAttr::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'DOMAttr::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'DOMAttr::normalize' => 'Normalizes the node',
'DOMAttr::removeChild' => 'Removes child from list of children',
'DOMAttr::replaceChild' => 'Replaces a child',
'domcdatasection::__construct' => 'Constructs a new DOMCdataSection object',
'DOMCdataSection::appendChild' => 'Adds new child at the end of the children',
'DOMCdataSection::appendData' => 'Append the string to the end of the character data of the node',
'DOMCdataSection::C14N' => 'Canonicalize nodes to a string',
'DOMCdataSection::C14NFile' => 'Canonicalize nodes to a file',
'DOMCdataSection::cloneNode' => 'Clones a node',
'DOMCdataSection::deleteData' => 'Remove a range of characters from the node',
'DOMCdataSection::getLineNo' => 'Get line number for a node',
'DOMCdataSection::getNodePath' => 'Get an XPath for a node',
'DOMCdataSection::hasAttributes' => 'Checks if node has attributes',
'DOMCdataSection::hasChildNodes' => 'Checks if node has children',
'DOMCdataSection::insertBefore' => 'Adds a new child before a reference node',
'DOMCdataSection::insertData' => 'Insert a string at the specified 16-bit unit offset',
'DOMCdataSection::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'DOMCdataSection::isElementContentWhitespace' => 'Returns whether this text node contains whitespace in element content',
'DOMCdataSection::isSameNode' => 'Indicates if two nodes are the same node',
'DOMCdataSection::isSupported' => 'Checks if feature is supported for specified version',
'DOMCdataSection::isWhitespaceInElementContent' => 'Indicates whether this text node contains whitespace',
'DOMCdataSection::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'DOMCdataSection::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'DOMCdataSection::normalize' => 'Normalizes the node',
'DOMCdataSection::removeChild' => 'Removes child from list of children',
'DOMCdataSection::replaceChild' => 'Replaces a child',
'DOMCdataSection::replaceData' => 'Replace a substring within the DOMCharacterData node',
'DOMCdataSection::splitText' => 'Breaks this node into two nodes at the specified offset',
'DOMCdataSection::substringData' => 'Extracts a range of data from the node',
'DOMCharacterData::appendChild' => 'Adds new child at the end of the children',
'domcharacterdata::appendData' => 'Append the string to the end of the character data of the node',
'DOMCharacterData::C14N' => 'Canonicalize nodes to a string',
'DOMCharacterData::C14NFile' => 'Canonicalize nodes to a file',
'DOMCharacterData::cloneNode' => 'Clones a node',
'domcharacterdata::deleteData' => 'Remove a range of characters from the node',
'DOMCharacterData::getLineNo' => 'Get line number for a node',
'DOMCharacterData::getNodePath' => 'Get an XPath for a node',
'DOMCharacterData::hasAttributes' => 'Checks if node has attributes',
'DOMCharacterData::hasChildNodes' => 'Checks if node has children',
'DOMCharacterData::insertBefore' => 'Adds a new child before a reference node',
'domcharacterdata::insertData' => 'Insert a string at the specified 16-bit unit offset',
'DOMCharacterData::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'DOMCharacterData::isSameNode' => 'Indicates if two nodes are the same node',
'DOMCharacterData::isSupported' => 'Checks if feature is supported for specified version',
'DOMCharacterData::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'DOMCharacterData::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'DOMCharacterData::normalize' => 'Normalizes the node',
'DOMCharacterData::removeChild' => 'Removes child from list of children',
'DOMCharacterData::replaceChild' => 'Replaces a child',
'domcharacterdata::replaceData' => 'Replace a substring within the DOMCharacterData node',
'domcharacterdata::substringData' => 'Extracts a range of data from the node',
'domcomment::__construct' => 'Creates a new DOMComment object',
'DOMComment::appendChild' => 'Adds new child at the end of the children',
'DOMComment::appendData' => 'Append the string to the end of the character data of the node',
'DOMComment::C14N' => 'Canonicalize nodes to a string',
'DOMComment::C14NFile' => 'Canonicalize nodes to a file',
'DOMComment::cloneNode' => 'Clones a node',
'DOMComment::deleteData' => 'Remove a range of characters from the node',
'DOMComment::getLineNo' => 'Get line number for a node',
'DOMComment::getNodePath' => 'Get an XPath for a node',
'DOMComment::hasAttributes' => 'Checks if node has attributes',
'DOMComment::hasChildNodes' => 'Checks if node has children',
'DOMComment::insertBefore' => 'Adds a new child before a reference node',
'DOMComment::insertData' => 'Insert a string at the specified 16-bit unit offset',
'DOMComment::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'DOMComment::isSameNode' => 'Indicates if two nodes are the same node',
'DOMComment::isSupported' => 'Checks if feature is supported for specified version',
'DOMComment::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'DOMComment::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'DOMComment::normalize' => 'Normalizes the node',
'DOMComment::removeChild' => 'Removes child from list of children',
'DOMComment::replaceChild' => 'Replaces a child',
'DOMComment::replaceData' => 'Replace a substring within the DOMCharacterData node',
'DOMComment::substringData' => 'Extracts a range of data from the node',
'domdocument::__construct' => 'Creates a new DOMDocument object',
'DOMDocument::appendChild' => 'Adds new child at the end of the children',
'DOMDocument::C14N' => 'Canonicalize nodes to a string',
'DOMDocument::C14NFile' => 'Canonicalize nodes to a file',
'DOMDocument::cloneNode' => 'Clones a node',
'domdocument::createAttribute' => 'Create new attribute',
'domdocument::createAttributeNS' => 'Create new attribute node with an associated namespace',
'domdocument::createCDATASection' => 'Create new cdata node',
'domdocument::createComment' => 'Create new comment node',
'domdocument::createDocumentFragment' => 'Create new document fragment',
'domdocument::createElement' => 'Create new element node',
'domdocument::createElementNS' => 'Create new element node with an associated namespace',
'domdocument::createEntityReference' => 'Create new entity reference node',
'domdocument::createProcessingInstruction' => 'Creates new PI node',
'domdocument::createTextNode' => 'Create new text node',
'domdocument::getElementById' => 'Searches for an element with a certain id',
'domdocument::getElementsByTagName' => 'Searches for all elements with given local tag name',
'domdocument::getElementsByTagNameNS' => 'Searches for all elements with given tag name in specified namespace',
'DOMDocument::getLineNo' => 'Get line number for a node',
'DOMDocument::getNodePath' => 'Get an XPath for a node',
'DOMDocument::hasAttributes' => 'Checks if node has attributes',
'DOMDocument::hasChildNodes' => 'Checks if node has children',
'domdocument::importNode' => 'Import node into current document',
'DOMDocument::insertBefore' => 'Adds a new child before a reference node',
'DOMDocument::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'DOMDocument::isSameNode' => 'Indicates if two nodes are the same node',
'DOMDocument::isSupported' => 'Checks if feature is supported for specified version',
'domdocument::load' => 'Load XML from a file',
'domdocument::loadHTML' => 'Load HTML from a string',
'domdocument::loadHTMLFile' => 'Load HTML from a file',
'domdocument::loadXML' => 'Load XML from a string',
'DOMDocument::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'DOMDocument::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'DOMDocument::normalize' => 'Normalizes the node',
'domdocument::normalizeDocument' => 'Normalizes the document',
'domdocument::registerNodeClass' => 'Register extended class used to create base node type',
'domdocument::relaxNGValidate' => 'Performs relaxNG validation on the document',
'domdocument::relaxNGValidateSource' => 'Performs relaxNG validation on the document',
'DOMDocument::removeChild' => 'Removes child from list of children',
'DOMDocument::replaceChild' => 'Replaces a child',
'domdocument::save' => 'Dumps the internal XML tree back into a file',
'domdocument::saveHTML' => 'Dumps the internal document into a string using HTML formatting',
'domdocument::saveHTMLFile' => 'Dumps the internal document into a file using HTML formatting',
'domdocument::saveXML' => 'Dumps the internal XML tree back into a string',
'domdocument::schemaValidate' => 'Validates a document based on a schema',
'domdocument::schemaValidateSource' => 'Validates a document based on a schema',
'domdocument::validate' => 'Validates the document based on its DTD',
'domdocument::xinclude' => 'Substitutes XIncludes in a DOMDocument Object',
'DOMDocumentFragment::appendChild' => 'Adds new child at the end of the children',
'domdocumentfragment::appendXML' => 'Append raw XML data',
'DOMDocumentFragment::C14N' => 'Canonicalize nodes to a string',
'DOMDocumentFragment::C14NFile' => 'Canonicalize nodes to a file',
'DOMDocumentFragment::cloneNode' => 'Clones a node',
'DOMDocumentFragment::getLineNo' => 'Get line number for a node',
'DOMDocumentFragment::getNodePath' => 'Get an XPath for a node',
'DOMDocumentFragment::hasAttributes' => 'Checks if node has attributes',
'DOMDocumentFragment::hasChildNodes' => 'Checks if node has children',
'DOMDocumentFragment::insertBefore' => 'Adds a new child before a reference node',
'DOMDocumentFragment::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'DOMDocumentFragment::isSameNode' => 'Indicates if two nodes are the same node',
'DOMDocumentFragment::isSupported' => 'Checks if feature is supported for specified version',
'DOMDocumentFragment::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'DOMDocumentFragment::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'DOMDocumentFragment::normalize' => 'Normalizes the node',
'DOMDocumentFragment::removeChild' => 'Removes child from list of children',
'DOMDocumentFragment::replaceChild' => 'Replaces a child',
'DOMDocumentType::appendChild' => 'Adds new child at the end of the children',
'DOMDocumentType::C14N' => 'Canonicalize nodes to a string',
'DOMDocumentType::C14NFile' => 'Canonicalize nodes to a file',
'DOMDocumentType::cloneNode' => 'Clones a node',
'DOMDocumentType::getLineNo' => 'Get line number for a node',
'DOMDocumentType::getNodePath' => 'Get an XPath for a node',
'DOMDocumentType::hasAttributes' => 'Checks if node has attributes',
'DOMDocumentType::hasChildNodes' => 'Checks if node has children',
'DOMDocumentType::insertBefore' => 'Adds a new child before a reference node',
'DOMDocumentType::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'DOMDocumentType::isSameNode' => 'Indicates if two nodes are the same node',
'DOMDocumentType::isSupported' => 'Checks if feature is supported for specified version',
'DOMDocumentType::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'DOMDocumentType::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'DOMDocumentType::normalize' => 'Normalizes the node',
'DOMDocumentType::removeChild' => 'Removes child from list of children',
'DOMDocumentType::replaceChild' => 'Replaces a child',
'domelement::__construct' => 'Creates a new DOMElement object',
'DOMElement::appendChild' => 'Adds new child at the end of the children',
'DOMElement::C14N' => 'Canonicalize nodes to a string',
'DOMElement::C14NFile' => 'Canonicalize nodes to a file',
'DOMElement::cloneNode' => 'Clones a node',
'domelement::getAttribute' => 'Returns value of attribute',
'domelement::getAttributeNode' => 'Returns attribute node',
'domelement::getAttributeNodeNS' => 'Returns attribute node',
'domelement::getAttributeNS' => 'Returns value of attribute',
'domelement::getElementsByTagName' => 'Gets elements by tagname',
'domelement::getElementsByTagNameNS' => 'Get elements by namespaceURI and localName',
'DOMElement::getLineNo' => 'Get line number for a node',
'DOMElement::getNodePath' => 'Get an XPath for a node',
'domelement::hasAttribute' => 'Checks to see if attribute exists',
'domelement::hasAttributeNS' => 'Checks to see if attribute exists',
'DOMElement::hasAttributes' => 'Checks if node has attributes',
'DOMElement::hasChildNodes' => 'Checks if node has children',
'DOMElement::insertBefore' => 'Adds a new child before a reference node',
'DOMElement::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'DOMElement::isSameNode' => 'Indicates if two nodes are the same node',
'DOMElement::isSupported' => 'Checks if feature is supported for specified version',
'DOMElement::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'DOMElement::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'DOMElement::normalize' => 'Normalizes the node',
'domelement::removeAttribute' => 'Removes attribute',
'domelement::removeAttributeNode' => 'Removes attribute',
'domelement::removeAttributeNS' => 'Removes attribute',
'DOMElement::removeChild' => 'Removes child from list of children',
'DOMElement::replaceChild' => 'Replaces a child',
'domelement::setAttribute' => 'Adds new attribute',
'domelement::setAttributeNode' => 'Adds new attribute node to element',
'domelement::setAttributeNodeNS' => 'Adds new attribute node to element',
'domelement::setAttributeNS' => 'Adds new attribute',
'domelement::setIdAttribute' => 'Declares the attribute specified by name to be of type ID',
'domelement::setIdAttributeNode' => 'Declares the attribute specified by node to be of type ID',
'domelement::setIdAttributeNS' => 'Declares the attribute specified by local name and namespace URI to be of type ID',
'DOMEntity::appendChild' => 'Adds new child at the end of the children',
'DOMEntity::C14N' => 'Canonicalize nodes to a string',
'DOMEntity::C14NFile' => 'Canonicalize nodes to a file',
'DOMEntity::cloneNode' => 'Clones a node',
'DOMEntity::getLineNo' => 'Get line number for a node',
'DOMEntity::getNodePath' => 'Get an XPath for a node',
'DOMEntity::hasAttributes' => 'Checks if node has attributes',
'DOMEntity::hasChildNodes' => 'Checks if node has children',
'DOMEntity::insertBefore' => 'Adds a new child before a reference node',
'DOMEntity::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'DOMEntity::isSameNode' => 'Indicates if two nodes are the same node',
'DOMEntity::isSupported' => 'Checks if feature is supported for specified version',
'DOMEntity::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'DOMEntity::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'DOMEntity::normalize' => 'Normalizes the node',
'DOMEntity::removeChild' => 'Removes child from list of children',
'DOMEntity::replaceChild' => 'Replaces a child',
'domentityreference::__construct' => 'Creates a new DOMEntityReference object',
'DOMEntityReference::appendChild' => 'Adds new child at the end of the children',
'DOMEntityReference::C14N' => 'Canonicalize nodes to a string',
'DOMEntityReference::C14NFile' => 'Canonicalize nodes to a file',
'DOMEntityReference::cloneNode' => 'Clones a node',
'DOMEntityReference::getLineNo' => 'Get line number for a node',
'DOMEntityReference::getNodePath' => 'Get an XPath for a node',
'DOMEntityReference::hasAttributes' => 'Checks if node has attributes',
'DOMEntityReference::hasChildNodes' => 'Checks if node has children',
'DOMEntityReference::insertBefore' => 'Adds a new child before a reference node',
'DOMEntityReference::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'DOMEntityReference::isSameNode' => 'Indicates if two nodes are the same node',
'DOMEntityReference::isSupported' => 'Checks if feature is supported for specified version',
'DOMEntityReference::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'DOMEntityReference::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'DOMEntityReference::normalize' => 'Normalizes the node',
'DOMEntityReference::removeChild' => 'Removes child from list of children',
'DOMEntityReference::replaceChild' => 'Replaces a child',
'DOMException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'DOMException::__toString' => 'String representation of the exception',
'DOMException::getCode' => 'Gets the Exception code',
'DOMException::getFile' => 'Gets the file in which the exception occurred',
'DOMException::getLine' => 'Gets the line in which the exception occurred',
'DOMException::getMessage' => 'Gets the Exception message',
'DOMException::getPrevious' => 'Returns previous Exception',
'DOMException::getTrace' => 'Gets the stack trace',
'DOMException::getTraceAsString' => 'Gets the stack trace as a string',
'domimplementation::__construct' => 'Creates a new DOMImplementation object',
'domimplementation::createDocument' => 'Creates a DOMDocument object of the specified type with its document element',
'domimplementation::createDocumentType' => 'Creates an empty DOMDocumentType object',
'domimplementation::hasFeature' => 'Test if the DOM implementation implements a specific feature',
'domnamednodemap::count' => 'Get number of nodes in the map',
'domnamednodemap::getNamedItem' => 'Retrieves a node specified by name',
'domnamednodemap::getNamedItemNS' => 'Retrieves a node specified by local name and namespace URI',
'domnamednodemap::item' => 'Retrieves a node specified by index',
'domnode::appendChild' => 'Adds new child at the end of the children',
'domnode::C14N' => 'Canonicalize nodes to a string',
'domnode::C14NFile' => 'Canonicalize nodes to a file',
'domnode::cloneNode' => 'Clones a node',
'domnode::getLineNo' => 'Get line number for a node',
'domnode::getNodePath' => 'Get an XPath for a node',
'domnode::hasAttributes' => 'Checks if node has attributes',
'domnode::hasChildNodes' => 'Checks if node has children',
'domnode::insertBefore' => 'Adds a new child before a reference node',
'domnode::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'domnode::isSameNode' => 'Indicates if two nodes are the same node',
'domnode::isSupported' => 'Checks if feature is supported for specified version',
'domnode::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'domnode::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'domnode::normalize' => 'Normalizes the node',
'domnode::removeChild' => 'Removes child from list of children',
'domnode::replaceChild' => 'Replaces a child',
'domnodelist::count' => 'Get number of nodes in the list',
'domnodelist::item' => 'Retrieves a node specified by index',
'DOMNotation::appendChild' => 'Adds new child at the end of the children',
'DOMNotation::C14N' => 'Canonicalize nodes to a string',
'DOMNotation::C14NFile' => 'Canonicalize nodes to a file',
'DOMNotation::cloneNode' => 'Clones a node',
'DOMNotation::getLineNo' => 'Get line number for a node',
'DOMNotation::getNodePath' => 'Get an XPath for a node',
'DOMNotation::hasAttributes' => 'Checks if node has attributes',
'DOMNotation::hasChildNodes' => 'Checks if node has children',
'DOMNotation::insertBefore' => 'Adds a new child before a reference node',
'DOMNotation::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'DOMNotation::isSameNode' => 'Indicates if two nodes are the same node',
'DOMNotation::isSupported' => 'Checks if feature is supported for specified version',
'DOMNotation::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'DOMNotation::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'DOMNotation::normalize' => 'Normalizes the node',
'DOMNotation::removeChild' => 'Removes child from list of children',
'DOMNotation::replaceChild' => 'Replaces a child',
'domprocessinginstruction::__construct' => 'Creates a new DOMProcessingInstruction object',
'DOMProcessingInstruction::appendChild' => 'Adds new child at the end of the children',
'DOMProcessingInstruction::C14N' => 'Canonicalize nodes to a string',
'DOMProcessingInstruction::C14NFile' => 'Canonicalize nodes to a file',
'DOMProcessingInstruction::cloneNode' => 'Clones a node',
'DOMProcessingInstruction::getLineNo' => 'Get line number for a node',
'DOMProcessingInstruction::getNodePath' => 'Get an XPath for a node',
'DOMProcessingInstruction::hasAttributes' => 'Checks if node has attributes',
'DOMProcessingInstruction::hasChildNodes' => 'Checks if node has children',
'DOMProcessingInstruction::insertBefore' => 'Adds a new child before a reference node',
'DOMProcessingInstruction::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'DOMProcessingInstruction::isSameNode' => 'Indicates if two nodes are the same node',
'DOMProcessingInstruction::isSupported' => 'Checks if feature is supported for specified version',
'DOMProcessingInstruction::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'DOMProcessingInstruction::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'DOMProcessingInstruction::normalize' => 'Normalizes the node',
'DOMProcessingInstruction::removeChild' => 'Removes child from list of children',
'DOMProcessingInstruction::replaceChild' => 'Replaces a child',
'domtext::__construct' => 'Creates a new DOMText object',
'DOMText::appendChild' => 'Adds new child at the end of the children',
'DOMText::appendData' => 'Append the string to the end of the character data of the node',
'DOMText::C14N' => 'Canonicalize nodes to a string',
'DOMText::C14NFile' => 'Canonicalize nodes to a file',
'DOMText::cloneNode' => 'Clones a node',
'DOMText::deleteData' => 'Remove a range of characters from the node',
'DOMText::getLineNo' => 'Get line number for a node',
'DOMText::getNodePath' => 'Get an XPath for a node',
'DOMText::hasAttributes' => 'Checks if node has attributes',
'DOMText::hasChildNodes' => 'Checks if node has children',
'DOMText::insertBefore' => 'Adds a new child before a reference node',
'DOMText::insertData' => 'Insert a string at the specified 16-bit unit offset',
'DOMText::isDefaultNamespace' => 'Checks if the specified namespaceURI is the default namespace or not',
'domtext::isElementContentWhitespace' => 'Returns whether this text node contains whitespace in element content',
'DOMText::isSameNode' => 'Indicates if two nodes are the same node',
'DOMText::isSupported' => 'Checks if feature is supported for specified version',
'domtext::isWhitespaceInElementContent' => 'Indicates whether this text node contains whitespace',
'DOMText::lookupNamespaceUri' => 'Gets the namespace URI of the node based on the prefix',
'DOMText::lookupPrefix' => 'Gets the namespace prefix of the node based on the namespace URI',
'DOMText::normalize' => 'Normalizes the node',
'DOMText::removeChild' => 'Removes child from list of children',
'DOMText::replaceChild' => 'Replaces a child',
'DOMText::replaceData' => 'Replace a substring within the DOMCharacterData node',
'domtext::splitText' => 'Breaks this node into two nodes at the specified offset',
'DOMText::substringData' => 'Extracts a range of data from the node',
'domxpath::__construct' => 'Creates a new DOMXPath object',
'domxpath::evaluate' => 'Evaluates the given XPath expression and returns a typed result if possible',
'domxpath::query' => 'Evaluates the given XPath expression',
'domxpath::registerNamespace' => 'Registers the namespace with the DOMXPath object',
'domxpath::registerPhpFunctions' => 'Register PHP functions as XPath functions',
'DOTNET::__construct' => 'COM class constructor.',
'doubleval' => 'Alias of floatval',
'ds\collection::clear' => 'Removes all values',
'ds\collection::copy' => 'Returns a shallow copy of the collection',
'ds\collection::isEmpty' => 'Returns whether the collection is empty',
'ds\collection::toArray' => 'Converts the collection to an `array`',
'ds\deque::__construct' => 'Creates a new instance',
'ds\deque::allocate' => 'Allocates enough memory for a required capacity',
'ds\deque::apply' => 'Updates all values by applying a callback function to each value',
'ds\deque::capacity' => 'Returns the current capacity',
'ds\deque::clear' => 'Removes all values from the deque',
'ds\deque::contains' => 'Determines if the deque contains given values',
'ds\deque::copy' => 'Returns a shallow copy of the deque',
'ds\deque::count' => 'Returns the number of values in the collection',
'ds\deque::filter' => 'Creates a new deque using a callable to determine which values to include',
'ds\deque::find' => 'Attempts to find a value\'s index',
'ds\deque::first' => 'Returns the first value in the deque',
'ds\deque::get' => 'Returns the value at a given index',
'ds\deque::insert' => 'Inserts values at a given index',
'ds\deque::isEmpty' => 'Returns whether the deque is empty',
'ds\deque::join' => 'Joins all values together as a string',
'ds\deque::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'ds\deque::last' => 'Returns the last value',
'ds\deque::map' => 'Returns the result of applying a callback to each value',
'ds\deque::merge' => 'Returns the result of adding all given values to the deque',
'ds\deque::pop' => 'Removes and returns the last value',
'ds\deque::push' => 'Adds values to the end of the deque',
'ds\deque::reduce' => 'Reduces the deque to a single value using a callback function',
'ds\deque::remove' => 'Removes and returns a value by index',
'ds\deque::reverse' => 'Reverses the deque in-place',
'ds\deque::reversed' => 'Returns a reversed copy',
'ds\deque::rotate' => 'Rotates the deque by a given number of rotations',
'ds\deque::set' => 'Updates a value at a given index',
'ds\deque::shift' => 'Removes and returns the first value',
'ds\deque::slice' => 'Returns a sub-deque of a given range',
'ds\deque::sort' => 'Sorts the deque in-place',
'ds\deque::sorted' => 'Returns a sorted copy',
'ds\deque::sum' => 'Returns the sum of all values in the deque',
'ds\deque::toArray' => 'Converts the deque to an `array`',
'ds\deque::unshift' => 'Adds values to the front of the deque',
'ds\hashable::equals' => 'Determines whether an object is equal to the current instance',
'ds\hashable::hash' => 'Returns a scalar value to be used as a hash value',
'ds\map::__construct' => 'Creates a new instance',
'ds\map::allocate' => 'Allocates enough memory for a required capacity',
'ds\map::apply' => 'Updates all values by applying a callback function to each value',
'ds\map::capacity' => 'Returns the current capacity',
'ds\map::clear' => 'Removes all values',
'ds\map::copy' => 'Returns a shallow copy of the map',
'ds\map::count' => 'Returns the number of values in the map',
'ds\map::diff' => 'Creates a new map using keys that aren\'t in another map',
'ds\map::filter' => 'Creates a new map using a callable to determine which pairs to include',
'ds\map::first' => 'Returns the first pair in the map',
'ds\map::get' => 'Returns the value for a given key',
'ds\map::hasKey' => 'Determines whether the map contains a given key',
'ds\map::hasValue' => 'Determines whether the map contains a given value',
'ds\map::intersect' => 'Creates a new map by intersecting keys with another map',
'ds\map::isEmpty' => 'Returns whether the map is empty',
'ds\map::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'ds\map::keys' => 'Returns a set of the map\'s keys',
'ds\map::ksort' => 'Sorts the map in-place by key',
'ds\map::ksorted' => 'Returns a copy, sorted by key',
'ds\map::last' => 'Returns the last pair of the map',
'ds\map::map' => 'Returns the result of applying a callback to each value',
'ds\map::merge' => 'Returns the result of adding all given associations',
'ds\map::pairs' => 'Returns a sequence containing all the pairs of the map',
'ds\map::put' => 'Associates a key with a value',
'ds\map::putAll' => 'Associates all key-value pairs of a traversable object or array',
'ds\map::reduce' => 'Reduces the map to a single value using a callback function',
'ds\map::remove' => 'Removes and returns a value by key',
'ds\map::reverse' => 'Reverses the map in-place',
'ds\map::reversed' => 'Returns a reversed copy',
'ds\map::skip' => 'Returns the pair at a given positional index',
'ds\map::slice' => 'Returns a subset of the map defined by a starting index and length',
'ds\map::sort' => 'Sorts the map in-place by value',
'ds\map::sorted' => 'Returns a copy, sorted by value',
'ds\map::sum' => 'Returns the sum of all values in the map',
'ds\map::toArray' => 'Converts the map to an `array`',
'ds\map::union' => 'Creates a new map using values from the current instance and another map',
'ds\map::values' => 'Returns a sequence of the map\'s values',
'ds\map::xor' => 'Creates a new map using keys of either the current instance or of another map, but not of both',
'ds\pair::__construct' => 'Creates a new instance',
'ds\pair::clear' => 'Removes all values',
'ds\pair::copy' => 'Returns a shallow copy of the pair',
'ds\pair::isEmpty' => 'Returns whether the pair is empty',
'ds\pair::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'ds\pair::toArray' => 'Converts the pair to an `array`',
'ds\priorityqueue::__construct' => 'Creates a new instance',
'ds\priorityqueue::allocate' => 'Allocates enough memory for a required capacity',
'ds\priorityqueue::capacity' => 'Returns the current capacity',
'ds\priorityqueue::clear' => 'Removes all values',
'ds\priorityqueue::copy' => 'Returns a shallow copy of the queue',
'ds\priorityqueue::count' => 'Returns the number of values in the queue',
'ds\priorityqueue::isEmpty' => 'Returns whether the queue is empty',
'ds\priorityqueue::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'ds\priorityqueue::peek' => 'Returns the value at the front of the queue',
'ds\priorityqueue::pop' => 'Removes and returns the value with the highest priority',
'ds\priorityqueue::push' => 'Pushes values into the queue',
'ds\priorityqueue::toArray' => 'Converts the queue to an `array`',
'ds\queue::__construct' => 'Creates a new instance',
'ds\queue::allocate' => 'Allocates enough memory for a required capacity',
'ds\queue::capacity' => 'Returns the current capacity',
'ds\queue::clear' => 'Removes all values',
'ds\queue::copy' => 'Returns a shallow copy of the queue',
'ds\queue::count' => 'Returns the number of values in the queue',
'ds\queue::isEmpty' => 'Returns whether the queue is empty',
'ds\queue::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'ds\queue::peek' => 'Returns the value at the front of the queue',
'ds\queue::pop' => 'Removes and returns the value at the front of the queue',
'ds\queue::push' => 'Pushes values into the queue',
'ds\queue::toArray' => 'Converts the queue to an `array`',
'ds\sequence::allocate' => 'Allocates enough memory for a required capacity',
'ds\sequence::apply' => 'Updates all values by applying a callback function to each value',
'ds\sequence::capacity' => 'Returns the current capacity',
'ds\sequence::contains' => 'Determines if the sequence contains given values',
'ds\sequence::filter' => 'Creates a new sequence using a callable to determine which values to include',
'ds\sequence::find' => 'Attempts to find a value\'s index',
'ds\sequence::first' => 'Returns the first value in the sequence',
'ds\sequence::get' => 'Returns the value at a given index',
'ds\sequence::insert' => 'Inserts values at a given index',
'ds\sequence::join' => 'Joins all values together as a string',
'ds\sequence::last' => 'Returns the last value',
'ds\sequence::map' => 'Returns the result of applying a callback to each value',
'ds\sequence::merge' => 'Returns the result of adding all given values to the sequence',
'ds\sequence::pop' => 'Removes and returns the last value',
'ds\sequence::push' => 'Adds values to the end of the sequence',
'ds\sequence::reduce' => 'Reduces the sequence to a single value using a callback function',
'ds\sequence::remove' => 'Removes and returns a value by index',
'ds\sequence::reverse' => 'Reverses the sequence in-place',
'ds\sequence::reversed' => 'Returns a reversed copy',
'ds\sequence::rotate' => 'Rotates the sequence by a given number of rotations',
'ds\sequence::set' => 'Updates a value at a given index',
'ds\sequence::shift' => 'Removes and returns the first value',
'ds\sequence::slice' => 'Returns a sub-sequence of a given range',
'ds\sequence::sort' => 'Sorts the sequence in-place',
'ds\sequence::sorted' => 'Returns a sorted copy',
'ds\sequence::sum' => 'Returns the sum of all values in the sequence',
'ds\sequence::unshift' => 'Adds values to the front of the sequence',
'ds\set::__construct' => 'Creates a new instance',
'ds\set::add' => 'Adds values to the set',
'ds\set::allocate' => 'Allocates enough memory for a required capacity',
'ds\set::capacity' => 'Returns the current capacity',
'ds\set::clear' => 'Removes all values',
'ds\set::contains' => 'Determines if the set contains all values',
'ds\set::copy' => 'Returns a shallow copy of the set',
'ds\set::count' => 'Returns the number of values in the set',
'ds\set::diff' => 'Creates a new set using values that aren\'t in another set',
'ds\set::filter' => 'Creates a new set using a callable to determine which values to include',
'ds\set::first' => 'Returns the first value in the set',
'ds\set::get' => 'Returns the value at a given index',
'ds\set::intersect' => 'Creates a new set by intersecting values with another set',
'ds\set::isEmpty' => 'Returns whether the set is empty',
'ds\set::join' => 'Joins all values together as a string',
'ds\set::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'ds\set::last' => 'Returns the last value in the set',
'ds\set::merge' => 'Returns the result of adding all given values to the set',
'ds\set::reduce' => 'Reduces the set to a single value using a callback function',
'ds\set::remove' => 'Removes all given values from the set',
'ds\set::reverse' => 'Reverses the set in-place',
'ds\set::reversed' => 'Returns a reversed copy',
'ds\set::slice' => 'Returns a sub-set of a given range',
'ds\set::sort' => 'Sorts the set in-place',
'ds\set::sorted' => 'Returns a sorted copy',
'ds\set::sum' => 'Returns the sum of all values in the set',
'ds\set::toArray' => 'Converts the set to an `array`',
'ds\set::union' => 'Creates a new set using values from the current instance and another set',
'ds\set::xor' => 'Creates a new set using values in either the current instance or in another set, but not in both',
'ds\stack::__construct' => 'Creates a new instance',
'ds\stack::allocate' => 'Allocates enough memory for a required capacity',
'ds\stack::capacity' => 'Returns the current capacity',
'ds\stack::clear' => 'Removes all values',
'ds\stack::copy' => 'Returns a shallow copy of the stack',
'ds\stack::count' => 'Returns the number of values in the stack',
'ds\stack::isEmpty' => 'Returns whether the stack is empty',
'ds\stack::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'ds\stack::peek' => 'Returns the value at the top of the stack',
'ds\stack::pop' => 'Removes and returns the value at the top of the stack',
'ds\stack::push' => 'Pushes values onto the stack',
'ds\stack::toArray' => 'Converts the stack to an `array`',
'ds\vector::__construct' => 'Creates a new instance',
'ds\vector::allocate' => 'Allocates enough memory for a required capacity',
'ds\vector::apply' => 'Updates all values by applying a callback function to each value',
'ds\vector::capacity' => 'Returns the current capacity',
'ds\vector::clear' => 'Removes all values',
'ds\vector::contains' => 'Determines if the vector contains given values',
'ds\vector::copy' => 'Returns a shallow copy of the vector',
'ds\vector::count' => 'Returns the number of values in the collection',
'ds\vector::filter' => 'Creates a new vector using a callable to determine which values to include',
'ds\vector::find' => 'Attempts to find a value\'s index',
'ds\vector::first' => 'Returns the first value in the vector',
'ds\vector::get' => 'Returns the value at a given index',
'ds\vector::insert' => 'Inserts values at a given index',
'ds\vector::isEmpty' => 'Returns whether the vector is empty',
'ds\vector::join' => 'Joins all values together as a string',
'ds\vector::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'ds\vector::last' => 'Returns the last value',
'ds\vector::map' => 'Returns the result of applying a callback to each value',
'ds\vector::merge' => 'Returns the result of adding all given values to the vector',
'ds\vector::pop' => 'Removes and returns the last value',
'ds\vector::push' => 'Adds values to the end of the vector',
'ds\vector::reduce' => 'Reduces the vector to a single value using a callback function',
'ds\vector::remove' => 'Removes and returns a value by index',
'ds\vector::reverse' => 'Reverses the vector in-place',
'ds\vector::reversed' => 'Returns a reversed copy',
'ds\vector::rotate' => 'Rotates the vector by a given number of rotations',
'ds\vector::set' => 'Updates a value at a given index',
'ds\vector::shift' => 'Removes and returns the first value',
'ds\vector::slice' => 'Returns a sub-vector of a given range',
'ds\vector::sort' => 'Sorts the vector in-place',
'ds\vector::sorted' => 'Returns a sorted copy',
'ds\vector::sum' => 'Returns the sum of all values in the vector',
'ds\vector::toArray' => 'Converts the vector to an `array`',
'ds\vector::unshift' => 'Adds values to the front of the vector',
'each' => 'Return the current key and value pair from an array and advance the array cursor',
'easter_date' => 'Get Unix timestamp for midnight on Easter of a given year',
'easter_days' => 'Get number of days after March 21 on which Easter falls for a given year',
'echo' => 'Output one or more strings',
'eio_busy' => 'Artificially increase load. Could be useful in tests, benchmarking',
'eio_cancel' => 'Cancels a request',
'eio_chmod' => 'Change file/direcrory permissions',
'eio_chown' => 'Change file/direcrory permissions',
'eio_close' => 'Close file',
'eio_custom' => 'Execute custom request like any other eio_* call',
'eio_dup2' => 'Duplicate a file descriptor',
'eio_event_loop' => 'Polls libeio until all requests proceeded',
'eio_fallocate' => 'Allows the caller to directly manipulate the allocated disk space for a file',
'eio_fchmod' => 'Change file permissions',
'eio_fchown' => 'Change file ownership',
'eio_fdatasync' => 'Synchronize a file\'s in-core state with storage device',
'eio_fstat' => 'Get file status',
'eio_fstatvfs' => 'Get file system statistics',
'eio_fsync' => 'Synchronize a file\'s in-core state with storage device',
'eio_ftruncate' => 'Truncate a file',
'eio_futime' => 'Change file last access and modification times',
'eio_get_event_stream' => 'Get stream representing a variable used in internal communications with libeio',
'eio_get_last_error' => 'Returns string describing the last error associated with a request resource',
'eio_grp' => 'Creates a request group',
'eio_grp_add' => 'Adds a request to the request group',
'eio_grp_cancel' => 'Cancels a request group',
'eio_grp_limit' => 'Set group limit',
'eio_init' => '(Re-)initialize Eio',
'eio_link' => 'Create a hardlink for file',
'eio_lstat' => 'Get file status',
'eio_mkdir' => 'Create directory',
'eio_mknod' => 'Create a special or ordinary file',
'eio_nop' => 'Does nothing, except go through the whole request cycle',
'eio_npending' => 'Returns number of finished, but unhandled requests',
'eio_nready' => 'Returns number of not-yet handled requests',
'eio_nreqs' => 'Returns number of requests to be processed',
'eio_nthreads' => 'Returns number of threads currently in use',
'eio_open' => 'Opens a file',
'eio_poll' => 'Can be to be called whenever there are pending requests that need finishing',
'eio_read' => 'Read from a file descriptor at given offset',
'eio_readahead' => 'Perform file readahead into page cache',
'eio_readdir' => 'Reads through a whole directory',
'eio_readlink' => 'Read value of a symbolic link',
'eio_realpath' => 'Get the canonicalized absolute pathname',
'eio_rename' => 'Change the name or location of a file',
'eio_rmdir' => 'Remove a directory',
'eio_seek' => 'Repositions the offset of the open file associated with the fd argument to the argument offset according to the directive whence',
'eio_sendfile' => 'Transfer data between file descriptors',
'eio_set_max_idle' => 'Set maximum number of idle threads',
'eio_set_max_parallel' => 'Set maximum parallel threads',
'eio_set_max_poll_reqs' => 'Set maximum number of requests processed in a poll',
'eio_set_max_poll_time' => 'Set maximum poll time',
'eio_set_min_parallel' => 'Set minimum parallel thread number',
'eio_stat' => 'Get file status',
'eio_statvfs' => 'Get file system statistics',
'eio_symlink' => 'Create a symbolic link',
'eio_sync' => 'Commit buffer cache to disk',
'eio_sync_file_range' => 'Sync a file segment with disk',
'eio_syncfs' => 'Calls Linux\' syncfs syscall, if available',
'eio_truncate' => 'Truncate a file',
'eio_unlink' => 'Delete a name and possibly the file it refers to',
'eio_utime' => 'Change file last access and modification times',
'eio_write' => 'Write to file',
'empty' => 'Determine whether a variable is empty',
'emptyiterator::current' => 'The current() method',
'emptyiterator::key' => 'The key() method',
'emptyiterator::next' => 'The next() method',
'emptyiterator::rewind' => 'The rewind() method',
'emptyiterator::valid' => 'The valid() method',
'enchant_broker_describe' => 'Enumerates the Enchant providers',
'enchant_broker_dict_exists' => 'Whether a dictionary exists or not. Using non-empty tag',
'enchant_broker_free' => 'Free the broker resource and its dictionnaries',
'enchant_broker_free_dict' => 'Free a dictionary resource',
'enchant_broker_get_dict_path' => 'Get the directory path for a given backend',
'enchant_broker_get_error' => 'Returns the last error of the broker',
'enchant_broker_init' => 'Create a new broker object capable of requesting',
'enchant_broker_list_dicts' => 'Returns a list of available dictionaries',
'enchant_broker_request_dict' => 'Create a new dictionary using a tag',
'enchant_broker_request_pwl_dict' => 'Creates a dictionary using a PWL file',
'enchant_broker_set_dict_path' => 'Set the directory path for a given backend',
'enchant_broker_set_ordering' => 'Declares a preference of dictionaries to use for the language',
'enchant_dict_add_to_personal' => 'Add a word to personal word list',
'enchant_dict_add_to_session' => 'Add \'word\' to this spell-checking session',
'enchant_dict_check' => 'Check whether a word is correctly spelled or not',
'enchant_dict_describe' => 'Describes an individual dictionary',
'enchant_dict_get_error' => 'Returns the last error of the current spelling-session',
'enchant_dict_is_in_session' => 'Whether or not \'word\' exists in this spelling-session',
'enchant_dict_quick_check' => 'Check the word is correctly spelled and provide suggestions',
'enchant_dict_store_replacement' => 'Add a correction for a word',
'enchant_dict_suggest' => 'Will return a list of values if any of those pre-conditions are not met',
'end' => 'Set the internal pointer of an array to its last element',
'ereg' => 'Regular expression match',
'ereg_replace' => 'Replace regular expression',
'eregi' => 'Case insensitive regular expression match',
'eregi_replace' => 'Replace regular expression case insensitive',
'Error::__clone' => 'Clone the error
Error can not be clone, so this method results in fatal error.',
'Error::__construct' => 'Construct the error object.',
'Error::__toString' => 'Gets a string representation of the thrown object',
'Error::getCode' => 'Gets the exception code',
'Error::getFile' => 'Gets the file in which the exception occurred',
'Error::getLine' => 'Gets the line on which the object was instantiated',
'Error::getPrevious' => 'Returns the previous Throwable',
'Error::getTrace' => 'Gets the stack trace',
'Error::getTraceAsString' => 'Gets the stack trace as a string',
'error_clear_last' => 'Clear the most recent error',
'error_get_last' => 'Get the last occurred error',
'error_log' => 'Send an error message to the defined error handling routines',
'error_reporting' => 'Sets which PHP errors are reported',
'ErrorException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'ErrorException::__construct' => 'Constructs the exception',
'ErrorException::__toString' => 'String representation of the exception',
'ErrorException::getCode' => 'Gets the Exception code',
'ErrorException::getFile' => 'Gets the file in which the exception occurred',
'ErrorException::getLine' => 'Gets the line in which the exception occurred',
'ErrorException::getMessage' => 'Gets the Exception message',
'ErrorException::getPrevious' => 'Returns previous Exception',
'ErrorException::getSeverity' => 'Gets the exception severity',
'ErrorException::getTrace' => 'Gets the stack trace',
'ErrorException::getTraceAsString' => 'Gets the stack trace as a string',
'escapeshellarg' => 'Escape a string to be used as a shell argument',
'escapeshellcmd' => 'Escape shell metacharacters',
'ev::backend' => 'Returns an integer describing the backend used by libev',
'ev::depth' => 'Returns recursion depth',
'ev::embeddableBackends' => 'Returns the set of backends that are embeddable in other event loops',
'ev::feedSignal' => 'Feed a signal event info Ev',
'ev::feedSignalEvent' => 'Feed signal event into the default loop',
'ev::iteration' => 'Return the number of times the default event loop has polled for new events',
'ev::now' => 'Returns the time when the last iteration of the default event loop has started',
'ev::nowUpdate' => 'Establishes the current time by querying the kernel, updating the time returned by Ev::now in the progress',
'ev::recommendedBackends' => 'Returns a bit mask of recommended backends for current platform',
'ev::resume' => 'Resume previously suspended default event loop',
'ev::run' => 'Begin checking for events and calling callbacks for the default loop',
'ev::sleep' => 'Block the process for the given number of seconds',
'ev::stop' => 'Stops the default event loop',
'ev::supportedBackends' => 'Returns the set of backends supported by current libev configuration',
'ev::suspend' => 'Suspend the default event loop',
'ev::time' => 'Returns the current time in fractional seconds since the epoch',
'ev::verify' => 'Performs internal consistency checks(for debugging)',
'eval' => 'Evaluate a string as PHP code',
'evcheck::__construct' => 'Constructs the EvCheck watcher object',
'EvCheck::clear' => 'Clear watcher pending status.

If the watcher is pending, this method clears its pending status and returns its revents bitset (as if its
callback was invoked). If the watcher isn\'t pending it does nothing and returns 0.

Sometimes it can be useful to "poll" a watcher instead of waiting for its callback to be invoked, which can be
accomplished with this function.',
'evcheck::createStopped' => 'Create instance of a stopped EvCheck watcher',
'EvCheck::feed' => 'Feeds the given revents set into the event loop.

Feeds the given revents set into the event loop, as if the specified event had happened for the watcher.',
'EvCheck::getLoop' => 'Returns the loop responsible for the watcher.',
'EvCheck::invoke' => 'Invokes the watcher callback with the given received events bit mask.',
'EvCheck::keepAlive' => 'Configures whether to keep the loop from returning.

Configures whether to keep the loop from returning. With keepalive value set to FALSE the watcher won\'t keep
Ev::run() / EvLoop::run() from returning even though the watcher is active.

Watchers have keepalive value TRUE by default.

Clearing keepalive status is useful when returning from Ev::run() / EvLoop::run() just because of the watcher
is undesirable. It could be a long running UDP socket watcher or so.',
'EvCheck::setCallback' => 'Sets new callback for the watcher.',
'EvCheck::start' => 'Starts the watcher.

Marks the watcher as active. Note that only active watchers will receive events.',
'EvCheck::stop' => 'Stops the watcher.

Marks the watcher as inactive. Note that only active watchers will receive events.',
'evchild::__construct' => 'Constructs the EvChild watcher object',
'EvChild::clear' => 'Clear watcher pending status.

If the watcher is pending, this method clears its pending status and returns its revents bitset (as if its
callback was invoked). If the watcher isn\'t pending it does nothing and returns 0.

Sometimes it can be useful to "poll" a watcher instead of waiting for its callback to be invoked, which can be
accomplished with this function.',
'evchild::createStopped' => 'Create instance of a stopped EvCheck watcher',
'EvChild::feed' => 'Feeds the given revents set into the event loop.

Feeds the given revents set into the event loop, as if the specified event had happened for the watcher.',
'EvChild::getLoop' => 'Returns the loop responsible for the watcher.',
'EvChild::invoke' => 'Invokes the watcher callback with the given received events bit mask.',
'EvChild::keepAlive' => 'Configures whether to keep the loop from returning.

Configures whether to keep the loop from returning. With keepalive value set to FALSE the watcher won\'t keep
Ev::run() / EvLoop::run() from returning even though the watcher is active.

Watchers have keepalive value TRUE by default.

Clearing keepalive status is useful when returning from Ev::run() / EvLoop::run() just because of the watcher
is undesirable. It could be a long running UDP socket watcher or so.',
'evchild::set' => 'Configures the watcher',
'EvChild::setCallback' => 'Sets new callback for the watcher.',
'EvChild::start' => 'Starts the watcher.

Marks the watcher as active. Note that only active watchers will receive events.',
'EvChild::stop' => 'Stops the watcher.

Marks the watcher as inactive. Note that only active watchers will receive events.',
'evembed::__construct' => 'Constructs the EvEmbed object',
'EvEmbed::clear' => 'Clear watcher pending status.

If the watcher is pending, this method clears its pending status and returns its revents bitset (as if its
callback was invoked). If the watcher isn\'t pending it does nothing and returns 0.

Sometimes it can be useful to "poll" a watcher instead of waiting for its callback to be invoked, which can be
accomplished with this function.',
'evembed::createStopped' => 'Create stopped EvEmbed watcher object',
'EvEmbed::feed' => 'Feeds the given revents set into the event loop.

Feeds the given revents set into the event loop, as if the specified event had happened for the watcher.',
'EvEmbed::getLoop' => 'Returns the loop responsible for the watcher.',
'EvEmbed::invoke' => 'Invokes the watcher callback with the given received events bit mask.',
'EvEmbed::keepAlive' => 'Configures whether to keep the loop from returning.

Configures whether to keep the loop from returning. With keepalive value set to FALSE the watcher won\'t keep
Ev::run() / EvLoop::run() from returning even though the watcher is active.

Watchers have keepalive value TRUE by default.

Clearing keepalive status is useful when returning from Ev::run() / EvLoop::run() just because of the watcher
is undesirable. It could be a long running UDP socket watcher or so.',
'evembed::set' => 'Configures the watcher',
'EvEmbed::setCallback' => 'Sets new callback for the watcher.',
'EvEmbed::start' => 'Starts the watcher.

Marks the watcher as active. Note that only active watchers will receive events.',
'EvEmbed::stop' => 'Stops the watcher.

Marks the watcher as inactive. Note that only active watchers will receive events.',
'evembed::sweep' => 'Make a single, non-blocking sweep over the embedded loop',
'event::__construct' => 'Constructs Event object',
'event::add' => 'Makes event pending',
'event::addSignal' => 'Makes signal event pending',
'event::addTimer' => 'Makes timer event pending',
'event::del' => 'Makes event non-pending',
'event::delSignal' => 'Makes signal event non-pending',
'event::delTimer' => 'Makes timer event non-pending',
'event::free' => 'Make event non-pending and free resources allocated for this event',
'event::getSupportedMethods' => 'Returns array with of the names of the methods supported in this version of Libevent',
'event::pending' => 'Detects whether event is pending or scheduled',
'event::set' => 'Re-configures event',
'event::setPriority' => 'Set event priority',
'event::setTimer' => 'Re-configures timer event',
'event::signal' => 'Constructs signal event object',
'event::timer' => 'Constructs timer event object',
'event_add' => 'Add an event to the set of monitored events',
'event_base_free' => 'Destroy event base',
'event_base_loop' => 'Handle events',
'event_base_loopbreak' => 'Abort event loop',
'event_base_loopexit' => 'Exit loop after a time',
'event_base_new' => 'Create and initialize new event base',
'event_base_priority_init' => 'Set the number of event priority levels',
'event_base_reinit' => 'Reinitialize the event base after a fork',
'event_base_set' => 'Associate event base with an event',
'event_buffer_base_set' => 'Associate buffered event with an event base',
'event_buffer_disable' => 'Disable a buffered event',
'event_buffer_enable' => 'Enable a buffered event',
'event_buffer_fd_set' => 'Change a buffered event file descriptor',
'event_buffer_free' => 'Destroy buffered event',
'event_buffer_new' => 'Create new buffered event',
'event_buffer_priority_set' => 'Assign a priority to a buffered event',
'event_buffer_read' => 'Read data from a buffered event',
'event_buffer_set_callback' => 'Set or reset callbacks for a buffered event',
'event_buffer_timeout_set' => 'Set read and write timeouts for a buffered event',
'event_buffer_watermark_set' => 'Set the watermarks for read and write events',
'event_buffer_write' => 'Write data to a buffered event',
'event_del' => 'Remove an event from the set of monitored events',
'event_free' => 'Free event resource',
'event_new' => 'Create new event',
'event_priority_set' => 'Assign a priority to an event',
'event_set' => 'Prepare an event',
'event_timer_add' => 'Alias of event_add',
'event_timer_del' => 'Alias of event_del',
'event_timer_new' => 'Alias of event_new',
'event_timer_set' => 'Prepare a timer event',
'eventbase::__construct' => 'Constructs EventBase object',
'eventbase::dispatch' => 'Dispatch pending events',
'eventbase::exit' => 'Stop dispatching events',
'eventbase::free' => 'Free resources allocated for this event base',
'eventbase::getFeatures' => 'Returns bitmask of features supported',
'eventbase::getMethod' => 'Returns event method in use',
'eventbase::getTimeOfDayCached' => 'Returns the current event base time',
'eventbase::gotExit' => 'Checks if the event loop was told to exit',
'eventbase::gotStop' => 'Checks if the event loop was told to exit',
'eventbase::loop' => 'Dispatch pending events',
'eventbase::priorityInit' => 'Sets number of priorities per event base',
'eventbase::reInit' => 'Re-initialize event base(after a fork)',
'eventbase::stop' => 'Tells event_base to stop dispatching events',
'eventbuffer::__construct' => 'Constructs EventBuffer object',
'eventbuffer::add' => 'Append data to the end of an event buffer',
'eventbuffer::addBuffer' => 'Move all data from a buffer provided to the current instance of EventBuffer',
'eventbuffer::appendFrom' => 'Moves the specified number of bytes from a source buffer to the end of the current buffer',
'eventbuffer::copyout' => 'Copies out specified number of bytes from the front of the buffer',
'eventbuffer::drain' => 'Removes specified number of bytes from the front of the buffer without copying it anywhere',
'EventBuffer::enableLocking' => 'enableLocking.',
'eventbuffer::expand' => 'Reserves space in buffer',
'eventbuffer::freeze' => 'Prevent calls that modify an event buffer from succeeding',
'eventbuffer::lock' => 'Acquires a lock on buffer',
'eventbuffer::prepend' => 'Prepend data to the front of the buffer',
'eventbuffer::prependBuffer' => 'Moves all data from source buffer to the front of current buffer',
'eventbuffer::pullup' => 'Linearizes data within buffer and returns it\'s contents as a string',
'eventbuffer::read' => 'Read data from an evbuffer and drain the bytes read',
'eventbuffer::readFrom' => 'Read data from a file onto the end of the buffer',
'eventbuffer::readLine' => 'Extracts a line from the front of the buffer',
'eventbuffer::search' => 'Scans the buffer for an occurrence of a string',
'eventbuffer::searchEol' => 'Scans the buffer for an occurrence of an end of line',
'eventbuffer::substr' => 'Substracts a portion of the buffer data',
'eventbuffer::unfreeze' => 'Re-enable calls that modify an event buffer',
'eventbuffer::unlock' => 'Releases lock acquired by EventBuffer::lock',
'eventbuffer::write' => 'Write contents of the buffer to a file or socket',
'eventbufferevent::__construct' => 'Constructs EventBufferEvent object',
'eventbufferevent::close' => 'Closes file descriptor associated with the current buffer event',
'eventbufferevent::connect' => 'Connect buffer event\'s file descriptor to given address or UNIX socket',
'eventbufferevent::connectHost' => 'Connects to a hostname with optionally asynchronous DNS resolving',
'eventbufferevent::createPair' => 'Creates two buffer events connected to each other',
'eventbufferevent::disable' => 'Disable events read, write, or both on a buffer event',
'eventbufferevent::enable' => 'Enable events read, write, or both on a buffer event',
'eventbufferevent::free' => 'Free a buffer event',
'eventbufferevent::getDnsErrorString' => 'Returns string describing the last failed DNS lookup attempt',
'eventbufferevent::getEnabled' => 'Returns bitmask of events currently enabled on the buffer event',
'eventbufferevent::getInput' => 'Returns underlying input buffer associated with current buffer event',
'eventbufferevent::getOutput' => 'Returns underlying output buffer associated with current buffer event',
'eventbufferevent::read' => 'Read buffer\'s data',
'eventbufferevent::readBuffer' => 'Drains the entire contents of the input buffer and places them into buf',
'eventbufferevent::setCallbacks' => 'Assigns read, write and event(status) callbacks',
'eventbufferevent::setPriority' => 'Assign a priority to a bufferevent',
'eventbufferevent::setTimeouts' => 'Set the read and write timeout for a buffer event',
'eventbufferevent::setWatermark' => 'Adjusts read and/or write watermarks',
'eventbufferevent::sslError' => 'Returns most recent OpenSSL error reported on the buffer event',
'eventbufferevent::sslFilter' => 'Create a new SSL buffer event to send its data over another buffer event',
'eventbufferevent::sslGetCipherInfo' => 'Returns a textual description of the cipher',
'eventbufferevent::sslGetCipherName' => 'Returns the current cipher name of the SSL connection',
'eventbufferevent::sslGetCipherVersion' => 'Returns version of cipher used by current SSL connection',
'eventbufferevent::sslGetProtocol' => 'Returns the name of the protocol used for current SSL connection',
'eventbufferevent::sslRenegotiate' => 'Tells a bufferevent to begin SSL renegotiation',
'eventbufferevent::sslSocket' => 'Creates a new SSL buffer event to send its data over an SSL on a socket',
'eventbufferevent::write' => 'Adds data to a buffer event\'s output buffer',
'eventbufferevent::writeBuffer' => 'Adds contents of the entire buffer to a buffer event\'s output buffer',
'eventconfig::__construct' => 'Constructs EventConfig object',
'eventconfig::avoidMethod' => 'Tells libevent to avoid specific event method',
'eventconfig::requireFeatures' => 'Enters a required event method feature that the application demands',
'eventconfig::setMaxDispatchInterval' => 'Prevents priority inversion',
'eventdnsbase::__construct' => 'Constructs EventDnsBase object',
'eventdnsbase::addNameserverIp' => 'Adds a nameserver to the DNS base',
'eventdnsbase::addSearch' => 'Adds a domain to the list of search domains',
'eventdnsbase::clearSearch' => 'Removes all current search suffixes',
'eventdnsbase::countNameservers' => 'Gets the number of configured nameservers',
'eventdnsbase::loadHosts' => 'Loads a hosts file (in the same format as /etc/hosts) from hosts file',
'eventdnsbase::parseResolvConf' => 'Scans the resolv.conf-formatted file',
'eventdnsbase::setOption' => 'Set the value of a configuration option',
'eventdnsbase::setSearchNdots' => 'Set the \'ndots\' parameter for searches',
'eventhttp::__construct' => 'Constructs EventHttp object(the HTTP server)',
'eventhttp::accept' => 'Makes an HTTP server accept connections on the specified socket stream or resource',
'eventhttp::addServerAlias' => 'Adds a server alias to the HTTP server object',
'eventhttp::bind' => 'Binds an HTTP server on the specified address and port',
'eventhttp::removeServerAlias' => 'Removes server alias',
'eventhttp::setAllowedMethods' => 'Sets the what HTTP methods are supported in requests accepted by this server, and passed to user callbacks',
'eventhttp::setCallback' => 'Sets a callback for specified URI',
'eventhttp::setDefaultCallback' => 'Sets default callback to handle requests that are not caught by specific callbacks',
'eventhttp::setMaxBodySize' => 'Sets maximum request body size',
'eventhttp::setMaxHeadersSize' => 'Sets maximum HTTP header size',
'eventhttp::setTimeout' => 'Sets the timeout for an HTTP request',
'eventhttpconnection::__construct' => 'Constructs EventHttpConnection object',
'eventhttpconnection::getBase' => 'Returns event base associated with the connection',
'eventhttpconnection::getPeer' => 'Gets the remote address and port associated with the connection',
'eventhttpconnection::makeRequest' => 'Makes an HTTP request over the specified connection',
'eventhttpconnection::setCloseCallback' => 'Set callback for connection close',
'eventhttpconnection::setLocalAddress' => 'Sets the IP address from which HTTP connections are made',
'eventhttpconnection::setLocalPort' => 'Sets the local port from which connections are made',
'eventhttpconnection::setMaxBodySize' => 'Sets maximum body size for the connection',
'eventhttpconnection::setMaxHeadersSize' => 'Sets maximum header size',
'eventhttpconnection::setRetries' => 'Sets the retry limit for the connection',
'eventhttpconnection::setTimeout' => 'Sets the timeout for the connection',
'eventhttprequest::__construct' => 'Constructs EventHttpRequest object',
'eventhttprequest::addHeader' => 'Adds an HTTP header to the headers of the request',
'eventhttprequest::cancel' => 'Cancels a pending HTTP request',
'eventhttprequest::clearHeaders' => 'Removes all output headers from the header list of the request',
'eventhttprequest::closeConnection' => 'Closes associated HTTP connection',
'eventhttprequest::findHeader' => 'Finds the value belonging a header',
'eventhttprequest::free' => 'Frees the object and removes associated events',
'eventhttprequest::getBufferEvent' => 'Returns EventBufferEvent object',
'eventhttprequest::getCommand' => 'Returns the request command(method)',
'eventhttprequest::getConnection' => 'Returns EventHttpConnection object',
'eventhttprequest::getHost' => 'Returns the request host',
'eventhttprequest::getInputBuffer' => 'Returns the input buffer',
'eventhttprequest::getInputHeaders' => 'Returns associative array of the input headers',
'eventhttprequest::getOutputBuffer' => 'Returns the output buffer of the request',
'eventhttprequest::getOutputHeaders' => 'Returns associative array of the output headers',
'eventhttprequest::getResponseCode' => 'Returns the response code',
'eventhttprequest::getUri' => 'Returns the request URI',
'eventhttprequest::removeHeader' => 'Removes an HTTP header from the headers of the request',
'eventhttprequest::sendError' => 'Send an HTML error message to the client',
'eventhttprequest::sendReply' => 'Send an HTML reply to the client',
'eventhttprequest::sendReplyChunk' => 'Send another data chunk as part of an ongoing chunked reply',
'eventhttprequest::sendReplyEnd' => 'Complete a chunked reply, freeing the request as appropriate',
'eventhttprequest::sendReplyStart' => 'Initiate a chunked reply',
'eventlistener::__construct' => 'Creates new connection listener associated with an event base',
'eventlistener::disable' => 'Disables an event connect listener object',
'eventlistener::enable' => 'Enables an event connect listener object',
'eventlistener::getBase' => 'Returns event base associated with the event listener',
'eventlistener::getSocketName' => 'Retreives the current address to which the listener\'s socket is bound',
'eventlistener::setCallback' => 'The setCallback purpose',
'eventlistener::setErrorCallback' => 'Set event listener\'s error callback',
'eventsslcontext::__construct' => 'Constructs an OpenSSL context for use with Event classes',
'eventutil::__construct' => 'The abstract constructor',
'eventutil::getLastSocketErrno' => 'Returns the most recent socket error number',
'eventutil::getLastSocketError' => 'Returns the most recent socket error',
'eventutil::getSocketFd' => 'Returns numeric file descriptor of a socket, or stream',
'eventutil::getSocketName' => 'Retreives the current address to which the socket is bound',
'eventutil::setSocketOption' => 'Sets socket options',
'eventutil::sslRandPoll' => 'Generates entropy by means of OpenSSL\'s RAND_poll()',
'evfork::__construct' => 'Constructs the EvFork watcher object',
'EvFork::clear' => 'Clear watcher pending status.

If the watcher is pending, this method clears its pending status and returns its revents bitset (as if its
callback was invoked). If the watcher isn\'t pending it does nothing and returns 0.

Sometimes it can be useful to "poll" a watcher instead of waiting for its callback to be invoked, which can be
accomplished with this function.',
'evfork::createStopped' => 'Creates a stopped instance of EvFork watcher class',
'EvFork::feed' => 'Feeds the given revents set into the event loop.

Feeds the given revents set into the event loop, as if the specified event had happened for the watcher.',
'EvFork::getLoop' => 'Returns the loop responsible for the watcher.',
'EvFork::invoke' => 'Invokes the watcher callback with the given received events bit mask.',
'EvFork::keepAlive' => 'Configures whether to keep the loop from returning.

Configures whether to keep the loop from returning. With keepalive value set to FALSE the watcher won\'t keep
Ev::run() / EvLoop::run() from returning even though the watcher is active.

Watchers have keepalive value TRUE by default.

Clearing keepalive status is useful when returning from Ev::run() / EvLoop::run() just because of the watcher
is undesirable. It could be a long running UDP socket watcher or so.',
'EvFork::setCallback' => 'Sets new callback for the watcher.',
'EvFork::start' => 'Starts the watcher.

Marks the watcher as active. Note that only active watchers will receive events.',
'EvFork::stop' => 'Stops the watcher.

Marks the watcher as inactive. Note that only active watchers will receive events.',
'evidle::__construct' => 'Constructs the EvIdle watcher object',
'EvIdle::clear' => 'Clear watcher pending status.

If the watcher is pending, this method clears its pending status and returns its revents bitset (as if its
callback was invoked). If the watcher isn\'t pending it does nothing and returns 0.

Sometimes it can be useful to "poll" a watcher instead of waiting for its callback to be invoked, which can be
accomplished with this function.',
'evidle::createStopped' => 'Creates instance of a stopped EvIdle watcher object',
'EvIdle::feed' => 'Feeds the given revents set into the event loop.

Feeds the given revents set into the event loop, as if the specified event had happened for the watcher.',
'EvIdle::getLoop' => 'Returns the loop responsible for the watcher.',
'EvIdle::invoke' => 'Invokes the watcher callback with the given received events bit mask.',
'EvIdle::keepAlive' => 'Configures whether to keep the loop from returning.

Configures whether to keep the loop from returning. With keepalive value set to FALSE the watcher won\'t keep
Ev::run() / EvLoop::run() from returning even though the watcher is active.

Watchers have keepalive value TRUE by default.

Clearing keepalive status is useful when returning from Ev::run() / EvLoop::run() just because of the watcher
is undesirable. It could be a long running UDP socket watcher or so.',
'EvIdle::setCallback' => 'Sets new callback for the watcher.',
'EvIdle::start' => 'Starts the watcher.

Marks the watcher as active. Note that only active watchers will receive events.',
'EvIdle::stop' => 'Stops the watcher.

Marks the watcher as inactive. Note that only active watchers will receive events.',
'evio::__construct' => 'Constructs EvIo watcher object',
'EvIo::clear' => 'Clear watcher pending status.

If the watcher is pending, this method clears its pending status and returns its revents bitset (as if its
callback was invoked). If the watcher isn\'t pending it does nothing and returns 0.

Sometimes it can be useful to "poll" a watcher instead of waiting for its callback to be invoked, which can be
accomplished with this function.',
'evio::createStopped' => 'Create stopped EvIo watcher object',
'EvIo::feed' => 'Feeds the given revents set into the event loop.

Feeds the given revents set into the event loop, as if the specified event had happened for the watcher.',
'EvIo::getLoop' => 'Returns the loop responsible for the watcher.',
'EvIo::invoke' => 'Invokes the watcher callback with the given received events bit mask.',
'EvIo::keepAlive' => 'Configures whether to keep the loop from returning.

Configures whether to keep the loop from returning. With keepalive value set to FALSE the watcher won\'t keep
Ev::run() / EvLoop::run() from returning even though the watcher is active.

Watchers have keepalive value TRUE by default.

Clearing keepalive status is useful when returning from Ev::run() / EvLoop::run() just because of the watcher
is undesirable. It could be a long running UDP socket watcher or so.',
'evio::set' => 'Configures the watcher',
'EvIo::setCallback' => 'Sets new callback for the watcher.',
'EvIo::start' => 'Starts the watcher.

Marks the watcher as active. Note that only active watchers will receive events.',
'EvIo::stop' => 'Stops the watcher.

Marks the watcher as inactive. Note that only active watchers will receive events.',
'evloop::__construct' => 'Constructs the event loop object',
'evloop::backend' => 'Returns an integer describing the backend used by libev',
'evloop::check' => 'Creates EvCheck object associated with the current event loop instance',
'evloop::child' => 'Creates EvChild object associated with the current event loop',
'evloop::defaultLoop' => 'Returns or creates the default event loop',
'evloop::embed' => 'Creates an instance of EvEmbed watcher associated with the current EvLoop object',
'evloop::fork' => 'Creates EvFork watcher object associated with the current event loop instance',
'evloop::idle' => 'Creates EvIdle watcher object associated with the current event loop instance',
'evloop::invokePending' => 'Invoke all pending watchers while resetting their pending state',
'evloop::io' => 'Create EvIo watcher object associated with the current event loop instance',
'evloop::loopFork' => 'Must be called after a fork',
'evloop::now' => 'Returns the current "event loop time"',
'evloop::nowUpdate' => 'Establishes the current time by querying the kernel, updating the time returned by EvLoop::now in the progress',
'evloop::periodic' => 'Creates EvPeriodic watcher object associated with the current event loop instance',
'evloop::prepare' => 'Creates EvPrepare watcher object associated with the current event loop instance',
'evloop::resume' => 'Resume previously suspended default event loop',
'evloop::run' => 'Begin checking for events and calling callbacks for the loop',
'evloop::signal' => 'Creates EvSignal watcher object associated with the current event loop instance',
'evloop::stat' => 'Creates EvStat watcher object associated with the current event loop instance',
'evloop::stop' => 'Stops the event loop',
'evloop::suspend' => 'Suspend the loop',
'evloop::timer' => 'Creates EvTimer watcher object associated with the current event loop instance',
'evloop::verify' => 'Performs internal consistency checks(for debugging)',
'evperiodic::__construct' => 'Constructs EvPeriodic watcher object',
'evperiodic::again' => 'Simply stops and restarts the periodic watcher again',
'evperiodic::at' => 'Returns the absolute time that this watcher is supposed to trigger next',
'EvPeriodic::clear' => 'Clear watcher pending status.

If the watcher is pending, this method clears its pending status and returns its revents bitset (as if its
callback was invoked). If the watcher isn\'t pending it does nothing and returns 0.

Sometimes it can be useful to "poll" a watcher instead of waiting for its callback to be invoked, which can be
accomplished with this function.',
'evperiodic::createStopped' => 'Create a stopped EvPeriodic watcher',
'EvPeriodic::feed' => 'Feeds the given revents set into the event loop.

Feeds the given revents set into the event loop, as if the specified event had happened for the watcher.',
'EvPeriodic::getLoop' => 'Returns the loop responsible for the watcher.',
'EvPeriodic::invoke' => 'Invokes the watcher callback with the given received events bit mask.',
'EvPeriodic::keepAlive' => 'Configures whether to keep the loop from returning.

Configures whether to keep the loop from returning. With keepalive value set to FALSE the watcher won\'t keep
Ev::run() / EvLoop::run() from returning even though the watcher is active.

Watchers have keepalive value TRUE by default.

Clearing keepalive status is useful when returning from Ev::run() / EvLoop::run() just because of the watcher
is undesirable. It could be a long running UDP socket watcher or so.',
'evperiodic::set' => 'Configures the watcher',
'EvPeriodic::setCallback' => 'Sets new callback for the watcher.',
'EvPeriodic::start' => 'Starts the watcher.

Marks the watcher as active. Note that only active watchers will receive events.',
'EvPeriodic::stop' => 'Stops the watcher.

Marks the watcher as inactive. Note that only active watchers will receive events.',
'evprepare::__construct' => 'Constructs EvPrepare watcher object',
'EvPrepare::clear' => 'Clear watcher pending status.

If the watcher is pending, this method clears its pending status and returns its revents bitset (as if its
callback was invoked). If the watcher isn\'t pending it does nothing and returns 0.

Sometimes it can be useful to "poll" a watcher instead of waiting for its callback to be invoked, which can be
accomplished with this function.',
'evprepare::createStopped' => 'Creates a stopped instance of EvPrepare watcher',
'EvPrepare::feed' => 'Feeds the given revents set into the event loop.

Feeds the given revents set into the event loop, as if the specified event had happened for the watcher.',
'EvPrepare::getLoop' => 'Returns the loop responsible for the watcher.',
'EvPrepare::invoke' => 'Invokes the watcher callback with the given received events bit mask.',
'EvPrepare::keepAlive' => 'Configures whether to keep the loop from returning.

Configures whether to keep the loop from returning. With keepalive value set to FALSE the watcher won\'t keep
Ev::run() / EvLoop::run() from returning even though the watcher is active.

Watchers have keepalive value TRUE by default.

Clearing keepalive status is useful when returning from Ev::run() / EvLoop::run() just because of the watcher
is undesirable. It could be a long running UDP socket watcher or so.',
'EvPrepare::setCallback' => 'Sets new callback for the watcher.',
'EvPrepare::start' => 'Starts the watcher.

Marks the watcher as active. Note that only active watchers will receive events.',
'EvPrepare::stop' => 'Stops the watcher.

Marks the watcher as inactive. Note that only active watchers will receive events.',
'evsignal::__construct' => 'Constructs EvSignal watcher object',
'EvSignal::clear' => 'Clear watcher pending status.

If the watcher is pending, this method clears its pending status and returns its revents bitset (as if its
callback was invoked). If the watcher isn\'t pending it does nothing and returns 0.

Sometimes it can be useful to "poll" a watcher instead of waiting for its callback to be invoked, which can be
accomplished with this function.',
'evsignal::createStopped' => 'Create stopped EvSignal watcher object',
'EvSignal::feed' => 'Feeds the given revents set into the event loop.

Feeds the given revents set into the event loop, as if the specified event had happened for the watcher.',
'EvSignal::getLoop' => 'Returns the loop responsible for the watcher.',
'EvSignal::invoke' => 'Invokes the watcher callback with the given received events bit mask.',
'EvSignal::keepAlive' => 'Configures whether to keep the loop from returning.

Configures whether to keep the loop from returning. With keepalive value set to FALSE the watcher won\'t keep
Ev::run() / EvLoop::run() from returning even though the watcher is active.

Watchers have keepalive value TRUE by default.

Clearing keepalive status is useful when returning from Ev::run() / EvLoop::run() just because of the watcher
is undesirable. It could be a long running UDP socket watcher or so.',
'evsignal::set' => 'Configures the watcher',
'EvSignal::setCallback' => 'Sets new callback for the watcher.',
'EvSignal::start' => 'Starts the watcher.

Marks the watcher as active. Note that only active watchers will receive events.',
'EvSignal::stop' => 'Stops the watcher.

Marks the watcher as inactive. Note that only active watchers will receive events.',
'evstat::__construct' => 'Constructs EvStat watcher object',
'evstat::attr' => 'Returns the values most recently detected by Ev',
'EvStat::clear' => 'Clear watcher pending status.

If the watcher is pending, this method clears its pending status and returns its revents bitset (as if its
callback was invoked). If the watcher isn\'t pending it does nothing and returns 0.

Sometimes it can be useful to "poll" a watcher instead of waiting for its callback to be invoked, which can be
accomplished with this function.',
'evstat::createStopped' => 'Create a stopped EvStat watcher object',
'EvStat::feed' => 'Feeds the given revents set into the event loop.

Feeds the given revents set into the event loop, as if the specified event had happened for the watcher.',
'EvStat::getLoop' => 'Returns the loop responsible for the watcher.',
'EvStat::invoke' => 'Invokes the watcher callback with the given received events bit mask.',
'EvStat::keepAlive' => 'Configures whether to keep the loop from returning.

Configures whether to keep the loop from returning. With keepalive value set to FALSE the watcher won\'t keep
Ev::run() / EvLoop::run() from returning even though the watcher is active.

Watchers have keepalive value TRUE by default.

Clearing keepalive status is useful when returning from Ev::run() / EvLoop::run() just because of the watcher
is undesirable. It could be a long running UDP socket watcher or so.',
'evstat::prev' => 'Returns the previous set of values returned by EvStat::attr',
'evstat::set' => 'Configures the watcher',
'EvStat::setCallback' => 'Sets new callback for the watcher.',
'EvStat::start' => 'Starts the watcher.

Marks the watcher as active. Note that only active watchers will receive events.',
'evstat::stat' => 'Initiates the stat call',
'EvStat::stop' => 'Stops the watcher.

Marks the watcher as inactive. Note that only active watchers will receive events.',
'evtimer::__construct' => 'Constructs an EvTimer watcher object',
'evtimer::again' => 'Restarts the timer watcher',
'EvTimer::clear' => 'Clear watcher pending status.

If the watcher is pending, this method clears its pending status and returns its revents bitset (as if its
callback was invoked). If the watcher isn\'t pending it does nothing and returns 0.

Sometimes it can be useful to "poll" a watcher instead of waiting for its callback to be invoked, which can be
accomplished with this function.',
'evtimer::createStopped' => 'Creates EvTimer stopped watcher object',
'EvTimer::feed' => 'Feeds the given revents set into the event loop.

Feeds the given revents set into the event loop, as if the specified event had happened for the watcher.',
'EvTimer::getLoop' => 'Returns the loop responsible for the watcher.',
'EvTimer::invoke' => 'Invokes the watcher callback with the given received events bit mask.',
'EvTimer::keepAlive' => 'Configures whether to keep the loop from returning.

Configures whether to keep the loop from returning. With keepalive value set to FALSE the watcher won\'t keep
Ev::run() / EvLoop::run() from returning even though the watcher is active.

Watchers have keepalive value TRUE by default.

Clearing keepalive status is useful when returning from Ev::run() / EvLoop::run() just because of the watcher
is undesirable. It could be a long running UDP socket watcher or so.',
'evtimer::set' => 'Configures the watcher',
'EvTimer::setCallback' => 'Sets new callback for the watcher.',
'EvTimer::start' => 'Starts the watcher.

Marks the watcher as active. Note that only active watchers will receive events.',
'EvTimer::stop' => 'Stops the watcher.

Marks the watcher as inactive. Note that only active watchers will receive events.',
'evwatcher::__construct' => 'Abstract constructor of a watcher object',
'evwatcher::clear' => 'Clear watcher pending status',
'evwatcher::feed' => 'Feeds the given revents set into the event loop',
'evwatcher::getLoop' => 'Returns the loop responsible for the watcher',
'evwatcher::invoke' => 'Invokes the watcher callback with the given received events bit mask',
'evwatcher::keepalive' => 'Configures whether to keep the loop from returning',
'evwatcher::setCallback' => 'Sets new callback for the watcher',
'evwatcher::start' => 'Starts the watcher',
'evwatcher::stop' => 'Stops the watcher',
'Exception::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'Exception::__construct' => 'Construct the exception. Note: The message is NOT binary safe.',
'Exception::__toString' => 'String representation of the exception',
'Exception::getCode' => 'Gets the Exception code',
'Exception::getFile' => 'Gets the file in which the exception occurred',
'Exception::getLine' => 'Gets the line in which the exception occurred',
'Exception::getMessage' => 'Gets the Exception message',
'Exception::getPrevious' => 'Returns previous Exception',
'Exception::getTrace' => 'Gets the stack trace',
'Exception::getTraceAsString' => 'Gets the stack trace as a string',
'exec' => 'Execute an external program',
'exif_imagetype' => 'Determine the type of an image',
'exif_read_data' => 'Reads the EXIF headers from an image file',
'exif_tagname' => 'Get the header name for an index',
'exif_thumbnail' => 'Retrieve the embedded thumbnail of an image',
'exit' => 'Output a message and terminate the current script',
'exp' => 'Calculates the exponent of e',
'expect_expectl' => 'Waits until the output from a process matches one of the patterns, a specified time period has passed, or an EOF is seen',
'expect_popen' => 'Execute command via Bourne shell, and open the PTY stream to the process',
'explode' => 'Split a string by a string',
'expm1' => 'Returns exp(number) - 1, computed in a way that is accurate even when the value of number is close to zero',
'expression' => 'Bind prepared statement variables as parameters',
'extension_loaded' => 'Find out whether an extension is loaded',
'extract' => 'Import variables into the current symbol table from an array',
'ezmlm_hash' => 'Calculate the hash value needed by EZMLM',
'fam_cancel_monitor' => 'Terminate monitoring',
'fam_close' => 'Close FAM connection',
'fam_monitor_collection' => 'Monitor a collection of files in a directory for changes',
'fam_monitor_directory' => 'Monitor a directory for changes',
'fam_monitor_file' => 'Monitor a regular file for changes',
'fam_next_event' => 'Get next pending FAM event',
'fam_open' => 'Open connection to FAM daemon',
'fam_pending' => 'Check for pending FAM events',
'fam_resume_monitor' => 'Resume suspended monitoring',
'fam_suspend_monitor' => 'Temporarily suspend monitoring',
'fann_cascadetrain_on_data' => 'Trains on an entire dataset, for a period of time using the Cascade2 training algorithm',
'fann_cascadetrain_on_file' => 'Trains on an entire dataset read from file, for a period of time using the Cascade2 training algorithm',
'fann_clear_scaling_params' => 'Clears scaling parameters',
'fann_copy' => 'Creates a copy of a fann structure',
'fann_create_from_file' => 'Constructs a backpropagation neural network from a configuration file',
'fann_create_shortcut' => 'Creates a standard backpropagation neural network which is not fully connectected and has shortcut connections',
'fann_create_shortcut_array' => 'Creates a standard backpropagation neural network which is not fully connectected and has shortcut connections',
'fann_create_sparse' => 'Creates a standard backpropagation neural network, which is not fully connected',
'fann_create_sparse_array' => 'Creates a standard backpropagation neural network, which is not fully connected using an array of layer sizes',
'fann_create_standard' => 'Creates a standard fully connected backpropagation neural network',
'fann_create_standard_array' => 'Creates a standard fully connected backpropagation neural network using an array of layer sizes',
'fann_create_train' => 'Creates an empty training data struct',
'fann_create_train_from_callback' => 'Creates the training data struct from a user supplied function',
'fann_descale_input' => 'Scale data in input vector after get it from ann based on previously calculated parameters',
'fann_descale_output' => 'Scale data in output vector after get it from ann based on previously calculated parameters',
'fann_descale_train' => 'Descale input and output data based on previously calculated parameters',
'fann_destroy' => 'Destroys the entire network and properly freeing all the associated memory',
'fann_destroy_train' => 'Destructs the training data',
'fann_duplicate_train_data' => 'Returns an exact copy of a fann train data',
'fann_get_activation_function' => 'Returns the activation function',
'fann_get_activation_steepness' => 'Returns the activation steepness for supplied neuron and layer number',
'fann_get_bias_array' => 'Get the number of bias in each layer in the network',
'fann_get_bit_fail' => 'The number of fail bits',
'fann_get_bit_fail_limit' => 'Returns the bit fail limit used during training',
'fann_get_cascade_activation_functions' => 'Returns the cascade activation functions',
'fann_get_cascade_activation_functions_count' => 'Returns the number of cascade activation functions',
'fann_get_cascade_activation_steepnesses' => 'Returns the cascade activation steepnesses',
'fann_get_cascade_activation_steepnesses_count' => 'The number of activation steepnesses',
'fann_get_cascade_candidate_change_fraction' => 'Returns the cascade candidate change fraction',
'fann_get_cascade_candidate_limit' => 'Return the candidate limit',
'fann_get_cascade_candidate_stagnation_epochs' => 'Returns the number of cascade candidate stagnation epochs',
'fann_get_cascade_max_cand_epochs' => 'Returns the maximum candidate epochs',
'fann_get_cascade_max_out_epochs' => 'Returns the maximum out epochs',
'fann_get_cascade_min_cand_epochs' => 'Returns the minimum candidate epochs',
'fann_get_cascade_min_out_epochs' => 'Returns the minimum out epochs',
'fann_get_cascade_num_candidate_groups' => 'Returns the number of candidate groups',
'fann_get_cascade_num_candidates' => 'Returns the number of candidates used during training',
'fann_get_cascade_output_change_fraction' => 'Returns the cascade output change fraction',
'fann_get_cascade_output_stagnation_epochs' => 'Returns the number of cascade output stagnation epochs',
'fann_get_cascade_weight_multiplier' => 'Returns the weight multiplier',
'fann_get_connection_array' => 'Get connections in the network',
'fann_get_connection_rate' => 'Get the connection rate used when the network was created',
'fann_get_errno' => 'Returns the last error number',
'fann_get_errstr' => 'Returns the last errstr',
'fann_get_layer_array' => 'Get the number of neurons in each layer in the network',
'fann_get_learning_momentum' => 'Returns the learning momentum',
'fann_get_learning_rate' => 'Returns the learning rate',
'fann_get_mse' => 'Reads the mean square error from the network',
'fann_get_network_type' => 'Get the type of neural network it was created as',
'fann_get_num_input' => 'Get the number of input neurons',
'fann_get_num_layers' => 'Get the number of layers in the neural network',
'fann_get_num_output' => 'Get the number of output neurons',
'fann_get_quickprop_decay' => 'Returns the decay which is a factor that weights should decrease in each iteration during quickprop training',
'fann_get_quickprop_mu' => 'Returns the mu factor',
'fann_get_rprop_decrease_factor' => 'Returns the increase factor used during RPROP training',
'fann_get_rprop_delta_max' => 'Returns the maximum step-size',
'fann_get_rprop_delta_min' => 'Returns the minimum step-size',
'fann_get_rprop_delta_zero' => 'Returns the initial step-size',
'fann_get_rprop_increase_factor' => 'Returns the increase factor used during RPROP training',
'fann_get_sarprop_step_error_shift' => 'Returns the sarprop step error shift',
'fann_get_sarprop_step_error_threshold_factor' => 'Returns the sarprop step error threshold factor',
'fann_get_sarprop_temperature' => 'Returns the sarprop temperature',
'fann_get_sarprop_weight_decay_shift' => 'Returns the sarprop weight decay shift',
'fann_get_total_connections' => 'Get the total number of connections in the entire network',
'fann_get_total_neurons' => 'Get the total number of neurons in the entire network',
'fann_get_train_error_function' => 'Returns the error function used during training',
'fann_get_train_stop_function' => 'Returns the stop function used during training',
'fann_get_training_algorithm' => 'Returns the training algorithm',
'fann_init_weights' => 'Initialize the weights using Widrow + Nguyen’s algorithm',
'fann_length_train_data' => 'Returns the number of training patterns in the train data',
'fann_merge_train_data' => 'Merges the train data',
'fann_num_input_train_data' => 'Returns the number of inputs in each of the training patterns in the train data',
'fann_num_output_train_data' => 'Returns the number of outputs in each of the training patterns in the train data',
'fann_print_error' => 'Prints the error string',
'fann_randomize_weights' => 'Give each connection a random weight between min_weight and max_weight',
'fann_read_train_from_file' => 'Reads a file that stores training data',
'fann_reset_errno' => 'Resets the last error number',
'fann_reset_errstr' => 'Resets the last error string',
'fann_reset_mse' => 'Resets the mean square error from the network',
'fann_run' => 'Will run input through the neural network',
'fann_save' => 'Saves the entire network to a configuration file',
'fann_save_train' => 'Save the training structure to a file',
'fann_scale_input' => 'Scale data in input vector before feed it to ann based on previously calculated parameters',
'fann_scale_input_train_data' => 'Scales the inputs in the training data to the specified range',
'fann_scale_output' => 'Scale data in output vector before feed it to ann based on previously calculated parameters',
'fann_scale_output_train_data' => 'Scales the outputs in the training data to the specified range',
'fann_scale_train' => 'Scale input and output data based on previously calculated parameters',
'fann_scale_train_data' => 'Scales the inputs and outputs in the training data to the specified range',
'fann_set_activation_function' => 'Sets the activation function for supplied neuron and layer',
'fann_set_activation_function_hidden' => 'Sets the activation function for all of the hidden layers',
'fann_set_activation_function_layer' => 'Sets the activation function for all the neurons in the supplied layer',
'fann_set_activation_function_output' => 'Sets the activation function for the output layer',
'fann_set_activation_steepness' => 'Sets the activation steepness for supplied neuron and layer number',
'fann_set_activation_steepness_hidden' => 'Sets the steepness of the activation steepness for all neurons in the all hidden layers',
'fann_set_activation_steepness_layer' => 'Sets the activation steepness for all of the neurons in the supplied layer number',
'fann_set_activation_steepness_output' => 'Sets the steepness of the activation steepness in the output layer',
'fann_set_bit_fail_limit' => 'Set the bit fail limit used during training',
'fann_set_callback' => 'Sets the callback function for use during training',
'fann_set_cascade_activation_functions' => 'Sets the array of cascade candidate activation functions',
'fann_set_cascade_activation_steepnesses' => 'Sets the array of cascade candidate activation steepnesses',
'fann_set_cascade_candidate_change_fraction' => 'Sets the cascade candidate change fraction',
'fann_set_cascade_candidate_limit' => 'Sets the candidate limit',
'fann_set_cascade_candidate_stagnation_epochs' => 'Sets the number of cascade candidate stagnation epochs',
'fann_set_cascade_max_cand_epochs' => 'Sets the max candidate epochs',
'fann_set_cascade_max_out_epochs' => 'Sets the maximum out epochs',
'fann_set_cascade_min_cand_epochs' => 'Sets the min candidate epochs',
'fann_set_cascade_min_out_epochs' => 'Sets the minimum out epochs',
'fann_set_cascade_num_candidate_groups' => 'Sets the number of candidate groups',
'fann_set_cascade_output_change_fraction' => 'Sets the cascade output change fraction',
'fann_set_cascade_output_stagnation_epochs' => 'Sets the number of cascade output stagnation epochs',
'fann_set_cascade_weight_multiplier' => 'Sets the weight multiplier',
'fann_set_error_log' => 'Sets where the errors are logged to',
'fann_set_input_scaling_params' => 'Calculate input scaling parameters for future use based on training data',
'fann_set_learning_momentum' => 'Sets the learning momentum',
'fann_set_learning_rate' => 'Sets the learning rate',
'fann_set_output_scaling_params' => 'Calculate output scaling parameters for future use based on training data',
'fann_set_quickprop_decay' => 'Sets the quickprop decay factor',
'fann_set_quickprop_mu' => 'Sets the quickprop mu factor',
'fann_set_rprop_decrease_factor' => 'Sets the decrease factor used during RPROP training',
'fann_set_rprop_delta_max' => 'Sets the maximum step-size',
'fann_set_rprop_delta_min' => 'Sets the minimum step-size',
'fann_set_rprop_delta_zero' => 'Sets the initial step-size',
'fann_set_rprop_increase_factor' => 'Sets the increase factor used during RPROP training',
'fann_set_sarprop_step_error_shift' => 'Sets the sarprop step error shift',
'fann_set_sarprop_step_error_threshold_factor' => 'Sets the sarprop step error threshold factor',
'fann_set_sarprop_temperature' => 'Sets the sarprop temperature',
'fann_set_sarprop_weight_decay_shift' => 'Sets the sarprop weight decay shift',
'fann_set_scaling_params' => 'Calculate input and output scaling parameters for future use based on training data',
'fann_set_train_error_function' => 'Sets the error function used during training',
'fann_set_train_stop_function' => 'Sets the stop function used during training',
'fann_set_training_algorithm' => 'Sets the training algorithm',
'fann_set_weight' => 'Set a connection in the network',
'fann_set_weight_array' => 'Set connections in the network',
'fann_shuffle_train_data' => 'Shuffles training data, randomizing the order',
'fann_subset_train_data' => 'Returns an copy of a subset of the train data',
'fann_test' => 'Test with a set of inputs, and a set of desired outputs',
'fann_test_data' => 'Test a set of training data and calculates the MSE for the training data',
'fann_train' => 'Train one iteration with a set of inputs, and a set of desired outputs',
'fann_train_epoch' => 'Train one epoch with a set of training data',
'fann_train_on_data' => 'Trains on an entire dataset for a period of time',
'fann_train_on_file' => 'Trains on an entire dataset, which is read from file, for a period of time',
'fannconnection::__construct' => 'The connection constructor',
'fannconnection::getFromNeuron' => 'Returns the positions of starting neuron',
'fannconnection::getToNeuron' => 'Returns the positions of terminating neuron',
'fannconnection::getWeight' => 'Returns the connection weight',
'fannconnection::setWeight' => 'Sets the connections weight',
'fastcgi_finish_request' => 'Flushes all response data to the client',
'fbird_add_user' => 'Alias of ibase_add_user',
'fbird_affected_rows' => 'Alias of ibase_affected_rows',
'fbird_backup' => 'Alias of ibase_backup',
'fbird_blob_add' => 'Alias of ibase_blob_add',
'fbird_blob_cancel' => 'Cancel creating blob',
'fbird_blob_close' => 'Alias of ibase_blob_close',
'fbird_blob_create' => 'Alias of ibase_blob_create',
'fbird_blob_echo' => 'Alias of ibase_blob_echo',
'fbird_blob_get' => 'Alias of ibase_blob_get',
'fbird_blob_import' => 'Alias of ibase_blob_import',
'fbird_blob_info' => 'Alias of ibase_blob_info',
'fbird_blob_open' => 'Alias of ibase_blob_open',
'fbird_close' => 'Alias of ibase_close',
'fbird_commit' => 'Alias of ibase_commit',
'fbird_commit_ret' => 'Alias of ibase_commit_ret',
'fbird_connect' => 'Alias of ibase_connect',
'fbird_db_info' => 'Alias of ibase_db_info',
'fbird_delete_user' => 'Alias of ibase_delete_user',
'fbird_drop_db' => 'Alias of ibase_drop_db',
'fbird_errcode' => 'Alias of ibase_errcode',
'fbird_errmsg' => 'Alias of ibase_errmsg',
'fbird_execute' => 'Alias of ibase_execute',
'fbird_fetch_assoc' => 'Alias of ibase_fetch_assoc',
'fbird_fetch_object' => 'Alias of ibase_fetch_object',
'fbird_fetch_row' => 'Alias of ibase_fetch_row',
'fbird_field_info' => 'Alias of ibase_field_info',
'fbird_free_event_handler' => 'Alias of ibase_free_event_handler',
'fbird_free_query' => 'Alias of ibase_free_query',
'fbird_free_result' => 'Alias of ibase_free_result',
'fbird_gen_id' => 'Alias of ibase_gen_id',
'fbird_maintain_db' => 'Alias of ibase_maintain_db',
'fbird_modify_user' => 'Alias of ibase_modify_user',
'fbird_name_result' => 'Alias of ibase_name_result',
'fbird_num_fields' => 'Alias of ibase_num_fields',
'fbird_num_params' => 'Alias of ibase_num_params',
'fbird_param_info' => 'Alias of ibase_param_info',
'fbird_pconnect' => 'Alias of ibase_pconnect',
'fbird_prepare' => 'Alias of ibase_prepare',
'fbird_query' => 'Alias of ibase_query',
'fbird_restore' => 'Alias of ibase_restore',
'fbird_rollback' => 'Alias of ibase_rollback',
'fbird_rollback_ret' => 'Alias of ibase_rollback_ret',
'fbird_server_info' => 'Alias of ibase_server_info',
'fbird_service_attach' => 'Alias of ibase_service_attach',
'fbird_service_detach' => 'Alias of ibase_service_detach',
'fbird_set_event_handler' => 'Alias of ibase_set_event_handler',
'fbird_trans' => 'Alias of ibase_trans',
'fbird_wait_event' => 'Alias of ibase_wait_event',
'fbsql_affected_rows' => 'Get number of affected rows in previous FrontBase operation',
'fbsql_autocommit' => 'Enable or disable autocommit',
'fbsql_blob_size' => 'Get the size of a BLOB',
'fbsql_change_user' => 'Change logged in user of the active connection',
'fbsql_clob_size' => 'Get the size of a CLOB',
'fbsql_close' => 'Close FrontBase connection',
'fbsql_commit' => 'Commits a transaction to the database',
'fbsql_connect' => 'Open a connection to a FrontBase Server',
'fbsql_create_blob' => 'Create a BLOB',
'fbsql_create_clob' => 'Create a CLOB',
'fbsql_create_db' => 'Create a FrontBase database',
'fbsql_data_seek' => 'Move internal result pointer',
'fbsql_database' => 'Get or set the database name used with a connection',
'fbsql_database_password' => 'Sets or retrieves the password for a FrontBase database',
'fbsql_db_query' => 'Send a FrontBase query',
'fbsql_db_status' => 'Get the status for a given database',
'fbsql_drop_db' => 'Drop (delete) a FrontBase database',
'fbsql_errno' => 'Returns the error number from previous operation',
'fbsql_error' => 'Returns the error message from previous operation',
'fbsql_fetch_array' => 'Fetch a result row as an associative array, a numeric array, or both',
'fbsql_fetch_assoc' => 'Fetch a result row as an associative array',
'fbsql_fetch_field' => 'Get column information from a result and return as an object',
'fbsql_fetch_lengths' => 'Get the length of each output in a result',
'fbsql_fetch_object' => 'Fetch a result row as an object',
'fbsql_fetch_row' => 'Get a result row as an enumerated array',
'fbsql_field_flags' => 'Get the flags associated with the specified field in a result',
'fbsql_field_len' => 'Returns the length of the specified field',
'fbsql_field_name' => 'Get the name of the specified field in a result',
'fbsql_field_seek' => 'Set result pointer to a specified field offset',
'fbsql_field_table' => 'Get name of the table the specified field is in',
'fbsql_field_type' => 'Get the type of the specified field in a result',
'fbsql_free_result' => 'Free result memory',
'fbsql_hostname' => 'Get or set the host name used with a connection',
'fbsql_insert_id' => 'Get the id generated from the previous INSERT operation',
'fbsql_list_dbs' => 'List databases available on a FrontBase server',
'fbsql_list_fields' => 'List FrontBase result fields',
'fbsql_list_tables' => 'List tables in a FrontBase database',
'fbsql_next_result' => 'Move the internal result pointer to the next result',
'fbsql_num_fields' => 'Get number of fields in result',
'fbsql_num_rows' => 'Get number of rows in result',
'fbsql_password' => 'Get or set the user password used with a connection',
'fbsql_pconnect' => 'Open a persistent connection to a FrontBase Server',
'fbsql_query' => 'Send a FrontBase query',
'fbsql_read_blob' => 'Read a BLOB from the database',
'fbsql_read_clob' => 'Read a CLOB from the database',
'fbsql_result' => 'Get result data',
'fbsql_rollback' => 'Rollback a transaction to the database',
'fbsql_rows_fetched' => 'Get the number of rows affected by the last statement',
'fbsql_select_db' => 'Select a FrontBase database',
'fbsql_set_characterset' => 'Change input/output character set',
'fbsql_set_lob_mode' => 'Set the LOB retrieve mode for a FrontBase result set',
'fbsql_set_password' => 'Change the password for a given user',
'fbsql_set_transaction' => 'Set the transaction locking and isolation',
'fbsql_start_db' => 'Start a database on local or remote server',
'fbsql_stop_db' => 'Stop a database on local or remote server',
'fbsql_table_name' => 'Get table name of field',
'fbsql_tablename' => 'Alias of fbsql_table_name',
'fbsql_username' => 'Get or set the username for the connection',
'fbsql_warnings' => 'Enable or disable FrontBase warnings',
'fclose' => 'Closes an open file pointer',
'fdf_add_doc_javascript' => 'Adds javascript code to the FDF document',
'fdf_add_template' => 'Adds a template into the FDF document',
'fdf_close' => 'Close an FDF document',
'fdf_create' => 'Create a new FDF document',
'fdf_enum_values' => 'Call a user defined function for each document value',
'fdf_errno' => 'Return error code for last fdf operation',
'fdf_error' => 'Return error description for FDF error code',
'fdf_get_ap' => 'Get the appearance of a field',
'fdf_get_attachment' => 'Extracts uploaded file embedded in the FDF',
'fdf_get_encoding' => 'Get the value of the /Encoding key',
'fdf_get_file' => 'Get the value of the /F key',
'fdf_get_flags' => 'Gets the flags of a field',
'fdf_get_opt' => 'Gets a value from the opt array of a field',
'fdf_get_status' => 'Get the value of the /STATUS key',
'fdf_get_value' => 'Get the value of a field',
'fdf_get_version' => 'Gets version number for FDF API or file',
'fdf_header' => 'Sets FDF-specific output headers',
'fdf_next_field_name' => 'Get the next field name',
'fdf_open' => 'Open a FDF document',
'fdf_open_string' => 'Read a FDF document from a string',
'fdf_remove_item' => 'Sets target frame for form',
'fdf_save' => 'Save a FDF document',
'fdf_save_string' => 'Returns the FDF document as a string',
'fdf_set_ap' => 'Set the appearance of a field',
'fdf_set_encoding' => 'Sets FDF character encoding',
'fdf_set_file' => 'Set PDF document to display FDF data in',
'fdf_set_flags' => 'Sets a flag of a field',
'fdf_set_javascript_action' => 'Sets an javascript action of a field',
'fdf_set_on_import_javascript' => 'Adds javascript code to be executed when Acrobat opens the FDF',
'fdf_set_opt' => 'Sets an option of a field',
'fdf_set_status' => 'Set the value of the /STATUS key',
'fdf_set_submit_form_action' => 'Sets a submit form action of a field',
'fdf_set_target_frame' => 'Set target frame for form display',
'fdf_set_value' => 'Set the value of a field',
'fdf_set_version' => 'Sets version number for a FDF file',
'feof' => 'Tests for end-of-file on a file pointer',
'FFI::addr' => 'Returns C pointer to the given C data structure. The pointer is
not "owned" and won\'t be free. Anyway, this is a potentially
unsafe operation, because the life-time of the returned pointer
may be longer than life-time of the source object, and this may
cause dangling pointer dereference (like in regular C).',
'FFI::alignof' => 'Returns size of C data type of the given FFI\CData or FFI\CType.',
'FFI::arrayType' => 'Constructs a new C array type with elements of $type and
dimensions specified by $dimensions.',
'FFI::cast' => 'Casts given $pointer to another C type, specified by C declaration
string or FFI\CType object.

This function may be called statically and use only predefined
types, or as a method of previously created FFI object. In last
case the first argument may reuse all type and tag names
defined in FFI::cdef().',
'FFI::cdef' => 'The method creates a binding on the existing C function.

All variables and functions defined by first arguments are bound
to corresponding native symbols in DSO library and then may be
accessed as FFI object methods and properties. C types of argument,
return value and variables are automatically converted to/from PHP
types (if possible). Otherwise, they are wrapped in a special CData
proxy object and may be accessed by elements.',
'FFI::free' => 'Manually removes previously created "not-owned" data structure.',
'ffi::isNull' => 'Checks whether a FFI\CData is a null pointer',
'FFI::load' => '<p>Instead of embedding of a long C definition into PHP string,
and creating FFI through FFI::cdef(), it\'s possible to separate
it into a C header file. Note, that C preprocessor directives
(e.g. #define or #ifdef) are not supported. And only a couple of
special macros may be used especially for FFI.</p>

<code>
 #define FFI_LIB "libc.so.6"

 int printf(const char *format, ...);
</code>

Here, FFI_LIB specifies, that the given library should be loaded.

<code>
 $ffi = FFI::load(__DIR__ . "/printf.h");
 $ffi->printf("Hello world!\n");
</code>',
'FFI::memcmp' => 'Compares $size bytes from memory area $a and $b.',
'FFI::memcpy' => 'Copies $size bytes from memory area $source to memory area $target.
$source may be any native data structure (FFI\CData) or PHP string.',
'FFI::memset' => 'Fills the $size bytes of the memory area pointed to by $target with
the constant byte $byte.',
'FFI::new' => 'Method that creates an arbitrary C structure.',
'FFI::scope' => 'FFI definition parsing and shared library loading may take
significant time. It\'s not useful to do it on each HTTP request in
WEB environment. However, it\'s possible to pre-load FFI definitions
and libraries at php startup, and instantiate FFI objects when
necessary. Header files may be extended with FFI_SCOPE define
(default pre-loading scope is "C"). This name is going to be
used as FFI::scope() argument. It\'s possible to pre-load few
files into a single scope.

<code>
 #define FFI_LIB "libc.so.6"
 #define FFI_SCOPE "libc"

 int printf(const char *format, ...);
</code>

These files are loaded through the same FFI::load() load function,
executed from file loaded by opcache.preload php.ini directive.

<code>
 ffi.preload=/etc/php/ffi/printf.h
</code>

Finally, FFI::scope() instantiate an FFI object, that implements
all C definition from the given scope.

<code>
 $ffi = FFI::scope("libc");
 $ffi->printf("Hello world!\n");
</code>',
'FFI::sizeof' => 'Returns size of C data type of the given FFI\CData or FFI\CType.',
'FFI::string' => 'Creates a PHP string from $size bytes of memory area pointed by
$source. If size is omitted, $source must be zero terminated
array of C chars.',
'FFI::type' => 'This function creates and returns a FFI\CType object, representng
type of the given C type declaration string.

FFI::type() may be called statically and use only predefined types,
or as a method of previously created FFI object. In last case the
first argument may reuse all type and tag names defined in
FFI::cdef().',
'FFI::typeof' => 'This function returns a FFI\CType object, representing the type of
the given FFI\CData object.',
'fflush' => 'Flushes the output to a file',
'ffmpeg_animated_gif::addFrame' => 'Add a frame to the end of the animated gif.',
'ffmpeg_frame::__construct' => 'NOTE: This function will not be available if GD is not enabled.',
'ffmpeg_frame::crop' => 'Crop the frame.',
'ffmpeg_frame::getHeight' => 'Return the height of the frame.',
'ffmpeg_frame::getPresentationTimestamp' => 'Return the presentation time stamp of the frame.',
'ffmpeg_frame::getPTS' => 'Return the presentation time stamp of the frame.',
'ffmpeg_frame::getWidth' => 'Return the width of the frame.',
'ffmpeg_frame::resize' => 'Resize and optionally crop the frame. (Cropping is built into ffmpeg resizing so I\'m providing it here for completeness.)',
'ffmpeg_frame::toGDImage' => 'Returns a truecolor GD image of the frame.
NOTE: This function will not be available if GD is not enabled.',
'ffmpeg_movie::__construct' => 'Open a video or audio file and return it as an object.',
'ffmpeg_movie::getArtist' => 'Return the author field from the movie or the artist ID3 field from an mp3 file.',
'ffmpeg_movie::getAudioBitRate' => 'Return the audio bit rate of the media file in bits per second.',
'ffmpeg_movie::getAudioChannels' => 'Return the number of audio channels in this movie as an integer.',
'ffmpeg_movie::getAudioCodec' => 'Return the name of the audio codec used to encode this movie as a string.',
'ffmpeg_movie::getAudioSampleRate' => 'Return the audio sample rate of the media file in bits per second.',
'ffmpeg_movie::getAuthor' => 'Return the author field from the movie or the artist ID3 field from an mp3 file.',
'ffmpeg_movie::getBitRate' => 'Return the bit rate of the movie or audio file in bits per second.',
'ffmpeg_movie::getComment' => 'Return the comment field from the movie or audio file.',
'ffmpeg_movie::getCopyright' => 'Return the copyright field from the movie or audio file.',
'ffmpeg_movie::getDuration' => 'Return the duration of a movie or audio file in seconds.',
'ffmpeg_movie::getFilename' => 'Return the path and name of the movie file or audio file.',
'ffmpeg_movie::getFrame' => 'Returns a frame from the movie as an ffmpeg_frame object. Returns false if the frame was not found.',
'ffmpeg_movie::getFrameCount' => 'Return the number of frames in a movie or audio file.',
'ffmpeg_movie::getFrameHeight' => 'Return the height of the movie in pixels.',
'ffmpeg_movie::getFrameNumber' => 'Return the current frame index.',
'ffmpeg_movie::getFrameRate' => 'Return the frame rate of a movie in fps.',
'ffmpeg_movie::getFrameWidth' => 'Return the width of the movie in pixels.',
'ffmpeg_movie::getGenre' => 'Return the genre ID3 field from an mp3 file.',
'ffmpeg_movie::getNextKeyFrame' => 'Returns the next key frame from the movie as an ffmpeg_frame object. Returns false if the frame was not found.',
'ffmpeg_movie::getPixelFormat' => 'Return the pixel format of the movie.',
'ffmpeg_movie::getTitle' => 'Return the title field from the movie or audio file.',
'ffmpeg_movie::getTrackNumber' => 'Return the track ID3 field from an mp3 file.',
'ffmpeg_movie::getVideoBitRate' => 'Return the bit rate of the video in bits per second.
NOTE: This only works for files with constant bit rate.',
'ffmpeg_movie::getVideoCodec' => 'Return the name of the video codec used to encode this movie as a string.',
'ffmpeg_movie::getYear' => 'Return the year ID3 field from an mp3 file.',
'ffmpeg_movie::hasAudio' => 'Return boolean value indicating whether the movie has an audio stream.',
'ffmpeg_movie::hasVideo' => 'Return boolean value indicating whether the movie has a video stream.',
'fgetc' => 'Gets character from file pointer',
'fgetcsv' => 'Gets line from file pointer and parse for CSV fields',
'fgets' => 'Gets line from file pointer',
'fgetss' => 'Gets line from file pointer and strip HTML tags',
'file' => 'Reads entire file into an array',
'file_exists' => 'Checks whether a file or directory exists',
'file_get_contents' => 'Reads entire file into a string',
'file_put_contents' => 'Write data to a file',
'fileatime' => 'Gets last access time of file',
'filectime' => 'Gets inode change time of file',
'filegroup' => 'Gets file group',
'fileinode' => 'Gets file inode',
'filemtime' => 'Gets file modification time',
'fileowner' => 'Gets file owner',
'fileperms' => 'Gets file permissions',
'filepro' => 'Read and verify the map file',
'filepro_fieldcount' => 'Find out how many fields are in a filePro database',
'filepro_fieldname' => 'Gets the name of a field',
'filepro_fieldtype' => 'Gets the type of a field',
'filepro_fieldwidth' => 'Gets the width of a field',
'filepro_retrieve' => 'Retrieves data from a filePro database',
'filepro_rowcount' => 'Find out how many rows are in a filePro database',
'filesize' => 'Gets file size',
'FilesystemIterator::__construct' => 'Constructs a new filesystem iterator',
'FilesystemIterator::__toString' => 'Get file name as a string',
'FilesystemIterator::current' => 'The current file',
'FilesystemIterator::getATime' => 'Get last access time of the current DirectoryIterator item',
'FilesystemIterator::getBasename' => 'Get base name of current DirectoryIterator item',
'FilesystemIterator::getCTime' => 'Get inode change time of the current DirectoryIterator item',
'FilesystemIterator::getExtension' => 'Gets the file extension',
'FilesystemIterator::getFileInfo' => 'Gets an SplFileInfo object for the file',
'FilesystemIterator::getFilename' => 'Return file name of current DirectoryIterator item',
'FilesystemIterator::getFlags' => 'Get the handling flags',
'FilesystemIterator::getGroup' => 'Get group for the current DirectoryIterator item',
'FilesystemIterator::getInode' => 'Get inode for the current DirectoryIterator item',
'FilesystemIterator::getLinkTarget' => 'Gets the target of a link',
'FilesystemIterator::getMTime' => 'Get last modification time of current DirectoryIterator item',
'FilesystemIterator::getOwner' => 'Get owner of current DirectoryIterator item',
'FilesystemIterator::getPath' => 'Get path of current Iterator item without filename',
'FilesystemIterator::getPathInfo' => 'Gets an SplFileInfo object for the path',
'FilesystemIterator::getPathname' => 'Return path and file name of current DirectoryIterator item',
'FilesystemIterator::getPerms' => 'Get the permissions of current DirectoryIterator item',
'FilesystemIterator::getRealPath' => 'Gets absolute path to file',
'FilesystemIterator::getSize' => 'Get size of current DirectoryIterator item',
'FilesystemIterator::getType' => 'Determine the type of the current DirectoryIterator item',
'FilesystemIterator::isDir' => 'Determine if current DirectoryIterator item is a directory',
'FilesystemIterator::isDot' => 'Determine if current DirectoryIterator item is \'.\' or \'..\'',
'FilesystemIterator::isExecutable' => 'Determine if current DirectoryIterator item is executable',
'FilesystemIterator::isFile' => 'Determine if current DirectoryIterator item is a regular file',
'FilesystemIterator::isLink' => 'Determine if current DirectoryIterator item is a symbolic link',
'FilesystemIterator::isReadable' => 'Determine if current DirectoryIterator item can be read',
'FilesystemIterator::isWritable' => 'Determine if current DirectoryIterator item can be written to',
'FilesystemIterator::key' => 'Retrieve the key for the current file',
'FilesystemIterator::next' => 'Move to the next file',
'FilesystemIterator::openFile' => 'Gets an SplFileObject object for the file',
'FilesystemIterator::rewind' => 'Rewinds back to the beginning',
'FilesystemIterator::seek' => 'Seek to a DirectoryIterator item',
'FilesystemIterator::setFileClass' => 'Sets the class used with SplFileInfo::openFile',
'FilesystemIterator::setFlags' => 'Sets handling flags',
'FilesystemIterator::setInfoClass' => 'Sets the class used with SplFileInfo::getFileInfo and SplFileInfo::getPathInfo',
'FilesystemIterator::valid' => 'Check whether current DirectoryIterator position is a valid file',
'filetype' => 'Gets file type',
'filter_has_var' => 'Checks if variable of specified type exists',
'filter_id' => 'Returns the filter ID belonging to a named filter',
'filter_input' => 'Gets a specific external variable by name and optionally filters it',
'filter_input_array' => 'Gets external variables and optionally filters them',
'filter_list' => 'Returns a list of all supported filters',
'filter_var' => 'Filters a variable with a specified filter',
'filter_var_array' => 'Gets multiple variables and optionally filters them',
'filteriterator::__construct' => 'Construct a filterIterator',
'filteriterator::accept' => 'Check whether the current element of the iterator is acceptable',
'filteriterator::current' => 'Get the current element value',
'filteriterator::getInnerIterator' => 'Get the inner iterator',
'filteriterator::key' => 'Get the current key',
'filteriterator::next' => 'Move the iterator forward',
'filteriterator::rewind' => 'Rewind the iterator',
'filteriterator::valid' => 'Check whether the current element is valid',
'finfo::__construct' => 'Alias of finfo_open',
'finfo::buffer' => 'Alias of finfo_buffer()',
'finfo::file' => 'Alias of finfo_file()',
'finfo::set_flags' => 'Alias of finfo_set_flags()',
'finfo_close' => 'Close fileinfo resource',
'floatval' => 'Get float value of a variable',
'flock' => 'Portable advisory file locking',
'floor' => 'Round fractions down',
'flush' => 'Flush system output buffer',
'fmod' => 'Returns the floating point remainder (modulo) of the division of the arguments',
'fnmatch' => 'Match filename against a pattern',
'fopen' => 'Opens file or URL',
'forward_static_call' => 'Call a static method',
'forward_static_call_array' => 'Call a static method and pass the arguments as array',
'fpassthru' => 'Output all remaining data on a file pointer',
'fprintf' => 'Write a formatted string to a stream',
'fputcsv' => 'Format line as CSV and write to file pointer',
'fputs' => 'Alias of fwrite',
'fread' => 'Binary-safe file read',
'frenchtojd' => 'Converts a date from the French Republican Calendar to a Julian Day Count',
'fribidi_log2vis' => 'Convert a logical string to a visual one',
'fscanf' => 'Parses input from a file according to a format',
'fseek' => 'Seeks on a file pointer',
'fsockopen' => 'Open Internet or Unix domain socket connection',
'fstat' => 'Gets information about a file using an open file pointer',
'ftell' => 'Returns the current position of the file read/write pointer',
'ftok' => 'Convert a pathname and a project identifier to a System V IPC key',
'ftp_alloc' => 'Allocates space for a file to be uploaded',
'ftp_append' => 'Append content of a file a another file on the FTP server',
'ftp_cdup' => 'Changes to the parent directory',
'ftp_chdir' => 'Changes the current directory on a FTP server',
'ftp_chmod' => 'Set permissions on a file via FTP',
'ftp_close' => 'Closes an FTP connection',
'ftp_connect' => 'Opens an FTP connection',
'ftp_delete' => 'Deletes a file on the FTP server',
'ftp_exec' => 'Requests execution of a command on the FTP server',
'ftp_fget' => 'Downloads a file from the FTP server and saves to an open file',
'ftp_fput' => 'Uploads from an open file to the FTP server',
'ftp_get' => 'Downloads a file from the FTP server',
'ftp_get_option' => 'Retrieves various runtime behaviours of the current FTP stream',
'ftp_login' => 'Logs in to an FTP connection',
'ftp_mdtm' => 'Returns the last modified time of the given file',
'ftp_mkdir' => 'Creates a directory',
'ftp_mlsd' => 'Returns a list of files in the given directory',
'ftp_nb_continue' => 'Continues retrieving/sending a file (non-blocking)',
'ftp_nb_fget' => 'Retrieves a file from the FTP server and writes it to an open file (non-blocking)',
'ftp_nb_fput' => 'Stores a file from an open file to the FTP server (non-blocking)',
'ftp_nb_get' => 'Retrieves a file from the FTP server and writes it to a local file (non-blocking)',
'ftp_nb_put' => 'Stores a file on the FTP server (non-blocking)',
'ftp_nlist' => 'Returns a list of files in the given directory',
'ftp_pasv' => 'Turns passive mode on or off',
'ftp_put' => 'Uploads a file to the FTP server',
'ftp_pwd' => 'Returns the current directory name',
'ftp_quit' => 'Alias of ftp_close',
'ftp_raw' => 'Sends an arbitrary command to an FTP server',
'ftp_rawlist' => 'Returns a detailed list of files in the given directory',
'ftp_rename' => 'Renames a file or a directory on the FTP server',
'ftp_rmdir' => 'Removes a directory',
'ftp_set_option' => 'Set miscellaneous runtime FTP options',
'ftp_site' => 'Sends a SITE command to the server',
'ftp_size' => 'Returns the size of the given file',
'ftp_ssl_connect' => 'Opens a Secure SSL-FTP connection',
'ftp_systype' => 'Returns the system type identifier of the remote FTP server',
'ftruncate' => 'Truncates a file to a given length',
'func_get_arg' => 'Return an item from the argument list',
'func_get_args' => 'Returns an array comprising a function\'s argument list',
'func_num_args' => 'Returns the number of arguments passed to the function',
'function_exists' => 'Return `true` if the given function has been defined',
'fwrite' => 'Binary-safe file write',
'gc_collect_cycles' => 'Forces collection of any existing garbage cycles',
'gc_disable' => 'Deactivates the circular reference collector',
'gc_enable' => 'Activates the circular reference collector',
'gc_enabled' => 'Returns status of the circular reference collector',
'gc_mem_caches' => 'Reclaims memory used by the Zend Engine memory manager',
'gc_status' => 'Gets information about the garbage collector',
'gd_info' => 'Retrieve information about the currently installed GD library',
'gearmanclient::__construct' => 'Create a GearmanClient instance',
'gearmanclient::addOptions' => 'Add client options',
'gearmanclient::addServer' => 'Add a job server to the client',
'gearmanclient::addServers' => 'Add a list of job servers to the client',
'gearmanclient::addTask' => 'Add a task to be run in parallel',
'gearmanclient::addTaskBackground' => 'Add a background task to be run in parallel',
'gearmanclient::addTaskHigh' => 'Add a high priority task to run in parallel',
'gearmanclient::addTaskHighBackground' => 'Add a high priority background task to be run in parallel',
'gearmanclient::addTaskLow' => 'Add a low priority task to run in parallel',
'gearmanclient::addTaskLowBackground' => 'Add a low priority background task to be run in parallel',
'gearmanclient::addTaskStatus' => 'Add a task to get status',
'gearmanclient::clearCallbacks' => 'Clear all task callback functions',
'gearmanclient::clone' => 'Create a copy of a GearmanClient object',
'gearmanclient::context' => 'Get the application context',
'gearmanclient::data' => 'Get the application data (deprecated)',
'gearmanclient::do' => 'Run a single task and return a result [deprecated]',
'gearmanclient::doBackground' => 'Run a task in the background',
'gearmanclient::doHigh' => 'Run a single high priority task',
'gearmanclient::doHighBackground' => 'Run a high priority task in the background',
'gearmanclient::doJobHandle' => 'Get the job handle for the running task',
'gearmanclient::doLow' => 'Run a single low priority task',
'gearmanclient::doLowBackground' => 'Run a low priority task in the background',
'gearmanclient::doNormal' => 'Run a single task and return a result',
'gearmanclient::doStatus' => 'Get the status for the running task',
'gearmanclient::echo' => 'Send data to all job servers to see if they echo it back [deprecated]',
'gearmanclient::error' => 'Returns an error string for the last error encountered',
'gearmanclient::getErrno' => 'Get an errno value',
'gearmanclient::jobStatus' => 'Get the status of a background job',
'gearmanclient::ping' => 'Send data to all job servers to see if they echo it back',
'gearmanclient::removeOptions' => 'Remove client options',
'gearmanclient::returnCode' => 'Get the last Gearman return code',
'gearmanclient::runTasks' => 'Run a list of tasks in parallel',
'gearmanclient::setClientCallback' => 'Callback function when there is a data packet for a task (deprecated)',
'gearmanclient::setCompleteCallback' => 'Set a function to be called on task completion',
'gearmanclient::setContext' => 'Set application context',
'gearmanclient::setCreatedCallback' => 'Set a callback for when a task is queued',
'gearmanclient::setData' => 'Set application data (deprecated)',
'gearmanclient::setDataCallback' => 'Callback function when there is a data packet for a task',
'gearmanclient::setExceptionCallback' => 'Set a callback for worker exceptions',
'gearmanclient::setFailCallback' => 'Set callback for job failure',
'gearmanclient::setOptions' => 'Set client options',
'gearmanclient::setStatusCallback' => 'Set a callback for collecting task status',
'gearmanclient::setTimeout' => 'Set socket I/O activity timeout',
'gearmanclient::setWarningCallback' => 'Set a callback for worker warnings',
'gearmanclient::setWorkloadCallback' => 'Set a callback for accepting incremental data updates',
'gearmanclient::timeout' => 'Get current socket I/O activity timeout value',
'gearmanjob::__construct' => 'Create a GearmanJob instance',
'gearmanjob::complete' => 'Send the result and complete status (deprecated)',
'gearmanjob::data' => 'Send data for a running job (deprecated)',
'gearmanjob::exception' => 'Send exception for running job (deprecated)',
'gearmanjob::fail' => 'Send fail status (deprecated)',
'gearmanjob::functionName' => 'Get function name',
'gearmanjob::handle' => 'Get the job handle',
'gearmanjob::returnCode' => 'Get last return code',
'gearmanjob::sendComplete' => 'Send the result and complete status',
'gearmanjob::sendData' => 'Send data for a running job',
'gearmanjob::sendException' => 'Send exception for running job (exception)',
'gearmanjob::sendFail' => 'Send fail status',
'gearmanjob::sendStatus' => 'Send status',
'gearmanjob::sendWarning' => 'Send a warning',
'gearmanjob::setReturn' => 'Set a return value',
'gearmanjob::status' => 'Send status (deprecated)',
'gearmanjob::unique' => 'Get the unique identifier',
'gearmanjob::warning' => 'Send a warning (deprecated)',
'gearmanjob::workload' => 'Get workload',
'gearmanjob::workloadSize' => 'Get size of work load',
'gearmantask::__construct' => 'Create a GearmanTask instance',
'gearmantask::create' => 'Create a task (deprecated)',
'gearmantask::data' => 'Get data returned for a task',
'gearmantask::dataSize' => 'Get the size of returned data',
'gearmantask::function' => 'Get associated function name (deprecated)',
'gearmantask::functionName' => 'Get associated function name',
'gearmantask::isKnown' => 'Determine if task is known',
'gearmantask::isRunning' => 'Test whether the task is currently running',
'gearmantask::jobHandle' => 'Get the job handle',
'gearmantask::recvData' => 'Read work or result data into a buffer for a task',
'gearmantask::returnCode' => 'Get the last return code',
'gearmantask::sendData' => 'Send data for a task (deprecated)',
'gearmantask::sendWorkload' => 'Send data for a task',
'gearmantask::taskDenominator' => 'Get completion percentage denominator',
'gearmantask::taskNumerator' => 'Get completion percentage numerator',
'gearmantask::unique' => 'Get the unique identifier for a task',
'gearmantask::uuid' => 'Get the unique identifier for a task (deprecated)',
'gearmanworker::__construct' => 'Create a GearmanWorker instance',
'gearmanworker::addFunction' => 'Register and add callback function',
'gearmanworker::addOptions' => 'Add worker options',
'gearmanworker::addServer' => 'Add a job server',
'gearmanworker::addServers' => 'Add job servers',
'gearmanworker::clone' => 'Create a copy of the worker',
'gearmanworker::echo' => 'Test job server response',
'gearmanworker::error' => 'Get the last error encountered',
'gearmanworker::getErrno' => 'Get errno',
'gearmanworker::options' => 'Get worker options',
'gearmanworker::register' => 'Register a function with the job server',
'gearmanworker::removeOptions' => 'Remove worker options',
'gearmanworker::returnCode' => 'Get last Gearman return code',
'gearmanworker::setId' => 'Give the worker an identifier so it can be tracked when asking gearmand for the list of available workers',
'gearmanworker::setOptions' => 'Set worker options',
'gearmanworker::setTimeout' => 'Set socket I/O activity timeout',
'gearmanworker::timeout' => 'Get socket I/O activity timeout',
'gearmanworker::unregister' => 'Unregister a function name with the job servers',
'gearmanworker::unregisterAll' => 'Unregister all function names with the job servers',
'gearmanworker::wait' => 'Wait for activity from one of the job servers',
'gearmanworker::work' => 'Wait for and perform jobs',
'gender\gender::__construct' => 'Construct the Gender object',
'gender\gender::connect' => 'Connect to an external name dictionary',
'gender\gender::country' => 'Get textual country representation',
'gender\gender::get' => 'Get gender of a name',
'gender\gender::isNick' => 'Check if the name0 is an alias of the name1',
'gender\gender::similarNames' => 'Get similar names',
'Generator::__wakeup' => 'Serialize callback
Throws an exception as generators can\'t be serialized.',
'Generator::current' => 'Returns whatever was passed to yield or null if nothing was passed or the generator is already closed.',
'Generator::getReturn' => 'Returns whatever was passed to return or null if nothing.
Throws an exception if the generator is still valid.',
'Generator::key' => 'Returns the yielded key or, if none was specified, an auto-incrementing key or null if the generator is already closed.',
'Generator::next' => 'Resumes the generator (unless the generator is already closed).',
'Generator::rewind' => 'Throws an exception if the generator is currently after the first yield.',
'Generator::send' => 'Sets the return value of the yield expression and resumes the generator (unless the generator is already closed).',
'Generator::valid' => 'Returns false if the generator has been closed, true otherwise.',
'geoip_asnum_by_name' => 'Get the Autonomous System Numbers (ASN)',
'geoip_continent_code_by_name' => 'Get the two letter continent code',
'geoip_country_code3_by_name' => 'Get the three letter country code',
'geoip_country_code_by_name' => 'Get the two letter country code',
'geoip_country_name_by_name' => 'Get the full country name',
'geoip_database_info' => 'Get GeoIP Database information',
'geoip_db_avail' => 'Determine if GeoIP Database is available',
'geoip_db_filename' => 'Returns the filename of the corresponding GeoIP Database',
'geoip_db_get_all_info' => 'Returns detailed information about all GeoIP database types',
'geoip_domain_by_name' => 'Get the second level domain name',
'geoip_id_by_name' => 'Get the Internet connection type',
'geoip_isp_by_name' => 'Get the Internet Service Provider (ISP) name',
'geoip_netspeedcell_by_name' => 'Get the Internet connection speed',
'geoip_org_by_name' => 'Get the organization name',
'geoip_record_by_name' => 'Returns the detailed City information found in the GeoIP Database',
'geoip_region_by_name' => 'Get the country code and region',
'geoip_region_name_by_code' => 'Returns the region name for some country and region code combo',
'geoip_setup_custom_directory' => 'Set a custom directory for the GeoIP database',
'geoip_time_zone_by_country_and_region' => 'Returns the time zone for some country and region code combo',
'GEOSGeometry::__construct' => 'GEOSGeometry constructor.',
'GEOSPolygonize' => '- \'rings\'
    Type: array of GEOSGeometry
    Rings that can be formed by the costituent
    linework of geometry.
- \'cut_edges\' (optional)
    Type: array of GEOSGeometry
    Edges which are connected at both ends but
    which do not form part of polygon.
- \'dangles\'
    Type: array of GEOSGeometry
    Edges which have one or both ends which are
    not incident on another edge endpoint
- \'invalid_rings\'
    Type: array of GEOSGeometry
    Edges which form rings which are invalid
    (e.g. the component lines contain a self-intersection)',
'GEOSWKBReader::__construct' => 'GEOSWKBReader constructor.',
'GEOSWKBWriter::__construct' => 'GEOSWKBWriter constructor.',
'GEOSWKTReader::__construct' => 'GEOSWKTReader constructor.',
'GEOSWKTWriter::__construct' => 'GEOSWKTWriter constructor.',
'get_browser' => 'Tells what the user\'s browser is capable of',
'get_called_class' => 'The "Late Static Binding" class name',
'get_cfg_var' => 'Gets the value of a PHP configuration option',
'get_class' => 'Returns the name of the class of an object',
'get_class_methods' => 'Gets the class methods\' names',
'get_class_vars' => 'Get the default properties of the class',
'get_current_user' => 'Gets the name of the owner of the current PHP script',
'get_declared_classes' => 'Returns an array with the name of the defined classes',
'get_declared_interfaces' => 'Returns an array of all declared interfaces',
'get_declared_traits' => 'Returns an array of all declared traits',
'get_defined_constants' => 'Returns an associative array with the names of all the constants and their values',
'get_defined_functions' => 'Returns an array of all defined functions',
'get_defined_vars' => 'Returns an array of all defined variables',
'get_extension_funcs' => 'Returns an array with the names of the functions of a module',
'get_headers' => 'Fetches all the headers sent by the server in response to an HTTP request',
'get_html_translation_table' => 'Returns the translation table used by htmlspecialchars and htmlentities',
'get_include_path' => 'Gets the current include_path configuration option',
'get_included_files' => 'Returns an array with the names of included or required files',
'get_loaded_extensions' => 'Returns an array with the names of all modules compiled and loaded',
'get_magic_quotes_gpc' => 'Gets the current configuration setting of magic_quotes_gpc',
'get_magic_quotes_runtime' => 'Gets the current active configuration setting of magic_quotes_runtime',
'get_meta_tags' => 'Extracts all meta tag content attributes from a file and returns an array',
'get_object_vars' => 'Gets the properties of the given object',
'get_parent_class' => 'Retrieves the parent class name for object or class',
'get_required_files' => 'Alias of get_included_files',
'get_resource_type' => 'Returns the resource type',
'get_resources' => 'Returns active resources',
'getallheaders' => 'Fetch all HTTP request headers',
'getcwd' => 'Gets the current working directory',
'getdate' => 'Get date/time information',
'getenv' => 'Gets the value of an environment variable',
'gethostbyaddr' => 'Get the Internet host name corresponding to a given IP address',
'gethostbyname' => 'Get the IPv4 address corresponding to a given Internet host name',
'gethostbynamel' => 'Get a list of IPv4 addresses corresponding to a given Internet host name',
'gethostname' => 'Gets the host name',
'getimagesize' => 'Get the size of an image',
'getimagesizefromstring' => 'Get the size of an image from a string',
'getlastmod' => 'Gets time of last page modification',
'getmxrr' => 'Get MX records corresponding to a given Internet host name',
'getmygid' => 'Get PHP script owner\'s GID',
'getmyinode' => 'Gets the inode of the current script',
'getmypid' => 'Gets PHP\'s process ID',
'getmyuid' => 'Gets PHP script owner\'s UID',
'getopt' => 'Gets options from the command line argument list',
'getprotobyname' => 'Get protocol number associated with protocol name',
'getprotobynumber' => 'Get protocol name associated with protocol number',
'getrandmax' => 'Show largest possible random value',
'getrusage' => 'Gets the current resource usages',
'getservbyname' => 'Get port number associated with an Internet service and protocol',
'getservbyport' => 'Get Internet service which corresponds to port and protocol',
'getsession' => 'Connect to a MySQL server',
'gettext' => 'Lookup a message in the current domain',
'gettimeofday' => 'Get current time',
'gettype' => 'Get the type of a variable',
'glob' => 'Find pathnames matching a pattern',
'globiterator::__construct' => 'Construct a directory using glob',
'GlobIterator::__toString' => 'Get file name as a string',
'globiterator::count' => 'Get the number of directories and files',
'GlobIterator::current' => 'The current file',
'GlobIterator::getATime' => 'Get last access time of the current DirectoryIterator item',
'GlobIterator::getBasename' => 'Get base name of current DirectoryIterator item',
'GlobIterator::getCTime' => 'Get inode change time of the current DirectoryIterator item',
'GlobIterator::getExtension' => 'Gets the file extension',
'GlobIterator::getFileInfo' => 'Gets an SplFileInfo object for the file',
'GlobIterator::getFilename' => 'Return file name of current DirectoryIterator item',
'GlobIterator::getFlags' => 'Get the handling flags',
'GlobIterator::getGroup' => 'Get group for the current DirectoryIterator item',
'GlobIterator::getInode' => 'Get inode for the current DirectoryIterator item',
'GlobIterator::getLinkTarget' => 'Gets the target of a link',
'GlobIterator::getMTime' => 'Get last modification time of current DirectoryIterator item',
'GlobIterator::getOwner' => 'Get owner of current DirectoryIterator item',
'GlobIterator::getPath' => 'Get path of current Iterator item without filename',
'GlobIterator::getPathInfo' => 'Gets an SplFileInfo object for the path',
'GlobIterator::getPathname' => 'Return path and file name of current DirectoryIterator item',
'GlobIterator::getPerms' => 'Get the permissions of current DirectoryIterator item',
'GlobIterator::getRealPath' => 'Gets absolute path to file',
'GlobIterator::getSize' => 'Get size of current DirectoryIterator item',
'GlobIterator::getType' => 'Determine the type of the current DirectoryIterator item',
'GlobIterator::isDir' => 'Determine if current DirectoryIterator item is a directory',
'GlobIterator::isDot' => 'Determine if current DirectoryIterator item is \'.\' or \'..\'',
'GlobIterator::isExecutable' => 'Determine if current DirectoryIterator item is executable',
'GlobIterator::isFile' => 'Determine if current DirectoryIterator item is a regular file',
'GlobIterator::isLink' => 'Determine if current DirectoryIterator item is a symbolic link',
'GlobIterator::isReadable' => 'Determine if current DirectoryIterator item can be read',
'GlobIterator::isWritable' => 'Determine if current DirectoryIterator item can be written to',
'GlobIterator::key' => 'Retrieve the key for the current file',
'GlobIterator::next' => 'Move to the next file',
'GlobIterator::openFile' => 'Gets an SplFileObject object for the file',
'GlobIterator::rewind' => 'Rewinds back to the beginning',
'GlobIterator::seek' => 'Seek to a DirectoryIterator item',
'GlobIterator::setFileClass' => 'Sets the class used with SplFileInfo::openFile',
'GlobIterator::setFlags' => 'Sets handling flags',
'GlobIterator::setInfoClass' => 'Sets the class used with SplFileInfo::getFileInfo and SplFileInfo::getPathInfo',
'GlobIterator::valid' => 'Check whether current DirectoryIterator position is a valid file',
'gmagick::__construct' => 'The Gmagick constructor',
'gmagick::addimage' => 'Adds new image to Gmagick object image list',
'gmagick::addnoiseimage' => 'Adds random noise to the image',
'gmagick::annotateimage' => 'Annotates an image with text',
'gmagick::blurimage' => 'Adds blur filter to image',
'gmagick::borderimage' => 'Surrounds the image with a border',
'gmagick::charcoalimage' => 'Simulates a charcoal drawing',
'gmagick::chopimage' => 'Removes a region of an image and trims',
'gmagick::clear' => 'Clears all resources associated to Gmagick object',
'gmagick::commentimage' => 'Adds a comment to your image',
'gmagick::compositeimage' => 'Composite one image onto another',
'gmagick::cropimage' => 'Extracts a region of the image',
'gmagick::cropthumbnailimage' => 'Creates a crop thumbnail',
'gmagick::current' => 'The current purpose',
'gmagick::cyclecolormapimage' => 'Displaces an image\'s colormap',
'gmagick::deconstructimages' => 'Returns certain pixel differences between images',
'gmagick::despeckleimage' => 'The despeckleimage purpose',
'gmagick::destroy' => 'The destroy purpose',
'gmagick::drawimage' => 'Renders the GmagickDraw object on the current image',
'gmagick::edgeimage' => 'Enhance edges within the image',
'gmagick::embossimage' => 'Returns a grayscale image with a three-dimensional effect',
'gmagick::enhanceimage' => 'Improves the quality of a noisy image',
'gmagick::equalizeimage' => 'Equalizes the image histogram',
'gmagick::flipimage' => 'Creates a vertical mirror image',
'gmagick::flopimage' => 'The flopimage purpose',
'gmagick::frameimage' => 'Adds a simulated three-dimensional border',
'gmagick::gammaimage' => 'Gamma-corrects an image',
'gmagick::getcopyright' => 'Returns the GraphicsMagick API copyright as a string',
'gmagick::getfilename' => 'The filename associated with an image sequence',
'gmagick::getimagebackgroundcolor' => 'Returns the image background color',
'gmagick::getimageblueprimary' => 'Returns the chromaticy blue primary point',
'gmagick::getimagebordercolor' => 'Returns the image border color',
'gmagick::getimagechanneldepth' => 'Gets the depth for a particular image channel',
'gmagick::getimagecolors' => 'Returns the color of the specified colormap index',
'gmagick::getimagecolorspace' => 'Gets the image colorspace',
'gmagick::getimagecompose' => 'Returns the composite operator associated with the image',
'gmagick::getimagedelay' => 'Gets the image delay',
'gmagick::getimagedepth' => 'Gets the depth of the image',
'gmagick::getimagedispose' => 'Gets the image disposal method',
'gmagick::getimageextrema' => 'Gets the extrema for the image',
'gmagick::getimagefilename' => 'Returns the filename of a particular image in a sequence',
'gmagick::getimageformat' => 'Returns the format of a particular image in a sequence',
'gmagick::getimagegamma' => 'Gets the image gamma',
'gmagick::getimagegreenprimary' => 'Returns the chromaticy green primary point',
'gmagick::getimageheight' => 'Returns the image height',
'gmagick::getimagehistogram' => 'Gets the image histogram',
'gmagick::getimageindex' => 'Gets the index of the current active image',
'gmagick::getimageinterlacescheme' => 'Gets the image interlace scheme',
'gmagick::getimageiterations' => 'Gets the image iterations',
'gmagick::getimagematte' => 'Check if the image has a matte channel',
'gmagick::getimagemattecolor' => 'Returns the image matte color',
'gmagick::getimageprofile' => 'Returns the named image profile',
'gmagick::getimageredprimary' => 'Returns the chromaticity red primary point',
'gmagick::getimagerenderingintent' => 'Gets the image rendering intent',
'gmagick::getimageresolution' => 'Gets the image X and Y resolution',
'gmagick::getimagescene' => 'Gets the image scene',
'gmagick::getimagesignature' => 'Generates an SHA-256 message digest',
'gmagick::getimagetype' => 'Gets the potential image type',
'gmagick::getimageunits' => 'Gets the image units of resolution',
'gmagick::getimagewhitepoint' => 'Returns the chromaticity white point',
'gmagick::getimagewidth' => 'Returns the width of the image',
'gmagick::getpackagename' => 'Returns the GraphicsMagick package name',
'gmagick::getquantumdepth' => 'Returns the Gmagick quantum depth as a string',
'gmagick::getreleasedate' => 'Returns the GraphicsMagick release date as a string',
'gmagick::getsamplingfactors' => 'Gets the horizontal and vertical sampling factor',
'gmagick::getsize' => 'Returns the size associated with the Gmagick object',
'gmagick::getversion' => 'Returns the GraphicsMagick API version',
'gmagick::hasnextimage' => 'Checks if the object has more images',
'gmagick::haspreviousimage' => 'Checks if the object has a previous image',
'gmagick::implodeimage' => 'Creates a new image as a copy',
'gmagick::labelimage' => 'Adds a label to an image',
'gmagick::levelimage' => 'Adjusts the levels of an image',
'gmagick::magnifyimage' => 'Scales an image proportionally 2x',
'gmagick::mapimage' => 'Replaces the colors of an image with the closest color from a reference image',
'gmagick::medianfilterimage' => 'Applies a digital filter',
'gmagick::minifyimage' => 'Scales an image proportionally to half its size',
'gmagick::modulateimage' => 'Control the brightness, saturation, and hue',
'gmagick::motionblurimage' => 'Simulates motion blur',
'gmagick::newimage' => 'Creates a new image',
'gmagick::nextimage' => 'Moves to the next image',
'gmagick::normalizeimage' => 'Enhances the contrast of a color image',
'gmagick::oilpaintimage' => 'Simulates an oil painting',
'gmagick::previousimage' => 'Move to the previous image in the object',
'gmagick::profileimage' => 'Adds or removes a profile from an image',
'gmagick::quantizeimage' => 'Analyzes the colors within a reference image',
'gmagick::quantizeimages' => 'The quantizeimages purpose',
'gmagick::queryfontmetrics' => 'Returns an array representing the font metrics',
'gmagick::queryfonts' => 'Returns the configured fonts',
'gmagick::queryformats' => 'Returns formats supported by Gmagick',
'gmagick::radialblurimage' => 'Radial blurs an image',
'gmagick::raiseimage' => 'Creates a simulated 3d button-like effect',
'gmagick::read' => 'Reads image from filename',
'gmagick::readimage' => 'Reads image from filename',
'gmagick::readimageblob' => 'Reads image from a binary string',
'gmagick::readimagefile' => 'The readimagefile purpose',
'gmagick::reducenoiseimage' => 'Smooths the contours of an image',
'gmagick::removeimage' => 'Removes an image from the image list',
'gmagick::removeimageprofile' => 'Removes the named image profile and returns it',
'gmagick::resampleimage' => 'Resample image to desired resolution',
'gmagick::resizeimage' => 'Scales an image',
'gmagick::rollimage' => 'Offsets an image',
'gmagick::rotateimage' => 'Rotates an image',
'gmagick::scaleimage' => 'Scales the size of an image',
'gmagick::separateimagechannel' => 'Separates a channel from the image',
'gmagick::setCompressionQuality' => 'Sets the object\'s default compression quality',
'gmagick::setfilename' => 'Sets the filename before you read or write the image',
'gmagick::setimagebackgroundcolor' => 'Sets the image background color',
'gmagick::setimageblueprimary' => 'Sets the image chromaticity blue primary point',
'gmagick::setimagebordercolor' => 'Sets the image border color',
'gmagick::setimagechanneldepth' => 'Sets the depth of a particular image channel',
'gmagick::setimagecolorspace' => 'Sets the image colorspace',
'gmagick::setimagecompose' => 'Sets the image composite operator',
'gmagick::setimagedelay' => 'Sets the image delay',
'gmagick::setimagedepth' => 'Sets the image depth',
'gmagick::setimagedispose' => 'Sets the image disposal method',
'gmagick::setimagefilename' => 'Sets the filename of a particular image in a sequence',
'gmagick::setimageformat' => 'Sets the format of a particular image',
'gmagick::setimagegamma' => 'Sets the image gamma',
'gmagick::setimagegreenprimary' => 'Sets the image chromaticity green primary point',
'gmagick::setimageindex' => 'Set the iterator to the position in the image list specified with the index parameter',
'gmagick::setimageinterlacescheme' => 'Sets the interlace scheme of the image',
'gmagick::setimageiterations' => 'Sets the image iterations',
'gmagick::setimageprofile' => 'Adds a named profile to the Gmagick object',
'gmagick::setimageredprimary' => 'Sets the image chromaticity red primary point',
'gmagick::setimagerenderingintent' => 'Sets the image rendering intent',
'gmagick::setimageresolution' => 'Sets the image resolution',
'gmagick::setimagescene' => 'Sets the image scene',
'gmagick::setimagetype' => 'Sets the image type',
'gmagick::setimageunits' => 'Sets the image units of resolution',
'gmagick::setimagewhitepoint' => 'Sets the image chromaticity white point',
'gmagick::setsamplingfactors' => 'Sets the image sampling factors',
'gmagick::setsize' => 'Sets the size of the Gmagick object',
'gmagick::shearimage' => 'Creating a parallelogram',
'gmagick::solarizeimage' => 'Applies a solarizing effect to the image',
'gmagick::spreadimage' => 'Randomly displaces each pixel in a block',
'gmagick::stripimage' => 'Strips an image of all profiles and comments',
'gmagick::swirlimage' => 'Swirls the pixels about the center of the image',
'gmagick::thumbnailimage' => 'Changes the size of an image',
'gmagick::trimimage' => 'Remove edges from the image',
'gmagick::write' => 'Alias of Gmagick::writeimage',
'gmagick::writeimage' => 'Writes an image to the specified filename',
'gmagickdraw::annotate' => 'Draws text on the image',
'gmagickdraw::arc' => 'Draws an arc',
'gmagickdraw::bezier' => 'Draws a bezier curve',
'gmagickdraw::ellipse' => 'Draws an ellipse on the image',
'gmagickdraw::getfillcolor' => 'Returns the fill color',
'gmagickdraw::getfillopacity' => 'Returns the opacity used when drawing',
'gmagickdraw::getfont' => 'Returns the font',
'gmagickdraw::getfontsize' => 'Returns the font pointsize',
'gmagickdraw::getfontstyle' => 'Returns the font style',
'gmagickdraw::getfontweight' => 'Returns the font weight',
'gmagickdraw::getstrokecolor' => 'Returns the color used for stroking object outlines',
'gmagickdraw::getstrokeopacity' => 'Returns the opacity of stroked object outlines',
'gmagickdraw::getstrokewidth' => 'Returns the width of the stroke used to draw object outlines',
'gmagickdraw::gettextdecoration' => 'Returns the text decoration',
'gmagickdraw::gettextencoding' => 'Returns the code set used for text annotations',
'gmagickdraw::line' => 'The line purpose',
'gmagickdraw::point' => 'Draws a point',
'gmagickdraw::polygon' => 'Draws a polygon',
'gmagickdraw::polyline' => 'Draws a polyline',
'gmagickdraw::rectangle' => 'Draws a rectangle',
'gmagickdraw::rotate' => 'Applies the specified rotation to the current coordinate space',
'gmagickdraw::roundrectangle' => 'Draws a rounded rectangle',
'gmagickdraw::scale' => 'Adjusts the scaling factor',
'gmagickdraw::setfillcolor' => 'Sets the fill color to be used for drawing filled objects',
'gmagickdraw::setfillopacity' => 'The setfillopacity purpose',
'gmagickdraw::setfont' => 'Sets the fully-specified font to use when annotating with text',
'gmagickdraw::setfontsize' => 'Sets the font pointsize to use when annotating with text',
'gmagickdraw::setfontstyle' => 'Sets the font style to use when annotating with text',
'gmagickdraw::setfontweight' => 'Sets the font weight',
'gmagickdraw::setstrokecolor' => 'Sets the color used for stroking object outlines',
'gmagickdraw::setstrokeopacity' => 'Specifies the opacity of stroked object outlines',
'gmagickdraw::setstrokewidth' => 'Sets the width of the stroke used to draw object outlines',
'gmagickdraw::settextdecoration' => 'Specifies a decoration',
'gmagickdraw::settextencoding' => 'Specifies the text code set',
'gmagickpixel::__construct' => 'The GmagickPixel constructor',
'gmagickpixel::getcolor' => 'Returns the color',
'gmagickpixel::getcolorcount' => 'Returns the color count associated with this color',
'gmagickpixel::getcolorvalue' => 'Gets the normalized value of the provided color channel',
'gmagickpixel::setcolor' => 'Sets the color',
'gmagickpixel::setcolorvalue' => 'Sets the normalized value of one of the channels',
'gmdate' => 'Format a GMT/UTC date/time',
'gmmktime' => 'Get Unix timestamp for a GMT date',
'GMP::serialize' => 'String representation of object',
'GMP::unserialize' => 'Constructs the object',
'gmp_abs' => 'Absolute value',
'gmp_add' => 'Add numbers',
'gmp_and' => 'Bitwise AND',
'gmp_binomial' => 'Calculates binomial coefficient',
'gmp_clrbit' => 'Clear bit',
'gmp_cmp' => 'Compare numbers',
'gmp_com' => 'Calculates one\'s complement',
'gmp_div' => 'Alias of gmp_div_q',
'gmp_div_q' => 'Divide numbers',
'gmp_div_qr' => 'Divide numbers and get quotient and remainder',
'gmp_div_r' => 'Remainder of the division of numbers',
'gmp_divexact' => 'Exact division of numbers',
'gmp_export' => 'Export to a binary string',
'gmp_fact' => 'Factorial',
'gmp_gcd' => 'Calculate GCD',
'gmp_gcdext' => 'Calculate GCD and multipliers',
'gmp_hamdist' => 'Hamming distance',
'gmp_import' => 'Import from a binary string',
'gmp_init' => 'Create GMP number',
'gmp_intval' => 'Convert GMP number to integer',
'gmp_invert' => 'Inverse by modulo',
'gmp_jacobi' => 'Jacobi symbol',
'gmp_kronecker' => 'Kronecker symbol',
'gmp_lcm' => 'Calculate GCD',
'gmp_legendre' => 'Legendre symbol',
'gmp_mod' => 'Modulo operation',
'gmp_mul' => 'Multiply numbers',
'gmp_neg' => 'Negate number',
'gmp_nextprime' => 'Find next prime number',
'gmp_or' => 'Bitwise OR',
'gmp_perfect_power' => 'Perfect power check',
'gmp_perfect_square' => 'Perfect square check',
'gmp_popcount' => 'Population count',
'gmp_pow' => 'Raise number into power',
'gmp_powm' => 'Raise number into power with modulo',
'gmp_prob_prime' => 'Check if number is "probably prime"',
'gmp_random' => 'Random number',
'gmp_random_bits' => 'Random number',
'gmp_random_range' => 'Random number',
'gmp_random_seed' => 'Sets the RNG seed',
'gmp_root' => 'Take the integer part of nth root',
'gmp_rootrem' => 'Take the integer part and remainder of nth root',
'gmp_scan0' => 'Scan for 0',
'gmp_scan1' => 'Scan for 1',
'gmp_setbit' => 'Set bit',
'gmp_sign' => 'Sign of number',
'gmp_sqrt' => 'Calculate square root',
'gmp_sqrtrem' => 'Square root with remainder',
'gmp_strval' => 'Convert GMP number to string',
'gmp_sub' => 'Subtract numbers',
'gmp_testbit' => 'Tests if a bit is set',
'gmp_xor' => 'Bitwise XOR',
'gmstrftime' => 'Format a GMT/UTC time/date according to locale settings',
'gnupg::adddecryptkey' => 'Add a key for decryption',
'gnupg::addencryptkey' => 'Add a key for encryption',
'gnupg::addsignkey' => 'Add a key for signing',
'gnupg::cleardecryptkeys' => 'Removes all keys which were set for decryption before',
'gnupg::clearencryptkeys' => 'Removes all keys which were set for encryption before',
'gnupg::clearsignkeys' => 'Removes all keys which were set for signing before',
'gnupg::decrypt' => 'Decrypts a given text',
'gnupg::decryptverify' => 'Decrypts and verifies a given text',
'gnupg::encrypt' => 'Encrypts a given text',
'gnupg::encryptsign' => 'Encrypts and signs a given text',
'gnupg::export' => 'Exports a key',
'gnupg::geterror' => 'Returns the errortext, if a function fails',
'gnupg::getprotocol' => 'Returns the currently active protocol for all operations',
'gnupg::import' => 'Imports a key',
'gnupg::init' => 'Initialize a connection',
'gnupg::keyinfo' => 'Returns an array with information about all keys that matches the given pattern',
'gnupg::setarmor' => 'Toggle armored output',
'gnupg::seterrormode' => 'Sets the mode for error_reporting',
'gnupg::setsignmode' => 'Sets the mode for signing',
'gnupg::sign' => 'Signs a given text',
'gnupg::verify' => 'Verifies a signed text',
'gnupg_adddecryptkey' => 'Add a key for decryption',
'gnupg_addencryptkey' => 'Add a key for encryption',
'gnupg_addsignkey' => 'Add a key for signing',
'gnupg_cleardecryptkeys' => 'Removes all keys which were set for decryption before',
'gnupg_clearencryptkeys' => 'Removes all keys which were set for encryption before',
'gnupg_clearsignkeys' => 'Removes all keys which were set for signing before',
'gnupg_decrypt' => 'Decrypts a given text',
'gnupg_decryptverify' => 'Decrypts and verifies a given text',
'gnupg_encrypt' => 'Encrypts a given text',
'gnupg_encryptsign' => 'Encrypts and signs a given text',
'gnupg_export' => 'Exports a key',
'gnupg_geterror' => 'Returns the errortext, if a function fails',
'gnupg_getprotocol' => 'Returns the currently active protocol for all operations',
'gnupg_import' => 'Imports a key',
'gnupg_init' => 'Initialize a connection',
'gnupg_keyinfo' => 'Returns an array with information about all keys that matches the given pattern',
'gnupg_setarmor' => 'Toggle armored output',
'gnupg_seterrormode' => 'Sets the mode for error_reporting',
'gnupg_setsignmode' => 'Sets the mode for signing',
'gnupg_sign' => 'Signs a given text',
'gnupg_verify' => 'Verifies a signed text',
'gopher_parsedir' => 'Translate a gopher formatted directory entry into an associative array',
'gregoriantojd' => 'Converts a Gregorian date to Julian Day Count',
'gridObj::set' => 'Set object property to a new value.',
'Grpc\Call::__construct' => 'Constructs a new instance of the Call class.',
'Grpc\Call::cancel' => 'Cancel the call. This will cause the call to end with STATUS_CANCELLED if it
has not already ended with another status.',
'Grpc\Call::getPeer' => 'Get the endpoint this call/stream is connected to',
'Grpc\Call::setCredentials' => 'Set the CallCredentials for this call.',
'Grpc\Call::startBatch' => 'Start a batch of RPC actions.',
'Grpc\CallCredentials::createComposite' => 'Create composite credentials from two existing credentials.',
'Grpc\CallCredentials::createFromPlugin' => 'Create a call credentials object from the plugin API',
'Grpc\Channel::__construct' => 'Construct an instance of the Channel class. If the $args array contains a
"credentials" key mapping to a ChannelCredentials object, a secure channel
will be created with those credentials.',
'Grpc\Channel::close' => 'Close the channel',
'Grpc\Channel::getConnectivityState' => 'Get the connectivity state of the channel',
'Grpc\Channel::getTarget' => 'Get the endpoint this call/stream is connected to',
'Grpc\Channel::watchConnectivityState' => 'Watch the connectivity state of the channel until it changed',
'Grpc\ChannelCredentials::createComposite' => 'Create composite credentials from two existing credentials.',
'Grpc\ChannelCredentials::createDefault' => 'Create a default channel credentials object.',
'Grpc\ChannelCredentials::createInsecure' => 'Create insecure channel credentials',
'Grpc\ChannelCredentials::createSsl' => 'Create SSL credentials.',
'Grpc\ChannelCredentials::setDefaultRootsPem' => 'Set default roots pem.',
'Grpc\Server::__construct' => 'Constructs a new instance of the Server class',
'Grpc\Server::addHttp2Port' => 'Add a http2 over tcp listener.',
'Grpc\Server::addSecureHttp2Port' => 'Add a secure http2 over tcp listener.',
'Grpc\Server::requestCall' => 'Request a call on a server. Creates a single GRPC_SERVER_RPC_NEW event.',
'Grpc\Server::start' => 'Start a server - tells all listeners to start listening',
'Grpc\ServerCredentials::createSsl' => 'Create SSL credentials.',
'Grpc\Timeval::__construct' => 'Constructs a new instance of the Timeval class',
'Grpc\Timeval::add' => 'Adds another Timeval to this one and returns the sum. Calculations saturate
at infinities.',
'Grpc\Timeval::compare' => 'Return negative, 0, or positive according to whether a < b, a == b, or a > b
respectively.',
'Grpc\Timeval::infFuture' => 'Returns the infinite future time value as a timeval object',
'Grpc\Timeval::infPast' => 'Returns the infinite past time value as a timeval object',
'Grpc\Timeval::now' => 'Returns the current time as a timeval object',
'Grpc\Timeval::similar' => 'Checks whether the two times are within $threshold of each other',
'Grpc\Timeval::sleepUntil' => 'Sleep until this time, interpreted as an absolute timeout',
'Grpc\Timeval::subtract' => 'Subtracts another Timeval from this one and returns the difference.
Calculations saturate at infinities.',
'Grpc\Timeval::zero' => 'Returns the zero time interval as a timeval object',
'gupnp_context_get_host_ip' => 'Get the IP address',
'gupnp_context_get_port' => 'Get the port',
'gupnp_context_get_subscription_timeout' => 'Get the event subscription timeout',
'gupnp_context_host_path' => 'Start hosting',
'gupnp_context_new' => 'Create a new context',
'gupnp_context_set_subscription_timeout' => 'Sets the event subscription timeout',
'gupnp_context_timeout_add' => 'Sets a function to be called at regular intervals',
'gupnp_context_unhost_path' => 'Stop hosting',
'gupnp_control_point_browse_start' => 'Start browsing',
'gupnp_control_point_browse_stop' => 'Stop browsing',
'gupnp_control_point_callback_set' => 'Set control point callback',
'gupnp_control_point_new' => 'Create a new control point',
'gupnp_device_action_callback_set' => 'Set device callback function',
'gupnp_device_info_get' => 'Get info of root device',
'gupnp_device_info_get_service' => 'Get the service with type',
'gupnp_root_device_get_available' => 'Check whether root device is available',
'gupnp_root_device_get_relative_location' => 'Get the relative location of root device',
'gupnp_root_device_new' => 'Create a new root device',
'gupnp_root_device_set_available' => 'Set whether or not root_device is available',
'gupnp_root_device_start' => 'Start main loop',
'gupnp_root_device_stop' => 'Stop main loop',
'gupnp_service_action_get' => 'Retrieves the specified action arguments',
'gupnp_service_action_return' => 'Return successfully',
'gupnp_service_action_return_error' => 'Return error code',
'gupnp_service_action_set' => 'Sets the specified action return values',
'gupnp_service_freeze_notify' => 'Freeze new notifications',
'gupnp_service_info_get' => 'Get full info of service',
'gupnp_service_info_get_introspection' => 'Get resource introspection of service',
'gupnp_service_introspection_get_state_variable' => 'Returns the state variable data',
'gupnp_service_notify' => 'Notifies listening clients',
'gupnp_service_proxy_action_get' => 'Send action to the service and get value',
'gupnp_service_proxy_action_set' => 'Send action to the service and set value',
'gupnp_service_proxy_add_notify' => 'Sets up callback for variable change notification',
'gupnp_service_proxy_callback_set' => 'Set service proxy callback for signal',
'gupnp_service_proxy_get_subscribed' => 'Check whether subscription is valid to the service',
'gupnp_service_proxy_remove_notify' => 'Cancels the variable change notification',
'gupnp_service_proxy_send_action' => 'Send action with multiple parameters synchronously',
'gupnp_service_proxy_set_subscribed' => '(Un)subscribes to the service',
'gupnp_service_thaw_notify' => 'Sends out any pending notifications and stops queuing of new ones',
'gzclose' => 'Close an open gz-file pointer',
'gzcompress' => 'Compress a string',
'gzdecode' => 'Decodes a gzip compressed string',
'gzdeflate' => 'Deflate a string',
'gzencode' => 'Create a gzip compressed string',
'gzeof' => 'Test for EOF on a gz-file pointer',
'gzfile' => 'Read entire gz-file into an array',
'gzgetc' => 'Get character from gz-file pointer',
'gzgets' => 'Get line from file pointer',
'gzgetss' => 'Get line from gz-file pointer and strip HTML tags',
'gzinflate' => 'Inflate a deflated string',
'gzopen' => 'Open gz-file',
'gzpassthru' => 'Output all remaining data on a gz-file pointer',
'gzputs' => 'Alias of gzwrite',
'gzread' => 'Binary-safe gz-file read',
'gzrewind' => 'Rewind the position of a gz-file pointer',
'gzseek' => 'Seek on a gz-file pointer',
'gztell' => 'Tell gz-file pointer read/write position',
'gzuncompress' => 'Uncompress a compressed string',
'gzwrite' => 'Binary-safe gz-file write',
'haruannotation::setBorderStyle' => 'Set the border style of the annotation',
'haruannotation::setHighlightMode' => 'Set the highlighting mode of the annotation',
'haruannotation::setIcon' => 'Set the icon style of the annotation',
'haruannotation::setOpened' => 'Set the initial state of the annotation',
'harudestination::setFit' => 'Set the appearance of the page to fit the window',
'harudestination::setFitB' => 'Set the appearance of the page to fit the bounding box of the page within the window',
'harudestination::setFitBH' => 'Set the appearance of the page to fit the width of the bounding box',
'harudestination::setFitBV' => 'Set the appearance of the page to fit the height of the boudning box',
'harudestination::setFitH' => 'Set the appearance of the page to fit the window width',
'harudestination::setFitR' => 'Set the appearance of the page to fit the specified rectangle',
'harudestination::setFitV' => 'Set the appearance of the page to fit the window height',
'harudestination::setXYZ' => 'Set the appearance of the page',
'harudoc::__construct' => 'Construct new HaruDoc instance',
'harudoc::addPage' => 'Add new page to the document',
'harudoc::addPageLabel' => 'Set the numbering style for the specified range of pages',
'harudoc::createOutline' => 'Create a HaruOutline instance',
'harudoc::getCurrentEncoder' => 'Get HaruEncoder currently used in the document',
'harudoc::getCurrentPage' => 'Return current page of the document',
'harudoc::getEncoder' => 'Get HaruEncoder instance for the specified encoding',
'harudoc::getFont' => 'Get HaruFont instance',
'harudoc::getInfoAttr' => 'Get current value of the specified document attribute',
'harudoc::getPageLayout' => 'Get current page layout',
'harudoc::getPageMode' => 'Get current page mode',
'harudoc::getStreamSize' => 'Get the size of the temporary stream',
'harudoc::insertPage' => 'Insert new page just before the specified page',
'harudoc::loadJPEG' => 'Load a JPEG image',
'harudoc::loadPNG' => 'Load PNG image and return HaruImage instance',
'harudoc::loadRaw' => 'Load a RAW image',
'harudoc::loadTTC' => 'Load the font with the specified index from TTC file',
'harudoc::loadTTF' => 'Load TTF font file',
'harudoc::loadType1' => 'Load Type1 font',
'harudoc::output' => 'Write the document data to the output buffer',
'harudoc::readFromStream' => 'Read data from the temporary stream',
'harudoc::resetError' => 'Reset error state of the document handle',
'harudoc::resetStream' => 'Rewind the temporary stream',
'harudoc::save' => 'Save the document into the specified file',
'harudoc::saveToStream' => 'Save the document into a temporary stream',
'harudoc::setCompressionMode' => 'Set compression mode for the document',
'harudoc::setCurrentEncoder' => 'Set the current encoder for the document',
'harudoc::setEncryptionMode' => 'Set encryption mode for the document',
'harudoc::setInfoAttr' => 'Set the info attribute of the document',
'harudoc::setInfoDateAttr' => 'Set the datetime info attributes of the document',
'harudoc::setOpenAction' => 'Define which page is shown when the document is opened',
'harudoc::setPageLayout' => 'Set how pages should be displayed',
'harudoc::setPageMode' => 'Set how the document should be displayed',
'harudoc::setPagesConfiguration' => 'Set the number of pages per set of pages',
'harudoc::setPassword' => 'Set owner and user passwords for the document',
'harudoc::setPermission' => 'Set permissions for the document',
'harudoc::useCNSEncodings' => 'Enable Chinese simplified encodings',
'harudoc::useCNSFonts' => 'Enable builtin Chinese simplified fonts',
'harudoc::useCNTEncodings' => 'Enable Chinese traditional encodings',
'harudoc::useCNTFonts' => 'Enable builtin Chinese traditional fonts',
'harudoc::useJPEncodings' => 'Enable Japanese encodings',
'harudoc::useJPFonts' => 'Enable builtin Japanese fonts',
'harudoc::useKREncodings' => 'Enable Korean encodings',
'harudoc::useKRFonts' => 'Enable builtin Korean fonts',
'haruencoder::getByteType' => 'Get the type of the byte in the text',
'haruencoder::getType' => 'Get the type of the encoder',
'haruencoder::getUnicode' => 'Convert the specified character to unicode',
'haruencoder::getWritingMode' => 'Get the writing mode of the encoder',
'harufont::getAscent' => 'Get the vertical ascent of the font',
'harufont::getCapHeight' => 'Get the distance from the baseline of uppercase letters',
'harufont::getDescent' => 'Get the vertical descent of the font',
'harufont::getEncodingName' => 'Get the name of the encoding',
'harufont::getFontName' => 'Get the name of the font',
'harufont::getTextWidth' => 'Get the total width of the text, number of characters, number of words and number of spaces',
'harufont::getUnicodeWidth' => 'Get the width of the character in the font',
'harufont::getXHeight' => 'Get the distance from the baseline of lowercase letters',
'harufont::measureText' => 'Calculate the number of characters which can be included within the specified width',
'haruimage::getBitsPerComponent' => 'Get the number of bits used to describe each color component of the image',
'haruimage::getColorSpace' => 'Get the name of the color space',
'haruimage::getHeight' => 'Get the height of the image',
'haruimage::getSize' => 'Get size of the image',
'haruimage::getWidth' => 'Get the width of the image',
'haruimage::setColorMask' => 'Set the color mask of the image',
'haruimage::setMaskImage' => 'Set the image mask',
'haruoutline::setDestination' => 'Set the destination for the outline',
'haruoutline::setOpened' => 'Set the initial state of the outline',
'harupage::arc' => 'Append an arc to the current path',
'harupage::beginText' => 'Begin a text object and set the current text position to (0,0)',
'harupage::circle' => 'Append a circle to the current path',
'harupage::closePath' => 'Append a straight line from the current point to the start point of the path',
'harupage::concat' => 'Concatenate current transformation matrix of the page and the specified matrix',
'harupage::createDestination' => 'Create new HaruDestination instance',
'harupage::createLinkAnnotation' => 'Create new HaruAnnotation instance',
'harupage::createTextAnnotation' => 'Create new HaruAnnotation instance',
'harupage::createURLAnnotation' => 'Create and return new HaruAnnotation instance',
'harupage::curveTo' => 'Append a Bezier curve to the current path',
'harupage::curveTo2' => 'Append a Bezier curve to the current path',
'harupage::curveTo3' => 'Append a Bezier curve to the current path',
'harupage::drawImage' => 'Show image at the page',
'harupage::ellipse' => 'Append an ellipse to the current path',
'harupage::endPath' => 'End current path object without filling and painting operations',
'harupage::endText' => 'End current text object',
'harupage::eofill' => 'Fill current path using even-odd rule',
'harupage::eoFillStroke' => 'Fill current path using even-odd rule, then paint the path',
'harupage::fill' => 'Fill current path using nonzero winding number rule',
'harupage::fillStroke' => 'Fill current path using nonzero winding number rule, then paint the path',
'harupage::getCharSpace' => 'Get the current value of character spacing',
'harupage::getCMYKFill' => 'Get the current filling color',
'harupage::getCMYKStroke' => 'Get the current stroking color',
'harupage::getCurrentFont' => 'Get the currently used font',
'harupage::getCurrentFontSize' => 'Get the current font size',
'harupage::getCurrentPos' => 'Get the current position for path painting',
'harupage::getCurrentTextPos' => 'Get the current position for text printing',
'harupage::getDash' => 'Get the current dash pattern',
'harupage::getFillingColorSpace' => 'Get the current filling color space',
'harupage::getFlatness' => 'Get the flatness of the page',
'harupage::getGMode' => 'Get the current graphics mode',
'harupage::getGrayFill' => 'Get the current filling color',
'harupage::getGrayStroke' => 'Get the current stroking color',
'harupage::getHeight' => 'Get the height of the page',
'harupage::getHorizontalScaling' => 'Get the current value of horizontal scaling',
'harupage::getLineCap' => 'Get the current line cap style',
'harupage::getLineJoin' => 'Get the current line join style',
'harupage::getLineWidth' => 'Get the current line width',
'harupage::getMiterLimit' => 'Get the value of miter limit',
'harupage::getRGBFill' => 'Get the current filling color',
'harupage::getRGBStroke' => 'Get the current stroking color',
'harupage::getStrokingColorSpace' => 'Get the current stroking color space',
'harupage::getTextLeading' => 'Get the current value of line spacing',
'harupage::getTextMatrix' => 'Get the current text transformation matrix of the page',
'harupage::getTextRenderingMode' => 'Get the current text rendering mode',
'harupage::getTextRise' => 'Get the current value of text rising',
'harupage::getTextWidth' => 'Get the width of the text using current fontsize, character spacing and word spacing',
'harupage::getTransMatrix' => 'Get the current transformation matrix of the page',
'harupage::getWidth' => 'Get the width of the page',
'harupage::getWordSpace' => 'Get the current value of word spacing',
'harupage::lineTo' => 'Draw a line from the current point to the specified point',
'harupage::measureText' => 'Calculate the byte length of characters which can be included on one line of the specified width',
'harupage::moveTextPos' => 'Move text position to the specified offset',
'harupage::moveTo' => 'Set starting point for new drawing path',
'harupage::moveToNextLine' => 'Move text position to the start of the next line',
'harupage::rectangle' => 'Append a rectangle to the current path',
'harupage::setCharSpace' => 'Set character spacing for the page',
'harupage::setCMYKFill' => 'Set filling color for the page',
'harupage::setCMYKStroke' => 'Set stroking color for the page',
'harupage::setDash' => 'Set the dash pattern for the page',
'harupage::setFlatness' => 'Set flatness for the page',
'harupage::setFontAndSize' => 'Set font and fontsize for the page',
'harupage::setGrayFill' => 'Set filling color for the page',
'harupage::setGrayStroke' => 'Sets stroking color for the page',
'harupage::setHeight' => 'Set height of the page',
'harupage::setHorizontalScaling' => 'Set horizontal scaling for the page',
'harupage::setLineCap' => 'Set the shape to be used at the ends of lines',
'harupage::setLineJoin' => 'Set line join style for the page',
'harupage::setLineWidth' => 'Set line width for the page',
'harupage::setMiterLimit' => 'Set the current value of the miter limit of the page',
'harupage::setRGBFill' => 'Set filling color for the page',
'harupage::setRGBStroke' => 'Set stroking color for the page',
'harupage::setRotate' => 'Set rotation angle of the page',
'harupage::setSize' => 'Set size and direction of the page',
'harupage::setSlideShow' => 'Set transition style for the page',
'harupage::setTextLeading' => 'Set text leading (line spacing) for the page',
'harupage::setTextMatrix' => 'Set the current text transformation matrix of the page',
'harupage::setTextRenderingMode' => 'Set text rendering mode for the page',
'harupage::setTextRise' => 'Set the current value of text rising',
'harupage::setWidth' => 'Set width of the page',
'harupage::setWordSpace' => 'Set word spacing for the page',
'harupage::showText' => 'Print text at the current position of the page',
'harupage::showTextNextLine' => 'Move the current position to the start of the next line and print the text',
'harupage::stroke' => 'Paint current path',
'harupage::textOut' => 'Print the text on the specified position',
'harupage::textRect' => 'Print the text inside the specified region',
'hash' => 'Generate a hash value (message digest)',
'hash_algos' => 'Return a list of registered hashing algorithms',
'hash_copy' => 'Copy hashing context',
'hash_equals' => 'Timing attack safe string comparison',
'hash_file' => 'Generate a hash value using the contents of a given file',
'hash_final' => 'Finalize an incremental hash and return resulting digest',
'hash_hkdf' => 'Generate a HKDF key derivation of a supplied key input',
'hash_hmac' => 'Generate a keyed hash value using the HMAC method',
'hash_hmac_algos' => 'Return a list of registered hashing algorithms suitable for hash_hmac',
'hash_hmac_file' => 'Generate a keyed hash value using the HMAC method and the contents of a given file',
'hash_init' => 'Initialize an incremental hashing context',
'hash_pbkdf2' => 'Generate a PBKDF2 key derivation of a supplied password',
'hash_update' => 'Pump data into an active hashing context',
'hash_update_file' => 'Pump data into an active hashing context from a file',
'hash_update_stream' => 'Pump data into an active hashing context from an open stream',
'hashcontext::__construct' => 'Private constructor to disallow direct instantiation',
'hashTableObj::clear' => 'Clear all items in the hashTable (To NULL).',
'hashTableObj::get' => 'Fetch class metadata entry by name.  Returns "" if no entry
matches the name.  Note that the search is case sensitive.',
'hashTableObj::nextkey' => 'Return the next key or first key if previousKey = NULL.
Return NULL if no item is in the hashTable or end of hashTable is
reached',
'hashTableObj::remove' => 'Remove a metadata entry in the hashTable.  Returns MS_SUCCESS/MS_FAILURE.',
'hashTableObj::set' => 'Set a metadata entry in the hashTable. Returns MS_SUCCESS/MS_FAILURE.',
'header' => 'Send a raw HTTP header',
'header_register_callback' => 'Call a header function',
'header_remove' => 'Remove previously set headers',
'headers_list' => 'Returns a list of response headers sent (or ready to send)',
'headers_sent' => 'Checks if or where headers have been sent',
'hebrev' => 'Convert logical Hebrew text to visual text',
'hebrevc' => 'Convert logical Hebrew text to visual text with newline conversion',
'hex2bin' => 'Decodes a hexadecimally encoded binary string',
'hexdec' => 'Hexadecimal to decimal',
'highlight_file' => 'Syntax highlighting of a file',
'highlight_string' => 'Syntax highlighting of a string',
'hrtime' => 'Get the system\'s high resolution time',
'hrtime_performancecounter::getFrequency' => 'Timer frequency in ticks per second',
'hrtime_performancecounter::getTicks' => 'Current ticks from the system',
'hrtime_performancecounter::getTicksSince' => 'Ticks elapsed since the given value',
'hrtime_stopwatch::getElapsedTicks' => 'Get elapsed ticks for all intervals',
'hrtime_stopwatch::getElapsedTime' => 'Get elapsed time for all intervals',
'hrtime_stopwatch::getLastElapsedTicks' => 'Get elapsed ticks for the last interval',
'hrtime_stopwatch::getLastElapsedTime' => 'Get elapsed time for the last interval',
'hrtime_stopwatch::isRunning' => 'Whether the measurement is running',
'hrtime_stopwatch::start' => 'Start time measurement',
'hrtime_stopwatch::stop' => 'Stop time measurement',
'html_entity_decode' => 'Convert HTML entities to their corresponding characters',
'htmlentities' => 'Convert all applicable characters to HTML entities',
'htmlspecialchars' => 'Convert special characters to HTML entities',
'htmlspecialchars_decode' => 'Convert special HTML entities back to characters',
'http\Client::__construct' => 'Create a new HTTP client.',
'http\Client::addCookies' => 'Add custom cookies.
See http\Client::setCookies().',
'http\Client::addSslOptions' => 'Add specific SSL options.
See http\Client::setSslOptions(), http\Client::setOptions() and http\Client\Curl\$ssl options.',
'http\Client::attach' => 'Implements SplSubject. Attach another observer.
Attached observers will be notified with progress of each transfer.',
'http\Client::configure' => 'Configure the client\'s low level options.

> ***NOTE:***
> This method has been added in v2.3.0.',
'http\Client::count' => 'Implements Countable. Retrieve the number of enqueued requests.

> ***NOTE:***
> The enqueued requests are counted without regard whether they are finished or not.',
'http\Client::dequeue' => 'Dequeue the http\Client\Request $request.

See http\Client::requeue(), if you want to requeue the request, instead of calling http\Client::dequeue() and then http\Client::enqueue().',
'http\Client::detach' => 'Implements SplSubject. Detach $observer, which has been previously attached.',
'http\Client::enableEvents' => 'Enable usage of an event library like libevent, which might improve performance with big socket sets.

> ***NOTE:***
> This method has been deprecated in 2.3.0, please use http\Client::configure() instead.',
'http\Client::enablePipelining' => 'Enable sending pipelined requests to the same host if the driver supports it.

> ***NOTE:***
> This method has been deprecated in 2.3.0, please use http\Client::configure() instead.',
'http\Client::enqueue' => 'Add another http\Client\Request to the request queue.
If the optional callback $cb returns true, the request will be automatically dequeued.

> ***Note:***
> The http\Client\Response object resulting from the request is always stored
> internally to be retrieved at a later time, __even__ when $cb is used.
>
> If you are about to send a lot of requests and do __not__ need the response
> after executing the callback, you can use http\Client::getResponse() within
> the callback to keep the memory usage level as low as possible.

See http\Client::dequeue() and http\Client::send().',
'http\Client::getAvailableConfiguration' => 'Get a list of available configuration options and their default values.

See f.e. the [configuration options for the Curl driver](http/Client/Curl#Configuration:).',
'http\Client::getAvailableDrivers' => 'List available drivers.',
'http\Client::getAvailableOptions' => 'Retrieve a list of available request options and their default values.

See f.e. the [request options for the Curl driver](http/Client/Curl#Options:).',
'http\Client::getCookies' => 'Get priorly set custom cookies.
See http\Client::setCookies().',
'http\Client::getHistory' => 'Simply returns the http\Message chain representing the request/response history.

> ***NOTE:***
> The history is only recorded while http\Client::$recordHistory is true.',
'http\Client::getObservers' => 'Returns the SplObjectStorage holding attached observers.',
'http\Client::getOptions' => 'Get priorly set options.
See http\Client::setOptions().',
'http\Client::getProgressInfo' => 'Retrieve the progress information for $request.',
'http\Client::getResponse' => 'Retrieve the corresponding response of an already finished request, or the last received response if $request is not set.

> ***NOTE:***
> If $request is NULL, then the response is removed from the internal storage (stack-like operation).',
'http\Client::getSslOptions' => 'Retrieve priorly set SSL options.
See http\Client::getOptions() and http\Client::setSslOptions().',
'http\Client::getTransferInfo' => 'Get transfer related information for a running or finished request.',
'http\Client::notify' => 'Implements SplSubject. Notify attached observers about progress with $request.',
'http\Client::once' => 'Perform outstanding transfer actions.
See http\Client::wait() for the completing interface.',
'http\Client::requeue' => 'Requeue an http\Client\Request.

The difference simply is, that this method, in contrast to http\Client::enqueue(), does not throw an http\Exception when the request to queue is already enqueued and dequeues it automatically prior enqueueing it again.',
'http\Client::reset' => 'Reset the client to the initial state.',
'http\Client::send' => 'Send all enqueued requests.
See http\Client::once() and http\Client::wait() for a more fine grained interface.',
'http\Client::setCookies' => 'Set custom cookies.
See http\Client::addCookies() and http\Client::getCookies().',
'http\Client::setDebug' => 'Set client debugging callback.

> ***NOTE:***
> This method has been added in v2.6.0, resp. v3.1.0.',
'http\Client::setOptions' => 'Set client options.
See http\Client\Curl.

> ***NOTE:***
> Only options specified prior enqueueing a request are applied to the request.',
'http\Client::setSslOptions' => 'Specifically set SSL options.
See http\Client::setOptions() and http\Client\Curl\$ssl options.',
'http\Client::wait' => 'Wait for $timeout seconds for transfers to provide data.
This is the completion call to http\Client::once().',
'http\Client\Curl\User::init' => 'Initialize the event loop.',
'http\Client\Curl\User::once' => 'Run the loop as long as it does not block.

> ***NOTE:***
> This method is called by http\Client::once(), so it does not need to have an actual implementation if http\Client::once() is never called.',
'http\Client\Curl\User::send' => 'Run the loop.

> ***NOTE:***
> This method is called by http\Client::send(), so it does not need to have an actual implementation if http\Client::send() is never called.',
'http\Client\Curl\User::socket' => 'Register (or deregister) a socket watcher.',
'http\Client\Curl\User::timer' => 'Register a timeout watcher.',
'http\Client\Curl\User::wait' => 'Wait/poll/select (block the loop) until events fire.

> ***NOTE:***
> This method is called by http\Client::wait(), so it does not need to have an actual implementation if http\Client::wait() is never called.',
'http\Client\Request::__construct' => 'Create a new client request message to be enqueued and sent by http\Client.',
'http\Client\Request::__toString' => 'Retrieve the message serialized to a string.
Alias of http\Message::toString().',
'http\Client\Request::addBody' => 'Append the data of $body to the message\'s body.
See http\Message::setBody() and http\Message\Body::append().',
'http\Client\Request::addHeader' => 'Add an header, appending to already existing headers.
See http\Message::addHeaders() and http\Message::setHeader().',
'http\Client\Request::addHeaders' => 'Add headers, optionally appending values, if header keys already exist.
See http\Message::addHeader() and http\Message::setHeaders().',
'http\Client\Request::addQuery' => 'Add querystring data.
See http\Client\Request::setQuery() and http\Message::setRequestUrl().',
'http\Client\Request::addSslOptions' => 'Add specific SSL options.
See http\Client\Request::setSslOptions(), http\Client\Request::setOptions() and http\Client\Curl\$ssl options.',
'http\Client\Request::count' => 'Implements Countable.',
'http\Client\Request::current' => 'Implements iterator.
See http\Message::valid() and http\Message::rewind().',
'http\Client\Request::detach' => 'Detach a clone of this message from any message chain.',
'http\Client\Request::getBody' => 'Retrieve the message\'s body.
See http\Message::setBody().',
'http\Client\Request::getContentType' => 'Extract the currently set "Content-Type" header.
See http\Client\Request::setContentType().',
'http\Client\Request::getHeader' => 'Retrieve a single header, optionally hydrated into a http\Header extending class.',
'http\Client\Request::getHeaders' => 'Retrieve all message headers.
See http\Message::setHeaders() and http\Message::getHeader().',
'http\Client\Request::getHttpVersion' => 'Retrieve the HTTP protocol version of the message.
See http\Message::setHttpVersion().',
'http\Client\Request::getInfo' => 'Retrieve the first line of a request or response message.
See http\Message::setInfo and also:

* http\Message::getType()
* http\Message::getHttpVersion()
* http\Message::getResponseCode()
* http\Message::getResponseStatus()
* http\Message::getRequestMethod()
* http\Message::getRequestUrl()',
'http\Client\Request::getOptions' => 'Get priorly set options.
See http\Client\Request::setOptions().',
'http\Client\Request::getParentMessage' => 'Retrieve any parent message.
See http\Message::reverse().',
'http\Client\Request::getQuery' => 'Retrieve the currently set querystring.',
'http\Client\Request::getRequestMethod' => 'Retrieve the request method of the message.
See http\Message::setRequestMethod() and http\Message::getRequestUrl().',
'http\Client\Request::getRequestUrl' => 'Retrieve the request URL of the message.
See http\Message::setRequestUrl().',
'http\Client\Request::getResponseCode' => 'Retrieve the response code of the message.
See http\Message::setResponseCode() and http\Message::getResponseStatus().',
'http\Client\Request::getResponseStatus' => 'Retrieve the response status of the message.
See http\Message::setResponseStatus() and http\Message::getResponseCode().',
'http\Client\Request::getSslOptions' => 'Retrieve priorly set SSL options.
See http\Client\Request::getOptions() and http\Client\Request::setSslOptions().',
'http\Client\Request::getType' => 'Retrieve the type of the message.
See http\Message::setType() and http\Message::getInfo().',
'http\Client\Request::isMultipart' => 'Check whether this message is a multipart message based on it\'s content type.
If the message is a multipart message and a reference $boundary is given, the boundary string of the multipart message will be stored in $boundary.

See http\Message::splitMultipartBody().',
'http\Client\Request::key' => 'Implements Iterator.
See http\Message::current() and http\Message::rewind().',
'http\Client\Request::next' => 'Implements Iterator.
See http\Message::valid() and http\Message::rewind().',
'http\Client\Request::prepend' => 'Prepend message(s) $message to this message, or the top most message of this message chain.

> ***NOTE:***
> The message chains must not overlap.',
'http\Client\Request::reverse' => 'Reverse the message chain and return the former top-most message.

> ***NOTE:***
> Message chains are ordered in reverse-parsed order by default, i.e. the last parsed message is the message you\'ll receive from any call parsing HTTP messages.
>
> This call re-orders the messages of the chain and returns the message that was parsed first with any later parsed messages re-parentized.',
'http\Client\Request::rewind' => 'Implements Iterator.',
'http\Client\Request::serialize' => 'Implements Serializable.',
'http\Client\Request::setBody' => 'Set the message\'s body.
See http\Message::getBody() and http\Message::addBody().',
'http\Client\Request::setContentType' => 'Set the MIME content type of the request message.',
'http\Client\Request::setHeader' => 'Set a single header.
See http\Message::getHeader() and http\Message::addHeader().

> ***NOTE:***
> Prior to v2.5.6/v3.1.0 headers with the same name were merged into a single
> header with values concatenated by comma.',
'http\Client\Request::setHeaders' => 'Set the message headers.
See http\Message::getHeaders() and http\Message::addHeaders().

> ***NOTE:***
> Prior to v2.5.6/v3.1.0 headers with the same name were merged into a single
> header with values concatenated by comma.',
'http\Client\Request::setHttpVersion' => 'Set the HTTP protocol version of the message.
See http\Message::getHttpVersion().',
'http\Client\Request::setInfo' => 'Set the complete message info, i.e. type and response resp. request information, at once.
See http\Message::getInfo().',
'http\Client\Request::setOptions' => 'Set client options.
See http\Client::setOptions() and http\Client\Curl.

Request specific options override general options which were set in the client.

> ***NOTE:***
> Only options specified prior enqueueing a request are applied to the request.',
'http\Client\Request::setQuery' => '(Re)set the querystring.
See http\Client\Request::addQuery() and http\Message::setRequestUrl().',
'http\Client\Request::setRequestMethod' => 'Set the request method of the message.
See http\Message::getRequestMethod() and http\Message::setRequestUrl().',
'http\Client\Request::setRequestUrl' => 'Set the request URL of the message.
See http\Message::getRequestUrl() and http\Message::setRequestMethod().',
'http\Client\Request::setResponseCode' => 'Set the response status code.
See http\Message::getResponseCode() and http\Message::setResponseStatus().

> ***NOTE:***
> This method also resets the response status phrase to the default for that code.',
'http\Client\Request::setResponseStatus' => 'Set the response status phrase.
See http\Message::getResponseStatus() and http\Message::setResponseCode().',
'http\Client\Request::setSslOptions' => 'Specifically set SSL options.
See http\Client\Request::setOptions() and http\Client\Curl\$ssl options.',
'http\Client\Request::setType' => 'Set the message type and reset the message info.
See http\Message::getType() and http\Message::setInfo().',
'http\Client\Request::splitMultipartBody' => 'Splits the body of a multipart message.
See http\Message::isMultipart() and http\Message\Body::addPart().',
'http\Client\Request::toCallback' => 'Stream the message through a callback.',
'http\Client\Request::toStream' => 'Stream the message into stream $stream, starting from $offset, streaming $maxlen at most.',
'http\Client\Request::toString' => 'Retrieve the message serialized to a string.',
'http\Client\Request::unserialize' => 'Implements Serializable.',
'http\Client\Request::valid' => 'Implements Iterator.
See http\Message::current() and http\Message::rewind().',
'http\Client\Response::__construct' => 'Create a new HTTP message.',
'http\Client\Response::__toString' => 'Retrieve the message serialized to a string.
Alias of http\Message::toString().',
'http\Client\Response::addBody' => 'Append the data of $body to the message\'s body.
See http\Message::setBody() and http\Message\Body::append().',
'http\Client\Response::addHeader' => 'Add an header, appending to already existing headers.
See http\Message::addHeaders() and http\Message::setHeader().',
'http\Client\Response::addHeaders' => 'Add headers, optionally appending values, if header keys already exist.
See http\Message::addHeader() and http\Message::setHeaders().',
'http\Client\Response::count' => 'Implements Countable.',
'http\Client\Response::current' => 'Implements iterator.
See http\Message::valid() and http\Message::rewind().',
'http\Client\Response::detach' => 'Detach a clone of this message from any message chain.',
'http\Client\Response::getBody' => 'Retrieve the message\'s body.
See http\Message::setBody().',
'http\Client\Response::getCookies' => 'Extract response cookies.
Parses any "Set-Cookie" response headers into an http\Cookie list. See http\Cookie::__construct().',
'http\Client\Response::getHeader' => 'Retrieve a single header, optionally hydrated into a http\Header extending class.',
'http\Client\Response::getHeaders' => 'Retrieve all message headers.
See http\Message::setHeaders() and http\Message::getHeader().',
'http\Client\Response::getHttpVersion' => 'Retrieve the HTTP protocol version of the message.
See http\Message::setHttpVersion().',
'http\Client\Response::getInfo' => 'Retrieve the first line of a request or response message.
See http\Message::setInfo and also:

* http\Message::getType()
* http\Message::getHttpVersion()
* http\Message::getResponseCode()
* http\Message::getResponseStatus()
* http\Message::getRequestMethod()
* http\Message::getRequestUrl()',
'http\Client\Response::getParentMessage' => 'Retrieve any parent message.
See http\Message::reverse().',
'http\Client\Response::getRequestMethod' => 'Retrieve the request method of the message.
See http\Message::setRequestMethod() and http\Message::getRequestUrl().',
'http\Client\Response::getRequestUrl' => 'Retrieve the request URL of the message.
See http\Message::setRequestUrl().',
'http\Client\Response::getResponseCode' => 'Retrieve the response code of the message.
See http\Message::setResponseCode() and http\Message::getResponseStatus().',
'http\Client\Response::getResponseStatus' => 'Retrieve the response status of the message.
See http\Message::setResponseStatus() and http\Message::getResponseCode().',
'http\Client\Response::getTransferInfo' => 'Retrieve transfer related information after the request has completed.
See http\Client::getTransferInfo().',
'http\Client\Response::getType' => 'Retrieve the type of the message.
See http\Message::setType() and http\Message::getInfo().',
'http\Client\Response::isMultipart' => 'Check whether this message is a multipart message based on it\'s content type.
If the message is a multipart message and a reference $boundary is given, the boundary string of the multipart message will be stored in $boundary.

See http\Message::splitMultipartBody().',
'http\Client\Response::key' => 'Implements Iterator.
See http\Message::current() and http\Message::rewind().',
'http\Client\Response::next' => 'Implements Iterator.
See http\Message::valid() and http\Message::rewind().',
'http\Client\Response::prepend' => 'Prepend message(s) $message to this message, or the top most message of this message chain.

> ***NOTE:***
> The message chains must not overlap.',
'http\Client\Response::reverse' => 'Reverse the message chain and return the former top-most message.

> ***NOTE:***
> Message chains are ordered in reverse-parsed order by default, i.e. the last parsed message is the message you\'ll receive from any call parsing HTTP messages.
>
> This call re-orders the messages of the chain and returns the message that was parsed first with any later parsed messages re-parentized.',
'http\Client\Response::rewind' => 'Implements Iterator.',
'http\Client\Response::serialize' => 'Implements Serializable.',
'http\Client\Response::setBody' => 'Set the message\'s body.
See http\Message::getBody() and http\Message::addBody().',
'http\Client\Response::setHeader' => 'Set a single header.
See http\Message::getHeader() and http\Message::addHeader().

> ***NOTE:***
> Prior to v2.5.6/v3.1.0 headers with the same name were merged into a single
> header with values concatenated by comma.',
'http\Client\Response::setHeaders' => 'Set the message headers.
See http\Message::getHeaders() and http\Message::addHeaders().

> ***NOTE:***
> Prior to v2.5.6/v3.1.0 headers with the same name were merged into a single
> header with values concatenated by comma.',
'http\Client\Response::setHttpVersion' => 'Set the HTTP protocol version of the message.
See http\Message::getHttpVersion().',
'http\Client\Response::setInfo' => 'Set the complete message info, i.e. type and response resp. request information, at once.
See http\Message::getInfo().',
'http\Client\Response::setRequestMethod' => 'Set the request method of the message.
See http\Message::getRequestMethod() and http\Message::setRequestUrl().',
'http\Client\Response::setRequestUrl' => 'Set the request URL of the message.
See http\Message::getRequestUrl() and http\Message::setRequestMethod().',
'http\Client\Response::setResponseCode' => 'Set the response status code.
See http\Message::getResponseCode() and http\Message::setResponseStatus().

> ***NOTE:***
> This method also resets the response status phrase to the default for that code.',
'http\Client\Response::setResponseStatus' => 'Set the response status phrase.
See http\Message::getResponseStatus() and http\Message::setResponseCode().',
'http\Client\Response::setType' => 'Set the message type and reset the message info.
See http\Message::getType() and http\Message::setInfo().',
'http\Client\Response::splitMultipartBody' => 'Splits the body of a multipart message.
See http\Message::isMultipart() and http\Message\Body::addPart().',
'http\Client\Response::toCallback' => 'Stream the message through a callback.',
'http\Client\Response::toStream' => 'Stream the message into stream $stream, starting from $offset, streaming $maxlen at most.',
'http\Client\Response::toString' => 'Retrieve the message serialized to a string.',
'http\Client\Response::unserialize' => 'Implements Serializable.',
'http\Client\Response::valid' => 'Implements Iterator.
See http\Message::current() and http\Message::rewind().',
'http\Cookie::__construct' => 'Create a new cookie list.',
'http\Cookie::__toString' => 'String cast handler. Alias of http\Cookie::toString().',
'http\Cookie::addCookie' => 'Add a cookie.
See http\Cookie::setCookie() and http\Cookie::addCookies().',
'http\Cookie::addCookies' => '(Re)set the cookies.
See http\Cookie::setCookies().',
'http\Cookie::addExtra' => 'Add an extra attribute to the cookie list.
See http\Cookie::setExtra().',
'http\Cookie::addExtras' => 'Add several extra attributes.
See http\Cookie::addExtra().',
'http\Cookie::getCookie' => 'Retrieve a specific cookie value.
See http\Cookie::setCookie().',
'http\Cookie::getCookies' => 'Get the list of cookies.
See http\Cookie::setCookies().',
'http\Cookie::getDomain' => 'Retrieve the effective domain of the cookie list.
See http\Cookie::setDomain().',
'http\Cookie::getExpires' => 'Get the currently set expires attribute.
See http\Cookie::setExpires().

> ***NOTE:***
> A return value of -1 means that the attribute is not set.',
'http\Cookie::getExtra' => 'Retrieve an extra attribute.
See http\Cookie::setExtra().',
'http\Cookie::getExtras' => 'Retrieve the list of extra attributes.
See http\Cookie::setExtras().',
'http\Cookie::getFlags' => 'Get the currently set flags.
See http\Cookie::SECURE and http\Cookie::HTTPONLY constants.',
'http\Cookie::getMaxAge' => 'Get the currently set max-age attribute of the cookie list.
See http\Cookie::setMaxAge().

> ***NOTE:***
> A return value of -1 means that the attribute is not set.',
'http\Cookie::getPath' => 'Retrieve the path the cookie(s) of this cookie list are effective at.
See http\Cookie::setPath().',
'http\Cookie::setCookie' => '(Re)set a cookie.
See http\Cookie::addCookie() and http\Cookie::setCookies().

> ***NOTE:***
> The cookie will be deleted from the list if $cookie_value is NULL.',
'http\Cookie::setCookies' => '(Re)set the cookies.
See http\Cookie::addCookies().',
'http\Cookie::setDomain' => 'Set the effective domain of the cookie list.
See http\Cookie::setPath().',
'http\Cookie::setExpires' => 'Set the traditional expires timestamp.
See http\Cookie::setMaxAge() for a safer alternative.',
'http\Cookie::setExtra' => '(Re)set an extra attribute.
See http\Cookie::addExtra().

> ***NOTE:***
> The attribute will be removed from the extras list if $extra_value is NULL.',
'http\Cookie::setExtras' => '(Re)set the extra attributes.
See http\Cookie::addExtras().',
'http\Cookie::setFlags' => 'Set the flags to specified $value.
See http\Cookie::SECURE and http\Cookie::HTTPONLY constants.',
'http\Cookie::setMaxAge' => 'Set the maximum age the cookie may have on the client side.
This is a client clock departure safe alternative to the "expires" attribute.
See http\Cookie::setExpires().',
'http\Cookie::setPath' => 'Set the path the cookie(s) of this cookie list should be effective at.
See http\Cookie::setDomain().',
'http\Cookie::toArray' => 'Get the cookie list as array.',
'http\Cookie::toString' => 'Retrieve the string representation of the cookie list.
See http\Cookie::toArray().',
'http\Encoding\Stream::__construct' => 'Base constructor for encoding stream implementations.',
'http\Encoding\Stream::done' => 'Check whether the encoding stream is already done.',
'http\Encoding\Stream::finish' => 'Finish and reset the encoding stream.
Returns any pending data.',
'http\Encoding\Stream::flush' => 'Flush the encoding stream.
Returns any pending data.',
'http\Encoding\Stream::update' => 'Update the encoding stream with more input.',
'http\Encoding\Stream\Debrotli::__construct' => 'Base constructor for encoding stream implementations.',
'http\Encoding\Stream\Debrotli::decode' => 'Decode brotli encoded data.',
'http\Encoding\Stream\Debrotli::done' => 'Check whether the encoding stream is already done.',
'http\Encoding\Stream\Debrotli::finish' => 'Finish and reset the encoding stream.
Returns any pending data.',
'http\Encoding\Stream\Debrotli::flush' => 'Flush the encoding stream.
Returns any pending data.',
'http\Encoding\Stream\Debrotli::update' => 'Update the encoding stream with more input.',
'http\Encoding\Stream\Dechunk::__construct' => 'Base constructor for encoding stream implementations.',
'http\Encoding\Stream\Dechunk::decode' => 'Decode chunked encoded data.',
'http\Encoding\Stream\Dechunk::done' => 'Check whether the encoding stream is already done.',
'http\Encoding\Stream\Dechunk::finish' => 'Finish and reset the encoding stream.
Returns any pending data.',
'http\Encoding\Stream\Dechunk::flush' => 'Flush the encoding stream.
Returns any pending data.',
'http\Encoding\Stream\Dechunk::update' => 'Update the encoding stream with more input.',
'http\Encoding\Stream\Deflate::__construct' => 'Base constructor for encoding stream implementations.',
'http\Encoding\Stream\Deflate::done' => 'Check whether the encoding stream is already done.',
'http\Encoding\Stream\Deflate::encode' => 'Encode data with deflate/zlib/gzip encoding.',
'http\Encoding\Stream\Deflate::finish' => 'Finish and reset the encoding stream.
Returns any pending data.',
'http\Encoding\Stream\Deflate::flush' => 'Flush the encoding stream.
Returns any pending data.',
'http\Encoding\Stream\Deflate::update' => 'Update the encoding stream with more input.',
'http\Encoding\Stream\Enbrotli::__construct' => 'Base constructor for encoding stream implementations.',
'http\Encoding\Stream\Enbrotli::done' => 'Check whether the encoding stream is already done.',
'http\Encoding\Stream\Enbrotli::encode' => 'Encode data with brotli encoding.',
'http\Encoding\Stream\Enbrotli::finish' => 'Finish and reset the encoding stream.
Returns any pending data.',
'http\Encoding\Stream\Enbrotli::flush' => 'Flush the encoding stream.
Returns any pending data.',
'http\Encoding\Stream\Enbrotli::update' => 'Update the encoding stream with more input.',
'http\Encoding\Stream\Inflate::__construct' => 'Base constructor for encoding stream implementations.',
'http\Encoding\Stream\Inflate::decode' => 'Decode deflate/zlib/gzip encoded data.',
'http\Encoding\Stream\Inflate::done' => 'Check whether the encoding stream is already done.',
'http\Encoding\Stream\Inflate::finish' => 'Finish and reset the encoding stream.
Returns any pending data.',
'http\Encoding\Stream\Inflate::flush' => 'Flush the encoding stream.
Returns any pending data.',
'http\Encoding\Stream\Inflate::update' => 'Update the encoding stream with more input.',
'http\Env::getRequestBody' => 'Retrieve the current HTTP request\'s body.',
'http\Env::getRequestHeader' => 'Retrieve one or all headers of the current HTTP request.',
'http\Env::getResponseCode' => 'Get the HTTP response code to send.',
'http\Env::getResponseHeader' => 'Get one or all HTTP response headers to be sent.',
'http\Env::getResponseStatusForAllCodes' => 'Retrieve a list of all known HTTP response status.',
'http\Env::getResponseStatusForCode' => 'Retrieve the string representation of specified HTTP response code.',
'http\Env::negotiate' => 'Generic negotiator. For specific client negotiation see http\Env::negotiateContentType() and related methods.

> ***NOTE:***
> The first element of $supported serves as a default if no operand matches.',
'http\Env::negotiateCharset' => 'Negotiate the client\'s preferred character set.

> ***NOTE:***
> The first element of $supported character sets serves as a default if no character set matches.',
'http\Env::negotiateContentType' => 'Negotiate the client\'s preferred MIME content type.

> ***NOTE:***
> The first element of $supported content types serves as a default if no content-type matches.',
'http\Env::negotiateEncoding' => 'Negotiate the client\'s preferred encoding.

> ***NOTE:***
> The first element of $supported encodings serves as a default if no encoding matches.',
'http\Env::negotiateLanguage' => 'Negotiate the client\'s preferred language.

> ***NOTE:***
> The first element of $supported languages serves as a default if no language matches.',
'http\Env::setResponseCode' => 'Set the HTTP response code to send.',
'http\Env::setResponseHeader' => 'Set a response header, either replacing a prior set header, or appending the new header value, depending on $replace.

If no $header_value is specified, or $header_value is NULL, then a previously set header with the same key will be deleted from the list.

If $response_code is not 0, the response status code is updated accordingly.',
'http\Env\Request::__construct' => 'Create an instance of the server\'s current HTTP request.

Upon construction, the http\Env\Request acquires http\QueryString instances of query parameters ($\_GET) and form parameters ($\_POST).

It also compiles an array of uploaded files ($\_FILES) more comprehensive than the original $\_FILES array, see http\Env\Request::getFiles() for that matter.',
'http\Env\Request::__toString' => 'Retrieve the message serialized to a string.
Alias of http\Message::toString().',
'http\Env\Request::addBody' => 'Append the data of $body to the message\'s body.
See http\Message::setBody() and http\Message\Body::append().',
'http\Env\Request::addHeader' => 'Add an header, appending to already existing headers.
See http\Message::addHeaders() and http\Message::setHeader().',
'http\Env\Request::addHeaders' => 'Add headers, optionally appending values, if header keys already exist.
See http\Message::addHeader() and http\Message::setHeaders().',
'http\Env\Request::count' => 'Implements Countable.',
'http\Env\Request::current' => 'Implements iterator.
See http\Message::valid() and http\Message::rewind().',
'http\Env\Request::detach' => 'Detach a clone of this message from any message chain.',
'http\Env\Request::getBody' => 'Retrieve the message\'s body.
See http\Message::setBody().',
'http\Env\Request::getCookie' => 'Retrieve an URL query value ($_GET)',
'http\Env\Request::getFiles' => 'Retrieve the uploaded files list ($_FILES)',
'http\Env\Request::getForm' => 'Retrieve a form value ($_POST)',
'http\Env\Request::getHeader' => 'Retrieve a single header, optionally hydrated into a http\Header extending class.',
'http\Env\Request::getHeaders' => 'Retrieve all message headers.
See http\Message::setHeaders() and http\Message::getHeader().',
'http\Env\Request::getHttpVersion' => 'Retrieve the HTTP protocol version of the message.
See http\Message::setHttpVersion().',
'http\Env\Request::getInfo' => 'Retrieve the first line of a request or response message.
See http\Message::setInfo and also:

* http\Message::getType()
* http\Message::getHttpVersion()
* http\Message::getResponseCode()
* http\Message::getResponseStatus()
* http\Message::getRequestMethod()
* http\Message::getRequestUrl()',
'http\Env\Request::getParentMessage' => 'Retrieve any parent message.
See http\Message::reverse().',
'http\Env\Request::getQuery' => 'Retrieve an URL query value ($_GET)',
'http\Env\Request::getRequestMethod' => 'Retrieve the request method of the message.
See http\Message::setRequestMethod() and http\Message::getRequestUrl().',
'http\Env\Request::getRequestUrl' => 'Retrieve the request URL of the message.
See http\Message::setRequestUrl().',
'http\Env\Request::getResponseCode' => 'Retrieve the response code of the message.
See http\Message::setResponseCode() and http\Message::getResponseStatus().',
'http\Env\Request::getResponseStatus' => 'Retrieve the response status of the message.
See http\Message::setResponseStatus() and http\Message::getResponseCode().',
'http\Env\Request::getType' => 'Retrieve the type of the message.
See http\Message::setType() and http\Message::getInfo().',
'http\Env\Request::isMultipart' => 'Check whether this message is a multipart message based on it\'s content type.
If the message is a multipart message and a reference $boundary is given, the boundary string of the multipart message will be stored in $boundary.

See http\Message::splitMultipartBody().',
'http\Env\Request::key' => 'Implements Iterator.
See http\Message::current() and http\Message::rewind().',
'http\Env\Request::next' => 'Implements Iterator.
See http\Message::valid() and http\Message::rewind().',
'http\Env\Request::prepend' => 'Prepend message(s) $message to this message, or the top most message of this message chain.

> ***NOTE:***
> The message chains must not overlap.',
'http\Env\Request::reverse' => 'Reverse the message chain and return the former top-most message.

> ***NOTE:***
> Message chains are ordered in reverse-parsed order by default, i.e. the last parsed message is the message you\'ll receive from any call parsing HTTP messages.
>
> This call re-orders the messages of the chain and returns the message that was parsed first with any later parsed messages re-parentized.',
'http\Env\Request::rewind' => 'Implements Iterator.',
'http\Env\Request::serialize' => 'Implements Serializable.',
'http\Env\Request::setBody' => 'Set the message\'s body.
See http\Message::getBody() and http\Message::addBody().',
'http\Env\Request::setHeader' => 'Set a single header.
See http\Message::getHeader() and http\Message::addHeader().

> ***NOTE:***
> Prior to v2.5.6/v3.1.0 headers with the same name were merged into a single
> header with values concatenated by comma.',
'http\Env\Request::setHeaders' => 'Set the message headers.
See http\Message::getHeaders() and http\Message::addHeaders().

> ***NOTE:***
> Prior to v2.5.6/v3.1.0 headers with the same name were merged into a single
> header with values concatenated by comma.',
'http\Env\Request::setHttpVersion' => 'Set the HTTP protocol version of the message.
See http\Message::getHttpVersion().',
'http\Env\Request::setInfo' => 'Set the complete message info, i.e. type and response resp. request information, at once.
See http\Message::getInfo().',
'http\Env\Request::setRequestMethod' => 'Set the request method of the message.
See http\Message::getRequestMethod() and http\Message::setRequestUrl().',
'http\Env\Request::setRequestUrl' => 'Set the request URL of the message.
See http\Message::getRequestUrl() and http\Message::setRequestMethod().',
'http\Env\Request::setResponseCode' => 'Set the response status code.
See http\Message::getResponseCode() and http\Message::setResponseStatus().

> ***NOTE:***
> This method also resets the response status phrase to the default for that code.',
'http\Env\Request::setResponseStatus' => 'Set the response status phrase.
See http\Message::getResponseStatus() and http\Message::setResponseCode().',
'http\Env\Request::setType' => 'Set the message type and reset the message info.
See http\Message::getType() and http\Message::setInfo().',
'http\Env\Request::splitMultipartBody' => 'Splits the body of a multipart message.
See http\Message::isMultipart() and http\Message\Body::addPart().',
'http\Env\Request::toCallback' => 'Stream the message through a callback.',
'http\Env\Request::toStream' => 'Stream the message into stream $stream, starting from $offset, streaming $maxlen at most.',
'http\Env\Request::toString' => 'Retrieve the message serialized to a string.',
'http\Env\Request::unserialize' => 'Implements Serializable.',
'http\Env\Request::valid' => 'Implements Iterator.
See http\Message::current() and http\Message::rewind().',
'http\Env\Response::__construct' => 'Create a new env response message instance.',
'http\Env\Response::__invoke' => 'Output buffer handler',
'http\Env\Response::__toString' => 'Retrieve the message serialized to a string.
Alias of http\Message::toString().',
'http\Env\Response::addBody' => 'Append the data of $body to the message\'s body.
See http\Message::setBody() and http\Message\Body::append().',
'http\Env\Response::addHeader' => 'Add an header, appending to already existing headers.
See http\Message::addHeaders() and http\Message::setHeader().',
'http\Env\Response::addHeaders' => 'Add headers, optionally appending values, if header keys already exist.
See http\Message::addHeader() and http\Message::setHeaders().',
'http\Env\Response::count' => 'Implements Countable.',
'http\Env\Response::current' => 'Implements iterator.
See http\Message::valid() and http\Message::rewind().',
'http\Env\Response::detach' => 'Detach a clone of this message from any message chain.',
'http\Env\Response::getBody' => 'Retrieve the message\'s body.
See http\Message::setBody().',
'http\Env\Response::getHeader' => 'Retrieve a single header, optionally hydrated into a http\Header extending class.',
'http\Env\Response::getHeaders' => 'Retrieve all message headers.
See http\Message::setHeaders() and http\Message::getHeader().',
'http\Env\Response::getHttpVersion' => 'Retrieve the HTTP protocol version of the message.
See http\Message::setHttpVersion().',
'http\Env\Response::getInfo' => 'Retrieve the first line of a request or response message.
See http\Message::setInfo and also:

* http\Message::getType()
* http\Message::getHttpVersion()
* http\Message::getResponseCode()
* http\Message::getResponseStatus()
* http\Message::getRequestMethod()
* http\Message::getRequestUrl()',
'http\Env\Response::getParentMessage' => 'Retrieve any parent message.
See http\Message::reverse().',
'http\Env\Response::getRequestMethod' => 'Retrieve the request method of the message.
See http\Message::setRequestMethod() and http\Message::getRequestUrl().',
'http\Env\Response::getRequestUrl' => 'Retrieve the request URL of the message.
See http\Message::setRequestUrl().',
'http\Env\Response::getResponseCode' => 'Retrieve the response code of the message.
See http\Message::setResponseCode() and http\Message::getResponseStatus().',
'http\Env\Response::getResponseStatus' => 'Retrieve the response status of the message.
See http\Message::setResponseStatus() and http\Message::getResponseCode().',
'http\Env\Response::getType' => 'Retrieve the type of the message.
See http\Message::setType() and http\Message::getInfo().',
'http\Env\Response::isCachedByEtag' => 'Manually test the header $header_name of the environment\'s request for a cache hit.
http\Env\Response::send() checks that itself, though.',
'http\Env\Response::isCachedByLastModified' => 'Manually test the header $header_name of the environment\'s request for a cache hit.
http\Env\Response::send() checks that itself, though.',
'http\Env\Response::isMultipart' => 'Check whether this message is a multipart message based on it\'s content type.
If the message is a multipart message and a reference $boundary is given, the boundary string of the multipart message will be stored in $boundary.

See http\Message::splitMultipartBody().',
'http\Env\Response::key' => 'Implements Iterator.
See http\Message::current() and http\Message::rewind().',
'http\Env\Response::next' => 'Implements Iterator.
See http\Message::valid() and http\Message::rewind().',
'http\Env\Response::prepend' => 'Prepend message(s) $message to this message, or the top most message of this message chain.

> ***NOTE:***
> The message chains must not overlap.',
'http\Env\Response::reverse' => 'Reverse the message chain and return the former top-most message.

> ***NOTE:***
> Message chains are ordered in reverse-parsed order by default, i.e. the last parsed message is the message you\'ll receive from any call parsing HTTP messages.
>
> This call re-orders the messages of the chain and returns the message that was parsed first with any later parsed messages re-parentized.',
'http\Env\Response::rewind' => 'Implements Iterator.',
'http\Env\Response::send' => 'Send the response through the SAPI or $stream',
'http\Env\Response::serialize' => 'Implements Serializable.',
'http\Env\Response::setBody' => 'Set the message\'s body.
See http\Message::getBody() and http\Message::addBody().',
'http\Env\Response::setCacheControl' => 'Make suggestions to the client how it should cache the response',
'http\Env\Response::setContentDisposition' => 'Set the response’s content disposition parameters',
'http\Env\Response::setContentEncoding' => 'Enable support for “Accept-Encoding” requests with deflate or gzip',
'http\Env\Response::setContentType' => 'Set the MIME content type of the response',
'http\Env\Response::setCookie' => 'Add cookies to the response to send',
'http\Env\Response::setEnvRequest' => 'Override the environment’s request',
'http\Env\Response::setEtag' => 'Override the environment’s request',
'http\Env\Response::setHeader' => 'Set a single header.
See http\Message::getHeader() and http\Message::addHeader().

> ***NOTE:***
> Prior to v2.5.6/v3.1.0 headers with the same name were merged into a single
> header with values concatenated by comma.',
'http\Env\Response::setHeaders' => 'Set the message headers.
See http\Message::getHeaders() and http\Message::addHeaders().

> ***NOTE:***
> Prior to v2.5.6/v3.1.0 headers with the same name were merged into a single
> header with values concatenated by comma.',
'http\Env\Response::setHttpVersion' => 'Set the HTTP protocol version of the message.
See http\Message::getHttpVersion().',
'http\Env\Response::setInfo' => 'Set the complete message info, i.e. type and response resp. request information, at once.
See http\Message::getInfo().',
'http\Env\Response::setLastModified' => 'Override the environment’s request',
'http\Env\Response::setRequestMethod' => 'Set the request method of the message.
See http\Message::getRequestMethod() and http\Message::setRequestUrl().',
'http\Env\Response::setRequestUrl' => 'Set the request URL of the message.
See http\Message::getRequestUrl() and http\Message::setRequestMethod().',
'http\Env\Response::setResponseCode' => 'Set the response status code.
See http\Message::getResponseCode() and http\Message::setResponseStatus().

> ***NOTE:***
> This method also resets the response status phrase to the default for that code.',
'http\Env\Response::setResponseStatus' => 'Set the response status phrase.
See http\Message::getResponseStatus() and http\Message::setResponseCode().',
'http\Env\Response::setThrottleRate' => 'Override the environment’s request',
'http\Env\Response::setType' => 'Set the message type and reset the message info.
See http\Message::getType() and http\Message::setInfo().',
'http\Env\Response::splitMultipartBody' => 'Splits the body of a multipart message.
See http\Message::isMultipart() and http\Message\Body::addPart().',
'http\Env\Response::toCallback' => 'Stream the message through a callback.',
'http\Env\Response::toStream' => 'Stream the message into stream $stream, starting from $offset, streaming $maxlen at most.',
'http\Env\Response::toString' => 'Retrieve the message serialized to a string.',
'http\Env\Response::unserialize' => 'Implements Serializable.',
'http\Env\Response::valid' => 'Implements Iterator.
See http\Message::current() and http\Message::rewind().',
'http\Header::__construct' => 'Create an http\Header instance for use of simple matching or negotiation. If the value of the header is an array it may be compounded to a single comma separated string.',
'http\Header::__toString' => 'String cast handler. Alias of http\Header::serialize().',
'http\Header::getParams' => 'Create a parameter list out of the HTTP header value.',
'http\Header::match' => 'Match the HTTP header\'s value against provided $value according to $flags.',
'http\Header::negotiate' => 'Negotiate the header\'s value against a list of supported values in $supported.
Negotiation operation is adopted according to the header name, i.e. if the
header being negotiated is Accept, then a slash is used as primary type
separator, and if the header is Accept-Language respectively, a hyphen is
used instead.

> ***NOTE:***
> The first element of $supported serves as a default if no operand matches.',
'http\Header::parse' => 'Parse HTTP headers.
See also http\Header\Parser.',
'http\Header::serialize' => 'Implements Serializable.',
'http\Header::toString' => 'Convenience method. Alias of http\Header::serialize().',
'http\Header::unserialize' => 'Implements Serializable.',
'http\Header\Parser::getState' => 'Retrieve the current state of the parser.
See http\Header\Parser::STATE_* constants.',
'http\Header\Parser::parse' => 'Parse a string.',
'http\Header\Parser::stream' => 'Parse a stream.',
'http\Message::__construct' => 'Create a new HTTP message.',
'http\Message::__toString' => 'Retrieve the message serialized to a string.
Alias of http\Message::toString().',
'http\Message::addBody' => 'Append the data of $body to the message\'s body.
See http\Message::setBody() and http\Message\Body::append().',
'http\Message::addHeader' => 'Add an header, appending to already existing headers.
See http\Message::addHeaders() and http\Message::setHeader().',
'http\Message::addHeaders' => 'Add headers, optionally appending values, if header keys already exist.
See http\Message::addHeader() and http\Message::setHeaders().',
'http\Message::count' => 'Implements Countable.',
'http\Message::current' => 'Implements iterator.
See http\Message::valid() and http\Message::rewind().',
'http\Message::detach' => 'Detach a clone of this message from any message chain.',
'http\Message::getBody' => 'Retrieve the message\'s body.
See http\Message::setBody().',
'http\Message::getHeader' => 'Retrieve a single header, optionally hydrated into a http\Header extending class.',
'http\Message::getHeaders' => 'Retrieve all message headers.
See http\Message::setHeaders() and http\Message::getHeader().',
'http\Message::getHttpVersion' => 'Retrieve the HTTP protocol version of the message.
See http\Message::setHttpVersion().',
'http\Message::getInfo' => 'Retrieve the first line of a request or response message.
See http\Message::setInfo and also:

* http\Message::getType()
* http\Message::getHttpVersion()
* http\Message::getResponseCode()
* http\Message::getResponseStatus()
* http\Message::getRequestMethod()
* http\Message::getRequestUrl()',
'http\Message::getParentMessage' => 'Retrieve any parent message.
See http\Message::reverse().',
'http\Message::getRequestMethod' => 'Retrieve the request method of the message.
See http\Message::setRequestMethod() and http\Message::getRequestUrl().',
'http\Message::getRequestUrl' => 'Retrieve the request URL of the message.
See http\Message::setRequestUrl().',
'http\Message::getResponseCode' => 'Retrieve the response code of the message.
See http\Message::setResponseCode() and http\Message::getResponseStatus().',
'http\Message::getResponseStatus' => 'Retrieve the response status of the message.
See http\Message::setResponseStatus() and http\Message::getResponseCode().',
'http\Message::getType' => 'Retrieve the type of the message.
See http\Message::setType() and http\Message::getInfo().',
'http\Message::isMultipart' => 'Check whether this message is a multipart message based on it\'s content type.
If the message is a multipart message and a reference $boundary is given, the boundary string of the multipart message will be stored in $boundary.

See http\Message::splitMultipartBody().',
'http\Message::key' => 'Implements Iterator.
See http\Message::current() and http\Message::rewind().',
'http\Message::next' => 'Implements Iterator.
See http\Message::valid() and http\Message::rewind().',
'http\Message::prepend' => 'Prepend message(s) $message to this message, or the top most message of this message chain.

> ***NOTE:***
> The message chains must not overlap.',
'http\Message::reverse' => 'Reverse the message chain and return the former top-most message.

> ***NOTE:***
> Message chains are ordered in reverse-parsed order by default, i.e. the last parsed message is the message you\'ll receive from any call parsing HTTP messages.
>
> This call re-orders the messages of the chain and returns the message that was parsed first with any later parsed messages re-parentized.',
'http\Message::rewind' => 'Implements Iterator.',
'http\Message::serialize' => 'Implements Serializable.',
'http\Message::setBody' => 'Set the message\'s body.
See http\Message::getBody() and http\Message::addBody().',
'http\Message::setHeader' => 'Set a single header.
See http\Message::getHeader() and http\Message::addHeader().

> ***NOTE:***
> Prior to v2.5.6/v3.1.0 headers with the same name were merged into a single
> header with values concatenated by comma.',
'http\Message::setHeaders' => 'Set the message headers.
See http\Message::getHeaders() and http\Message::addHeaders().

> ***NOTE:***
> Prior to v2.5.6/v3.1.0 headers with the same name were merged into a single
> header with values concatenated by comma.',
'http\Message::setHttpVersion' => 'Set the HTTP protocol version of the message.
See http\Message::getHttpVersion().',
'http\Message::setInfo' => 'Set the complete message info, i.e. type and response resp. request information, at once.
See http\Message::getInfo().',
'http\Message::setRequestMethod' => 'Set the request method of the message.
See http\Message::getRequestMethod() and http\Message::setRequestUrl().',
'http\Message::setRequestUrl' => 'Set the request URL of the message.
See http\Message::getRequestUrl() and http\Message::setRequestMethod().',
'http\Message::setResponseCode' => 'Set the response status code.
See http\Message::getResponseCode() and http\Message::setResponseStatus().

> ***NOTE:***
> This method also resets the response status phrase to the default for that code.',
'http\Message::setResponseStatus' => 'Set the response status phrase.
See http\Message::getResponseStatus() and http\Message::setResponseCode().',
'http\Message::setType' => 'Set the message type and reset the message info.
See http\Message::getType() and http\Message::setInfo().',
'http\Message::splitMultipartBody' => 'Splits the body of a multipart message.
See http\Message::isMultipart() and http\Message\Body::addPart().',
'http\Message::toCallback' => 'Stream the message through a callback.',
'http\Message::toStream' => 'Stream the message into stream $stream, starting from $offset, streaming $maxlen at most.',
'http\Message::toString' => 'Retrieve the message serialized to a string.',
'http\Message::unserialize' => 'Implements Serializable.',
'http\Message::valid' => 'Implements Iterator.
See http\Message::current() and http\Message::rewind().',
'http\Message\Body::__construct' => 'Create a new message body, optionally referencing $stream.',
'http\Message\Body::__toString' => 'String cast handler.',
'http\Message\Body::addForm' => 'Add form fields and files to the message body.

> ***NOTE:***
> Currently, http\Message\Body::addForm() creates "multipart/form-data" bodies.',
'http\Message\Body::addPart' => 'Add a part to a multipart body.',
'http\Message\Body::append' => 'Append plain bytes to the message body.',
'http\Message\Body::etag' => 'Retrieve the ETag of the body.',
'http\Message\Body::getBoundary' => 'Retrieve any boundary of the message body.
See http\Message::splitMultipartBody().',
'http\Message\Body::getResource' => 'Retrieve the underlying stream resource.',
'http\Message\Body::serialize' => 'Implements Serializable.
Alias of http\Message\Body::__toString().',
'http\Message\Body::stat' => 'Stat size, atime, mtime and/or ctime.',
'http\Message\Body::toCallback' => 'Stream the message body through a callback.',
'http\Message\Body::toStream' => 'Stream the message body into another stream $stream, starting from $offset, streaming $maxlen at most.',
'http\Message\Body::toString' => 'Retrieve the message body serialized to a string.
Alias of http\Message\Body::__toString().',
'http\Message\Body::unserialize' => 'Implements Serializable.',
'http\Message\Parser::getState' => 'Retrieve the current state of the parser.
See http\Message\Parser::STATE_* constants.',
'http\Message\Parser::parse' => 'Parse a string.',
'http\Message\Parser::stream' => 'Parse a stream.',
'http\Params::__construct' => 'Instantiate a new HTTP (header) parameter set.',
'http\Params::__toString' => 'String cast handler. Alias of http\Params::toString().
Returns a stringified version of the parameters.',
'http\Params::offsetExists' => 'Implements ArrayAccess.',
'http\Params::offsetGet' => 'Implements ArrayAccess.',
'http\Params::offsetSet' => 'Implements ArrayAccess.',
'http\Params::offsetUnset' => 'Implements ArrayAccess.',
'http\Params::toArray' => 'Convenience method that simply returns http\Params::$params.',
'http\Params::toString' => 'Returns a stringified version of the parameters.',
'http\QueryString::__construct' => 'QueryString constructor.',
'http\QueryString::__toString' => 'Get the string representation of the querystring (x-www-form-urlencoded).',
'http\QueryString::get' => 'Retrieve an querystring value',
'http\QueryString::getArray' => 'Retrieve an array value at offset $name',
'http\QueryString::getBool' => 'Retrieve an array value at offset $name',
'http\QueryString::getFloat' => 'Retrieve an array value at offset $name',
'http\QueryString::getGlobalInstance' => 'Retrieve the global querystring instance referencing $_GET',
'http\QueryString::getInt' => 'Retrieve an array value at offset $name',
'http\QueryString::getIterator' => 'Implements IteratorAggregate.',
'http\QueryString::getObject' => 'Retrieve an array value at offset $name',
'http\QueryString::getString' => 'Retrieve an array value at offset $name',
'http\QueryString::mod' => 'Set additional $params to a clone of this instance',
'http\QueryString::offsetExists' => 'Implements ArrayAccess.',
'http\QueryString::offsetGet' => 'Implements ArrayAccess.',
'http\QueryString::offsetSet' => 'Implements ArrayAccess.',
'http\QueryString::offsetUnset' => 'Implements ArrayAccess.',
'http\QueryString::serialize' => 'Implements Serializable.
See http\QueryString::toString().',
'http\QueryString::set' => 'Set additional querystring entries',
'http\QueryString::toArray' => 'Returns http\QueryString::$queryArray',
'http\QueryString::toString' => 'Get the string representation of the querystring (x-www-form-urlencoded)',
'http\QueryString::unserialize' => 'Implements Serializable.',
'http\QueryString::xlate' => 'Translate character encodings of the querystring with ext/iconv',
'http\Url::__construct' => 'Url constructor.',
'http\Url::__toString' => 'Alias of Url::toString()',
'http\Url::mod' => 'Clone this URL and apply $parts to the cloned URL',
'http\Url::toArray' => 'Retrieve the URL parts as array',
'http\Url::toString' => 'Get the string prepresentation of the URL',
'http_build_query' => 'Generate URL-encoded query string',
'http_response_code' => 'Get or Set the HTTP response code',
'HttpDeflateStream::__construct' => 'HttpDeflateStream class constructor',
'HttpDeflateStream::factory' => 'HttpDeflateStream class factory',
'HttpDeflateStream::finish' => 'Finalize deflate stream',
'HttpDeflateStream::flush' => 'Flush deflate stream',
'HttpDeflateStream::update' => 'Update deflate stream',
'HttpInflateStream::__construct' => 'HttpInflateStream class constructor',
'HttpInflateStream::factory' => 'HttpInflateStream class factory',
'HttpInflateStream::finish' => 'Finalize inflate stream',
'HttpInflateStream::flush' => 'Flush inflate stream',
'HttpInflateStream::update' => 'Update inflate stream',
'HttpMessage::__construct' => 'HttpMessage constructor',
'HttpMessage::addHeaders' => 'Add headers',
'HttpMessage::detach' => 'Detach HttpMessage',
'HttpMessage::factory' => 'Create HttpMessage from string',
'HttpMessage::fromEnv' => 'Create HttpMessage from environment',
'HttpMessage::fromString' => 'Create HttpMessage from string',
'HttpMessage::getBody' => 'Get message body',
'HttpMessage::getHeader' => 'Get header',
'HttpMessage::getHeaders' => 'Get message headers',
'HttpMessage::getHttpVersion' => 'Get HTTP version',
'HttpMessage::getParentMessage' => 'Get parent message',
'HttpMessage::getRequestMethod' => 'Get request method',
'HttpMessage::getRequestUrl' => 'Get request URL',
'HttpMessage::getResponseCode' => 'Get response code',
'HttpMessage::getResponseStatus' => 'Get response status',
'HttpMessage::getType' => 'Get message type',
'HttpMessage::guessContentType' => 'Guess content type',
'HttpMessage::prepend' => 'Prepend message(s)',
'HttpMessage::reverse' => 'Reverse message chain',
'HttpMessage::send' => 'Send message',
'HttpMessage::setBody' => 'Set message body',
'HttpMessage::setHeaders' => 'Set headers',
'HttpMessage::setHttpVersion' => 'Set HTTP version',
'HttpMessage::setRequestMethod' => 'Set request method',
'HttpMessage::setRequestUrl' => 'Set request URL',
'HttpMessage::setResponseCode' => 'Set response code',
'HttpMessage::setResponseStatus' => 'Set response status',
'HttpMessage::setType' => 'Set message type',
'HttpMessage::toMessageTypeObject' => 'Create HTTP object regarding message type',
'HttpMessage::toString' => 'Get string representation',
'HttpQueryString::__construct' => 'HttpQueryString constructor',
'HttpQueryString::get' => 'Get (part of) query string',
'HttpQueryString::mod' => 'Modify query string copy',
'HttpQueryString::offsetExists' => 'Whether a offset exists',
'HttpQueryString::offsetGet' => 'Offset to retrieve',
'HttpQueryString::offsetSet' => 'Offset to set',
'HttpQueryString::offsetUnset' => 'Offset to unset',
'HttpQueryString::serialize' => 'String representation of object',
'HttpQueryString::set' => 'Set query string params',
'HttpQueryString::singleton' => 'HttpQueryString singleton',
'HttpQueryString::toArray' => 'Get query string as array',
'HttpQueryString::toString' => 'Get query string',
'HttpQueryString::unserialize' => 'Constructs the object',
'HttpQueryString::xlate' => 'Change query strings charset',
'HttpRequest::__construct' => 'HttpRequest constructor',
'HttpRequest::addCookies' => 'Add cookies',
'HttpRequest::addHeaders' => 'Add headers',
'HttpRequest::addPostFields' => 'Add post fields',
'HttpRequest::addPostFile' => 'Add post file',
'HttpRequest::addPutData' => 'Add put data',
'HttpRequest::addQueryData' => 'Add query data',
'HttpRequest::addRawPostData' => 'Add raw post data',
'HttpRequest::addSslOptions' => 'Add ssl options',
'HttpRequest::clearHistory' => 'Clear history',
'HttpRequest::enableCookies' => 'Enable cookies',
'HttpRequest::getContentType' => 'Get content type',
'HttpRequest::getCookies' => 'Get cookies',
'HttpRequest::getHeaders' => 'Get headers',
'HttpRequest::getHistory' => 'Get history',
'HttpRequest::getMethod' => 'Get method',
'HttpRequest::getOptions' => 'Get options',
'HttpRequest::getPostFields' => 'Get post fields',
'HttpRequest::getPostFiles' => 'Get post files',
'HttpRequest::getPutData' => 'Get put data',
'HttpRequest::getPutFile' => 'Get put file',
'HttpRequest::getQueryData' => 'Get query data',
'HttpRequest::getRawPostData' => 'Get raw post data',
'HttpRequest::getRawRequestMessage' => 'Get raw request message',
'HttpRequest::getRawResponseMessage' => 'Get raw response message',
'HttpRequest::getRequestMessage' => 'Get request message',
'HttpRequest::getResponseBody' => 'Get response body',
'HttpRequest::getResponseCode' => 'Get response code',
'HttpRequest::getResponseCookies' => 'Get response cookie(s)',
'HttpRequest::getResponseData' => 'Get response data',
'HttpRequest::getResponseHeader' => 'Get response header(s)',
'HttpRequest::getResponseInfo' => 'Get response info',
'HttpRequest::getResponseMessage' => 'Get response message',
'HttpRequest::getResponseStatus' => 'Get response status',
'HttpRequest::getSslOptions' => 'Get ssl options',
'HttpRequest::getUrl' => 'Get url',
'HttpRequest::resetCookies' => 'Reset cookies',
'HttpRequest::send' => 'Send request',
'HttpRequest::setContentType' => 'Set content type',
'HttpRequest::setCookies' => 'Set cookies',
'HttpRequest::setHeaders' => 'Set headers',
'HttpRequest::setMethod' => 'Set method',
'HttpRequest::setOptions' => 'Set options',
'HttpRequest::setPostFields' => 'Set post fields',
'HttpRequest::setPostFiles' => 'Set post files',
'HttpRequest::setPutData' => 'Set put data',
'HttpRequest::setPutFile' => 'Set put file',
'HttpRequest::setQueryData' => 'Set query data',
'HttpRequest::setRawPostData' => 'Set raw post data',
'HttpRequest::setSslOptions' => 'Set ssl options',
'HttpRequest::setUrl' => 'Set URL',
'HttpRequestPool::__construct' => 'HttpRequestPool constructor',
'HttpRequestPool::__destruct' => 'HttpRequestPool destructor',
'HttpRequestPool::attach' => 'Attach HttpRequest',
'HttpRequestPool::detach' => 'Detach HttpRequest',
'HttpRequestPool::getAttachedRequests' => 'Get attached requests',
'HttpRequestPool::getFinishedRequests' => 'Get finished requests',
'HttpRequestPool::reset' => 'Reset request pool',
'HttpRequestPool::send' => 'Send all requests',
'HttpRequestPool::socketPerform' => 'Perform socket actions',
'HttpRequestPool::socketSelect' => 'Perform socket select',
'HttpResponse::capture' => 'Capture script output',
'HttpResponse::getBufferSize' => 'Get buffer size',
'HttpResponse::getCache' => 'Get cache',
'HttpResponse::getCacheControl' => 'Get cache control',
'HttpResponse::getContentDisposition' => 'Get content disposition',
'HttpResponse::getContentType' => 'Get content type',
'HttpResponse::getData' => 'Get data',
'HttpResponse::getETag' => 'Get ETag',
'HttpResponse::getFile' => 'Get file',
'HttpResponse::getGzip' => 'Get gzip',
'HttpResponse::getHeader' => 'Get header',
'HttpResponse::getLastModified' => 'Get last modified',
'HttpResponse::getRequestBody' => 'Get request body',
'HttpResponse::getRequestBodyStream' => 'Get request body stream',
'HttpResponse::getRequestHeaders' => 'Get request headers',
'HttpResponse::getStream' => 'Get Stream',
'HttpResponse::getThrottleDelay' => 'Get throttle delay',
'HttpResponse::guessContentType' => 'Guess content type',
'HttpResponse::redirect' => 'Redirect',
'HttpResponse::send' => 'Send response',
'HttpResponse::setBufferSize' => 'Set buffer size',
'HttpResponse::setCache' => 'Set cache',
'HttpResponse::setCacheControl' => 'Set cache control',
'HttpResponse::setContentDisposition' => 'Set content disposition',
'HttpResponse::setContentType' => 'Set content type',
'HttpResponse::setData' => 'Set data',
'HttpResponse::setETag' => 'Set ETag',
'HttpResponse::setFile' => 'Set file',
'HttpResponse::setGzip' => 'Set gzip',
'HttpResponse::setHeader' => 'Set header',
'HttpResponse::setLastModified' => 'Set last modified',
'HttpResponse::setStream' => 'Set stream',
'HttpResponse::setThrottleDelay' => 'Set throttle delay',
'HttpResponse::status' => 'Send HTTP response status',
'hw_api::checkin' => 'Checks in an object',
'hw_api::checkout' => 'Checks out an object',
'hw_api::children' => 'Returns children of an object',
'hw_api::content' => 'Returns content of an object',
'hw_api::copy' => 'Copies physically',
'hw_api::dbstat' => 'Returns statistics about database server',
'hw_api::dcstat' => 'Returns statistics about document cache server',
'hw_api::dstanchors' => 'Returns a list of all destination anchors',
'hw_api::dstofsrcanchor' => 'Returns destination of a source anchor',
'hw_api::find' => 'Search for objects',
'hw_api::ftstat' => 'Returns statistics about fulltext server',
'hw_api::hwstat' => 'Returns statistics about Hyperwave server',
'hw_api::identify' => 'Log into Hyperwave Server',
'hw_api::info' => 'Returns information about server configuration',
'hw_api::insert' => 'Inserts a new object',
'hw_api::insertanchor' => 'Inserts a new object of type anchor',
'hw_api::insertcollection' => 'Inserts a new object of type collection',
'hw_api::insertdocument' => 'Inserts a new object of type document',
'hw_api::link' => 'Creates a link to an object',
'hw_api::lock' => 'Locks an object',
'hw_api::move' => 'Moves object between collections',
'hw_api::object' => 'Retrieve attribute information',
'hw_api::objectbyanchor' => 'Returns the object an anchor belongs to',
'hw_api::parents' => 'Returns parents of an object',
'hw_api::remove' => 'Delete an object',
'hw_api::replace' => 'Replaces an object',
'hw_api::setcommittedversion' => 'Commits version other than last version',
'hw_api::srcanchors' => 'Returns a list of all source anchors',
'hw_api::srcsofdst' => 'Returns source of a destination object',
'hw_api::unlock' => 'Unlocks a locked object',
'hw_api::user' => 'Returns the own user object',
'hw_api::userlist' => 'Returns a list of all logged in users',
'hw_api_attribute::key' => 'Returns key of the attribute',
'hw_api_attribute::langdepvalue' => 'Returns value for a given language',
'hw_api_attribute::value' => 'Returns value of the attribute',
'hw_api_attribute::values' => 'Returns all values of the attribute',
'hw_api_content::mimetype' => 'Returns mimetype',
'hw_api_content::read' => 'Read content',
'hw_api_error::count' => 'Returns number of reasons',
'hw_api_error::reason' => 'Returns reason of error',
'hw_api_object::assign' => 'Clones object',
'hw_api_object::attreditable' => 'Checks whether an attribute is editable',
'hw_api_object::count' => 'Returns number of attributes',
'hw_api_object::insert' => 'Inserts new attribute',
'hw_api_object::remove' => 'Removes attribute',
'hw_api_object::title' => 'Returns the title attribute',
'hw_api_object::value' => 'Returns value of attribute',
'hw_api_reason::description' => 'Returns description of reason',
'hw_api_reason::type' => 'Returns type of reason',
'hwapi_attribute_new' => 'Creates instance of class hw_api_attribute',
'hwapi_content_new' => 'Create new instance of class hw_api_content',
'hwapi_hgcsp' => 'Returns object of class hw_api',
'hwapi_object_new' => 'Creates a new instance of class hwapi_object_new',
'hypot' => 'Calculate the length of the hypotenuse of a right-angle triangle',
'ibase_add_user' => 'Add a user to a security database',
'ibase_affected_rows' => 'Return the number of rows that were affected by the previous query',
'ibase_backup' => 'Initiates a backup task in the service manager and returns immediately',
'ibase_blob_add' => 'Add data into a newly created blob',
'ibase_blob_cancel' => 'Cancel creating blob',
'ibase_blob_close' => 'Close blob',
'ibase_blob_create' => 'Create a new blob for adding data',
'ibase_blob_echo' => 'Output blob contents to browser',
'ibase_blob_get' => 'Get len bytes data from open blob',
'ibase_blob_import' => 'Create blob, copy file in it, and close it',
'ibase_blob_info' => 'Return blob length and other useful info',
'ibase_blob_open' => 'Open blob for retrieving data parts',
'ibase_close' => 'Close a connection to an InterBase database',
'ibase_commit' => 'Commit a transaction',
'ibase_commit_ret' => 'Commit a transaction without closing it',
'ibase_connect' => 'Open a connection to a database',
'ibase_db_info' => 'Request statistics about a database',
'ibase_delete_user' => 'Delete a user from a security database',
'ibase_drop_db' => 'Drops a database',
'ibase_errcode' => 'Return an error code',
'ibase_errmsg' => 'Return error messages',
'ibase_execute' => 'Execute a previously prepared query',
'ibase_fetch_assoc' => 'Fetch a result row from a query as an associative array',
'ibase_fetch_object' => 'Get an object from a InterBase database',
'ibase_fetch_row' => 'Fetch a row from an InterBase database',
'ibase_field_info' => 'Get information about a field',
'ibase_free_event_handler' => 'Cancels a registered event handler',
'ibase_free_query' => 'Free memory allocated by a prepared query',
'ibase_free_result' => 'Free a result set',
'ibase_gen_id' => 'Increments the named generator and returns its new value',
'ibase_maintain_db' => 'Execute a maintenance command on the database server',
'ibase_modify_user' => 'Modify a user to a security database',
'ibase_name_result' => 'Assigns a name to a result set',
'ibase_num_fields' => 'Get the number of fields in a result set',
'ibase_num_params' => 'Return the number of parameters in a prepared query',
'ibase_param_info' => 'Return information about a parameter in a prepared query',
'ibase_pconnect' => 'Open a persistent connection to an InterBase database',
'ibase_prepare' => 'Prepare a query for later binding of parameter placeholders and execution',
'ibase_query' => 'Execute a query on an InterBase database',
'ibase_restore' => 'Initiates a restore task in the service manager and returns immediately',
'ibase_rollback' => 'Roll back a transaction',
'ibase_rollback_ret' => 'Roll back a transaction without closing it',
'ibase_server_info' => 'Request information about a database server',
'ibase_service_attach' => 'Connect to the service manager',
'ibase_service_detach' => 'Disconnect from the service manager',
'ibase_set_event_handler' => 'Register a callback function to be called when events are posted',
'ibase_trans' => 'Begin a transaction',
'ibase_wait_event' => 'Wait for an event to be posted by the database',
'iconv' => 'Convert string to requested character encoding',
'iconv_get_encoding' => 'Retrieve internal configuration variables of iconv extension',
'iconv_mime_decode' => 'Decodes a MIME header field',
'iconv_mime_decode_headers' => 'Decodes multiple MIME header fields at once',
'iconv_mime_encode' => 'Composes a MIME header field',
'iconv_set_encoding' => 'Set current setting for character encoding conversion',
'iconv_strlen' => 'Returns the character count of string',
'iconv_strpos' => 'Finds position of first occurrence of a needle within a haystack',
'iconv_strrpos' => 'Finds the last occurrence of a needle within a haystack',
'iconv_substr' => 'Cut out part of a string',
'id3_get_frame_long_name' => 'Get the long name of an ID3v2 frame',
'id3_get_frame_short_name' => 'Get the short name of an ID3v2 frame',
'id3_get_genre_id' => 'Get the id for a genre',
'id3_get_genre_list' => 'Get all possible genre values',
'id3_get_genre_name' => 'Get the name for a genre id',
'id3_get_tag' => 'Get all information stored in an ID3 tag',
'id3_get_version' => 'Get version of an ID3 tag',
'id3_remove_tag' => 'Remove an existing ID3 tag',
'id3_set_tag' => 'Update information stored in an ID3 tag',
'idate' => 'Format a local time/date as integer',
'ifx_affected_rows' => 'Get number of rows affected by a query',
'ifx_blobinfile_mode' => 'Set the default blob mode for all select queries',
'ifx_byteasvarchar' => 'Set the default byte mode',
'ifx_close' => 'Close Informix connection',
'ifx_connect' => 'Open Informix server connection',
'ifx_copy_blob' => 'Duplicates the given blob object',
'ifx_create_blob' => 'Creates an blob object',
'ifx_create_char' => 'Creates an char object',
'ifx_do' => 'Execute a previously prepared SQL-statement',
'ifx_error' => 'Returns error code of last Informix call',
'ifx_errormsg' => 'Returns error message of last Informix call',
'ifx_fetch_row' => 'Get row as an associative array',
'ifx_fieldproperties' => 'List of SQL fieldproperties',
'ifx_fieldtypes' => 'List of Informix SQL fields',
'ifx_free_blob' => 'Deletes the blob object',
'ifx_free_char' => 'Deletes the char object',
'ifx_free_result' => 'Releases resources for the query',
'ifx_get_blob' => 'Return the content of a blob object',
'ifx_get_char' => 'Return the content of the char object',
'ifx_getsqlca' => 'Get the contents of sqlca.sqlerrd[0..5] after a query',
'ifx_htmltbl_result' => 'Formats all rows of a query into a HTML table',
'ifx_nullformat' => 'Sets the default return value on a fetch row',
'ifx_num_fields' => 'Returns the number of columns in the query',
'ifx_num_rows' => 'Count the rows already fetched from a query',
'ifx_pconnect' => 'Open persistent Informix connection',
'ifx_prepare' => 'Prepare an SQL-statement for execution',
'ifx_query' => 'Send Informix query',
'ifx_textasvarchar' => 'Set the default text mode',
'ifx_update_blob' => 'Updates the content of the blob object',
'ifx_update_char' => 'Updates the content of the char object',
'ifxus_close_slob' => 'Deletes the slob object',
'ifxus_create_slob' => 'Creates an slob object and opens it',
'ifxus_free_slob' => 'Deletes the slob object',
'ifxus_open_slob' => 'Opens an slob object',
'ifxus_read_slob' => 'Reads nbytes of the slob object',
'ifxus_seek_slob' => 'Sets the current file or seek position',
'ifxus_tell_slob' => 'Returns the current file or seek position',
'ifxus_write_slob' => 'Writes a string into the slob object',
'ignore_user_abort' => 'Set whether a client disconnect should abort script execution',
'iis_add_server' => 'Creates a new virtual web server',
'iis_get_dir_security' => 'Gets Directory Security',
'iis_get_script_map' => 'Gets script mapping on a virtual directory for a specific extension',
'iis_get_server_by_comment' => 'Return the instance number associated with the Comment',
'iis_get_server_by_path' => 'Return the instance number associated with the Path',
'iis_get_server_rights' => 'Gets server rights',
'iis_get_service_state' => 'Returns the state for the service defined by ServiceId',
'iis_remove_server' => 'Removes the virtual web server indicated by ServerInstance',
'iis_set_app_settings' => 'Creates application scope for a virtual directory',
'iis_set_dir_security' => 'Sets Directory Security',
'iis_set_script_map' => 'Sets script mapping on a virtual directory',
'iis_set_server_rights' => 'Sets server rights',
'iis_start_server' => 'Starts the virtual web server',
'iis_start_service' => 'Starts the service defined by ServiceId',
'iis_stop_server' => 'Stops the virtual web server',
'iis_stop_service' => 'Stops the service defined by ServiceId',
'image2wbmp' => '`gd.image.output`',
'image_type_to_extension' => 'Get file extension for image type',
'image_type_to_mime_type' => 'Get Mime-Type for image-type returned by getimagesize, exif_read_data, exif_thumbnail, exif_imagetype',
'imageaffine' => 'Return an image containing the affine transformed src image, using an optional clipping area',
'imageaffinematrixconcat' => 'Concatenate two affine transformation matrices',
'imageaffinematrixget' => 'Get an affine transformation matrix',
'imagealphablending' => 'Set the blending mode for an image',
'imageantialias' => 'Should antialias functions be used or not',
'imagearc' => 'Draws an arc',
'imagebmp' => 'Output a BMP image to browser or file',
'imagechar' => 'Draw a character horizontally',
'imagecharup' => 'Draw a character vertically',
'imagecolorallocate' => 'Allocate a color for an image',
'imagecolorallocatealpha' => 'Allocate a color for an image',
'imagecolorat' => 'Get the index of the color of a pixel',
'imagecolorclosest' => 'Get the index of the closest color to the specified color',
'imagecolorclosestalpha' => 'Get the index of the closest color to the specified color + alpha',
'imagecolorclosesthwb' => 'Get the index of the color which has the hue, white and blackness',
'imagecolordeallocate' => 'De-allocate a color for an image',
'imagecolorexact' => 'Get the index of the specified color',
'imagecolorexactalpha' => 'Get the index of the specified color + alpha',
'imagecolormatch' => 'Makes the colors of the palette version of an image more closely match the true color version',
'imagecolorresolve' => 'Get the index of the specified color or its closest possible alternative',
'imagecolorresolvealpha' => 'Get the index of the specified color + alpha or its closest possible alternative',
'imagecolorset' => 'Set the color for the specified palette index',
'imagecolorsforindex' => 'Get the colors for an index',
'imagecolorstotal' => 'Find out the number of colors in an image\'s palette',
'imagecolortransparent' => 'Define a color as transparent',
'imageconvolution' => 'Apply a 3x3 convolution matrix, using coefficient and offset',
'imagecopy' => 'Copy part of an image',
'imagecopymerge' => 'Copy and merge part of an image',
'imagecopymergegray' => 'Copy and merge part of an image with gray scale',
'imagecopyresampled' => 'Copy and resize part of an image with resampling',
'imagecopyresized' => 'Copy and resize part of an image',
'imagecreate' => 'Create a new palette based image',
'imagecreatefrombmp' => '`gd.image.new`',
'imagecreatefromgd' => 'Create a new image from GD file or URL',
'imagecreatefromgd2' => 'Create a new image from GD2 file or URL',
'imagecreatefromgd2part' => 'Create a new image from a given part of GD2 file or URL',
'imagecreatefromgif' => '`gd.image.new`',
'imagecreatefromjpeg' => '`gd.image.new`',
'imagecreatefrompng' => '`gd.image.new`',
'imagecreatefromstring' => 'Create a new image from the image stream in the string',
'imagecreatefromwbmp' => '`gd.image.new`',
'imagecreatefromwebp' => '`gd.image.new`',
'imagecreatefromxbm' => '`gd.image.new`',
'imagecreatefromxpm' => '`gd.image.new`',
'imagecreatetruecolor' => 'Create a new true color image',
'imagecrop' => 'Crop an image to the given rectangle',
'imagecropauto' => 'Crop an image automatically using one of the available modes',
'imagedashedline' => 'Draw a dashed line',
'imagedestroy' => 'Destroy an image',
'imageellipse' => 'Draw an ellipse',
'imagefill' => 'Flood fill',
'imagefilledarc' => 'Draw a partial arc and fill it',
'imagefilledellipse' => 'Draw a filled ellipse',
'imagefilledpolygon' => 'Draw a filled polygon',
'imagefilledrectangle' => 'Draw a filled rectangle',
'imagefilltoborder' => 'Flood fill to specific color',
'imagefilter' => 'Applies a filter to an image',
'imageflip' => 'Flips an image using a given mode',
'imagefontheight' => 'Get font height',
'imagefontwidth' => 'Get font width',
'imageftbbox' => 'Give the bounding box of a text using fonts via freetype2',
'imagefttext' => 'Write text to the image using fonts using FreeType 2',
'imagegammacorrect' => 'Apply a gamma correction to a GD image',
'imagegd' => 'Output GD image to browser or file',
'imagegd2' => 'Output GD2 image to browser or file',
'imagegetclip' => 'Get the clipping rectangle',
'imagegif' => '`gd.image.output`',
'imagegrabscreen' => 'Captures the whole screen',
'imagegrabwindow' => 'Captures a window',
'imageinterlace' => 'Enable or disable interlace',
'imageistruecolor' => 'Finds whether an image is a truecolor image',
'imagejpeg' => '`gd.image.output`',
'imagelayereffect' => 'Set the alpha blending flag to use layering effects',
'imageline' => 'Draw a line',
'imageloadfont' => 'Load a new font',
'imageObj::pasteImage' => 'Copy srcImg on top of the current imageObj.
transparentColorHex is the color (in 0xrrggbb format) from srcImg
that should be considered transparent (i.e. those pixels won\'t
be copied).  Pass -1 if you don\'t want any transparent color.
If optional dstx,dsty are provided then it defines the position
where the image should be copied (dstx,dsty = top-left corner
position).
The optional angle is a value between 0 and 360 degrees to rotate
the source image counterclockwise.  Note that if an angle is specified
(even if its value is zero) then the dstx and dsty coordinates
specify the CENTER of the destination area.
Note: this function works only with 8 bits GD images (PNG or GIF).',
'imageObj::saveImage' => 'Writes image object to specified filename.
Passing no filename or an empty filename sends output to stdout.  In
this case, the PHP header() function should be used to set the
document\'s content-type prior to calling saveImage().  The output
format is the one that is currently selected in the map file.  The
second argument oMap is not manadatory. It is usful when saving to
formats like GTIFF that needs georeference information contained in
the map file. On success, it returns either MS_SUCCESS if writing to an
external file, or the number of bytes written if output is sent to
stdout.',
'imageObj::saveWebImage' => 'Writes image to temp directory.  Returns image URL.
The output format is the one that is currently selected in the
map file.',
'imageopenpolygon' => 'Draws an open polygon',
'imagepalettecopy' => 'Copy the palette from one image to another',
'imagepalettetotruecolor' => 'Converts a palette based image to true color',
'imagepng' => 'Output a PNG image to either the browser or a file',
'imagepolygon' => 'Draws a polygon',
'imagepsbbox' => 'Give the bounding box of a text rectangle using PostScript Type1 fonts',
'imagepsencodefont' => 'Change the character encoding vector of a font',
'imagepsextendfont' => 'Extend or condense a font',
'imagepsfreefont' => 'Free memory used by a PostScript Type 1 font',
'imagepsloadfont' => 'Load a PostScript Type 1 font from file',
'imagepsslantfont' => 'Slant a font',
'imagepstext' => 'Draws a text over an image using PostScript Type1 fonts',
'imagerectangle' => 'Draw a rectangle',
'imageresolution' => 'Get or set the resolution of the image',
'imagerotate' => 'Rotate an image with a given angle',
'imagesavealpha' => 'Whether to retain full alpha channel information when saving PNG images',
'imagescale' => 'Scale an image using the given new width and height',
'imagesetbrush' => 'Set the brush image for line drawing',
'imagesetclip' => 'Set the clipping rectangle',
'imagesetinterpolation' => 'Set the interpolation method',
'imagesetpixel' => 'Set a single pixel',
'imagesetstyle' => 'Set the style for line drawing',
'imagesetthickness' => 'Set the thickness for line drawing',
'imagesettile' => 'Set the tile image for filling',
'imagestring' => 'Draw a string horizontally',
'imagestringup' => 'Draw a string vertically',
'imagesx' => 'Get image width',
'imagesy' => 'Get image height',
'imagetruecolortopalette' => 'Convert a true color image to a palette image',
'imagettfbbox' => 'Give the bounding box of a text using TrueType fonts',
'imagettftext' => 'Write text to the image using TrueType fonts',
'imagetypes' => 'Return the image types supported by this PHP build',
'imagewbmp' => '`gd.image.output`',
'imagewebp' => 'Output a WebP image to browser or file',
'imagexbm' => 'Output an XBM image to browser or file',
'imagick::__construct' => 'The Imagick constructor',
'imagick::__toString' => 'Returns the image as a string',
'imagick::adaptiveBlurImage' => 'Adds adaptive blur filter to image',
'imagick::adaptiveResizeImage' => 'Adaptively resize image with data dependent triangulation',
'imagick::adaptiveSharpenImage' => 'Adaptively sharpen the image',
'imagick::adaptiveThresholdImage' => 'Selects a threshold for each pixel based on a range of intensity',
'imagick::addImage' => 'Adds new image to Imagick object image list',
'imagick::addNoiseImage' => 'Adds random noise to the image',
'imagick::affineTransformImage' => 'Transforms an image',
'imagick::animateImages' => 'Animates an image or images',
'imagick::annotateImage' => 'Annotates an image with text',
'imagick::appendImages' => 'Append a set of images',
'Imagick::autoGammaImage' => 'Extracts the \'mean\' from the image and adjust the image to try make set its gamma appropriately.',
'Imagick::autoOrient' => 'Adjusts an image so that its orientation is suitable $ for viewing (i.e. top-left orientation).',
'imagick::averageImages' => 'Average a set of images',
'imagick::blackThresholdImage' => 'Forces all pixels below the threshold into black',
'imagick::blurImage' => 'Adds blur filter to image',
'imagick::borderImage' => 'Surrounds the image with a border',
'Imagick::brightnessContrastImage' => 'Change the brightness and/or contrast of an image. It converts the brightness and contrast parameters into slope and intercept and calls a polynomical function to apply to the image.',
'imagick::charcoalImage' => 'Simulates a charcoal drawing',
'imagick::chopImage' => 'Removes a region of an image and trims',
'imagick::clear' => 'Clears all resources associated to Imagick object',
'imagick::clipImage' => 'Clips along the first path from the 8BIM profile',
'imagick::clipPathImage' => 'Clips along the named paths from the 8BIM profile',
'imagick::clone' => 'Makes an exact copy of the Imagick object',
'imagick::clutImage' => 'Replaces colors in the image',
'imagick::coalesceImages' => 'Composites a set of images',
'imagick::colorFloodfillImage' => 'Changes the color value of any pixel that matches target',
'imagick::colorizeImage' => 'Blends the fill color with the image',
'Imagick::colorMatrixImage' => 'Apply color transformation to an image. The method permits saturation changes, hue rotation, luminance to alpha, and various other effects. Although variable-sized transformation matrices can be used, typically one uses a 5x5 matrix for an RGBA image and a 6x6 for CMYKA (or RGBA with offsets).
The matrix is similar to those used by Adobe Flash except offsets are in column 6 rather than 5 (in support of CMYKA images) and offsets are normalized (divide Flash offset by 255)',
'imagick::combineImages' => 'Combines one or more images into a single image',
'imagick::commentImage' => 'Adds a comment to your image',
'imagick::compareImageChannels' => 'Returns the difference in one or more images',
'imagick::compareImageLayers' => 'Returns the maximum bounding region between images',
'imagick::compareImages' => 'Compares an image to a reconstructed image',
'imagick::compositeImage' => 'Composite one image onto another',
'Imagick::compositeImageGravity' => 'Composite one image onto another using the specified gravity.',
'imagick::contrastImage' => 'Change the contrast of the image',
'imagick::contrastStretchImage' => 'Enhances the contrast of a color image',
'imagick::convolveImage' => 'Applies a custom convolution kernel to the image',
'imagick::count' => 'Get the number of images',
'imagick::cropImage' => 'Extracts a region of the image',
'imagick::cropThumbnailImage' => 'Creates a crop thumbnail',
'imagick::current' => 'Returns a reference to the current Imagick object',
'imagick::cycleColormapImage' => 'Displaces an image\'s colormap',
'imagick::decipherImage' => 'Deciphers an image',
'imagick::deconstructImages' => 'Returns certain pixel differences between images',
'imagick::deleteImageArtifact' => 'Delete image artifact',
'Imagick::deleteImageProperty' => 'Deletes an image property.',
'imagick::deskewImage' => 'Removes skew from the image',
'imagick::despeckleImage' => 'Reduces the speckle noise in an image',
'imagick::destroy' => 'Destroys the Imagick object',
'imagick::displayImage' => 'Displays an image',
'imagick::displayImages' => 'Displays an image or image sequence',
'imagick::distortImage' => 'Distorts an image using various distortion methods',
'imagick::drawImage' => 'Renders the ImagickDraw object on the current image',
'imagick::edgeImage' => 'Enhance edges within the image',
'imagick::embossImage' => 'Returns a grayscale image with a three-dimensional effect',
'imagick::encipherImage' => 'Enciphers an image',
'imagick::enhanceImage' => 'Improves the quality of a noisy image',
'imagick::equalizeImage' => 'Equalizes the image histogram',
'imagick::evaluateImage' => 'Applies an expression to an image',
'Imagick::evaluateImages' => 'Merge multiple images of the same size together with the selected operator. https://www.imagemagick.org/Usage/layers/#evaluate-sequence',
'imagick::exportImagePixels' => 'Exports raw image pixels',
'imagick::extentImage' => 'Set image size',
'Imagick::filter' => 'Applies a custom convolution kernel to the image.',
'imagick::flattenImages' => 'Merges a sequence of images',
'imagick::flipImage' => 'Creates a vertical mirror image',
'imagick::floodFillPaintImage' => 'Changes the color value of any pixel that matches target',
'imagick::flopImage' => 'Creates a horizontal mirror image',
'Imagick::forwardFourierTransformimage' => 'Implements the discrete Fourier transform (DFT) of the image either as a magnitude / phase or real / imaginary image pair.',
'imagick::frameImage' => 'Adds a simulated three-dimensional border',
'imagick::functionImage' => 'Applies a function on the image',
'imagick::fxImage' => 'Evaluate expression for each pixel in the image',
'imagick::gammaImage' => 'Gamma-corrects an image',
'imagick::gaussianBlurImage' => 'Blurs an image',
'imagick::getColorspace' => 'Gets the colorspace',
'imagick::getCompression' => 'Gets the object compression type',
'imagick::getCompressionQuality' => 'Gets the object compression quality',
'Imagick::getConfigureOptions' => 'Returns any ImageMagick  configure options that match the specified pattern (e.g. "*" for all). Options include NAME, VERSION, LIB_VERSION, etc.',
'imagick::getCopyright' => 'Returns the ImageMagick API copyright as a string',
'Imagick::getFeatures' => 'GetFeatures() returns the ImageMagick features that have been compiled into the runtime.',
'imagick::getFilename' => 'The filename associated with an image sequence',
'imagick::getFont' => 'Gets font',
'imagick::getFormat' => 'Returns the format of the Imagick object',
'imagick::getGravity' => 'Gets the gravity',
'imagick::getHomeURL' => 'Returns the ImageMagick home URL',
'imagick::getImage' => 'Returns a new Imagick object',
'imagick::getImageAlphaChannel' => 'Gets the image alpha channel',
'imagick::getImageArtifact' => 'Get image artifact',
'imagick::getImageBackgroundColor' => 'Returns the image background color',
'imagick::getImageBlob' => 'Returns the image sequence as a blob',
'imagick::getImageBluePrimary' => 'Returns the chromaticy blue primary point',
'imagick::getImageBorderColor' => 'Returns the image border color',
'imagick::getImageChannelDepth' => 'Gets the depth for a particular image channel',
'imagick::getImageChannelDistortion' => 'Compares image channels of an image to a reconstructed image',
'imagick::getImageChannelDistortions' => 'Gets channel distortions',
'imagick::getImageChannelExtrema' => 'Gets the extrema for one or more image channels',
'imagick::getImageChannelKurtosis' => 'The getImageChannelKurtosis purpose',
'imagick::getImageChannelMean' => 'Gets the mean and standard deviation',
'imagick::getImageChannelRange' => 'Gets channel range',
'imagick::getImageChannelStatistics' => 'Returns statistics for each channel in the image',
'imagick::getImageClipMask' => 'Gets image clip mask',
'imagick::getImageColormapColor' => 'Returns the color of the specified colormap index',
'imagick::getImageColors' => 'Gets the number of unique colors in the image',
'imagick::getImageColorspace' => 'Gets the image colorspace',
'imagick::getImageCompose' => 'Returns the composite operator associated with the image',
'imagick::getImageCompression' => 'Gets the current image\'s compression type',
'imagick::getImageCompressionQuality' => 'Gets the current image\'s compression quality',
'imagick::getImageDelay' => 'Gets the image delay',
'imagick::getImageDepth' => 'Gets the image depth',
'imagick::getImageDispose' => 'Gets the image disposal method',
'imagick::getImageDistortion' => 'Compares an image to a reconstructed image',
'imagick::getImageExtrema' => 'Gets the extrema for the image',
'imagick::getImageFilename' => 'Returns the filename of a particular image in a sequence',
'imagick::getImageFormat' => 'Returns the format of a particular image in a sequence',
'imagick::getImageGamma' => 'Gets the image gamma',
'imagick::getImageGeometry' => 'Gets the width and height as an associative array',
'imagick::getImageGravity' => 'Gets the image gravity',
'imagick::getImageGreenPrimary' => 'Returns the chromaticy green primary point',
'imagick::getImageHeight' => 'Returns the image height',
'imagick::getImageHistogram' => 'Gets the image histogram',
'imagick::getImageIndex' => 'Gets the index of the current active image',
'imagick::getImageInterlaceScheme' => 'Gets the image interlace scheme',
'imagick::getImageInterpolateMethod' => 'Returns the interpolation method',
'imagick::getImageIterations' => 'Gets the image iterations',
'imagick::getImageLength' => 'Returns the image length in bytes',
'imagick::getImageMagickLicense' => 'Returns a string containing the ImageMagick license',
'imagick::getImageMatte' => 'Return if the image has a matte channel',
'imagick::getImageMatteColor' => 'Returns the image matte color',
'Imagick::getImageMimeType' => '`@return string` Returns the image mime-type.',
'imagick::getImageOrientation' => 'Gets the image orientation',
'imagick::getImagePage' => 'Returns the page geometry',
'imagick::getImagePixelColor' => 'Returns the color of the specified pixel',
'imagick::getImageProfile' => 'Returns the named image profile',
'imagick::getImageProfiles' => 'Returns the image profiles',
'imagick::getImageProperties' => 'Returns the image properties',
'imagick::getImageProperty' => 'Returns the named image property',
'imagick::getImageRedPrimary' => 'Returns the chromaticity red primary point',
'imagick::getImageRegion' => 'Extracts a region of the image',
'imagick::getImageRenderingIntent' => 'Gets the image rendering intent',
'imagick::getImageResolution' => 'Gets the image X and Y resolution',
'imagick::getImagesBlob' => 'Returns all image sequences as a blob',
'imagick::getImageScene' => 'Gets the image scene',
'imagick::getImageSignature' => 'Generates an SHA-256 message digest',
'imagick::getImageSize' => 'Returns the image length in bytes',
'imagick::getImageTicksPerSecond' => 'Gets the image ticks-per-second',
'imagick::getImageTotalInkDensity' => 'Gets the image total ink density',
'imagick::getImageType' => 'Gets the potential image type',
'imagick::getImageUnits' => 'Gets the image units of resolution',
'imagick::getImageVirtualPixelMethod' => 'Returns the virtual pixel method',
'imagick::getImageWhitePoint' => 'Returns the chromaticity white point',
'imagick::getImageWidth' => 'Returns the image width',
'imagick::getInterlaceScheme' => 'Gets the object interlace scheme',
'imagick::getIteratorIndex' => 'Gets the index of the current active image',
'imagick::getNumberImages' => 'Returns the number of images in the object',
'imagick::getOption' => 'Returns a value associated with the specified key',
'imagick::getPackageName' => 'Returns the ImageMagick package name',
'imagick::getPage' => 'Returns the page geometry',
'imagick::getPixelIterator' => 'Returns a MagickPixelIterator',
'imagick::getPixelRegionIterator' => 'Get an ImagickPixelIterator for an image section',
'imagick::getPointSize' => 'Gets point size',
'Imagick::getQuantum' => 'Returns the ImageMagick quantum range as an integer.',
'imagick::getQuantumDepth' => 'Gets the quantum depth',
'imagick::getQuantumRange' => 'Returns the Imagick quantum range',
'Imagick::getRegistry' => 'Get the StringRegistry entry for the named key or false if not set.',
'imagick::getReleaseDate' => 'Returns the ImageMagick release date',
'imagick::getResource' => 'Returns the specified resource\'s memory usage',
'imagick::getResourceLimit' => 'Returns the specified resource limit',
'imagick::getSamplingFactors' => 'Gets the horizontal and vertical sampling factor',
'imagick::getSize' => 'Returns the size associated with the Imagick object',
'imagick::getSizeOffset' => 'Returns the size offset',
'imagick::getVersion' => 'Returns the ImageMagick API version',
'imagick::haldClutImage' => 'Replaces colors in the image',
'imagick::hasNextImage' => 'Checks if the object has more images',
'imagick::hasPreviousImage' => 'Checks if the object has a previous image',
'Imagick::identifyFormat' => 'Replaces any embedded formatting characters with the appropriate image property and returns the interpreted text. See https://www.imagemagick.org/script/escape.php for escape sequences.',
'imagick::identifyImage' => 'Identifies an image and fetches attributes',
'Imagick::identifyImageType' => 'Identifies the potential image type, returns one of the Imagick::IMGTYPE_* constants',
'imagick::implodeImage' => 'Creates a new image as a copy',
'imagick::importImagePixels' => 'Imports image pixels',
'Imagick::inverseFourierTransformImage' => 'Implements the inverse discrete Fourier transform (DFT) of the image either as a magnitude / phase or real / imaginary image pair.',
'imagick::labelImage' => 'Adds a label to an image',
'imagick::levelImage' => 'Adjusts the levels of an image',
'imagick::linearStretchImage' => 'Stretches with saturation the image intensity',
'imagick::liquidRescaleImage' => 'Animates an image or images',
'Imagick::listRegistry' => 'List all the registry settings. Returns an array of all the key/value pairs in the registry',
'Imagick::localContrastImage' => 'Attempts to increase the appearance of large-scale light-dark transitions.',
'imagick::magnifyImage' => 'Scales an image proportionally 2x',
'imagick::mapImage' => 'Replaces the colors of an image with the closest color from a reference image',
'imagick::matteFloodfillImage' => 'Changes the transparency value of a color',
'imagick::medianFilterImage' => 'Applies a digital filter',
'imagick::mergeImageLayers' => 'Merges image layers',
'imagick::minifyImage' => 'Scales an image proportionally to half its size',
'imagick::modulateImage' => 'Control the brightness, saturation, and hue',
'imagick::montageImage' => 'Creates a composite image',
'imagick::morphImages' => 'Method morphs a set of images',
'Imagick::morphology' => 'Applies a user supplied kernel to the image according to the given morphology method.',
'imagick::mosaicImages' => 'Forms a mosaic from images',
'imagick::motionBlurImage' => 'Simulates motion blur',
'imagick::negateImage' => 'Negates the colors in the reference image',
'imagick::newImage' => 'Creates a new image',
'imagick::newPseudoImage' => 'Creates a new image',
'imagick::nextImage' => 'Moves to the next image',
'imagick::normalizeImage' => 'Enhances the contrast of a color image',
'imagick::oilPaintImage' => 'Simulates an oil painting',
'imagick::opaquePaintImage' => 'Changes the color value of any pixel that matches target',
'imagick::optimizeImageLayers' => 'Removes repeated portions of images to optimize',
'imagick::orderedPosterizeImage' => 'Performs an ordered dither',
'imagick::paintFloodfillImage' => 'Changes the color value of any pixel that matches target',
'imagick::paintOpaqueImage' => 'Change any pixel that matches color',
'imagick::paintTransparentImage' => 'Changes any pixel that matches color with the color defined by fill',
'imagick::pingImage' => 'Fetch basic attributes about the image',
'imagick::pingImageBlob' => 'Quickly fetch attributes',
'imagick::pingImageFile' => 'Get basic image attributes in a lightweight manner',
'imagick::polaroidImage' => 'Simulates a Polaroid picture',
'imagick::posterizeImage' => 'Reduces the image to a limited number of color level',
'imagick::previewImages' => 'Quickly pin-point appropriate parameters for image processing',
'imagick::previousImage' => 'Move to the previous image in the object',
'imagick::profileImage' => 'Adds or removes a profile from an image',
'imagick::quantizeImage' => 'Analyzes the colors within a reference image',
'imagick::quantizeImages' => 'Analyzes the colors within a sequence of images',
'imagick::queryFontMetrics' => 'Returns an array representing the font metrics',
'imagick::queryFonts' => 'Returns the configured fonts',
'imagick::queryFormats' => 'Returns formats supported by Imagick',
'imagick::radialBlurImage' => 'Radial blurs an image',
'imagick::raiseImage' => 'Creates a simulated 3d button-like effect',
'imagick::randomThresholdImage' => 'Creates a high-contrast, two-color image',
'imagick::readImage' => 'Reads image from filename',
'imagick::readImageBlob' => 'Reads image from a binary string',
'imagick::readImageFile' => 'Reads image from open filehandle',
'imagick::recolorImage' => 'Recolors image',
'imagick::reduceNoiseImage' => 'Smooths the contours of an image',
'imagick::remapImage' => 'Remaps image colors',
'imagick::removeImage' => 'Removes an image from the image list',
'imagick::removeImageProfile' => 'Removes the named image profile and returns it',
'imagick::render' => 'Renders all preceding drawing commands',
'imagick::resampleImage' => 'Resample image to desired resolution',
'imagick::resetImagePage' => 'Reset image page',
'imagick::resizeImage' => 'Scales an image',
'imagick::rollImage' => 'Offsets an image',
'imagick::rotateImage' => 'Rotates an image',
'Imagick::rotationalBlurImage' => 'Rotational blurs an image.',
'imagick::roundCorners' => 'Rounds image corners',
'imagick::sampleImage' => 'Scales an image with pixel sampling',
'imagick::scaleImage' => 'Scales the size of an image',
'imagick::segmentImage' => 'Segments an image',
'Imagick::selectiveBlurImage' => 'Selectively blur an image within a contrast threshold. It is similar to the unsharpen mask that sharpens everything with contrast above a certain threshold.',
'imagick::separateImageChannel' => 'Separates a channel from the image',
'imagick::sepiaToneImage' => 'Sepia tones an image',
'Imagick::setAntiAlias' => 'Set whether antialiasing should be used for operations. On by default.',
'imagick::setBackgroundColor' => 'Sets the object\'s default background color',
'imagick::setColorspace' => 'Set colorspace',
'imagick::setCompression' => 'Sets the object\'s default compression type',
'imagick::setCompressionQuality' => 'Sets the object\'s default compression quality',
'imagick::setFilename' => 'Sets the filename before you read or write the image',
'imagick::setFirstIterator' => 'Sets the Imagick iterator to the first image',
'imagick::setFont' => 'Sets font',
'imagick::setFormat' => 'Sets the format of the Imagick object',
'imagick::setGravity' => 'Sets the gravity',
'imagick::setImage' => 'Replaces image in the object',
'Imagick::setImageAlpha' => 'Sets the image to the specified alpha level. Will replace ImagickDraw::setOpacity()',
'imagick::setImageAlphaChannel' => 'Sets image alpha channel',
'imagick::setImageArtifact' => 'Set image artifact',
'imagick::setImageBackgroundColor' => 'Sets the image background color',
'imagick::setImageBias' => 'Sets the image bias for any method that convolves an image',
'imagick::setImageBluePrimary' => 'Sets the image chromaticity blue primary point',
'imagick::setImageBorderColor' => 'Sets the image border color',
'imagick::setImageChannelDepth' => 'Sets the depth of a particular image channel',
'Imagick::setImageChannelMask' => 'Sets the image channel mask. Returns the previous set channel mask.
Only works with Imagick >=7',
'imagick::setImageClipMask' => 'Sets image clip mask',
'imagick::setImageColormapColor' => 'Sets the color of the specified colormap index',
'imagick::setImageColorspace' => 'Sets the image colorspace',
'imagick::setImageCompose' => 'Sets the image composite operator',
'imagick::setImageCompression' => 'Sets the image compression',
'imagick::setImageCompressionQuality' => 'Sets the image compression quality',
'imagick::setImageDelay' => 'Sets the image delay',
'imagick::setImageDepth' => 'Sets the image depth',
'imagick::setImageDispose' => 'Sets the image disposal method',
'imagick::setImageExtent' => 'Sets the image size',
'imagick::setImageFilename' => 'Sets the filename of a particular image',
'imagick::setImageFormat' => 'Sets the format of a particular image',
'imagick::setImageGamma' => 'Sets the image gamma',
'imagick::setImageGravity' => 'Sets the image gravity',
'imagick::setImageGreenPrimary' => 'Sets the image chromaticity green primary point',
'imagick::setImageIndex' => 'Set the iterator position',
'imagick::setImageInterlaceScheme' => 'Sets the image compression',
'imagick::setImageInterpolateMethod' => 'Sets the image interpolate pixel method',
'imagick::setImageIterations' => 'Sets the image iterations',
'imagick::setImageMatte' => 'Sets the image matte channel',
'imagick::setImageMatteColor' => 'Sets the image matte color',
'imagick::setImageOpacity' => 'Sets the image opacity level',
'imagick::setImageOrientation' => 'Sets the image orientation',
'imagick::setImagePage' => 'Sets the page geometry of the image',
'imagick::setImageProfile' => 'Adds a named profile to the Imagick object',
'imagick::setImageProperty' => 'Sets an image property',
'imagick::setImageRedPrimary' => 'Sets the image chromaticity red primary point',
'imagick::setImageRenderingIntent' => 'Sets the image rendering intent',
'imagick::setImageResolution' => 'Sets the image resolution',
'imagick::setImageScene' => 'Sets the image scene',
'imagick::setImageTicksPerSecond' => 'Sets the image ticks-per-second',
'imagick::setImageType' => 'Sets the image type',
'imagick::setImageUnits' => 'Sets the image units of resolution',
'imagick::setImageVirtualPixelMethod' => 'Sets the image virtual pixel method',
'imagick::setImageWhitePoint' => 'Sets the image chromaticity white point',
'imagick::setInterlaceScheme' => 'Sets the image compression',
'imagick::setIteratorIndex' => 'Set the iterator position',
'imagick::setLastIterator' => 'Sets the Imagick iterator to the last image',
'imagick::setOption' => 'Set an option',
'imagick::setPage' => 'Sets the page geometry of the Imagick object',
'imagick::setPointSize' => 'Sets point size',
'Imagick::setProgressMonitor' => 'Set a callback that will be called during the processing of the Imagick image.',
'Imagick::setRegistry' => 'Sets the ImageMagick registry entry named key to value. This is most useful for setting "temporary-path" which controls where ImageMagick creates temporary images e.g. while processing PDFs.',
'imagick::setResolution' => 'Sets the image resolution',
'imagick::setResourceLimit' => 'Sets the limit for a particular resource',
'imagick::setSamplingFactors' => 'Sets the image sampling factors',
'imagick::setSize' => 'Sets the size of the Imagick object',
'imagick::setSizeOffset' => 'Sets the size and offset of the Imagick object',
'imagick::setType' => 'Sets the image type attribute',
'imagick::shadeImage' => 'Creates a 3D effect',
'imagick::shadowImage' => 'Simulates an image shadow',
'imagick::sharpenImage' => 'Sharpens an image',
'imagick::shaveImage' => 'Shaves pixels from the image edges',
'imagick::shearImage' => 'Creating a parallelogram',
'imagick::sigmoidalContrastImage' => 'Adjusts the contrast of an image',
'Imagick::similarityImage' => 'Is an alias of Imagick::subImageMatch',
'imagick::sketchImage' => 'Simulates a pencil sketch',
'imagick::solarizeImage' => 'Applies a solarizing effect to the image',
'imagick::sparseColorImage' => 'Interpolates colors',
'imagick::spliceImage' => 'Splices a solid color into the image',
'imagick::spreadImage' => 'Randomly displaces each pixel in a block',
'Imagick::statisticImage' => 'Replace each pixel with corresponding statistic from the neighborhood of the specified width and height.',
'imagick::steganoImage' => 'Hides a digital watermark within the image',
'imagick::stereoImage' => 'Composites two images',
'imagick::stripImage' => 'Strips an image of all profiles and comments',
'Imagick::subImageMatch' => 'Searches for a subimage in the current image and returns a similarity image such that an exact match location is
completely white and if none of the pixels match, black, otherwise some gray level in-between.
You can also pass in the optional parameters bestMatch and similarity. After calling the function similarity will
be set to the \'score\' of the similarity between the subimage and the matching position in the larger image,
bestMatch will contain an associative array with elements x, y, width, height that describe the matching region.',
'imagick::swirlImage' => 'Swirls the pixels about the center of the image',
'imagick::textureImage' => 'Repeatedly tiles the texture image',
'imagick::thresholdImage' => 'Changes the value of individual pixels based on a threshold',
'imagick::thumbnailImage' => 'Changes the size of an image',
'imagick::tintImage' => 'Applies a color vector to each pixel in the image',
'imagick::transformImage' => 'Convenience method for setting crop size and the image geometry',
'imagick::transformImageColorspace' => 'Transforms an image to a new colorspace',
'imagick::transparentPaintImage' => 'Paints pixels transparent',
'imagick::transposeImage' => 'Creates a vertical mirror image',
'imagick::transverseImage' => 'Creates a horizontal mirror image',
'imagick::trimImage' => 'Remove edges from the image',
'imagick::uniqueImageColors' => 'Discards all but one of any pixel color',
'imagick::unsharpMaskImage' => 'Sharpens an image',
'imagick::valid' => 'Checks if the current item is valid',
'imagick::vignetteImage' => 'Adds vignette filter to the image',
'imagick::waveImage' => 'Applies wave filter to the image',
'imagick::whiteThresholdImage' => 'Force all pixels above the threshold into white',
'imagick::writeImage' => 'Writes an image to the specified filename',
'imagick::writeImageFile' => 'Writes an image to a filehandle',
'imagick::writeImages' => 'Writes an image or image sequence',
'imagick::writeImagesFile' => 'Writes frames to a filehandle',
'imagickdraw::__construct' => 'The ImagickDraw constructor',
'imagickdraw::affine' => 'Adjusts the current affine transformation matrix',
'imagickdraw::annotation' => 'Draws text on the image',
'imagickdraw::arc' => 'Draws an arc',
'imagickdraw::bezier' => 'Draws a bezier curve',
'imagickdraw::circle' => 'Draws a circle',
'imagickdraw::clear' => 'Clears the ImagickDraw',
'imagickdraw::clone' => 'Makes an exact copy of the specified ImagickDraw object',
'imagickdraw::color' => 'Draws color on image',
'imagickdraw::comment' => 'Adds a comment',
'imagickdraw::composite' => 'Composites an image onto the current image',
'imagickdraw::destroy' => 'Frees all associated resources',
'imagickdraw::ellipse' => 'Draws an ellipse on the image',
'ImagickDraw::getBorderColor' => 'Returns the border color used for drawing bordered objects.',
'imagickdraw::getClipPath' => 'Obtains the current clipping path ID',
'imagickdraw::getClipRule' => 'Returns the current polygon fill rule',
'imagickdraw::getClipUnits' => 'Returns the interpretation of clip path units',
'ImagickDraw::getDensity' => 'Obtains the vertical and horizontal resolution.',
'imagickdraw::getFillColor' => 'Returns the fill color',
'imagickdraw::getFillOpacity' => 'Returns the opacity used when drawing',
'imagickdraw::getFillRule' => 'Returns the fill rule',
'imagickdraw::getFont' => 'Returns the font',
'imagickdraw::getFontFamily' => 'Returns the font family',
'ImagickDraw::getFontResolution' => 'Gets the image X and Y resolution.',
'imagickdraw::getFontSize' => 'Returns the font pointsize',
'imagickdraw::getFontStyle' => 'Returns the font style',
'imagickdraw::getFontWeight' => 'Returns the font weight',
'imagickdraw::getGravity' => 'Returns the text placement gravity',
'ImagickDraw::getOpacity' => 'Returns the opacity used when drawing with the fill or stroke color or texture. Fully opaque is 1.0.',
'imagickdraw::getStrokeAntialias' => 'Returns the current stroke antialias setting',
'imagickdraw::getStrokeColor' => 'Returns the color used for stroking object outlines',
'imagickdraw::getStrokeDashArray' => 'Returns an array representing the pattern of dashes and gaps used to stroke paths',
'imagickdraw::getStrokeDashOffset' => 'Returns the offset into the dash pattern to start the dash',
'imagickdraw::getStrokeLineCap' => 'Returns the shape to be used at the end of open subpaths when they are stroked',
'imagickdraw::getStrokeLineJoin' => 'Returns the shape to be used at the corners of paths when they are stroked',
'imagickdraw::getStrokeMiterLimit' => 'Returns the stroke miter limit',
'imagickdraw::getStrokeOpacity' => 'Returns the opacity of stroked object outlines',
'imagickdraw::getStrokeWidth' => 'Returns the width of the stroke used to draw object outlines',
'imagickdraw::getTextAlignment' => 'Returns the text alignment',
'imagickdraw::getTextAntialias' => 'Returns the current text antialias setting',
'imagickdraw::getTextDecoration' => 'Returns the text decoration',
'ImagickDraw::getTextDirection' => 'Returns the direction that will be used when annotating with text.',
'imagickdraw::getTextEncoding' => 'Returns the code set used for text annotations',
'imagickdraw::getTextUnderColor' => 'Returns the text under color',
'imagickdraw::getVectorGraphics' => 'Returns a string containing vector graphics',
'imagickdraw::line' => 'Draws a line',
'imagickdraw::matte' => 'Paints on the image\'s opacity channel',
'imagickdraw::pathClose' => 'Adds a path element to the current path',
'imagickdraw::pathCurveToAbsolute' => 'Draws a cubic Bezier curve',
'imagickdraw::pathCurveToQuadraticBezierAbsolute' => 'Draws a quadratic Bezier curve',
'imagickdraw::pathCurveToQuadraticBezierRelative' => 'Draws a quadratic Bezier curve',
'imagickdraw::pathCurveToQuadraticBezierSmoothAbsolute' => 'Draws a quadratic Bezier curve',
'imagickdraw::pathCurveToQuadraticBezierSmoothRelative' => 'Draws a quadratic Bezier curve',
'imagickdraw::pathCurveToRelative' => 'Draws a cubic Bezier curve',
'imagickdraw::pathCurveToSmoothAbsolute' => 'Draws a cubic Bezier curve',
'imagickdraw::pathCurveToSmoothRelative' => 'Draws a cubic Bezier curve',
'imagickdraw::pathEllipticArcAbsolute' => 'Draws an elliptical arc',
'imagickdraw::pathEllipticArcRelative' => 'Draws an elliptical arc',
'imagickdraw::pathFinish' => 'Terminates the current path',
'imagickdraw::pathLineToAbsolute' => 'Draws a line path',
'imagickdraw::pathLineToHorizontalAbsolute' => 'Draws a horizontal line path',
'imagickdraw::pathLineToHorizontalRelative' => 'Draws a horizontal line',
'imagickdraw::pathLineToRelative' => 'Draws a line path',
'imagickdraw::pathLineToVerticalAbsolute' => 'Draws a vertical line',
'imagickdraw::pathLineToVerticalRelative' => 'Draws a vertical line path',
'imagickdraw::pathMoveToAbsolute' => 'Starts a new sub-path',
'imagickdraw::pathMoveToRelative' => 'Starts a new sub-path',
'imagickdraw::pathStart' => 'Declares the start of a path drawing list',
'imagickdraw::point' => 'Draws a point',
'imagickdraw::polygon' => 'Draws a polygon',
'imagickdraw::polyline' => 'Draws a polyline',
'imagickdraw::pop' => 'Destroys the current ImagickDraw in the stack, and returns to the previously pushed ImagickDraw',
'imagickdraw::popClipPath' => 'Terminates a clip path definition',
'imagickdraw::popDefs' => 'Terminates a definition list',
'imagickdraw::popPattern' => 'Terminates a pattern definition',
'imagickdraw::push' => 'Clones the current ImagickDraw and pushes it to the stack',
'imagickdraw::pushClipPath' => 'Starts a clip path definition',
'imagickdraw::pushDefs' => 'Indicates that following commands create named elements for early processing',
'imagickdraw::pushPattern' => 'Indicates that subsequent commands up to a ImagickDraw::opPattern() command comprise the definition of a named pattern',
'imagickdraw::rectangle' => 'Draws a rectangle',
'imagickdraw::render' => 'Renders all preceding drawing commands onto the image',
'imagickdraw::rotate' => 'Applies the specified rotation to the current coordinate space',
'imagickdraw::roundRectangle' => 'Draws a rounded rectangle',
'imagickdraw::scale' => 'Adjusts the scaling factor',
'ImagickDraw::setBorderColor' => 'Sets the border color to be used for drawing bordered objects.',
'imagickdraw::setClipPath' => 'Associates a named clipping path with the image',
'imagickdraw::setClipRule' => 'Set the polygon fill rule to be used by the clipping path',
'imagickdraw::setClipUnits' => 'Sets the interpretation of clip path units',
'ImagickDraw::setDensity' => 'Sets the vertical and horizontal resolution.',
'imagickdraw::setFillAlpha' => 'Sets the opacity to use when drawing using the fill color or fill texture',
'imagickdraw::setFillColor' => 'Sets the fill color to be used for drawing filled objects',
'imagickdraw::setFillOpacity' => 'Sets the opacity to use when drawing using the fill color or fill texture',
'imagickdraw::setFillPatternURL' => 'Sets the URL to use as a fill pattern for filling objects',
'imagickdraw::setFillRule' => 'Sets the fill rule to use while drawing polygons',
'imagickdraw::setFont' => 'Sets the fully-specified font to use when annotating with text',
'imagickdraw::setFontFamily' => 'Sets the font family to use when annotating with text',
'ImagickDraw::setFontResolution' => 'Sets the image font resolution.',
'imagickdraw::setFontSize' => 'Sets the font pointsize to use when annotating with text',
'imagickdraw::setFontStretch' => 'Sets the font stretch to use when annotating with text',
'imagickdraw::setFontStyle' => 'Sets the font style to use when annotating with text',
'imagickdraw::setFontWeight' => 'Sets the font weight',
'imagickdraw::setGravity' => 'Sets the text placement gravity',
'ImagickDraw::setOpacity' => 'Sets the opacity to use when drawing using the fill or stroke color or texture. Fully opaque is 1.0.',
'imagickdraw::setStrokeAlpha' => 'Specifies the opacity of stroked object outlines',
'imagickdraw::setStrokeAntialias' => 'Controls whether stroked outlines are antialiased',
'imagickdraw::setStrokeColor' => 'Sets the color used for stroking object outlines',
'imagickdraw::setStrokeDashArray' => 'Specifies the pattern of dashes and gaps used to stroke paths',
'imagickdraw::setStrokeDashOffset' => 'Specifies the offset into the dash pattern to start the dash',
'imagickdraw::setStrokeLineCap' => 'Specifies the shape to be used at the end of open subpaths when they are stroked',
'imagickdraw::setStrokeLineJoin' => 'Specifies the shape to be used at the corners of paths when they are stroked',
'imagickdraw::setStrokeMiterLimit' => 'Specifies the miter limit',
'imagickdraw::setStrokeOpacity' => 'Specifies the opacity of stroked object outlines',
'imagickdraw::setStrokePatternURL' => 'Sets the pattern used for stroking object outlines',
'imagickdraw::setStrokeWidth' => 'Sets the width of the stroke used to draw object outlines',
'imagickdraw::setTextAlignment' => 'Specifies a text alignment',
'imagickdraw::setTextAntialias' => 'Controls whether text is antialiased',
'imagickdraw::setTextDecoration' => 'Specifies a decoration',
'ImagickDraw::setTextDirection' => 'Sets the font style to use when annotating with text. The AnyStyle enumeration acts as a wild-card "don\'t care" option.',
'imagickdraw::setTextEncoding' => 'Specifies the text code set',
'imagickdraw::setTextUnderColor' => 'Specifies the color of a background rectangle',
'imagickdraw::setVectorGraphics' => 'Sets the vector graphics',
'imagickdraw::setViewbox' => 'Sets the overall canvas size',
'imagickdraw::skewX' => 'Skews the current coordinate system in the horizontal direction',
'imagickdraw::skewY' => 'Skews the current coordinate system in the vertical direction',
'imagickdraw::translate' => 'Applies a translation to the current coordinate system',
'ImagickKernel::addKernel' => 'Attach another kernel to this kernel to allow them to both be applied in a single morphology or filter function. Returns the new combined kernel.',
'ImagickKernel::addUnityKernel' => 'Adds a given amount of the \'Unity\' Convolution Kernel to the given pre-scaled and normalized Kernel. This in effect adds that amount of the original image into the resulting convolution kernel. The resulting effect is to convert the defined kernels into blended soft-blurs, unsharp kernels or into sharpening kernels.',
'ImagickKernel::fromBuiltin' => 'Create a kernel from a builtin in kernel. See https://www.imagemagick.org/Usage/morphology/#kernel for examples.<br>
Currently the \'rotation\' symbols are not supported. Example: $diamondKernel = ImagickKernel::fromBuiltIn(\Imagick::KERNEL_DIAMOND, "2");',
'ImagickKernel::fromMatrix' => 'Create a kernel from a builtin in kernel. See https://www.imagemagick.org/Usage/morphology/#kernel for examples.<br>
Currently the \'rotation\' symbols are not supported. Example: $diamondKernel = ImagickKernel::fromBuiltIn(\Imagick::KERNEL_DIAMOND, "2");',
'ImagickKernel::getMatrix' => 'Get the 2d matrix of values used in this kernel. The elements are either float for elements that are used or \'false\' if the element should be skipped.',
'ImagickKernel::scale' => 'ScaleKernelInfo() scales the given kernel list by the given amount, with or without normalization of the sum of the kernel values (as per given flags).<br>
The exact behaviour of this function depends on the normalization type being used please see https://www.imagemagick.org/api/morphology.php#ScaleKernelInfo for details.<br>
Flag should be one of Imagick::NORMALIZE_KERNEL_VALUE, Imagick::NORMALIZE_KERNEL_CORRELATE, Imagick::NORMALIZE_KERNEL_PERCENT or not set.',
'ImagickKernel::seperate' => 'Separates a linked set of kernels and returns an array of ImagickKernels.',
'imagickpixel::__construct' => 'The ImagickPixel constructor',
'imagickpixel::clear' => 'Clears resources associated with this object',
'imagickpixel::destroy' => 'Deallocates resources associated with this object',
'imagickpixel::getColor' => 'Returns the color',
'imagickpixel::getColorAsString' => 'Returns the color as a string',
'imagickpixel::getColorCount' => 'Returns the color count associated with this color',
'ImagickPixel::getColorQuantum' => 'Returns the color of the pixel in an array as Quantum values. If ImageMagick was compiled as HDRI these will be floats, otherwise they will be integers.',
'imagickpixel::getColorValue' => 'Gets the normalized value of the provided color channel',
'imagickpixel::getHSL' => 'Returns the normalized HSL color of the ImagickPixel object',
'imagickpixel::isPixelSimilar' => 'Check the distance between this color and another',
'ImagickPixel::isPixelSimilarQuantum' => 'Returns true if the distance between two colors is less than the specified distance. The fuzz value should be in the range 0-QuantumRange.<br>
The maximum value represents the longest possible distance in the colorspace. e.g. from RGB(0, 0, 0) to RGB(255, 255, 255) for the RGB colorspace',
'imagickpixel::isSimilar' => 'Check the distance between this color and another',
'imagickpixel::setColor' => 'Sets the color',
'ImagickPixel::setColorFromPixel' => 'Sets the color count associated with this color from another ImagickPixel object.',
'imagickpixel::setColorValue' => 'Sets the normalized value of one of the channels',
'imagickpixel::setHSL' => 'Sets the normalized HSL color',
'imagickpixeliterator::__construct' => 'The ImagickPixelIterator constructor',
'imagickpixeliterator::clear' => 'Clear resources associated with a PixelIterator',
'imagickpixeliterator::destroy' => 'Deallocates resources associated with a PixelIterator',
'imagickpixeliterator::getCurrentIteratorRow' => 'Returns the current row of ImagickPixel objects',
'imagickpixeliterator::getIteratorRow' => 'Returns the current pixel iterator row',
'imagickpixeliterator::getNextIteratorRow' => 'Returns the next row of the pixel iterator',
'imagickpixeliterator::getPreviousIteratorRow' => 'Returns the previous row',
'imagickpixeliterator::newPixelIterator' => 'Returns a new pixel iterator',
'imagickpixeliterator::newPixelRegionIterator' => 'Returns a new pixel iterator',
'imagickpixeliterator::resetIterator' => 'Resets the pixel iterator',
'imagickpixeliterator::setIteratorFirstRow' => 'Sets the pixel iterator to the first pixel row',
'imagickpixeliterator::setIteratorLastRow' => 'Sets the pixel iterator to the last pixel row',
'imagickpixeliterator::setIteratorRow' => 'Set the pixel iterator row',
'imagickpixeliterator::syncIterator' => 'Syncs the pixel iterator',
'imap_8bit' => 'Convert an 8bit string to a quoted-printable string',
'imap_alerts' => 'Returns all IMAP alert messages that have occurred',
'imap_append' => 'Append a string message to a specified mailbox',
'imap_base64' => 'Decode BASE64 encoded text',
'imap_binary' => 'Convert an 8bit string to a base64 string',
'imap_body' => 'Read the message body',
'imap_bodystruct' => 'Read the structure of a specified body section of a specific message',
'imap_check' => 'Check current mailbox',
'imap_clearflag_full' => 'Clears flags on messages',
'imap_close' => 'Close an IMAP stream',
'imap_create' => 'Alias of imap_createmailbox',
'imap_createmailbox' => 'Create a new mailbox',
'imap_delete' => 'Mark a message for deletion from current mailbox',
'imap_deletemailbox' => 'Delete a mailbox',
'imap_errors' => 'Returns all of the IMAP errors that have occurred',
'imap_expunge' => 'Delete all messages marked for deletion',
'imap_fetch_overview' => 'Read an overview of the information in the headers of the given message',
'imap_fetchbody' => 'Fetch a particular section of the body of the message',
'imap_fetchheader' => 'Returns header for a message',
'imap_fetchmime' => 'Fetch MIME headers for a particular section of the message',
'imap_fetchstructure' => 'Read the structure of a particular message',
'imap_fetchtext' => 'Alias of imap_body',
'imap_gc' => 'Clears IMAP cache',
'imap_get_quota' => 'Retrieve the quota level settings, and usage statics per mailbox',
'imap_get_quotaroot' => 'Retrieve the quota settings per user',
'imap_getacl' => 'Gets the ACL for a given mailbox',
'imap_getmailboxes' => 'Read the list of mailboxes, returning detailed information on each one',
'imap_getsubscribed' => 'List all the subscribed mailboxes',
'imap_header' => 'Alias of imap_headerinfo',
'imap_headerinfo' => 'Read the header of the message',
'imap_headers' => 'Returns headers for all messages in a mailbox',
'imap_last_error' => 'Gets the last IMAP error that occurred during this page request',
'imap_list' => 'Read the list of mailboxes',
'imap_listmailbox' => 'Alias of imap_list',
'imap_listscan' => 'Returns the list of mailboxes that matches the given text',
'imap_listsubscribed' => 'Alias of imap_lsub',
'imap_lsub' => 'List all the subscribed mailboxes',
'imap_mail' => 'Send an email message',
'imap_mail_compose' => 'Create a MIME message based on given envelope and body sections',
'imap_mail_copy' => 'Copy specified messages to a mailbox',
'imap_mail_move' => 'Move specified messages to a mailbox',
'imap_mailboxmsginfo' => 'Get information about the current mailbox',
'imap_mime_header_decode' => 'Decode MIME header elements',
'imap_msgno' => 'Gets the message sequence number for the given UID',
'imap_mutf7_to_utf8' => 'Decode a modified UTF-7 string to UTF-8',
'imap_num_msg' => 'Gets the number of messages in the current mailbox',
'imap_num_recent' => 'Gets the number of recent messages in current mailbox',
'imap_open' => 'Open an IMAP stream to a mailbox',
'imap_ping' => 'Check if the IMAP stream is still active',
'imap_qprint' => 'Convert a quoted-printable string to an 8 bit string',
'imap_rename' => 'Alias of imap_renamemailbox',
'imap_renamemailbox' => 'Rename an old mailbox to new mailbox',
'imap_reopen' => 'Reopen IMAP stream to new mailbox',
'imap_rfc822_parse_adrlist' => 'Parses an address string',
'imap_rfc822_parse_headers' => 'Parse mail headers from a string',
'imap_rfc822_write_address' => 'Returns a properly formatted email address given the mailbox, host, and personal info',
'imap_savebody' => 'Save a specific body section to a file',
'imap_scan' => 'Alias of imap_listscan',
'imap_scanmailbox' => 'Alias of imap_listscan',
'imap_search' => 'This function returns an array of messages matching the given search criteria',
'imap_set_quota' => 'Sets a quota for a given mailbox',
'imap_setacl' => 'Sets the ACL for a given mailbox',
'imap_setflag_full' => 'Sets flags on messages',
'imap_sort' => 'Gets and sort messages',
'imap_status' => 'Returns status information on a mailbox',
'imap_subscribe' => 'Subscribe to a mailbox',
'imap_thread' => 'Returns a tree of threaded message',
'imap_timeout' => 'Set or fetch imap timeout',
'imap_uid' => 'This function returns the UID for the given message sequence number',
'imap_undelete' => 'Unmark the message which is marked deleted',
'imap_unsubscribe' => 'Unsubscribe from a mailbox',
'imap_utf7_decode' => 'Decodes a modified UTF-7 encoded string',
'imap_utf7_encode' => 'Converts ISO-8859-1 string to modified UTF-7 text',
'imap_utf8' => 'Converts MIME-encoded text to UTF-8',
'imap_utf8_to_mutf7' => 'Encode a UTF-8 string to modified UTF-7',
'implode' => 'Join array elements with a string',
'import_request_variables' => 'Import GET/POST/Cookie variables into the global scope',
'in_array' => 'Checks if a value exists in an array',
'inclued_get_data' => 'Get the inclued data',
'inet_ntop' => 'Converts a packed internet address to a human readable representation',
'inet_pton' => 'Converts a human readable IP address to its packed in_addr representation',
'infiniteiterator::__construct' => 'Constructs an InfiniteIterator',
'InfiniteIterator::current' => 'Get the current value',
'InfiniteIterator::getInnerIterator' => 'Get the inner iterator',
'InfiniteIterator::key' => 'Get the key of the current element',
'infiniteiterator::next' => 'Moves the inner Iterator forward or rewinds it',
'InfiniteIterator::rewind' => 'Rewind to the first element',
'InfiniteIterator::valid' => 'Checks if the iterator is valid',
'inflate_add' => 'Incrementally inflate encoded data',
'inflate_get_read_len' => 'Get number of bytes read so far',
'inflate_get_status' => 'Get decompression status',
'inflate_init' => 'Initialize an incremental inflate context',
'ingres_autocommit' => 'Switch autocommit on or off',
'ingres_autocommit_state' => 'Test if the connection is using autocommit',
'ingres_charset' => 'Returns the installation character set',
'ingres_close' => 'Close an Ingres database connection',
'ingres_commit' => 'Commit a transaction',
'ingres_connect' => 'Open a connection to an Ingres database',
'ingres_cursor' => 'Get a cursor name for a given result resource',
'ingres_errno' => 'Get the last Ingres error number generated',
'ingres_error' => 'Get a meaningful error message for the last error generated',
'ingres_errsqlstate' => 'Get the last SQLSTATE error code generated',
'ingres_escape_string' => 'Escape special characters for use in a query',
'ingres_execute' => 'Execute a prepared query',
'ingres_fetch_array' => 'Fetch a row of result into an array',
'ingres_fetch_assoc' => 'Fetch a row of result into an associative array',
'ingres_fetch_object' => 'Fetch a row of result into an object',
'ingres_fetch_proc_return' => 'Get the return value from a procedure call',
'ingres_fetch_row' => 'Fetch a row of result into an enumerated array',
'ingres_field_length' => 'Get the length of a field',
'ingres_field_name' => 'Get the name of a field in a query result',
'ingres_field_nullable' => 'Test if a field is nullable',
'ingres_field_precision' => 'Get the precision of a field',
'ingres_field_scale' => 'Get the scale of a field',
'ingres_field_type' => 'Get the type of a field in a query result',
'ingres_free_result' => 'Free the resources associated with a result identifier',
'ingres_next_error' => 'Get the next Ingres error',
'ingres_num_fields' => 'Get the number of fields returned by the last query',
'ingres_num_rows' => 'Get the number of rows affected or returned by a query',
'ingres_pconnect' => 'Open a persistent connection to an Ingres database',
'ingres_prepare' => 'Prepare a query for later execution',
'ingres_query' => 'Send an SQL query to Ingres',
'ingres_result_seek' => 'Set the row position before fetching data',
'ingres_rollback' => 'Roll back a transaction',
'ingres_set_environment' => 'Set environment features controlling output options',
'ingres_unbuffered_query' => 'Send an unbuffered SQL query to Ingres',
'ini_alter' => 'Alias of ini_set',
'ini_get' => 'Gets the value of a configuration option',
'ini_get_all' => 'Gets all configuration options',
'ini_restore' => 'Restores the value of a configuration option',
'ini_set' => 'Sets the value of a configuration option',
'inotify_add_watch' => 'Add a watch to an initialized inotify instance',
'inotify_init' => 'Initialize an inotify instance',
'inotify_queue_len' => 'Return a number upper than zero if there are pending events',
'inotify_read' => 'Read events from an inotify instance',
'inotify_rm_watch' => 'Remove an existing watch from an inotify instance',
'intcal_get_maximum' => '(PHP 5 &gt;=5.5.0 PECL intl &gt;= 3.0.0a1)<br/>
Get the global maximum value for a field',
'intdiv' => 'Integer division',
'interface_exists' => 'Checks if the interface has been defined',
'intl_get' => '(PHP 5 &gt;=5.5.0 PECL intl &gt;= 3.0.0a1)<br/>
Get the value for a field',
'intlbreakiterator::__construct' => 'Private constructor for disallowing instantiation',
'intlbreakiterator::createCharacterInstance' => 'Create break iterator for boundaries of combining character sequences',
'intlbreakiterator::createCodePointInstance' => 'Create break iterator for boundaries of code points',
'intlbreakiterator::createLineInstance' => 'Create break iterator for logically possible line breaks',
'intlbreakiterator::createSentenceInstance' => 'Create break iterator for sentence breaks',
'intlbreakiterator::createTitleInstance' => 'Create break iterator for title-casing breaks',
'intlbreakiterator::createWordInstance' => 'Create break iterator for word breaks',
'intlbreakiterator::current' => 'Get index of current position',
'intlbreakiterator::first' => 'Set position to the first character in the text',
'intlbreakiterator::following' => 'Advance the iterator to the first boundary following specified offset',
'intlbreakiterator::getErrorCode' => 'Get last error code on the object',
'intlbreakiterator::getErrorMessage' => 'Get last error message on the object',
'intlbreakiterator::getLocale' => 'Get the locale associated with the object',
'intlbreakiterator::getPartsIterator' => 'Create iterator for navigating fragments between boundaries',
'intlbreakiterator::getText' => 'Get the text being scanned',
'intlbreakiterator::isBoundary' => 'Tell whether an offset is a boundaryʼs offset',
'intlbreakiterator::last' => 'Set the iterator position to index beyond the last character',
'intlbreakiterator::next' => 'Advance the iterator the next boundary',
'intlbreakiterator::preceding' => 'Set the iterator position to the first boundary before an offset',
'intlbreakiterator::previous' => 'Set the iterator position to the boundary immediately before the current',
'intlbreakiterator::setText' => 'Set the text being scanned',
'intlcal_greates_minimum' => '(PHP 5 &gt;=5.5.0 PECL intl &gt;= 3.0.0a1)<br/>
Get the largest local minimum value for a field',
'intlcalendar::__construct' => 'Private constructor for disallowing instantiation',
'intlcalendar::add' => 'Add a (signed) amount of time to a field',
'intlcalendar::after' => 'Whether this objectʼs time is after that of the passed object',
'intlcalendar::before' => 'Whether this objectʼs time is before that of the passed object',
'intlcalendar::clear' => 'Clear a field or all fields',
'intlcalendar::createInstance' => 'Create a new IntlCalendar',
'intlcalendar::equals' => 'Compare time of two IntlCalendar objects for equality',
'intlcalendar::fieldDifference' => 'Calculate difference between given time and this objectʼs time',
'intlcalendar::fromDateTime' => 'Create an IntlCalendar from a DateTime object or string',
'intlcalendar::get' => 'Get the value for a field',
'intlcalendar::getActualMaximum' => 'The maximum value for a field, considering the objectʼs current time',
'intlcalendar::getActualMinimum' => 'The minimum value for a field, considering the objectʼs current time',
'intlcalendar::getAvailableLocales' => 'Get array of locales for which there is data',
'intlcalendar::getDayOfWeekType' => 'Tell whether a day is a weekday, weekend or a day that has a transition between the two',
'intlcalendar::getErrorCode' => 'Get last error code on the object',
'intlcalendar::getErrorMessage' => 'Get last error message on the object',
'intlcalendar::getFirstDayOfWeek' => 'Get the first day of the week for the calendarʼs locale',
'intlcalendar::getGreatestMinimum' => 'Get the largest local minimum value for a field',
'intlcalendar::getKeywordValuesForLocale' => 'Get set of locale keyword values',
'intlcalendar::getLeastMaximum' => 'Get the smallest local maximum for a field',
'intlcalendar::getLocale' => 'Get the locale associated with the object',
'intlcalendar::getMaximum' => 'Get the global maximum value for a field',
'intlcalendar::getMinimalDaysInFirstWeek' => 'Get minimal number of days the first week in a year or month can have',
'intlcalendar::getMinimum' => 'Get the global minimum value for a field',
'intlcalendar::getNow' => 'Get number representing the current time',
'intlcalendar::getRepeatedWallTimeOption' => 'Get behavior for handling repeating wall time',
'intlcalendar::getSkippedWallTimeOption' => 'Get behavior for handling skipped wall time',
'intlcalendar::getTime' => 'Get time currently represented by the object',
'intlcalendar::getTimeZone' => 'Get the objectʼs timezone',
'intlcalendar::getType' => 'Get the calendar type',
'intlcalendar::getWeekendTransition' => 'Get time of the day at which weekend begins or ends',
'intlcalendar::inDaylightTime' => 'Whether the objectʼs time is in Daylight Savings Time',
'intlcalendar::isEquivalentTo' => 'Whether another calendar is equal but for a different time',
'intlcalendar::isLenient' => 'Whether date/time interpretation is in lenient mode',
'intlcalendar::isSet' => 'Whether a field is set',
'intlcalendar::isWeekend' => 'Whether a certain date/time is in the weekend',
'intlcalendar::roll' => 'Add value to field without carrying into more significant fields',
'intlcalendar::set' => 'Set a time field or several common fields at once',
'intlcalendar::setFirstDayOfWeek' => 'Set the day on which the week is deemed to start',
'intlcalendar::setLenient' => 'Set whether date/time interpretation is to be lenient',
'intlcalendar::setMinimalDaysInFirstWeek' => 'Set minimal number of days the first week in a year or month can have',
'intlcalendar::setRepeatedWallTimeOption' => 'Set behavior for handling repeating wall times at negative timezone offset transitions',
'intlcalendar::setSkippedWallTimeOption' => 'Set behavior for handling skipped wall times at positive timezone offset transitions',
'intlcalendar::setTime' => 'Set the calendar time in milliseconds since the epoch',
'intlcalendar::setTimeZone' => 'Set the timezone used by this calendar',
'intlcalendar::toDateTime' => 'Convert an IntlCalendar into a DateTime object',
'intlchar::charAge' => 'Get the "age" of the code point',
'intlchar::charDigitValue' => 'Get the decimal digit value of a decimal digit character',
'intlchar::charDirection' => 'Get bidirectional category value for a code point',
'intlchar::charFromName' => 'Find Unicode character by name and return its code point value',
'intlchar::charMirror' => 'Get the "mirror-image" character for a code point',
'intlchar::charName' => 'Retrieve the name of a Unicode character',
'intlchar::charType' => 'Get the general category value for a code point',
'intlchar::chr' => 'Return Unicode character by code point value',
'intlchar::digit' => 'Get the decimal digit value of a code point for a given radix',
'intlchar::enumCharNames' => 'Enumerate all assigned Unicode characters within a range',
'intlchar::enumCharTypes' => 'Enumerate all code points with their Unicode general categories',
'intlchar::foldCase' => 'Perform case folding on a code point',
'intlchar::forDigit' => 'Get character representation for a given digit and radix',
'intlchar::getBidiPairedBracket' => 'Get the paired bracket character for a code point',
'intlchar::getBlockCode' => 'Get the Unicode allocation block containing a code point',
'intlchar::getCombiningClass' => 'Get the combining class of a code point',
'intlchar::getFC_NFKC_Closure' => 'Get the FC_NFKC_Closure property for a code point',
'intlchar::getIntPropertyMaxValue' => 'Get the max value for a Unicode property',
'intlchar::getIntPropertyMinValue' => 'Get the min value for a Unicode property',
'intlchar::getIntPropertyValue' => 'Get the value for a Unicode property for a code point',
'intlchar::getNumericValue' => 'Get the numeric value for a Unicode code point',
'intlchar::getPropertyEnum' => 'Get the property constant value for a given property name',
'intlchar::getPropertyName' => 'Get the Unicode name for a property',
'intlchar::getPropertyValueEnum' => 'Get the property value for a given value name',
'intlchar::getPropertyValueName' => 'Get the Unicode name for a property value',
'intlchar::getUnicodeVersion' => 'Get the Unicode version',
'intlchar::hasBinaryProperty' => 'Check a binary Unicode property for a code point',
'intlchar::isalnum' => 'Check if code point is an alphanumeric character',
'intlchar::isalpha' => 'Check if code point is a letter character',
'intlchar::isbase' => 'Check if code point is a base character',
'intlchar::isblank' => 'Check if code point is a "blank" or "horizontal space" character',
'intlchar::iscntrl' => 'Check if code point is a control character',
'intlchar::isdefined' => 'Check whether the code point is defined',
'intlchar::isdigit' => 'Check if code point is a digit character',
'intlchar::isgraph' => 'Check if code point is a graphic character',
'intlchar::isIDIgnorable' => 'Check if code point is an ignorable character',
'intlchar::isIDPart' => 'Check if code point is permissible in an identifier',
'intlchar::isIDStart' => 'Check if code point is permissible as the first character in an identifier',
'intlchar::isISOControl' => 'Check if code point is an ISO control code',
'intlchar::isJavaIDPart' => 'Check if code point is permissible in a Java identifier',
'intlchar::isJavaIDStart' => 'Check if code point is permissible as the first character in a Java identifier',
'intlchar::isJavaSpaceChar' => 'Check if code point is a space character according to Java',
'intlchar::islower' => 'Check if code point is a lowercase letter',
'intlchar::isMirrored' => 'Check if code point has the Bidi_Mirrored property',
'intlchar::isprint' => 'Check if code point is a printable character',
'intlchar::ispunct' => 'Check if code point is punctuation character',
'intlchar::isspace' => 'Check if code point is a space character',
'intlchar::istitle' => 'Check if code point is a titlecase letter',
'intlchar::isUAlphabetic' => 'Check if code point has the Alphabetic Unicode property',
'intlchar::isULowercase' => 'Check if code point has the Lowercase Unicode property',
'intlchar::isupper' => 'Check if code point has the general category "Lu" (uppercase letter)',
'intlchar::isUUppercase' => 'Check if code point has the Uppercase Unicode property',
'intlchar::isUWhiteSpace' => 'Check if code point has the White_Space Unicode property',
'intlchar::isWhitespace' => 'Check if code point is a whitespace character according to ICU',
'intlchar::isxdigit' => 'Check if code point is a hexadecimal digit',
'intlchar::ord' => 'Return Unicode code point value of character',
'intlchar::tolower' => 'Make Unicode character lowercase',
'intlchar::totitle' => 'Make Unicode character titlecase',
'intlchar::toupper' => 'Make Unicode character uppercase',
'IntlCodePointBreakIterator::createCharacterInstance' => 'Create break iterator for boundaries of combining character sequences',
'IntlCodePointBreakIterator::createCodePointInstance' => 'Create break iterator for boundaries of code points',
'IntlCodePointBreakIterator::createLineInstance' => 'Create break iterator for logically possible line breaks',
'IntlCodePointBreakIterator::createSentenceInstance' => 'Create break iterator for sentence breaks',
'IntlCodePointBreakIterator::createTitleInstance' => 'Create break iterator for title-casing breaks',
'IntlCodePointBreakIterator::createWordInstance' => 'Create break iterator for word breaks',
'IntlCodePointBreakIterator::current' => 'Get index of current position',
'IntlCodePointBreakIterator::first' => 'Set position to the first character in the text',
'IntlCodePointBreakIterator::following' => 'Advance the iterator to the first boundary following specified offset',
'IntlCodePointBreakIterator::getErrorCode' => 'Get last error code on the object',
'IntlCodePointBreakIterator::getErrorMessage' => 'Get last error message on the object',
'intlcodepointbreakiterator::getLastCodePoint' => 'Get last code point passed over after advancing or receding the iterator',
'IntlCodePointBreakIterator::getLocale' => 'Get the locale associated with the object',
'IntlCodePointBreakIterator::getPartsIterator' => 'Create iterator for navigating fragments between boundaries',
'IntlCodePointBreakIterator::getText' => 'Get the text being scanned',
'IntlCodePointBreakIterator::isBoundary' => 'Tell whether an offset is a boundaryʼs offset',
'IntlCodePointBreakIterator::last' => 'Set the iterator position to index beyond the last character',
'IntlCodePointBreakIterator::next' => 'Advance the iterator the next boundary',
'IntlCodePointBreakIterator::preceding' => 'Set the iterator position to the first boundary before an offset',
'IntlCodePointBreakIterator::previous' => 'Set the iterator position to the boundary immediately before the current',
'IntlCodePointBreakIterator::setText' => 'Set the text being scanned',
'IntlDateFormatter::create' => 'Create a date formatter',
'intldateformatter::format' => 'Format the date/time value as a string',
'intldateformatter::formatObject' => 'Formats an object',
'intldateformatter::getCalendar' => 'Get the calendar type used for the IntlDateFormatter',
'intldateformatter::getCalendarObject' => 'Get copy of formatterʼs calendar object',
'intldateformatter::getDateType' => 'Get the datetype used for the IntlDateFormatter',
'intldateformatter::getErrorCode' => 'Get the error code from last operation',
'intldateformatter::getErrorMessage' => 'Get the error text from the last operation',
'intldateformatter::getLocale' => 'Get the locale used by formatter',
'intldateformatter::getPattern' => 'Get the pattern used for the IntlDateFormatter',
'intldateformatter::getTimeType' => 'Get the timetype used for the IntlDateFormatter',
'intldateformatter::getTimeZone' => 'Get formatterʼs timezone',
'intldateformatter::getTimeZoneId' => 'Get the timezone-id used for the IntlDateFormatter',
'intldateformatter::isLenient' => 'Get the lenient used for the IntlDateFormatter',
'intldateformatter::localtime' => 'Parse string to a field-based time value',
'intldateformatter::parse' => 'Parse string to a timestamp value',
'intldateformatter::setCalendar' => 'Sets the calendar type used by the formatter',
'intldateformatter::setLenient' => 'Set the leniency of the parser',
'intldateformatter::setPattern' => 'Set the pattern used for the IntlDateFormatter',
'intldateformatter::setTimeZone' => 'Sets formatterʼs timezone',
'intldateformatter::setTimeZoneId' => 'Sets the time zone to use',
'IntlException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'IntlException::__toString' => 'String representation of the exception',
'IntlException::getCode' => 'Gets the Exception code',
'IntlException::getFile' => 'Gets the file in which the exception occurred',
'IntlException::getLine' => 'Gets the line in which the exception occurred',
'IntlException::getMessage' => 'Gets the Exception message',
'IntlException::getPrevious' => 'Returns previous Exception',
'IntlException::getTrace' => 'Gets the stack trace',
'IntlException::getTraceAsString' => 'Gets the stack trace as a string',
'intlgregoriancalendar::__construct' => 'Create the Gregorian Calendar class',
'IntlGregorianCalendar::add' => 'Add a (signed) amount of time to a field',
'IntlGregorianCalendar::after' => 'Whether this objectʼs time is after that of the passed object',
'IntlGregorianCalendar::before' => 'Whether this objectʼs time is before that of the passed object',
'IntlGregorianCalendar::clear' => 'Clear a field or all fields',
'IntlGregorianCalendar::createInstance' => 'Create a new IntlCalendar',
'IntlGregorianCalendar::equals' => 'Compare time of two IntlCalendar objects for equality',
'IntlGregorianCalendar::fieldDifference' => 'Calculate difference between given time and this objectʼs time',
'IntlGregorianCalendar::fromDateTime' => 'Create an IntlCalendar from a DateTime object or string',
'IntlGregorianCalendar::get' => 'Get the value for a field',
'IntlGregorianCalendar::getActualMaximum' => 'The maximum value for a field, considering the objectʼs current time',
'IntlGregorianCalendar::getActualMinimum' => 'The minimum value for a field, considering the objectʼs current time',
'IntlGregorianCalendar::getAvailableLocales' => 'Get array of locales for which there is data',
'IntlGregorianCalendar::getDayOfWeekType' => 'Tell whether a day is a weekday, weekend or a day that has a transition between the two',
'IntlGregorianCalendar::getErrorCode' => 'Get last error code on the object',
'IntlGregorianCalendar::getErrorMessage' => 'Get last error message on the object',
'IntlGregorianCalendar::getFirstDayOfWeek' => 'Get the first day of the week for the calendarʼs locale',
'IntlGregorianCalendar::getGreatestMinimum' => 'Get the largest local minimum value for a field',
'intlgregoriancalendar::getGregorianChange' => 'Get the Gregorian Calendar change date',
'IntlGregorianCalendar::getKeywordValuesForLocale' => 'Get set of locale keyword values',
'IntlGregorianCalendar::getLeastMaximum' => 'Get the smallest local maximum for a field',
'IntlGregorianCalendar::getLocale' => 'Get the locale associated with the object',
'IntlGregorianCalendar::getMaximum' => 'Get the global maximum value for a field',
'IntlGregorianCalendar::getMinimalDaysInFirstWeek' => 'Get minimal number of days the first week in a year or month can have',
'IntlGregorianCalendar::getMinimum' => 'Get the global minimum value for a field',
'IntlGregorianCalendar::getNow' => 'Get number representing the current time',
'IntlGregorianCalendar::getRepeatedWallTimeOption' => 'Get behavior for handling repeating wall time',
'IntlGregorianCalendar::getSkippedWallTimeOption' => 'Get behavior for handling skipped wall time',
'IntlGregorianCalendar::getTime' => 'Get time currently represented by the object',
'IntlGregorianCalendar::getTimeZone' => 'Get the objectʼs timezone',
'IntlGregorianCalendar::getType' => 'Get the calendar type',
'IntlGregorianCalendar::getWeekendTransition' => 'Get time of the day at which weekend begins or ends',
'IntlGregorianCalendar::inDaylightTime' => 'Whether the objectʼs time is in Daylight Savings Time',
'IntlGregorianCalendar::isEquivalentTo' => 'Whether another calendar is equal but for a different time',
'intlgregoriancalendar::isLeapYear' => 'Determine if the given year is a leap year',
'IntlGregorianCalendar::isLenient' => 'Whether date/time interpretation is in lenient mode',
'IntlGregorianCalendar::isSet' => 'Whether a field is set',
'IntlGregorianCalendar::isWeekend' => 'Whether a certain date/time is in the weekend',
'IntlGregorianCalendar::roll' => 'Add value to field without carrying into more significant fields',
'IntlGregorianCalendar::set' => 'Set a time field or several common fields at once',
'IntlGregorianCalendar::setFirstDayOfWeek' => 'Set the day on which the week is deemed to start',
'intlgregoriancalendar::setGregorianChange' => 'Set the Gregorian Calendar the change date',
'IntlGregorianCalendar::setLenient' => 'Set whether date/time interpretation is to be lenient',
'IntlGregorianCalendar::setMinimalDaysInFirstWeek' => 'Set minimal number of days the first week in a year or month can have',
'IntlGregorianCalendar::setRepeatedWallTimeOption' => 'Set behavior for handling repeating wall times at negative timezone offset transitions',
'IntlGregorianCalendar::setSkippedWallTimeOption' => 'Set behavior for handling skipped wall times at positive timezone offset transitions',
'IntlGregorianCalendar::setTime' => 'Set the calendar time in milliseconds since the epoch',
'IntlGregorianCalendar::setTimeZone' => 'Set the timezone used by this calendar',
'IntlGregorianCalendar::toDateTime' => 'Convert an IntlCalendar into a DateTime object',
'intliterator::current' => 'Get the current element',
'intliterator::key' => 'Get the current key',
'intliterator::next' => 'Move forward to the next element',
'intliterator::rewind' => 'Rewind the iterator to the first element',
'intliterator::valid' => 'Check if current position is valid',
'IntlPartsIterator::current' => 'Get the current element',
'intlpartsiterator::getBreakIterator' => 'Get IntlBreakIterator backing this parts iterator',
'IntlPartsIterator::key' => 'Get the current key',
'IntlPartsIterator::next' => 'Move forward to the next element',
'IntlPartsIterator::rewind' => 'Rewind the iterator to the first element',
'IntlPartsIterator::valid' => 'Check if current position is valid',
'intlrulebasedbreakiterator::__construct' => 'Create iterator from ruleset',
'IntlRuleBasedBreakIterator::createCharacterInstance' => 'Create break iterator for boundaries of combining character sequences',
'IntlRuleBasedBreakIterator::createCodePointInstance' => 'Create break iterator for boundaries of code points',
'IntlRuleBasedBreakIterator::createLineInstance' => 'Create break iterator for logically possible line breaks',
'IntlRuleBasedBreakIterator::createSentenceInstance' => 'Create break iterator for sentence breaks',
'IntlRuleBasedBreakIterator::createTitleInstance' => 'Create break iterator for title-casing breaks',
'IntlRuleBasedBreakIterator::createWordInstance' => 'Create break iterator for word breaks',
'IntlRuleBasedBreakIterator::current' => 'Get index of current position',
'IntlRuleBasedBreakIterator::first' => 'Set position to the first character in the text',
'IntlRuleBasedBreakIterator::following' => 'Advance the iterator to the first boundary following specified offset',
'intlrulebasedbreakiterator::getBinaryRules' => 'Get the binary form of compiled rules',
'IntlRuleBasedBreakIterator::getErrorCode' => 'Get last error code on the object',
'IntlRuleBasedBreakIterator::getErrorMessage' => 'Get last error message on the object',
'IntlRuleBasedBreakIterator::getLocale' => 'Get the locale associated with the object',
'IntlRuleBasedBreakIterator::getPartsIterator' => 'Create iterator for navigating fragments between boundaries',
'intlrulebasedbreakiterator::getRules' => 'Get the rule set used to create this object',
'intlrulebasedbreakiterator::getRuleStatus' => 'Get the largest status value from the break rules that determined the current break position',
'intlrulebasedbreakiterator::getRuleStatusVec' => 'Get the status values from the break rules that determined the current break position',
'IntlRuleBasedBreakIterator::getText' => 'Get the text being scanned',
'IntlRuleBasedBreakIterator::isBoundary' => 'Tell whether an offset is a boundaryʼs offset',
'IntlRuleBasedBreakIterator::last' => 'Set the iterator position to index beyond the last character',
'IntlRuleBasedBreakIterator::next' => 'Advance the iterator the next boundary',
'IntlRuleBasedBreakIterator::preceding' => 'Set the iterator position to the first boundary before an offset',
'IntlRuleBasedBreakIterator::previous' => 'Set the iterator position to the boundary immediately before the current',
'IntlRuleBasedBreakIterator::setText' => 'Set the text being scanned',
'intltimezone::countEquivalentIDs' => 'Get the number of IDs in the equivalency group that includes the given ID',
'intltimezone::createDefault' => 'Create a new copy of the default timezone for this host',
'intltimezone::createEnumeration' => 'Get an enumeration over time zone IDs associated with the given country or offset',
'intltimezone::createTimeZone' => 'Create a timezone object for the given ID',
'intltimezone::createTimeZoneIDEnumeration' => 'Get an enumeration over system time zone IDs with the given filter conditions',
'intltimezone::fromDateTimeZone' => 'Create a timezone object from DateTimeZone',
'intltimezone::getCanonicalID' => 'Get the canonical system timezone ID or the normalized custom time zone ID for the given time zone ID',
'intltimezone::getDisplayName' => 'Get a name of this time zone suitable for presentation to the user',
'intltimezone::getDSTSavings' => 'Get the amount of time to be added to local standard time to get local wall clock time',
'intltimezone::getEquivalentID' => 'Get an ID in the equivalency group that includes the given ID',
'intltimezone::getErrorCode' => 'Get last error code on the object',
'intltimezone::getErrorMessage' => 'Get last error message on the object',
'intltimezone::getGMT' => 'Create GMT (UTC) timezone',
'intltimezone::getID' => 'Get timezone ID',
'intltimezone::getIDForWindowsID' => 'Translate a Windows timezone into a system timezone',
'intltimezone::getOffset' => 'Get the time zone raw and GMT offset for the given moment in time',
'intltimezone::getRawOffset' => 'Get the raw GMT offset (before taking daylight savings time into account',
'intltimezone::getRegion' => 'Get the region code associated with the given system time zone ID',
'intltimezone::getTZDataVersion' => 'Get the timezone data version currently used by ICU',
'intltimezone::getUnknown' => 'Get the "unknown" time zone',
'intltimezone::getWindowsID' => 'Translate a system timezone into a Windows timezone',
'intltimezone::hasSameRules' => 'Check if this zone has the same rules and offset as another zone',
'intltimezone::toDateTimeZone' => 'Convert to DateTimeZone object',
'intltimezone::useDaylightTime' => 'Check if this time zone uses daylight savings time',
'intltz_getGMT' => '(PHP 5 &gt;=5.5.0 PECL intl &gt;= 3.0.0a1)<br/>
Create GMT (UTC) timezone',
'intval' => 'Get the integer value of a variable',
'InvalidArgumentException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'InvalidArgumentException::__toString' => 'String representation of the exception',
'InvalidArgumentException::getCode' => 'Gets the Exception code',
'InvalidArgumentException::getFile' => 'Gets the file in which the exception occurred',
'InvalidArgumentException::getLine' => 'Gets the line in which the exception occurred',
'InvalidArgumentException::getMessage' => 'Gets the Exception message',
'InvalidArgumentException::getPrevious' => 'Returns previous Exception',
'InvalidArgumentException::getTrace' => 'Gets the stack trace',
'InvalidArgumentException::getTraceAsString' => 'Gets the stack trace as a string',
'ip2long' => 'Converts a string containing an (IPv4) Internet Protocol dotted address into a long integer',
'iptcembed' => 'Embeds binary IPTC data into a JPEG image',
'iptcparse' => 'Parse a binary IPTC block into single tags',
'is_a' => 'Checks if the object is of this class or has this class as one of its parents',
'is_array' => 'Finds whether a variable is an array',
'is_bool' => 'Finds out whether a variable is a boolean',
'is_callable' => 'Verify that the contents of a variable can be called as a function',
'is_countable' => 'Verify that the contents of a variable is a countable value',
'is_dir' => 'Tells whether the filename is a directory',
'is_double' => 'Alias of is_float',
'is_executable' => 'Tells whether the filename is executable',
'is_file' => 'Tells whether the filename is a regular file',
'is_finite' => 'Finds whether a value is a legal finite number',
'is_float' => 'Finds whether the type of a variable is float',
'is_infinite' => 'Finds whether a value is infinite',
'is_int' => 'Find whether the type of a variable is integer',
'is_integer' => 'Alias of is_int',
'is_iterable' => 'Verify that the contents of a variable is an iterable value',
'is_link' => 'Tells whether the filename is a symbolic link',
'is_long' => 'Alias of is_int',
'is_nan' => 'Finds whether a value is not a number',
'is_null' => 'Finds whether a variable is `null`',
'is_numeric' => 'Finds whether a variable is a number or a numeric string',
'is_object' => 'Finds whether a variable is an object',
'is_readable' => 'Tells whether a file exists and is readable',
'is_real' => 'Alias of is_float',
'is_resource' => 'Finds whether a variable is a resource',
'is_scalar' => 'Finds whether a variable is a scalar',
'is_soap_fault' => 'Checks if a SOAP call has failed',
'is_string' => 'Find whether the type of a variable is string',
'is_subclass_of' => 'Checks if the object has this class as one of its parents or implements it',
'is_tainted' => 'Checks whether a string is tainted',
'is_uploaded_file' => 'Tells whether the file was uploaded via HTTP POST',
'is_writable' => 'Tells whether the filename is writable',
'is_writeable' => 'Alias of is_writable',
'isset' => 'Determine if a variable is set and is not `null`',
'Iterator::current' => 'Return the current element',
'Iterator::key' => 'Return the key of the current element',
'Iterator::next' => 'Move forward to next element',
'Iterator::rewind' => 'Rewind the Iterator to the first element',
'Iterator::valid' => 'Checks if current position is valid',
'iterator_apply' => 'Call a function for every element in an iterator',
'iterator_count' => 'Count the elements in an iterator',
'iterator_to_array' => 'Copy the iterator into an array',
'IteratorAggregate::getIterator' => 'Retrieve an external iterator',
'iteratoriterator::__construct' => 'Create an iterator from anything that is traversable',
'iteratoriterator::current' => 'Get the current value',
'iteratoriterator::getInnerIterator' => 'Get the inner iterator',
'iteratoriterator::key' => 'Get the key of the current element',
'iteratoriterator::next' => 'Forward to the next element',
'iteratoriterator::rewind' => 'Rewind to the first element',
'iteratoriterator::valid' => 'Checks if the iterator is valid',
'java' => 'Create Java object',
'java::java' => 'Create Java object',
'JavaException::getCause' => 'Get Java exception that led to this exception',
'jddayofweek' => 'Returns the day of the week',
'jdmonthname' => 'Returns a month name',
'jdtofrench' => 'Converts a Julian Day Count to the French Republican Calendar',
'jdtogregorian' => 'Converts Julian Day Count to Gregorian date',
'jdtojewish' => 'Converts a Julian day count to a Jewish calendar date',
'jdtojulian' => 'Converts a Julian Day Count to a Julian Calendar Date',
'jdtounix' => 'Convert Julian Day to Unix timestamp',
'jewishtojd' => 'Converts a date in the Jewish Calendar to Julian Day Count',
'join' => 'Alias of implode',
'jpeg2wbmp' => 'Convert JPEG image file to WBMP image file',
'json_decode' => 'Decodes a JSON string',
'json_encode' => 'Returns the JSON representation of a value',
'json_last_error' => 'Returns the last error occurred',
'json_last_error_msg' => 'Returns the error string of the last json_encode() or json_decode() call',
'JsonException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'JsonException::__toString' => 'String representation of the exception',
'JsonException::getCode' => 'Gets the Exception code',
'JsonException::getFile' => 'Gets the file in which the exception occurred',
'JsonException::getLine' => 'Gets the line in which the exception occurred',
'JsonException::getMessage' => 'Gets the Exception message',
'JsonException::getPrevious' => 'Returns previous Exception',
'JsonException::getTrace' => 'Gets the stack trace',
'JsonException::getTraceAsString' => 'Gets the stack trace as a string',
'jsonserializable::jsonSerialize' => 'Specify data which should be serialized to JSON',
'judy::__construct' => 'Construct a new Judy object',
'judy::__destruct' => 'Destruct a Judy object',
'judy::byCount' => 'Locate the Nth index present in the Judy array',
'judy::count' => 'Count the number of elements in the Judy array',
'judy::first' => 'Search for the first index in the Judy array',
'judy::firstEmpty' => 'Search for the first absent index in the Judy array',
'judy::free' => 'Free the entire Judy array',
'judy::getType' => 'Return the type of the current Judy array',
'judy::last' => 'Search for the last index in the Judy array',
'judy::lastEmpty' => 'Search for the last absent index in the Judy array',
'judy::memoryUsage' => 'Return the memory used by the Judy array',
'judy::next' => 'Search for the next index in the Judy array',
'judy::nextEmpty' => 'Search for the next absent index in the Judy array',
'judy::offsetExists' => 'Whether a offset exists',
'judy::offsetGet' => 'Offset to retrieve',
'judy::offsetSet' => 'Offset to set',
'judy::offsetUnset' => 'Offset to unset',
'judy::prev' => 'Search for the previous index in the Judy array',
'judy::prevEmpty' => 'Search for the previous absent index in the Judy array',
'judy::size' => 'Return the size of the current Judy array',
'judy_type' => 'Return the type of a Judy array',
'judy_version' => 'Return or print the current PHP Judy version',
'juliantojd' => 'Converts a Julian Calendar date to Julian Day Count',
'kadm5_chpass_principal' => 'Changes the principal\'s password',
'kadm5_create_principal' => 'Creates a kerberos principal with the given parameters',
'kadm5_delete_principal' => 'Deletes a kerberos principal',
'kadm5_destroy' => 'Closes the connection to the admin server and releases all related resources',
'kadm5_flush' => 'Flush all changes to the Kerberos database',
'kadm5_get_policies' => 'Gets all policies from the Kerberos database',
'kadm5_get_principal' => 'Gets the principal\'s entries from the Kerberos database',
'kadm5_get_principals' => 'Gets all principals from the Kerberos database',
'kadm5_init_with_password' => 'Opens a connection to the KADM5 library',
'kadm5_modify_principal' => 'Modifies a kerberos principal with the given parameters',
'key' => 'Fetch a key from an array',
'key_exists' => 'Alias of array_key_exists',
'krsort' => 'Sort an array by key in reverse order',
'ksort' => 'Sort an array by key',
'ktaglib_id3v2_frame::getDescription' => 'Returns a description for the picture in a picture frame',
'ktaglib_id3v2_frame::getMimeType' => 'Returns the mime type of the picture',
'ktaglib_id3v2_frame::getType' => 'Returns the type of the image',
'ktaglib_id3v2_frame::savePicture' => 'Saves the picture to a file',
'ktaglib_id3v2_frame::setMimeType' => 'Set\'s the mime type of the picture',
'ktaglib_id3v2_frame::setPicture' => 'Sets the frame picture to the given image',
'ktaglib_id3v2_frame::setType' => 'Set the type of the image',
'ktaglib_mpeg_audioproperties::getBitrate' => 'Returns the bitrate of the MPEG file',
'ktaglib_mpeg_audioproperties::getChannels' => 'Returns the amount of channels of a MPEG file',
'ktaglib_mpeg_audioproperties::getLayer' => 'Returns the layer of a MPEG file',
'ktaglib_mpeg_audioproperties::getLength' => 'Returns the length of a MPEG file',
'ktaglib_mpeg_audioproperties::getSampleBitrate' => 'Returns the sample bitrate of a MPEG file',
'ktaglib_mpeg_audioproperties::getVersion' => 'Returns the version of a MPEG file',
'ktaglib_mpeg_audioproperties::isCopyrighted' => 'Returns the copyright status of an MPEG file',
'ktaglib_mpeg_audioproperties::isOriginal' => 'Returns if the file is marked as the original file',
'ktaglib_mpeg_audioproperties::isProtectionEnabled' => 'Returns if protection mechanisms of an MPEG file are enabled',
'ktaglib_mpeg_file::__construct' => 'Opens a new file',
'ktaglib_mpeg_file::getAudioProperties' => 'Returns an object that provides access to the audio properties',
'ktaglib_mpeg_file::getID3v1Tag' => 'Returns an object representing an ID3v1 tag',
'ktaglib_mpeg_file::getID3v2Tag' => 'Returns a ID3v2 object',
'labelcacheObj::freeCache' => 'Free the label cache. Always returns MS_SUCCESS.
Ex : map->labelcache->freeCache();',
'labelObj::convertToString' => 'Saves the object to a string.  Provides the inverse option for
updateFromString.',
'labelObj::deleteStyle' => 'Delete the style specified by the style index. If there are any
style that follow the deleted style, their index will decrease by 1.',
'labelObj::free' => 'Free the object properties and break the internal references.
Note that you have to unset the php variable to free totally the
resources.',
'labelObj::getBinding' => 'Get the attribute binding for a specified label property. Returns
NULL if there is no binding for this property.
Example:
.. code-block:: php
$oLabel->setbinding(MS_LABEL_BINDING_COLOR, "FIELD_NAME_COLOR");
echo $oLabel->getbinding(MS_LABEL_BINDING_COLOR); // FIELD_NAME_COLOR',
'labelObj::getExpressionString' => 'Returns the label expression string.',
'labelObj::getStyle' => 'Return the style object using an index. index >= 0 &&
index < label->numstyles.',
'labelObj::getTextString' => 'Returns the label text string.',
'labelObj::moveStyleDown' => 'The style specified by the style index will be moved down into
the array of classes. Returns MS_SUCCESS or MS_FAILURE.
ex label->movestyledown(0) will have the effect of moving style 0
up to position 1, and the style at position 1 will be moved
to position 0.',
'labelObj::moveStyleUp' => 'The style specified by the style index will be moved up into
the array of classes. Returns MS_SUCCESS or MS_FAILURE.
ex label->movestyleup(1) will have the effect of moving style 1
up to position 0, and the style at position 0 will be moved
to position 1.',
'labelObj::removeBinding' => 'Remove the attribute binding for a specfiled style property.
Example:
.. code-block:: php
$oStyle->removebinding(MS_LABEL_BINDING_COLOR);',
'labelObj::set' => 'Set object property to a new value.',
'labelObj::setBinding' => 'Set the attribute binding for a specified label property.
Example:
.. code-block:: php
$oLabel->setbinding(MS_LABEL_BINDING_COLOR, "FIELD_NAME_COLOR");
This would bind the color parameter with the data (ie will extract
the value of the color from the field called "FIELD_NAME_COLOR"',
'labelObj::setExpression' => 'Set the label expression.',
'labelObj::setText' => 'Set the label text.',
'labelObj::updateFromString' => 'Update a label from a string snippet. Returns MS_SUCCESS/MS_FAILURE.',
'lapack::eigenValues' => 'This function returns the eigenvalues for a given square matrix',
'lapack::identity' => 'Return an identity matrix',
'lapack::leastSquaresByFactorisation' => 'Calculate the linear least squares solution of a matrix using QR factorisation',
'lapack::leastSquaresBySVD' => 'Solve the linear least squares problem, using SVD',
'lapack::pseudoInverse' => 'Calculate the inverse of a matrix',
'lapack::singularValues' => 'Calculated the singular values of a matrix',
'lapack::solveLinearEquation' => 'Solve a system of linear equations',
'layerObj::addFeature' => 'Add a new feature in a layer. Returns MS_SUCCESS or MS_FAILURE on
error.',
'layerObj::applySLD' => 'Apply the :ref:`SLD <sld>` document to the layer object.
The matching between the sld document and the layer will be done
using the layer\'s name.
If a namedlayer argument is passed (argument is optional),
the NamedLayer in the sld that matches it will be used to style
the layer.
See :ref:`SLD HowTo <sld>` for more information on the SLD support.',
'layerObj::applySLDURL' => 'Apply the :ref:`SLD <sld>` document pointed by the URL to the
layer object. The matching between the sld document and the layer
will be done using the layer\'s name.  If a namedlayer argument is
passed (argument is optional), the NamedLayer in the sld that
matches it will be used to style the layer.  See :ref:`SLD HowTo
<sld>` for more information on the SLD support.',
'layerObj::clearProcessing' => 'Clears all the processing strings.',
'layerObj::close' => 'Close layer previously opened with open().',
'layerObj::convertToString' => 'Saves the object to a string.  Provides the inverse option for
updateFromString.',
'layerObj::draw' => 'Draw a single layer, add labels to cache if required.
Returns MS_SUCCESS or MS_FAILURE on error.',
'layerObj::drawQuery' => 'Draw query map for a single layer.
string   executeWFSGetfeature()
Executes a GetFeature request on a WFS layer and returns the
name of the temporary GML file created. Returns an empty
string on error.',
'layerObj::free' => 'Free the object properties and break the internal references.
Note that you have to unset the php variable to free totally the
resources.',
'layerObj::generateSLD' => 'Returns an SLD XML string based on all the classes found in the
layer (the layer must have `STATUS` `on`).',
'layerObj::getClass' => 'Returns a classObj from the layer given an index value (0=first class)',
'layerObj::getClassIndex' => 'Get the class index of a shape for a given scale. Returns -1 if no
class matches. classgroup is an array of class ids to check
(Optional). numclasses is the number of classes that the classgroup
array contains. By default, all the layer classes will be checked.',
'layerObj::getExtent' => 'Returns the layer\'s data extents or NULL on error.
If the layer\'s EXTENT member is set then this value is used,
otherwise this call opens/closes the layer to read the
extents. This is quick on shapefiles, but can be
an expensive operation on some file formats or data sources.
This function is safe to use on both opened or closed layers: it
is not necessary to call open()/close() before/after calling it.',
'layerObj::getFilterString' => 'Returns the :ref:`expression <expressions>` for this layer or NULL
on error.',
'layerObj::getGridIntersectionCoordinates' => 'Returns an array containing the grid intersection coordinates. If
there are no coordinates, it returns an empty array.',
'layerObj::getItems' => 'Returns an array containing the items. Must call open function first.
If there are no items, it returns an empty array.',
'layerObj::getMetaData' => 'Fetch layer metadata entry by name.  Returns "" if no entry
matches the name.  Note that the search is case sensitive.
.. note::
getMetaData\'s query is case sensitive.',
'layerObj::getNumResults' => 'Returns the number of results in the last query.',
'layerObj::getProcessing' => 'Returns an array containing the processing strings.
If there are no processing strings, it returns an empty array.',
'layerObj::getProjection' => 'Returns a string representation of the :ref:`projection <projection>`.
Returns NULL on error or if no projection is set.',
'layerObj::getResult' => 'Returns a resultObj by index from a layer object with
index in the range 0 to numresults-1.
Returns a valid object or FALSE(0) if index is invalid.',
'layerObj::getResultsBounds' => 'Returns the bounding box of the latest result.',
'layerObj::getShape' => 'If the resultObj passed has a valid resultindex, retrieve shapeObj from
a layer\'s resultset. (You get it from the resultObj returned by
getResult() for instance). Otherwise, it will do a single query on
the layer to fetch the shapeindex
.. code-block:: php
$map = new mapObj("gmap75.map");
$l = $map->getLayerByName("popplace");
$l->queryByRect($map->extent);
for ($i=0; $i<$l->getNumResults();$i++){
$s = $l->getShape($l->getResult($i));
echo $s->getValue($l,"Name");
echo "\n";
}',
'layerObj::getWMSFeatureInfoURL' => 'Returns a WMS GetFeatureInfo URL (works only for WMS layers)
clickX, clickY is the location of to query in pixel coordinates
with (0,0) at the top left of the image.
featureCount is the number of results to return.
infoFormat is the format the format in which the result should be
requested.  Depends on remote server\'s capabilities.  MapServer
WMS servers support only "MIME" (and should support "GML.1" soon).
Returns "" and outputs a warning if layer is not a WMS layer
or if it is not queryable.',
'layerObj::isVisible' => 'Returns MS_TRUE/MS_FALSE depending on whether the layer is
currently visible in the map (i.e. turned on, in scale, etc.).',
'layerObj::moveclassdown' => 'The class specified by the class index will be moved down into
the array of layers. Returns MS_SUCCESS or MS_FAILURE.
ex layer->moveclassdown(0) will have the effect of moving class 0
up to position 1, and the class at position 1 will be moved
to position 0.',
'layerObj::moveclassup' => 'The class specified by the class index will be moved up into
the array of layers. Returns MS_SUCCESS or MS_FAILURE.
ex layer->moveclassup(1) will have the effect of moving class 1
up to position 0, and the class at position 0 will be moved
to position 1.',
'layerObj::ms_newLayerObj' => 'Old style constructor',
'layerObj::nextShape' => 'Called after msWhichShapes has been called to actually retrieve
shapes within a given area. Returns a shape object or NULL on
error.
.. code-block:: php
$map = ms_newmapobj("d:/msapps/gmap-ms40/htdocs/gmap75.map");
$layer = $map->getLayerByName(\'road\');
$status = $layer->open();
$status = $layer->whichShapes($map->extent);
while ($shape = $layer->nextShape())
{
echo $shape->index ."<br>\n";
}
$layer->close();',
'layerObj::open' => 'Open the layer for use with getShape().
Returns MS_SUCCESS/MS_FAILURE.',
'layerObj::queryByAttributes' => 'Query layer for shapes that intersect current map extents.  qitem
is the item (attribute) on which the query is performed, and
qstring is the expression to match.  The query is performed on all
the shapes that are part of a :ref:`CLASS` that contains a
:ref:`TEMPLATE <template>` value or that match any class in a
layer that contains a :ref:`LAYER` :ref:`TEMPLATE <template>`
value.  Note that the layer\'s FILTER/FILTERITEM are ignored by
this function.  Mode is MS_SINGLE or MS_MULTIPLE depending on
number of results you want.  Returns MS_SUCCESS if shapes were
found or MS_FAILURE if nothing was found or if some other error
happened (note that the error message in case nothing was found
can be avoided in PHP using the \'@\' control operator).',
'layerObj::queryByFeatures' => 'Perform a query set based on a previous set of results from
another layer. At present the results MUST be based on a polygon
layer.
Returns MS_SUCCESS if shapes were found or MS_FAILURE if nothing
was found or if some other error happened (note that the error
message in case nothing was found can be avoided in PHP using
the \'@\' control operator).',
'layerObj::queryByPoint' => 'Query layer at point location specified in georeferenced map
coordinates (i.e. not pixels).
The query is performed on all the shapes that are part of a CLASS
that contains a TEMPLATE value or that match any class in a
layer that contains a LAYER TEMPLATE value.
Mode is MS_SINGLE or MS_MULTIPLE depending on number of results
you want.
Passing buffer -1 defaults to tolerances set in the map file
(in pixels) but you can use a constant buffer (specified in
ground units) instead.
Returns MS_SUCCESS if shapes were found or MS_FAILURE if nothing
was found or if some other error happened (note that the error
message in case nothing was found can be avoided in PHP using
the \'@\' control operator).',
'layerObj::queryByRect' => 'Query layer using a rectangle specified in georeferenced map
coordinates (i.e. not pixels).
The query is performed on all the shapes that are part of a CLASS
that contains a TEMPLATE value or that match any class in a
layer that contains a LAYER TEMPLATE value.
Returns MS_SUCCESS if shapes were found or MS_FAILURE if nothing
was found or if some other error happened (note that the error
message in case nothing was found can be avoided in PHP using
the \'@\' control operator).',
'layerObj::queryByShape' => 'Query layer based on a single shape, the shape has to be a polygon
at this point.
Returns MS_SUCCESS if shapes were found or MS_FAILURE if nothing
was found or if some other error happened (note that the error
message in case nothing was found can be avoided in PHP using
the \'@\' control operator).',
'layerObj::removeClass' => 'Removes the class indicated and returns a copy, or NULL in the case
of a failure.  Note that subsequent classes will be renumbered by
this operation. The numclasses field contains the number of classes
available.',
'layerObj::removeMetaData' => 'Remove a metadata entry for the layer.  Returns MS_SUCCESS/MS_FAILURE.',
'layerObj::set' => 'Set object property to a new value.',
'layerObj::setConnectionType' => 'Changes the connectiontype of the layer and recreates the vtable
according to the new connection type. This method should be used
instead of setting the connectiontype parameter directly.
In the case when the layer.connectiontype = MS_PLUGIN the plugin_library
parameter should also be specified so as to select the library to
load by MapServer. For the other connection types this parameter
is not used.',
'layerObj::setFilter' => 'Set layer filter :ref:`expression <expressions>`.',
'layerObj::setMetaData' => 'Set a metadata entry for the layer.  Returns MS_SUCCESS/MS_FAILURE.
int setProcessing(string)
Add the string to the processing string list for the layer.
The layer->num_processing is incremented by 1.
Returns MS_SUCCESS or MS_FAILURE on error.
.. code-block:: php
$oLayer->setprocessing("SCALE_1=AUTO");
$oLayer->setprocessing("SCALE_2=AUTO");',
'layerObj::setProjection' => 'Set layer :ref:`projection <projection>` and coordinate system.
Parameters are given as a single string of comma-delimited PROJ.4
parameters. Returns MS_SUCCESS or MS_FAILURE on error.',
'layerObj::setWKTProjection' => 'Same as setProjection(), but takes an OGC WKT projection
definition string as input.
.. note::
setWKTProjection requires GDAL support',
'layerObj::updateFromString' => 'Update a layer from a string snippet. Returns MS_SUCCESS/MS_FAILURE.
.. code-block:: php
modify the name
$oLayer->updateFromString(\'LAYER NAME land_fn2 END\');
add a new class
$oLayer->updateFromString(\'LAYER CLASS STYLE COLOR 255 255 0 END END END\');
int whichshapes(rectobj)
Performs a spatial, and optionally an attribute based feature
search.  The function basically prepares things so that candidate
features can be accessed by query or drawing functions (eg using
nextshape function).  Returns MS_SUCCESS, MS_FAILURE or MS_DONE.
MS_DONE is returned if the layer extent does not overlap the
rectObj.',
'lcfirst' => 'Make a string\'s first character lowercase',
'lcg_value' => 'Combined linear congruential generator',
'lchgrp' => 'Changes group ownership of symlink',
'lchown' => 'Changes user ownership of symlink',
'ldap_8859_to_t61' => 'Translate 8859 characters to t61 characters',
'ldap_add' => 'Add entries to LDAP directory',
'ldap_add_ext' => 'Add entries to LDAP directory',
'ldap_bind' => 'Bind to LDAP directory',
'ldap_bind_ext' => 'Bind to LDAP directory',
'ldap_close' => 'Alias of ldap_unbind',
'ldap_compare' => 'Compare value of attribute found in entry specified with DN',
'ldap_connect' => 'Connect to an LDAP server',
'ldap_control_paged_result' => 'Send LDAP pagination control',
'ldap_control_paged_result_response' => 'Retrieve the LDAP pagination cookie',
'ldap_count_entries' => 'Count the number of entries in a search',
'ldap_delete' => 'Delete an entry from a directory',
'ldap_delete_ext' => 'Delete an entry from a directory',
'ldap_dn2ufn' => 'Convert DN to User Friendly Naming format',
'ldap_err2str' => 'Convert LDAP error number into string error message',
'ldap_errno' => 'Return the LDAP error number of the last LDAP command',
'ldap_error' => 'Return the LDAP error message of the last LDAP command',
'ldap_escape' => 'Escape a string for use in an LDAP filter or DN',
'ldap_exop' => 'Performs an extended operation',
'ldap_exop_passwd' => 'PASSWD extended operation helper',
'ldap_exop_refresh' => 'Refresh extended operation helper',
'ldap_exop_whoami' => 'WHOAMI extended operation helper',
'ldap_explode_dn' => 'Splits DN into its component parts',
'ldap_first_attribute' => 'Return first attribute',
'ldap_first_entry' => 'Return first result id',
'ldap_first_reference' => 'Return first reference',
'ldap_free_result' => 'Free result memory',
'ldap_get_attributes' => 'Get attributes from a search result entry',
'ldap_get_dn' => 'Get the DN of a result entry',
'ldap_get_entries' => 'Get all result entries',
'ldap_get_option' => 'Get the current value for given option',
'ldap_get_values' => 'Get all values from a result entry',
'ldap_get_values_len' => 'Get all binary values from a result entry',
'ldap_list' => 'Single-level search',
'ldap_mod_add' => 'Add attribute values to current attributes',
'ldap_mod_add_ext' => 'Add attribute values to current attributes',
'ldap_mod_del' => 'Delete attribute values from current attributes',
'ldap_mod_del_ext' => 'Delete attribute values from current attributes',
'ldap_mod_replace' => 'Replace attribute values with new ones',
'ldap_mod_replace_ext' => 'Replace attribute values with new ones',
'ldap_modify' => 'Alias of ldap_mod_replace',
'ldap_modify_batch' => 'Batch and execute modifications on an LDAP entry',
'ldap_next_attribute' => 'Get the next attribute in result',
'ldap_next_entry' => 'Get next result entry',
'ldap_next_reference' => 'Get next reference',
'ldap_parse_exop' => 'Parse result object from an LDAP extended operation',
'ldap_parse_reference' => 'Extract information from reference entry',
'ldap_parse_result' => 'Extract information from result',
'ldap_read' => 'Read an entry',
'ldap_rename' => 'Modify the name of an entry',
'ldap_rename_ext' => 'Modify the name of an entry',
'ldap_sasl_bind' => 'Bind to LDAP directory using SASL',
'ldap_search' => 'Search LDAP tree',
'ldap_set_option' => 'Set the value of the given option',
'ldap_set_rebind_proc' => 'Set a callback function to do re-binds on referral chasing',
'ldap_sort' => 'Sort LDAP result entries on the client side',
'ldap_start_tls' => 'Start TLS',
'ldap_t61_to_8859' => 'Translate t61 characters to 8859 characters',
'ldap_unbind' => 'Unbind from LDAP directory',
'legendObj::convertToString' => 'Saves the object to a string.  Provides the inverse option for
updateFromString.',
'legendObj::free' => 'Free the object properties and break the internal references.
Note that you have to unset the php variable to free totally the
resources.',
'legendObj::set' => 'Set object property to a new value.',
'legendObj::updateFromString' => 'Update a legend from a string snippet. Returns MS_SUCCESS/MS_FAILURE.',
'LengthException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'LengthException::__toString' => 'String representation of the exception',
'LengthException::getCode' => 'Gets the Exception code',
'LengthException::getFile' => 'Gets the file in which the exception occurred',
'LengthException::getLine' => 'Gets the line in which the exception occurred',
'LengthException::getMessage' => 'Gets the Exception message',
'LengthException::getPrevious' => 'Returns previous Exception',
'LengthException::getTrace' => 'Gets the stack trace',
'LengthException::getTraceAsString' => 'Gets the stack trace as a string',
'LevelDB::getProperty' => 'Valid properties:
- leveldb.stats: returns the status of the entire db
- leveldb.num-files-at-level: returns the number of files for each level. For example, you can use leveldb.num-files-at-level0 the number of files for zero level.
- leveldb.sstables: returns current status of sstables',
'LevelDB::set' => 'Alias of LevelDB::put()',
'LevelDB::write' => 'Executes all of the operations added in the write batch.',
'levenshtein' => 'Calculate Levenshtein distance between two strings',
'libxml_clear_errors' => 'Clear libxml error buffer',
'libxml_disable_entity_loader' => 'Disable the ability to load external entities',
'libxml_get_errors' => 'Retrieve array of errors',
'libxml_get_last_error' => 'Retrieve last error from libxml',
'libxml_set_external_entity_loader' => 'Changes the default external entity loader',
'libxml_set_streams_context' => 'Set the streams context for the next libxml document load or write',
'libxml_use_internal_errors' => 'Disable libxml errors and allow user to fetch error information as needed',
'limititerator::__construct' => 'Construct a LimitIterator',
'limititerator::current' => 'Get current element',
'limititerator::getInnerIterator' => 'Get inner iterator',
'limititerator::getPosition' => 'Return the current position',
'limititerator::key' => 'Get current key',
'limititerator::next' => 'Move the iterator forward',
'limititerator::rewind' => 'Rewind the iterator to the specified starting offset',
'limititerator::seek' => 'Seek to the given position',
'limititerator::valid' => 'Check whether the current element is valid',
'lineObj::add' => 'Add a point to the end of line. Returns MS_SUCCESS/MS_FAILURE.',
'lineObj::addXY' => 'Add a point to the end of line. Returns MS_SUCCESS/MS_FAILURE.
.. note::
the 3rd parameter m is used for measured shape files only.
It is not mandatory.',
'lineObj::addXYZ' => 'Add a point to the end of line. Returns MS_SUCCESS/MS_FAILURE.
.. note::
the 4th parameter m is used for measured shape files only.
It is not mandatory.',
'lineObj::ms_newLineObj' => 'Old style constructor',
'lineObj::point' => 'Returns a reference to point number i.',
'lineObj::project' => 'Project the line from "in" projection (1st argument) to "out"
projection (2nd argument).  Returns MS_SUCCESS/MS_FAILURE.',
'link' => 'Create a hard link',
'linkinfo' => 'Gets information about a link',
'locale::acceptFromHttp' => 'Tries to find out best available locale based on HTTP "Accept-Language" header',
'locale::canonicalize' => 'Canonicalize the locale string',
'locale::composeLocale' => 'Returns a correctly ordered and delimited locale ID',
'locale::filterMatches' => 'Checks if a language tag filter matches with locale',
'locale::getAllVariants' => 'Gets the variants for the input locale',
'locale::getDefault' => 'Gets the default locale value from the INTL global \'default_locale\'',
'locale::getDisplayLanguage' => 'Returns an appropriately localized display name for language of the inputlocale',
'locale::getDisplayName' => 'Returns an appropriately localized display name for the input locale',
'locale::getDisplayRegion' => 'Returns an appropriately localized display name for region of the input locale',
'locale::getDisplayScript' => 'Returns an appropriately localized display name for script of the input locale',
'locale::getDisplayVariant' => 'Returns an appropriately localized display name for variants of the input locale',
'locale::getKeywords' => 'Gets the keywords for the input locale',
'locale::getPrimaryLanguage' => 'Gets the primary language for the input locale',
'locale::getRegion' => 'Gets the region for the input locale',
'locale::getScript' => 'Gets the script for the input locale',
'locale::lookup' => 'Searches the language tag list for the best match to the language',
'locale::parseLocale' => 'Returns a key-value array of locale ID subtag elements',
'locale::setDefault' => 'Sets the default runtime locale',
'localeconv' => 'Get numeric formatting information',
'localtime' => 'Get the local time',
'log' => 'Natural logarithm',
'log10' => 'Base-10 logarithm',
'log1p' => 'Returns log(1 + number), computed in a way that is accurate even when the value of number is close to zero',
'LogicException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'LogicException::__toString' => 'String representation of the exception',
'LogicException::getCode' => 'Gets the Exception code',
'LogicException::getFile' => 'Gets the file in which the exception occurred',
'LogicException::getLine' => 'Gets the line in which the exception occurred',
'LogicException::getMessage' => 'Gets the Exception message',
'LogicException::getPrevious' => 'Returns previous Exception',
'LogicException::getTrace' => 'Gets the stack trace',
'LogicException::getTraceAsString' => 'Gets the stack trace as a string',
'long2ip' => 'Converts an long integer address into a string in (IPv4) Internet standard dotted format',
'lstat' => 'Gives information about a file or symbolic link',
'ltrim' => 'Strip whitespace (or other characters) from the beginning of a string',
'lua::__construct' => 'Lua constructor',
'lua::assign' => 'Assign a PHP variable to Lua',
'Lua::call' => '`@return mixed` Returns result of the called function, null for wrong arguments or FALSE on other failure.',
'lua::eval' => 'Evaluate a string as Lua code',
'lua::getVersion' => 'The getversion purpose',
'lua::include' => 'Parse a Lua script file',
'lua::registerCallback' => 'Register a PHP function to Lua',
'luaclosure::__invoke' => 'Invoke luaclosure',
'luasandbox::callFunction' => 'Call a function in a Lua global variable',
'luasandbox::disableProfiler' => 'Disable the profiler',
'luasandbox::enableProfiler' => 'Enable the profiler.',
'luasandbox::getCPUUsage' => 'Fetch the current CPU time usage of the Lua environment',
'luasandbox::getMemoryUsage' => 'Fetch the current memory usage of the Lua environment',
'luasandbox::getPeakMemoryUsage' => 'Fetch the peak memory usage of the Lua environment',
'luasandbox::getProfilerFunctionReport' => 'Fetch profiler data',
'luasandbox::getVersionInfo' => 'Return the versions of LuaSandbox and Lua',
'luasandbox::loadBinary' => 'Load a precompiled binary chunk into the Lua environment',
'luasandbox::loadString' => 'Load Lua code into the Lua environment',
'luasandbox::pauseUsageTimer' => 'Pause the CPU usage timer',
'luasandbox::registerLibrary' => 'Register a set of PHP functions as a Lua library',
'luasandbox::setCPULimit' => 'Set the CPU time limit for the Lua environment',
'luasandbox::setMemoryLimit' => 'Set the memory limit for the Lua environment',
'luasandbox::unpauseUsageTimer' => 'Unpause the timer paused by LuaSandbox::pauseUsageTimer',
'luasandbox::wrapPhpFunction' => 'Wrap a PHP callable in a LuaSandboxFunction',
'luasandboxfunction::__construct' => 'Unused',
'luasandboxfunction::call' => 'Call a Lua function',
'luasandboxfunction::dump' => 'Dump the function as a binary blob',
'lzf_compress' => 'LZF compression',
'lzf_decompress' => 'LZF decompression',
'lzf_optimized_for' => 'Determines what LZF extension was optimized for',
'm_checkstatus' => 'Check to see if a transaction has completed',
'm_completeauthorizations' => 'Number of complete authorizations in queue, returning an array of their identifiers',
'm_connect' => 'Establish the connection to MCVE',
'm_connectionerror' => 'Get a textual representation of why a connection failed',
'm_deletetrans' => 'Delete specified transaction from MCVE_CONN structure',
'm_destroyconn' => 'Destroy the connection and MCVE_CONN structure',
'm_destroyengine' => 'Free memory associated with IP/SSL connectivity',
'm_getcell' => 'Get a specific cell from a comma delimited response by column name',
'm_getcellbynum' => 'Get a specific cell from a comma delimited response by column number',
'm_getcommadelimited' => 'Get the RAW comma delimited data returned from MCVE',
'm_getheader' => 'Get the name of the column in a comma-delimited response',
'm_initconn' => 'Create and initialize an MCVE_CONN structure',
'm_initengine' => 'Ready the client for IP/SSL Communication',
'm_iscommadelimited' => 'Checks to see if response is comma delimited',
'm_maxconntimeout' => 'The maximum amount of time the API will attempt a connection to MCVE',
'm_monitor' => 'Perform communication with MCVE (send/receive data) Non-blocking',
'm_numcolumns' => 'Number of columns returned in a comma delimited response',
'm_numrows' => 'Number of rows returned in a comma delimited response',
'm_parsecommadelimited' => 'Parse the comma delimited response so m_getcell, etc will work',
'm_responsekeys' => 'Returns array of strings which represents the keys that can be used for response parameters on this transaction',
'm_responseparam' => 'Get a custom response parameter',
'm_returnstatus' => 'Check to see if the transaction was successful',
'm_setblocking' => 'Set blocking/non-blocking mode for connection',
'm_setdropfile' => 'Set the connection method to Drop-File',
'm_setip' => 'Set the connection method to IP',
'm_setssl' => 'Set the connection method to SSL',
'm_setssl_cafile' => 'Set SSL CA (Certificate Authority) file for verification of server certificate',
'm_setssl_files' => 'Set certificate key files and certificates if server requires client certificate verification',
'm_settimeout' => 'Set maximum transaction time (per trans)',
'm_sslcert_gen_hash' => 'Generate hash for SSL client certificate verification',
'm_transactionssent' => 'Check to see if outgoing buffer is clear',
'm_transinqueue' => 'Number of transactions in client-queue',
'm_transkeyval' => 'Add key/value pair to a transaction. Replaces deprecated transparam()',
'm_transnew' => 'Start a new transaction',
'm_transsend' => 'Finalize and send the transaction',
'm_uwait' => 'Wait x microsecs',
'm_validateidentifier' => 'Whether or not to validate the passed identifier on any transaction it is passed to',
'm_verifyconnection' => 'Set whether or not to PING upon connect to verify connection',
'm_verifysslcert' => 'Set whether or not to verify the server ssl certificate',
'magic_quotes_runtime' => 'Alias of set_magic_quotes_runtime',
'mail' => 'Send mail',
'mailparse_determine_best_xfer_encoding' => 'Gets the best way of encoding',
'mailparse_msg_create' => 'Create a mime mail resource',
'mailparse_msg_extract_part' => 'Extracts/decodes a message section',
'mailparse_msg_extract_part_file' => 'Extracts/decodes a message section',
'mailparse_msg_extract_whole_part_file' => 'Extracts a message section including headers without decoding the transfer encoding',
'mailparse_msg_free' => 'Frees a MIME resource',
'mailparse_msg_get_part' => 'Returns a handle on a given section in a mimemessage',
'mailparse_msg_get_part_data' => 'Returns an associative array of info about the message',
'mailparse_msg_get_structure' => 'Returns an array of mime section names in the supplied message',
'mailparse_msg_parse' => 'Incrementally parse data into buffer',
'mailparse_msg_parse_file' => 'Parses a file',
'mailparse_rfc822_parse_addresses' => 'Parse RFC 822 compliant addresses',
'mailparse_stream_encode' => 'Streams data from source file pointer, apply encoding and write to destfp',
'mailparse_uudecode_all' => 'Scans the data from fp and extract each embedded uuencoded file',
'main' => 'Dummy for main',
'mapObj::__construct' => 'Returns a new object to deal with a MapServer map file.
Construct a new mapObj from a mapfile string. Returns a new object to deal
with a MapServer map file.
.. note::
By default, the SYMBOLSET, FONTSET, and other paths in the mapfile
are relative to the mapfile location.  If new_map_path is provided
then this directory will be used as the base path for all the
rewlative paths inside the mapfile.',
'mapObj::appendOutputFormat' => 'Appends outputformat object in the map object.
Returns the new numoutputformats value.',
'mapObj::applyconfigoptions' => 'Applies the config options set in the map file. For example
setting the PROJ_LIB using the setconfigoption only modifies
the value in the map object. applyconfigoptions will actually
change the PROJ_LIB value that will be used when dealing with
projection.',
'mapObj::applySLD' => 'Apply the :ref:`SLD` document to the map file. The matching between the
sld document and the map file will be done using the layer\'s name.
See :ref:`SLD HowTo <sld>` for more information on the SLD support.',
'mapObj::applySLDURL' => 'Apply the SLD document pointed by the URL to the map file. The
matching between the sld document and the map file will be done
using the layer\'s name.
See :ref:`SLD HowTo <sld>` for more information on the SLD support.',
'mapObj::convertToString' => 'Saves the object to a string.
.. note::
The inverse method updateFromString does not exist for the mapObj
.. versionadded:: 6.4',
'mapObj::draw' => 'Render map and return an image object or NULL on error.',
'mapObj::drawLabelCache' => 'Renders the labels for a map. Returns MS_SUCCESS or MS_FAILURE on error.',
'mapObj::drawLegend' => 'Render legend and return an image object.',
'mapObj::drawQuery' => 'Render a query map and return an image object or NULL on error.',
'mapObj::drawReferenceMap' => 'Render reference map and return an image object.',
'mapObj::drawScaleBar' => 'Render scale bar and return an image object.',
'mapObj::embedLegend' => 'embeds a legend. Actually the legend is just added to the label
cache so you must invoke drawLabelCache() to actually do the
rendering (unless postlabelcache is set in which case it is
drawn right away). Returns MS_SUCCESS or MS_FAILURE on error.',
'mapObj::embedScalebar' => 'embeds a scalebar. Actually the scalebar is just added to the label
cache so you must invoke drawLabelCache() to actually do the rendering
(unless postlabelcache is set in which case it is drawn right away).
Returns MS_SUCCESS or MS_FAILURE on error.',
'mapObj::free' => 'Free the object properties and break the internal references.
Note that you have to unset the php variable to free totally the
resources.
void freeQuery(layerindex)
Frees the query result on a specified layer. If the layerindex is -1,
all queries on layers will be freed.',
'mapObj::generateSLD' => 'Returns an SLD XML string based on all the classes found in all
the layers that have `STATUS` `on`.',
'mapObj::getAllGroupNames' => 'Return an array containing all the group names used in the
layers. If there are no groups, it returns an empty array.',
'mapObj::getAllLayerNames' => 'Return an array containing all the layer names.
If there are no layers, it returns an empty array.',
'mapObj::getColorbyIndex' => 'Returns a colorObj corresponding to the color index in the
palette.',
'mapObj::getConfigOption' => 'Returns the config value associated with the key.
Returns an empty string if key not found.',
'mapObj::getLabel' => 'Returns a labelcacheMemberObj from the map given an index value
(0=first label).  Labelcache has to be enabled.
.. code-block:: php
while ($oLabelCacheMember = $oMap->getLabel($i)) {
 do something with the labelcachemember
++$i;
}',
'mapObj::getLayer' => 'Returns a layerObj from the map given an index value (0=first layer)',
'mapObj::getLayerByName' => 'Returns a layerObj from the map given a layer name.
Returns NULL if layer doesn\'t exist.',
'mapObj::getLayersDrawingOrder' => 'Return an array containing layer\'s index in the order which they
are drawn. If there are no layers, it returns an empty array.',
'mapObj::getLayersIndexByGroup' => 'Return an array containing all the layer\'s indexes given
a group name. If there are no layers, it returns an empty array.',
'mapObj::getMetaData' => 'Fetch metadata entry by name (stored in the :ref:`WEB` object in
the map file).  Returns "" if no entry matches the name.
.. note::
getMetaData\'s query is case sensitive.',
'mapObj::getNumSymbols' => 'Return the number of symbols in map.',
'mapObj::getOutputFormat' => 'Returns the outputformat at index position.',
'mapObj::getProjection' => 'Returns a string representation of the projection.
Returns NULL on error or if no projection is set.',
'mapObj::getSymbolByName' => 'Returns the symbol index using the name.',
'mapObj::getSymbolObjectById' => 'Returns the symbol object using a symbol id. Refer to
the symbol object reference section for more details.
int insertLayer( layerObj layer [, int nIndex=-1 ] )
Insert a copy of *layer* into the Map at index *nIndex*.  The
default value of *nIndex* is -1, which means the last possible
index.  Returns the index of the new Layer, or -1 in the case of a
failure.',
'mapObj::loadMapContext' => 'Available only if WMS support is enabled.  Load a :ref:`WMS Map
Context <map_context>` XML file into the current mapObj.  If the
map already contains some layers then the layers defined in the
WMS Map context document are added to the current map.  The 2nd
argument unique_layer_name is optional and if set to MS_TRUE
layers created will have a unique name (unique prefix added to the
name). If set to MS_FALSE the layer name will be the the same name
as in the context. The default value is MS_FALSE.  Returns
MS_SUCCESS/MS_FAILURE.',
'mapObj::loadOWSParameters' => 'Load OWS request parameters (BBOX, LAYERS, &c.) into map.  Returns
MS_SUCCESS or MS_FAILURE.  2nd argument version is not mandatory.
If not given, the version will be set to 1.1.1
int loadQuery(filename)
Loads a query from a file. Returns MS_SUCCESS or MS_FAILURE.
To be used with savequery.',
'mapObj::moveLayerDown' => 'Move layer down in the hierarchy of drawing.
Returns MS_SUCCESS or MS_FAILURE on error.',
'mapObj::moveLayerUp' => 'Move layer up in the hierarchy of drawing.
Returns MS_SUCCESS or MS_FAILURE on error.',
'mapObj::ms_newMapObjFromString' => 'Old style constructor',
'mapObj::offsetExtent' => 'Offset the map extent based on the given distances in map coordinates.
Returns MS_SUCCESS or MS_FAILURE.',
'mapObj::owsDispatch' => 'Processes and executes the passed OpenGIS Web Services request on
the map.  Returns MS_DONE (2) if there is no valid OWS request in
the req object, MS_SUCCESS (0) if an OWS request was successfully
processed and MS_FAILURE (1) if an OWS request was not
successfully processed.  OWS requests include :ref:`WMS
<wms_server>`, :ref:`WFS <wfs_server>`, :ref:`WCS <wcs_server>`
and :ref:`SOS <sos_server>` requests supported by MapServer.
Results of a dispatched request are written to stdout and can be
captured using the msIO services (ie. ms_ioinstallstdouttobuffer()
and ms_iogetstdoutbufferstring())',
'mapObj::prepareImage' => 'Return a blank image object.',
'mapObj::prepareQuery' => 'Calculate the scale of the map and set map->scaledenom.',
'mapObj::processLegendTemplate' => 'Process legend template files and return the result in a buffer.
.. seealso::
:ref:`processtemplate <processtemplate>`',
'mapObj::processQueryTemplate' => 'Process query template files and return the result in a buffer.
Second argument generateimages is not mandatory. If not given
it will be set to TRUE.
.. seealso::
:ref:`processtemplate <processtemplate>`
.. _processtemplate:',
'mapObj::processTemplate' => 'Process the template file specified in the web object and return the
result in a buffer. The processing consists of opening the template
file and replace all the tags found in it. Only tags that have an
equivalent element in the map object are replaced (ex [scaledenom]).
The are two exceptions to the previous statement :
- [img], [scalebar], [ref], [legend] would be replaced with the
appropriate url if the parameter generateimages is set to
MS_TRUE. (Note :  the images corresponding to the different objects
are generated if the object is set to MS_ON in the map file)
- the user can use the params parameter to specify tags and
their values. For example if the user have a specific tag call
[my_tag] and would like it to be replaced by "value_of_my_tag"
he would do
.. code-block:: php
$tmparray["my_tag"] = "value_of_my_tag";
$map->processtemplate($tmparray, MS_FALSE);',
'mapObj::queryByFeatures' => 'Perform a query based on a previous set of results from
a layer. At present the results MUST be based on a polygon layer.
Returns MS_SUCCESS if shapes were found or MS_FAILURE if nothing
was found or if some other error happened (note that the error
message in case nothing was found can be avoided in PHP using
the \'@\' control operator).',
'mapObj::queryByIndex' => 'Add a specific shape on a given layer to the query result.
If addtoquery (which is a non mandatory argument) is set to MS_TRUE,
the shape will be added to the existing query list. Default behavior
is to free the existing query list and add only the new shape.',
'mapObj::queryByPoint' => 'Query all selected layers in map at point location specified in
georeferenced map coordinates (i.e. not pixels).
The query is performed on all the shapes that are part of a :ref:`CLASS`
that contains a :ref:`TEMPLATE` value or that match any class in a
layer that contains a :ref:`LAYER` :ref:`TEMPLATE <template>` value.
Mode is MS_SINGLE or MS_MULTIPLE depending on number of results
you want.
Passing buffer -1 defaults to tolerances set in the map file
(in pixels) but you can use a constant buffer (specified in
ground units) instead.
Returns MS_SUCCESS if shapes were found or MS_FAILURE if nothing
was found or if some other error happened (note that the error
message in case nothing was found can be avoided in PHP using
the \'@\' control operator).',
'mapObj::queryByRect' => 'Query all selected layers in map using a rectangle specified in
georeferenced map coordinates (i.e. not pixels).  The query is
performed on all the shapes that are part of a :ref:`CLASS` that
contains a :ref:`TEMPLATE` value or that match any class in a
layer that contains a :ref:`LAYER` :ref:`TEMPLATE <template>`
value.  Returns MS_SUCCESS if shapes were found or MS_FAILURE if
nothing was found or if some other error happened (note that the
error message in case nothing was found can be avoided in PHP
using the \'@\' control operator).',
'mapObj::queryByShape' => 'Query all selected layers in map based on a single shape, the
shape has to be a polygon at this point.
Returns MS_SUCCESS if shapes were found or MS_FAILURE if nothing
was found or if some other error happened (note that the error
message in case nothing was found can be avoided in PHP using
the \'@\' control operator).',
'mapObj::removeLayer' => 'Remove a layer from the mapObj. The argument is the index of the
layer to be removed. Returns the removed layerObj on success, else
null.',
'mapObj::removeMetaData' => 'Remove a metadata entry for the map (stored in the WEB object in the map
file).  Returns MS_SUCCESS/MS_FAILURE.',
'mapObj::removeOutputFormat' => 'Remove outputformat from the map.
Returns MS_SUCCESS/MS_FAILURE.',
'mapObj::save' => 'Save current map object state to a file. Returns -1 on error.
Use absolute path. If a relative path is used, then it will be
relative to the mapfile location.',
'mapObj::saveMapContext' => 'Available only if WMS support is enabled.  Save current map object
state in :ref:`WMS Map Context <map_context>` format.  Only WMS
layers are saved in the WMS Map Context XML file.  Returns
MS_SUCCESS/MS_FAILURE.',
'mapObj::saveQuery' => 'Save the current query in a file. Results determines the save format -
MS_TRUE (or 1/true) saves the query results (tile index and shape index),
MS_FALSE (or 0/false) the query parameters (and the query will be re-run
in loadquery). Returns MS_SUCCESS or MS_FAILURE. Either save format can be
used with loadquery. See RFC 65 and ticket #3647 for details of different
save formats.',
'mapObj::scaleExtent' => 'Scale the map extent using the zoomfactor and ensure the extent
within the minscaledenom and maxscaledenom domain.  If
minscaledenom and/or maxscaledenom is 0 then the parameter is not
taken into account.  Returns MS_SUCCESS or MS_FAILURE.',
'mapObj::selectOutputFormat' => 'Selects the output format to be used in the map.
Returns MS_SUCCESS/MS_FAILURE.
.. note::
the type used should correspond to one of the output formats
declared in the map file.  The type argument passed is compared
with the mimetype parameter in the output format structure and
then to the name parameter in the structure.',
'mapObj::set' => 'Set map object property to new value.',
'mapObj::setCenter' => 'Set the map center to the given map point.
Returns MS_SUCCESS or MS_FAILURE.',
'mapObj::setConfigOption' => 'Sets a config parameter using the key and the value passed',
'mapObj::setExtent' => 'Set the map extents using the georef extents passed in argument.
Returns MS_SUCCESS or MS_FAILURE on error.',
'mapObj::setFontSet' => 'Load and set a new :ref:`fontset`.
boolean  setLayersDrawingOrder(array layeryindex)
Set the layer\'s order array. The argument passed must be a valid
array with all the layer\'s index.
Returns MS_SUCCESS or MS_FAILURE on error.',
'mapObj::setMetaData' => 'Set a metadata entry for the map (stored in the WEB object in the map
file).  Returns MS_SUCCESS/MS_FAILURE.',
'mapObj::setProjection' => 'Set map projection and coordinate system. Returns MS_SUCCESS or
MS_FAILURE on error.
Parameters are given as a single string of comma-delimited PROJ.4
parameters.  The argument : bSetUnitsAndExtents is used to
automatically update the map units and extents based on the new
projection. Possible values are MS_TRUE and MS_FALSE. By default it is
set at MS_FALSE.',
'mapObj::setRotation' => 'Set map rotation angle. The map view rectangle (specified in
EXTENTS) will be rotated by the indicated angle in the counter-
clockwise direction. Note that this implies the rendered map
will be rotated by the angle in the clockwise direction.
Returns MS_SUCCESS or MS_FAILURE.',
'mapObj::setSize' => 'Set the map width and height. This method updates the internal
geotransform and other data structures required for map rotation
so it should be used instead of setting the width and height members
directly.
Returns MS_SUCCESS or MS_FAILURE.',
'mapObj::setSymbolSet' => 'Load and set a symbol file dynamically.',
'mapObj::setWKTProjection' => 'Same as setProjection(), but takes an OGC WKT projection
definition string as input. Returns MS_SUCCESS or MS_FAILURE on error.
.. note::
setWKTProjection requires GDAL support',
'mapObj::zoomPoint' => 'Zoom to a given XY position. Returns MS_SUCCESS or MS_FAILURE on error.
Parameters are
- Zoom factor : positive values do zoom in, negative values
zoom out. Factor of 1 will recenter.
- Pixel position (pointObj) : x, y coordinates of the click,
with (0,0) at the top-left
- Width : width in pixel of the current image.
- Height : Height in pixel of the current image.
- Georef extent (rectObj) : current georef extents.
- MaxGeoref extent (rectObj) : (optional) maximum georef extents.
If provided then it will be impossible to zoom/pan outside of
those extents.',
'mapObj::zoomRectangle' => 'Set the map extents to a given extents. Returns MS_SUCCESS or
MS_FAILURE on error.
Parameters are :
- oPixelExt (rect object) : Pixel Extents
- Width : width in pixel of the current image.
- Height : Height in pixel of the current image.
- Georef extent (rectObj) : current georef extents.',
'mapObj::zoomScale' => 'Zoom in or out to a given XY position so that the map is
displayed at specified scale. Returns MS_SUCCESS or MS_FAILURE on error.
Parameters are :
- ScaleDenom : Scale denominator of the scale at which the map
should be displayed.
- Pixel position (pointObj) : x, y coordinates of the click,
with (0,0) at the top-left
- Width : width in pixel of the current image.
- Height : Height in pixel of the current image.
- Georef extent (rectObj) : current georef extents.
- MaxGeoref extent (rectObj) : (optional) maximum georef extents.
If provided then it will be impossible to zoom/pan outside of
those extents.',
'max' => 'Find highest value',
'maxdb_bind_param' => 'Alias of maxdb_stmt_bind_param',
'maxdb_bind_result' => 'Alias of maxdb_stmt_bind_result',
'maxdb_client_encoding' => 'Alias of maxdb_character_set_name',
'maxdb_connect_errno' => 'Returns the error code from last connect call',
'maxdb_connect_error' => 'Returns a string description of the last connect error',
'maxdb_debug' => 'Performs debugging operations',
'maxdb_disable_rpl_parse' => 'Disable RPL parse',
'maxdb_dump_debug_info' => 'Dump debugging information into the log',
'maxdb_embedded_connect' => 'Open a connection to an embedded MaxDB server',
'maxdb_enable_reads_from_master' => 'Enable reads from master',
'maxdb_enable_rpl_parse' => 'Enable RPL parse',
'maxdb_escape_string' => 'Alias of maxdb_real_escape_string',
'maxdb_execute' => 'Alias of maxdb_stmt_execute',
'maxdb_fetch' => 'Alias of maxdb_stmt_fetch',
'maxdb_get_client_info' => 'Returns the MaxDB client version as a string',
'maxdb_get_client_version' => 'Get MaxDB client info',
'maxdb_get_metadata' => 'Alias of maxdb_stmt_result_metadata',
'maxdb_init' => 'Initializes MaxDB and returns an resource for use with maxdb_real_connect',
'maxdb_master_query' => 'Enforce execution of a query on the master in a master/slave setup',
'maxdb_param_count' => 'Alias of maxdb_stmt_param_count',
'maxdb_report' => 'Enables or disables internal report functions',
'maxdb_rpl_parse_enabled' => 'Check if RPL parse is enabled',
'maxdb_rpl_probe' => 'RPL probe',
'maxdb_send_long_data' => 'Alias of maxdb_stmt_send_long_data',
'maxdb_server_end' => 'Shut down the embedded server',
'maxdb_server_init' => 'Initialize embedded server',
'maxdb_set_opt' => 'Alias of maxdb_options',
'maxdb_stmt_sqlstate' => 'Returns SQLSTATE error from previous statement operation',
'maxdb_thread_safe' => 'Returns whether thread safety is given or not',
'mb_check_encoding' => 'Check if the string is valid for the specified encoding',
'mb_chr' => 'Get a specific character',
'mb_convert_case' => 'Perform case folding on a string',
'mb_convert_encoding' => 'Convert character encoding',
'mb_convert_kana' => 'Convert "kana" one from another ("zen-kaku", "han-kaku" and more)',
'mb_convert_variables' => 'Convert character code in variable(s)',
'mb_decode_mimeheader' => 'Decode string in MIME header field',
'mb_decode_numericentity' => 'Decode HTML numeric string reference to character',
'mb_detect_encoding' => 'Detect character encoding',
'mb_detect_order' => 'Set/Get character encoding detection order',
'mb_encode_mimeheader' => 'Encode string for MIME header',
'mb_encode_numericentity' => 'Encode character to HTML numeric string reference',
'mb_encoding_aliases' => 'Get aliases of a known encoding type',
'mb_ereg' => 'Regular expression match with multibyte support',
'mb_ereg_match' => 'Regular expression match for multibyte string',
'mb_ereg_replace' => 'Replace regular expression with multibyte support',
'mb_ereg_replace_callback' => 'Perform a regular expression search and replace with multibyte support using a callback',
'mb_ereg_search' => 'Multibyte regular expression match for predefined multibyte string',
'mb_ereg_search_getpos' => 'Returns start point for next regular expression match',
'mb_ereg_search_getregs' => 'Retrieve the result from the last multibyte regular expression match',
'mb_ereg_search_init' => 'Setup string and regular expression for a multibyte regular expression match',
'mb_ereg_search_pos' => 'Returns position and length of a matched part of the multibyte regular expression for a predefined multibyte string',
'mb_ereg_search_regs' => 'Returns the matched part of a multibyte regular expression',
'mb_ereg_search_setpos' => 'Set start point of next regular expression match',
'mb_eregi' => 'Regular expression match ignoring case with multibyte support',
'mb_eregi_replace' => 'Replace regular expression with multibyte support ignoring case',
'mb_get_info' => 'Get internal settings of mbstring',
'mb_http_input' => 'Detect HTTP input character encoding',
'mb_http_output' => 'Set/Get HTTP output character encoding',
'mb_internal_encoding' => 'Set/Get internal character encoding',
'mb_language' => 'Set/Get current language',
'mb_list_encodings' => 'Returns an array of all supported encodings',
'mb_ord' => 'Get code point of character',
'mb_output_handler' => 'Callback function converts character encoding in output buffer',
'mb_parse_str' => 'Parse GET/POST/COOKIE data and set global variable',
'mb_preferred_mime_name' => 'Get MIME charset string',
'mb_regex_encoding' => 'Set/Get character encoding for multibyte regex',
'mb_regex_set_options' => 'Set/Get the default options for mbregex functions',
'mb_send_mail' => 'Send encoded mail',
'mb_split' => 'Split multibyte string using regular expression',
'mb_str_split' => 'Given a multibyte string, return an array of its characters',
'mb_strcut' => 'Get part of string',
'mb_strimwidth' => 'Get truncated string with specified width',
'mb_stripos' => 'Finds position of first occurrence of a string within another, case insensitive',
'mb_stristr' => 'Finds first occurrence of a string within another, case insensitive',
'mb_strlen' => 'Get string length',
'mb_strpos' => 'Find position of first occurrence of string in a string',
'mb_strrchr' => 'Finds the last occurrence of a character in a string within another',
'mb_strrichr' => 'Finds the last occurrence of a character in a string within another, case insensitive',
'mb_strripos' => 'Finds position of last occurrence of a string within another, case insensitive',
'mb_strrpos' => 'Find position of last occurrence of a string in a string',
'mb_strstr' => 'Finds first occurrence of a string within another',
'mb_strtolower' => 'Make a string lowercase',
'mb_strtoupper' => 'Make a string uppercase',
'mb_strwidth' => 'Return width of string',
'mb_substitute_character' => 'Set/Get substitution character',
'mb_substr' => 'Get part of string',
'mb_substr_count' => 'Count the number of substring occurrences',
'mcrypt_cbc' => 'Encrypts/decrypts data in CBC mode',
'mcrypt_cfb' => 'Encrypts/decrypts data in CFB mode',
'mcrypt_create_iv' => 'Creates an initialization vector (IV) from a random source',
'mcrypt_decrypt' => 'Decrypts crypttext with given parameters',
'mcrypt_ecb' => 'Deprecated: Encrypts/decrypts data in ECB mode',
'mcrypt_enc_get_algorithms_name' => 'Returns the name of the opened algorithm',
'mcrypt_enc_get_block_size' => 'Returns the blocksize of the opened algorithm',
'mcrypt_enc_get_iv_size' => 'Returns the size of the IV of the opened algorithm',
'mcrypt_enc_get_key_size' => 'Returns the maximum supported keysize of the opened mode',
'mcrypt_enc_get_modes_name' => 'Returns the name of the opened mode',
'mcrypt_enc_get_supported_key_sizes' => 'Returns an array with the supported keysizes of the opened algorithm',
'mcrypt_enc_is_block_algorithm' => 'Checks whether the algorithm of the opened mode is a block algorithm',
'mcrypt_enc_is_block_algorithm_mode' => 'Checks whether the encryption of the opened mode works on blocks',
'mcrypt_enc_is_block_mode' => 'Checks whether the opened mode outputs blocks',
'mcrypt_enc_self_test' => 'Runs a self test on the opened module',
'mcrypt_encrypt' => 'Encrypts plaintext with given parameters',
'mcrypt_generic' => 'This function encrypts data',
'mcrypt_generic_deinit' => 'This function deinitializes an encryption module',
'mcrypt_generic_end' => 'This function terminates encryption',
'mcrypt_generic_init' => 'This function initializes all buffers needed for encryption',
'mcrypt_get_block_size' => 'Gets the block size of the specified cipher',
'mcrypt_get_cipher_name' => 'Gets the name of the specified cipher',
'mcrypt_get_iv_size' => 'Returns the size of the IV belonging to a specific cipher/mode combination',
'mcrypt_get_key_size' => 'Gets the key size of the specified cipher',
'mcrypt_list_algorithms' => 'Gets an array of all supported ciphers',
'mcrypt_list_modes' => 'Gets an array of all supported modes',
'mcrypt_module_close' => 'Closes the mcrypt module',
'mcrypt_module_get_algo_block_size' => 'Returns the blocksize of the specified algorithm',
'mcrypt_module_get_algo_key_size' => 'Returns the maximum supported keysize of the opened mode',
'mcrypt_module_get_supported_key_sizes' => 'Returns an array with the supported keysizes of the opened algorithm',
'mcrypt_module_is_block_algorithm' => 'This function checks whether the specified algorithm is a block algorithm',
'mcrypt_module_is_block_algorithm_mode' => 'Returns if the specified module is a block algorithm or not',
'mcrypt_module_is_block_mode' => 'Returns if the specified mode outputs blocks or not',
'mcrypt_module_open' => 'Opens the module of the algorithm and the mode to be used',
'mcrypt_module_self_test' => 'This function runs a self test on the specified module',
'mcrypt_ofb' => 'Encrypts/decrypts data in OFB mode',
'md5' => 'Calculate the md5 hash of a string',
'md5_file' => 'Calculates the md5 hash of a given file',
'mdecrypt_generic' => 'Decrypts data',
'memcache::add' => 'Add an item to the server',
'memcache::addServer' => 'Add a memcached server to connection pool',
'memcache::close' => 'Close memcached server connection',
'memcache::connect' => 'Open memcached server connection',
'memcache::decrement' => 'Decrement item\'s value',
'memcache::delete' => 'Delete item from the server',
'memcache::flush' => 'Flush all existing items at the server',
'memcache::get' => 'Retrieve item from the server',
'memcache::getExtendedStats' => 'Get statistics from all servers in pool',
'memcache::getServerStatus' => 'Returns server status',
'memcache::getStats' => 'Get statistics of the server',
'memcache::getVersion' => 'Return version of the server',
'memcache::increment' => 'Increment item\'s value',
'memcache::pconnect' => 'Open memcached server persistent connection',
'memcache::replace' => 'Replace value of the existing item',
'memcache::set' => 'Store data at the server',
'memcache::setCompressThreshold' => 'Enable automatic compression of large values',
'memcache::setServerParams' => 'Changes server parameters and status at runtime',
'memcache_debug' => 'Turn debug output on/off',
'memcached::__construct' => 'Create a Memcached instance',
'memcached::add' => 'Add an item under a new key',
'memcached::addByKey' => 'Add an item under a new key on a specific server',
'memcached::addServer' => 'Add a server to the server pool',
'memcached::addServers' => 'Add multiple servers to the server pool',
'memcached::append' => 'Append data to an existing item',
'memcached::appendByKey' => 'Append data to an existing item on a specific server',
'memcached::cas' => 'Compare and swap an item',
'memcached::casByKey' => 'Compare and swap an item on a specific server',
'memcached::decrement' => 'Decrement numeric item\'s value',
'memcached::decrementByKey' => 'Decrement numeric item\'s value, stored on a specific server',
'memcached::delete' => 'Delete an item',
'memcached::deleteByKey' => 'Delete an item from a specific server',
'memcached::deleteMulti' => 'Delete multiple items',
'memcached::deleteMultiByKey' => 'Delete multiple items from a specific server',
'memcached::fetch' => 'Fetch the next result',
'memcached::fetchAll' => 'Fetch all the remaining results',
'memcached::flush' => 'Invalidate all items in the cache',
'memcached::get' => 'Retrieve an item',
'memcached::getAllKeys' => 'Gets the keys stored on all the servers',
'memcached::getByKey' => 'Retrieve an item from a specific server',
'memcached::getDelayed' => 'Request multiple items',
'memcached::getDelayedByKey' => 'Request multiple items from a specific server',
'memcached::getMulti' => 'Retrieve multiple items',
'memcached::getMultiByKey' => 'Retrieve multiple items from a specific server',
'memcached::getOption' => 'Retrieve a Memcached option value',
'memcached::getResultCode' => 'Return the result code of the last operation',
'memcached::getResultMessage' => 'Return the message describing the result of the last operation',
'memcached::getServerByKey' => 'Map a key to a server',
'memcached::getServerList' => 'Get the list of the servers in the pool',
'memcached::getStats' => 'Get server pool statistics',
'memcached::getVersion' => 'Get server pool version info',
'memcached::increment' => 'Increment numeric item\'s value',
'memcached::incrementByKey' => 'Increment numeric item\'s value, stored on a specific server',
'memcached::isPersistent' => 'Check if a persitent connection to memcache is being used',
'memcached::isPristine' => 'Check if the instance was recently created',
'memcached::prepend' => 'Prepend data to an existing item',
'memcached::prependByKey' => 'Prepend data to an existing item on a specific server',
'memcached::quit' => 'Close any open connections',
'memcached::replace' => 'Replace the item under an existing key',
'memcached::replaceByKey' => 'Replace the item under an existing key on a specific server',
'memcached::resetServerList' => 'Clears all servers from the server list',
'memcached::set' => 'Store an item',
'memcached::setByKey' => 'Store an item on a specific server',
'memcached::setMulti' => 'Store multiple items',
'memcached::setMultiByKey' => 'Store multiple items on a specific server',
'memcached::setOption' => 'Set a Memcached option',
'memcached::setOptions' => 'Set Memcached options',
'memcached::setSaslAuthData' => 'Set the credentials to use for authentication',
'memcached::touch' => 'Set a new expiration on an item',
'memcached::touchByKey' => 'Set a new expiration on an item on a specific server',
'MemcachedException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'MemcachedException::__toString' => 'String representation of the exception',
'MemcachedException::getCode' => 'Gets the Exception code',
'MemcachedException::getFile' => 'Gets the file in which the exception occurred',
'MemcachedException::getLine' => 'Gets the line in which the exception occurred',
'MemcachedException::getMessage' => 'Gets the Exception message',
'MemcachedException::getPrevious' => 'Returns previous Exception',
'MemcachedException::getTrace' => 'Gets the stack trace',
'MemcachedException::getTraceAsString' => 'Gets the stack trace as a string',
'MemcachePool::add' => 'Add an item to the server. If the key already exists, the value will not be added and <b>FALSE</b> will be returned.',
'MemcachePool::addServer' => 'Add a memcached server to connection pool',
'MemcachePool::close' => 'Close memcached server connection',
'MemcachePool::connect' => 'Open memcached server connection',
'MemcachePool::decrement' => 'Decrement item\'s value',
'MemcachePool::delete' => 'Delete item from the server
https://secure.php.net/manual/ru/memcache.delete.php',
'MemcachePool::flush' => 'Flush all existing items at the server',
'MemcachePool::get' => 'Retrieve item from the server',
'MemcachePool::getExtendedStats' => 'Get statistics from all servers in pool',
'MemcachePool::getServerStatus' => 'Returns server status',
'MemcachePool::getStats' => 'Get statistics of the server',
'MemcachePool::getVersion' => 'Return version of the server',
'MemcachePool::increment' => 'Increment item\'s value',
'MemcachePool::replace' => 'Replace value of the existing item',
'MemcachePool::set' => 'Stores an item var with key on the memcached server. Parameter expire is expiration time in seconds.
If it\'s 0, the item never expires (but memcached server doesn\'t guarantee this item to be stored all the time,
it could be deleted from the cache to make place for other items).
You can use MEMCACHE_COMPRESSED constant as flag value if you want to use on-the-fly compression (uses zlib).',
'MemcachePool::setCompressThreshold' => 'Enable automatic compression of large values',
'MemcachePool::setServerParams' => 'Changes server parameters and status at runtime',
'memory_get_peak_usage' => 'Returns the peak of memory allocated by PHP',
'memory_get_usage' => 'Returns the amount of memory allocated to PHP',
'MessageFormatter::__construct' => 'Constructs a new Message Formatter',
'MessageFormatter::create' => 'Constructs a new Message Formatter',
'messageformatter::format' => 'Format the message',
'messageformatter::formatMessage' => 'Quick format message',
'messageformatter::getErrorCode' => 'Get the error code from last operation',
'messageformatter::getErrorMessage' => 'Get the error text from the last operation',
'messageformatter::getLocale' => 'Get the locale for which the formatter was created',
'messageformatter::getPattern' => 'Get the pattern used by the formatter',
'messageformatter::parse' => 'Parse input string according to pattern',
'messageformatter::parseMessage' => 'Quick parse input string',
'messageformatter::setPattern' => 'Set the pattern used by the formatter',
'metaphone' => 'Calculate the metaphone key of a string',
'method_exists' => 'Checks if the class method exists',
'mhash' => 'Computes hash',
'mhash_count' => 'Gets the highest available hash ID',
'mhash_get_block_size' => 'Gets the block size of the specified hash',
'mhash_get_hash_name' => 'Gets the name of the specified hash',
'mhash_keygen_s2k' => 'Generates a key',
'microtime' => 'Return current Unix timestamp with microseconds',
'mime_content_type' => 'Detect MIME Content-type for a file',
'min' => 'Find lowest value',
'ming_keypress' => 'Returns the action flag for keyPress(char)',
'ming_setcubicthreshold' => 'Set cubic threshold',
'ming_setscale' => 'Set the global scaling factor',
'ming_setswfcompression' => 'Sets the SWF output compression',
'ming_useconstants' => 'Use constant pool',
'ming_useswfversion' => 'Sets the SWF version',
'mkdir' => 'Makes directory',
'mktime' => 'Get Unix timestamp for a date',
'money_format' => 'Formats a number as a currency string',
'mongo::__construct' => 'The __construct purpose',
'Mongo::__get' => 'Gets a database',
'Mongo::__toString' => 'String representation of this connection',
'Mongo::close' => 'Closes this database connection
This method does not need to be called, except in unusual circumstances.
The driver will cleanly close the database connection when the Mongo object goes out of scope.',
'Mongo::connect' => 'Connects to a database server',
'mongo::connectUtil' => 'Connects with a database server',
'Mongo::dropDB' => '`@return array` The database response.',
'Mongo::forceError' => 'Creates a database error on the database.',
'Mongo::getConnections' => 'Get connections
Returns an array of all open connections, and information about each of the servers',
'Mongo::getHosts' => 'Get hosts
This method is only useful with a connection to a replica set. It returns the status of all of the hosts in the
set. Without a replica set, it will just return an array with one element containing the host that you are
connected to.',
'mongo::getPoolSize' => 'Get pool size for connection pools',
'Mongo::getReadPreference' => 'Get read preference
Get the read preference for this connection',
'mongo::getSlave' => 'Returns the address being used by this for slaveOkay reads',
'mongo::getSlaveOkay' => 'Get slaveOkay setting for this connection',
'Mongo::getWriteConcern' => 'Get the write concern for this connection',
'Mongo::killCursor' => 'Kills a specific cursor on the server',
'Mongo::lastError' => 'Check if there was an error on the most recent db operation performed',
'Mongo::listDBs' => 'Lists all of the databases available',
'Mongo::pairConnect' => 'Connects to paired database server',
'Mongo::pairPersistConnect' => 'Creates a persistent connection with paired database servers',
'Mongo::persistConnect' => 'Creates a persistent connection with a database server',
'mongo::poolDebug' => 'Returns information about all connection pools',
'Mongo::prevError' => 'Checks for the last error thrown during a database operation',
'Mongo::resetError' => 'Clears any flagged errors on the connection',
'Mongo::selectCollection' => 'Gets a database collection',
'Mongo::selectDB' => 'Gets a database',
'mongo::setPoolSize' => 'Set the size for future connection pools',
'Mongo::setReadPreference' => 'Set read preference',
'mongo::setSlaveOkay' => 'Change slaveOkay setting for this connection',
'mongo::switchSlave' => 'Choose a new secondary for slaveOkay reads',
'mongobindata::__construct' => 'Creates a new binary data object',
'mongobindata::__toString' => 'The string representation of this binary data object',
'mongoclient::__construct' => 'Creates a new database connection object',
'mongoclient::__get' => 'Gets a database',
'mongoclient::__toString' => 'String representation of this connection',
'mongoclient::close' => 'Closes this connection',
'mongoclient::connect' => 'Connects to a database server',
'mongoclient::dropDB' => 'Drops a database [deprecated]',
'mongoclient::getConnections' => 'Return info about all open connections',
'mongoclient::getHosts' => 'Updates status for all associated hosts',
'mongoclient::getReadPreference' => 'Get the read preference for this connection',
'mongoclient::getWriteConcern' => 'Get the write concern for this connection',
'mongoclient::killCursor' => 'Kills a specific cursor on the server',
'mongoclient::listDBs' => 'Lists all of the databases available',
'mongoclient::selectCollection' => 'Gets a database collection',
'mongoclient::selectDB' => 'Gets a database',
'mongoclient::setReadPreference' => 'Set the read preference for this connection',
'mongoclient::setWriteConcern' => 'Set the write concern for this connection',
'MongoClient::switchSlave' => 'Choose a new secondary for slaveOkay reads',
'mongocode::__construct' => 'Creates a new code object',
'mongocode::__toString' => 'Returns this code as a string',
'MongoCollection::__construct' => 'Creates a new collection',
'MongoCollection::__get' => 'Gets a collection',
'MongoCollection::__toString' => 'String representation of this collection',
'MongoCollection::aggregate' => '<p>
The MongoDB
{@link https://docs.mongodb.org/manual/applications/aggregation/ aggregation framework}
provides a means to calculate aggregated values without having to use
MapReduce. While MapReduce is powerful, it is often more difficult than
necessary for many simple aggregation tasks, such as totaling or averaging
field values.
</p>
<p>
This method accepts either a variable amount of pipeline operators, or a
single array of operators constituting the pipeline.
</p>',
'MongoCollection::aggregateCursor' => '<p>
With this method you can execute Aggregation Framework pipelines and retrieve the results
through a cursor, instead of getting just one document back as you would with
{@link https://php.net/manual/en/mongocollection.aggregate.php MongoCollection::aggregate()}.
This method returns a {@link https://php.net/manual/en/class.mongocommandcursor.php MongoCommandCursor} object.
This cursor object implements the {@link https://php.net/manual/en/class.iterator.php Iterator} interface
just like the {@link https://php.net/manual/en/class.mongocursor.php MongoCursor} objects that are returned
by the {@link https://php.net/manual/en/mongocollection.find.php MongoCollection::find()} method
</p>',
'MongoCollection::batchInsert' => 'Inserts multiple documents into this collection',
'MongoCollection::count' => 'Counts the number of documents in this collection',
'MongoCollection::createDBRef' => 'Creates a database reference',
'MongoCollection::createIndex' => 'Creates an index on the given field(s), or does nothing if the index already exists',
'MongoCollection::deleteIndex' => 'Deletes an index from this collection',
'MongoCollection::deleteIndexes' => 'Delete all indexes for this collection',
'MongoCollection::distinct' => 'Retrieve a list of distinct values for the given key across a collection',
'MongoCollection::drop' => 'Drops this collection',
'MongoCollection::ensureIndex' => '`@return boolean` always true',
'MongoCollection::find' => 'Queries this collection',
'MongoCollection::findAndModify' => 'Update a document and return it',
'MongoCollection::findOne' => 'Queries this collection, returning a single element',
'MongoCollection::getDBRef' => 'Fetches the document pointed to by a database reference',
'MongoCollection::getIndexInfo' => 'Returns an array of index names for this collection',
'MongoCollection::getName' => 'Returns this collection\'s name',
'MongoCollection::getSlaveOkay' => '<p>
See {@link https://secure.php.net/manual/en/mongo.queries.php the query section} of this manual for
information on distributing reads to secondaries.
</p>',
'MongoCollection::group' => 'Performs an operation similar to SQL\'s GROUP BY command',
'MongoCollection::insert' => 'Inserts an array into the collection',
'MongoCollection::remove' => 'Remove records from this collection',
'MongoCollection::save' => 'Saves an object to this collection',
'MongoCollection::setSlaveOkay' => '<p>
See {@link https://secure.php.net/manual/en/mongo.queries.php the query section} of this manual for
information on distributing reads to secondaries.
</p>',
'MongoCollection::update' => 'Update records based on a given criteria',
'MongoCollection::validate' => 'Validates this collection',
'mongocommandcursor::__construct' => 'Create a new command cursor',
'mongocommandcursor::batchSize' => 'Limits the number of elements returned in one batch',
'mongocommandcursor::createFromDocument' => 'Create a new command cursor from an existing command response document',
'mongocommandcursor::current' => 'Returns the current element',
'mongocommandcursor::dead' => 'Checks if there are results that have not yet been sent from the database',
'mongocommandcursor::getReadPreference' => 'Get the read preference for this command',
'mongocommandcursor::info' => 'Gets information about the cursor\'s creation and iteration',
'mongocommandcursor::key' => 'Returns the current result\'s index within the result set',
'mongocommandcursor::next' => 'Advances the cursor to the next result',
'mongocommandcursor::rewind' => 'Executes the command and resets the cursor to the start of the result set',
'mongocommandcursor::setReadPreference' => 'Set the read preference for this command',
'mongocommandcursor::timeout' => 'Sets a client-side timeout for this command',
'mongocommandcursor::valid' => 'Checks if the cursor is reading a valid result',
'MongoCursor::__construct' => 'Create a new cursor',
'MongoCursor::addOption' => 'Adds a top-level key/value pair to a query',
'MongoCursor::awaitData' => 'Sets whether this cursor will wait for a while for a tailable cursor to return more data',
'MongoCursor::batchSize' => 'PECL mongo >=1.0.11
Limits the number of elements returned in one batch.
<p>A cursor typically fetches a batch of result objects and store them locally.
This method sets the batchSize value to configure the amount of documents retrieved from the server in one data packet.
However, it will never return more documents than fit in the max batch size limit (usually 4MB).',
'MongoCursor::count' => 'Counts the number of results for this query',
'MongoCursor::current' => 'Returns the current element',
'MongoCursor::dead' => 'Checks if there are documents that have not been sent yet from the database for this cursor',
'MongoCursor::doQuery' => 'Execute the query',
'MongoCursor::explain' => 'Return an explanation of the query, often useful for optimization and debugging',
'MongoCursor::fields' => 'Sets the fields for a query',
'MongoCursor::getNext' => 'Return the next object to which this cursor points, and advance the cursor',
'MongoCursor::hasNext' => 'Checks if there are any more elements in this cursor',
'MongoCursor::hint' => 'Gives the database a hint about the query',
'MongoCursor::immortal' => 'Sets whether this cursor will timeout',
'MongoCursor::info' => 'Gets the query, fields, limit, and skip for this cursor',
'MongoCursor::key' => 'Returns the current result\'s _id',
'MongoCursor::limit' => 'Limits the number of results returned',
'MongoCursor::maxTimeMS' => '(PECL mongo >=1.5.0)
Sets a server-side timeout for this query',
'MongoCursor::next' => 'Advances the cursor to the next result',
'MongoCursor::reset' => 'Clears the cursor',
'MongoCursor::rewind' => 'Returns the cursor to the beginning of the result set',
'MongoCursor::skip' => 'Skips a number of results',
'MongoCursor::slaveOkay' => 'Sets whether this query can be done on a slave
This method will override the static class variable slaveOkay.',
'MongoCursor::snapshot' => 'Use snapshot mode for the query',
'MongoCursor::sort' => 'Sorts the results by given fields',
'MongoCursor::tailable' => 'Sets whether this cursor will be left open after fetching the last results',
'MongoCursor::timeout' => 'Sets a client-side timeout for this query',
'MongoCursor::valid' => 'Checks if the cursor is reading a valid result.',
'MongoCursorException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'MongoCursorException::__construct' => 'Construct the exception. Note: The message is NOT binary safe.',
'MongoCursorException::__toString' => 'String representation of the exception',
'MongoCursorException::getCode' => 'Gets the Exception code',
'MongoCursorException::getFile' => 'Gets the file in which the exception occurred',
'mongocursorexception::getHost' => 'The hostname of the server that encountered the error',
'MongoCursorException::getLine' => 'Gets the line in which the exception occurred',
'MongoCursorException::getMessage' => 'Gets the Exception message',
'MongoCursorException::getPrevious' => 'Returns previous Exception',
'MongoCursorException::getTrace' => 'Gets the stack trace',
'MongoCursorException::getTraceAsString' => 'Gets the stack trace as a string',
'mongocursorinterface::batchSize' => 'Limits the number of elements returned in one batch',
'MongoCursorInterface::current' => 'Return the current element',
'mongocursorinterface::dead' => 'Checks if there are results that have not yet been sent from the database',
'mongocursorinterface::getReadPreference' => 'Get the read preference for this query',
'mongocursorinterface::info' => 'Gets information about the cursor\'s creation and iteration',
'MongoCursorInterface::key' => 'Return the key of the current element',
'MongoCursorInterface::next' => 'Move forward to next element',
'MongoCursorInterface::rewind' => 'Rewind the Iterator to the first element',
'mongocursorinterface::setReadPreference' => 'Set the read preference for this query',
'mongocursorinterface::timeout' => 'Sets a client-side timeout for this query',
'MongoCursorInterface::valid' => 'Checks if current position is valid',
'mongodate::__construct' => 'Creates a new date',
'mongodate::__toString' => 'Returns a string representation of this date',
'mongodate::toDateTime' => 'Returns a DateTime object representing this date',
'MongoDB::__construct' => 'Creates a new database
This method is not meant to be called directly. The preferred way to create an instance of MongoDB is through {@see Mongo::__get()} or {@see Mongo::selectDB()}.',
'MongoDB::__get' => 'Gets a collection',
'MongoDB::__toString' => 'The name of this database',
'MongoDB::authenticate' => 'Log in to this database',
'MongoDB::command' => 'Execute a database command',
'MongoDB::createCollection' => 'Creates a collection',
'MongoDB::createDBRef' => 'Creates a database reference',
'MongoDB::drop' => 'Drops this database',
'MongoDB::execute' => 'Runs JavaScript code on the database server.',
'MongoDB::forceError' => 'Creates a database error',
'MongoDB::getDBRef' => 'Fetches the document pointed to by a database reference',
'MongoDB::getGridFS' => 'Fetches toolkit for dealing with files stored in this database',
'MongoDB::getProfilingLevel' => 'Gets this database\'s profiling level',
'MongoDB::getReadPreference' => 'Get the read preference for this database',
'MongoDB::getSlaveOkay' => 'Get slaveOkay setting for this database',
'MongoDB::getWriteConcern' => 'Get the write concern for this database',
'MongoDB::lastError' => 'Check if there was an error on the most recent db operation performed',
'MongoDB::listCollections' => 'Get a list of collections in this database',
'MongoDB::prevError' => 'Checks for the last error thrown during a database operation',
'MongoDB::repair' => 'Repairs and compacts this database',
'MongoDB::resetError' => 'Clears any flagged errors on the database',
'MongoDB::selectCollection' => 'Gets a collection',
'MongoDB::setProfilingLevel' => 'Sets this database\'s profiling level',
'MongoDB::setReadPreference' => 'Set the read preference for this database',
'MongoDB::setSlaveOkay' => 'Change slaveOkay setting for this database',
'mongodb\bson\binary::__construct' => 'Construct a new Binary',
'mongodb\bson\binary::__toString' => 'Returns the Binary\'s data',
'mongodb\bson\binary::getData' => 'Returns the Binary\'s data',
'mongodb\bson\binary::getType' => 'Returns the Binary\'s type',
'mongodb\bson\binary::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'mongodb\bson\binary::serialize' => 'Serialize a Binary',
'mongodb\bson\binary::unserialize' => 'Unserialize a Binary',
'mongodb\bson\binaryinterface::__toString' => 'Returns the BinaryInterface\'s data',
'mongodb\bson\binaryinterface::getData' => 'Returns the BinaryInterface\'s data',
'mongodb\bson\binaryinterface::getType' => 'Returns the BinaryInterface\'s type',
'mongodb\bson\dbpointer::__construct' => 'Construct a new DBPointer (unused)',
'mongodb\bson\dbpointer::__toString' => 'Returns an empty string',
'mongodb\bson\dbpointer::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'mongodb\bson\dbpointer::serialize' => 'Serialize a DBPointer',
'mongodb\bson\dbpointer::unserialize' => 'Unserialize a DBPointer',
'mongodb\bson\decimal128::__construct' => 'Construct a new Decimal128',
'mongodb\bson\decimal128::__toString' => 'Returns the string representation of this Decimal128',
'mongodb\bson\decimal128::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'mongodb\bson\decimal128::serialize' => 'Serialize a Decimal128',
'mongodb\bson\decimal128::unserialize' => 'Unserialize a Decimal128',
'mongodb\bson\decimal128interface::__toString' => 'Returns the string representation of this Decimal128Interface',
'MongoDB\BSON\fromJSON' => 'Returns the BSON representation of a JSON value
Converts an extended JSON string to its BSON representation.',
'MongoDB\BSON\fromPHP' => 'Returns the BSON representation of a PHP value
Serializes a PHP array or object (e.g. document) to its BSON representation. The returned binary string will describe a BSON document.',
'mongodb\bson\int64::__construct' => 'Construct a new Int64 (unused)',
'mongodb\bson\int64::__toString' => 'Returns the string representation of this Int64',
'mongodb\bson\int64::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'mongodb\bson\int64::serialize' => 'Serialize an Int64',
'mongodb\bson\int64::unserialize' => 'Unserialize an Int64',
'mongodb\bson\javascript::__construct' => 'Construct a new Javascript',
'mongodb\bson\javascript::__toString' => 'Returns the Javascript\'s code',
'mongodb\bson\javascript::getCode' => 'Returns the Javascript\'s code',
'mongodb\bson\javascript::getScope' => 'Returns the Javascript\'s scope document',
'mongodb\bson\javascript::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'mongodb\bson\javascript::serialize' => 'Serialize a Javascript',
'mongodb\bson\javascript::unserialize' => 'Unserialize a Javascript',
'mongodb\bson\javascriptinterface::__toString' => 'Returns the JavascriptInterface\'s code',
'mongodb\bson\javascriptinterface::getCode' => 'Returns the JavascriptInterface\'s code',
'mongodb\bson\javascriptinterface::getScope' => 'Returns the JavascriptInterface\'s scope document',
'mongodb\bson\maxkey::__construct' => 'Construct a new MaxKey',
'mongodb\bson\maxkey::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'mongodb\bson\maxkey::serialize' => 'Serialize a MaxKey',
'mongodb\bson\maxkey::unserialize' => 'Unserialize a MaxKey',
'mongodb\bson\minkey::__construct' => 'Construct a new MinKey',
'mongodb\bson\minkey::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'mongodb\bson\minkey::serialize' => 'Serialize a MinKey',
'mongodb\bson\minkey::unserialize' => 'Unserialize a MinKey',
'mongodb\bson\objectid::__construct' => 'Construct a new ObjectId',
'mongodb\bson\objectid::__toString' => 'Returns the hexadecimal representation of this ObjectId',
'mongodb\bson\objectid::getTimestamp' => 'Returns the timestamp component of this ObjectId',
'mongodb\bson\objectid::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'mongodb\bson\objectid::serialize' => 'Serialize an ObjectId',
'mongodb\bson\objectid::unserialize' => 'Unserialize an ObjectId',
'MongoDB\BSON\ObjectIdInterface::__construct' => 'Construct a new ObjectId',
'mongodb\bson\objectidinterface::__toString' => 'Returns the hexadecimal representation of this ObjectIdInterface',
'mongodb\bson\objectidinterface::getTimestamp' => 'Returns the timestamp component of this ObjectIdInterface',
'mongodb\bson\regex::__construct' => 'Construct a new Regex',
'mongodb\bson\regex::__toString' => 'Returns the string representation of this Regex',
'mongodb\bson\regex::getFlags' => 'Returns the Regex\'s flags',
'mongodb\bson\regex::getPattern' => 'Returns the Regex\'s pattern',
'mongodb\bson\regex::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'mongodb\bson\regex::serialize' => 'Serialize a Regex',
'mongodb\bson\regex::unserialize' => 'Unserialize a Regex',
'mongodb\bson\regexinterface::__toString' => 'Returns the string representation of this RegexInterface',
'mongodb\bson\regexinterface::getFlags' => 'Returns the RegexInterface\'s flags',
'mongodb\bson\regexinterface::getPattern' => 'Returns the RegexInterface\'s pattern',
'mongodb\bson\serializable::bsonSerialize' => 'Provides an array or document to serialize as BSON',
'mongodb\bson\symbol::__construct' => 'Construct a new Symbol (unused)',
'mongodb\bson\symbol::__toString' => 'Returns the Symbol as a string',
'mongodb\bson\symbol::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'mongodb\bson\symbol::serialize' => 'Serialize a Symbol',
'mongodb\bson\symbol::unserialize' => 'Unserialize a Symbol',
'mongodb\bson\timestamp::__construct' => 'Construct a new Timestamp',
'mongodb\bson\timestamp::__toString' => 'Returns the string representation of this Timestamp',
'mongodb\bson\timestamp::getIncrement' => 'Returns the increment component of this Timestamp',
'mongodb\bson\timestamp::getTimestamp' => 'Returns the timestamp component of this Timestamp',
'mongodb\bson\timestamp::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'mongodb\bson\timestamp::serialize' => 'Serialize a Timestamp',
'mongodb\bson\timestamp::unserialize' => 'Unserialize a Timestamp',
'mongodb\bson\timestampinterface::__toString' => 'Returns the string representation of this TimestampInterface',
'mongodb\bson\timestampinterface::getIncrement' => 'Returns the increment component of this TimestampInterface',
'mongodb\bson\timestampinterface::getTimestamp' => 'Returns the timestamp component of this TimestampInterface',
'MongoDB\BSON\toCanonicalExtendedJSON' => 'Converts a BSON string to its Canonical Extended JSON representation.
The canonical format prefers type fidelity at the expense of concise output and is most suited for producing
output that can be converted back to BSON without any loss of type information
(e.g. numeric types will remain differentiated).',
'MongoDB\BSON\toJSON' => 'Returns the JSON representation of a BSON value
Converts a BSON string to its extended JSON representation.',
'MongoDB\BSON\toPHP' => 'Returns the PHP representation of a BSON value
Unserializes a BSON document (i.e. binary string) to its PHP representation.
The typeMap parameter may be used to control the PHP types used for converting BSON arrays and documents (both root and embedded).',
'MongoDB\BSON\toRelaxedExtendedJSON' => 'Converts a BSON string to its » Relaxed Extended JSON representation.
The relaxed format prefers use of JSON type primitives at the expense of type fidelity and is most suited for
producing output that can be easily consumed by web APIs and humans.',
'mongodb\bson\undefined::__construct' => 'Construct a new Undefined (unused)',
'mongodb\bson\undefined::__toString' => 'Returns an empty string',
'mongodb\bson\undefined::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'mongodb\bson\undefined::serialize' => 'Serialize a Undefined',
'mongodb\bson\undefined::unserialize' => 'Unserialize a Undefined',
'mongodb\bson\unserializable::bsonUnserialize' => 'Constructs the object from a BSON array or document',
'mongodb\bson\utcdatetime::__construct' => 'Construct a new UTCDateTime',
'mongodb\bson\utcdatetime::__toString' => 'Returns the string representation of this UTCDateTime',
'MongoDB\BSON\UTCDateTime::getIncrement' => 'Returns the increment component of this TimestampInterface',
'MongoDB\BSON\UTCDateTime::getTimestamp' => 'Returns the timestamp component of this TimestampInterface',
'mongodb\bson\utcdatetime::jsonSerialize' => 'Returns a representation that can be converted to JSON',
'mongodb\bson\utcdatetime::serialize' => 'Serialize a UTCDateTime',
'mongodb\bson\utcdatetime::toDateTime' => 'Returns the DateTime representation of this UTCDateTime',
'mongodb\bson\utcdatetime::unserialize' => 'Unserialize a UTCDateTime',
'mongodb\bson\utcdatetimeinterface::__toString' => 'Returns the string representation of this UTCDateTimeInterface',
'mongodb\bson\utcdatetimeinterface::toDateTime' => 'Returns the DateTime representation of this UTCDateTimeInterface',
'mongodb\driver\bulkwrite::__construct' => 'Create a new BulkWrite',
'mongodb\driver\bulkwrite::count' => 'Count number of write operations in the bulk',
'mongodb\driver\bulkwrite::delete' => 'Add a delete operation to the bulk',
'mongodb\driver\bulkwrite::insert' => 'Add an insert operation to the bulk',
'mongodb\driver\bulkwrite::update' => 'Add an update operation to the bulk',
'mongodb\driver\clientencryption::createDataKey' => 'Create a new encryption data key',
'mongodb\driver\clientencryption::decrypt' => 'Decrypt a value',
'mongodb\driver\clientencryption::encrypt' => 'Encrypt a value',
'mongodb\driver\command::__construct' => 'Create a new Command',
'mongodb\driver\cursor::__construct' => 'Create a new Cursor (not used)',
'mongodb\driver\cursor::getId' => 'Returns the ID for this cursor',
'mongodb\driver\cursor::getServer' => 'Returns the server associated with this cursor',
'mongodb\driver\cursor::isDead' => 'Checks if the cursor may have additional results',
'mongodb\driver\cursor::setTypeMap' => 'Sets a type map to use for BSON unserialization',
'mongodb\driver\cursor::toArray' => 'Returns an array containing all results for this cursor',
'mongodb\driver\cursorid::__construct' => 'Create a new CursorId (not used)',
'mongodb\driver\cursorid::__toString' => 'String representation of the cursor ID',
'mongodb\driver\cursorid::serialize' => 'Serialize a CursorId',
'mongodb\driver\cursorid::unserialize' => 'Unserialize a CursorId',
'mongodb\driver\cursorinterface::getId' => 'Returns the ID for this cursor',
'mongodb\driver\cursorinterface::getServer' => 'Returns the server associated with this cursor',
'mongodb\driver\cursorinterface::isDead' => 'Checks if the cursor may have additional results',
'mongodb\driver\cursorinterface::setTypeMap' => 'Sets a type map to use for BSON unserialization',
'mongodb\driver\cursorinterface::toArray' => 'Returns an array containing all results for this cursor',
'MongoDB\Driver\Exception\CommandException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'MongoDB\Driver\Exception\CommandException::__toString' => 'String representation of the exception',
'MongoDB\Driver\Exception\CommandException::getCode' => 'Gets the Exception code',
'MongoDB\Driver\Exception\CommandException::getFile' => 'Gets the file in which the exception occurred',
'MongoDB\Driver\Exception\CommandException::getLine' => 'Gets the line in which the exception occurred',
'MongoDB\Driver\Exception\CommandException::getMessage' => 'Gets the Exception message',
'MongoDB\Driver\Exception\CommandException::getPrevious' => 'Returns previous Exception',
'mongodb\driver\exception\commandexception::getResultDocument' => 'Returns the result document for the failed command',
'MongoDB\Driver\Exception\CommandException::getTrace' => 'Gets the stack trace',
'MongoDB\Driver\Exception\CommandException::getTraceAsString' => 'Gets the stack trace as a string',
'MongoDB\Driver\Exception\CommandException::hasErrorLabel' => 'Whether the given errorLabel is associated with this exception',
'MongoDB\Driver\Exception\Exception::__toString' => 'Gets a string representation of the thrown object',
'MongoDB\Driver\Exception\Exception::getCode' => 'Gets the exception code',
'MongoDB\Driver\Exception\Exception::getFile' => 'Gets the file in which the exception occurred',
'MongoDB\Driver\Exception\Exception::getLine' => 'Gets the line on which the object was instantiated',
'MongoDB\Driver\Exception\Exception::getMessage' => 'Gets the message',
'MongoDB\Driver\Exception\Exception::getPrevious' => 'Returns the previous Throwable',
'MongoDB\Driver\Exception\Exception::getTrace' => 'Gets the stack trace',
'MongoDB\Driver\Exception\Exception::getTraceAsString' => 'Gets the stack trace as a string',
'MongoDB\Driver\Exception\RuntimeException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'MongoDB\Driver\Exception\RuntimeException::__toString' => 'String representation of the exception',
'MongoDB\Driver\Exception\RuntimeException::getCode' => 'Gets the Exception code',
'MongoDB\Driver\Exception\RuntimeException::getFile' => 'Gets the file in which the exception occurred',
'MongoDB\Driver\Exception\RuntimeException::getLine' => 'Gets the line in which the exception occurred',
'MongoDB\Driver\Exception\RuntimeException::getMessage' => 'Gets the Exception message',
'MongoDB\Driver\Exception\RuntimeException::getPrevious' => 'Returns previous Exception',
'MongoDB\Driver\Exception\RuntimeException::getTrace' => 'Gets the stack trace',
'MongoDB\Driver\Exception\RuntimeException::getTraceAsString' => 'Gets the stack trace as a string',
'mongodb\driver\exception\runtimeexception::hasErrorLabel' => 'Returns whether an error label is associated with an exception',
'MongoDB\Driver\Exception\ServerException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'MongoDB\Driver\Exception\ServerException::__toString' => 'String representation of the exception',
'MongoDB\Driver\Exception\ServerException::getCode' => 'Gets the Exception code',
'MongoDB\Driver\Exception\ServerException::getFile' => 'Gets the file in which the exception occurred',
'MongoDB\Driver\Exception\ServerException::getLine' => 'Gets the line in which the exception occurred',
'MongoDB\Driver\Exception\ServerException::getMessage' => 'Gets the Exception message',
'MongoDB\Driver\Exception\ServerException::getPrevious' => 'Returns previous Exception',
'MongoDB\Driver\Exception\ServerException::getTrace' => 'Gets the stack trace',
'MongoDB\Driver\Exception\ServerException::getTraceAsString' => 'Gets the stack trace as a string',
'MongoDB\Driver\Exception\ServerException::hasErrorLabel' => 'Whether the given errorLabel is associated with this exception',
'MongoDB\Driver\Exception\WriteException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'MongoDB\Driver\Exception\WriteException::__toString' => 'String representation of the exception',
'MongoDB\Driver\Exception\WriteException::getCode' => 'Gets the Exception code',
'MongoDB\Driver\Exception\WriteException::getFile' => 'Gets the file in which the exception occurred',
'MongoDB\Driver\Exception\WriteException::getLine' => 'Gets the line in which the exception occurred',
'MongoDB\Driver\Exception\WriteException::getMessage' => 'Gets the Exception message',
'MongoDB\Driver\Exception\WriteException::getPrevious' => 'Returns previous Exception',
'MongoDB\Driver\Exception\WriteException::getTrace' => 'Gets the stack trace',
'MongoDB\Driver\Exception\WriteException::getTraceAsString' => 'Gets the stack trace as a string',
'mongodb\driver\exception\writeexception::getWriteResult' => 'Returns the WriteResult for the failed write operation',
'MongoDB\Driver\Exception\WriteException::hasErrorLabel' => 'Whether the given errorLabel is associated with this exception',
'mongodb\driver\manager::__construct' => 'Create new MongoDB Manager',
'mongodb\driver\manager::createClientEncryption' => 'Create a new ClientEncryption object',
'mongodb\driver\manager::executeBulkWrite' => 'Execute one or more write operations',
'mongodb\driver\manager::executeCommand' => 'Execute a database command',
'mongodb\driver\manager::executeQuery' => 'Execute a database query',
'mongodb\driver\manager::executeReadCommand' => 'Execute a database command that reads',
'mongodb\driver\manager::executeReadWriteCommand' => 'Execute a database command that reads and writes',
'mongodb\driver\manager::executeWriteCommand' => 'Execute a database command that writes',
'mongodb\driver\manager::getReadConcern' => 'Return the ReadConcern for the Manager',
'mongodb\driver\manager::getReadPreference' => 'Return the ReadPreference for the Manager',
'mongodb\driver\manager::getServers' => 'Return the servers to which this manager is connected',
'mongodb\driver\manager::getWriteConcern' => 'Return the WriteConcern for the Manager',
'mongodb\driver\manager::selectServer' => 'Select a server matching a read preference',
'mongodb\driver\manager::startSession' => 'Start a new client session for use with this client',
'MongoDB\Driver\Monitoring\addSubscriber' => 'Registers a new monitoring event subscriber with the driver.
Registered subscribers will be notified of monitoring events through specific methods.
Note: If the object is already registered, this function is a no-op.',
'mongodb\driver\monitoring\commandfailedevent::getCommandName' => 'Returns the command name',
'mongodb\driver\monitoring\commandfailedevent::getDurationMicros' => 'Returns the command\'s duration in microseconds',
'mongodb\driver\monitoring\commandfailedevent::getError' => 'Returns the Exception associated with the failed command',
'mongodb\driver\monitoring\commandfailedevent::getOperationId' => 'Returns the command\'s operation ID',
'mongodb\driver\monitoring\commandfailedevent::getReply' => 'Returns the command reply document',
'mongodb\driver\monitoring\commandfailedevent::getRequestId' => 'Returns the command\'s request ID',
'mongodb\driver\monitoring\commandfailedevent::getServer' => 'Returns the Server on which the command was executed',
'mongodb\driver\monitoring\commandstartedevent::getCommand' => 'Returns the command document',
'mongodb\driver\monitoring\commandstartedevent::getCommandName' => 'Returns the command name',
'mongodb\driver\monitoring\commandstartedevent::getDatabaseName' => 'Returns the database on which the command was executed',
'mongodb\driver\monitoring\commandstartedevent::getOperationId' => 'Returns the command\'s operation ID',
'mongodb\driver\monitoring\commandstartedevent::getRequestId' => 'Returns the command\'s request ID',
'mongodb\driver\monitoring\commandstartedevent::getServer' => 'Returns the Server on which the command was executed',
'mongodb\driver\monitoring\commandsubscriber::commandFailed' => 'Notification method for a failed command',
'mongodb\driver\monitoring\commandsubscriber::commandStarted' => 'Notification method for a started command',
'mongodb\driver\monitoring\commandsubscriber::commandSucceeded' => 'Notification method for a successful command',
'mongodb\driver\monitoring\commandsucceededevent::getCommandName' => 'Returns the command name',
'mongodb\driver\monitoring\commandsucceededevent::getDurationMicros' => 'Returns the command\'s duration in microseconds',
'mongodb\driver\monitoring\commandsucceededevent::getOperationId' => 'Returns the command\'s operation ID',
'mongodb\driver\monitoring\commandsucceededevent::getReply' => 'Returns the command reply document',
'mongodb\driver\monitoring\commandsucceededevent::getRequestId' => 'Returns the command\'s request ID',
'mongodb\driver\monitoring\commandsucceededevent::getServer' => 'Returns the Server on which the command was executed',
'MongoDB\Driver\Monitoring\removeSubscriber' => 'Unregisters an existing monitoring event subscriber from the driver.
Unregistered subscribers will no longer be notified of monitoring events.
Note: If the object is not registered, this function is a no-op.',
'mongodb\driver\query::__construct' => 'Create a new Query',
'mongodb\driver\readconcern::__construct' => 'Create a new ReadConcern',
'mongodb\driver\readconcern::bsonSerialize' => 'Returns an object for BSON serialization',
'mongodb\driver\readconcern::getLevel' => 'Returns the ReadConcern\'s "level" option',
'mongodb\driver\readconcern::isDefault' => 'Checks if this is the default read concern',
'mongodb\driver\readconcern::serialize' => 'Serialize a ReadConcern',
'mongodb\driver\readconcern::unserialize' => 'Unserialize a ReadConcern',
'mongodb\driver\readpreference::__construct' => 'Create a new ReadPreference',
'mongodb\driver\readpreference::bsonSerialize' => 'Returns an object for BSON serialization',
'mongodb\driver\readpreference::getMaxStalenessSeconds' => 'Returns the ReadPreference\'s "maxStalenessSeconds" option',
'mongodb\driver\readpreference::getMode' => 'Returns the ReadPreference\'s "mode" option',
'mongodb\driver\readpreference::getModeString' => 'Returns the ReadPreference\'s "mode" option as a string',
'mongodb\driver\readpreference::getTagSets' => 'Returns the ReadPreference\'s "tagSets" option',
'mongodb\driver\readpreference::serialize' => 'Serialize a ReadPreference',
'mongodb\driver\readpreference::unserialize' => 'Unserialize a ReadPreference',
'mongodb\driver\server::__construct' => 'Create a new Server (not used)',
'mongodb\driver\server::executeBulkWrite' => 'Execute one or more write operations on this server',
'mongodb\driver\server::executeCommand' => 'Execute a database command on this server',
'mongodb\driver\server::executeQuery' => 'Execute a database query on this server',
'mongodb\driver\server::executeReadCommand' => 'Execute a database command that reads on this server',
'mongodb\driver\server::executeReadWriteCommand' => 'Execute a database command that reads and writes on this server',
'mongodb\driver\server::executeWriteCommand' => 'Execute a database command that writes on this server',
'mongodb\driver\server::getHost' => 'Returns the hostname of this server',
'mongodb\driver\server::getInfo' => 'Returns an array of information about this server',
'mongodb\driver\server::getLatency' => 'Returns the latency of this server',
'mongodb\driver\server::getPort' => 'Returns the port on which this server is listening',
'mongodb\driver\server::getTags' => 'Returns an array of tags describing this server in a replica set',
'mongodb\driver\server::getType' => 'Returns an integer denoting the type of this server',
'mongodb\driver\server::isArbiter' => 'Checks if this server is an arbiter member of a replica set',
'mongodb\driver\server::isHidden' => 'Checks if this server is a hidden member of a replica set',
'mongodb\driver\server::isPassive' => 'Checks if this server is a passive member of a replica set',
'mongodb\driver\server::isPrimary' => 'Checks if this server is a primary member of a replica set',
'mongodb\driver\server::isSecondary' => 'Checks if this server is a secondary member of a replica set',
'mongodb\driver\session::__construct' => 'Create a new Session (not used)',
'mongodb\driver\session::abortTransaction' => 'Aborts a transaction',
'mongodb\driver\session::advanceClusterTime' => 'Advances the cluster time for this session',
'mongodb\driver\session::advanceOperationTime' => 'Advances the operation time for this session',
'mongodb\driver\session::commitTransaction' => 'Commits a transaction',
'mongodb\driver\session::endSession' => 'Terminates a session',
'mongodb\driver\session::getClusterTime' => 'Returns the cluster time for this session',
'mongodb\driver\session::getLogicalSessionId' => 'Returns the logical session ID for this session',
'mongodb\driver\session::getOperationTime' => 'Returns the operation time for this session',
'mongodb\driver\session::getServer' => 'Returns the server to which this session is pinned',
'mongodb\driver\session::getTransactionOptions' => 'Returns options for the currently running transaction',
'mongodb\driver\session::getTransactionState' => 'Returns the current transaction state for this session',
'mongodb\driver\session::isInTransaction' => 'Returns whether a multi-document transaction is in progress',
'mongodb\driver\session::startTransaction' => 'Starts a transaction',
'mongodb\driver\writeconcern::__construct' => 'Create a new WriteConcern',
'mongodb\driver\writeconcern::bsonSerialize' => 'Returns an object for BSON serialization',
'mongodb\driver\writeconcern::getJournal' => 'Returns the WriteConcern\'s "journal" option',
'mongodb\driver\writeconcern::getW' => 'Returns the WriteConcern\'s "w" option',
'mongodb\driver\writeconcern::getWtimeout' => 'Returns the WriteConcern\'s "wtimeout" option',
'mongodb\driver\writeconcern::isDefault' => 'Checks if this is the default write concern',
'mongodb\driver\writeconcern::serialize' => 'Serialize a WriteConcern',
'mongodb\driver\writeconcern::unserialize' => 'Unserialize a WriteConcern',
'mongodb\driver\writeconcernerror::getCode' => 'Returns the WriteConcernError\'s error code',
'mongodb\driver\writeconcernerror::getInfo' => 'Returns additional metadata for the WriteConcernError',
'mongodb\driver\writeconcernerror::getMessage' => 'Returns the WriteConcernError\'s error message',
'mongodb\driver\writeerror::getCode' => 'Returns the WriteError\'s error code',
'mongodb\driver\writeerror::getIndex' => 'Returns the index of the write operation corresponding to this WriteError',
'mongodb\driver\writeerror::getInfo' => 'Returns additional metadata for the WriteError',
'mongodb\driver\writeerror::getMessage' => 'Returns the WriteError\'s error message',
'mongodb\driver\writeresult::getDeletedCount' => 'Returns the number of documents deleted',
'mongodb\driver\writeresult::getInsertedCount' => 'Returns the number of documents inserted (excluding upserts)',
'mongodb\driver\writeresult::getMatchedCount' => 'Returns the number of documents selected for update',
'mongodb\driver\writeresult::getModifiedCount' => 'Returns the number of existing documents updated',
'mongodb\driver\writeresult::getServer' => 'Returns the server associated with this write result',
'mongodb\driver\writeresult::getUpsertedCount' => 'Returns the number of documents inserted by an upsert',
'mongodb\driver\writeresult::getUpsertedIds' => 'Returns an array of identifiers for upserted documents',
'mongodb\driver\writeresult::getWriteConcernError' => 'Returns any write concern error that occurred',
'mongodb\driver\writeresult::getWriteErrors' => 'Returns any write errors that occurred',
'mongodb\driver\writeresult::isAcknowledged' => 'Returns whether the write was acknowledged',
'mongodbref::create' => 'Creates a new database reference',
'mongodbref::get' => 'Fetches the object pointed to by a reference',
'mongodbref::isRef' => 'Checks if an array is a database reference',
'MongoException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'MongoException::__construct' => 'Construct the exception. Note: The message is NOT binary safe.',
'MongoException::__toString' => 'String representation of the exception',
'MongoException::getCode' => 'Gets the Exception code',
'MongoException::getFile' => 'Gets the file in which the exception occurred',
'MongoException::getLine' => 'Gets the line in which the exception occurred',
'MongoException::getMessage' => 'Gets the Exception message',
'MongoException::getPrevious' => 'Returns previous Exception',
'MongoException::getTrace' => 'Gets the stack trace',
'MongoException::getTraceAsString' => 'Gets the stack trace as a string',
'MongoGridFS::__construct' => 'Files as stored across two collections, the first containing file meta
information, the second containing chunks of the actual file. By default,
fs.files and fs.chunks are the collection names used.',
'MongoGridFS::__get' => 'Gets a collection',
'MongoGridFS::__toString' => 'String representation of this collection',
'MongoGridFS::aggregate' => '<p>
The MongoDB
{@link https://docs.mongodb.org/manual/applications/aggregation/ aggregation framework}
provides a means to calculate aggregated values without having to use
MapReduce. While MapReduce is powerful, it is often more difficult than
necessary for many simple aggregation tasks, such as totaling or averaging
field values.
</p>
<p>
This method accepts either a variable amount of pipeline operators, or a
single array of operators constituting the pipeline.
</p>',
'MongoGridFS::aggregateCursor' => '<p>
With this method you can execute Aggregation Framework pipelines and retrieve the results
through a cursor, instead of getting just one document back as you would with
{@link https://php.net/manual/en/mongocollection.aggregate.php MongoCollection::aggregate()}.
This method returns a {@link https://php.net/manual/en/class.mongocommandcursor.php MongoCommandCursor} object.
This cursor object implements the {@link https://php.net/manual/en/class.iterator.php Iterator} interface
just like the {@link https://php.net/manual/en/class.mongocursor.php MongoCursor} objects that are returned
by the {@link https://php.net/manual/en/mongocollection.find.php MongoCollection::find()} method
</p>',
'MongoGridFS::batchInsert' => 'Inserts multiple documents into this collection',
'MongoGridFS::count' => 'Counts the number of documents in this collection',
'MongoGridFS::createDBRef' => 'Creates a database reference',
'MongoGridFS::createIndex' => 'Creates an index on the given field(s), or does nothing if the index already exists',
'MongoGridFS::delete' => 'Delete a file from the database',
'MongoGridFS::deleteIndex' => 'Deletes an index from this collection',
'MongoGridFS::deleteIndexes' => 'Delete all indexes for this collection',
'MongoGridFS::distinct' => 'Retrieve a list of distinct values for the given key across a collection',
'MongoGridFS::drop' => 'Drops the files and chunks collections',
'MongoGridFS::ensureIndex' => '`@return boolean` always true',
'MongoGridFS::find' => '`@return MongoGridFSCursor` A MongoGridFSCursor',
'MongoGridFS::findAndModify' => 'Update a document and return it',
'MongoGridFS::findOne' => 'Returns a single file matching the criteria',
'MongoGridFS::get' => 'Retrieve a file from the database',
'MongoGridFS::getDBRef' => 'Fetches the document pointed to by a database reference',
'MongoGridFS::getIndexInfo' => 'Returns an array of index names for this collection',
'MongoGridFS::getName' => 'Returns this collection\'s name',
'MongoGridFS::getSlaveOkay' => '<p>
See {@link https://secure.php.net/manual/en/mongo.queries.php the query section} of this manual for
information on distributing reads to secondaries.
</p>',
'MongoGridFS::group' => 'Performs an operation similar to SQL\'s GROUP BY command',
'MongoGridFS::insert' => 'Inserts an array into the collection',
'MongoGridFS::put' => 'Stores a file in the database',
'MongoGridFS::remove' => 'Removes files from the collections',
'MongoGridFS::save' => 'Saves an object to this collection',
'MongoGridFS::setSlaveOkay' => '<p>
See {@link https://secure.php.net/manual/en/mongo.queries.php the query section} of this manual for
information on distributing reads to secondaries.
</p>',
'MongoGridFS::storeBytes' => 'Chunkifies and stores bytes in the database',
'MongoGridFS::storeFile' => 'Stores a file in the database',
'MongoGridFS::storeUpload' => 'Saves an uploaded file directly from a POST to the database',
'MongoGridFS::update' => 'Update records based on a given criteria',
'MongoGridFS::validate' => 'Validates this collection',
'MongoGridFSCursor::__construct' => 'Create a new cursor',
'MongoGridFSCursor::addOption' => 'Adds a top-level key/value pair to a query',
'MongoGridFSCursor::awaitData' => 'Sets whether this cursor will wait for a while for a tailable cursor to return more data',
'MongoGridFSCursor::batchSize' => 'PECL mongo >=1.0.11
Limits the number of elements returned in one batch.
<p>A cursor typically fetches a batch of result objects and store them locally.
This method sets the batchSize value to configure the amount of documents retrieved from the server in one data packet.
However, it will never return more documents than fit in the max batch size limit (usually 4MB).',
'MongoGridFSCursor::count' => 'Counts the number of results for this query',
'MongoGridFSCursor::current' => 'Returns the current file',
'MongoGridFSCursor::dead' => 'Checks if there are documents that have not been sent yet from the database for this cursor',
'MongoGridFSCursor::doQuery' => 'Execute the query',
'MongoGridFSCursor::explain' => 'Return an explanation of the query, often useful for optimization and debugging',
'MongoGridFSCursor::fields' => 'Sets the fields for a query',
'MongoGridFSCursor::getNext' => 'Return the next file to which this cursor points, and advance the cursor',
'MongoGridFSCursor::hasNext' => 'Checks if there are any more elements in this cursor',
'MongoGridFSCursor::hint' => 'Gives the database a hint about the query',
'MongoGridFSCursor::immortal' => 'Sets whether this cursor will timeout',
'MongoGridFSCursor::info' => 'Gets the query, fields, limit, and skip for this cursor',
'MongoGridFSCursor::key' => 'Returns the current result\'s filename',
'MongoGridFSCursor::limit' => 'Limits the number of results returned',
'MongoGridFSCursor::maxTimeMS' => '(PECL mongo >=1.5.0)
Sets a server-side timeout for this query',
'MongoGridFSCursor::next' => 'Advances the cursor to the next result',
'MongoGridFSCursor::reset' => 'Clears the cursor',
'MongoGridFSCursor::rewind' => 'Returns the cursor to the beginning of the result set',
'MongoGridFSCursor::skip' => 'Skips a number of results',
'MongoGridFSCursor::slaveOkay' => 'Sets whether this query can be done on a slave
This method will override the static class variable slaveOkay.',
'MongoGridFSCursor::snapshot' => 'Use snapshot mode for the query',
'MongoGridFSCursor::sort' => 'Sorts the results by given fields',
'MongoGridFSCursor::tailable' => 'Sets whether this cursor will be left open after fetching the last results',
'MongoGridFSCursor::timeout' => 'Sets a client-side timeout for this query',
'MongoGridFSCursor::valid' => 'Checks if the cursor is reading a valid result.',
'mongogridfsfile::__construct' => 'Create a new GridFS file',
'mongogridfsfile::getBytes' => 'Returns this file\'s contents as a string of bytes',
'mongogridfsfile::getFilename' => 'Returns this file\'s filename',
'mongogridfsfile::getResource' => 'Returns a resource that can be used to read the stored file',
'mongogridfsfile::getSize' => 'Returns this file\'s size',
'mongogridfsfile::write' => 'Writes this file to the filesystem',
'mongoid::__construct' => 'Creates a new id',
'mongoid::__set_state' => 'Create a dummy MongoId',
'mongoid::__toString' => 'Returns a hexadecimal representation of this id',
'mongoid::getHostname' => 'Gets the hostname being used for this machine\'s ids',
'mongoid::getInc' => 'Gets the incremented value to create this id',
'mongoid::getPID' => 'Gets the process ID',
'mongoid::getTimestamp' => 'Gets the number of seconds since the epoch that this id was created',
'mongoid::isValid' => 'Check if a value is a valid ObjectId',
'mongoint32::__construct' => 'Creates a new 32-bit integer',
'mongoint32::__toString' => 'Returns the string representation of this 32-bit integer',
'mongoint64::__construct' => 'Creates a new 64-bit integer',
'mongoint64::__toString' => 'Returns the string representation of this 64-bit integer',
'mongolog::getCallback' => 'Gets the previously set callback function',
'mongolog::getLevel' => 'Gets the level(s) currently being logged',
'mongolog::getModule' => 'Gets the module(s) currently being logged',
'mongolog::setCallback' => 'Sets a callback function to be invoked for events',
'mongolog::setLevel' => 'Sets the level(s) to be logged',
'mongolog::setModule' => 'Sets the module(s) to be logged',
'mongopool::getSize' => 'Get pool size for connection pools',
'mongopool::info' => 'Returns information about all connection pools',
'mongopool::setSize' => 'Set the size for future connection pools',
'mongoregex::__construct' => 'Creates a new regular expression',
'mongoregex::__toString' => 'A string representation of this regular expression',
'MongoResultException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'MongoResultException::__construct' => 'Construct the exception. Note: The message is NOT binary safe.',
'MongoResultException::__toString' => 'String representation of the exception',
'MongoResultException::getCode' => 'Gets the Exception code',
'mongoresultexception::getDocument' => 'Retrieve the full result document',
'MongoResultException::getFile' => 'Gets the file in which the exception occurred',
'MongoResultException::getLine' => 'Gets the line in which the exception occurred',
'MongoResultException::getMessage' => 'Gets the Exception message',
'MongoResultException::getPrevious' => 'Returns previous Exception',
'MongoResultException::getTrace' => 'Gets the stack trace',
'MongoResultException::getTraceAsString' => 'Gets the stack trace as a string',
'mongotimestamp::__construct' => 'Creates a new timestamp',
'mongotimestamp::__toString' => 'Returns a string representation of this timestamp',
'MongoUpdateBatch::__construct' => '<p>(PECL mongo &gt;= 1.5.0)</p>
MongoUpdateBatch constructor.',
'MongoUpdateBatch::add' => '<p>(PECL mongo &gt;= 1.5.0)</p>
Adds a write operation to a batch',
'MongoUpdateBatch::execute' => '<p>(PECL mongo &gt;= 1.5.0)</p>
Executes a batch of write operations',
'mongowritebatch::__construct' => 'Creates a new batch of write operations',
'mongowritebatch::add' => 'Adds a write operation to a batch',
'mongowritebatch::execute' => 'Executes a batch of write operations',
'MongoWriteConcernException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'MongoWriteConcernException::__construct' => 'Construct the exception. Note: The message is NOT binary safe.',
'MongoWriteConcernException::__toString' => 'String representation of the exception',
'MongoWriteConcernException::getCode' => 'Gets the Exception code',
'mongowriteconcernexception::getDocument' => 'Get the error document',
'MongoWriteConcernException::getFile' => 'Gets the file in which the exception occurred',
'MongoWriteConcernException::getLine' => 'Gets the line in which the exception occurred',
'MongoWriteConcernException::getMessage' => 'Gets the Exception message',
'MongoWriteConcernException::getPrevious' => 'Returns previous Exception',
'MongoWriteConcernException::getTrace' => 'Gets the stack trace',
'MongoWriteConcernException::getTraceAsString' => 'Gets the stack trace as a string',
'move_uploaded_file' => 'Moves an uploaded file to a new location',
'mqseries_back' => 'MQSeries MQBACK',
'mqseries_begin' => 'MQseries MQBEGIN',
'mqseries_close' => 'MQSeries MQCLOSE',
'mqseries_cmit' => 'MQSeries MQCMIT',
'mqseries_conn' => 'MQSeries MQCONN',
'mqseries_connx' => 'MQSeries MQCONNX',
'mqseries_disc' => 'MQSeries MQDISC',
'mqseries_get' => 'MQSeries MQGET',
'mqseries_inq' => 'MQSeries MQINQ',
'mqseries_open' => 'MQSeries MQOPEN',
'mqseries_put' => 'MQSeries MQPUT',
'mqseries_put1' => 'MQSeries MQPUT1',
'mqseries_set' => 'MQSeries MQSET',
'mqseries_strerror' => 'Returns the error message corresponding to a result code (MQRC)',
'ms_GetErrorObj' => 'Returns a reference to the head of the list of errorObj.',
'ms_GetVersion' => 'Returns the MapServer version and options in a string.  This
string can be parsed to find out which modules were compiled in,
etc.',
'ms_GetVersionInt' => 'Returns the MapServer version number (x.y.z) as an integer
(x*10000 + y*100 + z). (New in v5.0) e.g. V5.4.3 would return
50403.',
'ms_iogetStdoutBufferBytes' => 'Writes the current buffer to stdout.  The PHP header() function
should be used to set the documents\'s content-type prior to
calling the function.  Returns the number of bytes written if
output is sent to stdout.  See :ref:`mapscript_ows` for more info.',
'ms_ResetErrorList' => 'Clear the current error list.
Note that clearing the list invalidates any errorObj handles obtained
via the $error->next() method.',
'ms_TokenizeMap' => 'Preparses a mapfile through the MapServer parser and return an
array with one item for each token from the mapfile.  Strings,
logical expressions, regex expressions and comments are returned
as individual tokens.',
'msession_connect' => 'Connect to msession server',
'msession_count' => 'Get session count',
'msession_create' => 'Create a session',
'msession_destroy' => 'Destroy a session',
'msession_disconnect' => 'Close connection to msession server',
'msession_find' => 'Find all sessions with name and value',
'msession_get' => 'Get value from session',
'msession_get_array' => 'Get array of msession variables',
'msession_get_data' => 'Get data session unstructured data',
'msession_inc' => 'Increment value in session',
'msession_list' => 'List all sessions',
'msession_listvar' => 'List sessions with variable',
'msession_lock' => 'Lock a session',
'msession_plugin' => 'Call an escape function within the msession personality plugin',
'msession_randstr' => 'Get random string',
'msession_set' => 'Set value in session',
'msession_set_array' => 'Set msession variables from an array',
'msession_set_data' => 'Set data session unstructured data',
'msession_timeout' => 'Set/get session timeout',
'msession_uniq' => 'Get unique id',
'msession_unlock' => 'Unlock a session',
'msg_get_queue' => 'Create or attach to a message queue',
'msg_queue_exists' => 'Check whether a message queue exists',
'msg_receive' => 'Receive a message from a message queue',
'msg_remove_queue' => 'Destroy a message queue',
'msg_send' => 'Send a message to a message queue',
'msg_set_queue' => 'Set information in the message queue data structure',
'msg_stat_queue' => 'Returns information from the message queue data structure',
'msgpack_pack' => 'Alias of msgpack_serialize',
'msgpack_serialize' => 'Serialize a variable into msgpack format',
'msgpack_unpack' => 'Alias of msgpack_unserialize',
'msgpack_unserialize' => 'Unserialize $str',
'msql' => 'Alias of msql_db_query',
'msql_affected_rows' => 'Returns number of affected rows',
'msql_close' => 'Close mSQL connection',
'msql_connect' => 'Open mSQL connection',
'msql_create_db' => 'Create mSQL database',
'msql_createdb' => 'Alias of msql_create_db',
'msql_data_seek' => 'Move internal row pointer',
'msql_db_query' => 'Send mSQL query',
'msql_dbname' => 'Alias of msql_result',
'msql_drop_db' => 'Drop (delete) mSQL database',
'msql_error' => 'Returns error message of last msql call',
'msql_fetch_array' => 'Fetch row as array',
'msql_fetch_field' => 'Get field information',
'msql_fetch_object' => 'Fetch row as object',
'msql_fetch_row' => 'Get row as enumerated array',
'msql_field_flags' => 'Get field flags',
'msql_field_len' => 'Get field length',
'msql_field_name' => 'Get the name of the specified field in a result',
'msql_field_seek' => 'Set field offset',
'msql_field_table' => 'Get table name for field',
'msql_field_type' => 'Get field type',
'msql_fieldflags' => 'Alias of msql_field_flags',
'msql_fieldlen' => 'Alias of msql_field_len',
'msql_fieldname' => 'Alias of msql_field_name',
'msql_fieldtable' => 'Alias of msql_field_table',
'msql_fieldtype' => 'Alias of msql_field_type',
'msql_free_result' => 'Free result memory',
'msql_list_dbs' => 'List mSQL databases on server',
'msql_list_fields' => 'List result fields',
'msql_list_tables' => 'List tables in an mSQL database',
'msql_num_fields' => 'Get number of fields in result',
'msql_num_rows' => 'Get number of rows in result',
'msql_numfields' => 'Alias of msql_num_fields',
'msql_numrows' => 'Alias of msql_num_rows',
'msql_pconnect' => 'Open persistent mSQL connection',
'msql_query' => 'Send mSQL query',
'msql_regcase' => 'Alias of sql_regcase',
'msql_result' => 'Get result data',
'msql_select_db' => 'Select mSQL database',
'msql_tablename' => 'Alias of msql_result',
'mssql_bind' => 'Adds a parameter to a stored procedure or a remote stored procedure',
'mssql_close' => 'Close MS SQL Server connection',
'mssql_connect' => 'Open MS SQL server connection',
'mssql_data_seek' => 'Moves internal row pointer',
'mssql_execute' => 'Executes a stored procedure on a MS SQL server database',
'mssql_fetch_array' => 'Fetch a result row as an associative array, a numeric array, or both',
'mssql_fetch_assoc' => 'Returns an associative array of the current row in the result',
'mssql_fetch_batch' => 'Returns the next batch of records',
'mssql_fetch_field' => 'Get field information',
'mssql_fetch_object' => 'Fetch row as object',
'mssql_fetch_row' => 'Get row as enumerated array',
'mssql_field_length' => 'Get the length of a field',
'mssql_field_name' => 'Get the name of a field',
'mssql_field_seek' => 'Seeks to the specified field offset',
'mssql_field_type' => 'Gets the type of a field',
'mssql_free_result' => 'Free result memory',
'mssql_free_statement' => 'Free statement memory',
'mssql_get_last_message' => 'Returns the last message from the server',
'mssql_guid_string' => 'Converts a 16 byte binary GUID to a string',
'mssql_init' => 'Initializes a stored procedure or a remote stored procedure',
'mssql_min_error_severity' => 'Sets the minimum error severity',
'mssql_min_message_severity' => 'Sets the minimum message severity',
'mssql_next_result' => 'Move the internal result pointer to the next result',
'mssql_num_fields' => 'Gets the number of fields in result',
'mssql_num_rows' => 'Gets the number of rows in result',
'mssql_pconnect' => 'Open persistent MS SQL connection',
'mssql_query' => 'Send MS SQL query',
'mssql_result' => 'Get result data',
'mssql_rows_affected' => 'Returns the number of records affected by the query',
'mssql_select_db' => 'Select MS SQL database',
'mt_getrandmax' => 'Show largest possible random value',
'mt_rand' => 'Generate a random value via the Mersenne Twister Random Number Generator',
'mt_srand' => 'Seeds the Mersenne Twister Random Number Generator',
'multipleiterator::__construct' => 'Constructs a new MultipleIterator',
'multipleiterator::attachIterator' => 'Attaches iterator information',
'multipleiterator::containsIterator' => 'Checks if an iterator is attached',
'multipleiterator::countIterators' => 'Gets the number of attached iterator instances',
'multipleiterator::current' => 'Gets the registered iterator instances',
'multipleiterator::detachIterator' => 'Detaches an iterator',
'multipleiterator::getFlags' => 'Gets the flag information',
'multipleiterator::key' => 'Gets the registered iterator instances',
'multipleiterator::next' => 'Moves all attached iterator instances forward',
'multipleiterator::rewind' => 'Rewinds all attached iterator instances',
'multipleiterator::setFlags' => 'Sets flags',
'multipleiterator::valid' => 'Checks the validity of sub iterators',
'mutex::create' => 'Create a Mutex',
'mutex::destroy' => 'Destroy Mutex',
'mutex::lock' => 'Acquire Mutex',
'mutex::trylock' => 'Attempt to Acquire Mutex',
'mutex::unlock' => 'Release Mutex',
'mysql_affected_rows' => 'Get number of affected rows in previous MySQL operation',
'mysql_client_encoding' => 'Returns the name of the character set',
'mysql_close' => 'Close MySQL connection',
'mysql_connect' => 'Open a connection to a MySQL Server',
'mysql_create_db' => 'Create a MySQL database',
'mysql_data_seek' => 'Move internal result pointer',
'mysql_db_name' => 'Retrieves database name from the call to mysql_list_dbs',
'mysql_db_query' => 'Selects a database and executes a query on it',
'mysql_drop_db' => 'Drop (delete) a MySQL database',
'mysql_errno' => 'Returns the numerical value of the error message from previous MySQL operation',
'mysql_error' => 'Returns the text of the error message from previous MySQL operation',
'mysql_escape_string' => 'Escapes a string for use in a mysql_query',
'mysql_fetch_array' => 'Fetch a result row as an associative array, a numeric array, or both',
'mysql_fetch_assoc' => 'Fetch a result row as an associative array',
'mysql_fetch_field' => 'Get column information from a result and return as an object',
'mysql_fetch_lengths' => 'Get the length of each output in a result',
'mysql_fetch_object' => 'Fetch a result row as an object',
'mysql_fetch_row' => 'Get a result row as an enumerated array',
'mysql_field_flags' => 'Get the flags associated with the specified field in a result',
'mysql_field_len' => 'Returns the length of the specified field',
'mysql_field_name' => 'Get the name of the specified field in a result',
'mysql_field_seek' => 'Set result pointer to a specified field offset',
'mysql_field_table' => 'Get name of the table the specified field is in',
'mysql_field_type' => 'Get the type of the specified field in a result',
'mysql_free_result' => 'Free result memory',
'mysql_get_client_info' => 'Get MySQL client info',
'mysql_get_host_info' => 'Get MySQL host info',
'mysql_get_proto_info' => 'Get MySQL protocol info',
'mysql_get_server_info' => 'Get MySQL server info',
'mysql_info' => 'Get information about the most recent query',
'mysql_insert_id' => 'Get the ID generated in the last query',
'mysql_list_dbs' => 'List databases available on a MySQL server',
'mysql_list_fields' => 'List MySQL table fields',
'mysql_list_processes' => 'List MySQL processes',
'mysql_list_tables' => 'List tables in a MySQL database',
'mysql_num_fields' => 'Get number of fields in result',
'mysql_num_rows' => 'Get number of rows in result',
'mysql_pconnect' => 'Open a persistent connection to a MySQL server',
'mysql_ping' => 'Ping a server connection or reconnect if there is no connection',
'mysql_query' => 'Send a MySQL query',
'mysql_real_escape_string' => 'Escapes special characters in a string for use in an SQL statement',
'mysql_result' => 'Get result data',
'mysql_select_db' => 'Select a MySQL database',
'mysql_set_charset' => 'Sets the client character set',
'mysql_stat' => 'Get current system status',
'mysql_tablename' => 'Get table name of field',
'mysql_thread_id' => 'Return the current thread ID',
'mysql_unbuffered_query' => 'Send an SQL query to MySQL without fetching and buffering the result rows',
'mysql_xdevapi\baseresult::getWarnings' => 'Fetch warnings from last operation',
'mysql_xdevapi\baseresult::getWarningsCount' => 'Fetch warning count from last operation',
'mysql_xdevapi\client::__construct' => 'Client constructor',
'mysql_xdevapi\client::close' => 'Close client',
'mysql_xdevapi\client::getClient' => 'Get client session',
'mysql_xdevapi\collection::__construct' => 'Collection constructor',
'mysql_xdevapi\collection::add' => 'Add collection document',
'mysql_xdevapi\collection::addOrReplaceOne' => 'Add or replace collection document',
'mysql_xdevapi\collection::count' => 'Get document count',
'mysql_xdevapi\collection::createIndex' => 'Create collection index',
'mysql_xdevapi\collection::dropIndex' => 'Drop collection index',
'mysql_xdevapi\collection::existsInDatabase' => 'Check if collection exists in database',
'mysql_xdevapi\collection::find' => 'Search for document',
'mysql_xdevapi\collection::getName' => 'Get collection name',
'mysql_xdevapi\collection::getOne' => 'Get one document',
'mysql_xdevapi\collection::getSchema' => 'Get schema object',
'mysql_xdevapi\collection::getSession' => 'Get session object',
'mysql_xdevapi\collection::modify' => 'Modify collection documents',
'mysql_xdevapi\collection::remove' => 'Remove collection documents',
'mysql_xdevapi\collection::removeOne' => 'Remove one collection document',
'mysql_xdevapi\collection::replaceOne' => 'Replace one collection document',
'mysql_xdevapi\collectionadd::__construct' => 'CollectionAdd constructor',
'mysql_xdevapi\collectionadd::execute' => 'Execute the statement',
'mysql_xdevapi\collectionfind::__construct' => 'CollectionFind constructor',
'mysql_xdevapi\collectionfind::bind' => 'Bind value to query placeholder',
'mysql_xdevapi\collectionfind::execute' => 'Execute the statement',
'mysql_xdevapi\collectionfind::fields' => 'Set document field filter',
'mysql_xdevapi\collectionfind::groupBy' => 'Set grouping criteria',
'mysql_xdevapi\collectionfind::having' => 'Set condition for aggregate functions',
'mysql_xdevapi\collectionfind::limit' => 'Limit number of returned documents',
'mysql_xdevapi\collectionfind::lockExclusive' => 'Execute operation with EXCLUSIVE LOCK',
'mysql_xdevapi\collectionfind::lockShared' => 'Execute operation with SHARED LOCK',
'mysql_xdevapi\collectionfind::offset' => 'Skip given number of elements to be returned',
'mysql_xdevapi\collectionfind::sort' => 'Set the sorting criteria',
'mysql_xdevapi\collectionmodify::__construct' => 'CollectionModify constructor',
'mysql_xdevapi\collectionmodify::arrayAppend' => 'Append element to an array field',
'mysql_xdevapi\collectionmodify::arrayInsert' => 'Insert element into an array field',
'mysql_xdevapi\collectionmodify::bind' => 'Bind value to query placeholder',
'mysql_xdevapi\collectionmodify::execute' => 'Execute modify operation',
'mysql_xdevapi\collectionmodify::limit' => 'Limit number of modified documents',
'mysql_xdevapi\collectionmodify::patch' => 'Patch document',
'mysql_xdevapi\collectionmodify::replace' => 'Replace document field',
'mysql_xdevapi\collectionmodify::set' => 'Set document attribute',
'mysql_xdevapi\collectionmodify::skip' => 'Skip elements',
'mysql_xdevapi\collectionmodify::sort' => 'Set the sorting criteria',
'mysql_xdevapi\collectionmodify::unset' => 'Unset the value of document fields',
'mysql_xdevapi\collectionremove::__construct' => 'CollectionRemove constructor',
'mysql_xdevapi\collectionremove::bind' => 'Bind value to placeholder',
'mysql_xdevapi\collectionremove::execute' => 'Execute remove operation',
'mysql_xdevapi\collectionremove::limit' => 'Limit number of documents to remove',
'mysql_xdevapi\collectionremove::sort' => 'Set the sorting criteria',
'mysql_xdevapi\columnresult::__construct' => 'ColumnResult constructor',
'mysql_xdevapi\columnresult::getCharacterSetName' => 'Get character set',
'mysql_xdevapi\columnresult::getCollationName' => 'Get collation name',
'mysql_xdevapi\columnresult::getColumnLabel' => 'Get column label',
'mysql_xdevapi\columnresult::getColumnName' => 'Get column name',
'mysql_xdevapi\columnresult::getFractionalDigits' => 'Get fractional digit length',
'mysql_xdevapi\columnresult::getLength' => 'Get column field length',
'mysql_xdevapi\columnresult::getSchemaName' => 'Get schema name',
'mysql_xdevapi\columnresult::getTableLabel' => 'Get table label',
'mysql_xdevapi\columnresult::getTableName' => 'Get table name',
'mysql_xdevapi\columnresult::getType' => 'Get column type',
'mysql_xdevapi\columnresult::isNumberSigned' => 'Check if signed type',
'mysql_xdevapi\columnresult::isPadded' => 'Check if padded',
'mysql_xdevapi\crudoperationbindable::bind' => 'Bind value to placeholder',
'mysql_xdevapi\crudoperationlimitable::limit' => 'Set result limit',
'mysql_xdevapi\crudoperationskippable::skip' => 'Number of operations to skip',
'mysql_xdevapi\crudoperationsortable::sort' => 'Sort results',
'mysql_xdevapi\databaseobject::existsInDatabase' => 'Check if object exists in database',
'mysql_xdevapi\databaseobject::getName' => 'Get object name',
'mysql_xdevapi\databaseobject::getSession' => 'Get session name',
'mysql_xdevapi\docresult::__construct' => 'DocResult constructor',
'mysql_xdevapi\docresult::fetchAll' => 'Get all rows',
'mysql_xdevapi\docresult::fetchOne' => 'Get one row',
'mysql_xdevapi\docresult::getWarnings' => 'Get warnings from last operation',
'mysql_xdevapi\docresult::getWarningsCount' => 'Get warning count from last operation',
'mysql_xdevapi\driver::__construct' => 'Driver constructor',
'mysql_xdevapi\executable::execute' => 'Execute statement',
'mysql_xdevapi\executionstatus::__construct' => 'ExecutionStatus constructor',
'mysql_xdevapi\expression::__construct' => 'Expression constructor',
'mysql_xdevapi\fieldmetadata::__construct' => 'FieldMetadata constructor',
'mysql_xdevapi\result::__construct' => 'Result constructor',
'mysql_xdevapi\result::getAffectedItemsCount' => 'Get affected row count',
'mysql_xdevapi\result::getAutoIncrementValue' => 'Get autoincremented value',
'mysql_xdevapi\result::getGeneratedIds' => 'Get generated ids',
'mysql_xdevapi\result::getWarnings' => 'Get warnings from last operation',
'mysql_xdevapi\result::getWarningsCount' => 'Get warning count from last operation',
'mysql_xdevapi\rowresult::__construct' => 'RowResult constructor',
'mysql_xdevapi\rowresult::fetchAll' => 'Get all rows from result',
'mysql_xdevapi\rowresult::fetchOne' => 'Get row from result',
'mysql_xdevapi\rowresult::getColumnCount' => 'Get column count',
'mysql_xdevapi\rowresult::getColumnNames' => 'Get all column names',
'mysql_xdevapi\rowresult::getColumns' => 'Get column metadata',
'mysql_xdevapi\rowresult::getColumnsCount' => 'Get column count',
'mysql_xdevapi\rowresult::getWarnings' => 'Get warnings from last operation',
'mysql_xdevapi\rowresult::getWarningsCount' => 'Get warning count from last operation',
'mysql_xdevapi\schema::__construct' => 'constructor',
'mysql_xdevapi\schema::createCollection' => 'Add collection to schema',
'mysql_xdevapi\schema::dropCollection' => 'Drop collection from schema',
'mysql_xdevapi\schema::existsInDatabase' => 'Check if exists in database',
'mysql_xdevapi\schema::getCollection' => 'Get collection from schema',
'mysql_xdevapi\schema::getCollectionAsTable' => 'Get collection table object',
'mysql_xdevapi\schema::getCollections' => 'Get all schema collections',
'mysql_xdevapi\schema::getName' => 'Get schema name',
'mysql_xdevapi\schema::getSession' => 'Get schema session',
'mysql_xdevapi\schema::getTable' => 'Get schema table',
'mysql_xdevapi\schema::getTables' => 'Get schema tables',
'mysql_xdevapi\schemaobject::getSchema' => 'Get schema object',
'mysql_xdevapi\session::__construct' => 'Description constructor',
'mysql_xdevapi\session::close' => 'Close session',
'mysql_xdevapi\session::commit' => 'Commit transaction',
'mysql_xdevapi\session::createSchema' => 'Create new schema',
'mysql_xdevapi\session::dropSchema' => 'Drop a schema',
'mysql_xdevapi\session::executeSql' => 'Execute an SQL statement',
'mysql_xdevapi\session::generateUUID' => 'Get new UUID',
'mysql_xdevapi\session::getClientId' => 'Get client ID',
'mysql_xdevapi\session::getDefaultSchema' => 'Get default schema name',
'mysql_xdevapi\session::getSchema' => 'Get a new schema object',
'mysql_xdevapi\session::getSchemas' => 'Get the schemas',
'mysql_xdevapi\session::getServerVersion' => 'Get server version',
'mysql_xdevapi\session::killClient' => 'Kill the client',
'mysql_xdevapi\session::listClients' => 'Get client list',
'mysql_xdevapi\session::quoteName' => 'Add quotes',
'mysql_xdevapi\session::releaseSavepoint' => 'Release set savepoint',
'mysql_xdevapi\session::rollback' => 'Rollback transaction',
'mysql_xdevapi\session::rollbackTo' => 'Rollback transaction to savepoint',
'mysql_xdevapi\session::setSavepoint' => 'Create savepoint',
'mysql_xdevapi\session::sql' => 'Execute SQL query',
'mysql_xdevapi\session::startTransaction' => 'Start transaction',
'mysql_xdevapi\sqlstatement::__construct' => 'Description constructor',
'mysql_xdevapi\sqlstatement::bind' => 'Bind statement parameters',
'mysql_xdevapi\sqlstatement::execute' => 'Execute the operation',
'mysql_xdevapi\sqlstatement::getNextResult' => 'Get next result',
'mysql_xdevapi\sqlstatement::getResult' => 'Get result',
'mysql_xdevapi\sqlstatement::hasMoreResults' => 'Check for more results',
'mysql_xdevapi\sqlstatementresult::__construct' => 'Description constructor',
'mysql_xdevapi\sqlstatementresult::fetchAll' => 'Get all rows',
'mysql_xdevapi\sqlstatementresult::fetchOne' => 'Get single row',
'mysql_xdevapi\sqlstatementresult::getAffectedItemsCount' => 'Get affected row count',
'mysql_xdevapi\sqlstatementresult::getColumnCount' => 'Get column count',
'mysql_xdevapi\sqlstatementresult::getColumnNames' => 'Get column names',
'mysql_xdevapi\sqlstatementresult::getColumns' => 'Get columns',
'mysql_xdevapi\sqlstatementresult::getColumnsCount' => 'Get column count',
'mysql_xdevapi\sqlstatementresult::getGeneratedIds' => 'Get generated ids',
'mysql_xdevapi\sqlstatementresult::getLastInsertId' => 'Get last insert id',
'mysql_xdevapi\sqlstatementresult::getWarnings' => 'Get warnings from last operation',
'mysql_xdevapi\sqlstatementresult::getWarningsCount' => 'Get warning count from last operation',
'mysql_xdevapi\sqlstatementresult::hasData' => 'Check if result has data',
'mysql_xdevapi\sqlstatementresult::nextResult' => 'Get next result',
'mysql_xdevapi\statement::__construct' => 'Description constructor',
'mysql_xdevapi\statement::getNextResult' => 'Get next result',
'mysql_xdevapi\statement::getResult' => 'Get result',
'mysql_xdevapi\statement::hasMoreResults' => 'Check if more results',
'mysql_xdevapi\table::__construct' => 'Table constructor',
'mysql_xdevapi\table::count' => 'Get row count',
'mysql_xdevapi\table::delete' => 'Delete rows from table',
'mysql_xdevapi\table::existsInDatabase' => 'Check if table exists in database',
'mysql_xdevapi\table::getName' => 'Get table name',
'mysql_xdevapi\table::getSchema' => 'Get table schema',
'mysql_xdevapi\table::getSession' => 'Get table session',
'mysql_xdevapi\table::insert' => 'Insert table rows',
'mysql_xdevapi\table::isView' => 'Check if table is view',
'mysql_xdevapi\table::select' => 'Select rows from table',
'mysql_xdevapi\table::update' => 'Update rows in table',
'mysql_xdevapi\tabledelete::__construct' => 'TableDelete constructor',
'mysql_xdevapi\tabledelete::bind' => 'Bind delete query parameters',
'mysql_xdevapi\tabledelete::execute' => 'Execute delete query',
'mysql_xdevapi\tabledelete::limit' => 'Limit deleted rows',
'mysql_xdevapi\tabledelete::offset' => 'Set delete limit offset',
'mysql_xdevapi\tabledelete::orderby' => 'Set delete sort criteria',
'mysql_xdevapi\tabledelete::where' => 'Set delete search condition',
'mysql_xdevapi\tableinsert::__construct' => 'TableInsert constructor',
'mysql_xdevapi\tableinsert::execute' => 'Execute insert query',
'mysql_xdevapi\tableinsert::values' => 'Add insert row values',
'mysql_xdevapi\tableselect::__construct' => 'TableSelect constructor',
'mysql_xdevapi\tableselect::bind' => 'Bind select query parameters',
'mysql_xdevapi\tableselect::execute' => 'Execute select statement',
'mysql_xdevapi\tableselect::groupBy' => 'Set select grouping criteria',
'mysql_xdevapi\tableselect::having' => 'Set select having condition',
'mysql_xdevapi\tableselect::limit' => 'Limit selected rows',
'mysql_xdevapi\tableselect::lockExclusive' => 'Execute EXCLUSIVE LOCK',
'mysql_xdevapi\tableselect::lockShared' => 'Execute SHARED LOCK',
'mysql_xdevapi\tableselect::offset' => 'Set limit offset',
'mysql_xdevapi\tableselect::orderby' => 'Set select sort criteria',
'mysql_xdevapi\tableselect::where' => 'Set select search condition',
'mysql_xdevapi\tableupdate::__construct' => 'TableUpdate constructor',
'mysql_xdevapi\tableupdate::bind' => 'Bind update query parameters',
'mysql_xdevapi\tableupdate::execute' => 'Execute update query',
'mysql_xdevapi\tableupdate::limit' => 'Limit update row count',
'mysql_xdevapi\tableupdate::orderby' => 'Set sorting criteria',
'mysql_xdevapi\tableupdate::set' => 'Add field to be updated',
'mysql_xdevapi\tableupdate::where' => 'Set search filter',
'mysql_xdevapi\warning::__construct' => 'Warning constructor',
'mysql_xdevapi\xsession::__construct' => 'Description constructor',
'mysqli::__construct' => 'Open a new connection to the MySQL server
</p>',
'mysqli::autocommit' => 'Turns on or off auto-committing database modifications',
'mysqli::begin_transaction' => 'Starts a transaction',
'mysqli::change_user' => 'Changes the user of the specified database connection',
'mysqli::character_set_name' => 'Returns the default character set for the database connection',
'mysqli::close' => 'Closes a previously opened database connection',
'mysqli::commit' => 'Commits the current transaction',
'mysqli::debug' => 'Performs debugging operations',
'mysqli::dump_debug_info' => 'Dump debugging information into the log',
'mysqli::escape_string' => 'Escapes special characters in a string for use in an SQL statement, taking into account the current charset of the connection',
'mysqli::get_charset' => 'Returns a character set object',
'mysqli::get_client_info' => 'Get MySQL client info',
'mysqli::get_connection_stats' => 'Returns statistics about the client connection',
'mysqli::get_server_info' => 'Returns the version of the MySQL server',
'mysqli::get_warnings' => 'Get result of SHOW WARNINGS',
'mysqli::init' => 'Initializes MySQLi and returns a resource for use with mysqli_real_connect()',
'mysqli::kill' => 'Asks the server to kill a MySQL thread',
'mysqli::more_results' => 'Check if there are any more query results from a multi query',
'mysqli::multi_query' => 'Performs a query on the database',
'mysqli::next_result' => 'Prepare next result from multi_query',
'mysqli::options' => 'Set options',
'mysqli::ping' => 'Pings a server connection, or tries to reconnect if the connection has gone down',
'mysqli::poll' => 'Poll connections',
'mysqli::prepare' => 'Prepare an SQL statement for execution',
'mysqli::query' => 'Performs a query on the database',
'mysqli::real_connect' => 'Opens a connection to a mysql server',
'mysqli::real_escape_string' => 'Escapes special characters in a string for use in an SQL statement, taking into account the current charset of the connection',
'mysqli::real_query' => 'Execute an SQL query',
'mysqli::reap_async_query' => 'Get result from async query',
'mysqli::refresh' => 'Refreshes',
'mysqli::release_savepoint' => 'Removes the named savepoint from the set of savepoints of the current transaction',
'mysqli::rollback' => 'Rolls back current transaction',
'mysqli::rpl_query_type' => 'Returns RPL query type',
'mysqli::savepoint' => 'Set a named transaction savepoint',
'mysqli::select_db' => 'Selects the default database for database queries',
'mysqli::send_query' => 'Send the query and return',
'mysqli::set_charset' => 'Sets the default client character set',
'mysqli::set_local_infile_default' => 'Unsets user defined handler for load local infile command',
'mysqli::set_local_infile_handler' => 'Set callback function for LOAD DATA LOCAL INFILE command',
'mysqli::ssl_set' => 'Used for establishing secure connections using SSL',
'mysqli::stat' => 'Gets the current system status',
'mysqli::stmt_init' => 'Initializes a statement and returns an object for use with mysqli_stmt_prepare',
'mysqli::store_result' => 'Transfers a result set from the last query',
'mysqli::thread_safe' => 'Returns whether thread safety is given or not',
'mysqli::use_result' => 'Initiate a result set retrieval',
'mysqli_bind_param' => 'Alias for mysqli_stmt_bind_param',
'mysqli_bind_result' => 'Alias for mysqli_stmt_bind_result',
'mysqli_client_encoding' => 'Alias of mysqli_character_set_name',
'mysqli_connect' => 'Alias of mysqli::__construct',
'mysqli_disable_rpl_parse' => 'Disable RPL parse',
'mysqli_driver::embedded_server_end' => 'Stop embedded server',
'mysqli_driver::embedded_server_start' => 'Initialize and start embedded server',
'mysqli_enable_reads_from_master' => 'Enable reads from master',
'mysqli_enable_rpl_parse' => 'Enable RPL parse',
'mysqli_escape_string' => 'Alias of mysqli_real_escape_string',
'mysqli_execute' => 'Alias for mysqli_stmt_execute',
'mysqli_execute_query' => 'Prepares, binds parameters, and executes SQL statement',
'mysqli_fetch' => 'Alias for mysqli_stmt_fetch',
'mysqli_get_cache_stats' => 'Returns client Zval cache statistics',
'mysqli_get_client_stats' => 'Returns client per-process statistics',
'mysqli_get_links_stats' => 'Return information about open and cached links',
'mysqli_get_metadata' => 'Alias for mysqli_stmt_result_metadata',
'mysqli_master_query' => 'Enforce execution of a query on the master in a master/slave setup',
'mysqli_param_count' => 'Alias for mysqli_stmt_param_count',
'mysqli_report' => 'Alias of mysqli_driver-&gt;report_mode',
'mysqli_result::__construct' => 'Constructor (no docs available)',
'mysqli_result::close' => 'Frees the memory associated with a result',
'mysqli_result::data_seek' => 'Adjusts the result pointer to an arbitrary row in the result',
'mysqli_result::fetch_all' => 'Fetches all result rows as an associative array, a numeric array, or both',
'mysqli_result::fetch_array' => 'Fetch a result row as an associative, a numeric array, or both',
'mysqli_result::fetch_assoc' => 'Fetch a result row as an associative array',
'mysqli_result::fetch_column' => 'Fetch a single column from the next row of a result set',
'mysqli_result::fetch_field' => 'Returns the next field in the result set',
'mysqli_result::fetch_field_direct' => 'Fetch meta-data for a single field',
'mysqli_result::fetch_fields' => 'Returns an array of objects representing the fields in a result set',
'mysqli_result::fetch_object' => 'Returns the current row of a result set as an object',
'mysqli_result::fetch_row' => 'Get a result row as an enumerated array',
'mysqli_result::field_seek' => 'Set result pointer to a specified field offset',
'mysqli_result::free' => 'Frees the memory associated with a result',
'mysqli_result::free_result' => 'Frees the memory associated with a result',
'mysqli_rpl_parse_enabled' => 'Check if RPL parse is enabled',
'mysqli_rpl_probe' => 'RPL probe',
'mysqli_send_long_data' => 'Alias for mysqli_stmt_send_long_data',
'mysqli_slave_query' => 'Force execution of a query on a slave in a master/slave setup',
'mysqli_sql_exception::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'mysqli_sql_exception::__toString' => 'String representation of the exception',
'mysqli_sql_exception::getCode' => 'Gets the Exception code',
'mysqli_sql_exception::getFile' => 'Gets the file in which the exception occurred',
'mysqli_sql_exception::getLine' => 'Gets the line in which the exception occurred',
'mysqli_sql_exception::getMessage' => 'Gets the Exception message',
'mysqli_sql_exception::getPrevious' => 'Returns previous Exception',
'mysqli_sql_exception::getTrace' => 'Gets the stack trace',
'mysqli_sql_exception::getTraceAsString' => 'Gets the stack trace as a string',
'mysqli_stmt::__construct' => 'Constructs a new mysqli_stmt object',
'mysqli_stmt::attr_get' => 'Used to get the current value of a statement attribute',
'mysqli_stmt::attr_set' => 'Used to modify the behavior of a prepared statement',
'mysqli_stmt::bind_param' => 'Binds variables to a prepared statement as parameters',
'mysqli_stmt::bind_result' => 'Binds variables to a prepared statement for result storage',
'mysqli_stmt::close' => 'Closes a prepared statement',
'mysqli_stmt::data_seek' => 'Seeks to an arbitrary row in statement result set',
'mysqli_stmt::execute' => 'Executes a prepared statement',
'mysqli_stmt::fetch' => 'Fetch results from a prepared statement into the bound variables',
'mysqli_stmt::free_result' => 'Frees stored result memory for the given statement handle',
'mysqli_stmt::get_result' => 'Gets a result set from a prepared statement',
'mysqli_stmt::get_warnings' => 'Get result of SHOW WARNINGS',
'mysqli_stmt::more_results' => 'Check if there are more query results from a multiple query',
'mysqli_stmt::next_result' => 'Reads the next result from a multiple query',
'mysqli_stmt::num_rows' => 'Return the number of rows in statements result set',
'mysqli_stmt::prepare' => 'Prepare an SQL statement for execution',
'mysqli_stmt::reset' => 'Resets a prepared statement',
'mysqli_stmt::result_metadata' => 'Returns result set metadata from a prepared statement',
'mysqli_stmt::send_long_data' => 'Send data in blocks',
'mysqli_stmt::stmt' => 'No documentation available',
'mysqli_stmt::store_result' => 'Transfers a result set from a prepared statement',
'mysqli_warning::__construct' => 'The __construct purpose',
'mysqli_warning::next' => 'The next purpose',
'mysqlnd_memcache_get_config' => 'Returns information about the plugin configuration',
'mysqlnd_memcache_set' => 'Associate a MySQL connection with a Memcache connection',
'mysqlnd_ms_dump_servers' => 'Returns a list of currently configured servers',
'mysqlnd_ms_fabric_select_global' => 'Switch to global sharding server for a given table',
'mysqlnd_ms_fabric_select_shard' => 'Switch to shard',
'mysqlnd_ms_get_last_gtid' => 'Returns the latest global transaction ID',
'mysqlnd_ms_get_last_used_connection' => 'Returns an array which describes the last used connection',
'mysqlnd_ms_get_stats' => 'Returns query distribution and connection statistics',
'mysqlnd_ms_match_wild' => 'Finds whether a table name matches a wildcard pattern or not',
'mysqlnd_ms_query_is_select' => 'Find whether to send the query to the master, the slave or the last used MySQL server',
'mysqlnd_ms_set_qos' => 'Sets the quality of service needed from the cluster',
'mysqlnd_ms_set_user_pick_server' => 'Sets a callback for user-defined read/write splitting',
'mysqlnd_ms_xa_begin' => 'Starts a distributed/XA transaction among MySQL servers',
'mysqlnd_ms_xa_commit' => 'Commits a distributed/XA transaction among MySQL servers',
'mysqlnd_ms_xa_gc' => 'Garbage collects unfinished XA transactions after severe errors',
'mysqlnd_ms_xa_rollback' => 'Rolls back a distributed/XA transaction among MySQL servers',
'mysqlnd_qc_clear_cache' => 'Flush all cache contents',
'mysqlnd_qc_get_available_handlers' => 'Returns a list of available storage handler',
'mysqlnd_qc_get_cache_info' => 'Returns information on the current handler, the number of cache entries and cache entries, if available',
'mysqlnd_qc_get_core_stats' => 'Statistics collected by the core of the query cache',
'mysqlnd_qc_get_normalized_query_trace_log' => 'Returns a normalized query trace log for each query inspected by the query cache',
'mysqlnd_qc_get_query_trace_log' => 'Returns a backtrace for each query inspected by the query cache',
'mysqlnd_qc_set_cache_condition' => 'Set conditions for automatic caching',
'mysqlnd_qc_set_is_select' => 'Installs a callback which decides whether a statement is cached',
'mysqlnd_qc_set_storage_handler' => 'Change current storage handler',
'mysqlnd_qc_set_user_handlers' => 'Sets the callback functions for a user-defined procedural storage handler',
'mysqlnd_uh_convert_to_mysqlnd' => 'Converts a MySQL connection handle into a mysqlnd connection handle',
'mysqlnd_uh_set_connection_proxy' => 'Installs a proxy for mysqlnd connections',
'mysqlnd_uh_set_statement_proxy' => 'Installs a proxy for mysqlnd statements',
'mysqlnduhconnection::__construct' => 'The __construct purpose',
'mysqlnduhconnection::changeUser' => 'Changes the user of the specified mysqlnd database connection',
'mysqlnduhconnection::charsetName' => 'Returns the default character set for the database connection',
'mysqlnduhconnection::close' => 'Closes a previously opened database connection',
'mysqlnduhconnection::connect' => 'Open a new connection to the MySQL server',
'mysqlnduhconnection::endPSession' => 'End a persistent connection',
'mysqlnduhconnection::escapeString' => 'Escapes special characters in a string for use in an SQL statement, taking into account the current charset of the connection',
'mysqlnduhconnection::getAffectedRows' => 'Gets the number of affected rows in a previous MySQL operation',
'mysqlnduhconnection::getErrorNumber' => 'Returns the error code for the most recent function call',
'mysqlnduhconnection::getErrorString' => 'Returns a string description of the last error',
'mysqlnduhconnection::getFieldCount' => 'Returns the number of columns for the most recent query',
'mysqlnduhconnection::getHostInformation' => 'Returns a string representing the type of connection used',
'mysqlnduhconnection::getLastInsertId' => 'Returns the auto generated id used in the last query',
'mysqlnduhconnection::getLastMessage' => 'Retrieves information about the most recently executed query',
'mysqlnduhconnection::getProtocolInformation' => 'Returns the version of the MySQL protocol used',
'mysqlnduhconnection::getServerInformation' => 'Returns the version of the MySQL server',
'mysqlnduhconnection::getServerStatistics' => 'Gets the current system status',
'mysqlnduhconnection::getServerVersion' => 'Returns the version of the MySQL server as an integer',
'mysqlnduhconnection::getSqlstate' => 'Returns the SQLSTATE error from previous MySQL operation',
'mysqlnduhconnection::getStatistics' => 'Returns statistics about the client connection',
'mysqlnduhconnection::getThreadId' => 'Returns the thread ID for the current connection',
'mysqlnduhconnection::getWarningCount' => 'Returns the number of warnings from the last query for the given link',
'mysqlnduhconnection::init' => 'Initialize mysqlnd connection',
'mysqlnduhconnection::killConnection' => 'Asks the server to kill a MySQL thread',
'mysqlnduhconnection::listFields' => 'List MySQL table fields',
'mysqlnduhconnection::listMethod' => 'Wrapper for assorted list commands',
'mysqlnduhconnection::moreResults' => 'Check if there are any more query results from a multi query',
'mysqlnduhconnection::nextResult' => 'Prepare next result from multi_query',
'mysqlnduhconnection::ping' => 'Pings a server connection, or tries to reconnect if the connection has gone down',
'mysqlnduhconnection::query' => 'Performs a query on the database',
'mysqlnduhconnection::queryReadResultsetHeader' => 'Read a result set header',
'mysqlnduhconnection::reapQuery' => 'Get result from async query',
'mysqlnduhconnection::refreshServer' => 'Flush or reset tables and caches',
'mysqlnduhconnection::restartPSession' => 'Restart a persistent mysqlnd connection',
'mysqlnduhconnection::selectDb' => 'Selects the default database for database queries',
'mysqlnduhconnection::sendClose' => 'Sends a close command to MySQL',
'mysqlnduhconnection::sendQuery' => 'Sends a query to MySQL',
'mysqlnduhconnection::serverDumpDebugInformation' => 'Dump debugging information into the log for the MySQL server',
'mysqlnduhconnection::setAutocommit' => 'Turns on or off auto-committing database modifications',
'mysqlnduhconnection::setCharset' => 'Sets the default client character set',
'mysqlnduhconnection::setClientOption' => 'Sets a client option',
'mysqlnduhconnection::setServerOption' => 'Sets a server option',
'mysqlnduhconnection::shutdownServer' => 'The shutdownServer purpose',
'mysqlnduhconnection::simpleCommand' => 'Sends a basic COM_* command',
'mysqlnduhconnection::simpleCommandHandleResponse' => 'Process a response for a basic COM_* command send to the client',
'mysqlnduhconnection::sslSet' => 'Used for establishing secure connections using SSL',
'mysqlnduhconnection::stmtInit' => 'Initializes a statement and returns a resource for use with mysqli_statement::prepare',
'mysqlnduhconnection::storeResult' => 'Transfers a result set from the last query',
'mysqlnduhconnection::txCommit' => 'Commits the current transaction',
'mysqlnduhconnection::txRollback' => 'Rolls back current transaction',
'mysqlnduhconnection::useResult' => 'Initiate a result set retrieval',
'mysqlnduhpreparedstatement::__construct' => 'The __construct purpose',
'mysqlnduhpreparedstatement::execute' => 'Executes a prepared Query',
'mysqlnduhpreparedstatement::prepare' => 'Prepare an SQL statement for execution',
'natcasesort' => 'Sort an array using a case insensitive "natural order" algorithm',
'natsort' => 'Sort an array using a "natural order" algorithm',
'ncurses_addch' => 'Add character at current position and advance cursor',
'ncurses_addchnstr' => 'Add attributed string with specified length at current position',
'ncurses_addchstr' => 'Add attributed string at current position',
'ncurses_addnstr' => 'Add string with specified length at current position',
'ncurses_addstr' => 'Output text at current position',
'ncurses_assume_default_colors' => 'Define default colors for color 0',
'ncurses_attroff' => 'Turn off the given attributes',
'ncurses_attron' => 'Turn on the given attributes',
'ncurses_attrset' => 'Set given attributes',
'ncurses_baudrate' => 'Returns baudrate of terminal',
'ncurses_beep' => 'Let the terminal beep',
'ncurses_bkgd' => 'Set background property for terminal screen',
'ncurses_bkgdset' => 'Control screen background',
'ncurses_border' => 'Draw a border around the screen using attributed characters',
'ncurses_bottom_panel' => 'Moves a visible panel to the bottom of the stack',
'ncurses_can_change_color' => 'Checks if terminal color definitions can be changed',
'ncurses_cbreak' => 'Switch off input buffering',
'ncurses_clear' => 'Clear screen',
'ncurses_clrtobot' => 'Clear screen from current position to bottom',
'ncurses_clrtoeol' => 'Clear screen from current position to end of line',
'ncurses_color_content' => 'Retrieves RGB components of a color',
'ncurses_color_set' => 'Set active foreground and background colors',
'ncurses_curs_set' => 'Set cursor state',
'ncurses_def_prog_mode' => 'Saves terminals (program) mode',
'ncurses_def_shell_mode' => 'Saves terminals (shell) mode',
'ncurses_define_key' => 'Define a keycode',
'ncurses_del_panel' => 'Remove panel from the stack and delete it (but not the associated window)',
'ncurses_delay_output' => 'Delay output on terminal using padding characters',
'ncurses_delch' => 'Delete character at current position, move rest of line left',
'ncurses_deleteln' => 'Delete line at current position, move rest of screen up',
'ncurses_delwin' => 'Delete a ncurses window',
'ncurses_doupdate' => 'Write all prepared refreshes to terminal',
'ncurses_echo' => 'Activate keyboard input echo',
'ncurses_echochar' => 'Single character output including refresh',
'ncurses_end' => 'Stop using ncurses, clean up the screen',
'ncurses_erase' => 'Erase terminal screen',
'ncurses_erasechar' => 'Returns current erase character',
'ncurses_filter' => 'Set LINES for iniscr() and newterm() to 1',
'ncurses_flash' => 'Flash terminal screen (visual bell)',
'ncurses_flushinp' => 'Flush keyboard input buffer',
'ncurses_getch' => 'Read a character from keyboard',
'ncurses_getmaxyx' => 'Returns the size of a window',
'ncurses_getmouse' => 'Reads mouse event',
'ncurses_getyx' => 'Returns the current cursor position for a window',
'ncurses_halfdelay' => 'Put terminal into halfdelay mode',
'ncurses_has_colors' => 'Checks if terminal has color capabilities',
'ncurses_has_ic' => 'Check for insert- and delete-capabilities',
'ncurses_has_il' => 'Check for line insert- and delete-capabilities',
'ncurses_has_key' => 'Check for presence of a function key on terminal keyboard',
'ncurses_hide_panel' => 'Remove panel from the stack, making it invisible',
'ncurses_hline' => 'Draw a horizontal line at current position using an attributed character and max. n characters long',
'ncurses_inch' => 'Get character and attribute at current position',
'ncurses_init' => 'Initialize ncurses',
'ncurses_init_color' => 'Define a terminal color',
'ncurses_init_pair' => 'Define a color pair',
'ncurses_insch' => 'Insert character moving rest of line including character at current position',
'ncurses_insdelln' => 'Insert lines before current line scrolling down (negative numbers delete and scroll up)',
'ncurses_insertln' => 'Insert a line, move rest of screen down',
'ncurses_insstr' => 'Insert string at current position, moving rest of line right',
'ncurses_instr' => 'Reads string from terminal screen',
'ncurses_isendwin' => 'Ncurses is in endwin mode, normal screen output may be performed',
'ncurses_keyok' => 'Enable or disable a keycode',
'ncurses_keypad' => 'Turns keypad on or off',
'ncurses_killchar' => 'Returns current line kill character',
'ncurses_longname' => 'Returns terminals description',
'ncurses_meta' => 'Enables/Disable 8-bit meta key information',
'ncurses_mouse_trafo' => 'Transforms coordinates',
'ncurses_mouseinterval' => 'Set timeout for mouse button clicks',
'ncurses_mousemask' => 'Sets mouse options',
'ncurses_move' => 'Move output position',
'ncurses_move_panel' => 'Moves a panel so that its upper-left corner is at [startx, starty]',
'ncurses_mvaddch' => 'Move current position and add character',
'ncurses_mvaddchnstr' => 'Move position and add attributed string with specified length',
'ncurses_mvaddchstr' => 'Move position and add attributed string',
'ncurses_mvaddnstr' => 'Move position and add string with specified length',
'ncurses_mvaddstr' => 'Move position and add string',
'ncurses_mvcur' => 'Move cursor immediately',
'ncurses_mvdelch' => 'Move position and delete character, shift rest of line left',
'ncurses_mvgetch' => 'Move position and get character at new position',
'ncurses_mvhline' => 'Set new position and draw a horizontal line using an attributed character and max. n characters long',
'ncurses_mvinch' => 'Move position and get attributed character at new position',
'ncurses_mvvline' => 'Set new position and draw a vertical line using an attributed character and max. n characters long',
'ncurses_mvwaddstr' => 'Add string at new position in window',
'ncurses_napms' => 'Sleep',
'ncurses_new_panel' => 'Create a new panel and associate it with window',
'ncurses_newpad' => 'Creates a new pad (window)',
'ncurses_newwin' => 'Create a new window',
'ncurses_nl' => 'Translate newline and carriage return / line feed',
'ncurses_nocbreak' => 'Switch terminal to cooked mode',
'ncurses_noecho' => 'Switch off keyboard input echo',
'ncurses_nonl' => 'Do not translate newline and carriage return / line feed',
'ncurses_noqiflush' => 'Do not flush on signal characters',
'ncurses_noraw' => 'Switch terminal out of raw mode',
'ncurses_pair_content' => 'Retrieves foreground and background colors of a color pair',
'ncurses_panel_above' => 'Returns the panel above panel',
'ncurses_panel_below' => 'Returns the panel below panel',
'ncurses_panel_window' => 'Returns the window associated with panel',
'ncurses_pnoutrefresh' => 'Copies a region from a pad into the virtual screen',
'ncurses_prefresh' => 'Copies a region from a pad into the virtual screen',
'ncurses_putp' => 'Apply padding information to the string and output it',
'ncurses_qiflush' => 'Flush on signal characters',
'ncurses_raw' => 'Switch terminal into raw mode',
'ncurses_refresh' => 'Refresh screen',
'ncurses_replace_panel' => 'Replaces the window associated with panel',
'ncurses_reset_prog_mode' => 'Resets the prog mode saved by def_prog_mode',
'ncurses_reset_shell_mode' => 'Resets the shell mode saved by def_shell_mode',
'ncurses_resetty' => 'Restores saved terminal state',
'ncurses_savetty' => 'Saves terminal state',
'ncurses_scr_dump' => 'Dump screen content to file',
'ncurses_scr_init' => 'Initialize screen from file dump',
'ncurses_scr_restore' => 'Restore screen from file dump',
'ncurses_scr_set' => 'Inherit screen from file dump',
'ncurses_scrl' => 'Scroll window content up or down without changing current position',
'ncurses_show_panel' => 'Places an invisible panel on top of the stack, making it visible',
'ncurses_slk_attr' => 'Returns current soft label key attribute',
'ncurses_slk_attroff' => 'Turn off the given attributes for soft function-key labels',
'ncurses_slk_attron' => 'Turn on the given attributes for soft function-key labels',
'ncurses_slk_attrset' => 'Set given attributes for soft function-key labels',
'ncurses_slk_clear' => 'Clears soft labels from screen',
'ncurses_slk_color' => 'Sets color for soft label keys',
'ncurses_slk_init' => 'Initializes soft label key functions',
'ncurses_slk_noutrefresh' => 'Copies soft label keys to virtual screen',
'ncurses_slk_refresh' => 'Copies soft label keys to screen',
'ncurses_slk_restore' => 'Restores soft label keys',
'ncurses_slk_set' => 'Sets function key labels',
'ncurses_slk_touch' => 'Forces output when ncurses_slk_noutrefresh is performed',
'ncurses_standend' => 'Stop using \'standout\' attribute',
'ncurses_standout' => 'Start using \'standout\' attribute',
'ncurses_start_color' => 'Initializes color functionality',
'ncurses_termattrs' => 'Returns a logical OR of all attribute flags supported by terminal',
'ncurses_termname' => 'Returns terminals (short)-name',
'ncurses_timeout' => 'Set timeout for special key sequences',
'ncurses_top_panel' => 'Moves a visible panel to the top of the stack',
'ncurses_typeahead' => 'Specify different filedescriptor for typeahead checking',
'ncurses_ungetch' => 'Put a character back into the input stream',
'ncurses_ungetmouse' => 'Pushes mouse event to queue',
'ncurses_update_panels' => 'Refreshes the virtual screen to reflect the relations between panels in the stack',
'ncurses_use_default_colors' => 'Assign terminal default colors to color id -1',
'ncurses_use_env' => 'Control use of environment information about terminal size',
'ncurses_use_extended_names' => 'Control use of extended names in terminfo descriptions',
'ncurses_vidattr' => 'Display the string on the terminal in the video attribute mode',
'ncurses_vline' => 'Draw a vertical line at current position using an attributed character and max. n characters long',
'ncurses_waddch' => 'Adds character at current position in a window and advance cursor',
'ncurses_waddstr' => 'Outputs text at current position in window',
'ncurses_wattroff' => 'Turns off attributes for a window',
'ncurses_wattron' => 'Turns on attributes for a window',
'ncurses_wattrset' => 'Set the attributes for a window',
'ncurses_wborder' => 'Draws a border around the window using attributed characters',
'ncurses_wclear' => 'Clears window',
'ncurses_wcolor_set' => 'Sets windows color pairings',
'ncurses_werase' => 'Erase window contents',
'ncurses_wgetch' => 'Reads a character from keyboard (window)',
'ncurses_whline' => 'Draws a horizontal line in a window at current position using an attributed character and max. n characters long',
'ncurses_wmouse_trafo' => 'Transforms window/stdscr coordinates',
'ncurses_wmove' => 'Moves windows output position',
'ncurses_wnoutrefresh' => 'Copies window to virtual screen',
'ncurses_wrefresh' => 'Refresh window on terminal screen',
'ncurses_wstandend' => 'End standout mode for a window',
'ncurses_wstandout' => 'Enter standout mode for a window',
'ncurses_wvline' => 'Draws a vertical line in a window at current position using an attributed character and max. n characters long',
'newt_bell' => 'Send a beep to the terminal',
'newt_button' => 'Create a new button',
'newt_button_bar' => 'This function returns a grid containing the buttons created',
'newt_centered_window' => 'Open a centered window of the specified size',
'newt_checkbox_get_value' => 'Retreives value of checkox resource',
'newt_checkbox_set_flags' => 'Configures checkbox resource',
'newt_checkbox_set_value' => 'Sets the value of the checkbox',
'newt_checkbox_tree_add_item' => 'Adds new item to the checkbox tree',
'newt_checkbox_tree_find_item' => 'Finds an item in the checkbox tree',
'newt_checkbox_tree_get_current' => 'Returns checkbox tree selected item',
'newt_clear_key_buffer' => 'Discards the contents of the terminal\'s input buffer without waiting for additional input',
'newt_draw_root_text' => 'Displays the string text at the position indicated',
'newt_finished' => 'Uninitializes newt interface',
'newt_form' => 'Create a form',
'newt_form_add_component' => 'Adds a single component to the form',
'newt_form_add_components' => 'Add several components to the form',
'newt_form_destroy' => 'Destroys a form',
'newt_form_run' => 'Runs a form',
'newt_get_screen_size' => 'Fills in the passed references with the current size of the terminal',
'newt_init' => 'Initialize newt',
'newt_open_window' => 'Open a window of the specified size and position',
'newt_pop_help_line' => 'Replaces the current help line with the one from the stack',
'newt_pop_window' => 'Removes the top window from the display',
'newt_push_help_line' => 'Saves the current help line on a stack, and displays the new line',
'newt_refresh' => 'Updates modified portions of the screen',
'newt_resume' => 'Resume using the newt interface after calling newt_suspend',
'newt_run_form' => 'Runs a form',
'newt_set_suspend_callback' => 'Set a callback function which gets invoked when user presses the suspend key',
'newt_suspend' => 'Tells newt to return the terminal to its initial state',
'newt_wait_for_key' => 'Doesn\'t return until a key has been pressed',
'next' => 'Advance the internal pointer of an array',
'ngettext' => 'Plural version of gettext',
'nl2br' => 'Inserts HTML line breaks before all newlines in a string',
'nl_langinfo' => 'Query language and locale information',
'norewinditerator::__construct' => 'Construct a NoRewindIterator',
'norewinditerator::current' => 'Get the current value',
'norewinditerator::getInnerIterator' => 'Get the inner iterator',
'norewinditerator::key' => 'Get the current key',
'norewinditerator::next' => 'Forward to the next element',
'norewinditerator::rewind' => 'Prevents the rewind operation on the inner iterator',
'norewinditerator::valid' => 'Validates the iterator',
'normalizer::getRawDecomposition' => 'Gets the Decomposition_Mapping property for the given UTF-8 encoded code point',
'normalizer::isNormalized' => 'Checks if the provided string is already in the specified normalization form',
'normalizer::normalize' => 'Normalizes the input provided and returns the normalized string',
'nsapi_request_headers' => 'Fetch all HTTP request headers',
'nsapi_response_headers' => 'Fetch all HTTP response headers',
'nsapi_virtual' => 'Perform an NSAPI sub-request',
'number_format' => 'Format a number with grouped thousands',
'NumberFormatter::create' => 'Create a number formatter',
'numberformatter::format' => 'Format a number',
'numberformatter::formatCurrency' => 'Format a currency value',
'numberformatter::getAttribute' => 'Get an attribute',
'numberformatter::getErrorCode' => 'Get formatter\'s last error code',
'numberformatter::getErrorMessage' => 'Get formatter\'s last error message',
'numberformatter::getLocale' => 'Get formatter locale',
'numberformatter::getPattern' => 'Get formatter pattern',
'numberformatter::getSymbol' => 'Get a symbol value',
'numberformatter::getTextAttribute' => 'Get a text attribute',
'numberformatter::parse' => 'Parse a number',
'numberformatter::parseCurrency' => 'Parse a currency number',
'numberformatter::setAttribute' => 'Set an attribute',
'numberformatter::setPattern' => 'Set formatter pattern',
'numberformatter::setSymbol' => 'Set a symbol value',
'numberformatter::setTextAttribute' => 'Set a text attribute',
'oauth::__construct' => 'Create a new OAuth object',
'oauth::__destruct' => 'The destructor',
'oauth::disableDebug' => 'Turn off verbose debugging',
'oauth::disableRedirects' => 'Turn off redirects',
'oauth::disableSSLChecks' => 'Turn off SSL checks',
'oauth::enableDebug' => 'Turn on verbose debugging',
'oauth::enableRedirects' => 'Turn on redirects',
'oauth::enableSSLChecks' => 'Turn on SSL checks',
'oauth::fetch' => 'Fetch an OAuth protected resource',
'oauth::generateSignature' => 'Generate a signature',
'oauth::getAccessToken' => 'Fetch an access token',
'oauth::getCAPath' => 'Gets CA information',
'oauth::getLastResponse' => 'Get the last response',
'oauth::getLastResponseHeaders' => 'Get headers for last response',
'oauth::getLastResponseInfo' => 'Get HTTP information about the last response',
'oauth::getRequestHeader' => 'Generate OAuth header string signature',
'oauth::getRequestToken' => 'Fetch a request token',
'oauth::setAuthType' => 'Set authorization type',
'oauth::setCAPath' => 'Set CA path and info',
'oauth::setNonce' => 'Set the nonce for subsequent requests',
'oauth::setRequestEngine' => 'The setRequestEngine purpose',
'oauth::setRSACertificate' => 'Set the RSA certificate',
'oauth::setSSLChecks' => 'Tweak specific SSL checks for requests',
'OAuth::setTimeout' => 'Set the timeout',
'oauth::setTimestamp' => 'Set the timestamp',
'oauth::setToken' => 'Sets the token and secret',
'oauth::setVersion' => 'Set the OAuth version',
'oauth_get_sbs' => 'Generate a Signature Base String',
'oauth_urlencode' => 'Encode a URI to RFC 3986',
'oauthprovider::__construct' => 'Constructs a new OAuthProvider object',
'oauthprovider::addRequiredParameter' => 'Add required parameters',
'oauthprovider::callconsumerHandler' => 'Calls the consumerNonceHandler callback',
'oauthprovider::callTimestampNonceHandler' => 'Calls the timestampNonceHandler callback',
'oauthprovider::calltokenHandler' => 'Calls the tokenNonceHandler callback',
'oauthprovider::checkOAuthRequest' => 'Check an oauth request',
'oauthprovider::consumerHandler' => 'Set the consumerHandler handler callback',
'oauthprovider::generateToken' => 'Generate a random token',
'oauthprovider::is2LeggedEndpoint' => 'is2LeggedEndpoint',
'oauthprovider::isRequestTokenEndpoint' => 'Sets isRequestTokenEndpoint',
'oauthprovider::removeRequiredParameter' => 'Remove a required parameter',
'oauthprovider::reportProblem' => 'Report a problem',
'oauthprovider::setParam' => 'Set a parameter',
'oauthprovider::setRequestTokenPath' => 'Set request token path',
'oauthprovider::timestampNonceHandler' => 'Set the timestampNonceHandler handler callback',
'oauthprovider::tokenHandler' => 'Set the tokenHandler handler callback',
'ob_clean' => 'Clean (erase) the output buffer',
'ob_end_clean' => 'Clean (erase) the output buffer and turn off output buffering',
'ob_end_flush' => 'Flush (send) the output buffer and turn off output buffering',
'ob_flush' => 'Flush (send) the output buffer',
'ob_get_clean' => 'Get current buffer contents and delete current output buffer',
'ob_get_contents' => 'Return the contents of the output buffer',
'ob_get_flush' => 'Flush the output buffer, return it as a string and turn off output buffering',
'ob_get_length' => 'Return the length of the output buffer',
'ob_get_level' => 'Return the nesting level of the output buffering mechanism',
'ob_get_status' => 'Get status of output buffers',
'ob_gzhandler' => 'ob_start callback function to gzip output buffer',
'ob_iconv_handler' => 'Convert character encoding as output buffer handler',
'ob_implicit_flush' => 'Turn implicit flush on/off',
'ob_list_handlers' => 'List all output handlers in use',
'ob_start' => 'Turn on output buffering',
'ob_tidyhandler' => 'ob_start callback function to repair the buffer',
'oci_bind_array_by_name' => 'Binds a PHP array to an Oracle PL/SQL array parameter',
'oci_bind_by_name' => 'Binds a PHP variable to an Oracle placeholder',
'oci_cancel' => 'Cancels reading from cursor',
'oci_client_version' => 'Returns the Oracle client library version',
'oci_close' => 'Closes an Oracle connection',
'oci_collection::append' => 'Appends element to the collection',
'oci_collection::assign' => 'Assigns a value to the collection from another existing collection',
'oci_collection::assignElem' => 'Assigns a value to the element of the collection',
'oci_collection::free' => 'Frees the resources associated with the collection object',
'oci_collection::getElem' => 'Returns value of the element',
'oci_collection::max' => 'Returns the maximum number of elements in the collection',
'oci_collection::size' => 'Returns size of the collection',
'oci_collection::trim' => 'Trims elements from the end of the collection',
'oci_commit' => 'Commits the outstanding database transaction',
'oci_connect' => 'Connect to an Oracle database',
'oci_define_by_name' => 'Associates a PHP variable with a column for query fetches',
'oci_error' => 'Returns the last error found',
'oci_execute' => 'Executes a statement',
'oci_fetch' => 'Fetches the next row from a query into internal buffers',
'oci_fetch_all' => 'Fetches multiple rows from a query into a two-dimensional array',
'oci_fetch_array' => 'Returns the next row from a query as an associative or numeric array',
'oci_fetch_assoc' => 'Returns the next row from a query as an associative array',
'oci_fetch_object' => 'Returns the next row from a query as an object',
'oci_fetch_row' => 'Returns the next row from a query as a numeric array',
'oci_field_is_null' => 'Checks if a field in the currently fetched row is `null`',
'oci_field_name' => 'Returns the name of a field from the statement',
'oci_field_precision' => 'Tell the precision of a field',
'oci_field_scale' => 'Tell the scale of the field',
'oci_field_size' => 'Returns field\'s size',
'oci_field_type' => 'Returns a field\'s data type name',
'oci_field_type_raw' => 'Tell the raw Oracle data type of the field',
'oci_free_descriptor' => 'Frees a descriptor',
'oci_free_statement' => 'Frees all resources associated with statement or cursor',
'oci_get_implicit_resultset' => 'Returns the next child statement resource from a parent statement resource that has Oracle Database 12c Implicit Result Sets',
'oci_internal_debug' => 'Enables or disables internal debug output',
'oci_lob::append' => 'Appends data from the large object to another large object',
'oci_lob::close' => 'Closes LOB descriptor',
'oci_lob::eof' => 'Tests for end-of-file on a large object\'s descriptor',
'oci_lob::erase' => 'Erases a specified portion of the internal LOB data',
'oci_lob::export' => 'Exports LOB\'s contents to a file',
'oci_lob::flush' => 'Flushes/writes buffer of the LOB to the server',
'oci_lob::free' => 'Frees resources associated with the LOB descriptor',
'oci_lob::getBuffering' => 'Returns current state of buffering for the large object',
'oci_lob::import' => 'Imports file data to the LOB',
'oci_lob::load' => 'Returns large object\'s contents',
'oci_lob::read' => 'Reads part of the large object',
'oci_lob::rewind' => 'Moves the internal pointer to the beginning of the large object',
'oci_lob::save' => 'Saves data to the large object',
'oci_lob::saveFile' => 'Alias of OCI-Lob::import',
'oci_lob::seek' => 'Sets the internal pointer of the large object',
'oci_lob::setBuffering' => 'Changes current state of buffering for the large object',
'oci_lob::size' => 'Returns size of large object',
'oci_lob::tell' => 'Returns the current position of internal pointer of large object',
'oci_lob::truncate' => 'Truncates large object',
'oci_lob::write' => 'Writes data to the large object',
'oci_lob::writeTemporary' => 'Writes a temporary large object',
'oci_lob::writeToFile' => 'Alias of OCI-Lob::export',
'oci_lob_copy' => 'Copies large object',
'oci_lob_is_equal' => 'Compares two LOB/FILE locators for equality',
'oci_new_collection' => 'Allocates new collection object',
'oci_new_connect' => 'Connect to the Oracle server using a unique connection',
'oci_new_cursor' => 'Allocates and returns a new cursor (statement handle)',
'oci_new_descriptor' => 'Initializes a new empty LOB or FILE descriptor',
'oci_num_fields' => 'Returns the number of result columns in a statement',
'oci_num_rows' => 'Returns number of rows affected during statement execution',
'oci_parse' => 'Prepares an Oracle statement for execution',
'oci_password_change' => 'Changes password of Oracle\'s user',
'oci_pconnect' => 'Connect to an Oracle database using a persistent connection',
'oci_register_taf_callback' => 'Register a user-defined callback function for Oracle Database TAF',
'oci_result' => 'Returns field\'s value from the fetched row',
'oci_rollback' => 'Rolls back the outstanding database transaction',
'oci_server_version' => 'Returns the Oracle Database version',
'oci_set_action' => 'Sets the action name',
'oci_set_call_timeout' => 'Sets a millisecond timeout for database calls',
'oci_set_client_identifier' => 'Sets the client identifier',
'oci_set_client_info' => 'Sets the client information',
'oci_set_db_operation' => 'Sets the database operation',
'oci_set_edition' => 'Sets the database edition',
'oci_set_module_name' => 'Sets the module name',
'oci_set_prefetch' => 'Sets number of rows to be prefetched by queries',
'oci_statement_type' => 'Returns the type of a statement',
'oci_unregister_taf_callback' => 'Unregister a user-defined callback function for Oracle Database TAF',
'ocibindbyname' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_bind_by_name}',
'ocicancel' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_cancel}',
'ocicloselob' => '(PHP 4 &gt;= 4.0.6, PECL OCI8 1.0)
Alias of {@see OCI-Lob::close()}',
'ocicollappend' => '(PHP 4 &gt;= 4.0.6, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
(@see OCICollection::append)',
'ocicollassign' => '(PHP 4 >= 4.0.6, PECL OCI8 1.0)
Alias of {@see OCI-Collection::assign()}
Assigns a value to the collection from another existing collection',
'ocicollassignelem' => '(PHP 4 &gt;= 4.0.6, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see OCICollection::assignElem}',
'ocicollgetelem' => '(PHP 4 &gt;= 4.0.6, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see OCI_COLLection::getElem}',
'ocicollmax' => '(PHP 4 &gt;= 4.0.6, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see OCI_COLLection::max}',
'ocicollsize' => '(PHP 4 &gt;= 4.0.6, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see OCI_COLLection::size}',
'ocicolltrim' => '(PHP 4 &gt;= 4.0.6, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see OCICollection::trim}',
'ocicolumnisnull' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_field_is_null}',
'ocicolumnname' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_field_name}',
'ocicolumnprecision' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_field_precision}',
'ocicolumnscale' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_field_scale}',
'ocicolumnsize' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_field_size}',
'ocicolumntype' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_field_type}',
'ocicolumntyperaw' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_field_type_raw}',
'ocicommit' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see oci_commit}',
'ocidefinebyname' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_define_by_name}',
'ocierror' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see oci_error}',
'ociexecute' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_execute}',
'ocifetch' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_fetch}',
'ocifetchstatement' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_fetch_all}',
'ocifreecollection' => '(PHP 4 &gt;= 4.0.7, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see OCICollection::free}',
'ocifreecursor' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see oci_free_statement}',
'ocifreedesc' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see OCI-Lob::free}',
'ocifreestatement' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_free_statement}',
'ociinternaldebug' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_internal_debug}',
'ociloadlob' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see OCILob::load}',
'ocilogoff' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_close}',
'ocilogon' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_connect}',
'ocinewcollection' => '(PHP 4 &gt;= 4.0.6, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see oci_new_collection}',
'ocinewcursor' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_new_cursor}',
'ocinewdescriptor' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see oci_new_descriptor}',
'ocinlogon' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see oci_new_connect}',
'ocinumcols' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_num_fields}',
'ociparse' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_parse}',
'ocipasswordchange' => '(PHP 5, PECL OCI8 &gt;= 1.1.0)<br/>
Changes password of Oracle\'s user',
'ociplogon' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see oci_pconnect}',
'ociresult' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_result}',
'ocirollback' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see oci_rollback}',
'ocirowcount' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_num_rows}',
'ocisavelob' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see OCI-Lob::save}',
'ocisavelobfile' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see OCILob::import}',
'ociserverversion' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_server_version}',
'ocisetprefetch' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_set_prefetch}',
'ocistatementtype' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of {@see oci_statement_type}',
'ociwritelobtofile' => '(PHP 4, PHP 5, PECL OCI8 &gt;= 1.0.0)<br/>
Alias of
{@see OCILob::export}',
'ociwritetemporarylob' => '(PHP 4 &gt;= 4.0.6, PECL OCI8 1.0)
Writes a temporary large object
Alias of {@see OCI-Lob::writeTemporary()}',
'octdec' => 'Octal to decimal',
'odbc_autocommit' => 'Toggle autocommit behaviour',
'odbc_binmode' => 'Handling of binary column data',
'odbc_close' => 'Close an ODBC connection',
'odbc_close_all' => 'Close all ODBC connections',
'odbc_columnprivileges' => 'Lists columns and associated privileges for the given table',
'odbc_columns' => 'Lists the column names in specified tables',
'odbc_commit' => 'Commit an ODBC transaction',
'odbc_connect' => 'Connect to a datasource',
'odbc_cursor' => 'Get cursorname',
'odbc_data_source' => 'Returns information about a current connection',
'odbc_do' => 'Alias of odbc_exec',
'odbc_error' => 'Get the last error code',
'odbc_errormsg' => 'Get the last error message',
'odbc_exec' => 'Prepare and execute an SQL statement',
'odbc_execute' => 'Execute a prepared statement',
'odbc_fetch_array' => 'Fetch a result row as an associative array',
'odbc_fetch_into' => 'Fetch one result row into array',
'odbc_fetch_object' => 'Fetch a result row as an object',
'odbc_fetch_row' => 'Fetch a row',
'odbc_field_len' => 'Get the length (precision) of a field',
'odbc_field_name' => 'Get the columnname',
'odbc_field_num' => 'Return column number',
'odbc_field_precision' => 'Alias of odbc_field_len',
'odbc_field_scale' => 'Get the scale of a field',
'odbc_field_type' => 'Datatype of a field',
'odbc_foreignkeys' => 'Retrieves a list of foreign keys',
'odbc_free_result' => 'Free resources associated with a result',
'odbc_gettypeinfo' => 'Retrieves information about data types supported by the data source',
'odbc_longreadlen' => 'Handling of LONG columns',
'odbc_next_result' => 'Checks if multiple results are available',
'odbc_num_fields' => 'Number of columns in a result',
'odbc_num_rows' => 'Number of rows in a result',
'odbc_pconnect' => 'Open a persistent database connection',
'odbc_prepare' => 'Prepares a statement for execution',
'odbc_primarykeys' => 'Gets the primary keys for a table',
'odbc_procedurecolumns' => 'Retrieve information about parameters to procedures',
'odbc_procedures' => 'Get the list of procedures stored in a specific data source',
'odbc_result' => 'Get result data',
'odbc_result_all' => 'Print result as HTML table',
'odbc_rollback' => 'Rollback a transaction',
'odbc_setoption' => 'Adjust ODBC settings',
'odbc_specialcolumns' => 'Retrieves special columns',
'odbc_statistics' => 'Retrieve statistics about a table',
'odbc_tableprivileges' => 'Lists tables and the privileges associated with each table',
'odbc_tables' => 'Get the list of table names stored in a specific data source',
'opcache_compile_file' => 'Compiles and caches a PHP script without executing it',
'opcache_get_configuration' => 'Get configuration information about the cache',
'opcache_get_status' => 'Get status information about the cache',
'opcache_invalidate' => 'Invalidates a cached script',
'opcache_is_script_cached' => 'Tells whether a script is cached in OPCache',
'opcache_reset' => 'Resets the contents of the opcode cache',
'openal_buffer_create' => 'Generate OpenAL buffer',
'openal_buffer_data' => 'Load a buffer with data',
'openal_buffer_destroy' => 'Destroys an OpenAL buffer',
'openal_buffer_get' => 'Retrieve an OpenAL buffer property',
'openal_buffer_loadwav' => 'Load a .wav file into a buffer',
'openal_context_create' => 'Create an audio processing context',
'openal_context_current' => 'Make the specified context current',
'openal_context_destroy' => 'Destroys a context',
'openal_context_process' => 'Process the specified context',
'openal_context_suspend' => 'Suspend the specified context',
'openal_device_close' => 'Close an OpenAL device',
'openal_device_open' => 'Initialize the OpenAL audio layer',
'openal_listener_get' => 'Retrieve a listener property',
'openal_listener_set' => 'Set a listener property',
'openal_source_create' => 'Generate a source resource',
'openal_source_destroy' => 'Destroy a source resource',
'openal_source_get' => 'Retrieve an OpenAL source property',
'openal_source_pause' => 'Pause the source',
'openal_source_play' => 'Start playing the source',
'openal_source_rewind' => 'Rewind the source',
'openal_source_set' => 'Set source property',
'openal_source_stop' => 'Stop playing the source',
'openal_stream' => 'Begin streaming on a source',
'opendir' => 'Open directory handle',
'openlog' => 'Open connection to system logger',
'openssl_cipher_iv_length' => 'Gets the cipher iv length',
'openssl_csr_export' => 'Exports a CSR as a string',
'openssl_csr_export_to_file' => 'Exports a CSR to a file',
'openssl_csr_get_public_key' => 'Returns the public key of a CSR',
'openssl_csr_get_subject' => 'Returns the subject of a CSR',
'openssl_csr_new' => 'Generates a CSR',
'openssl_csr_sign' => 'Sign a CSR with another certificate (or itself) and generate a certificate',
'openssl_decrypt' => 'Decrypts data',
'openssl_dh_compute_key' => 'Computes shared secret for public value of remote DH public key and local DH key',
'openssl_digest' => 'Computes a digest',
'openssl_encrypt' => 'Encrypts data',
'openssl_error_string' => 'Return openSSL error message',
'openssl_free_key' => 'Free key resource',
'openssl_get_cert_locations' => 'Retrieve the available certificate locations',
'openssl_get_cipher_methods' => 'Gets available cipher methods',
'openssl_get_curve_names' => 'Gets list of available curve names for ECC',
'openssl_get_md_methods' => 'Gets available digest methods',
'openssl_get_privatekey' => 'Alias of openssl_pkey_get_private',
'openssl_get_publickey' => 'Alias of openssl_pkey_get_public',
'openssl_open' => 'Open sealed data',
'openssl_pbkdf2' => 'Generates a PKCS5 v2 PBKDF2 string',
'openssl_pkcs12_export' => 'Exports a PKCS#12 Compatible Certificate Store File to variable',
'openssl_pkcs12_export_to_file' => 'Exports a PKCS#12 Compatible Certificate Store File',
'openssl_pkcs12_read' => 'Parse a PKCS#12 Certificate Store into an array',
'openssl_pkcs7_decrypt' => 'Decrypts an S/MIME encrypted message',
'openssl_pkcs7_encrypt' => 'Encrypt an S/MIME message',
'openssl_pkcs7_read' => 'Export the PKCS7 file to an array of PEM certificates',
'openssl_pkcs7_sign' => 'Sign an S/MIME message',
'openssl_pkcs7_verify' => 'Verifies the signature of an S/MIME signed message',
'openssl_pkey_export' => 'Gets an exportable representation of a key into a string',
'openssl_pkey_export_to_file' => 'Gets an exportable representation of a key into a file',
'openssl_pkey_free' => 'Frees a private key',
'openssl_pkey_get_details' => 'Returns an array with the key details',
'openssl_pkey_get_private' => 'Get a private key',
'openssl_pkey_get_public' => 'Extract public key from certificate and prepare it for use',
'openssl_pkey_new' => 'Generates a new private key',
'openssl_private_decrypt' => 'Decrypts data with private key',
'openssl_private_encrypt' => 'Encrypts data with private key',
'openssl_public_decrypt' => 'Decrypts data with public key',
'openssl_public_encrypt' => 'Encrypts data with public key',
'openssl_random_pseudo_bytes' => 'Generate a pseudo-random string of bytes',
'openssl_seal' => 'Seal (encrypt) data',
'openssl_sign' => 'Generate signature',
'openssl_spki_export' => 'Exports a valid PEM formatted public key signed public key and challenge',
'openssl_spki_export_challenge' => 'Exports the challenge associated with a signed public key and challenge',
'openssl_spki_new' => 'Generate a new signed public key and challenge',
'openssl_spki_verify' => 'Verifies a signed public key and challenge',
'openssl_verify' => 'Verify signature',
'openssl_x509_check_private_key' => 'Checks if a private key corresponds to a certificate',
'openssl_x509_checkpurpose' => 'Verifies if a certificate can be used for a particular purpose',
'openssl_x509_export' => 'Exports a certificate as a string',
'openssl_x509_export_to_file' => 'Exports a certificate to file',
'openssl_x509_fingerprint' => 'Calculates the fingerprint, or digest, of a given X.509 certificate',
'openssl_x509_free' => 'Free certificate resource',
'openssl_x509_parse' => 'Parse an X509 certificate and return the information as an array',
'openssl_x509_read' => 'Parse an X.509 certificate and return a resource identifier for it',
'openssl_x509_verify' => 'Verifies digital signature of x509 certificate against a public key',
'ord' => 'Convert the first byte of a string to a value between 0 and 255',
'OuterIterator::current' => 'Return the current element',
'outeriterator::getInnerIterator' => 'Returns the inner iterator for the current entry',
'OuterIterator::key' => 'Return the key of the current element',
'OuterIterator::next' => 'Move forward to next element',
'OuterIterator::rewind' => 'Rewind the Iterator to the first element',
'OuterIterator::valid' => 'Checks if current position is valid',
'OutOfBoundsException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'OutOfBoundsException::__toString' => 'String representation of the exception',
'OutOfBoundsException::getCode' => 'Gets the Exception code',
'OutOfBoundsException::getFile' => 'Gets the file in which the exception occurred',
'OutOfBoundsException::getLine' => 'Gets the line in which the exception occurred',
'OutOfBoundsException::getMessage' => 'Gets the Exception message',
'OutOfBoundsException::getPrevious' => 'Returns previous Exception',
'OutOfBoundsException::getTrace' => 'Gets the stack trace',
'OutOfBoundsException::getTraceAsString' => 'Gets the stack trace as a string',
'OutOfRangeException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'OutOfRangeException::__toString' => 'String representation of the exception',
'OutOfRangeException::getCode' => 'Gets the Exception code',
'OutOfRangeException::getFile' => 'Gets the file in which the exception occurred',
'OutOfRangeException::getLine' => 'Gets the line in which the exception occurred',
'OutOfRangeException::getMessage' => 'Gets the Exception message',
'OutOfRangeException::getPrevious' => 'Returns previous Exception',
'OutOfRangeException::getTrace' => 'Gets the stack trace',
'OutOfRangeException::getTraceAsString' => 'Gets the stack trace as a string',
'output_add_rewrite_var' => 'Add URL rewriter values',
'output_reset_rewrite_vars' => 'Reset URL rewriter values',
'outputformatObj::getOption' => 'Returns the associated value for the format option property passed
as argument. Returns an empty string if property not found.',
'outputformatObj::set' => 'Set object property to a new value.',
'outputformatObj::setOption' => 'Add or Modify the format option list. return true on success.
.. code-block:: php
$oMap->outputformat->setOption("OUTPUT_TYPE", "RASTER");',
'outputformatObj::validate' => 'Checks some internal consistency issues, Returns MS_SUCCESS or
MS_FAILURE. Some problems are fixed up internally. May produce debug
output if issues encountered.',
'OverflowException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'OverflowException::__toString' => 'String representation of the exception',
'OverflowException::getCode' => 'Gets the Exception code',
'OverflowException::getFile' => 'Gets the file in which the exception occurred',
'OverflowException::getLine' => 'Gets the line in which the exception occurred',
'OverflowException::getMessage' => 'Gets the Exception message',
'OverflowException::getPrevious' => 'Returns previous Exception',
'OverflowException::getTrace' => 'Gets the stack trace',
'OverflowException::getTraceAsString' => 'Gets the stack trace as a string',
'override_function' => 'Overrides built-in functions',
'OwsrequestObj::__construct' => 'request = ms_newOwsrequestObj();
Create a new ows request object.',
'OwsrequestObj::addParameter' => 'Add a request parameter, even if the parameter key was previousely set.
This is useful when multiple parameters with the same key are required.
For example :
.. code-block:: php
$request->addparameter(\'SIZE\', \'x(100)\');
$request->addparameter(\'SIZE\', \'y(100)\');',
'OwsrequestObj::getName' => 'Return the name of the parameter at *index* in the request\'s array
of parameter names.',
'OwsrequestObj::getValue' => 'Return the value of the parameter at *index* in the request\'s array
of parameter values.',
'OwsrequestObj::getValueByName' => 'Return the value associated with the parameter *name*.',
'OwsrequestObj::loadParams' => 'Initializes the OWSRequest object from the cgi environment variables
REQUEST_METHOD, QUERY_STRING and HTTP_COOKIE.  Returns the number of
name/value pairs collected.',
'OwsrequestObj::setParameter' => 'Set a request parameter.  For example :
.. code-block:: php
$request->setparameter(\'REQUEST\', \'GetMap\');',
'pack' => 'Pack data into binary string',
'parallel\bootstrap' => 'Bootstrapping',
'parallel\channel::__construct' => 'Channel Construction',
'parallel\Channel::__toString' => 'Returns name of channel',
'parallel\channel::close' => 'Closing',
'parallel\channel::make' => 'Access',
'parallel\channel::open' => 'Access',
'parallel\channel::recv' => 'Sharing',
'parallel\channel::send' => 'Sharing',
'parallel\events::addChannel' => 'Targets',
'parallel\events::addFuture' => 'Targets',
'parallel\events::poll' => 'Polling',
'parallel\events::remove' => 'Targets',
'parallel\events::setBlocking' => 'Behaviour',
'parallel\events::setInput' => 'Input',
'parallel\events::setTimeout' => 'Behaviour',
'parallel\Events\Input::add' => 'Shall set input for the given target',
'parallel\Events\Input::clear' => 'Shall remove input for all targets',
'parallel\Events\Input::remove' => 'Shall remove input for the given target',
'parallel\future::cancel' => 'Cancellation',
'parallel\future::cancelled' => 'State Detection',
'parallel\future::done' => 'State Detection',
'parallel\future::select' => 'Resolution',
'parallel\future::value' => 'Resolution',
'parallel\input::add' => 'Inputs',
'parallel\input::clear' => 'Inputs',
'parallel\input::remove' => 'Inputs',
'parallel\run' => 'Execution',
'parallel\runtime::__construct' => 'Runtime Construction',
'parallel\runtime::close' => 'Runtime Graceful Join',
'parallel\runtime::kill' => 'Runtime Join',
'parallel\runtime::run' => 'Parallel Execution',
'parallel\sync::__construct' => 'Construction',
'parallel\sync::__invoke' => 'Synchronization',
'parallel\sync::get' => 'Access',
'parallel\sync::notify' => 'Synchronization',
'parallel\sync::set' => 'Access',
'parallel\sync::wait' => 'Synchronization',
'parentiterator::__construct' => 'Constructs a ParentIterator',
'parentiterator::accept' => 'Determines acceptability',
'ParentIterator::current' => 'Get the current element value',
'parentiterator::getChildren' => 'Return the inner iterator\'s children contained in a ParentIterator',
'ParentIterator::getInnerIterator' => 'Get the inner iterator',
'parentiterator::hasChildren' => 'Check whether the inner iterator\'s current element has children',
'ParentIterator::key' => 'Get the current key',
'parentiterator::next' => 'Move the iterator forward',
'parentiterator::rewind' => 'Rewind the iterator',
'ParentIterator::valid' => 'Check whether the current element is valid',
'parle\lexer::advance' => 'Process next lexer rule',
'parle\lexer::build' => 'Finalize the lexer rule set',
'parle\lexer::callout' => 'Define token callback',
'parle\lexer::consume' => 'Pass the data for processing',
'parle\lexer::dump' => 'Dump the state machine',
'parle\lexer::getToken' => 'Retrieve the current token',
'parle\lexer::insertMacro' => 'Insert regex macro',
'parle\lexer::push' => 'Add a lexer rule',
'parle\lexer::reset' => 'Reset lexer',
'parle\parser::advance' => 'Process next parser rule',
'parle\parser::build' => 'Finalize the grammar rules',
'parle\parser::consume' => 'Consume the data for processing',
'parle\parser::dump' => 'Dump the grammar',
'parle\parser::errorInfo' => 'Retrieve the error information',
'parle\parser::left' => 'Declare a token with left-associativity',
'parle\parser::nonassoc' => 'Declare a token with no associativity',
'parle\parser::precedence' => 'Declare a precedence rule',
'parle\parser::push' => 'Add a grammar rule',
'parle\parser::reset' => 'Reset parser state',
'parle\parser::right' => 'Declare a token with right-associativity',
'parle\parser::sigil' => 'Retrieve a matching part of a rule',
'parle\parser::token' => 'Declare a token',
'parle\parser::tokenId' => 'Get token id',
'parle\parser::trace' => 'Trace the parser operation',
'parle\parser::validate' => 'Validate input',
'parle\rlexer::advance' => 'Process next lexer rule',
'parle\rlexer::build' => 'Finalize the lexer rule set',
'parle\rlexer::callout' => 'Define token callback',
'parle\rlexer::consume' => 'Pass the data for processing',
'parle\rlexer::dump' => 'Dump the state machine',
'parle\rlexer::getToken' => 'Retrieve the current token',
'parle\rlexer::insertMacro' => 'Insert regex macro',
'parle\rlexer::push' => 'Add a lexer rule',
'parle\rlexer::pushState' => 'Push a new start state',
'parle\rlexer::reset' => 'Reset lexer',
'parle\rparser::advance' => 'Process next parser rule',
'parle\rparser::build' => 'Finalize the grammar rules',
'parle\rparser::consume' => 'Consume the data for processing',
'parle\rparser::dump' => 'Dump the grammar',
'parle\rparser::errorInfo' => 'Retrieve the error information',
'parle\rparser::left' => 'Declare a token with left-associativity',
'parle\rparser::nonassoc' => 'Declare a token with no associativity',
'parle\rparser::precedence' => 'Declare a precedence rule',
'parle\rparser::push' => 'Add a grammar rule',
'parle\rparser::reset' => 'Reset parser state',
'parle\rparser::right' => 'Declare a token with right-associativity',
'parle\rparser::sigil' => 'Retrieve a matching part of a rule',
'parle\rparser::token' => 'Declare a token',
'parle\rparser::tokenId' => 'Get token id',
'parle\rparser::trace' => 'Trace the parser operation',
'parle\rparser::validate' => 'Validate input',
'parle\stack::pop' => 'Pop an item from the stack',
'parle\stack::push' => 'Push an item into the stack',
'parse_ini_file' => 'Parse a configuration file',
'parse_ini_string' => 'Parse a configuration string',
'parse_str' => 'Parses the string into variables',
'parse_url' => 'Parse a URL and return its components',
'ParseError::__clone' => 'Clone the error
Error can not be clone, so this method results in fatal error.',
'ParseError::__toString' => 'Gets a string representation of the thrown object',
'ParseError::getCode' => 'Gets the exception code',
'ParseError::getFile' => 'Gets the file in which the exception occurred',
'ParseError::getLine' => 'Gets the line on which the object was instantiated',
'ParseError::getPrevious' => 'Returns the previous Throwable',
'ParseError::getTrace' => 'Gets the stack trace',
'ParseError::getTraceAsString' => 'Gets the stack trace as a string',
'parsekit_compile_file' => 'Compile a PHP file and return the resulting op array',
'parsekit_compile_string' => 'Compile a string of PHP code and return the resulting op array',
'parsekit_func_arginfo' => 'Return information regarding function argument(s)',
'passthru' => 'Execute an external program and display raw output',
'password_get_info' => 'Returns information about the given hash',
'password_hash' => 'Creates a password hash',
'password_needs_rehash' => 'Checks if the given hash matches the given options',
'password_verify' => 'Verifies that a password matches a hash',
'pathinfo' => 'Returns information about a file path',
'pclose' => 'Closes process file pointer',
'pcntl_alarm' => 'Set an alarm clock for delivery of a signal',
'pcntl_async_signals' => 'Enable/disable asynchronous signal handling or return the old setting',
'pcntl_errno' => 'Alias of pcntl_get_last_error',
'pcntl_exec' => 'Executes specified program in current process space',
'pcntl_fork' => 'Forks the currently running process',
'pcntl_get_last_error' => 'Retrieve the error number set by the last pcntl function which failed',
'pcntl_getpriority' => 'Get the priority of any process',
'pcntl_setpriority' => 'Change the priority of any process',
'pcntl_signal' => 'Installs a signal handler',
'pcntl_signal_dispatch' => 'Calls signal handlers for pending signals',
'pcntl_signal_get_handler' => 'Get the current handler for specified signal',
'pcntl_sigprocmask' => 'Sets and retrieves blocked signals',
'pcntl_sigtimedwait' => 'Waits for signals, with a timeout',
'pcntl_sigwaitinfo' => 'Waits for signals',
'pcntl_strerror' => 'Retrieve the system error message associated with the given errno',
'pcntl_wait' => 'Waits on or returns the status of a forked child',
'pcntl_waitpid' => 'Waits on or returns the status of a forked child',
'pcntl_wexitstatus' => 'Returns the return code of a terminated child',
'pcntl_wifexited' => 'Checks if status code represents a normal exit',
'pcntl_wifsignaled' => 'Checks whether the status code represents a termination due to a signal',
'pcntl_wifstopped' => 'Checks whether the child process is currently stopped',
'pcntl_wstopsig' => 'Returns the signal which caused the child to stop',
'pcntl_wtermsig' => 'Returns the signal which caused the child to terminate',
'pdf_activate_item' => 'Activate structure element or other content item',
'pdf_add_annotation' => 'Add annotation [deprecated]',
'pdf_add_bookmark' => 'Add bookmark for current page [deprecated]',
'pdf_add_launchlink' => 'Add launch annotation for current page [deprecated]',
'pdf_add_locallink' => 'Add link annotation for current page [deprecated]',
'pdf_add_nameddest' => 'Create named destination',
'pdf_add_note' => 'Set annotation for current page [deprecated]',
'pdf_add_outline' => 'Add bookmark for current page [deprecated]',
'pdf_add_pdflink' => 'Add file link annotation for current page [deprecated]',
'pdf_add_table_cell' => 'Add a cell to a new or existing table',
'pdf_add_textflow' => 'Create Textflow or add text to existing Textflow',
'pdf_add_thumbnail' => 'Add thumbnail for current page',
'pdf_add_weblink' => 'Add weblink for current page [deprecated]',
'pdf_arc' => 'Draw a counterclockwise circular arc segment',
'pdf_arcn' => 'Draw a clockwise circular arc segment',
'pdf_attach_file' => 'Add file attachment for current page [deprecated]',
'pdf_begin_document' => 'Create new PDF file',
'pdf_begin_font' => 'Start a Type 3 font definition',
'pdf_begin_glyph' => 'Start glyph definition for Type 3 font',
'pdf_begin_item' => 'Open structure element or other content item',
'pdf_begin_layer' => 'Start layer',
'pdf_begin_page' => 'Start new page [deprecated]',
'pdf_begin_page_ext' => 'Start new page',
'pdf_begin_pattern' => 'Start pattern definition',
'pdf_begin_template' => 'Start template definition [deprecated]',
'pdf_begin_template_ext' => 'Start template definition',
'pdf_circle' => 'Draw a circle',
'pdf_clip' => 'Clip to current path',
'pdf_close' => 'Close pdf resource [deprecated]',
'pdf_close_image' => 'Close image',
'pdf_close_pdi' => 'Close the input PDF document [deprecated]',
'pdf_close_pdi_page' => 'Close the page handle',
'pdf_closepath' => 'Close current path',
'pdf_closepath_fill_stroke' => 'Close, fill and stroke current path',
'pdf_closepath_stroke' => 'Close and stroke path',
'pdf_concat' => 'Concatenate a matrix to the CTM',
'pdf_continue_text' => 'Output text in next line',
'pdf_create_3dview' => 'Create 3D view',
'pdf_create_action' => 'Create action for objects or events',
'pdf_create_annotation' => 'Create rectangular annotation',
'pdf_create_bookmark' => 'Create bookmark',
'pdf_create_field' => 'Create form field',
'pdf_create_fieldgroup' => 'Create form field group',
'pdf_create_gstate' => 'Create graphics state object',
'pdf_create_pvf' => 'Create PDFlib virtual file',
'pdf_create_textflow' => 'Create textflow object',
'pdf_curveto' => 'Draw Bezier curve',
'pdf_define_layer' => 'Create layer definition',
'pdf_delete' => 'Delete PDFlib object',
'pdf_delete_pvf' => 'Delete PDFlib virtual file',
'pdf_delete_table' => 'Delete table object',
'pdf_delete_textflow' => 'Delete textflow object',
'pdf_encoding_set_char' => 'Add glyph name and/or Unicode value',
'pdf_end_document' => 'Close PDF file',
'pdf_end_font' => 'Terminate Type 3 font definition',
'pdf_end_glyph' => 'Terminate glyph definition for Type 3 font',
'pdf_end_item' => 'Close structure element or other content item',
'pdf_end_layer' => 'Deactivate all active layers',
'pdf_end_page' => 'Finish page',
'pdf_end_page_ext' => 'Finish page',
'pdf_end_pattern' => 'Finish pattern',
'pdf_end_template' => 'Finish template',
'pdf_endpath' => 'End current path',
'pdf_fill' => 'Fill current path',
'pdf_fill_imageblock' => 'Fill image block with variable data',
'pdf_fill_pdfblock' => 'Fill PDF block with variable data',
'pdf_fill_stroke' => 'Fill and stroke path',
'pdf_fill_textblock' => 'Fill text block with variable data',
'pdf_findfont' => 'Prepare font for later use [deprecated]',
'pdf_fit_image' => 'Place image or template',
'pdf_fit_pdi_page' => 'Place imported PDF page',
'pdf_fit_table' => 'Place table on page',
'pdf_fit_textflow' => 'Format textflow in rectangular area',
'pdf_fit_textline' => 'Place single line of text',
'pdf_get_apiname' => 'Get name of unsuccessful API function',
'pdf_get_buffer' => 'Get PDF output buffer',
'pdf_get_errmsg' => 'Get error text',
'pdf_get_errnum' => 'Get error number',
'pdf_get_font' => 'Get font [deprecated]',
'pdf_get_fontname' => 'Get font name [deprecated]',
'pdf_get_fontsize' => 'Font handling [deprecated]',
'pdf_get_image_height' => 'Get image height [deprecated]',
'pdf_get_image_width' => 'Get image width [deprecated]',
'pdf_get_majorversion' => 'Get major version number [deprecated]',
'pdf_get_minorversion' => 'Get minor version number [deprecated]',
'pdf_get_parameter' => 'Get string parameter',
'pdf_get_pdi_parameter' => 'Get PDI string parameter [deprecated]',
'pdf_get_pdi_value' => 'Get PDI numerical parameter [deprecated]',
'pdf_get_value' => 'Get numerical parameter',
'pdf_info_font' => 'Query detailed information about a loaded font',
'pdf_info_matchbox' => 'Query matchbox information',
'pdf_info_table' => 'Retrieve table information',
'pdf_info_textflow' => 'Query textflow state',
'pdf_info_textline' => 'Perform textline formatting and query metrics',
'pdf_initgraphics' => 'Reset graphic state',
'pdf_lineto' => 'Draw a line',
'pdf_load_3ddata' => 'Load 3D model',
'pdf_load_font' => 'Search and prepare font',
'pdf_load_iccprofile' => 'Search and prepare ICC profile',
'pdf_load_image' => 'Open image file',
'pdf_makespotcolor' => 'Make spot color',
'pdf_moveto' => 'Set current point',
'pdf_new' => 'Create PDFlib object',
'pdf_open_ccitt' => 'Open raw CCITT image [deprecated]',
'pdf_open_file' => 'Create PDF file [deprecated]',
'pdf_open_gif' => 'Open GIF image [deprecated]',
'pdf_open_image' => 'Use image data [deprecated]',
'pdf_open_image_file' => 'Read image from file [deprecated]',
'pdf_open_jpeg' => 'Open JPEG image [deprecated]',
'pdf_open_memory_image' => 'Open image created with PHP\'s image functions [not supported]',
'pdf_open_pdi' => 'Open PDF file [deprecated]',
'pdf_open_pdi_document' => 'Prepare a pdi document',
'pdf_open_pdi_page' => 'Prepare a page',
'pdf_open_tiff' => 'Open TIFF image [deprecated]',
'pdf_pcos_get_number' => 'Get value of pCOS path with type number or boolean',
'pdf_pcos_get_stream' => 'Get contents of pCOS path with type stream, fstream, or string',
'pdf_pcos_get_string' => 'Get value of pCOS path with type name, string, or boolean',
'pdf_place_image' => 'Place image on the page [deprecated]',
'pdf_place_pdi_page' => 'Place PDF page [deprecated]',
'pdf_process_pdi' => 'Process imported PDF document',
'pdf_rect' => 'Draw rectangle',
'pdf_restore' => 'Restore graphics state',
'pdf_resume_page' => 'Resume page',
'pdf_rotate' => 'Rotate coordinate system',
'pdf_save' => 'Save graphics state',
'pdf_scale' => 'Scale coordinate system',
'pdf_set_border_color' => 'Set border color of annotations [deprecated]',
'pdf_set_border_dash' => 'Set border dash style of annotations [deprecated]',
'pdf_set_border_style' => 'Set border style of annotations [deprecated]',
'pdf_set_char_spacing' => 'Set character spacing [deprecated]',
'pdf_set_duration' => 'Set duration between pages [deprecated]',
'pdf_set_gstate' => 'Activate graphics state object',
'pdf_set_horiz_scaling' => 'Set horizontal text scaling [deprecated]',
'pdf_set_info' => 'Fill document info field',
'pdf_set_info_author' => 'Fill the author document info field [deprecated]',
'pdf_set_info_creator' => 'Fill the creator document info field [deprecated]',
'pdf_set_info_keywords' => 'Fill the keywords document info field [deprecated]',
'pdf_set_info_subject' => 'Fill the subject document info field [deprecated]',
'pdf_set_info_title' => 'Fill the title document info field [deprecated]',
'pdf_set_layer_dependency' => 'Define relationships among layers',
'pdf_set_leading' => 'Set distance between text lines [deprecated]',
'pdf_set_parameter' => 'Set string parameter',
'pdf_set_text_matrix' => 'Set text matrix [deprecated]',
'pdf_set_text_pos' => 'Set text position',
'pdf_set_text_rendering' => 'Determine text rendering [deprecated]',
'pdf_set_text_rise' => 'Set text rise [deprecated]',
'pdf_set_value' => 'Set numerical parameter',
'pdf_set_word_spacing' => 'Set spacing between words [deprecated]',
'pdf_setcolor' => 'Set fill and stroke color',
'pdf_setdash' => 'Set simple dash pattern',
'pdf_setdashpattern' => 'Set dash pattern',
'pdf_setflat' => 'Set flatness',
'pdf_setfont' => 'Set font',
'pdf_setgray' => 'Set color to gray [deprecated]',
'pdf_setgray_fill' => 'Set fill color to gray [deprecated]',
'pdf_setgray_stroke' => 'Set stroke color to gray [deprecated]',
'pdf_setlinecap' => 'Set linecap parameter',
'pdf_setlinejoin' => 'Set linejoin parameter',
'pdf_setlinewidth' => 'Set line width',
'pdf_setmatrix' => 'Set current transformation matrix',
'pdf_setmiterlimit' => 'Set miter limit',
'pdf_setpolydash' => 'Set complicated dash pattern [deprecated]',
'pdf_setrgbcolor' => 'Set fill and stroke rgb color values [deprecated]',
'pdf_setrgbcolor_fill' => 'Set fill rgb color values [deprecated]',
'pdf_setrgbcolor_stroke' => 'Set stroke rgb color values [deprecated]',
'pdf_shading' => 'Define blend',
'pdf_shading_pattern' => 'Define shading pattern',
'pdf_shfill' => 'Fill area with shading',
'pdf_show' => 'Output text at current position',
'pdf_show_boxed' => 'Output text in a box [deprecated]',
'pdf_show_xy' => 'Output text at given position',
'pdf_skew' => 'Skew the coordinate system',
'pdf_stringwidth' => 'Return width of text',
'pdf_stroke' => 'Stroke path',
'pdf_suspend_page' => 'Suspend page',
'pdf_translate' => 'Set origin of coordinate system',
'pdf_utf16_to_utf8' => 'Convert string from UTF-16 to UTF-8',
'pdf_utf32_to_utf16' => 'Convert string from UTF-32 to UTF-16',
'pdf_utf8_to_utf16' => 'Convert string from UTF-8 to UTF-16',
'PDFlib::activate_item' => 'Activates a previously created structure element or other content item.',
'PDFlib::add_launchlink' => 'Adds a link to a web resource.',
'PDFlib::add_locallink' => 'Add a link annotation to a target within the current PDF file.',
'PDFlib::add_nameddest' => 'Creates a named destination on an arbitrary page in the current document.',
'PDFlib::add_note' => 'Sets an annotation for the current page.',
'PDFlib::add_pdflink' => 'Add a file link annotation to a PDF target.',
'PDFlib::add_table_cell' => 'Adds a cell to a new or existing table.',
'PDFlib::add_textflow' => 'Creates a Textflow object, or adds text and explicit options to an existing Textflow.',
'PDFlib::add_thumbnail' => 'Adds an existing image as thumbnail for the current page.',
'PDFlib::add_weblink' => 'Adds a weblink annotation to a target url on the Web.',
'PDFlib::arc' => 'Adds a counterclockwise circular arc',
'PDFlib::arcn' => 'Except for the drawing direction, this function behaves exactly like PDF_arc().',
'PDFlib::attach_file' => 'Adds a file attachment annotation.',
'PDFlib::begin_document' => 'Creates a new PDF file subject to various options.',
'PDFlib::begin_font' => 'Starts a Type 3 font definition.',
'PDFlib::begin_glyph' => 'Starts a glyph definition for a Type 3 font.',
'PDFlib::begin_item' => 'Opens a structure element or other content item with attributes supplied as options.',
'PDFlib::begin_layer' => 'Starts a layer for subsequent output on the page.',
'PDFlib::begin_page' => 'Adds a new page to the document.',
'PDFlib::begin_page_ext' => 'Adds a new page to the document, and specifies various options. The parameters width and height are the dimensions of the new page in points.',
'PDFlib::begin_pattern' => 'Starts a new pattern definition.',
'PDFlib::begin_template_ext' => 'Starts a new template definition.',
'PDFlib::close_pdi_page' => 'Closes the page handle, and frees all page-related resources',
'PDO::__construct' => 'Creates a PDO instance representing a connection to a database',
'PDO::beginTransaction' => 'Initiates a transaction
<p>
Turns off autocommit mode. While autocommit mode is turned off,
changes made to the database via the PDO object instance are not committed
until you end the transaction by calling {@link PDO::commit()}.
Calling {@link PDO::rollBack()} will roll back all changes to the database and
return the connection to autocommit mode.
</p>
<p>
Some databases, including MySQL, automatically issue an implicit COMMIT
when a database definition language (DDL) statement
such as DROP TABLE or CREATE TABLE is issued within a transaction.
The implicit COMMIT will prevent you from rolling back any other changes
within the transaction boundary.
</p>',
'PDO::commit' => 'Commits a transaction',
'PDO::errorCode' => 'Fetch the SQLSTATE associated with the last operation on the database handle',
'PDO::errorInfo' => 'Fetch extended error information associated with the last operation on the database handle',
'PDO::exec' => 'Execute an SQL statement and return the number of affected rows',
'PDO::getAttribute' => 'Retrieve a database connection attribute',
'PDO::getAvailableDrivers' => 'Return an array of available PDO drivers',
'PDO::inTransaction' => 'Checks if inside a transaction',
'PDO::lastInsertId' => 'Returns the ID of the last inserted row or sequence value',
'PDO::prepare' => 'Prepares a statement for execution and returns a statement object',
'PDO::query' => 'Executes an SQL statement, returning a result set as a PDOStatement object',
'PDO::quote' => 'Quotes a string for use in a query.',
'PDO::rollBack' => 'Rolls back a transaction',
'PDO::setAttribute' => 'Set an attribute',
'PDO::sqliteCreateFunction' => 'Registers a User Defined Function for use in SQL statements',
'PDOException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'PDOException::__toString' => 'String representation of the exception',
'PDOException::getCode' => 'Gets the Exception code',
'PDOException::getFile' => 'Gets the file in which the exception occurred',
'PDOException::getLine' => 'Gets the line in which the exception occurred',
'PDOException::getMessage' => 'Gets the Exception message',
'PDOException::getPrevious' => 'Returns previous Exception',
'PDOException::getTrace' => 'Gets the stack trace',
'PDOException::getTraceAsString' => 'Gets the stack trace as a string',
'pdostatement::bindColumn' => 'Bind a column to a PHP variable',
'pdostatement::bindParam' => 'Binds a parameter to the specified variable name',
'pdostatement::bindValue' => 'Binds a value to a parameter',
'pdostatement::closeCursor' => 'Closes the cursor, enabling the statement to be executed again',
'pdostatement::columnCount' => 'Returns the number of columns in the result set',
'pdostatement::debugDumpParams' => 'Dump an SQL prepared command',
'pdostatement::errorCode' => 'Fetch the SQLSTATE associated with the last operation on the statement handle',
'pdostatement::errorInfo' => 'Fetch extended error information associated with the last operation on the statement handle',
'pdostatement::execute' => 'Executes a prepared statement',
'pdostatement::fetch' => 'Fetches the next row from a result set',
'pdostatement::fetchAll' => 'Returns an array containing all of the result set rows',
'pdostatement::fetchColumn' => 'Returns a single column from the next row of a result set',
'pdostatement::fetchObject' => 'Fetches the next row and returns it as an object',
'pdostatement::getAttribute' => 'Retrieve a statement attribute',
'pdostatement::getColumnMeta' => 'Returns metadata for a column in a result set',
'pdostatement::nextRowset' => 'Advances to the next rowset in a multi-rowset statement handle',
'pdostatement::rowCount' => 'Returns the number of rows affected by the last SQL statement',
'pdostatement::setAttribute' => 'Set a statement attribute',
'pdostatement::setFetchMode' => 'Set the default fetch mode for this statement',
'pfsockopen' => 'Open persistent Internet or Unix domain socket connection',
'pg_affected_rows' => 'Returns number of affected records (tuples)',
'pg_cancel_query' => 'Cancel an asynchronous query',
'pg_client_encoding' => 'Gets the client encoding',
'pg_close' => 'Closes a PostgreSQL connection',
'pg_connect' => 'Open a PostgreSQL connection',
'pg_connect_poll' => 'Poll the status of an in-progress asynchronous PostgreSQL connection attempt',
'pg_connection_busy' => 'Get connection is busy or not',
'pg_connection_reset' => 'Reset connection (reconnect)',
'pg_connection_status' => 'Get connection status',
'pg_consume_input' => 'Reads input on the connection',
'pg_convert' => 'Convert associative array values into forms suitable for SQL statements',
'pg_copy_from' => 'Insert records into a table from an array',
'pg_copy_to' => 'Copy a table to an array',
'pg_dbname' => 'Get the database name',
'pg_delete' => 'Deletes records',
'pg_end_copy' => 'Sync with PostgreSQL backend',
'pg_escape_bytea' => 'Escape a string for insertion into a bytea field',
'pg_escape_identifier' => 'Escape a identifier for insertion into a text field',
'pg_escape_literal' => 'Escape a literal for insertion into a text field',
'pg_escape_string' => 'Escape a string for query',
'pg_execute' => 'Sends a request to execute a prepared statement with given parameters, and waits for the result',
'pg_fetch_all' => 'Fetches all rows from a result as an array',
'pg_fetch_all_columns' => 'Fetches all rows in a particular result column as an array',
'pg_fetch_array' => 'Fetch a row as an array',
'pg_fetch_assoc' => 'Fetch a row as an associative array',
'pg_fetch_object' => 'Fetch a row as an object',
'pg_fetch_result' => 'Returns values from a result resource',
'pg_fetch_row' => 'Get a row as an enumerated array',
'pg_field_is_null' => 'Test if a field is SQL NULL',
'pg_field_name' => 'Returns the name of a field',
'pg_field_num' => 'Returns the field number of the named field',
'pg_field_prtlen' => 'Returns the printed length',
'pg_field_size' => 'Returns the internal storage size of the named field',
'pg_field_table' => 'Returns the name or oid of the tables field',
'pg_field_type' => 'Returns the type name for the corresponding field number',
'pg_field_type_oid' => 'Returns the type ID (OID) for the corresponding field number',
'pg_flush' => 'Flush outbound query data on the connection',
'pg_free_result' => 'Free result memory',
'pg_get_notify' => 'Gets SQL NOTIFY message',
'pg_get_pid' => 'Gets the backend\'s process ID',
'pg_get_result' => 'Get asynchronous query result',
'pg_host' => 'Returns the host name associated with the connection',
'pg_insert' => 'Insert array into table',
'pg_last_error' => 'Get the last error message string of a connection',
'pg_last_notice' => 'Returns the last notice message from PostgreSQL server',
'pg_last_oid' => 'Returns the last row\'s OID',
'pg_lo_close' => 'Close a large object',
'pg_lo_create' => 'Create a large object',
'pg_lo_export' => 'Export a large object to file',
'pg_lo_import' => 'Import a large object from file',
'pg_lo_open' => 'Open a large object',
'pg_lo_read' => 'Read a large object',
'pg_lo_read_all' => 'Reads an entire large object and send straight to browser',
'pg_lo_seek' => 'Seeks position within a large object',
'pg_lo_tell' => 'Returns current seek position a of large object',
'pg_lo_truncate' => 'Truncates a large object',
'pg_lo_unlink' => 'Delete a large object',
'pg_lo_write' => 'Write to a large object',
'pg_meta_data' => 'Get meta data for table',
'pg_num_fields' => 'Returns the number of fields in a result',
'pg_num_rows' => 'Returns the number of rows in a result',
'pg_options' => 'Get the options associated with the connection',
'pg_parameter_status' => 'Looks up a current parameter setting of the server',
'pg_pconnect' => 'Open a persistent PostgreSQL connection',
'pg_ping' => 'Ping database connection',
'pg_port' => 'Return the port number associated with the connection',
'pg_prepare' => 'Submits a request to create a prepared statement with the given parameters, and waits for completion',
'pg_put_line' => 'Send a NULL-terminated string to PostgreSQL backend',
'pg_query' => 'Execute a query',
'pg_query_params' => 'Submits a command to the server and waits for the result, with the ability to pass parameters separately from the SQL command text',
'pg_result_error' => 'Get error message associated with result',
'pg_result_error_field' => 'Returns an individual field of an error report',
'pg_result_seek' => 'Set internal row offset in result resource',
'pg_result_status' => 'Get status of query result',
'pg_select' => 'Select records',
'pg_send_execute' => 'Sends a request to execute a prepared statement with given parameters, without waiting for the result(s)',
'pg_send_prepare' => 'Sends a request to create a prepared statement with the given parameters, without waiting for completion',
'pg_send_query' => 'Sends asynchronous query',
'pg_send_query_params' => 'Submits a command and separate parameters to the server without waiting for the result(s)',
'pg_set_client_encoding' => 'Set the client encoding',
'pg_set_error_verbosity' => 'Determines the verbosity of messages returned by pg_last_error and pg_result_error',
'pg_socket' => 'Get a read only handle to the socket underlying a PostgreSQL connection',
'pg_trace' => 'Enable tracing a PostgreSQL connection',
'pg_transaction_status' => 'Returns the current in-transaction status of the server',
'pg_tty' => 'Return the TTY name associated with the connection',
'pg_unescape_bytea' => 'Unescape binary for bytea type',
'pg_untrace' => 'Disable tracing of a PostgreSQL connection',
'pg_update' => 'Update table',
'pg_version' => 'Returns an array with client, protocol and server version (when available)',
'Phan\Tests\Language\Internal\FunctionSignatureMapTest::realFunctionSignatureMapVersionProvider' => 'Provides values of PHP_VERSION_ID',
'Phar::__construct' => 'Construct a Phar archive object',
'Phar::__toString' => 'Get file name as a string',
'Phar::addEmptyDir' => 'Add an empty directory to the phar archive',
'Phar::addFile' => 'Add a file from the filesystem to the phar archive',
'Phar::addFromString' => 'Add a file from a string to the phar archive',
'Phar::apiVersion' => 'Returns the api version',
'Phar::buildFromDirectory' => 'Construct a phar archive from the files within a directory',
'Phar::buildFromIterator' => 'Construct a phar archive from an iterator',
'Phar::canCompress' => 'Returns whether phar extension supports compression using either zlib or bzip2',
'Phar::canWrite' => 'Returns whether phar extension supports writing and creating phars',
'Phar::compress' => 'Compresses the entire Phar archive using Gzip or Bzip2 compression',
'Phar::compressAllFilesBZIP2' => 'Compresses all files in the current Phar archive using Bzip2 compression',
'Phar::compressAllFilesGZ' => 'Compresses all files in the current Phar archive using Gzip compression',
'Phar::compressFiles' => 'Compresses all files in the current Phar archive',
'Phar::convertToData' => 'Convert a phar archive to a non-executable tar or zip file',
'Phar::convertToExecutable' => 'Convert a phar archive to another executable phar archive file format',
'Phar::copy' => 'Copy a file internal to the phar archive to another new file within the phar',
'Phar::count' => 'Returns the number of entries (files) in the Phar archive',
'Phar::createDefaultStub' => 'Create a phar-file format specific stub',
'Phar::current' => 'The current file',
'Phar::decompress' => 'Decompresses the entire Phar archive',
'Phar::decompressFiles' => 'Decompresses all files in the current Phar archive',
'Phar::delete' => 'Delete a file within a phar archive',
'Phar::delMetadata' => 'Deletes the global metadata of the phar',
'Phar::extractTo' => 'Extract the contents of a phar archive to a directory',
'Phar::getAlias' => 'Get the alias for Phar',
'Phar::getATime' => 'Gets last access time of the file',
'Phar::getBasename' => 'Get base name of current DirectoryIterator item',
'Phar::getChildren' => 'Returns an iterator for the current entry if it is a directory',
'Phar::getCTime' => 'Gets the inode change time',
'Phar::getExtension' => 'Gets the file extension',
'Phar::getFileInfo' => 'Gets an SplFileInfo object for the file',
'Phar::getFilename' => 'Return file name of current DirectoryIterator item',
'Phar::getFlags' => 'Get the handling flags',
'Phar::getGroup' => 'Gets the file group',
'Phar::getInode' => 'Gets the inode for the file',
'Phar::getLinkTarget' => 'Gets the target of a link',
'Phar::getMetadata' => 'Returns phar archive meta-data',
'Phar::getModified' => 'Return whether phar was modified',
'Phar::getMTime' => 'Gets the last modified time',
'Phar::getOwner' => 'Gets the owner of the file',
'Phar::getPath' => 'Get the real path to the Phar archive on disk',
'Phar::getPathInfo' => 'Gets an SplFileInfo object for the path',
'Phar::getPathname' => 'Gets the path to the file',
'Phar::getPerms' => 'Gets file permissions',
'Phar::getRealPath' => 'Gets absolute path to file',
'Phar::getSignature' => 'Return MD5/SHA1/SHA256/SHA512/OpenSSL signature of a Phar archive',
'Phar::getSize' => 'Gets file size',
'Phar::getStub' => 'Return the PHP loader or bootstrap stub of a Phar archive',
'Phar::getSubPath' => 'Get sub path',
'Phar::getSubPathname' => 'Get sub path and name',
'Phar::getSupportedCompression' => 'Return array of supported compression algorithms',
'Phar::getSupportedSignatures' => 'Return array of supported signature types',
'Phar::getType' => 'Gets file type',
'Phar::getVersion' => 'Return version info of Phar archive',
'Phar::hasChildren' => 'Returns whether current entry is a directory and not \'.\' or \'..\'',
'Phar::hasMetadata' => 'Returns whether phar has global meta-data',
'Phar::interceptFileFuncs' => 'Instructs phar to intercept fopen, file_get_contents, opendir, and all of the stat-related functions',
'Phar::isBuffering' => 'Used to determine whether Phar write operations are being buffered, or are flushing directly to disk',
'Phar::isCompressed' => 'Returns Phar::GZ or PHAR::BZ2 if the entire phar archive is compressed (.tar.gz/tar.bz and so on)',
'Phar::isDir' => 'Tells if the file is a directory',
'Phar::isDot' => 'Determine if current DirectoryIterator item is \'.\' or \'..\'',
'Phar::isExecutable' => 'Tells if the file is executable',
'Phar::isFile' => 'Tells if the object references a regular file',
'Phar::isFileFormat' => 'Returns true if the phar archive is based on the tar/phar/zip file format depending on the parameter',
'Phar::isLink' => 'Tells if the file is a link',
'Phar::isReadable' => 'Tells if file is readable',
'Phar::isValidPharFilename' => 'Returns whether the given filename is a valid phar filename',
'Phar::isWritable' => 'Returns true if the phar archive can be modified',
'Phar::key' => 'Retrieve the key for the current file',
'Phar::loadPhar' => 'Loads any phar archive with an alias',
'Phar::mapPhar' => 'Reads the currently executed file (a phar) and registers its manifest',
'Phar::mount' => 'Mount an external path or file to a virtual location within the phar archive',
'Phar::mungServer' => 'Defines a list of up to 4 $_SERVER variables that should be modified for execution',
'Phar::next' => 'Move to the next file',
'Phar::offsetExists' => 'Determines whether a file exists in the phar',
'Phar::offsetGet' => 'Gets a PharFileInfo object for a specific file',
'Phar::offsetSet' => 'Set the contents of an internal file to those of an external file',
'Phar::offsetUnset' => 'Remove a file from a phar',
'Phar::openFile' => 'Gets an SplFileObject object for the file',
'Phar::rewind' => 'Rewinds back to the beginning',
'Phar::running' => 'Returns the full path on disk or full phar URL to the currently executing Phar archive',
'Phar::seek' => 'Seek to a DirectoryIterator item',
'Phar::setAlias' => 'Set the alias for the Phar archive',
'Phar::setDefaultStub' => 'Used to set the PHP loader or bootstrap stub of a Phar archive to the default loader',
'Phar::setFileClass' => 'Sets the class used with SplFileInfo::openFile',
'Phar::setFlags' => 'Sets handling flags',
'Phar::setInfoClass' => 'Sets the class used with SplFileInfo::getFileInfo and SplFileInfo::getPathInfo',
'Phar::setMetadata' => 'Sets phar archive meta-data',
'Phar::setSignatureAlgorithm' => 'Set the signature algorithm for a phar and apply it',
'Phar::setStub' => 'Used to set the PHP loader or bootstrap stub of a Phar archive',
'Phar::startBuffering' => 'Start buffering Phar write operations, do not modify the Phar object on disk',
'Phar::stopBuffering' => 'Stop buffering write requests to the Phar archive, and save changes to disk',
'Phar::uncompressAllFiles' => 'Uncompresses all files in the current Phar archive',
'Phar::unlinkArchive' => 'Completely remove a phar archive from disk and from memory',
'Phar::valid' => 'Check whether current DirectoryIterator position is a valid file',
'Phar::webPhar' => 'mapPhar for web-based phars. front controller for web applications',
'PharData::__construct' => 'Construct a non-executable tar or zip archive object',
'PharData::__toString' => 'Get file name as a string',
'PharData::addEmptyDir' => 'Add an empty directory to the tar/zip archive',
'PharData::addFile' => 'Add a file from the filesystem to the tar/zip archive',
'PharData::addFromString' => 'Add a file from the filesystem to the tar/zip archive',
'PharData::apiVersion' => 'Returns the api version',
'PharData::buildFromDirectory' => 'Construct a tar/zip archive from the files within a directory',
'PharData::buildFromIterator' => 'Construct a tar or zip archive from an iterator',
'PharData::canCompress' => 'Returns whether phar extension supports compression using either zlib or bzip2',
'PharData::canWrite' => 'Returns whether phar extension supports writing and creating phars',
'PharData::compress' => 'Compresses the entire tar/zip archive using Gzip or Bzip2 compression',
'PharData::compressFiles' => 'Compresses all files in the current tar/zip archive',
'PharData::convertToData' => 'Convert a phar archive to a non-executable tar or zip file',
'PharData::convertToExecutable' => 'Convert a non-executable tar/zip archive to an executable phar archive',
'PharData::copy' => 'Copy a file internal to the phar archive to another new file within the phar',
'PharData::count' => 'Returns the number of entries (files) in the Phar archive',
'PharData::createDefaultStub' => 'Create a phar-file format specific stub',
'PharData::current' => 'The current file',
'PharData::decompress' => 'Decompresses the entire Phar archive',
'PharData::decompressFiles' => 'Decompresses all files in the current zip archive',
'PharData::delete' => 'Delete a file within a tar/zip archive',
'PharData::delMetadata' => 'Deletes the global metadata of a zip archive',
'PharData::extractTo' => 'Extract the contents of a tar/zip archive to a directory',
'PharData::getAlias' => 'Get the alias for Phar',
'PharData::getATime' => 'Gets last access time of the file',
'PharData::getBasename' => 'Get base name of current DirectoryIterator item',
'PharData::getChildren' => 'Returns an iterator for the current entry if it is a directory',
'PharData::getCTime' => 'Gets the inode change time',
'PharData::getExtension' => 'Gets the file extension',
'PharData::getFileInfo' => 'Gets an SplFileInfo object for the file',
'PharData::getFilename' => 'Return file name of current DirectoryIterator item',
'PharData::getFlags' => 'Get the handling flags',
'PharData::getGroup' => 'Gets the file group',
'PharData::getInode' => 'Gets the inode for the file',
'PharData::getLinkTarget' => 'Gets the target of a link',
'PharData::getMetadata' => 'Returns phar archive meta-data',
'PharData::getModified' => 'Return whether phar was modified',
'PharData::getMTime' => 'Gets the last modified time',
'PharData::getOwner' => 'Gets the owner of the file',
'PharData::getPath' => 'Get the real path to the Phar archive on disk',
'PharData::getPathInfo' => 'Gets an SplFileInfo object for the path',
'PharData::getPathname' => 'Gets the path to the file',
'PharData::getPerms' => 'Gets file permissions',
'PharData::getRealPath' => 'Gets absolute path to file',
'PharData::getSignature' => 'Return MD5/SHA1/SHA256/SHA512/OpenSSL signature of a Phar archive',
'PharData::getSize' => 'Gets file size',
'PharData::getStub' => 'Return the PHP loader or bootstrap stub of a Phar archive',
'PharData::getSubPath' => 'Get sub path',
'PharData::getSubPathname' => 'Get sub path and name',
'PharData::getSupportedCompression' => 'Return array of supported compression algorithms',
'PharData::getSupportedSignatures' => 'Return array of supported signature types',
'PharData::getType' => 'Gets file type',
'PharData::getVersion' => 'Return version info of Phar archive',
'PharData::hasChildren' => 'Returns whether current entry is a directory and not \'.\' or \'..\'',
'PharData::hasMetadata' => 'Returns whether phar has global meta-data',
'PharData::interceptFileFuncs' => 'Instructs phar to intercept fopen, file_get_contents, opendir, and all of the stat-related functions',
'PharData::isBuffering' => 'Used to determine whether Phar write operations are being buffered, or are flushing directly to disk',
'PharData::isCompressed' => 'Returns Phar::GZ or PHAR::BZ2 if the entire phar archive is compressed (.tar.gz/tar.bz and so on)',
'PharData::isDir' => 'Tells if the file is a directory',
'PharData::isDot' => 'Determine if current DirectoryIterator item is \'.\' or \'..\'',
'PharData::isExecutable' => 'Tells if the file is executable',
'PharData::isFile' => 'Tells if the object references a regular file',
'PharData::isFileFormat' => 'Returns true if the phar archive is based on the tar/phar/zip file format depending on the parameter',
'PharData::isLink' => 'Tells if the file is a link',
'PharData::isReadable' => 'Tells if file is readable',
'PharData::isValidPharFilename' => 'Returns whether the given filename is a valid phar filename',
'PharData::isWritable' => 'Returns true if the tar/zip archive can be modified',
'PharData::key' => 'Retrieve the key for the current file',
'PharData::loadPhar' => 'Loads any phar archive with an alias',
'PharData::mapPhar' => 'Reads the currently executed file (a phar) and registers its manifest',
'PharData::mount' => 'Mount an external path or file to a virtual location within the phar archive',
'PharData::mungServer' => 'Defines a list of up to 4 $_SERVER variables that should be modified for execution',
'PharData::next' => 'Move to the next file',
'PharData::offsetSet' => 'Set the contents of a file within the tar/zip to those of an external file or string',
'PharData::offsetUnset' => 'Remove a file from a tar/zip archive',
'PharData::openFile' => 'Gets an SplFileObject object for the file',
'PharData::rewind' => 'Rewinds back to the beginning',
'PharData::running' => 'Returns the full path on disk or full phar URL to the currently executing Phar archive',
'PharData::seek' => 'Seek to a DirectoryIterator item',
'PharData::setAlias' => 'Dummy function (Phar::setAlias is not valid for PharData)',
'PharData::setDefaultStub' => 'Dummy function (Phar::setDefaultStub is not valid for PharData)',
'PharData::setFileClass' => 'Sets the class used with SplFileInfo::openFile',
'PharData::setFlags' => 'Sets handling flags',
'PharData::setInfoClass' => 'Sets the class used with SplFileInfo::getFileInfo and SplFileInfo::getPathInfo',
'PharData::setMetadata' => 'Sets phar archive meta-data',
'PharData::setSignatureAlgorithm' => 'Set the signature algorithm for a phar and apply it',
'PharData::setStub' => 'Dummy function (Phar::setStub is not valid for PharData)',
'PharData::startBuffering' => 'Start buffering Phar write operations, do not modify the Phar object on disk',
'PharData::stopBuffering' => 'Stop buffering write requests to the Phar archive, and save changes to disk',
'PharData::unlinkArchive' => 'Completely remove a phar archive from disk and from memory',
'PharData::valid' => 'Check whether current DirectoryIterator position is a valid file',
'PharData::webPhar' => 'mapPhar for web-based phars. front controller for web applications',
'PharException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'PharException::__toString' => 'String representation of the exception',
'PharException::getCode' => 'Gets the Exception code',
'PharException::getFile' => 'Gets the file in which the exception occurred',
'PharException::getLine' => 'Gets the line in which the exception occurred',
'PharException::getMessage' => 'Gets the Exception message',
'PharException::getPrevious' => 'Returns previous Exception',
'PharException::getTrace' => 'Gets the stack trace',
'PharException::getTraceAsString' => 'Gets the stack trace as a string',
'pharfileinfo::__construct' => 'Construct a Phar entry object',
'PharFileInfo::__toString' => 'Returns the path to the file as a string',
'pharfileinfo::chmod' => 'Sets file-specific permission bits',
'pharfileinfo::compress' => 'Compresses the current Phar entry with either zlib or bzip2 compression',
'pharfileinfo::decompress' => 'Decompresses the current Phar entry within the phar',
'pharfileinfo::delMetadata' => 'Deletes the metadata of the entry',
'PharFileInfo::getATime' => 'Gets last access time of the file',
'PharFileInfo::getBasename' => 'Gets the base name of the file',
'pharfileinfo::getCompressedSize' => 'Returns the actual size of the file (with compression) inside the Phar archive',
'pharfileinfo::getContent' => 'Get the complete file contents of the entry',
'pharfileinfo::getCRC32' => 'Returns CRC32 code or throws an exception if CRC has not been verified',
'PharFileInfo::getCTime' => 'Gets the inode change time',
'PharFileInfo::getExtension' => 'Gets the file extension',
'PharFileInfo::getFileInfo' => 'Gets an SplFileInfo object for the file',
'PharFileInfo::getFilename' => 'Gets the filename',
'PharFileInfo::getGroup' => 'Gets the file group',
'PharFileInfo::getInode' => 'Gets the inode for the file',
'PharFileInfo::getLinkTarget' => 'Gets the target of a link',
'pharfileinfo::getMetadata' => 'Returns file-specific meta-data saved with a file',
'PharFileInfo::getMTime' => 'Gets the last modified time',
'PharFileInfo::getOwner' => 'Gets the owner of the file',
'PharFileInfo::getPath' => 'Gets the path without filename',
'PharFileInfo::getPathInfo' => 'Gets an SplFileInfo object for the path',
'PharFileInfo::getPathname' => 'Gets the path to the file',
'PharFileInfo::getPerms' => 'Gets file permissions',
'pharfileinfo::getPharFlags' => 'Returns the Phar file entry flags',
'PharFileInfo::getRealPath' => 'Gets absolute path to file',
'PharFileInfo::getSize' => 'Gets file size',
'PharFileInfo::getType' => 'Gets file type',
'pharfileinfo::hasMetadata' => 'Returns the metadata of the entry',
'pharfileinfo::isCompressed' => 'Returns whether the entry is compressed',
'pharfileinfo::isCompressedBZIP2' => 'Returns whether the entry is compressed using bzip2',
'pharfileinfo::isCompressedGZ' => 'Returns whether the entry is compressed using gz',
'pharfileinfo::isCRCChecked' => 'Returns whether file entry has had its CRC verified',
'PharFileInfo::isDir' => 'Tells if the file is a directory',
'PharFileInfo::isExecutable' => 'Tells if the file is executable',
'PharFileInfo::isFile' => 'Tells if the object references a regular file',
'PharFileInfo::isLink' => 'Tells if the file is a link',
'PharFileInfo::isReadable' => 'Tells if file is readable',
'PharFileInfo::isWritable' => 'Tells if the entry is writable',
'PharFileInfo::openFile' => 'Gets an SplFileObject object for the file',
'pharfileinfo::setCompressedBZIP2' => 'Compresses the current Phar entry within the phar using Bzip2 compression',
'pharfileinfo::setCompressedGZ' => 'Compresses the current Phar entry within the phar using gz compression',
'PharFileInfo::setFileClass' => 'Sets the class used with SplFileInfo::openFile',
'PharFileInfo::setInfoClass' => 'Sets the class used with SplFileInfo::getFileInfo and SplFileInfo::getPathInfo',
'pharfileinfo::setMetadata' => 'Sets file-specific meta-data saved with a file',
'pharfileinfo::setUncompressed' => 'Uncompresses the current Phar entry within the phar, if it is compressed',
'php_check_syntax' => 'Check the PHP syntax of (and execute) the specified file',
'php_ini_loaded_file' => 'Retrieve a path to the loaded php.ini file',
'php_ini_scanned_files' => 'Return a list of .ini files parsed from the additional ini dir',
'php_logo_guid' => 'Gets the logo guid',
'php_sapi_name' => 'Returns the type of interface between web server and PHP',
'php_strip_whitespace' => 'Return source with stripped comments and whitespace',
'php_uname' => 'Returns information about the operating system PHP is running on',
'php_user_filter::filter' => 'Called when applying the filter',
'php_user_filter::onClose' => 'Called when closing the filter',
'php_user_filter::onCreate' => 'Called when creating the filter',
'phpcredits' => 'Prints out the credits for PHP',
'phpdbg_break_file' => 'Inserts a breakpoint at a line in a file',
'phpdbg_break_function' => 'Inserts a breakpoint at entry to a function',
'phpdbg_break_method' => 'Inserts a breakpoint at entry to a method',
'phpdbg_break_next' => 'Inserts a breakpoint at the next opcode',
'phpdbg_clear' => 'Clears all breakpoints',
'phpdbg_color' => 'Sets the color of certain elements',
'phpdbg_exec' => 'Attempts to set the execution context',
'phpdbg_prompt' => 'Sets the command prompt',
'phpinfo' => 'Outputs information about PHP\'s configuration',
'phpversion' => 'Gets the current PHP version',
'pht\atomicinteger::__construct' => 'AtomicInteger creation',
'pht\atomicinteger::dec' => 'Decrements the atomic integer\'s value by one',
'pht\atomicinteger::get' => 'Gets the atomic integer\'s value',
'pht\atomicinteger::inc' => 'Increments the atomic integer\'s value by one',
'pht\atomicinteger::lock' => 'Acquires the atomic integer\'s mutex lock',
'pht\atomicinteger::set' => 'Sets the atomic integer\'s value',
'pht\atomicinteger::unlock' => 'Releases the atomic integer\'s mutex lock',
'pht\hashtable::lock' => 'Acquires the hash table\'s mutex lock',
'pht\hashtable::size' => 'Gets the size of the hash table',
'pht\hashtable::unlock' => 'Releases the hash table\'s mutex lock',
'pht\queue::front' => 'Returns the first value from a queue',
'pht\queue::lock' => 'Acquires the queue\'s mutex lock',
'pht\queue::pop' => 'Pops a value off of the front of a queue',
'pht\queue::push' => 'Pushes a value to the end of a queue',
'pht\queue::size' => 'Gets the size of the queue',
'pht\queue::unlock' => 'Releases the queue\'s mutex lock',
'pht\runnable::run' => 'The entry point of a threaded class',
'pht\thread::addClassTask' => 'Class threading',
'pht\thread::addFileTask' => 'File threading',
'pht\thread::addFunctionTask' => 'Function threading',
'pht\thread::join' => 'Joins a thread',
'pht\thread::start' => 'Starts the new thread',
'pht\thread::taskCount' => 'Gets a thread\'s task count',
'pht\threaded::lock' => 'Acquires the mutex lock',
'pht\threaded::unlock' => 'Releases the mutex lock',
'pht\vector::__construct' => 'Vector creation',
'pht\vector::deleteAt' => 'Deletes a value in the vector',
'pht\vector::insertAt' => 'Inserts a value into the vector',
'pht\vector::lock' => 'Acquires the vector\'s mutex lock',
'pht\vector::pop' => 'Pops a value to the vector',
'pht\vector::push' => 'Pushes a value to the vector',
'pht\vector::resize' => 'Resizes a vector',
'pht\vector::shift' => 'Shifts a value from the vector',
'pht\vector::size' => 'Gets the size of the vector',
'pht\vector::unlock' => 'Releases the vector\'s mutex lock',
'pht\vector::unshift' => 'Unshifts a value to the vector front',
'pht\vector::updateAt' => 'Updates a value in the vector',
'pi' => 'Get value of pi',
'png2wbmp' => 'Convert PNG image file to WBMP image file',
'pointObj::distanceToLine' => 'Calculates distance between a point ad a lined defined by the
two points passed in argument.',
'pointObj::distanceToPoint' => 'Calculates distance between two points.',
'pointObj::distanceToShape' => 'Calculates the minimum distance between a point and a shape.',
'pointObj::draw' => 'Draws the individual point using layer.  The class_index is used
to classify the point based on the classes defined for the layer.
The text string is used to annotate the point. (Optional)
Returns MS_SUCCESS/MS_FAILURE.',
'pointObj::ms_newPointObj' => 'Old style constructor',
'pointObj::project' => 'Project the point from "in" projection (1st argument) to "out"
projection (2nd argument).  Returns MS_SUCCESS/MS_FAILURE.',
'pointObj::setXY' => 'Set X,Y coordinate values.
.. note::
the 3rd parameter m is used for measured shape files only.
It is not mandatory.',
'pointObj::setXYZ' => 'Set X,Y,Z coordinate values.
.. note::
the 4th parameter m is used for measured shape files only.
It is not mandatory.',
'pool::__construct' => 'Creates a new Pool of Workers',
'pool::collect' => 'Collect references to completed tasks',
'pool::resize' => 'Resize the Pool',
'pool::shutdown' => 'Shutdown all workers',
'pool::submit' => 'Submits an object for execution',
'pool::submitTo' => 'Submits a task to a specific worker for execution',
'popen' => 'Opens process file pointer',
'pos' => 'Alias of current',
'posix_access' => 'Determine accessibility of a file',
'posix_ctermid' => 'Get path name of controlling terminal',
'posix_errno' => 'Alias of posix_get_last_error',
'posix_get_last_error' => 'Retrieve the error number set by the last posix function that failed',
'posix_getcwd' => 'Pathname of current directory',
'posix_getegid' => 'Return the effective group ID of the current process',
'posix_geteuid' => 'Return the effective user ID of the current process',
'posix_getgid' => 'Return the real group ID of the current process',
'posix_getgrgid' => 'Return info about a group by group id',
'posix_getgrnam' => 'Return info about a group by name',
'posix_getgroups' => 'Return the group set of the current process',
'posix_getlogin' => 'Return login name',
'posix_getpgid' => 'Get process group id for job control',
'posix_getpgrp' => 'Return the current process group identifier',
'posix_getpid' => 'Return the current process identifier',
'posix_getppid' => 'Return the parent process identifier',
'posix_getpwnam' => 'Return info about a user by username',
'posix_getpwuid' => 'Return info about a user by user id',
'posix_getrlimit' => 'Return info about system resource limits',
'posix_getsid' => 'Get the current sid of the process',
'posix_getuid' => 'Return the real user ID of the current process',
'posix_initgroups' => 'Calculate the group access list',
'posix_isatty' => 'Determine if a file descriptor is an interactive terminal',
'posix_kill' => 'Send a signal to a process',
'posix_mkfifo' => 'Create a fifo special file (a named pipe)',
'posix_mknod' => 'Create a special or ordinary file (POSIX.1)',
'posix_setegid' => 'Set the effective GID of the current process',
'posix_seteuid' => 'Set the effective UID of the current process',
'posix_setgid' => 'Set the GID of the current process',
'posix_setpgid' => 'Set process group id for job control',
'posix_setrlimit' => 'Set system resource limits',
'posix_setsid' => 'Make the current process a session leader',
'posix_setuid' => 'Set the UID of the current process',
'posix_strerror' => 'Retrieve the system error message associated with the given errno',
'posix_times' => 'Get process times',
'posix_ttyname' => 'Determine terminal device name',
'posix_uname' => 'Get system name',
'pow' => 'Exponential expression',
'preg_filter' => 'Perform a regular expression search and replace',
'preg_grep' => 'Return array entries that match the pattern',
'preg_last_error' => 'Returns the error code of the last PCRE regex execution',
'preg_match' => 'Perform a regular expression match',
'preg_match_all' => 'Perform a global regular expression match',
'preg_quote' => 'Quote regular expression characters',
'preg_replace' => 'Perform a regular expression search and replace',
'preg_replace_callback' => 'Perform a regular expression search and replace using a callback',
'preg_replace_callback_array' => 'Perform a regular expression search and replace using callbacks',
'preg_split' => 'Split string by a regular expression',
'prev' => 'Rewind the internal array pointer',
'print' => 'Output a string',
'print_r' => 'Prints human-readable information about a variable',
'printf' => 'Output a formatted string',
'proc_close' => 'Close a process opened by proc_open and return the exit code of that process',
'proc_get_status' => 'Get information about a process opened by proc_open',
'proc_nice' => 'Change the priority of the current process',
'proc_open' => 'Execute a command and open file pointers for input/output',
'proc_terminate' => 'Kills a process opened by proc_open',
'projectionObj::__construct' => 'Creates a projection object based on the projection string passed
as argument.
$projInObj = ms_newprojectionobj("proj=latlong")
will create a geographic projection class.
The following example will convert a lat/long point to an LCC
projection:
$projInObj = ms_newprojectionobj("proj=latlong");
$projOutObj = ms_newprojectionobj("proj=lcc,ellps=GRS80,lat_0=49,".
"lon_0=-95,lat_1=49,lat_2=77");
$poPoint = ms_newpointobj();
$poPoint->setXY(-92.0, 62.0);
$poPoint->project($projInObj, $projOutObj);',
'projectionObj::getUnits' => 'Returns the units of a projection object. Returns -1 on error.',
'projectionObj::ms_newProjectionObj' => 'Old style constructor',
'property_exists' => 'Checks if the object or class has a property',
'ps_add_bookmark' => 'Add bookmark to current page',
'ps_add_launchlink' => 'Adds link which launches file',
'ps_add_locallink' => 'Adds link to a page in the same document',
'ps_add_note' => 'Adds note to current page',
'ps_add_pdflink' => 'Adds link to a page in a second pdf document',
'ps_add_weblink' => 'Adds link to a web location',
'ps_arc' => 'Draws an arc counterclockwise',
'ps_arcn' => 'Draws an arc clockwise',
'ps_begin_page' => 'Start a new page',
'ps_begin_pattern' => 'Start a new pattern',
'ps_begin_template' => 'Start a new template',
'ps_circle' => 'Draws a circle',
'ps_clip' => 'Clips drawing to current path',
'ps_close' => 'Closes a PostScript document',
'ps_close_image' => 'Closes image and frees memory',
'ps_closepath' => 'Closes path',
'ps_closepath_stroke' => 'Closes and strokes path',
'ps_continue_text' => 'Continue text in next line',
'ps_curveto' => 'Draws a curve',
'ps_delete' => 'Deletes all resources of a PostScript document',
'ps_end_page' => 'End a page',
'ps_end_pattern' => 'End a pattern',
'ps_end_template' => 'End a template',
'ps_fill' => 'Fills the current path',
'ps_fill_stroke' => 'Fills and strokes the current path',
'ps_findfont' => 'Loads a font',
'ps_get_buffer' => 'Fetches the full buffer containing the generated PS data',
'ps_get_parameter' => 'Gets certain parameters',
'ps_get_value' => 'Gets certain values',
'ps_hyphenate' => 'Hyphenates a word',
'ps_include_file' => 'Reads an external file with raw PostScript code',
'ps_lineto' => 'Draws a line',
'ps_makespotcolor' => 'Create spot color',
'ps_moveto' => 'Sets current point',
'ps_new' => 'Creates a new PostScript document object',
'ps_open_file' => 'Opens a file for output',
'ps_open_image' => 'Reads an image for later placement',
'ps_open_image_file' => 'Opens image from file',
'ps_open_memory_image' => 'Takes an GD image and returns an image for placement in a PS document',
'ps_place_image' => 'Places image on the page',
'ps_rect' => 'Draws a rectangle',
'ps_restore' => 'Restore previously save context',
'ps_rotate' => 'Sets rotation factor',
'ps_save' => 'Save current context',
'ps_scale' => 'Sets scaling factor',
'ps_set_border_color' => 'Sets color of border for annotations',
'ps_set_border_dash' => 'Sets length of dashes for border of annotations',
'ps_set_border_style' => 'Sets border style of annotations',
'ps_set_info' => 'Sets information fields of document',
'ps_set_parameter' => 'Sets certain parameters',
'ps_set_text_pos' => 'Sets position for text output',
'ps_set_value' => 'Sets certain values',
'ps_setcolor' => 'Sets current color',
'ps_setdash' => 'Sets appearance of a dashed line',
'ps_setflat' => 'Sets flatness',
'ps_setfont' => 'Sets font to use for following output',
'ps_setgray' => 'Sets gray value',
'ps_setlinecap' => 'Sets appearance of line ends',
'ps_setlinejoin' => 'Sets how contected lines are joined',
'ps_setlinewidth' => 'Sets width of a line',
'ps_setmiterlimit' => 'Sets the miter limit',
'ps_setoverprintmode' => 'Sets overprint mode',
'ps_setpolydash' => 'Sets appearance of a dashed line',
'ps_shading' => 'Creates a shading for later use',
'ps_shading_pattern' => 'Creates a pattern based on a shading',
'ps_shfill' => 'Fills an area with a shading',
'ps_show' => 'Output text',
'ps_show2' => 'Output a text at current position',
'ps_show_boxed' => 'Output text in a box',
'ps_show_xy' => 'Output text at given position',
'ps_show_xy2' => 'Output text at position',
'ps_string_geometry' => 'Gets geometry of a string',
'ps_stringwidth' => 'Gets width of a string',
'ps_stroke' => 'Draws the current path',
'ps_symbol' => 'Output a glyph',
'ps_symbol_name' => 'Gets name of a glyph',
'ps_symbol_width' => 'Gets width of a glyph',
'ps_translate' => 'Sets translation',
'pspell_add_to_personal' => 'Add the word to a personal wordlist',
'pspell_add_to_session' => 'Add the word to the wordlist in the current session',
'pspell_check' => 'Check a word',
'pspell_clear_session' => 'Clear the current session',
'pspell_config_create' => 'Create a config used to open a dictionary',
'pspell_config_data_dir' => 'Location of language data files',
'pspell_config_dict_dir' => 'Location of the main word list',
'pspell_config_ignore' => 'Ignore words less than N characters long',
'pspell_config_mode' => 'Change the mode number of suggestions returned',
'pspell_config_personal' => 'Set a file that contains personal wordlist',
'pspell_config_repl' => 'Set a file that contains replacement pairs',
'pspell_config_runtogether' => 'Consider run-together words as valid compounds',
'pspell_config_save_repl' => 'Determine whether to save a replacement pairs list along with the wordlist',
'pspell_new' => 'Load a new dictionary',
'pspell_new_config' => 'Load a new dictionary with settings based on a given config',
'pspell_new_personal' => 'Load a new dictionary with personal wordlist',
'pspell_save_wordlist' => 'Save the personal wordlist to a file',
'pspell_store_replacement' => 'Store a replacement pair for a word',
'pspell_suggest' => 'Suggest spellings of a word',
'putenv' => 'Sets the value of an environment variable',
'px_close' => 'Closes a paradox database',
'px_create_fp' => 'Create a new paradox database',
'px_date2string' => 'Converts a date into a string',
'px_delete' => 'Deletes resource of paradox database',
'px_delete_record' => 'Deletes record from paradox database',
'px_get_field' => 'Returns the specification of a single field',
'px_get_info' => 'Return lots of information about a paradox file',
'px_get_parameter' => 'Gets a parameter',
'px_get_record' => 'Returns record of paradox database',
'px_get_schema' => 'Returns the database schema',
'px_get_value' => 'Gets a value',
'px_insert_record' => 'Inserts record into paradox database',
'px_new' => 'Create a new paradox object',
'px_numfields' => 'Returns number of fields in a database',
'px_numrecords' => 'Returns number of records in a database',
'px_open_fp' => 'Open paradox database',
'px_put_record' => 'Stores record into paradox database',
'px_retrieve_record' => 'Returns record of paradox database',
'px_set_blob_file' => 'Sets the file where blobs are read from',
'px_set_parameter' => 'Sets a parameter',
'px_set_tablename' => 'Sets the name of a table (deprecated)',
'px_set_targetencoding' => 'Sets the encoding for character fields (deprecated)',
'px_set_value' => 'Sets a value',
'px_timestamp2string' => 'Converts the timestamp into a string',
'px_update_record' => 'Updates record in paradox database',
'querymapObj::convertToString' => 'Saves the object to a string.  Provides the inverse option for
updateFromString.',
'querymapObj::free' => 'Free the object properties and break the internal references.
Note that you have to unset the php variable to free totally the resources.',
'querymapObj::set' => 'Set object property to a new value.',
'querymapObj::updateFromString' => 'Update a queryMap object from a string snippet. Returns
MS_SUCCESS/MS_FAILURE.',
'quickhashinthash::__construct' => 'Creates a new QuickHashIntHash object',
'quickhashinthash::add' => 'This method adds a new entry to the hash',
'quickhashinthash::delete' => 'This method deletes am entry from the hash',
'quickhashinthash::exists' => 'This method checks whether a key is part of the hash',
'quickhashinthash::get' => 'This method retrieves a value from the hash by its key',
'quickhashinthash::getSize' => 'Returns the number of elements in the hash',
'quickhashinthash::loadFromFile' => 'This factory method creates a hash from a file',
'quickhashinthash::loadFromString' => 'This factory method creates a hash from a string',
'quickhashinthash::saveToFile' => 'This method stores an in-memory hash to disk',
'quickhashinthash::saveToString' => 'This method returns a serialized version of the hash',
'quickhashinthash::set' => 'This method updates an entry in the hash with a new value, or adds a new one if the entry doesn\'t exist',
'quickhashinthash::update' => 'This method updates an entry in the hash with a new value',
'quickhashintset::__construct' => 'Creates a new QuickHashIntSet object',
'quickhashintset::add' => 'This method adds a new entry to the set',
'quickhashintset::delete' => 'This method deletes an entry from the set',
'quickhashintset::exists' => 'This method checks whether a key is part of the set',
'quickhashintset::getSize' => 'Returns the number of elements in the set',
'quickhashintset::loadFromFile' => 'This factory method creates a set from a file',
'quickhashintset::loadFromString' => 'This factory method creates a set from a string',
'quickhashintset::saveToFile' => 'This method stores an in-memory set to disk',
'quickhashintset::saveToString' => 'This method returns a serialized version of the set',
'quickhashintstringhash::__construct' => 'Creates a new QuickHashIntStringHash object',
'quickhashintstringhash::add' => 'This method adds a new entry to the hash',
'quickhashintstringhash::delete' => 'This method deletes am entry from the hash',
'quickhashintstringhash::exists' => 'This method checks whether a key is part of the hash',
'quickhashintstringhash::get' => 'This method retrieves a value from the hash by its key',
'quickhashintstringhash::getSize' => 'Returns the number of elements in the hash',
'quickhashintstringhash::loadFromFile' => 'This factory method creates a hash from a file',
'quickhashintstringhash::loadFromString' => 'This factory method creates a hash from a string',
'quickhashintstringhash::saveToFile' => 'This method stores an in-memory hash to disk',
'quickhashintstringhash::saveToString' => 'This method returns a serialized version of the hash',
'quickhashintstringhash::set' => 'This method updates an entry in the hash with a new value, or adds a new one if the entry doesn\'t exist',
'quickhashintstringhash::update' => 'This method updates an entry in the hash with a new value',
'quickhashstringinthash::__construct' => 'Creates a new QuickHashStringIntHash object',
'quickhashstringinthash::add' => 'This method adds a new entry to the hash',
'quickhashstringinthash::delete' => 'This method deletes am entry from the hash',
'quickhashstringinthash::exists' => 'This method checks whether a key is part of the hash',
'quickhashstringinthash::get' => 'This method retrieves a value from the hash by its key',
'quickhashstringinthash::getSize' => 'Returns the number of elements in the hash',
'quickhashstringinthash::loadFromFile' => 'This factory method creates a hash from a file',
'quickhashstringinthash::loadFromString' => 'This factory method creates a hash from a string',
'quickhashstringinthash::saveToFile' => 'This method stores an in-memory hash to disk',
'quickhashstringinthash::saveToString' => 'This method returns a serialized version of the hash',
'quickhashstringinthash::set' => 'This method updates an entry in the hash with a new value, or adds a new one if the entry doesn\'t exist',
'quickhashstringinthash::update' => 'This method updates an entry in the hash with a new value',
'quoted_printable_decode' => 'Convert a quoted-printable string to an 8 bit string',
'quoted_printable_encode' => 'Convert a 8 bit string to a quoted-printable string',
'quotemeta' => 'Quote meta characters',
'rad2deg' => 'Converts the radian number to the equivalent number in degrees',
'radius_acct_open' => 'Creates a Radius handle for accounting',
'radius_add_server' => 'Adds a server',
'radius_auth_open' => 'Creates a Radius handle for authentication',
'radius_close' => 'Frees all resources',
'radius_config' => 'Causes the library to read the given configuration file',
'radius_create_request' => 'Create accounting or authentication request',
'radius_cvt_addr' => 'Converts raw data to IP-Address',
'radius_cvt_int' => 'Converts raw data to integer',
'radius_cvt_string' => 'Converts raw data to string',
'radius_demangle' => 'Demangles data',
'radius_demangle_mppe_key' => 'Derives mppe-keys from mangled data',
'radius_get_attr' => 'Extracts an attribute',
'radius_get_tagged_attr_data' => 'Extracts the data from a tagged attribute',
'radius_get_tagged_attr_tag' => 'Extracts the tag from a tagged attribute',
'radius_get_vendor_attr' => 'Extracts a vendor specific attribute',
'radius_put_addr' => 'Attaches an IP address attribute',
'radius_put_attr' => 'Attaches a binary attribute',
'radius_put_int' => 'Attaches an integer attribute',
'radius_put_string' => 'Attaches a string attribute',
'radius_put_vendor_addr' => 'Attaches a vendor specific IP address attribute',
'radius_put_vendor_attr' => 'Attaches a vendor specific binary attribute',
'radius_put_vendor_int' => 'Attaches a vendor specific integer attribute',
'radius_put_vendor_string' => 'Attaches a vendor specific string attribute',
'radius_request_authenticator' => 'Returns the request authenticator',
'radius_salt_encrypt_attr' => 'Salt-encrypts a value',
'radius_send_request' => 'Sends the request and waits for a reply',
'radius_server_secret' => 'Returns the shared secret',
'radius_strerror' => 'Returns an error message',
'rand' => 'Generate a random integer',
'random_bytes' => 'Generates cryptographically secure pseudo-random bytes',
'random_int' => 'Generates cryptographically secure pseudo-random integers',
'range' => 'Create an array containing a range of elements',
'RangeException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'RangeException::__toString' => 'String representation of the exception',
'RangeException::getCode' => 'Gets the Exception code',
'RangeException::getFile' => 'Gets the file in which the exception occurred',
'RangeException::getLine' => 'Gets the line in which the exception occurred',
'RangeException::getMessage' => 'Gets the Exception message',
'RangeException::getPrevious' => 'Returns previous Exception',
'RangeException::getTrace' => 'Gets the stack trace',
'RangeException::getTraceAsString' => 'Gets the stack trace as a string',
'rar_wrapper_cache_stats' => 'Cache hits and misses for the URL wrapper',
'rararchive::__toString' => 'Get text representation',
'rararchive::close' => 'Close RAR archive and free all resources',
'rararchive::getComment' => 'Get comment text from the RAR archive',
'rararchive::getEntries' => 'Get full list of entries from the RAR archive',
'rararchive::getEntry' => 'Get entry object from the RAR archive',
'rararchive::isBroken' => 'Test whether an archive is broken (incomplete)',
'rararchive::isSolid' => 'Check whether the RAR archive is solid',
'rararchive::open' => 'Open RAR archive',
'rararchive::setAllowBroken' => 'Whether opening broken archives is allowed',
'rarentry::__toString' => 'Get text representation of entry',
'rarentry::extract' => 'Extract entry from the archive',
'rarentry::getAttr' => 'Get attributes of the entry',
'rarentry::getCrc' => 'Get CRC of the entry',
'rarentry::getFileTime' => 'Get entry last modification time',
'rarentry::getHostOs' => 'Get entry host OS',
'rarentry::getMethod' => 'Get pack method of the entry',
'rarentry::getName' => 'Get name of the entry',
'rarentry::getPackedSize' => 'Get packed size of the entry',
'rarentry::getStream' => 'Get file handler for entry',
'rarentry::getUnpackedSize' => 'Get unpacked size of the entry',
'rarentry::getVersion' => 'Get minimum version of RAR program required to unpack the entry',
'rarentry::isDirectory' => 'Test whether an entry represents a directory',
'rarentry::isEncrypted' => 'Test whether an entry is encrypted',
'RarException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'RarException::__construct' => 'Construct the exception. Note: The message is NOT binary safe.',
'RarException::__toString' => 'String representation of the exception',
'RarException::getCode' => 'Gets the Exception code',
'RarException::getFile' => 'Gets the file in which the exception occurred',
'RarException::getLine' => 'Gets the line in which the exception occurred',
'RarException::getMessage' => 'Gets the Exception message',
'RarException::getPrevious' => 'Returns previous Exception',
'RarException::getTrace' => 'Gets the stack trace',
'RarException::getTraceAsString' => 'Gets the stack trace as a string',
'rarexception::isUsingExceptions' => 'Check whether error handling with exceptions is in use',
'rarexception::setUsingExceptions' => 'Activate and deactivate error handling with exceptions',
'rawurldecode' => 'Decode URL-encoded strings',
'rawurlencode' => 'URL-encode according to RFC 3986',
'rd_kafka_get_err_descs' => 'Returns the full list of error codes.',
'rd_kafka_thread_cnt' => 'Retrieve the current number of threads in use by librdkafka.',
'read_exif_data' => 'Alias of exif_read_data',
'readdir' => 'Read entry from directory handle',
'readfile' => 'Outputs a file',
'readgzfile' => 'Output a gz-file',
'readline' => 'Reads a line',
'readline_add_history' => 'Adds a line to the history',
'readline_callback_handler_install' => 'Initializes the readline callback interface and terminal, prints the prompt and returns immediately',
'readline_callback_handler_remove' => 'Removes a previously installed callback handler and restores terminal settings',
'readline_callback_read_char' => 'Reads a character and informs the readline callback interface when a line is received',
'readline_clear_history' => 'Clears the history',
'readline_completion_function' => 'Registers a completion function',
'readline_info' => 'Gets/sets various internal readline variables',
'readline_list_history' => 'Lists the history',
'readline_on_new_line' => 'Inform readline that the cursor has moved to a new line',
'readline_read_history' => 'Reads the history',
'readline_redisplay' => 'Redraws the display',
'readline_write_history' => 'Writes the history',
'readlink' => 'Returns the target of a symbolic link',
'realpath' => 'Returns canonicalized absolute pathname',
'realpath_cache_get' => 'Get realpath cache entries',
'realpath_cache_size' => 'Get realpath cache size',
'recode' => 'Alias of recode_string',
'recode_file' => 'Recode from file to file according to recode request',
'recode_string' => 'Recode a string according to a recode request',
'rectObj::__construct' => '.. note:: the members (minx, miny, maxx ,maxy) are initialized to -1;',
'rectObj::draw' => 'Draws the individual rectangle using layer.  The class_index is used
to classify the rectangle based on the classes defined for the layer.
The text string is used to annotate the rectangle. (Optional)
Returns MS_SUCCESS/MS_FAILURE.',
'rectObj::fit' => 'Adjust extents of the rectangle to fit the width/height specified.',
'rectObj::ms_newRectObj' => 'Old style constructor',
'rectObj::project' => 'Project the rectangle from "in" projection (1st argument) to "out"
projection (2nd argument).  Returns MS_SUCCESS/MS_FAILURE.',
'rectObj::set' => 'Set object property to a new value.',
'rectObj::setextent' => 'Set the rectangle extents.',
'RecursiveArrayIterator::append' => 'Append an element',
'RecursiveArrayIterator::asort' => 'Sort array by values',
'RecursiveArrayIterator::count' => 'Count elements',
'RecursiveArrayIterator::current' => 'Return current array entry',
'RecursiveArrayIterator::getArrayCopy' => 'Get array copy',
'RecursiveArrayIterator::getChildren' => 'Returns an iterator for the current entry if it is an array or an object',
'RecursiveArrayIterator::getFlags' => 'Get behavior flags',
'RecursiveArrayIterator::hasChildren' => 'Returns whether current entry is an array or an object',
'RecursiveArrayIterator::key' => 'Return current array key',
'RecursiveArrayIterator::ksort' => 'Sort array by keys',
'RecursiveArrayIterator::natcasesort' => 'Sort an array naturally, case insensitive',
'RecursiveArrayIterator::natsort' => 'Sort an array naturally',
'RecursiveArrayIterator::next' => 'Move to next entry',
'RecursiveArrayIterator::offsetExists' => 'Check if offset exists',
'RecursiveArrayIterator::offsetGet' => 'Get value for an offset',
'RecursiveArrayIterator::offsetSet' => 'Set value for an offset',
'RecursiveArrayIterator::offsetUnset' => 'Unset value for an offset',
'RecursiveArrayIterator::rewind' => 'Rewind array back to the start',
'RecursiveArrayIterator::seek' => 'Seek to position',
'RecursiveArrayIterator::serialize' => 'Serialize',
'RecursiveArrayIterator::setFlags' => 'Set behaviour flags',
'RecursiveArrayIterator::uasort' => 'Sort with a user-defined comparison function and maintain index association',
'RecursiveArrayIterator::uksort' => 'Sort by keys using a user-defined comparison function',
'RecursiveArrayIterator::unserialize' => 'Unserialize',
'RecursiveArrayIterator::valid' => 'Check whether array contains more entries',
'RecursiveCachingIterator::__construct' => 'Construct',
'RecursiveCachingIterator::__toString' => 'Return the string representation of the current element',
'RecursiveCachingIterator::count' => 'The number of elements in the iterator',
'RecursiveCachingIterator::current' => 'Return the current element',
'RecursiveCachingIterator::getCache' => 'Retrieve the contents of the cache',
'RecursiveCachingIterator::getChildren' => 'Return the inner iterator\'s children as a RecursiveCachingIterator',
'RecursiveCachingIterator::getFlags' => 'Get flags used',
'RecursiveCachingIterator::getInnerIterator' => 'Returns the inner iterator',
'RecursiveCachingIterator::hasChildren' => 'Check whether the current element of the inner iterator has children',
'RecursiveCachingIterator::hasNext' => 'Check whether the inner iterator has a valid next element',
'RecursiveCachingIterator::key' => 'Return the key for the current element',
'RecursiveCachingIterator::next' => 'Move the iterator forward',
'RecursiveCachingIterator::offsetExists' => 'The offsetExists purpose',
'RecursiveCachingIterator::offsetGet' => 'The offsetGet purpose',
'RecursiveCachingIterator::offsetSet' => 'The offsetSet purpose',
'RecursiveCachingIterator::offsetUnset' => 'The offsetUnset purpose',
'RecursiveCachingIterator::rewind' => 'Rewind the iterator',
'RecursiveCachingIterator::setFlags' => 'The setFlags purpose',
'RecursiveCachingIterator::valid' => 'Check whether the current element is valid',
'RecursiveCallbackFilterIterator::__construct' => 'Create a RecursiveCallbackFilterIterator from a RecursiveIterator',
'RecursiveCallbackFilterIterator::accept' => 'Calls the callback with the current value, the current key and the inner iterator as arguments',
'RecursiveCallbackFilterIterator::current' => 'Get the current element value',
'RecursiveCallbackFilterIterator::getChildren' => 'Return the inner iterator\'s children contained in a RecursiveCallbackFilterIterator',
'RecursiveCallbackFilterIterator::getInnerIterator' => 'Get the inner iterator',
'RecursiveCallbackFilterIterator::hasChildren' => 'Check whether the inner iterator\'s current element has children',
'RecursiveCallbackFilterIterator::key' => 'Get the current key',
'RecursiveCallbackFilterIterator::next' => 'Move the iterator forward',
'RecursiveCallbackFilterIterator::rewind' => 'Rewind the iterator',
'RecursiveCallbackFilterIterator::valid' => 'Check whether the current element is valid',
'RecursiveDirectoryIterator::__construct' => 'Constructs a RecursiveDirectoryIterator',
'RecursiveDirectoryIterator::__toString' => 'Get file name as a string',
'RecursiveDirectoryIterator::current' => 'The current file',
'RecursiveDirectoryIterator::getATime' => 'Get last access time of the current DirectoryIterator item',
'RecursiveDirectoryIterator::getBasename' => 'Get base name of current DirectoryIterator item',
'RecursiveDirectoryIterator::getChildren' => 'Returns an iterator for the current entry if it is a directory',
'RecursiveDirectoryIterator::getCTime' => 'Get inode change time of the current DirectoryIterator item',
'RecursiveDirectoryIterator::getExtension' => 'Gets the file extension',
'RecursiveDirectoryIterator::getFileInfo' => 'Gets an SplFileInfo object for the file',
'RecursiveDirectoryIterator::getFilename' => 'Return file name of current DirectoryIterator item',
'RecursiveDirectoryIterator::getFlags' => 'Get the handling flags',
'RecursiveDirectoryIterator::getGroup' => 'Get group for the current DirectoryIterator item',
'RecursiveDirectoryIterator::getInode' => 'Get inode for the current DirectoryIterator item',
'RecursiveDirectoryIterator::getLinkTarget' => 'Gets the target of a link',
'RecursiveDirectoryIterator::getMTime' => 'Get last modification time of current DirectoryIterator item',
'RecursiveDirectoryIterator::getOwner' => 'Get owner of current DirectoryIterator item',
'RecursiveDirectoryIterator::getPath' => 'Get path of current Iterator item without filename',
'RecursiveDirectoryIterator::getPathInfo' => 'Gets an SplFileInfo object for the path',
'RecursiveDirectoryIterator::getPathname' => 'Return path and file name of current DirectoryIterator item',
'RecursiveDirectoryIterator::getPerms' => 'Get the permissions of current DirectoryIterator item',
'RecursiveDirectoryIterator::getRealPath' => 'Gets absolute path to file',
'RecursiveDirectoryIterator::getSize' => 'Get size of current DirectoryIterator item',
'RecursiveDirectoryIterator::getSubPath' => 'Get sub path',
'RecursiveDirectoryIterator::getSubPathname' => 'Get sub path and name',
'RecursiveDirectoryIterator::getType' => 'Determine the type of the current DirectoryIterator item',
'RecursiveDirectoryIterator::hasChildren' => 'Returns whether current entry is a directory and not \'.\' or \'..\'',
'RecursiveDirectoryIterator::isDir' => 'Determine if current DirectoryIterator item is a directory',
'RecursiveDirectoryIterator::isDot' => 'Determine if current DirectoryIterator item is \'.\' or \'..\'',
'RecursiveDirectoryIterator::isExecutable' => 'Determine if current DirectoryIterator item is executable',
'RecursiveDirectoryIterator::isFile' => 'Determine if current DirectoryIterator item is a regular file',
'RecursiveDirectoryIterator::isLink' => 'Determine if current DirectoryIterator item is a symbolic link',
'RecursiveDirectoryIterator::isReadable' => 'Determine if current DirectoryIterator item can be read',
'RecursiveDirectoryIterator::isWritable' => 'Determine if current DirectoryIterator item can be written to',
'RecursiveDirectoryIterator::key' => 'Return path and filename of current dir entry',
'RecursiveDirectoryIterator::next' => 'Move to next entry',
'RecursiveDirectoryIterator::openFile' => 'Gets an SplFileObject object for the file',
'RecursiveDirectoryIterator::rewind' => 'Rewind dir back to the start',
'RecursiveDirectoryIterator::seek' => 'Seek to a DirectoryIterator item',
'RecursiveDirectoryIterator::setFileClass' => 'Sets the class used with SplFileInfo::openFile',
'RecursiveDirectoryIterator::setFlags' => 'Sets handling flags',
'RecursiveDirectoryIterator::setInfoClass' => 'Sets the class used with SplFileInfo::getFileInfo and SplFileInfo::getPathInfo',
'RecursiveDirectoryIterator::valid' => 'Check whether current DirectoryIterator position is a valid file',
'RecursiveFilterIterator::__construct' => 'Create a RecursiveFilterIterator from a RecursiveIterator',
'RecursiveFilterIterator::accept' => 'Check whether the current element of the iterator is acceptable',
'RecursiveFilterIterator::current' => 'Get the current element value',
'RecursiveFilterIterator::getChildren' => 'Return the inner iterator\'s children contained in a RecursiveFilterIterator',
'RecursiveFilterIterator::getInnerIterator' => 'Get the inner iterator',
'RecursiveFilterIterator::hasChildren' => 'Check whether the inner iterator\'s current element has children',
'RecursiveFilterIterator::key' => 'Get the current key',
'RecursiveFilterIterator::next' => 'Move the iterator forward',
'RecursiveFilterIterator::rewind' => 'Rewind the iterator',
'RecursiveFilterIterator::valid' => 'Check whether the current element is valid',
'RecursiveIterator::current' => 'Return the current element',
'RecursiveIterator::getChildren' => 'Returns an iterator for the current entry',
'RecursiveIterator::hasChildren' => 'Returns if an iterator can be created for the current entry',
'RecursiveIterator::key' => 'Return the key of the current element',
'RecursiveIterator::next' => 'Move forward to next element',
'RecursiveIterator::rewind' => 'Rewind the Iterator to the first element',
'RecursiveIterator::valid' => 'Checks if current position is valid',
'RecursiveIteratorIterator::__construct' => 'Construct a RecursiveIteratorIterator',
'RecursiveIteratorIterator::beginChildren' => 'Begin children',
'RecursiveIteratorIterator::beginIteration' => 'Begin Iteration',
'RecursiveIteratorIterator::callGetChildren' => 'Get children',
'RecursiveIteratorIterator::callHasChildren' => 'Has children',
'RecursiveIteratorIterator::current' => 'Access the current element value',
'RecursiveIteratorIterator::endChildren' => 'End children',
'RecursiveIteratorIterator::endIteration' => 'End Iteration',
'RecursiveIteratorIterator::getDepth' => 'Get the current depth of the recursive iteration',
'RecursiveIteratorIterator::getInnerIterator' => 'Get inner iterator',
'RecursiveIteratorIterator::getMaxDepth' => 'Get max depth',
'RecursiveIteratorIterator::getSubIterator' => 'The current active sub iterator',
'RecursiveIteratorIterator::key' => 'Access the current key',
'RecursiveIteratorIterator::next' => 'Move forward to the next element',
'RecursiveIteratorIterator::nextElement' => 'Next element',
'RecursiveIteratorIterator::rewind' => 'Rewind the iterator to the first element of the top level inner iterator',
'RecursiveIteratorIterator::setMaxDepth' => 'Set max depth',
'RecursiveIteratorIterator::valid' => 'Check whether the current position is valid',
'RecursiveRegexIterator::__construct' => 'Creates a new RecursiveRegexIterator',
'RecursiveRegexIterator::accept' => 'Get accept status',
'RecursiveRegexIterator::current' => 'Get the current element value',
'RecursiveRegexIterator::getChildren' => 'Returns an iterator for the current entry',
'RecursiveRegexIterator::getFlags' => 'Get flags',
'RecursiveRegexIterator::getInnerIterator' => 'Get the inner iterator',
'RecursiveRegexIterator::getMode' => 'Returns operation mode',
'RecursiveRegexIterator::getPregFlags' => 'Returns the regular expression flags',
'RecursiveRegexIterator::getRegex' => 'Returns current regular expression',
'RecursiveRegexIterator::hasChildren' => 'Returns whether an iterator can be obtained for the current entry',
'RecursiveRegexIterator::key' => 'Get the current key',
'RecursiveRegexIterator::next' => 'Move the iterator forward',
'RecursiveRegexIterator::rewind' => 'Rewind the iterator',
'RecursiveRegexIterator::setFlags' => 'Sets the flags',
'RecursiveRegexIterator::setMode' => 'Sets the operation mode',
'RecursiveRegexIterator::setPregFlags' => 'Sets the regular expression flags',
'RecursiveRegexIterator::valid' => 'Check whether the current element is valid',
'RecursiveTreeIterator::__construct' => 'Construct a RecursiveTreeIterator',
'RecursiveTreeIterator::beginChildren' => 'Begin children',
'RecursiveTreeIterator::beginIteration' => 'Begin iteration',
'RecursiveTreeIterator::callGetChildren' => 'Get children',
'RecursiveTreeIterator::callHasChildren' => 'Has children',
'RecursiveTreeIterator::current' => 'Get current element',
'RecursiveTreeIterator::endChildren' => 'End children',
'RecursiveTreeIterator::endIteration' => 'End iteration',
'RecursiveTreeIterator::getDepth' => 'Get the current depth of the recursive iteration',
'RecursiveTreeIterator::getEntry' => 'Get current entry',
'RecursiveTreeIterator::getInnerIterator' => 'Get inner iterator',
'RecursiveTreeIterator::getMaxDepth' => 'Get max depth',
'RecursiveTreeIterator::getPostfix' => 'Get the postfix',
'RecursiveTreeIterator::getPrefix' => 'Get the prefix',
'RecursiveTreeIterator::getSubIterator' => 'The current active sub iterator',
'RecursiveTreeIterator::key' => 'Get the key of the current element',
'RecursiveTreeIterator::next' => 'Move to next element',
'RecursiveTreeIterator::nextElement' => 'Next element',
'RecursiveTreeIterator::rewind' => 'Rewind iterator',
'RecursiveTreeIterator::setMaxDepth' => 'Set max depth',
'RecursiveTreeIterator::setPostfix' => 'Set postfix',
'RecursiveTreeIterator::setPrefixPart' => 'Set a part of the prefix',
'RecursiveTreeIterator::valid' => 'Check validity',
'Redis::__construct' => 'Creates a Redis client',
'Redis::_prefix' => 'A utility method to prefix the value with the prefix setting for phpredis.',
'Redis::_serialize' => 'A utility method to serialize values manually. This method allows you to serialize a value with whatever
serializer is configured, manually. This can be useful for serialization/unserialization of data going in
and out of EVAL commands as phpredis can\'t automatically do this itself.  Note that if no serializer is
set, phpredis will change Array values to \'Array\', and Objects to \'Object\'.',
'Redis::_unserialize' => 'A utility method to unserialize data with whatever serializer is set up.  If there is no serializer set, the
value will be returned unchanged.  If there is a serializer set up, and the data passed in is malformed, an
exception will be thrown. This can be useful if phpredis is serializing values, and you return something from
redis in a LUA script that is serialized.',
'Redis::append' => 'Append specified string to the string stored in specified key.',
'Redis::auth' => 'Authenticate the connection using a password.
Warning: The password is sent in plain-text over the network.',
'Redis::bgrewriteaof' => 'Starts the background rewrite of AOF (Append-Only File)',
'Redis::bgsave' => 'Performs a background save.',
'Redis::bitCount' => 'Count bits in a string.',
'Redis::bitOp' => 'Bitwise operation on multiple keys.',
'Redis::bitpos' => 'Return the position of the first bit set to 1 or 0 in a string. The position is returned, thinking of the
string as an array of bits from left to right, where the first byte\'s most significant bit is at position 0,
the second byte\'s most significant bit is at position 8, and so forth.',
'Redis::blPop' => 'Is a blocking lPop primitive. If at least one of the lists contains at least one element,
the element will be popped from the head of the list and returned to the caller.
Il all the list identified by the keys passed in arguments are empty, blPop will block
during the specified timeout until an element is pushed to one of those lists. This element will be popped.',
'Redis::brPop' => 'Is a blocking rPop primitive. If at least one of the lists contains at least one element,
the element will be popped from the head of the list and returned to the caller.
Il all the list identified by the keys passed in arguments are empty, brPop will
block during the specified timeout until an element is pushed to one of those lists. T
his element will be popped.',
'Redis::brpoplpush' => 'A blocking version of rpoplpush, with an integral timeout in the third parameter.',
'Redis::bzPopMax' => 'Block until Redis can pop the highest or lowest scoring members from one or more ZSETs.
There are two commands (BZPOPMIN and BZPOPMAX for popping the lowest and highest scoring elements respectively.)',
'Redis::bzPopMin' => '`@return array` Either an array with the key member and score of the higest or lowest element or an empty array
if the timeout was reached without an element to pop.',
'Redis::clearLastError' => 'Clear the last error message',
'Redis::client' => 'Issue the CLIENT command with various arguments.',
'Redis::close' => 'Disconnects from the Redis instance, except when pconnect is used.',
'Redis::config' => 'Get or Set the redis config keys.',
'Redis::connect' => 'Connects to a Redis instance.',
'Redis::dbSize' => 'Returns the current database\'s size.',
'Redis::decr' => 'Decrement the number stored at key by one.',
'Redis::decrBy' => 'Decrement the number stored at key by one. If the second argument is filled, it will be used as the integer
value of the decrement.',
'Redis::del' => 'Remove specified keys.',
'Redis::delete' => '`@return  int`             Number of keys deleted.',
'Redis::dump' => 'Dump a key out of a redis database, the value of which can later be passed into redis using the RESTORE command.
The data that comes out of DUMP is a binary representation of the key as Redis stores it.',
'Redis::echo' => 'Echo the given string',
'Redis::eval' => 'Evaluate a LUA script serverside',
'Redis::evalSha' => 'Evaluate a LUA script serverside, from the SHA1 hash of the script instead of the script itself.
In order to run this command Redis will have to have already loaded the script, either by running it or via
the SCRIPT LOAD command.',
'Redis::evaluate' => '`@return mixed` @see eval()',
'Redis::exists' => 'Verify if the specified key/keys exists.',
'Redis::expire' => 'Sets an expiration date (a timeout) on an item.',
'Redis::expireAt' => 'Sets an expiration date (a timestamp) on an item.',
'Redis::flushAll' => 'Removes all entries from all databases.',
'Redis::flushDB' => 'Removes all entries from the current database.',
'Redis::geoadd' => 'Add one or more geospatial items to the specified key.
This function must be called with at least one longitude, latitude, member triplet.',
'Redis::geodist' => 'Return the distance between two members in a geospatial set.

If units are passed it must be one of the following values:
- \'m\' => Meters
- \'km\' => Kilometers
- \'mi\' => Miles
- \'ft\' => Feet',
'Redis::geohash' => 'Retrieve Geohash strings for one or more elements of a geospatial index.',
'Redis::geopos' => 'Return longitude, latitude positions for each requested member.',
'Redis::georadius' => 'Return members of a set with geospatial information that are within the radius specified by the caller.',
'Redis::georadiusbymember' => 'This method is identical to geoRadius except that instead of passing a longitude and latitude as the "source"
you pass an existing member in the geospatial set',
'Redis::get' => 'Get the value related to the specified key',
'Redis::getAuth' => 'Get the password used to authenticate the phpredis connection',
'Redis::getBit' => 'Return a single bit out of a larger string',
'Redis::getDbNum' => 'Get the database number phpredis is pointed to',
'Redis::getHost' => 'Retrieve our host or unix socket that we\'re connected to',
'Redis::getLastError' => 'The last error message (if any)',
'Redis::getMode' => 'Detect whether we\'re in ATOMIC/MULTI/PIPELINE mode.',
'Redis::getMultiple' => 'Get the values of all the specified keys. If one or more keys don\'t exist, the array will contain FALSE at the
position of the key.',
'Redis::getOption' => 'Get client option',
'Redis::getPersistentID' => 'Gets the persistent ID that phpredis is using',
'Redis::getPort' => 'Get the port we\'re connected to',
'Redis::getRange' => 'Return a substring of a larger string',
'Redis::getReadTimeout' => 'Get the read timeout specified to phpredis or FALSE if we\'re not connected',
'Redis::getSet' => 'Sets a value and returns the previous entry at that key.',
'Redis::getTimeout' => 'Get the (write) timeout in use for phpredis',
'Redis::hDel' => 'Removes a values from the hash stored at key.
If the hash table doesn\'t exist, or the key doesn\'t exist, FALSE is returned.',
'Redis::hExists' => 'Verify if the specified member exists in a key.',
'Redis::hGet' => 'Gets a value from the hash stored at key.
If the hash table doesn\'t exist, or the key doesn\'t exist, FALSE is returned.',
'Redis::hGetAll' => 'Returns the whole hash, as an array of strings indexed by strings.',
'Redis::hIncrBy' => 'Increments the value of a member from a hash by a given amount.',
'Redis::hIncrByFloat' => 'Increment the float value of a hash field by the given amount',
'Redis::hKeys' => 'Returns the keys in a hash, as an array of strings.',
'Redis::hLen' => 'Returns the length of a hash, in number of items',
'Redis::hMGet' => 'Retirieve the values associated to the specified fields in the hash.',
'Redis::hMSet' => 'Fills in a whole hash. Non-string values are converted to string, using the standard (string) cast.
NULL values are stored as empty strings',
'Redis::hScan' => 'Scan a HASH value for members, with an optional pattern and count.',
'Redis::hSet' => 'Adds a value to the hash stored at key. If this value is already in the hash, FALSE is returned.',
'Redis::hSetNx' => 'Adds a value to the hash stored at key only if this field isn\'t already in the hash.',
'Redis::hStrLen' => 'Get the string length of the value associated with field in the hash stored at key',
'Redis::hVals' => 'Returns the values in a hash, as an array of strings.',
'Redis::incr' => 'Increment the number stored at key by one.',
'Redis::incrBy' => 'Increment the number stored at key by one. If the second argument is filled, it will be used as the integer
value of the increment.',
'Redis::incrByFloat' => 'Increment the float value of a key by the given amount',
'Redis::info' => 'Returns an associative array of strings and integers',
'Redis::isConnected' => 'A method to determine if a phpredis object thinks it\'s connected to a server',
'Redis::keys' => 'Returns the keys that match a certain pattern.',
'Redis::lastSave' => 'Returns the timestamp of the last disk save.',
'Redis::lGet' => '`@return mixed|bool` the element at this index',
'Redis::lIndex' => 'Return the specified element of the list stored at the specified key.
0 the first element, 1 the second ... -1 the last element, -2 the penultimate ...
Return FALSE in case of a bad index or a key that doesn\'t point to a list.',
'Redis::lInsert' => 'Insert value in the list before or after the pivot value. the parameter options
specify the position of the insert (before or after). If the list didn\'t exists,
or the pivot didn\'t exists, the value is not inserted.',
'Redis::lLen' => 'Returns the size of a list identified by Key. If the list didn\'t exist or is empty,
the command returns 0. If the data type identified by Key is not a list, the command return FALSE.',
'Redis::lPop' => 'Returns and removes the first element of the list.',
'Redis::lPush' => 'Adds the string values to the head (left) of the list. Creates the list if the key didn\'t exist.
If the key exists and is not a list, FALSE is returned.',
'Redis::lPushx' => 'Adds the string value to the head (left) of the list if the list exists.',
'Redis::lRange' => 'Returns the specified elements of the list stored at the specified key in
the range [start, end]. start and stop are interpreted as indices: 0 the first element,
1 the second ... -1 the last element, -2 the penultimate ...',
'Redis::lRem' => 'Removes the first count occurrences of the value element from the list.
If count is zero, all the matching elements are removed. If count is negative,
elements are removed from tail to head.',
'Redis::lSet' => 'Set the list at index with the new value.',
'Redis::lSize' => '`@return  int`       The size of the list identified by Key exists.',
'Redis::lTrim' => 'Trims an existing list so that it will contain only a specified range of elements.',
'Redis::mget' => 'Returns the values of all specified keys.

For every key that does not hold a string value or does not exist,
the special value false is returned. Because of this, the operation never fails.',
'Redis::migrate' => 'Migrates a key to a different Redis instance.',
'Redis::move' => 'Moves a key to a different database.',
'Redis::mset' => 'Sets multiple key-value pairs in one atomic command.
MSETNX only returns TRUE if all the keys were set (see SETNX).',
'Redis::msetnx' => '`@return  int` 1 (if the keys were set) or 0 (no key was set)',
'Redis::multi' => 'Enter and exit transactional mode.',
'Redis::object' => 'Describes the object pointed to by a key.
The information to retrieve (string) and the key (string).
Info can be one of the following:
- "encoding"
- "refcount"
- "idletime"',
'Redis::open' => 'Connects to a Redis instance.',
'Redis::pconnect' => 'Connects to a Redis instance or reuse a connection already established with pconnect/popen.

The connection will not be closed on close or end of request until the php process ends.
So be patient on to many open FD\'s (specially on redis server side) when using persistent connections on
many servers connecting to one redis server.

Also more than one persistent connection can be made identified by either host + port + timeout
or host + persistent_id or unix socket + timeout.

This feature is not available in threaded versions. pconnect and popen then working like their non persistent
equivalents.',
'Redis::persist' => 'Remove the expiration timer from a key.',
'Redis::pExpire' => 'Sets an expiration date (a timeout in milliseconds) on an item.',
'Redis::pExpireAt' => 'Sets an expiration date (a timestamp) on an item. Requires a timestamp in milliseconds',
'Redis::pfAdd' => 'Adds all the element arguments to the HyperLogLog data structure stored at the key.',
'Redis::pfCount' => 'When called with a single key, returns the approximated cardinality computed by the HyperLogLog data
structure stored at the specified variable, which is 0 if the variable does not exist.',
'Redis::pfMerge' => 'Merge multiple HyperLogLog values into an unique value that will approximate the cardinality
of the union of the observed Sets of the source HyperLogLog structures.',
'Redis::ping' => 'Check the current connection status',
'Redis::psetex' => 'Set the string value in argument as value of the key, with a time to live.',
'Redis::psubscribe' => 'Subscribe to channels by pattern',
'Redis::pttl' => 'Returns a time to live left for a given key, in milliseconds.

If the key doesn\'t exist, FALSE is returned.',
'Redis::publish' => 'Publish messages to channels. Warning: this function will probably change in the future.',
'Redis::pubsub' => 'A command allowing you to get information on the Redis pub/sub system.',
'Redis::punsubscribe' => 'Stop listening for messages posted to the given channels.',
'Redis::randomKey' => 'Returns a random key.',
'Redis::rawCommand' => 'Send arbitrary things to the redis server.',
'Redis::rename' => 'Renames a key.',
'Redis::renameNx' => 'Renames a key.

Same as rename, but will not replace a key if the destination already exists.
This is the same behaviour as setNx.',
'Redis::resetStat' => 'Resets the statistics reported by Redis using the INFO command (`info()` function).
These are the counters that are reset:
     - Keyspace hits
     - Keyspace misses
     - Number of commands processed
     - Number of connections received
     - Number of expired keys',
'Redis::restore' => 'Restore a key from the result of a DUMP operation.',
'Redis::rPop' => 'Returns and removes the last element of the list.',
'Redis::rpoplpush' => 'Pops a value from the tail of a list, and pushes it to the front of another list.
Also return this value.',
'Redis::rPush' => 'Adds the string values to the tail (right) of the list. Creates the list if the key didn\'t exist.
If the key exists and is not a list, FALSE is returned.',
'Redis::rPushx' => 'Adds the string value to the tail (right) of the list if the list exists. FALSE in case of Failure.',
'Redis::sAdd' => 'Adds a values to the set value stored at key.
If this value is already in the set, FALSE is returned.',
'Redis::sAddArray' => 'Adds a values to the set value stored at key.',
'Redis::save' => 'Performs a synchronous save.',
'Redis::scan' => 'Scan the keyspace for keys.',
'Redis::sCard' => 'Returns the cardinality of the set identified by key.',
'Redis::script' => 'Execute the Redis SCRIPT command to perform various operations on the scripting subsystem.',
'Redis::sDiff' => 'Performs the difference between N sets and returns it.',
'Redis::sDiffStore' => 'Performs the same action as sDiff, but stores the result in the first key',
'Redis::select' => 'Switches to a given database.',
'Redis::set' => 'Set the string value in argument as value of the key.',
'Redis::setBit' => 'Changes a single bit of a string.',
'Redis::setex' => 'Set the string value in argument as value of the key, with a time to live.',
'Redis::setnx' => 'Set the string value in argument as value of the key if the key doesn\'t already exist in the database.',
'Redis::setOption' => 'Set client option.',
'Redis::setRange' => 'Changes a substring of a larger string.',
'Redis::sGetMembers' => 'An array of elements, the contents of the set',
'Redis::sInter' => 'Returns the members of a set resulting from the intersection of all the sets
held at the specified keys. If just a single key is specified, then this command
produces the members of this set. If one of the keys is missing, FALSE is returned.',
'Redis::sInterStore' => 'Performs a sInter command and stores the result in a new set.',
'Redis::sIsMember' => 'Checks if value is a member of the set stored at the key key.',
'Redis::slaveof' => 'Changes the slave status
Either host and port, or no parameter to stop being a slave.',
'Redis::slowlog' => 'Access the Redis slow log.',
'Redis::sMembers' => 'Returns the contents of a set.',
'Redis::sMove' => 'Moves the specified member from the set at srcKey to the set at dstKey.',
'Redis::sort' => 'Sort',
'Redis::sPop' => 'Removes and returns a random element from the set value at Key.',
'Redis::sRandMember' => 'Returns a random element(s) from the set value at Key, without removing it.',
'Redis::sRem' => 'Removes the specified members from the set value stored at key.',
'Redis::sScan' => 'Scan a set for members.',
'Redis::strlen' => 'Get the length of a string value.',
'Redis::subscribe' => 'Subscribe to channels. Warning: this function will probably change in the future.',
'Redis::substr' => 'Return a substring of a larger string',
'Redis::sUnion' => 'Performs the union between N sets and returns it.',
'Redis::sUnionStore' => 'Performs the same action as sUnion, but stores the result in the first key',
'Redis::swapdb' => 'Swap one Redis database with another atomically

Note: Requires Redis >= 4.0.0',
'Redis::time' => 'Return the current Redis server time.',
'Redis::ttl' => 'Returns the time to live left for a given key, in seconds. If the key doesn\'t exist, FALSE is returned.',
'Redis::type' => 'Returns the type of data pointed by a given key.',
'Redis::unlink' => 'Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.',
'Redis::unsubscribe' => 'Stop listening for messages posted to the given channels.',
'Redis::wait' => 'Blocks the current client until all the previous write commands are successfully transferred and
acknowledged by at least the specified number of slaves.',
'Redis::watch' => 'Watches a key for modifications by another client. If the key is modified between WATCH and EXEC,
the MULTI/EXEC transaction will fail (return FALSE). unwatch cancels all the watching of all keys by this client.',
'Redis::xAck' => 'Acknowledge one or more messages on behalf of a consumer group.',
'Redis::xAdd' => 'Add a message to a stream.',
'Redis::xClaim' => 'Claim ownership of one or more pending messages.',
'Redis::xDel' => 'Delete one or more messages from a stream.',
'Redis::xGroup' => '`@return  mixed`   This command returns different types depending on the specific XGROUP command executed.',
'Redis::xInfo' => 'Get information about a stream or consumer groups.',
'Redis::xLen' => 'Get the length of a given stream.',
'Redis::xPending' => 'Get information about pending messages in a given stream.',
'Redis::xRange' => 'Get a range of messages from a given stream.',
'Redis::xRead' => 'Read data from one or more streams and only return IDs greater than sent in the command.',
'Redis::xReadGroup' => 'This method is similar to xRead except that it supports reading messages for a specific consumer group.',
'Redis::xRevRange' => 'This is identical to xRange except the results come back in reverse order. Also note that Redis reverses the order of "start" and "end".',
'Redis::xTrim' => 'Trim the stream length to a given maximum. If the "approximate" flag is pasesed, Redis will use your size as a hint but only trim trees in whole nodes (this is more efficient)..',
'Redis::zAdd' => 'Adds the specified member with a given score to the sorted set stored at key.',
'Redis::zCard' => 'Returns the cardinality of an ordered set.',
'Redis::zCount' => 'Returns the number of elements of the sorted set stored at the specified key which have
scores in the range [start,end]. Adding a parenthesis before start or end excludes it
from the range. +inf and -inf are also valid limits.',
'Redis::zDelete' => '`@return  int`     Number of deleted values',
'Redis::zIncrBy' => 'Increments the score of a member from a sorted set by a given amount.',
'Redis::zInter' => 'Creates an intersection of sorted sets given in second argument.
The result of the union will be stored in the sorted set defined by the first argument.
The third optional argument defines weights to apply to the sorted sets in input.
In this case, the weights will be multiplied by the score of each element in the sorted set
before applying the aggregation. The forth argument defines the AGGREGATE option which
specify how the results of the union are aggregated.',
'Redis::zInterStore' => 'Creates an intersection of sorted sets given in second argument.
The result of the union will be stored in the sorted set defined by the first argument.
The third optional argument defines weights to apply to the sorted sets in input.
In this case, the weights will be multiplied by the score of each element in the sorted set
before applying the aggregation. The forth argument defines the AGGREGATE option which
specify how the results of the union are aggregated.',
'Redis::zPopMax' => 'Can pop the highest scoring members from one ZSET.',
'Redis::zPopMin' => 'Can pop the lowest scoring members from one ZSET.',
'Redis::zRange' => 'Returns a range of elements from the ordered set stored at the specified key,
with values in the range [start, end]. start and stop are interpreted as zero-based indices:
0 the first element,
1 the second ...
-1 the last element,
-2 the penultimate ...',
'Redis::zRangeByLex' => 'Returns a lexigraphical range of members in a sorted set, assuming the members have the same score. The
min and max values are required to start with \'(\' (exclusive), \'[\' (inclusive), or be exactly the values
\'-\' (negative inf) or \'+\' (positive inf).  The command must be called with either three *or* five
arguments or will return FALSE.',
'Redis::zRangeByScore' => 'Returns the elements of the sorted set stored at the specified key which have scores in the
range [start,end]. Adding a parenthesis before start or end excludes it from the range.
+inf and -inf are also valid limits.

zRevRangeByScore returns the same items in reverse order, when the start and end parameters are swapped.',
'Redis::zRank' => 'Returns the rank of a given member in the specified sorted set, starting at 0 for the item
with the smallest score. zRevRank starts at 0 for the item with the largest score.',
'Redis::zRem' => 'Deletes a specified member from the ordered set.',
'Redis::zRemRangeByRank' => 'Deletes the elements of the sorted set stored at the specified key which have rank in the range [start,end].',
'Redis::zRemRangeByScore' => 'Deletes the elements of the sorted set stored at the specified key which have scores in the range [start,end].',
'Redis::zRevRange' => 'Returns the elements of the sorted set stored at the specified key in the range [start, end]
in reverse order. start and stop are interpreted as zero-based indices:
0 the first element,
1 the second ...
-1 the last element,
-2 the penultimate ...',
'Redis::zRevRank' => '`@return int`    the item\'s score',
'Redis::zScan' => 'Scan a sorted set for members, with optional pattern and count.',
'Redis::zScore' => 'Returns the score of a given member in the specified sorted set.',
'Redis::zUnion' => 'Creates an union of sorted sets given in second argument.
The result of the union will be stored in the sorted set defined by the first argument.
The third optionnel argument defines weights to apply to the sorted sets in input.
In this case, the weights will be multiplied by the score of each element in the sorted set
before applying the aggregation. The forth argument defines the AGGREGATE option which
specify how the results of the union are aggregated.',
'Redis::zUnionStore' => 'Creates an union of sorted sets given in second argument.
The result of the union will be stored in the sorted set defined by the first argument.
The third optionnel argument defines weights to apply to the sorted sets in input.
In this case, the weights will be multiplied by the score of each element in the sorted set
before applying the aggregation. The forth argument defines the AGGREGATE option which
specify how the results of the union are aggregated.',
'RedisArray::__construct' => 'Constructor',
'RedisArray::_function' => '`@return  string`  the name of the function used to extract key parts during consistent hashing',
'RedisArray::_hosts' => '`@return  array`   list of hosts for the selected array',
'RedisArray::_prefix' => 'A utility method to prefix the value with the prefix setting for phpredis.',
'RedisArray::_rehash' => 'Use this function when a new node is added and keys need to be rehashed.',
'RedisArray::_serialize' => 'A utility method to serialize values manually. This method allows you to serialize a value with whatever
serializer is configured, manually. This can be useful for serialization/unserialization of data going in
and out of EVAL commands as phpredis can\'t automatically do this itself.  Note that if no serializer is
set, phpredis will change Array values to \'Array\', and Objects to \'Object\'.',
'RedisArray::_target' => '`@return  string`  the host to be used for a certain key',
'RedisArray::_unserialize' => 'A utility method to unserialize data with whatever serializer is set up.  If there is no serializer set, the
value will be returned unchanged.  If there is a serializer set up, and the data passed in is malformed, an
exception will be thrown. This can be useful if phpredis is serializing values, and you return something from
redis in a LUA script that is serialized.',
'RedisArray::append' => 'Append specified string to the string stored in specified key.',
'RedisArray::auth' => 'Authenticate the connection using a password.
Warning: The password is sent in plain-text over the network.',
'RedisArray::bgrewriteaof' => 'Starts the background rewrite of AOF (Append-Only File)',
'RedisArray::bgsave' => 'Performs a background save.',
'RedisArray::bitCount' => 'Count bits in a string',
'RedisArray::bitOp' => 'Bitwise operation on multiple keys.',
'RedisArray::bitpos' => 'Return the position of the first bit set to 1 or 0 in a string. The position is returned, thinking of the
string as an array of bits from left to right, where the first byte\'s most significant bit is at position 0,
the second byte\'s most significant bit is at position 8, and so forth.',
'RedisArray::blPop' => 'Is a blocking lPop primitive. If at least one of the lists contains at least one element,
the element will be popped from the head of the list and returned to the caller.
Il all the list identified by the keys passed in arguments are empty, blPop will block
during the specified timeout until an element is pushed to one of those lists. This element will be popped.',
'RedisArray::brPop' => 'Is a blocking rPop primitive. If at least one of the lists contains at least one element,
the element will be popped from the head of the list and returned to the caller.
Il all the list identified by the keys passed in arguments are empty, brPop will
block during the specified timeout until an element is pushed to one of those lists. T
his element will be popped.',
'RedisArray::brpoplpush' => 'A blocking version of rpoplpush, with an integral timeout in the third parameter.',
'RedisArray::bzPopMax' => 'Block until Redis can pop the highest or lowest scoring members from one or more ZSETs.
There are two commands (BZPOPMIN and BZPOPMAX for popping the lowest and highest scoring elements respectively.)',
'RedisArray::bzPopMin' => '`@return array` Either an array with the key member and score of the higest or lowest element or an empty array
if the timeout was reached without an element to pop.',
'RedisArray::clearLastError' => 'Clear the last error message',
'RedisArray::client' => 'Issue the CLIENT command with various arguments.
The Redis CLIENT command can be used in four ways:
- CLIENT LIST
- CLIENT GETNAME
- CLIENT SETNAME [name]
- CLIENT KILL [ip:port]',
'RedisArray::close' => 'Disconnects from the Redis instance.

Note: Closing a persistent connection requires PhpRedis >= 4.2.0',
'RedisArray::config' => 'Get or Set the redis config keys.',
'RedisArray::connect' => 'Connects to a Redis instance.',
'RedisArray::dbSize' => 'Returns the current database\'s size',
'RedisArray::decr' => 'Decrement the number stored at key by one.',
'RedisArray::decrBy' => 'Decrement the number stored at key by one.
If the second argument is filled, it will be used as the integer value of the decrement.',
'RedisArray::del' => 'Remove specified keys.',
'RedisArray::delete' => '`@return int` Number of keys deleted',
'RedisArray::dump' => 'Dump a key out of a redis database, the value of which can later be passed into redis using the RESTORE command.
The data that comes out of DUMP is a binary representation of the key as Redis stores it.',
'RedisArray::echo' => 'Echo the given string',
'RedisArray::eval' => 'Evaluate a LUA script serverside',
'RedisArray::evalSha' => 'Evaluate a LUA script serverside, from the SHA1 hash of the script instead of the script itself.
In order to run this command Redis will have to have already loaded the script, either by running it or via
the SCRIPT LOAD command.',
'RedisArray::evaluate' => '`@return  mixed`   @see eval()',
'RedisArray::exists' => 'Verify if the specified key/keys exists

This function took a single argument and returned TRUE or FALSE in phpredis versions < 4.0.0.',
'RedisArray::expire' => 'Sets an expiration date (a timeout) on an item',
'RedisArray::expireAt' => 'Sets an expiration date (a timestamp) on an item.',
'RedisArray::flushAll' => 'Removes all entries from all databases.',
'RedisArray::flushDB' => 'Removes all entries from the current database.',
'RedisArray::geoadd' => 'Add one or more geospatial items to the specified key.
This function must be called with at least one longitude, latitude, member triplet.',
'RedisArray::geodist' => 'Return the distance between two members in a geospatial set.

If units are passed it must be one of the following values:
- \'m\' => Meters
- \'km\' => Kilometers
- \'mi\' => Miles
- \'ft\' => Feet',
'RedisArray::geohash' => 'Retrieve Geohash strings for one or more elements of a geospatial index.',
'RedisArray::geopos' => 'Return longitude, latitude positions for each requested member.',
'RedisArray::georadius' => 'Return members of a set with geospatial information that are within the radius specified by the caller.',
'RedisArray::georadiusbymember' => 'This method is identical to geoRadius except that instead of passing a longitude and latitude as the "source"
you pass an existing member in the geospatial set',
'RedisArray::get' => 'Get the value related to the specified key',
'RedisArray::getAuth' => 'Get the password used to authenticate the phpredis connection',
'RedisArray::getBit' => 'Return a single bit out of a larger string',
'RedisArray::getDbNum' => 'Get the database number phpredis is pointed to',
'RedisArray::getHost' => 'Retrieve our host or unix socket that we\'re connected to',
'RedisArray::getLastError' => 'The last error message (if any)',
'RedisArray::getMode' => 'Detect whether we\'re in ATOMIC/MULTI/PIPELINE mode.',
'RedisArray::getMultiple' => 'Get the values of all the specified keys.
If one or more keys dont exist, the array will contain FALSE at the position of the key.',
'RedisArray::getOption' => 'Get client option',
'RedisArray::getPersistentID' => 'Gets the persistent ID that phpredis is using',
'RedisArray::getPort' => 'Get the port we\'re connected to',
'RedisArray::getRange' => 'Return a substring of a larger string',
'RedisArray::getReadTimeout' => 'Get the read timeout specified to phpredis or FALSE if we\'re not connected',
'RedisArray::getSet' => 'Sets a value and returns the previous entry at that key.',
'RedisArray::getTimeout' => 'Get the (write) timeout in use for phpredis',
'RedisArray::hDel' => 'Removes a values from the hash stored at key.
If the hash table doesn\'t exist, or the key doesn\'t exist, FALSE is returned.',
'RedisArray::hExists' => 'Verify if the specified member exists in a key.',
'RedisArray::hGet' => 'Gets a value from the hash stored at key.
If the hash table doesn\'t exist, or the key doesn\'t exist, FALSE is returned.',
'RedisArray::hGetAll' => 'Returns the whole hash, as an array of strings indexed by strings.',
'RedisArray::hIncrBy' => 'Increments the value of a member from a hash by a given amount.',
'RedisArray::hIncrByFloat' => 'Increment the float value of a hash field by the given amount',
'RedisArray::hKeys' => 'Returns the keys in a hash, as an array of strings.',
'RedisArray::hLen' => 'Returns the length of a hash, in number of items',
'RedisArray::hMGet' => 'Retirieve the values associated to the specified fields in the hash.',
'RedisArray::hMSet' => 'Fills in a whole hash. Non-string values are converted to string, using the standard (string) cast.
NULL values are stored as empty strings',
'RedisArray::hScan' => 'Scan a HASH value for members, with an optional pattern and count.',
'RedisArray::hSet' => 'Adds a value to the hash stored at key. If this value is already in the hash, FALSE is returned.',
'RedisArray::hSetNx' => 'Adds a value to the hash stored at key only if this field isn\'t already in the hash.',
'RedisArray::hStrLen' => 'Get the string length of the value associated with field in the hash stored at key',
'RedisArray::hVals' => 'Returns the values in a hash, as an array of strings.',
'RedisArray::incr' => 'Increment the number stored at key by one.',
'RedisArray::incrBy' => 'Increment the number stored at key by one.
If the second argument is filled, it will be used as the integer value of the increment.',
'RedisArray::incrByFloat' => 'Increment the float value of a key by the given amount',
'RedisArray::info' => 'Returns an associative array of strings and integers, with the following keys:
- redis_version
- redis_git_sha1
- redis_git_dirty
- redis_build_id
- redis_mode
- os
- arch_bits
- multiplexing_api
- atomicvar_api
- gcc_version
- process_id
- run_id
- tcp_port
- uptime_in_seconds
- uptime_in_days
- hz
- lru_clock
- executable
- config_file
- connected_clients
- client_longest_output_list
- client_biggest_input_buf
- blocked_clients
- used_memory
- used_memory_human
- used_memory_rss
- used_memory_rss_human
- used_memory_peak
- used_memory_peak_human
- used_memory_peak_perc
- used_memory_peak
- used_memory_overhead
- used_memory_startup
- used_memory_dataset
- used_memory_dataset_perc
- total_system_memory
- total_system_memory_human
- used_memory_lua
- used_memory_lua_human
- maxmemory
- maxmemory_human
- maxmemory_policy
- mem_fragmentation_ratio
- mem_allocator
- active_defrag_running
- lazyfree_pending_objects
- mem_fragmentation_ratio
- loading
- rdb_changes_since_last_save
- rdb_bgsave_in_progress
- rdb_last_save_time
- rdb_last_bgsave_status
- rdb_last_bgsave_time_sec
- rdb_current_bgsave_time_sec
- rdb_last_cow_size
- aof_enabled
- aof_rewrite_in_progress
- aof_rewrite_scheduled
- aof_last_rewrite_time_sec
- aof_current_rewrite_time_sec
- aof_last_bgrewrite_status
- aof_last_write_status
- aof_last_cow_size
- changes_since_last_save
- aof_current_size
- aof_base_size
- aof_pending_rewrite
- aof_buffer_length
- aof_rewrite_buffer_length
- aof_pending_bio_fsync
- aof_delayed_fsync
- loading_start_time
- loading_total_bytes
- loading_loaded_bytes
- loading_loaded_perc
- loading_eta_seconds
- total_connections_received
- total_commands_processed
- instantaneous_ops_per_sec
- total_net_input_bytes
- total_net_output_bytes
- instantaneous_input_kbps
- instantaneous_output_kbps
- rejected_connections
- maxclients
- sync_full
- sync_partial_ok
- sync_partial_err
- expired_keys
- evicted_keys
- keyspace_hits
- keyspace_misses
- pubsub_channels
- pubsub_patterns
- latest_fork_usec
- migrate_cached_sockets
- slave_expires_tracked_keys
- active_defrag_hits
- active_defrag_misses
- active_defrag_key_hits
- active_defrag_key_misses
- role
- master_replid
- master_replid2
- master_repl_offset
- second_repl_offset
- repl_backlog_active
- repl_backlog_size
- repl_backlog_first_byte_offset
- repl_backlog_histlen
- master_host
- master_port
- master_link_status
- master_last_io_seconds_ago
- master_sync_in_progress
- slave_repl_offset
- slave_priority
- slave_read_only
- master_sync_left_bytes
- master_sync_last_io_seconds_ago
- master_link_down_since_seconds
- connected_slaves
- min-slaves-to-write
- min-replicas-to-write
- min_slaves_good_slaves
- used_cpu_sys
- used_cpu_user
- used_cpu_sys_children
- used_cpu_user_children
- cluster_enabled',
'RedisArray::isConnected' => 'A method to determine if a phpredis object thinks it\'s connected to a server',
'RedisArray::keys' => 'Returns the keys that match a certain pattern.',
'RedisArray::lastSave' => 'Returns the timestamp of the last disk save.',
'RedisArray::lGet' => '`@return mixed|bool` the element at this index',
'RedisArray::lIndex' => 'Return the specified element of the list stored at the specified key.
0 the first element, 1 the second ... -1 the last element, -2 the penultimate ...
Return FALSE in case of a bad index or a key that doesn\'t point to a list.',
'RedisArray::lInsert' => 'Insert value in the list before or after the pivot value. the parameter options
specify the position of the insert (before or after). If the list didn\'t exists,
or the pivot didn\'t exists, the value is not inserted.',
'RedisArray::lLen' => 'Returns the size of a list identified by Key. If the list didn\'t exist or is empty,
the command returns 0. If the data type identified by Key is not a list, the command return FALSE.',
'RedisArray::lPop' => 'Returns and removes the first element of the list.',
'RedisArray::lPush' => 'Adds the string values to the head (left) of the list.
Creates the list if the key didn\'t exist.
If the key exists and is not a list, FALSE is returned.',
'RedisArray::lPushx' => 'Adds the string value to the head (left) of the list if the list exists.',
'RedisArray::lRange' => 'Returns the specified elements of the list stored at the specified key in
the range [start, end]. start and stop are interpretated as indices: 0 the first element,
1 the second ... -1 the last element, -2 the penultimate ...',
'RedisArray::lRem' => 'Removes the first count occurences of the value element from the list.
If count is zero, all the matching elements are removed. If count is negative,
elements are removed from tail to head.',
'RedisArray::lSet' => 'Set the list at index with the new value.',
'RedisArray::lSize' => '`@return int` The size of the list identified by Key exists',
'RedisArray::lTrim' => 'Trims an existing list so that it will contain only a specified range of elements.',
'RedisArray::mget' => 'Returns the values of all specified keys.

For every key that does not hold a string value or does not exist,
the special value false is returned. Because of this, the operation never fails.',
'RedisArray::migrate' => 'Migrates a key to a different Redis instance.',
'RedisArray::move' => 'Moves a key to a different database.',
'RedisArray::mset' => 'Sets multiple key-value pairs in one atomic command.
MSETNX only returns TRUE if all the keys were set (see SETNX).',
'RedisArray::msetnx' => '`@return int` 1 (if the keys were set) or 0 (no key was set)',
'RedisArray::multi' => 'Enter and exit transactional mode.',
'RedisArray::object' => 'Describes the object pointed to by a key.
The information to retrieve (string) and the key (string).
Info can be one of the following:
- "encoding"
- "refcount"
- "idletime"',
'RedisArray::open' => 'Connects to a Redis instance.',
'RedisArray::pconnect' => 'Connects to a Redis instance or reuse a connection already established with pconnect/popen.

The connection will not be closed on close or end of request until the php process ends.
So be patient on to many open FD\'s (specially on redis server side) when using persistent connections on
many servers connecting to one redis server.

Also more than one persistent connection can be made identified by either host + port + timeout
or host + persistentId or unix socket + timeout.

This feature is not available in threaded versions. pconnect and popen then working like their non persistent
equivalents.',
'RedisArray::persist' => 'Remove the expiration timer from a key.',
'RedisArray::pExpire' => 'Sets an expiration date (a timeout in milliseconds) on an item',
'RedisArray::pExpireAt' => 'Sets an expiration date (a timestamp) on an item. Requires a timestamp in milliseconds',
'RedisArray::pfAdd' => 'Adds all the element arguments to the HyperLogLog data structure stored at the key.',
'RedisArray::pfCount' => 'When called with a single key, returns the approximated cardinality computed by the HyperLogLog data
structure stored at the specified variable, which is 0 if the variable does not exist.',
'RedisArray::pfMerge' => 'Merge multiple HyperLogLog values into an unique value that will approximate the cardinality
of the union of the observed Sets of the source HyperLogLog structures.',
'RedisArray::ping' => 'Check the current connection status',
'RedisArray::psetex' => 'Set the value and expiration in milliseconds of a key.',
'RedisArray::psubscribe' => 'Subscribe to channels by pattern',
'RedisArray::pttl' => 'Returns a time to live left for a given key, in milliseconds.

If the key doesn\'t exist, FALSE is returned.',
'RedisArray::publish' => 'Publish messages to channels.

Warning: this function will probably change in the future.',
'RedisArray::pubsub' => 'A command allowing you to get information on the Redis pub/sub system',
'RedisArray::punsubscribe' => 'Stop listening for messages posted to the given channels.',
'RedisArray::randomKey' => 'Returns a random key',
'RedisArray::rawCommand' => 'Send arbitrary things to the redis server.',
'RedisArray::rename' => 'Renames a key',
'RedisArray::renameNx' => 'Renames a key

Same as rename, but will not replace a key if the destination already exists.
This is the same behaviour as setNx.',
'RedisArray::resetStat' => 'Resets the statistics reported by Redis using the INFO command (`info()` function).
These are the counters that are reset:
     - Keyspace hits
     - Keyspace misses
     - Number of commands processed
     - Number of connections received
     - Number of expired keys',
'RedisArray::restore' => 'Restore a key from the result of a DUMP operation.',
'RedisArray::rPop' => 'Returns and removes the last element of the list.',
'RedisArray::rpoplpush' => 'Pops a value from the tail of a list, and pushes it to the front of another list.
Also return this value.',
'RedisArray::rPush' => 'Adds the string values to the tail (right) of the list.
Creates the list if the key didn\'t exist.
If the key exists and is not a list, FALSE is returned.',
'RedisArray::rPushx' => 'Adds the string value to the tail (right) of the list if the ist exists. FALSE in case of Failure.',
'RedisArray::sAdd' => 'Adds a values to the set value stored at key.',
'RedisArray::sAddArray' => 'Adds a values to the set value stored at key.',
'RedisArray::save' => 'Performs a synchronous save.',
'RedisArray::scan' => 'Scan the keyspace for keys',
'RedisArray::sCard' => 'Returns the cardinality of the set identified by key.',
'RedisArray::script' => 'Execute the Redis SCRIPT command to perform various operations on the scripting subsystem.',
'RedisArray::sDiff' => 'Performs the difference between N sets and returns it.',
'RedisArray::sDiffStore' => 'Performs the same action as sDiff, but stores the result in the first key',
'RedisArray::select' => 'Switches to a given database',
'RedisArray::set' => 'Set the string value in argument as value of the key.',
'RedisArray::setBit' => 'Changes a single bit of a string.',
'RedisArray::setex' => 'Set the string value in argument as value of the key, with a time to live.',
'RedisArray::setnx' => 'Set the string value in argument as value of the key if the key doesn\'t already exist in the database.',
'RedisArray::setOption' => 'Set client option',
'RedisArray::setRange' => 'Changes a substring of a larger string.',
'RedisArray::sGetMembers' => '`@return array`   An array of elements, the contents of the set',
'RedisArray::sInter' => 'Returns the members of a set resulting from the intersection of all the sets
held at the specified keys. If just a single key is specified, then this command
produces the members of this set. If one of the keys is missing, FALSE is returned.',
'RedisArray::sInterStore' => 'Performs a sInter command and stores the result in a new set.',
'RedisArray::sIsMember' => 'Checks if value is a member of the set stored at the key key.',
'RedisArray::slaveof' => 'Changes the slave status
Either host and port, or no parameter to stop being a slave.',
'RedisArray::slowLog' => 'Access the Redis slowLog',
'RedisArray::sMembers' => 'Returns the contents of a set.',
'RedisArray::sMove' => 'Moves the specified member from the set at srcKey to the set at dstKey.',
'RedisArray::sort' => 'Sort',
'RedisArray::sPop' => 'Removes and returns a random element from the set value at Key.',
'RedisArray::sRandMember' => 'Returns a random element(s) from the set value at Key, without removing it.',
'RedisArray::sRem' => 'Removes the specified members from the set value stored at key.',
'RedisArray::sScan' => 'Scan a set for members',
'RedisArray::strlen' => 'Get the length of a string value.',
'RedisArray::subscribe' => 'Subscribe to channels.

Warning: this function will probably change in the future.',
'RedisArray::substr' => 'Return a substring of a larger string',
'RedisArray::sUnion' => 'Performs the union between N sets and returns it.',
'RedisArray::sUnionStore' => 'Performs the same action as sUnion, but stores the result in the first key',
'RedisArray::swapdb' => 'Swap one Redis database with another atomically

Note: Requires Redis >= 4.0.0',
'RedisArray::time' => 'Return the current Redis server time.',
'RedisArray::ttl' => 'Returns the time to live left for a given key, in seconds. If the key doesn\'t exist, FALSE is returned.',
'RedisArray::type' => 'Returns the type of data pointed by a given key.',
'RedisArray::unlink' => 'Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.',
'RedisArray::unsubscribe' => 'Stop listening for messages posted to the given channels.',
'RedisArray::wait' => 'Blocks the current client until all the previous write commands are successfully transferred and
acknowledged by at least the specified number of slaves.',
'RedisArray::watch' => 'Watches a key for modifications by another client. If the key is modified between WATCH and EXEC,
the MULTI/EXEC transaction will fail (return FALSE). unwatch cancels all the watching of all keys by this client.',
'RedisArray::xAck' => 'Acknowledge one or more messages on behalf of a consumer group.',
'RedisArray::xAdd' => 'Add a message to a stream',
'RedisArray::xClaim' => 'Claim ownership of one or more pending messages',
'RedisArray::xDel' => 'Delete one or more messages from a stream',
'RedisArray::xGroup' => '`@return mixed` This command returns different types depending on the specific XGROUP command executed.',
'RedisArray::xInfo' => 'Get information about a stream or consumer groups',
'RedisArray::xLen' => 'Get the length of a given stream.',
'RedisArray::xPending' => 'Get information about pending messages in a given stream',
'RedisArray::xRange' => 'Get a range of messages from a given stream',
'RedisArray::xRead' => 'Read data from one or more streams and only return IDs greater than sent in the command.',
'RedisArray::xReadGroup' => 'This method is similar to xRead except that it supports reading messages for a specific consumer group.',
'RedisArray::xRevRange' => 'This is identical to xRange except the results come back in reverse order.
Also note that Redis reverses the order of "start" and "end".',
'RedisArray::xTrim' => 'Trim the stream length to a given maximum.
If the "approximate" flag is pasesed, Redis will use your size as a hint but only trim trees in whole nodes
(this is more efficient)',
'RedisArray::zAdd' => 'Adds the specified member with a given score to the sorted set stored at key',
'RedisArray::zCard' => 'Returns the cardinality of an ordered set.',
'RedisArray::zCount' => 'Returns the number of elements of the sorted set stored at the specified key which have
scores in the range [start,end]. Adding a parenthesis before start or end excludes it
from the range. +inf and -inf are also valid limits.',
'RedisArray::zDelete' => '`@return int` Number of deleted values',
'RedisArray::zIncrBy' => 'Increments the score of a member from a sorted set by a given amount.',
'RedisArray::zInterStore' => 'Creates an intersection of sorted sets given in second argument.
The result of the union will be stored in the sorted set defined by the first argument.
The third optional argument defines weights to apply to the sorted sets in input.
In this case, the weights will be multiplied by the score of each element in the sorted set
before applying the aggregation. The forth argument defines the AGGREGATE option which
specify how the results of the union are aggregated.',
'RedisArray::zPopMax' => 'Can pop the highest scoring members from one ZSET.',
'RedisArray::zPopMin' => 'Can pop the lowest scoring members from one ZSET.',
'RedisArray::zRange' => 'Returns a range of elements from the ordered set stored at the specified key,
with values in the range [start, end]. start and stop are interpreted as zero-based indices:
0 the first element,
1 the second ...
-1 the last element,
-2 the penultimate ...',
'RedisArray::zRangeByLex' => 'Returns a lexigraphical range of members in a sorted set, assuming the members have the same score. The
min and max values are required to start with \'(\' (exclusive), \'[\' (inclusive), or be exactly the values
\'-\' (negative inf) or \'+\' (positive inf).  The command must be called with either three *or* five
arguments or will return FALSE.',
'RedisArray::zRangeByScore' => 'Returns the elements of the sorted set stored at the specified key which have scores in the
range [start,end]. Adding a parenthesis before start or end excludes it from the range.
+inf and -inf are also valid limits.

zRevRangeByScore returns the same items in reverse order, when the start and end parameters are swapped.',
'RedisArray::zRank' => 'Returns the rank of a given member in the specified sorted set, starting at 0 for the item
with the smallest score. zRevRank starts at 0 for the item with the largest score.',
'RedisArray::zRem' => 'Deletes a specified member from the ordered set.',
'RedisArray::zRemRangeByRank' => 'Deletes the elements of the sorted set stored at the specified key which have rank in the range [start,end].',
'RedisArray::zRemRangeByScore' => 'Deletes the elements of the sorted set stored at the specified key which have scores in the range [start,end].',
'RedisArray::zRevRange' => 'Returns the elements of the sorted set stored at the specified key in the range [start, end]
in reverse order. start and stop are interpretated as zero-based indices:
0 the first element,
1 the second ...
-1 the last element,
-2 the penultimate ...',
'RedisArray::zRevRank' => '`@return int|bool` the item\'s score, false - if key or member is not exists',
'RedisArray::zScan' => 'Scan a sorted set for members, with optional pattern and count',
'RedisArray::zScore' => 'Returns the score of a given member in the specified sorted set.',
'RedisArray::zUnionStore' => 'Creates an union of sorted sets given in second argument.
The result of the union will be stored in the sorted set defined by the first argument.
The third optionnel argument defines weights to apply to the sorted sets in input.
In this case, the weights will be multiplied by the score of each element in the sorted set
before applying the aggregation. The forth argument defines the AGGREGATE option which
specify how the results of the union are aggregated.',
'RedisCluster::__construct' => 'Creates a Redis Cluster client',
'RedisCluster::_masters' => 'Return all redis master nodes',
'RedisCluster::_prefix' => 'A utility method to prefix the value with the prefix setting for phpredis.',
'RedisCluster::_serialize' => 'A utility method to serialize values manually. This method allows you to serialize a value with whatever
serializer is configured, manually. This can be useful for serialization/unserialization of data going in
and out of EVAL commands as phpredis can\'t automatically do this itself.  Note that if no serializer is
set, phpredis will change Array values to \'Array\', and Objects to \'Object\'.',
'RedisCluster::_unserialize' => 'A utility method to unserialize data with whatever serializer is set up.  If there is no serializer set, the
value will be returned unchanged.  If there is a serializer set up, and the data passed in is malformed, an
exception will be thrown. This can be useful if phpredis is serializing values, and you return something from
redis in a LUA script that is serialized.',
'RedisCluster::append' => 'Append specified string to the string stored in specified key.',
'RedisCluster::bgrewriteaof' => 'Starts the background rewrite of AOF (Append-Only File) at a specific node.',
'RedisCluster::bgsave' => 'Performs a background save at a specific node.',
'RedisCluster::bitCount' => 'Count bits in a string.',
'RedisCluster::bitOp' => 'Bitwise operation on multiple keys.',
'RedisCluster::bitpos' => 'Return the position of the first bit set to 1 or 0 in a string. The position is returned, thinking of the
string as an array of bits from left to right, where the first byte\'s most significant bit is at position 0,
the second byte\'s most significant bit is at position 8, and so forth.',
'RedisCluster::blPop' => 'BLPOP is a blocking list pop primitive.
It is the blocking version of LPOP because it blocks the connection when
there are no elements to pop from any of the given lists.
An element is popped from the head of the first list that is non-empty,
with the given keys being checked in the order that they are given.',
'RedisCluster::brPop' => 'BRPOP is a blocking list pop primitive.
It is the blocking version of RPOP because it blocks the connection when
there are no elements to pop from any of the given lists.
An element is popped from the tail of the first list that is non-empty,
with the given keys being checked in the order that they are given.
See the BLPOP documentation(https://redis.io/commands/blpop) for the exact semantics,
since BRPOP is identical to BLPOP with the only difference being that
it pops elements from the tail of a list instead of popping from the head.',
'RedisCluster::brpoplpush' => 'A blocking version of rpoplpush, with an integral timeout in the third parameter.',
'RedisCluster::clearLastError' => 'Clear the last error message',
'RedisCluster::client' => 'Allows you to get information of the cluster client',
'RedisCluster::close' => 'Disconnects from the Redis instance, except when pconnect is used.',
'RedisCluster::command' => 'Returns Array reply of details about all Redis Cluster commands.',
'RedisCluster::config' => 'Get or Set the redis config keys.',
'RedisCluster::dbSize' => 'Returns the current database\'s size at a specific node.',
'RedisCluster::decr' => 'Decrement the number stored at key by one.',
'RedisCluster::decrBy' => 'Decrement the number stored at key by one. If the second argument is filled, it will be used as the integer
value of the decrement.',
'RedisCluster::del' => 'Remove specified keys.',
'RedisCluster::dump' => 'Dump a key out of a redis database, the value of which can later be passed into redis using the RESTORE command.
The data that comes out of DUMP is a binary representation of the key as Redis stores it.',
'RedisCluster::echo' => 'Returns message.',
'RedisCluster::evalSha' => 'Evaluate a LUA script serverside, from the SHA1 hash of the script instead of the script itself.
In order to run this command Redis will have to have already loaded the script, either by running it or via
the SCRIPT LOAD command.',
'RedisCluster::exists' => 'Verify if the specified key exists.',
'RedisCluster::expire' => 'Sets an expiration date (a timeout) on an item.',
'RedisCluster::expireAt' => 'Sets an expiration date (a timestamp) on an item.',
'RedisCluster::flushAll' => 'Removes all entries from all databases at a specific node.',
'RedisCluster::flushDB' => 'Removes all entries from the current database at a specific node.',
'RedisCluster::geoAdd' => 'Add one or more geospatial items in the geospatial index represented using a sorted set',
'RedisCluster::geoDist' => 'Returns the distance between two members of a geospatial index',
'RedisCluster::geohash' => 'Returns members of a geospatial index as standard geohash strings',
'RedisCluster::geopos' => 'Returns longitude and latitude of members of a geospatial index',
'RedisCluster::geoRadius' => 'Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a point',
'RedisCluster::geoRadiusByMember' => 'Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a member',
'RedisCluster::get' => 'Get the value related to the specified key',
'RedisCluster::getBit' => 'Return a single bit out of a larger string',
'RedisCluster::getLastError' => 'The last error message (if any)',
'RedisCluster::getMode' => 'Detect whether we\'re in ATOMIC/MULTI/PIPELINE mode.',
'RedisCluster::getOption' => 'Get client option',
'RedisCluster::getRange' => 'Return a substring of a larger string',
'RedisCluster::getSet' => 'Sets a value and returns the previous entry at that key.',
'RedisCluster::hDel' => 'Removes a values from the hash stored at key.
If the hash table doesn\'t exist, or the key doesn\'t exist, FALSE is returned.',
'RedisCluster::hExists' => 'Verify if the specified member exists in a key.',
'RedisCluster::hGet' => 'Gets a value from the hash stored at key.
If the hash table doesn\'t exist, or the key doesn\'t exist, FALSE is returned.',
'RedisCluster::hGetAll' => 'Returns the whole hash, as an array of strings indexed by strings.',
'RedisCluster::hIncrBy' => 'Increments the value of a member from a hash by a given amount.',
'RedisCluster::hIncrByFloat' => 'Increment the float value of a hash field by the given amount',
'RedisCluster::hKeys' => 'Returns the keys in a hash, as an array of strings.',
'RedisCluster::hLen' => 'Returns the length of a hash, in number of items',
'RedisCluster::hMGet' => 'Retirieve the values associated to the specified fields in the hash.',
'RedisCluster::hMSet' => 'Fills in a whole hash. Non-string values are converted to string, using the standard (string) cast.
NULL values are stored as empty strings',
'RedisCluster::hScan' => 'Scan a HASH value for members, with an optional pattern and count.',
'RedisCluster::hSet' => 'Adds a value to the hash stored at key. If this value is already in the hash, FALSE is returned.',
'RedisCluster::hSetNx' => 'Adds a value to the hash stored at key only if this field isn\'t already in the hash.',
'RedisCluster::hVals' => 'Returns the values in a hash, as an array of strings.',
'RedisCluster::incr' => 'Increment the number stored at key by one.',
'RedisCluster::incrBy' => 'Increment the number stored at key by one. If the second argument is filled, it will be used as the integer
value of the increment.',
'RedisCluster::incrByFloat' => 'Increment the float value of a key by the given amount',
'RedisCluster::info' => 'Returns an associative array of strings and integers',
'RedisCluster::keys' => 'Returns the keys that match a certain pattern.',
'RedisCluster::lastSave' => 'Returns the timestamp of the last disk save at a specific node.',
'RedisCluster::lIndex' => 'Return the specified element of the list stored at the specified key.
0 the first element, 1 the second ... -1 the last element, -2 the penultimate ...
Return FALSE in case of a bad index or a key that doesn\'t point to a list.',
'RedisCluster::lInsert' => 'Insert value in the list before or after the pivot value. the parameter options
specify the position of the insert (before or after). If the list didn\'t exists,
or the pivot didn\'t exists, the value is not inserted.',
'RedisCluster::lLen' => 'Returns the size of a list identified by Key. If the list didn\'t exist or is empty,
the command returns 0. If the data type identified by Key is not a list, the command return FALSE.',
'RedisCluster::lPop' => 'Returns and removes the first element of the list.',
'RedisCluster::lPush' => 'Adds the string values to the head (left) of the list. Creates the list if the key didn\'t exist.
If the key exists and is not a list, FALSE is returned.',
'RedisCluster::lPushx' => 'Adds the string value to the head (left) of the list if the list exists.',
'RedisCluster::lRange' => 'Returns the specified elements of the list stored at the specified key in
the range [start, end]. start and stop are interpreted as indices: 0 the first element,
1 the second ... -1 the last element, -2 the penultimate ...',
'RedisCluster::lRem' => 'Removes the first count occurrences of the value element from the list.
If count is zero, all the matching elements are removed. If count is negative,
elements are removed from tail to head.',
'RedisCluster::lSet' => 'Set the list at index with the new value.',
'RedisCluster::lTrim' => 'Trims an existing list so that it will contain only a specified range of elements.',
'RedisCluster::mget' => 'Returns the values of all specified keys.

For every key that does not hold a string value or does not exist,
the special value false is returned. Because of this, the operation never fails.',
'RedisCluster::mset' => 'Sets multiple key-value pairs in one atomic command.
MSETNX only returns TRUE if all the keys were set (see SETNX).',
'RedisCluster::msetnx' => '`@return  int` 1 (if the keys were set) or 0 (no key was set)',
'RedisCluster::multi' => 'Enter and exit transactional mode.',
'RedisCluster::object' => 'Describes the object pointed to by a key.
The information to retrieve (string) and the key (string).
Info can be one of the following:
- "encoding"
- "refcount"
- "idletime"',
'RedisCluster::persist' => 'Remove the expiration timer from a key.',
'RedisCluster::pExpire' => 'Sets an expiration date (a timeout in milliseconds) on an item.',
'RedisCluster::pExpireAt' => 'Sets an expiration date (a timestamp) on an item. Requires a timestamp in milliseconds',
'RedisCluster::pfAdd' => 'Adds all the element arguments to the HyperLogLog data structure stored at the key.',
'RedisCluster::pfCount' => 'When called with a single key, returns the approximated cardinality computed by the HyperLogLog data
structure stored at the specified variable, which is 0 if the variable does not exist.',
'RedisCluster::pfMerge' => 'Merge multiple HyperLogLog values into an unique value that will approximate the cardinality
of the union of the observed Sets of the source HyperLogLog structures.',
'RedisCluster::ping' => 'Check the specified node status',
'RedisCluster::psetex' => 'PSETEX works exactly like SETEX with the sole difference that the expire time is specified in milliseconds
instead of seconds.',
'RedisCluster::psubscribe' => 'Subscribe to channels by pattern',
'RedisCluster::pttl' => 'Returns the remaining time to live of a key that has an expire set,
with the sole difference that TTL returns the amount of remaining time in seconds while PTTL returns it in
milliseconds. In Redis 2.6 or older the command returns -1 if the key does not exist or if the key exist but has
no associated expire. Starting with Redis 2.8 the return value in case of error changed: Returns -2 if the key
does not exist. Returns -1 if the key exists but has no associated expire.',
'RedisCluster::publish' => 'Publish messages to channels. Warning: this function will probably change in the future.',
'RedisCluster::pubsub' => 'A command allowing you to get information on the Redis pub/sub system.',
'RedisCluster::punSubscribe' => 'Unsubscribes the client from the given patterns, or from all of them if none is given.',
'RedisCluster::randomKey' => 'Returns a random key at the specified node',
'RedisCluster::rawCommand' => 'Send arbitrary things to the redis server at the specified node',
'RedisCluster::rename' => 'Renames a key.',
'RedisCluster::renameNx' => 'Renames a key.

Same as rename, but will not replace a key if the destination already exists.
This is the same behaviour as setNx.',
'RedisCluster::restore' => 'Restore a key from the result of a DUMP operation.',
'RedisCluster::rPop' => 'Returns and removes the last element of the list.',
'RedisCluster::rpoplpush' => 'Pops a value from the tail of a list, and pushes it to the front of another list.
Also return this value.',
'RedisCluster::rPush' => 'Adds the string values to the tail (right) of the list. Creates the list if the key didn\'t exist.
If the key exists and is not a list, FALSE is returned.',
'RedisCluster::rPushx' => 'Adds the string value to the tail (right) of the list if the list exists. FALSE in case of Failure.',
'RedisCluster::sAdd' => 'Adds a values to the set value stored at key.
If this value is already in the set, FALSE is returned.',
'RedisCluster::sAddArray' => 'Adds a values to the set value stored at key.
If this value is already in the set, FALSE is returned.',
'RedisCluster::save' => 'Performs a synchronous save at a specific node.',
'RedisCluster::scan' => 'Scan the keyspace for keys.',
'RedisCluster::sCard' => 'Returns the set cardinality (number of elements) of the set stored at key.',
'RedisCluster::script' => 'Execute the Redis SCRIPT command to perform various operations on the scripting subsystem.',
'RedisCluster::sDiff' => 'Performs the difference between N sets and returns it.',
'RedisCluster::sDiffStore' => 'Performs the same action as sDiff, but stores the result in the first key',
'RedisCluster::set' => 'Set the string value in argument as value of the key.',
'RedisCluster::setBit' => 'Changes a single bit of a string.',
'RedisCluster::setex' => 'Set the string value in argument as value of the key, with a time to live.',
'RedisCluster::setnx' => 'Set the string value in argument as value of the key if the key doesn\'t already exist in the database.',
'RedisCluster::setOption' => 'Set client option.',
'RedisCluster::setRange' => 'Changes a substring of a larger string.',
'RedisCluster::sInter' => 'Returns the members of a set resulting from the intersection of all the sets
held at the specified keys. If just a single key is specified, then this command
produces the members of this set. If one of the keys is missing, FALSE is returned.',
'RedisCluster::sInterStore' => 'Performs a sInter command and stores the result in a new set.',
'RedisCluster::sIsMember' => 'Returns if member is a member of the set stored at key.',
'RedisCluster::slowLog' => 'This function is used in order to read and reset the Redis slow queries log.',
'RedisCluster::sMembers' => 'Returns all the members of the set value stored at key.
This has the same effect as running SINTER with one argument key.',
'RedisCluster::sMove' => 'Moves the specified member from the set at srcKey to the set at dstKey.',
'RedisCluster::sort' => 'Sort',
'RedisCluster::sPop' => 'Removes and returns a random element from the set value at Key.',
'RedisCluster::sRandMember' => 'Returns a random element(s) from the set value at Key, without removing it.',
'RedisCluster::sRem' => 'Removes the specified members from the set value stored at key.',
'RedisCluster::sScan' => 'Scan a set for members.',
'RedisCluster::strlen' => 'Get the length of a string value.',
'RedisCluster::subscribe' => 'Subscribe to channels. Warning: this function will probably change in the future.',
'RedisCluster::sUnion' => 'Performs the union between N sets and returns it.',
'RedisCluster::sUnionStore' => 'Performs the same action as sUnion, but stores the result in the first key',
'RedisCluster::time' => 'Return the specified node server time.',
'RedisCluster::ttl' => 'Returns the remaining time to live of a key that has a timeout.
This introspection capability allows a Redis client to check how many seconds a given key will continue to be
part of the dataset. In Redis 2.6 or older the command returns -1 if the key does not exist or if the key exist
but has no associated expire. Starting with Redis 2.8 the return value in case of error changed: Returns -2 if
the key does not exist. Returns -1 if the key exists but has no associated expire.',
'RedisCluster::type' => 'Returns the type of data pointed by a given key.',
'RedisCluster::unSubscribe' => 'Unsubscribes the client from the given channels, or from all of them if none is given.',
'RedisCluster::watch' => 'Watches a key for modifications by another client. If the key is modified between WATCH and EXEC,
the MULTI/EXEC transaction will fail (return FALSE). unwatch cancels all the watching of all keys by this client.',
'RedisCluster::zAdd' => 'Adds the specified member with a given score to the sorted set stored at key.',
'RedisCluster::zCard' => 'Returns the cardinality of an ordered set.',
'RedisCluster::zCount' => 'Returns the number of elements of the sorted set stored at the specified key which have
scores in the range [start,end]. Adding a parenthesis before start or end excludes it
from the range. +inf and -inf are also valid limits.',
'RedisCluster::zIncrBy' => 'Increments the score of a member from a sorted set by a given amount.',
'RedisCluster::zInterStore' => 'Intersect multiple sorted sets and store the resulting sorted set in a new key',
'RedisCluster::zLexCount' => 'Count the number of members in a sorted set between a given lexicographical range.',
'RedisCluster::zRange' => 'Returns a range of elements from the ordered set stored at the specified key,
with values in the range [start, end]. start and stop are interpreted as zero-based indices:
0 the first element,
1 the second ...
-1 the last element,
-2 the penultimate ...',
'RedisCluster::zRangeByLex' => 'Returns a range of members in a sorted set, by lexicographical range',
'RedisCluster::zRangeByScore' => 'Returns the elements of the sorted set stored at the specified key which have scores in the
range [start,end]. Adding a parenthesis before start or end excludes it from the range.
+inf and -inf are also valid limits.

zRevRangeByScore returns the same items in reverse order, when the start and end parameters are swapped.',
'RedisCluster::zRank' => 'Returns the rank of a given member in the specified sorted set, starting at 0 for the item
with the smallest score. zRevRank starts at 0 for the item with the largest score.',
'RedisCluster::zRem' => 'Deletes a specified member from the ordered set.',
'RedisCluster::zRemRangeByLex' => 'Remove all members in a sorted set between the given lexicographical range.',
'RedisCluster::zRemRangeByRank' => 'Deletes the elements of the sorted set stored at the specified key which have rank in the range [start,end].',
'RedisCluster::zRemRangeByScore' => 'Deletes the elements of the sorted set stored at the specified key which have scores in the range [start,end].',
'RedisCluster::zRevRange' => 'Returns the elements of the sorted set stored at the specified key in the range [start, end]
in reverse order. start and stop are interpreted as zero-based indices:
0 the first element,
1 the second ...
-1 the last element,
-2 the penultimate ...',
'RedisCluster::zRevRank' => '`@return int`    the item\'s score',
'RedisCluster::zScan' => 'Scan a sorted set for members, with optional pattern and count.',
'RedisCluster::zScore' => 'Returns the score of a given member in the specified sorted set.',
'RedisCluster::zUnionStore' => 'Add multiple sorted sets and store the resulting sorted set in a new key',
'referenceMapObj::convertToString' => 'Saves the object to a string.  Provides the inverse option for
updateFromString.',
'referenceMapObj::free' => 'Free the object properties and break the internal references.
Note that you have to unset the php variable to free totally the
resources.',
'referenceMapObj::set' => 'Set object property to a new value.',
'referenceMapObj::updateFromString' => 'Update a referenceMap object from a string snippet.
Returns MS_SUCCESS/MS_FAILURE.',
'reflection::export' => 'Exports',
'reflection::getModifierNames' => 'Gets modifier names',
'ReflectionClass::__clone' => 'Clones object',
'reflectionclass::__construct' => 'Constructs a ReflectionClass',
'reflectionclass::__toString' => 'Returns the string representation of the ReflectionClass object',
'reflectionclass::export' => 'Exports a class',
'reflectionclass::getConstant' => 'Gets defined constant',
'reflectionclass::getConstants' => 'Gets constants',
'reflectionclass::getConstructor' => 'Gets the constructor of the class',
'reflectionclass::getDefaultProperties' => 'Gets default properties',
'reflectionclass::getDocComment' => 'Gets doc comments',
'reflectionclass::getEndLine' => 'Gets end line',
'reflectionclass::getExtension' => 'Gets a ReflectionExtension object for the extension which defined the class',
'reflectionclass::getExtensionName' => 'Gets the name of the extension which defined the class',
'reflectionclass::getFileName' => 'Gets the filename of the file in which the class has been defined',
'reflectionclass::getInterfaceNames' => 'Gets the interface names',
'reflectionclass::getInterfaces' => 'Gets the interfaces',
'reflectionclass::getMethod' => 'Gets a ReflectionMethod for a class method',
'reflectionclass::getMethods' => 'Gets an array of methods',
'reflectionclass::getModifiers' => 'Gets the class modifiers',
'reflectionclass::getName' => 'Gets class name',
'reflectionclass::getNamespaceName' => 'Gets namespace name',
'reflectionclass::getParentClass' => 'Gets parent class',
'reflectionclass::getProperties' => 'Gets properties',
'reflectionclass::getProperty' => 'Gets a ReflectionProperty for a class\'s property',
'reflectionclass::getReflectionConstant' => 'Gets a ReflectionClassConstant for a class\'s constant',
'reflectionclass::getReflectionConstants' => 'Gets class constants',
'reflectionclass::getShortName' => 'Gets short name',
'reflectionclass::getStartLine' => 'Gets starting line number',
'reflectionclass::getStaticProperties' => 'Gets values of initialized static properties',
'reflectionclass::getStaticPropertyValue' => 'Gets static property value',
'reflectionclass::getTraitAliases' => 'Returns an array of trait aliases',
'reflectionclass::getTraitNames' => 'Returns an array of names of traits used by this class',
'reflectionclass::getTraits' => 'Returns an array of traits used by this class',
'reflectionclass::hasConstant' => 'Checks if constant is defined',
'reflectionclass::hasMethod' => 'Checks if method is defined',
'reflectionclass::hasProperty' => 'Checks if property is defined',
'reflectionclass::implementsInterface' => 'Implements interface',
'reflectionclass::inNamespace' => 'Checks if in namespace',
'reflectionclass::isAbstract' => 'Checks if class is abstract',
'reflectionclass::isAnonymous' => 'Checks if class is anonymous',
'reflectionclass::isCloneable' => 'Returns whether this class is cloneable',
'reflectionclass::isFinal' => 'Checks if class is final',
'reflectionclass::isInstance' => 'Checks class for instance',
'reflectionclass::isInstantiable' => 'Checks if the class is instantiable',
'reflectionclass::isInterface' => 'Checks if the class is an interface',
'reflectionclass::isInternal' => 'Checks if class is defined internally by an extension, or the core',
'reflectionclass::isIterable' => 'Check whether this class is iterable',
'reflectionclass::isIterateable' => 'Alias of ReflectionClass::isIterable',
'reflectionclass::isSubclassOf' => 'Checks if a subclass',
'reflectionclass::isTrait' => 'Returns whether this is a trait',
'reflectionclass::isUserDefined' => 'Checks if user defined',
'reflectionclass::newInstance' => 'Creates a new class instance from given arguments',
'reflectionclass::newInstanceArgs' => 'Creates a new class instance from given arguments',
'reflectionclass::newInstanceWithoutConstructor' => 'Creates a new class instance without invoking the constructor',
'reflectionclass::setStaticPropertyValue' => 'Sets static property value',
'reflectionclassconstant::__construct' => 'Constructs a ReflectionClassConstant',
'reflectionclassconstant::__toString' => 'Returns the string representation of the ReflectionClassConstant object',
'reflectionclassconstant::export' => 'Export',
'reflectionclassconstant::getDeclaringClass' => 'Gets declaring class',
'reflectionclassconstant::getDocComment' => 'Gets doc comments',
'reflectionclassconstant::getModifiers' => 'Gets the class constant modifiers',
'reflectionclassconstant::getName' => 'Get name of the constant',
'reflectionclassconstant::getValue' => 'Gets value',
'reflectionclassconstant::isPrivate' => 'Checks if class constant is private',
'reflectionclassconstant::isProtected' => 'Checks if class constant is protected',
'reflectionclassconstant::isPublic' => 'Checks if class constant is public',
'ReflectionException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'ReflectionException::__toString' => 'String representation of the exception',
'ReflectionException::getCode' => 'Gets the Exception code',
'ReflectionException::getFile' => 'Gets the file in which the exception occurred',
'ReflectionException::getLine' => 'Gets the line in which the exception occurred',
'ReflectionException::getMessage' => 'Gets the Exception message',
'ReflectionException::getPrevious' => 'Returns previous Exception',
'ReflectionException::getTrace' => 'Gets the stack trace',
'ReflectionException::getTraceAsString' => 'Gets the stack trace as a string',
'reflectionextension::__clone' => 'Clones',
'reflectionextension::__construct' => 'Constructs a ReflectionExtension',
'reflectionextension::__toString' => 'To string',
'reflectionextension::export' => 'Export',
'reflectionextension::getClasses' => 'Gets classes',
'reflectionextension::getClassNames' => 'Gets class names',
'reflectionextension::getConstants' => 'Gets constants',
'reflectionextension::getDependencies' => 'Gets dependencies',
'reflectionextension::getFunctions' => 'Gets extension functions',
'reflectionextension::getINIEntries' => 'Gets extension ini entries',
'reflectionextension::getName' => 'Gets extension name',
'reflectionextension::getVersion' => 'Gets extension version',
'reflectionextension::info' => 'Print extension info',
'reflectionextension::isPersistent' => 'Returns whether this extension is persistent',
'reflectionextension::isTemporary' => 'Returns whether this extension is temporary',
'ReflectionFunction::__clone' => 'Clones function',
'reflectionfunction::__construct' => 'Constructs a ReflectionFunction object',
'reflectionfunction::__toString' => 'To string',
'reflectionfunction::export' => 'Exports function',
'reflectionfunction::getClosure' => 'Returns a dynamically created closure for the function',
'ReflectionFunction::getClosureScopeClass' => 'Returns the scope associated to the closure',
'ReflectionFunction::getClosureThis' => 'Returns this pointer bound to closure',
'ReflectionFunction::getDocComment' => 'Gets doc comment',
'ReflectionFunction::getEndLine' => 'Gets end line number',
'ReflectionFunction::getExtension' => 'Gets extension info',
'ReflectionFunction::getExtensionName' => 'Gets extension name',
'ReflectionFunction::getFileName' => 'Gets file name',
'ReflectionFunction::getName' => 'Gets function name',
'ReflectionFunction::getNamespaceName' => 'Gets namespace name',
'ReflectionFunction::getNumberOfParameters' => 'Gets number of parameters',
'ReflectionFunction::getNumberOfRequiredParameters' => 'Gets number of required parameters',
'ReflectionFunction::getParameters' => 'Gets parameters',
'ReflectionFunction::getReturnType' => 'Gets the specified return type of a function',
'ReflectionFunction::getShortName' => 'Gets function short name',
'ReflectionFunction::getStartLine' => 'Gets starting line number',
'ReflectionFunction::getStaticVariables' => 'Gets static variables',
'ReflectionFunction::hasReturnType' => 'Checks if the function has a specified return type',
'ReflectionFunction::inNamespace' => 'Checks if function in namespace',
'reflectionfunction::invoke' => 'Invokes function',
'reflectionfunction::invokeArgs' => 'Invokes function args',
'ReflectionFunction::isClosure' => 'Checks if closure',
'ReflectionFunction::isDeprecated' => 'Checks if deprecated',
'reflectionfunction::isDisabled' => 'Checks if function is disabled',
'ReflectionFunction::isGenerator' => 'Returns whether this function is a generator',
'ReflectionFunction::isInternal' => 'Checks if is internal',
'ReflectionFunction::isUserDefined' => 'Checks if user defined',
'ReflectionFunction::isVariadic' => 'Checks if the function is variadic',
'ReflectionFunction::returnsReference' => 'Checks if returns reference',
'reflectionfunctionabstract::__clone' => 'Clones function',
'reflectionfunctionabstract::__toString' => 'To string',
'ReflectionFunctionAbstract::export' => 'Exports',
'reflectionfunctionabstract::getClosureScopeClass' => 'Returns the scope associated to the closure',
'reflectionfunctionabstract::getClosureThis' => 'Returns this pointer bound to closure',
'reflectionfunctionabstract::getDocComment' => 'Gets doc comment',
'reflectionfunctionabstract::getEndLine' => 'Gets end line number',
'reflectionfunctionabstract::getExtension' => 'Gets extension info',
'reflectionfunctionabstract::getExtensionName' => 'Gets extension name',
'reflectionfunctionabstract::getFileName' => 'Gets file name',
'reflectionfunctionabstract::getName' => 'Gets function name',
'reflectionfunctionabstract::getNamespaceName' => 'Gets namespace name',
'reflectionfunctionabstract::getNumberOfParameters' => 'Gets number of parameters',
'reflectionfunctionabstract::getNumberOfRequiredParameters' => 'Gets number of required parameters',
'reflectionfunctionabstract::getParameters' => 'Gets parameters',
'reflectionfunctionabstract::getReturnType' => 'Gets the specified return type of a function',
'reflectionfunctionabstract::getShortName' => 'Gets function short name',
'reflectionfunctionabstract::getStartLine' => 'Gets starting line number',
'reflectionfunctionabstract::getStaticVariables' => 'Gets static variables',
'reflectionfunctionabstract::hasReturnType' => 'Checks if the function has a specified return type',
'reflectionfunctionabstract::inNamespace' => 'Checks if function in namespace',
'reflectionfunctionabstract::isClosure' => 'Checks if closure',
'reflectionfunctionabstract::isDeprecated' => 'Checks if deprecated',
'reflectionfunctionabstract::isGenerator' => 'Returns whether this function is a generator',
'reflectionfunctionabstract::isInternal' => 'Checks if is internal',
'reflectionfunctionabstract::isUserDefined' => 'Checks if user defined',
'reflectionfunctionabstract::isVariadic' => 'Checks if the function is variadic',
'reflectionfunctionabstract::returnsReference' => 'Checks if returns reference',
'reflectiongenerator::__construct' => 'Constructs a ReflectionGenerator object',
'reflectiongenerator::getExecutingFile' => 'Gets the file name of the currently executing generator',
'reflectiongenerator::getExecutingGenerator' => 'Gets the executing Generator object',
'reflectiongenerator::getExecutingLine' => 'Gets the currently executing line of the generator',
'reflectiongenerator::getFunction' => 'Gets the function name of the generator',
'reflectiongenerator::getThis' => 'Gets the $this value of the generator',
'reflectiongenerator::getTrace' => 'Gets the trace of the executing generator',
'ReflectionMethod::__clone' => 'Clones function',
'reflectionmethod::__construct' => 'Constructs a ReflectionMethod',
'reflectionmethod::__toString' => 'Returns the string representation of the Reflection method object',
'reflectionmethod::export' => 'Export a reflection method',
'reflectionmethod::getClosure' => 'Returns a dynamically created closure for the method',
'ReflectionMethod::getClosureScopeClass' => 'Returns the scope associated to the closure',
'ReflectionMethod::getClosureThis' => 'Returns this pointer bound to closure',
'reflectionmethod::getDeclaringClass' => 'Gets declaring class for the reflected method',
'ReflectionMethod::getDocComment' => 'Gets doc comment',
'ReflectionMethod::getEndLine' => 'Gets end line number',
'ReflectionMethod::getExtension' => 'Gets extension info',
'ReflectionMethod::getExtensionName' => 'Gets extension name',
'ReflectionMethod::getFileName' => 'Gets file name',
'reflectionmethod::getModifiers' => 'Gets the method modifiers',
'ReflectionMethod::getName' => 'Gets function name',
'ReflectionMethod::getNamespaceName' => 'Gets namespace name',
'ReflectionMethod::getNumberOfParameters' => 'Gets number of parameters',
'ReflectionMethod::getNumberOfRequiredParameters' => 'Gets number of required parameters',
'ReflectionMethod::getParameters' => 'Gets parameters',
'reflectionmethod::getPrototype' => 'Gets the method prototype (if there is one)',
'ReflectionMethod::getReturnType' => 'Gets the specified return type of a function',
'ReflectionMethod::getShortName' => 'Gets function short name',
'ReflectionMethod::getStartLine' => 'Gets starting line number',
'ReflectionMethod::getStaticVariables' => 'Gets static variables',
'ReflectionMethod::hasReturnType' => 'Checks if the function has a specified return type',
'ReflectionMethod::inNamespace' => 'Checks if function in namespace',
'reflectionmethod::invoke' => 'Invoke',
'reflectionmethod::invokeArgs' => 'Invoke args',
'reflectionmethod::isAbstract' => 'Checks if method is abstract',
'ReflectionMethod::isClosure' => 'Checks if closure',
'reflectionmethod::isConstructor' => 'Checks if method is a constructor',
'ReflectionMethod::isDeprecated' => 'Checks if deprecated',
'reflectionmethod::isDestructor' => 'Checks if method is a destructor',
'reflectionmethod::isFinal' => 'Checks if method is final',
'ReflectionMethod::isGenerator' => 'Returns whether this function is a generator',
'ReflectionMethod::isInternal' => 'Checks if is internal',
'reflectionmethod::isPrivate' => 'Checks if method is private',
'reflectionmethod::isProtected' => 'Checks if method is protected',
'reflectionmethod::isPublic' => 'Checks if method is public',
'reflectionmethod::isStatic' => 'Checks if method is static',
'ReflectionMethod::isUserDefined' => 'Checks if user defined',
'ReflectionMethod::isVariadic' => 'Checks if the function is variadic',
'ReflectionMethod::returnsReference' => 'Checks if returns reference',
'reflectionmethod::setAccessible' => 'Set method accessibility',
'ReflectionNamedType::__toString' => 'To string',
'ReflectionNamedType::allowsNull' => 'Checks if null is allowed',
'reflectionnamedtype::getName' => 'Get the text of the type hint',
'ReflectionNamedType::isBuiltin' => 'Checks if it is a built-in type',
'ReflectionObject::__clone' => 'Clones object',
'reflectionobject::__construct' => 'Constructs a ReflectionObject',
'ReflectionObject::__toString' => 'Returns the string representation of the ReflectionClass object',
'reflectionobject::export' => 'Export',
'ReflectionObject::getConstant' => 'Gets defined constant',
'ReflectionObject::getConstants' => 'Gets constants',
'ReflectionObject::getConstructor' => 'Gets the constructor of the class',
'ReflectionObject::getDefaultProperties' => 'Gets default properties',
'ReflectionObject::getDocComment' => 'Gets doc comments',
'ReflectionObject::getEndLine' => 'Gets end line',
'ReflectionObject::getExtension' => 'Gets a ReflectionExtension object for the extension which defined the class',
'ReflectionObject::getExtensionName' => 'Gets the name of the extension which defined the class',
'ReflectionObject::getFileName' => 'Gets the filename of the file in which the class has been defined',
'ReflectionObject::getInterfaceNames' => 'Gets the interface names',
'ReflectionObject::getInterfaces' => 'Gets the interfaces',
'ReflectionObject::getMethod' => 'Gets a ReflectionMethod for a class method',
'ReflectionObject::getMethods' => 'Gets an array of methods',
'ReflectionObject::getModifiers' => 'Gets the class modifiers',
'ReflectionObject::getName' => 'Gets class name',
'ReflectionObject::getNamespaceName' => 'Gets namespace name',
'ReflectionObject::getParentClass' => 'Gets parent class',
'ReflectionObject::getProperties' => 'Gets properties',
'ReflectionObject::getProperty' => 'Gets a ReflectionProperty for a class\'s property',
'ReflectionObject::getReflectionConstant' => 'Gets a ReflectionClassConstant for a class\'s constant',
'ReflectionObject::getReflectionConstants' => 'Gets class constants',
'ReflectionObject::getShortName' => 'Gets short name',
'ReflectionObject::getStartLine' => 'Gets starting line number',
'ReflectionObject::getStaticProperties' => 'Gets static properties',
'ReflectionObject::getStaticPropertyValue' => 'Gets static property value',
'ReflectionObject::getTraitAliases' => 'Returns an array of trait aliases',
'ReflectionObject::getTraitNames' => 'Returns an array of names of traits used by this class',
'ReflectionObject::getTraits' => 'Returns an array of traits used by this class',
'ReflectionObject::hasConstant' => 'Checks if constant is defined',
'ReflectionObject::hasMethod' => 'Checks if method is defined',
'ReflectionObject::hasProperty' => 'Checks if property is defined',
'ReflectionObject::implementsInterface' => 'Implements interface',
'ReflectionObject::inNamespace' => 'Checks if in namespace',
'ReflectionObject::isAbstract' => 'Checks if class is abstract',
'ReflectionObject::isAnonymous' => 'Checks if class is anonymous',
'ReflectionObject::isCloneable' => 'Returns whether this class is cloneable',
'ReflectionObject::isFinal' => 'Checks if class is final',
'ReflectionObject::isInstance' => 'Checks class for instance',
'ReflectionObject::isInstantiable' => 'Checks if the class is instantiable',
'ReflectionObject::isInterface' => 'Checks if the class is an interface',
'ReflectionObject::isInternal' => 'Checks if class is defined internally by an extension, or the core',
'ReflectionObject::isIterable' => 'Check whether this class is iterable',
'ReflectionObject::isIterateable' => 'Alias of ReflectionClass::isIterable',
'ReflectionObject::isSubclassOf' => 'Checks if a subclass',
'ReflectionObject::isTrait' => 'Returns whether this is a trait',
'ReflectionObject::isUserDefined' => 'Checks if user defined',
'ReflectionObject::newInstance' => 'Creates a new class instance from given arguments',
'ReflectionObject::newInstanceArgs' => 'Creates a new class instance from given arguments',
'ReflectionObject::newInstanceWithoutConstructor' => 'Creates a new class instance without invoking the constructor',
'ReflectionObject::setStaticPropertyValue' => 'Sets static property value',
'reflectionparameter::__clone' => 'Clone',
'reflectionparameter::__construct' => 'Construct',
'reflectionparameter::__toString' => 'To string',
'reflectionparameter::allowsNull' => 'Checks if null is allowed',
'reflectionparameter::canBePassedByValue' => 'Returns whether this parameter can be passed by value',
'reflectionparameter::export' => 'Exports',
'reflectionparameter::getClass' => 'Get the type hinted class',
'reflectionparameter::getDeclaringClass' => 'Gets declaring class',
'reflectionparameter::getDeclaringFunction' => 'Gets declaring function',
'reflectionparameter::getDefaultValue' => 'Gets default parameter value',
'reflectionparameter::getDefaultValueConstantName' => 'Returns the default value\'s constant name if default value is constant or null',
'reflectionparameter::getName' => 'Gets parameter name',
'reflectionparameter::getPosition' => 'Gets parameter position',
'reflectionparameter::getType' => 'Gets a parameter\'s type',
'reflectionparameter::hasType' => 'Checks if parameter has a type',
'reflectionparameter::isArray' => 'Checks if parameter expects an array',
'reflectionparameter::isCallable' => 'Returns whether parameter MUST be callable',
'reflectionparameter::isDefaultValueAvailable' => 'Checks if a default value is available',
'reflectionparameter::isDefaultValueConstant' => 'Returns whether the default value of this parameter is a constant',
'reflectionparameter::isOptional' => 'Checks if optional',
'reflectionparameter::isPassedByReference' => 'Checks if passed by reference',
'reflectionparameter::isVariadic' => 'Checks if the parameter is variadic',
'reflectionproperty::__clone' => 'Clone',
'reflectionproperty::__construct' => 'Construct a ReflectionProperty object',
'reflectionproperty::__toString' => 'To string',
'reflectionproperty::export' => 'Export',
'reflectionproperty::getDeclaringClass' => 'Gets declaring class',
'reflectionproperty::getDocComment' => 'Gets the property doc comment',
'reflectionproperty::getModifiers' => 'Gets the property modifiers',
'reflectionproperty::getName' => 'Gets property name',
'ReflectionProperty::getType' => 'Gets property type',
'reflectionproperty::getValue' => 'Gets value',
'ReflectionProperty::hasType' => 'Checks if property has type',
'reflectionproperty::isDefault' => 'Checks if property is a default property',
'ReflectionProperty::isInitialized' => 'Checks if property is initialized',
'reflectionproperty::isPrivate' => 'Checks if property is private',
'reflectionproperty::isProtected' => 'Checks if property is protected',
'reflectionproperty::isPublic' => 'Checks if property is public',
'reflectionproperty::isStatic' => 'Checks if property is static',
'reflectionproperty::setAccessible' => 'Set property accessibility',
'reflectionproperty::setValue' => 'Set property value',
'ReflectionReference::fromArrayElement' => 'Returns ReflectionReference if array element is a reference, null otherwise',
'ReflectionReference::getId' => 'Returns unique identifier for the reference. The return value format is unspecified',
'reflectiontype::__toString' => 'To string',
'reflectiontype::allowsNull' => 'Checks if null is allowed',
'ReflectionType::getName' => 'Get type of the parameter.',
'reflectiontype::isBuiltin' => 'Checks if it is a built-in type',
'reflectionzendextension::__clone' => 'Clone handler',
'reflectionzendextension::__construct' => 'Constructor',
'reflectionzendextension::__toString' => 'To string handler',
'reflectionzendextension::export' => 'Export',
'reflectionzendextension::getAuthor' => 'Gets author',
'reflectionzendextension::getCopyright' => 'Gets copyright',
'reflectionzendextension::getName' => 'Gets name',
'reflectionzendextension::getURL' => 'Gets URL',
'reflectionzendextension::getVersion' => 'Gets version',
'reflector::__toString' => 'To string',
'reflector::export' => 'Exports',
'regexiterator::__construct' => 'Create a new RegexIterator',
'regexiterator::accept' => 'Get accept status',
'RegexIterator::current' => 'Get the current element value',
'regexiterator::getFlags' => 'Get flags',
'RegexIterator::getInnerIterator' => 'Get the inner iterator',
'regexiterator::getMode' => 'Returns operation mode',
'regexiterator::getPregFlags' => 'Returns the regular expression flags',
'regexiterator::getRegex' => 'Returns current regular expression',
'RegexIterator::key' => 'Get the current key',
'RegexIterator::next' => 'Move the iterator forward',
'RegexIterator::rewind' => 'Rewind the iterator',
'regexiterator::setFlags' => 'Sets the flags',
'regexiterator::setMode' => 'Sets the operation mode',
'regexiterator::setPregFlags' => 'Sets the regular expression flags',
'RegexIterator::valid' => 'Check whether the current element is valid',
'register_shutdown_function' => 'Register a function for execution on shutdown',
'register_tick_function' => 'Register a function for execution on each tick',
'rename' => 'Renames a file or directory',
'rename_function' => 'Renames orig_name to new_name in the global function table',
'reset' => 'Set the internal pointer of an array to its first element',
'resourcebundle::count' => 'Get number of elements in the bundle',
'ResourceBundle::create' => 'Create a resource bundle',
'resourcebundle::get' => 'Get data from the bundle',
'resourcebundle::getErrorCode' => 'Get bundle\'s last error code',
'resourcebundle::getErrorMessage' => 'Get bundle\'s last error message',
'resourcebundle::getLocales' => 'Get supported locales',
'restore_error_handler' => 'Restores the previous error handler function',
'restore_exception_handler' => 'Restores the previously defined exception handler function',
'restore_include_path' => 'Restores the value of the include_path configuration option',
'resultObj::__construct' => 'or using the `layerObj`_\'s getResult() method.',
'rewind' => 'Rewind the position of a file pointer',
'rewinddir' => 'Rewind directory handle',
'rmdir' => 'Removes directory',
'round' => 'Rounds a float',
'rpm_close' => 'Closes an RPM file',
'rpm_get_tag' => 'Retrieves a header tag from an RPM file',
'rpm_is_valid' => 'Tests a filename for validity as an RPM file',
'rpm_open' => 'Opens an RPM file',
'rpm_version' => 'Returns a string representing the current version of the rpmreader extension',
'rpmaddtag' => 'Add tag retrieved in query',
'rpmdbinfo' => 'Get information from installed RPM',
'rpmdbsearch' => 'Search RPM packages',
'rpminfo' => 'Get information from a RPM file',
'rpmvercmp' => 'RPM version comparison',
'rrd_create' => 'Creates rrd database file',
'rrd_error' => 'Gets latest error message',
'rrd_fetch' => 'Fetch the data for graph as array',
'rrd_first' => 'Gets the timestamp of the first sample from rrd file',
'rrd_graph' => 'Creates image from a data',
'rrd_info' => 'Gets information about rrd file',
'rrd_last' => 'Gets unix timestamp of the last sample',
'rrd_lastupdate' => 'Gets information about last updated data',
'rrd_restore' => 'Restores the RRD file from XML dump',
'rrd_tune' => 'Tunes some RRD database file header options',
'rrd_update' => 'Updates the RRD database',
'rrd_version' => 'Gets information about underlying rrdtool library',
'rrd_xport' => 'Exports the information about RRD database',
'rrdc_disconnect' => 'Close any outstanding connection to rrd caching daemon',
'rrdcreator::__construct' => 'Creates new RRDCreator instance',
'rrdcreator::addArchive' => 'Adds RRA - archive of data values for each data source',
'rrdcreator::addDataSource' => 'Adds data source definition for RRD database',
'rrdcreator::save' => 'Saves the RRD database to a file',
'rrdgraph::__construct' => 'Creates new RRDGraph instance',
'rrdgraph::save' => 'Saves the result of query into image',
'rrdgraph::saveVerbose' => 'Saves the RRD database query into image and returns the verbose information about generated graph',
'rrdgraph::setOptions' => 'Sets the options for rrd graph export',
'rrdupdater::__construct' => 'Creates new RRDUpdater instance',
'rrdupdater::update' => 'Update the RRD database file',
'rsort' => 'Sort an array in reverse order',
'rtrim' => 'Strip whitespace (or other characters) from the end of a string',
'runkit7_constant_add' => 'Similar to define(), but allows defining in class definitions as well',
'runkit7_constant_redefine' => 'Redefine an already defined constant',
'runkit7_constant_remove' => 'Remove/Delete an already defined constant',
'runkit7_function_add' => 'Add a new function, similar to create_function',
'runkit7_function_copy' => 'Copy a function to a new function name',
'runkit7_function_redefine' => 'Replace a function definition with a new implementation',
'runkit7_function_remove' => 'Remove a function definition',
'runkit7_function_rename' => 'Change a function\'s name',
'runkit7_import' => 'Process a PHP file importing function and class definitions, overwriting where appropriate',
'runkit7_method_add' => 'Dynamically adds a new method to a given class',
'runkit7_method_copy' => 'Copies a method from class to another',
'runkit7_method_redefine' => 'Dynamically changes the code of the given method',
'runkit7_method_remove' => 'Dynamically removes the given method',
'runkit7_method_rename' => 'Dynamically changes the name of the given method',
'runkit7_object_id' => 'Return the integer object handle for given object',
'runkit7_superglobals' => 'Return numerically indexed array of registered superglobals',
'runkit7_zval_inspect' => 'Returns information about the passed in value with data types, reference counts, etc',
'runkit_class_adopt' => 'Convert a base class to an inherited class, add ancestral methods when appropriate',
'runkit_class_emancipate' => 'Convert an inherited class to a base class, removes any method whose scope is ancestral',
'runkit_constant_add' => 'Similar to define(), but allows defining in class definitions as well',
'runkit_constant_redefine' => 'Redefine an already defined constant',
'runkit_constant_remove' => 'Remove/Delete an already defined constant',
'runkit_function_add' => 'Add a new function, similar to create_function',
'runkit_function_copy' => 'Copy a function to a new function name',
'runkit_function_redefine' => 'Replace a function definition with a new implementation',
'runkit_function_remove' => 'Remove a function definition',
'runkit_function_rename' => 'Change a function\'s name',
'runkit_import' => 'Process a PHP file importing function and class definitions, overwriting where appropriate',
'runkit_lint' => 'Check the PHP syntax of the specified php code',
'runkit_lint_file' => 'Check the PHP syntax of the specified file',
'runkit_method_add' => 'Dynamically adds a new method to a given class',
'runkit_method_copy' => 'Copies a method from class to another',
'runkit_method_redefine' => 'Dynamically changes the code of the given method',
'runkit_method_remove' => 'Dynamically removes the given method',
'runkit_method_rename' => 'Dynamically changes the name of the given method',
'runkit_return_value_used' => 'Determines if the current functions return value will be used',
'runkit_sandbox_output_handler' => 'Specify a function to capture and/or process output from a runkit sandbox',
'runkit_superglobals' => 'Return numerically indexed array of registered superglobals',
'RuntimeException::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'RuntimeException::__toString' => 'String representation of the exception',
'RuntimeException::getCode' => 'Gets the Exception code',
'RuntimeException::getFile' => 'Gets the file in which the exception occurred',
'RuntimeException::getLine' => 'Gets the line in which the exception occurred',
'RuntimeException::getMessage' => 'Gets the Exception message',
'RuntimeException::getPrevious' => 'Returns previous Exception',
'RuntimeException::getTrace' => 'Gets the stack trace',
'RuntimeException::getTraceAsString' => 'Gets the stack trace as a string',
'samconnection::__construct' => 'Creates a new connection to a Messaging Server',
'samconnection::commit' => 'Commits (completes) the current unit of work',
'samconnection::connect' => 'Establishes a connection to a Messaging Server',
'samconnection::disconnect' => 'Disconnects from a Messaging Server',
'samconnection::errno' => 'Contains the unique numeric error code of the last executed SAM operation',
'samconnection::error' => 'Contains the text description of the last failed SAM operation',
'samconnection::isConnected' => 'Queries whether a connection is established to a Messaging Server',
'samconnection::peek' => 'Read a message from a queue without removing it from the queue',
'samconnection::peekAll' => 'Read one or more messages from a queue without removing it from the queue',
'samconnection::receive' => 'Receive a message from a queue or subscription',
'samconnection::remove' => 'Remove a message from a queue',
'samconnection::rollback' => 'Cancels (rolls back) an in-flight unit of work',
'samconnection::send' => 'Send a message to a queue or publish an item to a topic',
'samconnection::setDebug' => 'Turn on or off additional debugging output',
'samconnection::subscribe' => 'Create a subscription to a specified topic',
'samconnection::unsubscribe' => 'Cancel a subscription to a specified topic',
'sammessage::__construct' => 'Creates a new Message object',
'sammessage::body' => 'The body of the message',
'sammessage::header' => 'The header properties of the message',
'sapi_windows_cp_conv' => 'Convert string from one codepage to another',
'sapi_windows_cp_get' => 'Get process codepage',
'sapi_windows_cp_is_utf8' => 'Indicates whether the codepage is UTF-8 compatible',
'sapi_windows_cp_set' => 'Set process codepage',
'sapi_windows_generate_ctrl_event' => 'Send a CTRL event to another process',
'sapi_windows_set_ctrl_handler' => 'Set or remove a CTRL event handler',
'sapi_windows_vt100_support' => 'Get or set VT100 support for the specified stream associated to an output buffer of a Windows console.',
'Saxon\SaxonProcessor::__construct' => 'Constructor',
'Saxon\SaxonProcessor::createAtomicValue' => 'Create an Xdm Atomic value from any of the main primitive types (i.e. bool, int, float, double, string)',
'Saxon\SaxonProcessor::newSchemaValidator' => 'Create a {@link SchemaValidator} in the PHP environment. A {@link SchemaValidator} provides capabilities to load and cache XML schema definitions. You can also validate source documents with registered XML schema definitions',
'Saxon\SaxonProcessor::newXPathProcessor' => 'Create an {@link XPathProcessor} in the PHP environment. An {@link XPathProcessor} is used to compile and execute XPath queries',
'Saxon\SaxonProcessor::newXQueryProcessor' => 'Create an {@link XQueryProcessor} in the PHP environment. An {@link XQueryProcessor} is used to compile and execute XQuery queries',
'Saxon\SaxonProcessor::newXsltProcessor' => 'Create an {@link XsltProcessor} in the PHP environment. An {@link XsltProcessor} is used to compile and execute XSLT sytlesheets',
'Saxon\SaxonProcessor::parseXmlFromFile' => 'Create an {@link XdmNode} object.',
'Saxon\SaxonProcessor::parseXmlFromString' => 'Create an {@link XdmNode} object.',
'Saxon\SaxonProcessor::registerPHPFunctions' => 'Enables the ability to use PHP functions as XSLT functions. Accepts as parameter the full path of the Saxon/C PHP Extension library. This is needed to do the callbacks.',
'Saxon\SaxonProcessor::setConfigurationProperty' => 'Set a configuration property specific to the processor in use. Properties specified here are common across all the processors.',
'Saxon\SaxonProcessor::setcwd' => 'Set the current working directory used to resolve against files',
'Saxon\SaxonProcessor::setResourceDirectory' => 'Set the resources directory of where Saxon can locate data folder',
'Saxon\SaxonProcessor::version' => 'Report the Java Saxon version',
'Saxon\SchemaValidator::clearParameters' => 'Clear parameter values set',
'Saxon\SchemaValidator::clearProperties' => 'Clear property values set',
'Saxon\SchemaValidator::exceptionClear' => 'Clear any exception thrown',
'Saxon\SchemaValidator::getErrorCode' => 'Get the $i\'th error code if there are any errors',
'Saxon\SchemaValidator::getErrorMessage' => 'Get the $i\'th error message if there are any errors',
'Saxon\SchemaValidator::getExceptionCount' => 'Get number of error during execution of the validator',
'Saxon\SchemaValidator::getValidationReport' => 'Get the validation report produced after validating the source document. The reporting feature is switched on via setting the property on the {@link SchemaValidator): $validator->setProperty(\'report\', \'true\').',
'Saxon\SchemaValidator::registerSchemaFromFile' => 'Register the Schema which is given as file name.',
'Saxon\SchemaValidator::registerSchemaFromString' => 'Register the Schema which is given as a string representation.',
'Saxon\SchemaValidator::setOutputFile' => 'The instance document to be validated. Supplied file name is resolved and accessed',
'Saxon\SchemaValidator::setParameter' => 'Set the parameters required for XQuery Processor',
'Saxon\SchemaValidator::setProperty' => 'Set properties for Schema Validator.',
'Saxon\SchemaValidator::setSourceNode' => 'The instance document to be validated. Supplied as an Xdm Node',
'Saxon\SchemaValidator::validate' => 'Validate an instance document supplied as a Source object. Assume source document has already been supplied through accessor methods',
'Saxon\SchemaValidator::validateToNode' => 'Validate an instance document supplied as a Source object with the validated document returned to the calling program.',
'Saxon\XdmAtomicValue::addXdmItem' => 'Add item to the sequence at the end.',
'Saxon\XdmAtomicValue::getAtomicValue' => 'Provided the item is an atomic value we return the {@link XdmAtomicValue} otherwise return null',
'Saxon\XdmAtomicValue::getBooleanValue' => 'Get the value converted to a boolean using the XPath casting rules',
'Saxon\XdmAtomicValue::getDoubleValue' => 'Get the value converted to a double using the XPath casting rules. If the value is a string, the XSD 1.1 rules are used, which means that the string "+INF" is recognised',
'Saxon\XdmAtomicValue::getHead' => 'Get the first item in the sequence',
'Saxon\XdmAtomicValue::getLongValue' => 'Get the value converted to an integer using the XPath casting rules',
'Saxon\XdmAtomicValue::getNodeValue' => 'Provided the item is a node value we return the {@link XdmNode} otherwise return null',
'Saxon\XdmAtomicValue::getStringValue' => 'Get the string value of the item. For an atomic value, it has the same effect as casting the value to a string. In all cases the result is the same as applying the XPath string() function.',
'Saxon\XdmAtomicValue::isAtomic' => 'Determine whether the item is an atomic value or a node. Return TRUE if the item is an atomic value',
'Saxon\XdmAtomicValue::isNode' => 'Determine whether the item is a node value or not.',
'Saxon\XdmAtomicValue::itemAt' => 'Get the n\'th item in the value, counting from zero',
'Saxon\XdmAtomicValue::size' => 'Get the number of items in the sequence',
'Saxon\XdmItem::addXdmItem' => 'Add item to the sequence at the end.',
'Saxon\XdmItem::getAtomicValue' => 'Provided the item is an atomic value we return the {@link XdmAtomicValue} otherwise return null',
'Saxon\XdmItem::getHead' => 'Get the first item in the sequence',
'Saxon\XdmItem::getNodeValue' => 'Provided the item is a node value we return the {@link XdmNode} otherwise return null',
'Saxon\XdmItem::getStringValue' => 'Get the string value of the item. For a node, this gets the string value of the node. For an atomic value, it has the same effect as casting the value to a string. In all cases the result is the same as applying the XPath string() function.',
'Saxon\XdmItem::isAtomic' => 'Determine whether the item is an atomic value or not.',
'Saxon\XdmItem::isNode' => 'Determine whether the item is a node value or not.',
'Saxon\XdmItem::itemAt' => 'Get the n\'th item in the value, counting from zero',
'Saxon\XdmItem::size' => 'Get the number of items in the sequence',
'Saxon\XdmNode::addXdmItem' => 'Add item to the sequence at the end.',
'Saxon\XdmNode::getAtomicValue' => 'Provided the item is an atomic value we return the {@link XdmAtomicValue} otherwise return null',
'Saxon\XdmNode::getAttributeCount' => 'Get the count of attribute nodes at this node',
'Saxon\XdmNode::getAttributeNode' => 'Get the n\'th attribute node at this node. If the attribute node selected does not exist then return null',
'Saxon\XdmNode::getAttributeValue' => 'Get the n\'th attribute node value at this node. If the attribute node selected does not exist then return null',
'Saxon\XdmNode::getChildCount' => 'Get the count of child node at this current node',
'Saxon\XdmNode::getChildNode' => 'Get the n\'th child node at this node. If the child node selected does not exist then return null',
'Saxon\XdmNode::getHead' => 'Get the first item in the sequence',
'Saxon\XdmNode::getNodeKind' => 'Get the kind of node',
'Saxon\XdmNode::getNodeName' => 'Get the name of the node, as a EQName',
'Saxon\XdmNode::getNodeValue' => 'Provided the item is a node value we return the {@link XdmNode} otherwise return null',
'Saxon\XdmNode::getParent' => 'Get the parent of this node. If parent node does not exist then return null',
'Saxon\XdmNode::getStringValue' => 'Get the string value of the item. For a node, this gets the string value of the node.',
'Saxon\XdmNode::isAtomic' => 'Determine whether the item is an atomic value or a node. This method will return FALSE as the item is not atomic',
'Saxon\XdmNode::isNode' => 'Determine whether the item is a node value or not.',
'Saxon\XdmNode::itemAt' => 'Get the n\'th item in the value, counting from zero',
'Saxon\XdmNode::size' => 'Get the number of items in the sequence',
'Saxon\XdmValue::addXdmItem' => 'Add item to the sequence at the end.',
'Saxon\XdmValue::getHead' => 'Get the first item in the sequence',
'Saxon\XdmValue::itemAt' => 'Get the n\'th item in the value, counting from zero',
'Saxon\XdmValue::size' => 'Get the number of items in the sequence',
'Saxon\XPathProcessor::clearParameters' => 'Clear parameter values set',
'Saxon\XPathProcessor::clearProperties' => 'Clear property values set',
'Saxon\XPathProcessor::declareNamespace' => 'Declare a namespace binding as part of the static context for XPath expressions compiled using this {@link XPathProcessor}',
'Saxon\XPathProcessor::effectiveBooleanValue' => 'Evaluate the XPath expression, returning the effective boolean value of the result.',
'Saxon\XPathProcessor::evaluate' => 'Compile and evaluate an XPath expression, supplied as a character string. Result is an {@link XdmValue}',
'Saxon\XPathProcessor::evaluateSingle' => 'Compile and evaluate an XPath expression whose result is expected to be a single item, with a given context item. The expression is supplied as a character string.',
'Saxon\XPathProcessor::exceptionClear' => 'Clear any exception thrown',
'Saxon\XPathProcessor::getErrorCode' => 'Get the $i\'th error code if there are any errors',
'Saxon\XPathProcessor::getErrorMessage' => 'Get the $i\'th error message if there are any errors',
'Saxon\XPathProcessor::getExceptionCount' => 'Get number of error during execution or evaluate of stylesheet and query, respectively',
'Saxon\XPathProcessor::setBaseURI' => 'Set the static base URI for XPath expressions compiled using this XQuery Processor. The base URI is part of the static context, and is used to resolve any relative URIS appearing within a query',
'Saxon\XPathProcessor::setContextFile' => 'Set the context item from file',
'Saxon\XPathProcessor::setContextItem' => 'Set the context item from a {@link XdmItem}',
'Saxon\XPathProcessor::setParameter' => 'Set the parameters required for XQuery Processor',
'Saxon\XPathProcessor::setProperty' => 'Set properties for Query.',
'Saxon\XQueryProcessor::clearParameters' => 'Clear parameter values set',
'Saxon\XQueryProcessor::clearProperties' => 'Clear property values set',
'Saxon\XQueryProcessor::declareNamespace' => 'Declare a namespace binding as part of the static context for XPath expressions compiled using this XQuery processor',
'Saxon\XQueryProcessor::exceptionClear' => 'Clear any exception thrown',
'Saxon\XQueryProcessor::getErrorCode' => 'Get the $i\'th error code if there are any errors',
'Saxon\XQueryProcessor::getErrorMessage' => 'Get the $i\'th error message if there are any errors',
'Saxon\XQueryProcessor::getExceptionCount' => 'Get number of error during execution or evaluate of query',
'Saxon\XQueryProcessor::runQueryToFile' => 'Compile and evaluate the query. Save the result to file',
'Saxon\XQueryProcessor::runQueryToString' => 'Compile and evaluate the query. Result returned as string. If there are failures then a null is returned',
'Saxon\XQueryProcessor::runQueryToValue' => 'Compile and evaluate the query. Result returned as an XdmValue object. If there are failures then a null is returned',
'Saxon\XQueryProcessor::setContextItem' => 'Set the initial context item for the query.
Any one of the objects are accepted: {@link XdmValue}, {@link XdmItem}, {@link XdmNode} and {@link XdmAtomicValue}.',
'Saxon\XQueryProcessor::setContextItemFromFile' => 'Set the initial context item for the query. Supplied as filename',
'Saxon\XQueryProcessor::setParameter' => 'Set the parameters required for XQuery Processor',
'Saxon\XQueryProcessor::setProperty' => 'Set properties for Query.',
'Saxon\XQueryProcessor::setQueryBaseURI' => 'Set the static base URI for a query expressions compiled using this XQuery Processor. The base URI is part of the static context, and is used to resolve any relative URIS appearing within a query',
'Saxon\XQueryProcessor::setQueryContent' => 'query supplied as a string',
'Saxon\XQueryProcessor::setQueryFile' => 'query supplied as a file',
'Saxon\XsltProcessor::clearParameters' => 'Clear parameter values set',
'Saxon\XsltProcessor::clearProperties' => 'Clear property values set',
'Saxon\XsltProcessor::compileFromFile' => 'Compile a stylesheet supplied by file name',
'Saxon\XsltProcessor::compileFromString' => 'Compile a stylesheet received as a string.',
'Saxon\XsltProcessor::compileFromValue' => 'Compile a stylesheet received as an {@link XdmNode}.',
'Saxon\XsltProcessor::exceptionClear' => 'Clear any exception thrown',
'Saxon\XsltProcessor::getErrorCode' => 'Get the $i\'th error code if there are any errors',
'Saxon\XsltProcessor::getErrorMessage' => 'Get the $i\'th error message if there are any errors',
'Saxon\XsltProcessor::getExceptionCount' => 'Get number of error during execution or evaluate of stylesheet',
'Saxon\XsltProcessor::setOutputFile' => 'Set the output file name of where the transformation result is sent',
'Saxon\XsltProcessor::setParameter' => 'Set the parameters required for XSLT stylesheet',
'Saxon\XsltProcessor::setProperty' => 'Set properties for the stylesheet.',
'Saxon\XsltProcessor::setSourceFromFile' => 'The source used for a query or stylesheet. Requires a file name as string',
'Saxon\XsltProcessor::setSourceFromXdmValue' => 'The source used for a query or stylesheet. Requires an {@link XdmValue} object',
'Saxon\XsltProcessor::transformFileToFile' => 'Perform a one shot transformation. The result is stored in the supplied outputfile name.',
'Saxon\XsltProcessor::transformFileToString' => 'Perform a one shot transformation. The result is returned as a string. If there are failures then a null is returned.',
'Saxon\XsltProcessor::transformFileToValue' => 'Perform a one shot transformation. The result is returned as an {@link XdmValue}.',
'Saxon\XsltProcessor::transformToFile' => 'Perform the transformation based upon cached stylesheet and source document.',
'Saxon\XsltProcessor::transformToValue' => 'Perform the transformation based upon cached stylesheet and any source document. Result returned as an {@link XdmValue} object. If there are failures then a null is returned',
'sca::createDataObject' => 'Create an SDO',
'sca::getService' => 'Obtain a proxy for a service',
'sca_localproxy::createDataObject' => 'Create an SDO',
'sca_soapproxy::createDataObject' => 'Create an SDO',
'scalebarObj::convertToString' => 'Saves the object to a string.  Provides the inverse option for
updateFromString.',
'scalebarObj::free' => 'Free the object properties and break the internal references.
Note that you have to unset the php variable to free totally the
resources.',
'scalebarObj::set' => 'Set object property to a new value.',
'scalebarObj::setImageColor' => 'Sets the imagecolor property (baclground) of the object.
Returns MS_SUCCESS or MS_FAILURE on error.',
'scalebarObj::updateFromString' => 'Update a scalebar from a string snippet. Returns MS_SUCCESS/MS_FAILURE.',
'scandir' => 'List files and directories inside the specified path',
'scoutapm_get_calls' => 'Returns a list of instrumented calls that have occurred',
'scoutapm_list_instrumented_functions' => 'List functions scoutapm will instrument.',
'sdo_das_changesummary::beginLogging' => 'Begin change logging',
'sdo_das_changesummary::endLogging' => 'End change logging',
'sdo_das_changesummary::getChangedDataObjects' => 'Get the changed data objects from a change summary',
'sdo_das_changesummary::getChangeType' => 'Get the type of change made to an SDO_DataObject',
'sdo_das_changesummary::getOldContainer' => 'Get the old container for a deleted SDO_DataObject',
'sdo_das_changesummary::getOldValues' => 'Get the old values for a given changed SDO_DataObject',
'sdo_das_changesummary::isLogging' => 'Test to see whether change logging is switched on',
'sdo_das_datafactory::addPropertyToType' => 'Adds a property to a type',
'sdo_das_datafactory::addType' => 'Add a new type to a model',
'sdo_das_datafactory::getDataFactory' => 'Get a data factory instance',
'sdo_das_dataobject::getChangeSummary' => 'Get a data object\'s change summary',
'sdo_das_relational::__construct' => 'Creates an instance of a Relational Data Access Service',
'sdo_das_relational::applyChanges' => 'Applies the changes made to a data graph back to the database',
'sdo_das_relational::createRootDataObject' => 'Returns the special root object in an otherwise empty data graph. Used when creating a data graph from scratch',
'sdo_das_relational::executePreparedQuery' => 'Executes an SQL query passed as a prepared statement, with a list of values to substitute for placeholders, and return the results as a normalised data graph',
'sdo_das_relational::executeQuery' => 'Executes a given SQL query against a relational database and returns the results as a normalised data graph',
'sdo_das_setting::getListIndex' => 'Get the list index for a changed many-valued property',
'sdo_das_setting::getPropertyIndex' => 'Get the property index for a changed property',
'sdo_das_setting::getPropertyName' => 'Get the property name for a changed property',
'sdo_das_setting::getValue' => 'Get the old value for the changed property',
'sdo_das_setting::isSet' => 'Test whether a property was set prior to being modified',
'sdo_das_xml::addTypes' => 'To load a second or subsequent schema file to a SDO_DAS_XML object',
'sdo_das_xml::create' => 'To create SDO_DAS_XML object for a given schema file',
'sdo_das_xml::createDataObject' => 'Creates SDO_DataObject for a given namespace URI and type name',
'sdo_das_xml::createDocument' => 'Creates an XML Document object from scratch, without the need to load a document from a file or string',
'sdo_das_xml::loadFile' => 'Returns SDO_DAS_XML_Document object for a given path to xml instance document',
'sdo_das_xml::loadString' => 'Returns SDO_DAS_XML_Document for a given xml instance string',
'sdo_das_xml::saveFile' => 'Saves the SDO_DAS_XML_Document object to a file',
'sdo_das_xml::saveString' => 'Saves the SDO_DAS_XML_Document object to a string',
'sdo_das_xml_document::getRootDataObject' => 'Returns the root SDO_DataObject',
'sdo_das_xml_document::getRootElementName' => 'Returns root element\'s name',
'sdo_das_xml_document::getRootElementURI' => 'Returns root element\'s URI string',
'sdo_das_xml_document::setEncoding' => 'Sets the given string as encoding',
'sdo_das_xml_document::setXMLDeclaration' => 'Sets the xml declaration',
'sdo_das_xml_document::setXMLVersion' => 'Sets the given string as xml version',
'sdo_datafactory::create' => 'Create an SDO_DataObject',
'sdo_dataobject::clear' => 'Clear an SDO_DataObject\'s properties',
'sdo_dataobject::createDataObject' => 'Create a child SDO_DataObject',
'sdo_dataobject::getContainer' => 'Get a data object\'s container',
'sdo_dataobject::getSequence' => 'Get the sequence for a data object',
'sdo_dataobject::getTypeName' => 'Return the name of the type for a data object',
'sdo_dataobject::getTypeNamespaceURI' => 'Return the namespace URI of the type for a data object',
'sdo_exception::getCause' => 'Get the cause of the exception',
'sdo_list::insert' => 'Insert into a list',
'sdo_model_property::getContainingType' => 'Get the SDO_Model_Type which contains this property',
'sdo_model_property::getDefault' => 'Get the default value for the property',
'sdo_model_property::getName' => 'Get the name of the SDO_Model_Property',
'sdo_model_property::getType' => 'Get the SDO_Model_Type of the property',
'sdo_model_property::isContainment' => 'Test to see if the property defines a containment relationship',
'sdo_model_property::isMany' => 'Test to see if the property is many-valued',
'sdo_model_reflectiondataobject::__construct' => 'Construct an SDO_Model_ReflectionDataObject',
'sdo_model_reflectiondataobject::export' => 'Get a string describing the SDO_DataObject',
'sdo_model_reflectiondataobject::getContainmentProperty' => 'Get the property which defines the containment relationship to the data object',
'sdo_model_reflectiondataobject::getInstanceProperties' => 'Get the instance properties of the SDO_DataObject',
'sdo_model_reflectiondataobject::getType' => 'Get the SDO_Model_Type for the SDO_DataObject',
'sdo_model_type::getBaseType' => 'Get the base type for this type',
'sdo_model_type::getName' => 'Get the name of the type',
'sdo_model_type::getNamespaceURI' => 'Get the namespace URI of the type',
'sdo_model_type::getProperties' => 'Get the SDO_Model_Property objects defined for the type',
'sdo_model_type::getProperty' => 'Get an SDO_Model_Property of the type',
'sdo_model_type::isAbstractType' => 'Test to see if this SDO_Model_Type is an abstract data type',
'sdo_model_type::isDataType' => 'Test to see if this SDO_Model_Type is a primitive data type',
'sdo_model_type::isInstance' => 'Test for an SDO_DataObject being an instance of this SDO_Model_Type',
'sdo_model_type::isOpenType' => 'Test to see if this type is an open type',
'sdo_model_type::isSequencedType' => 'Test to see if this is a sequenced type',
'sdo_sequence::getProperty' => 'Return the property for the specified sequence index',
'sdo_sequence::insert' => 'Insert into a sequence',
'sdo_sequence::move' => 'Move an item to another sequence position',
'seaslog::alert' => 'Record alert log information',
'seaslog::analyzerCount' => 'Get log count by level, log_path and key_word',
'seaslog::analyzerDetail' => 'Get log detail by level, log_path, key_word, start, limit, order',
'seaslog::closeLoggerStream' => 'Manually release stream flow from logger',
'seaslog::critical' => 'Record critical log information',
'seaslog::debug' => 'Record debug log information',
'seaslog::emergency' => 'Record emergency log information',
'seaslog::error' => 'Record error log information',
'seaslog::flushBuffer' => 'Flush logs buffer, dump to appender file, or send to remote api with tcp/udp',
'seaslog::getBasePath' => 'Get SeasLog base path.',
'seaslog::getBuffer' => 'Get the logs buffer in memory as array',
'seaslog::getBufferEnabled' => 'Determine if buffer enabled',
'seaslog::getDatetimeFormat' => 'Get SeasLog datetime format style',
'seaslog::getLastLogger' => 'Get SeasLog last logger path',
'seaslog::getRequestID' => 'Get SeasLog request_id differentiated requests',
'seaslog::getRequestVariable' => 'Get SeasLog request variable',
'seaslog::info' => 'Record info log information',
'seaslog::log' => 'The Common Record Log Function',
'seaslog::notice' => 'Record notice log information',
'seaslog::setBasePath' => 'Set SeasLog base path',
'seaslog::setDatetimeFormat' => 'Set SeasLog datetime format style',
'seaslog::setLogger' => 'Set SeasLog logger name',
'seaslog::setRequestID' => 'Set SeasLog request_id differentiated requests',
'seaslog::setRequestVariable' => 'Manually set SeasLog request variable',
'seaslog::warning' => 'Record warning log information',
'seaslog_get_author' => 'Get SeasLog author.',
'seaslog_get_version' => 'Get SeasLog version.',
'SeekableIterator::current' => 'Return the current element',
'SeekableIterator::key' => 'Return the key of the current element',
'SeekableIterator::next' => 'Move forward to next element',
'SeekableIterator::rewind' => 'Rewind the Iterator to the first element',
'seekableiterator::seek' => 'Seeks to a position',
'SeekableIterator::valid' => 'Checks if current position is valid',
'sem_acquire' => 'Acquire a semaphore',
'sem_get' => 'Get a semaphore id',
'sem_release' => 'Release a semaphore',
'sem_remove' => 'Remove a semaphore',
'Serializable::serialize' => 'String representation of object',
'Serializable::unserialize' => 'Constructs the object',
'serialize' => 'Generates a storable representation of a value',
'session_abort' => 'Discard session array changes and finish session',
'session_cache_expire' => 'Return current cache expire',
'session_cache_limiter' => 'Get and/or set the current cache limiter',
'session_commit' => 'Alias of session_write_close',
'session_create_id' => 'Create new session id',
'session_decode' => 'Decodes session data from a session encoded string',
'session_destroy' => 'Destroys all data registered to a session',
'session_encode' => 'Encodes the current session data as a session encoded string',
'session_gc' => 'Perform session data garbage collection',
'session_get_cookie_params' => 'Get the session cookie parameters',
'session_id' => 'Get and/or set the current session id',
'session_is_registered' => 'Find out whether a global variable is registered in a session',
'session_module_name' => 'Get and/or set the current session module',
'session_name' => 'Get and/or set the current session name',
'session_pgsql_add_error' => 'Increments error counts and sets last error message',
'session_pgsql_get_error' => 'Returns number of errors and last error message',
'session_pgsql_get_field' => 'Get custom field value',
'session_pgsql_reset' => 'Reset connection to session database servers',
'session_pgsql_set_field' => 'Set custom field value',
'session_pgsql_status' => 'Get current save handler status',
'session_regenerate_id' => 'Update the current session id with a newly generated one',
'session_register' => 'Register one or more global variables with the current session',
'session_register_shutdown' => 'Session shutdown function',
'session_reset' => 'Re-initialize session array with original values',
'session_save_path' => 'Get and/or set the current session save path',
'session_set_cookie_params' => 'Set the session cookie parameters',
'session_set_save_handler' => 'Sets user-level session storage functions',
'session_start' => 'Start new or resume existing session',
'session_status' => 'Returns the current session status',
'session_unregister' => 'Unregister a global variable from the current session',
'session_unset' => 'Free all session variables',
'session_write_close' => 'Write session data and end session',
'sessionhandler::close' => 'Close the session',
'sessionhandler::create_sid' => 'Return a new session ID',
'sessionhandler::destroy' => 'Destroy a session',
'sessionhandler::gc' => 'Cleanup old sessions',
'sessionhandler::open' => 'Initialize session',
'sessionhandler::read' => 'Read session data',
'SessionHandler::updateTimestamp' => 'Update timestamp of a session',
'SessionHandler::validateId' => 'Validate session id',
'sessionhandler::write' => 'Write session data',
'sessionhandlerinterface::close' => 'Close the session',
'sessionhandlerinterface::destroy' => 'Destroy a session',
'sessionhandlerinterface::gc' => 'Cleanup old sessions',
'sessionhandlerinterface::open' => 'Initialize session',
'sessionhandlerinterface::read' => 'Read session data',
'sessionhandlerinterface::write' => 'Write session data',
'sessionidinterface::create_sid' => 'Create session ID',
'sessionupdatetimestamphandlerinterface::updateTimestamp' => 'Update timestamp',
'sessionupdatetimestamphandlerinterface::validateId' => 'Validate ID',
'set_error_handler' => 'Sets a user-defined error handler function',
'set_exception_handler' => 'Sets a user-defined exception handler function',
'set_file_buffer' => 'Alias of stream_set_write_buffer',
'set_include_path' => 'Sets the include_path configuration option',
'set_job_failed' => 'causes a job to fail logically
can be used to indicate an error in the script logic (e.g. database connection problem)',
'set_magic_quotes_runtime' => 'Sets the current active configuration setting of magic_quotes_runtime',
'set_socket_blocking' => 'Alias of stream_set_blocking',
'set_time_limit' => 'Limits the maximum execution time',
'setcookie' => 'Send a cookie',
'setlocale' => 'Set locale information',
'setproctitle' => 'Set the process title',
'setrawcookie' => 'Send a cookie without urlencoding the cookie value',
'setthreadtitle' => 'Set the thread title',
'settype' => 'Set the type of a variable',
'sha1' => 'Calculate the sha1 hash of a string',
'sha1_file' => 'Calculate the sha1 hash of a file',
'sha256' => 'Calculate the sha256 hash of a string',
'sha256_file' => 'Calculate the sha256 hash of given filename',
'shapefileObj::__construct' => 'Opens a shapefile and returns a new object to deal with it. Filename
should be passed with no extension.  To create a new file (or
overwrite an existing one), type should be one of MS_SHP_POINT,
MS_SHP_ARC, MS_SHP_POLYGON or MS_SHP_MULTIPOINT. Pass type as -1 to
open an existing file for read-only access, and type=-2 to open an
existing file for update (append).',
'shapefileObj::addPoint' => 'Appends a point to an open shapefile.',
'shapefileObj::addShape' => 'Appends a shape to an open shapefile.',
'shapefileObj::free' => 'Free the object properties and break the internal references.
Note that you have to unset the php variable to free totally the
resources.
.. note::
The shape file is closed (and changes committed) when
the object is destroyed. You can explicitly close and save
the changes by calling $shapefile->free();
unset($shapefile), which will also free the php object.',
'shapefileObj::getExtent' => 'Retrieve a shape\'s bounding box by index.',
'shapefileObj::getPoint' => 'Retrieve point by index.',
'shapefileObj::getShape' => 'Retrieve shape by index.',
'shapefileObj::getTransformed' => 'Retrieve shape by index.',
'shapefileObj::ms_newShapefileObj' => 'Old style constructor',
'shapeObj::__construct' => '\'type\' is one of MS_SHAPE_POINT, MS_SHAPE_LINE, MS_SHAPE_POLYGON or
MS_SHAPE_NULL
Creates new shape object from WKT string.',
'shapeObj::add' => 'Add a line (i.e. a part) to the shape.',
'shapeObj::boundary' => 'Returns the boundary of the shape.
Only available if php/mapscript is built with GEOS library.
shapeObj buffer(width)
Returns a new buffered shapeObj based on the supplied distance (given
in the coordinates of the existing shapeObj).
Only available if php/mapscript is built with GEOS library.',
'shapeObj::contains' => 'Returns MS_TRUE if the point is inside the shape, MS_FALSE otherwise.',
'shapeObj::containsShape' => 'Returns true if shape2 passed as argument is entirely within the shape.
Else return false.
Only available if php/mapscript is built with GEOS
library.',
'shapeObj::convexhull' => 'Returns a shape object representing the convex hull of shape.
Only available if php/mapscript is built with GEOS
library.',
'shapeObj::crosses' => 'Returns true if the shape passed as argument crosses the shape.
Else return false.
Only available if php/mapscript is built with GEOS library.',
'shapeObj::difference' => 'Returns a shape object representing the difference of the
shape object with the one passed as parameter.
Only available if php/mapscript is built with GEOS library.',
'shapeObj::disjoint' => 'Returns true if the shape passed as argument is disjoint to the
shape. Else return false.
Only available if php/mapscript is built with GEOS library.',
'shapeObj::draw' => 'Draws the individual shape using layer.
Returns MS_SUCCESS/MS_FAILURE.',
'shapeObj::equals' => 'Returns true if the shape passed as argument is equal to the
shape (geometry only). Else return false.
Only available if php/mapscript is built with GEOS library.',
'shapeObj::free' => 'Free the object properties and break the internal references.
Note that you have to unset the php variable to free totally the resources.',
'shapeObj::getArea' => 'Returns the area of the shape (if applicable).
Only available if php/mapscript is built with GEOS library.',
'shapeObj::getCentroid' => 'Returns a point object representing the centroid of the shape.
Only available if php/mapscript is built with GEOS library.',
'shapeObj::getLabelPoint' => 'Returns a point object with coordinates suitable for labelling
the shape.',
'shapeObj::getLength' => 'Returns the length (or perimeter) of the shape.
Only available if php/mapscript is built with GEOS library.
pointObj  getMeasureUsingPoint(pointObj point)
Apply only on Measured shape files. Given an XY Location, find the
nearest point on the shape object. Return a point object
of this point with the m value set.',
'shapeObj::getPointUsingMeasure' => 'Apply only on Measured shape files. Given a measure m, return the
corresponding XY location on the shapeobject.',
'shapeObj::getValue' => 'Returns the value for a given field name.',
'shapeObj::intersection' => 'Returns a shape object representing the intersection of the shape
object with the one passed as parameter.
Only available if php/mapscript is built with GEOS library.',
'shapeObj::intersects' => 'Returns MS_TRUE if the two shapes intersect, MS_FALSE otherwise.',
'shapeObj::line' => 'Returns a reference to line number i.',
'shapeObj::ms_shapeObjFromWkt' => 'Old style constructor',
'shapeObj::overlaps' => 'Returns true if the shape passed as argument overlaps the shape.
Else returns false.
Only available if php/mapscript is built with GEOS library.',
'shapeObj::project' => 'Project the shape from "in" projection (1st argument) to "out"
projection (2nd argument).  Returns MS_SUCCESS/MS_FAILURE.',
'shapeObj::set' => 'Set object property to a new value.',
'shapeObj::setBounds' => 'Updates the bounds property of the shape.
Must be called to calculate new bounding box after new parts have been
added.',
'shapeObj::simplify' => 'Given a tolerance, returns a simplified shape object or NULL on
error.  Only available if php/mapscript is built with GEOS library
(>=3.0).',
'shapeObj::symdifference' => 'Returns the computed symmetric difference of the supplied and
existing shape.
Only available if php/mapscript is built with GEOS library.',
'shapeObj::topologyPreservingSimplify' => 'Given a tolerance, returns a simplified shape object or NULL on
error.  Only available if php/mapscript is built with GEOS library
(>=3.0).',
'shapeObj::touches' => 'Returns true if the shape passed as argument touches the shape.
Else return false.
Only available if php/mapscript is built with GEOS library.',
'shapeObj::toWkt' => 'Returns WKT representation of the shape\'s geometry.',
'shapeObj::union' => 'Returns a shape object representing the union of the shape object
with the one passed as parameter.
Only available if php/mapscript is built with GEOS
library',
'shapeObj::within' => 'Returns true if the shape is entirely within the shape2 passed as
argument.
Else returns false.
Only available if php/mapscript is built with GEOS library.',
'shell_exec' => 'Execute command via shell and return the complete output as a string',
'shm_attach' => 'Creates or open a shared memory segment',
'shm_detach' => 'Disconnects from shared memory segment',
'shm_get_var' => 'Returns a variable from shared memory',
'shm_has_var' => 'Check whether a specific entry exists',
'shm_put_var' => 'Inserts or updates a variable in shared memory',
'shm_remove' => 'Removes shared memory from Unix systems',
'shm_remove_var' => 'Removes a variable from shared memory',
'shmop_close' => 'Close shared memory block',
'shmop_delete' => 'Delete shared memory block',
'shmop_open' => 'Create or open shared memory block',
'shmop_read' => 'Read data from shared memory block',
'shmop_size' => 'Get size of shared memory block',
'shmop_write' => 'Write data into shared memory block',
'show_source' => 'Alias of highlight_file',
'shuffle' => 'Shuffle an array',
'similar_text' => 'Calculate the similarity between two strings',
'simplexml_import_dom' => 'Get a SimpleXMLElement object from a DOM node',
'simplexml_load_file' => 'Interprets an XML file into an object',
'simplexml_load_string' => 'Interprets a string of XML into an object',
'simplexmlelement::__construct' => 'Creates a new SimpleXMLElement object',
'SimpleXMLElement::__get' => 'Provides access to element\'s children',
'simplexmlelement::__toString' => 'Returns the string content',
'simplexmlelement::addAttribute' => 'Adds an attribute to the SimpleXML element',
'simplexmlelement::addChild' => 'Adds a child element to the XML node',
'simplexmlelement::asXML' => 'Return a well-formed XML string based on SimpleXML element',
'simplexmlelement::attributes' => 'Identifies an element\'s attributes',
'simplexmlelement::children' => 'Finds children of given node',
'simplexmlelement::count' => 'Counts the children of an element',
'simplexmlelement::getDocNamespaces' => 'Returns namespaces declared in document',
'simplexmlelement::getName' => 'Gets the name of the XML element',
'simplexmlelement::getNamespaces' => 'Returns namespaces used in document',
'SimpleXMLElement::offsetExists' => 'Class provides access to children by position, and attributes by name',
'SimpleXMLElement::offsetGet' => 'Class provides access to children by position, and attributes by name',
'SimpleXMLElement::offsetSet' => 'Class provides access to children by position, and attributes by name',
'SimpleXMLElement::offsetUnset' => 'Class provides access to children by position, and attributes by name',
'simplexmlelement::registerXPathNamespace' => 'Creates a prefix/ns context for the next XPath query',
'simplexmlelement::saveXML' => 'Alias of SimpleXMLElement::asXML',
'simplexmlelement::xpath' => 'Runs XPath query on XML data',
'SimpleXMLIterator::__toString' => 'Returns the string content',
'SimpleXMLIterator::addAttribute' => 'Adds an attribute to the SimpleXML element',
'SimpleXMLIterator::addChild' => 'Adds a child element to the XML node',
'SimpleXMLIterator::asXML' => 'Return a well-formed XML string based on SimpleXML element',
'SimpleXMLIterator::attributes' => 'Identifies an element\'s attributes',
'SimpleXMLIterator::children' => 'Finds children of given node',
'SimpleXMLIterator::count' => 'Counts the children of an element',
'simplexmliterator::current' => 'Returns the current element',
'simplexmliterator::getChildren' => 'Returns the sub-elements of the current element',
'SimpleXMLIterator::getDocNamespaces' => 'Returns namespaces declared in document',
'SimpleXMLIterator::getName' => 'Gets the name of the XML element',
'SimpleXMLIterator::getNamespaces' => 'Returns namespaces used in document',
'simplexmliterator::hasChildren' => 'Checks whether the current element has sub elements',
'simplexmliterator::key' => 'Return current key',
'simplexmliterator::next' => 'Move to next element',
'SimpleXMLIterator::registerXPathNamespace' => 'Creates a prefix/ns context for the next XPath query',
'simplexmliterator::rewind' => 'Rewind to the first element',
'SimpleXMLIterator::saveXML' => 'Alias of SimpleXMLElement::asXML',
'simplexmliterator::valid' => 'Check whether the current element is valid',
'SimpleXMLIterator::xpath' => 'Runs XPath query on XML data',
'sin' => 'Sine',
'sinh' => 'Hyperbolic sine',
'sizeof' => 'Alias of count',
'sleep' => 'Delay execution',
'snmp2_get' => 'Fetch an SNMP object',
'snmp2_getnext' => 'Fetch the SNMP object which follows the given object id',
'snmp2_real_walk' => 'Return all objects including their respective object ID within the specified one',
'snmp2_set' => 'Set the value of an SNMP object',
'snmp2_walk' => 'Fetch all the SNMP objects from an agent',
'snmp3_get' => 'Fetch an SNMP object',
'snmp3_getnext' => 'Fetch the SNMP object which follows the given object id',
'snmp3_real_walk' => 'Return all objects including their respective object ID within the specified one',
'snmp3_set' => 'Set the value of an SNMP object',
'snmp3_walk' => 'Fetch all the SNMP objects from an agent',
'snmp::__construct' => 'Creates SNMP instance representing session to remote SNMP agent',
'snmp::close' => 'Close SNMP session',
'snmp::get' => 'Fetch an SNMP object',
'snmp::getErrno' => 'Get last error code',
'snmp::getError' => 'Get last error message',
'snmp::getnext' => 'Fetch an SNMP object which follows the given object id',
'snmp::set' => 'Set the value of an SNMP object',
'snmp::setSecurity' => 'Configures security-related SNMPv3 session parameters',
'snmp::walk' => 'Fetch SNMP object subtree',
'snmp_get_quick_print' => 'Fetches the current value of the UCD library\'s quick_print setting',
'snmp_get_valueretrieval' => 'Return the method how the SNMP values will be returned',
'snmp_read_mib' => 'Reads and parses a MIB file into the active MIB tree',
'snmp_set_enum_print' => 'Return all values that are enums with their enum value instead of the raw integer',
'snmp_set_oid_numeric_print' => 'Set the OID output format',
'snmp_set_oid_output_format' => 'Set the OID output format',
'snmp_set_quick_print' => 'Set the value of quick_print within the UCD SNMP library',
'snmp_set_valueretrieval' => 'Specify the method how the SNMP values will be returned',
'snmpget' => 'Fetch an SNMP object',
'snmpgetnext' => 'Fetch the SNMP object which follows the given object id',
'snmprealwalk' => 'Return all objects including their respective object ID within the specified one',
'snmpset' => 'Set the value of an SNMP object',
'snmpwalk' => 'Fetch all the SNMP objects from an agent',
'snmpwalkoid' => 'Query for a tree of information about a network entity',
'soapclient::__call' => 'Calls a SOAP function (deprecated)',
'soapclient::__construct' => 'SoapClient constructor',
'soapclient::__doRequest' => 'Performs a SOAP request',
'soapclient::__getCookies' => 'Get list of cookies',
'soapclient::__getFunctions' => 'Returns list of available SOAP functions',
'soapclient::__getLastRequest' => 'Returns last SOAP request',
'soapclient::__getLastRequestHeaders' => 'Returns the SOAP headers from the last request',
'soapclient::__getLastResponse' => 'Returns last SOAP response',
'soapclient::__getLastResponseHeaders' => 'Returns the SOAP headers from the last response',
'soapclient::__getTypes' => 'Returns a list of SOAP types',
'soapclient::__setCookie' => 'The __setCookie purpose',
'soapclient::__setLocation' => 'Sets the location of the Web service to use',
'soapclient::__setSoapHeaders' => 'Sets SOAP headers for subsequent calls',
'soapclient::__soapCall' => 'Calls a SOAP function',
'soapclient::SoapClient' => 'SoapClient constructor',
'SoapFault::__clone' => 'Clone the exception
Tries to clone the Exception, which results in Fatal error.',
'soapfault::__construct' => 'SoapFault constructor',
'soapfault::__toString' => 'Obtain a string representation of a SoapFault',
'SoapFault::getCode' => 'Gets the Exception code',
'SoapFault::getFile' => 'Gets the file in which the exception occurred',
'SoapFault::getLine' => 'Gets the line in which the exception occurred',
'SoapFault::getMessage' => 'Gets the Exception message',
'SoapFault::getPrevious' => 'Returns previous Exception',
'SoapFault::getTrace' => 'Gets the stack trace',
'SoapFault::getTraceAsString' => 'Gets the stack trace as a string',
'soapfault::SoapFault' => 'SoapFault constructor',
'soapheader::__construct' => 'SoapHeader constructor',
'soapheader::SoapHeader' => 'SoapHeader constructor',
'soapparam::__construct' => 'SoapParam constructor',
'soapparam::SoapParam' => 'SoapParam constructor',
'soapserver::__construct' => 'SoapServer constructor',
'soapserver::addFunction' => 'Adds one or more functions to handle SOAP requests',
'soapserver::addSoapHeader' => 'Add a SOAP header to the response',
'soapserver::fault' => 'Issue SoapServer fault indicating an error',
'soapserver::getFunctions' => 'Returns list of defined functions',
'soapserver::handle' => 'Handles a SOAP request',
'soapserver::setClass' => 'Sets the class which handles SOAP requests',
'soapserver::setObject' => 'Sets the object which will be used to handle SOAP requests',
'soapserver::setPersistence' => 'Sets SoapServer persistence mode',
'soapserver::SoapServer' => 'SoapServer constructor',
'soapvar::__construct' => 'SoapVar constructor',
'soapvar::SoapVar' => 'SoapVar constructor',
'socket_accept' => 'Accepts a connection on a socket',
'socket_addrinfo_bind' => 'Create and bind to a socket from a given addrinfo',
'socket_addrinfo_connect' => 'Create and connect to a socket from a given addrinfo',
'socket_addrinfo_explain' => 'Get information about addrinfo',
'socket_addrinfo_lookup' => 'Get array with contents of getaddrinfo about the given hostname',
'socket_bind' => 'Binds a name to a socket',
'socket_clear_error' => 'Clears the error on the socket or the last error code',
'socket_close' => 'Closes a socket resource',
'socket_cmsg_space' => 'Calculate message buffer size',
'socket_connect' => 'Initiates a connection on a socket',
'socket_create' => 'Create a socket (endpoint for communication)',
'socket_create_listen' => 'Opens a socket on port to accept connections',
'socket_create_pair' => 'Creates a pair of indistinguishable sockets and stores them in an array',
'socket_export_stream' => 'Export a socket extension resource into a stream that encapsulates a socket',
'socket_get_option' => 'Gets socket options for the socket',
'socket_get_status' => 'Alias of stream_get_meta_data',
'socket_getopt' => 'Alias of socket_get_option',
'socket_getpeername' => 'Queries the remote side of the given socket which may either result in host/port or in a Unix filesystem path, dependent on its type',
'socket_getsockname' => 'Queries the local side of the given socket which may either result in host/port or in a Unix filesystem path, dependent on its type',
'socket_import_stream' => 'Import a stream',
'socket_last_error' => 'Returns the last error on the socket',
'socket_listen' => 'Listens for a connection on a socket',
'socket_read' => 'Reads a maximum of length bytes from a socket',
'socket_recv' => 'Receives data from a connected socket',
'socket_recvfrom' => 'Receives data from a socket whether or not it is connection-oriented',
'socket_recvmsg' => 'Read a message',
'socket_select' => 'Runs the select() system call on the given arrays of sockets with a specified timeout',
'socket_send' => 'Sends data to a connected socket',
'socket_sendmsg' => 'Send a message',
'socket_sendto' => 'Sends a message to a socket, whether it is connected or not',
'socket_set_block' => 'Sets blocking mode on a socket resource',
'socket_set_blocking' => 'Alias of stream_set_blocking',
'socket_set_nonblock' => 'Sets nonblocking mode for file descriptor fd',
'socket_set_option' => 'Sets socket options for the socket',
'socket_set_timeout' => 'Alias of stream_set_timeout',
'socket_setopt' => 'Alias of socket_set_option',
'socket_shutdown' => 'Shuts down a socket for receiving, sending, or both',
'socket_strerror' => 'Return a string describing a socket error',
'socket_write' => 'Write to a socket',
'socket_wsaprotocol_info_export' => 'Exports the WSAPROTOCOL_INFO Structure',
'socket_wsaprotocol_info_import' => 'Imports a Socket from another Process',
'socket_wsaprotocol_info_release' => 'Releases an exported WSAPROTOCOL_INFO Structure',
'Sodium\add' => 'Add the right operand to the left',
'Sodium\bin2hex' => 'Convert to hex without side-channels',
'Sodium\compare' => 'Compare two strings in constant time',
'Sodium\crypto_aead_aes256gcm_decrypt' => 'Authenticated Encryption with Associated Data (decrypt)
AES-256-GCM',
'Sodium\crypto_aead_aes256gcm_encrypt' => 'Authenticated Encryption with Associated Data (encrypt)
AES-256-GCM',
'Sodium\crypto_aead_aes256gcm_is_available' => 'Can you access AES-256-GCM? This is only available if you have supported
hardware.',
'Sodium\crypto_aead_chacha20poly1305_decrypt' => 'Authenticated Encryption with Associated Data (decrypt)
ChaCha20 + Poly1305',
'Sodium\crypto_aead_chacha20poly1305_encrypt' => 'Authenticated Encryption with Associated Data (encrypt)
ChaCha20 + Poly1305',
'Sodium\crypto_auth' => 'Secret-key message authentication
HMAC SHA-512/256',
'Sodium\crypto_auth_verify' => 'Secret-key message verification
HMAC SHA-512/256',
'Sodium\crypto_box' => 'Public-key authenticated encryption (encrypt)
X25519 + Xsalsa20 + Poly1305',
'Sodium\crypto_box_keypair' => 'Generate an X25519 keypair for use with the crypto_box API',
'Sodium\crypto_box_keypair_from_secretkey_and_publickey' => 'Create an X25519 keypair from an X25519 secret key and X25519 public key',
'Sodium\crypto_box_open' => 'Public-key authenticated encryption (decrypt)
X25519 + Xsalsa20 + Poly1305',
'Sodium\crypto_box_publickey' => 'Get an X25519 public key from an X25519 keypair',
'Sodium\crypto_box_publickey_from_secretkey' => 'Derive an X25519 public key from an X25519 secret key',
'Sodium\crypto_box_seal' => 'Anonymous public-key encryption (encrypt)
X25519 + Xsalsa20 + Poly1305 + BLAKE2b',
'Sodium\crypto_box_seal_open' => 'Anonymous public-key encryption (decrypt)
X25519 + Xsalsa20 + Poly1305 + BLAKE2b',
'Sodium\crypto_box_secretkey' => 'Extract the X25519 secret key from an X25519 keypair',
'Sodium\crypto_box_seed_keypair' => 'Derive an X25519 keypair for use with the crypto_box API from a seed',
'Sodium\crypto_generichash' => 'Fast and secure cryptographic hash',
'Sodium\crypto_generichash_final' => 'Get the final hash
BLAKE2b',
'Sodium\crypto_generichash_init' => 'Create a new hash state (e.g. to use for streams)
BLAKE2b',
'Sodium\crypto_generichash_update' => 'Update the hash state with some data
BLAKE2b',
'Sodium\crypto_kx' => 'Elliptic Curve Diffie Hellman Key Exchange
X25519',
'Sodium\crypto_pwhash' => 'Secure password-based key derivation function
Argon2i',
'Sodium\crypto_pwhash_scryptsalsa208sha256' => 'Secure password-based key derivation function
Scrypt',
'Sodium\crypto_pwhash_scryptsalsa208sha256_str' => 'Get a formatted password hash (for storage)
Scrypt',
'Sodium\crypto_pwhash_scryptsalsa208sha256_str_verify' => 'Verify a password against a hash
Scrypt',
'Sodium\crypto_pwhash_str' => 'Get a formatted password hash (for storage)
Argon2i',
'Sodium\crypto_pwhash_str_verify' => 'Verify a password against a hash
Argon2i',
'Sodium\crypto_scalarmult' => 'Elliptic Curve Diffie Hellman over Curve25519
X25519',
'Sodium\crypto_scalarmult_base' => 'Scalar multiplication of the base point and your key',
'Sodium\crypto_secretbox' => 'Authenticated secret-key encryption (encrypt)
Xsals20 + Poly1305',
'Sodium\crypto_secretbox_open' => 'Authenticated secret-key encryption (decrypt)
Xsals20 + Poly1305',
'Sodium\crypto_shorthash' => 'A short keyed hash suitable for data structures
SipHash-2-4',
'Sodium\crypto_sign' => 'Digital Signature
Ed25519',
'Sodium\crypto_sign_detached' => 'Digital Signature (detached)
Ed25519',
'Sodium\crypto_sign_ed25519_pk_to_curve25519' => 'Convert an Ed25519 public key to an X25519 public key',
'Sodium\crypto_sign_ed25519_sk_to_curve25519' => 'Convert an Ed25519 secret key to an X25519 secret key',
'Sodium\crypto_sign_keypair' => 'Generate an Ed25519 keypair for use with the crypto_sign API',
'Sodium\crypto_sign_keypair_from_secretkey_and_publickey' => 'Create an Ed25519 keypair from an Ed25519 secret key + Ed25519 public key',
'Sodium\crypto_sign_open' => 'Verify a signed message and return the plaintext',
'Sodium\crypto_sign_publickey' => 'Get the public key from an Ed25519 keypair',
'Sodium\crypto_sign_publickey_from_secretkey' => 'Derive an Ed25519 public key from an Ed25519 secret key',
'Sodium\crypto_sign_secretkey' => 'Get the secret key from an Ed25519 keypair',
'Sodium\crypto_sign_seed_keypair' => 'Derive an Ed25519 keypair for use with the crypto_sign API from a seed',
'Sodium\crypto_sign_verify_detached' => 'Verify a detached signature',
'Sodium\crypto_stream' => 'Create a keystream from a key and nonce
Xsalsa20',
'Sodium\crypto_stream_xor' => 'Encrypt a message using a stream cipher
Xsalsa20',
'Sodium\hex2bin' => 'Convert from hex without side-channels',
'Sodium\increment' => 'Increment a string in little-endian',
'Sodium\library_version_major' => 'Get the true major version of libsodium',
'Sodium\library_version_minor' => 'Get the true minor version of libsodium',
'Sodium\memcmp' => 'Compare two strings in constant time',
'Sodium\memzero' => 'Wipe a buffer',
'Sodium\randombytes_buf' => 'Generate a string of random bytes
/dev/urandom',
'Sodium\randombytes_random16' => 'Generate a 16-bit integer
/dev/urandom',
'Sodium\randombytes_uniform' => 'Generate an unbiased random integer between 0 and a specified value
/dev/urandom',
'Sodium\version_string' => 'Get the version string',
'sodium_add' => 'Add large numbers',
'sodium_bin2hex' => 'Encode to hexadecimal',
'sodium_compare' => 'Compare large numbers',
'sodium_crypto_aead_aes256gcm_decrypt' => 'Decrypt in combined mode with precalculation',
'sodium_crypto_aead_aes256gcm_encrypt' => 'Encrypt in combined mode with precalculation',
'sodium_crypto_aead_aes256gcm_is_available' => 'Check if hardware supports AES256-GCM',
'sodium_crypto_aead_aes256gcm_keygen' => 'Get random bytes for key',
'sodium_crypto_aead_chacha20poly1305_decrypt' => 'Verify that the ciphertext includes a valid tag',
'sodium_crypto_aead_chacha20poly1305_encrypt' => 'Encrypt a message',
'sodium_crypto_aead_chacha20poly1305_ietf_decrypt' => 'Verify that the ciphertext includes a valid tag',
'sodium_crypto_aead_chacha20poly1305_ietf_encrypt' => 'Encrypt a message',
'sodium_crypto_aead_chacha20poly1305_ietf_keygen' => 'Get random bytes for key',
'sodium_crypto_aead_chacha20poly1305_ke